/* query.c generated by valac 0.56.0, the Vala compiler
 * generated from query.vala, do not modify */

/*
 * Copyright (C) 2011, 2015 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include "folks/folks.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

enum  {
	FOLKS_QUERY_0_PROPERTY,
	FOLKS_QUERY_MATCH_FIELDS_PROPERTY,
	FOLKS_QUERY_NUM_PROPERTIES
};
static GParamSpec* folks_query_properties[FOLKS_QUERY_NUM_PROPERTIES];

struct _FolksQueryPrivate {
	gchar** _match_fields;
	gint _match_fields_length1;
	gint __match_fields_size_;
};

static gint FolksQuery_private_offset;
static gpointer folks_query_parent_class = NULL;

static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static guint folks_query_real_is_match (FolksQuery* self,
                                 FolksIndividual* individual);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
static void folks_query_finalize (GObject * obj);
static GType folks_query_get_type_once (void);
static void _vala_folks_query_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_folks_query_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const gchar* FOLKS_QUERY_MATCH_FIELDS_NAMES[4] = {"alias", "full-name", "nickname", "structured-name"};
const gchar* FOLKS_QUERY_MATCH_FIELDS_ADDRESSES[6] = {"email-addresses", "im-addresses", "phone-numbers", "postal-addresses", "web-service-addresses", "urls"};
const gchar* FOLKS_QUERY_MATCH_FIELDS_MISC[3] = {"groups", "roles", "notes"};

static inline gpointer
folks_query_get_instance_private (FolksQuery* self)
{
	return G_STRUCT_MEMBER_P (self, FolksQuery_private_offset);
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

/**
   * Determines whether a given {@link Individual} matches this query.
   *
   * This returns a match strength, which is on an arbitrary scale which is not
   * part of libfolks’ public API. These strengths should not be stored by user
   * applications, or examined numerically — they should only be used for
   * pairwise strength comparisons.
   *
   * This function is intended to be used in the {@link SearchView}
   * implementation only. Use {@link SearchView.individuals} to retrieve search
   * results.
   *
   * @param individual an {@link Individual} to match against
   * @return a positive integer if the individual matches this query, or zero
   *   if they do not match; higher numbers indicate a better match
   * @since 0.11.0
   */
static guint
folks_query_real_is_match (FolksQuery* self,
                           FolksIndividual* individual)
{
	guint _tmp0_ = 0U;
	g_critical ("Type `%s' does not implement abstract method `folks_query_is_match'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

guint
folks_query_is_match (FolksQuery* self,
                      FolksIndividual* individual)
{
	FolksQueryClass* _klass_;
	g_return_val_if_fail (self != NULL, 0U);
	_klass_ = FOLKS_QUERY_GET_CLASS (self);
	if (_klass_->is_match) {
		return _klass_->is_match (self, individual);
	}
	return 0U;
}

FolksQuery*
folks_query_construct (GType object_type)
{
	FolksQuery * self = NULL;
	self = (FolksQuery*) g_object_new (object_type, NULL);
	return self;
}

gchar**
folks_query_get_match_fields (FolksQuery* self,
                              gint* result_length1)
{
	FolksQueryClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_QUERY_GET_CLASS (self);
	if (_klass_->get_match_fields) {
		return _klass_->get_match_fields (self, result_length1);
	}
	return NULL;
}

static gchar**
folks_query_real_get_match_fields (FolksQuery* base,
                                   gint* result_length1)
{
	gchar** result;
	FolksQuery* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = base;
	_tmp0_ = self->priv->_match_fields;
	_tmp0__length1 = self->priv->_match_fields_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static void
folks_query_set_match_fields (FolksQuery* self,
                              gchar** value,
                              gint value_length1)
{
	FolksQueryClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FOLKS_QUERY_GET_CLASS (self);
	if (_klass_->set_match_fields) {
		_klass_->set_match_fields (self, value, value_length1);
	}
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
folks_query_real_set_match_fields (FolksQuery* base,
                                   gchar** value,
                                   gint value_length1)
{
	FolksQuery* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = base;
	_tmp0_ = (value != NULL) ? _vala_array_dup5 (value, value_length1) : value;
	_tmp0__length1 = value_length1;
	self->priv->_match_fields = (_vala_array_free (self->priv->_match_fields, self->priv->_match_fields_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_match_fields = _tmp0_;
	self->priv->_match_fields_length1 = _tmp0__length1;
	self->priv->__match_fields_size_ = self->priv->_match_fields_length1;
	g_object_notify_by_pspec ((GObject *) self, folks_query_properties[FOLKS_QUERY_MATCH_FIELDS_PROPERTY]);
}

static void
folks_query_class_init (FolksQueryClass * klass,
                        gpointer klass_data)
{
	folks_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksQuery_private_offset);
	((FolksQueryClass *) klass)->is_match = (guint (*) (FolksQuery*, FolksIndividual*)) folks_query_real_is_match;
	FOLKS_QUERY_CLASS (klass)->get_match_fields = folks_query_real_get_match_fields;
	FOLKS_QUERY_CLASS (klass)->set_match_fields = folks_query_real_set_match_fields;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_query_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_query_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_query_finalize;
	/**
	   * The names of the fields to match within
	   *
	   * The names of valid fields are available via
	   * {@link PersonaStore.detail_key}.
	   *
	   * The ordering of the fields determines the order they are checked for
	   * matches, which can have performance implications (these should ideally be
	   * ordered from most- to least-likely to match).
	   *
	   * Also note that more fields (particularly rarely-matched fields) will
	   * negatively impact performance, so only include important fields.
	   *
	   * Default value is {@link Query.MATCH_FIELDS_NAMES}.
	   *
	   * @since 0.11.0
	   * @see PersonaDetail
	   * @see PersonaStore.detail_key
	   * @see Query.MATCH_FIELDS_NAMES
	   * @see Query.MATCH_FIELDS_ADDRESSES
	   * @see Query.MATCH_FIELDS_MISC
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_QUERY_MATCH_FIELDS_PROPERTY, folks_query_properties[FOLKS_QUERY_MATCH_FIELDS_PROPERTY] = g_param_spec_boxed ("match-fields", "match-fields", "match-fields", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
folks_query_instance_init (FolksQuery * self,
                           gpointer klass)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	self->priv = folks_query_get_instance_private (self);
	_tmp0_ = _vala_array_dup4 (FOLKS_QUERY_MATCH_FIELDS_NAMES, G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES));
	_tmp0__length1 = G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES);
	self->priv->_match_fields = _tmp0_;
	self->priv->_match_fields_length1 = _tmp0__length1;
	self->priv->__match_fields_size_ = self->priv->_match_fields_length1;
}

static void
folks_query_finalize (GObject * obj)
{
	FolksQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_QUERY, FolksQuery);
	self->priv->_match_fields = (_vala_array_free (self->priv->_match_fields, self->priv->_match_fields_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (folks_query_parent_class)->finalize (obj);
}

/**
 * A contact query.
 *
 * If any properties of the query change such that matches may change, the
 * {@link GLib.Object.notify} signal will be emitted, potentially without a
 * detail string. Views which are using this query should re-evaluate their
 * matches on receiving this signal.
 *
 * @see SearchView
 * @since 0.11.0
 */
static GType
folks_query_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksQuery), 0, (GInstanceInitFunc) folks_query_instance_init, NULL };
	GType folks_query_type_id;
	folks_query_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksQuery", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	FolksQuery_private_offset = g_type_add_instance_private (folks_query_type_id, sizeof (FolksQueryPrivate));
	return folks_query_type_id;
}

GType
folks_query_get_type (void)
{
	static volatile gsize folks_query_type_id__once = 0;
	if (g_once_init_enter (&folks_query_type_id__once)) {
		GType folks_query_type_id;
		folks_query_type_id = folks_query_get_type_once ();
		g_once_init_leave (&folks_query_type_id__once, folks_query_type_id);
	}
	return folks_query_type_id__once;
}

static void
_vala_folks_query_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	FolksQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_QUERY, FolksQuery);
	switch (property_id) {
		case FOLKS_QUERY_MATCH_FIELDS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, folks_query_get_match_fields (self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_query_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	FolksQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_QUERY, FolksQuery);
	switch (property_id) {
		case FOLKS_QUERY_MATCH_FIELDS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			folks_query_set_match_fields (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

