/****************************************************************************
**
** Copyright (C) 2017 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#pragma once

#include <actioninterface.h>

#include <componentcore_constants.h>

#include <QWidgetAction>

#include <functional>
#include <memory>

namespace QmlDesigner {

class AbstractView;

struct StyleWidgetEntry {
    QString displayName;

    QString styleName;
    QString styleTheme;

    bool operator==(const StyleWidgetEntry &entry) const {
        if (displayName != entry.displayName)
            return false;
        if (styleName != entry.styleName)
            return false;
        if (styleTheme != entry.styleTheme)
            return false;

        return true;
    };
};

class ChangeStyleWidgetAction : public QWidgetAction
{
    Q_OBJECT

public:
    explicit ChangeStyleWidgetAction(QObject *parent = nullptr);
    void handleModelUpdate(const QString &style);

    const QList<StyleWidgetEntry> styleItems() const;

public slots:
    void changeStyle(const QString &style);

protected:
    QWidget *createWidget(QWidget *parent) override;

signals:
    void modelUpdated(const QString &style);

public:
    QString qmlFileName;
    QPointer<AbstractView> view;

    QList<StyleWidgetEntry> items;
};

class ChangeStyleAction : public ActionInterface
{
public:
    ChangeStyleAction() :
        m_action(new ChangeStyleWidgetAction())
    {}

    QAction *action() const override { return m_action.get(); }
    QByteArray category() const override  { return ComponentCoreConstants::genericToolBarCategory; }
    QByteArray menuId() const override  { return QByteArray(); }
    int priority() const override { return 50; }
    Type type() const override { return ToolBarAction; }
    void currentContextChanged(const SelectionContext &) override;

private:
    std::unique_ptr<ChangeStyleWidgetAction> m_action;
};


} // namespace QmlDesigner
