/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.jsp.el;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotWritableException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.JspContext;
import jakarta.servlet.jsp.PageContext;
import java.beans.FeatureDescriptor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ImplicitObjectELResolver
extends ELResolver {
    private static final String[] SCOPE_NAMES = new String[]{"applicationScope", "cookie", "header", "headerValues", "initParam", "pageContext", "pageScope", "param", "paramValues", "requestScope", "sessionScope"};
    private static final int APPLICATIONSCOPE = 0;
    private static final int COOKIE = 1;
    private static final int HEADER = 2;
    private static final int HEADERVALUES = 3;
    private static final int INITPARAM = 4;
    private static final int PAGECONTEXT = 5;
    private static final int PAGESCOPE = 6;
    private static final int PARAM = 7;
    private static final int PARAM_VALUES = 8;
    private static final int REQUEST_SCOPE = 9;
    private static final int SESSION_SCOPE = 10;

    public Object getValue(ELContext eLContext, Object object, Object object2) {
        int n;
        Objects.requireNonNull(eLContext);
        if (object == null && object2 != null && (n = Arrays.binarySearch(SCOPE_NAMES, object2.toString())) >= 0) {
            PageContext pageContext = (PageContext)eLContext.getContext(JspContext.class);
            eLContext.setPropertyResolved(object, object2);
            switch (n) {
                case 0: {
                    return ScopeManager.get(pageContext).getApplicationScope();
                }
                case 1: {
                    return ScopeManager.get(pageContext).getCookie();
                }
                case 2: {
                    return ScopeManager.get(pageContext).getHeader();
                }
                case 3: {
                    return ScopeManager.get(pageContext).getHeaderValues();
                }
                case 4: {
                    return ScopeManager.get(pageContext).getInitParam();
                }
                case 5: {
                    return ScopeManager.get(pageContext).getPageContext();
                }
                case 6: {
                    return ScopeManager.get(pageContext).getPageScope();
                }
                case 7: {
                    return ScopeManager.get(pageContext).getParam();
                }
                case 8: {
                    return ScopeManager.get(pageContext).getParamValues();
                }
                case 9: {
                    return ScopeManager.get(pageContext).getRequestScope();
                }
                case 10: {
                    return ScopeManager.get(pageContext).getSessionScope();
                }
            }
        }
        return null;
    }

    public Class<?> getType(ELContext eLContext, Object object, Object object2) {
        int n;
        Objects.requireNonNull(eLContext);
        if (object == null && object2 != null && (n = Arrays.binarySearch(SCOPE_NAMES, object2.toString())) >= 0) {
            eLContext.setPropertyResolved(object, object2);
        }
        return null;
    }

    public void setValue(ELContext eLContext, Object object, Object object2, Object object3) {
        int n;
        Objects.requireNonNull(eLContext);
        if (object == null && object2 != null && (n = Arrays.binarySearch(SCOPE_NAMES, object2.toString())) >= 0) {
            eLContext.setPropertyResolved(object, object2);
            throw new PropertyNotWritableException();
        }
    }

    public boolean isReadOnly(ELContext eLContext, Object object, Object object2) {
        int n;
        Objects.requireNonNull(eLContext);
        if (object == null && object2 != null && (n = Arrays.binarySearch(SCOPE_NAMES, object2.toString())) >= 0) {
            eLContext.setPropertyResolved(object, object2);
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true, since="JSP 3.1")
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext eLContext, Object object) {
        ArrayList<FeatureDescriptor> arrayList = new ArrayList<FeatureDescriptor>(SCOPE_NAMES.length);
        for (String string : SCOPE_NAMES) {
            FeatureDescriptor featureDescriptor = new FeatureDescriptor();
            featureDescriptor.setDisplayName(string);
            featureDescriptor.setExpert(false);
            featureDescriptor.setHidden(false);
            featureDescriptor.setName(string);
            featureDescriptor.setPreferred(true);
            featureDescriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
            featureDescriptor.setValue("type", String.class);
            arrayList.add(featureDescriptor);
        }
        return arrayList.iterator();
    }

    public Class<String> getCommonPropertyType(ELContext eLContext, Object object) {
        if (object == null) {
            return String.class;
        }
        return null;
    }

    private static abstract class ScopeMap<V>
    extends AbstractMap<String, V> {
        private ScopeMap() {
        }

        protected abstract Enumeration<String> getAttributeNames();

        protected abstract V getAttribute(String var1);

        protected void removeAttribute(String string) {
            throw new UnsupportedOperationException();
        }

        protected void setAttribute(String string, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Set<Map.Entry<String, V>> entrySet() {
            Enumeration<String> enumeration = this.getAttributeNames();
            HashSet<Map.Entry<String, V>> hashSet = new HashSet<Map.Entry<String, V>>();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    hashSet.add(new ScopeEntry(enumeration.nextElement()));
                }
            }
            return hashSet;
        }

        @Override
        public final int size() {
            int n = 0;
            Enumeration<String> enumeration = this.getAttributeNames();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    enumeration.nextElement();
                    ++n;
                }
            }
            return n;
        }

        @Override
        public final boolean containsKey(Object object) {
            if (object == null) {
                return false;
            }
            Enumeration<String> enumeration = this.getAttributeNames();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    if (!object.equals(enumeration.nextElement())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public final V get(Object object) {
            if (object != null) {
                return this.getAttribute((String)object);
            }
            return null;
        }

        @Override
        public final V put(String string, V v) {
            Objects.requireNonNull(string);
            if (v == null) {
                this.removeAttribute(string);
            } else {
                this.setAttribute(string, v);
            }
            return null;
        }

        @Override
        public final V remove(Object object) {
            Objects.requireNonNull(object);
            this.removeAttribute((String)object);
            return null;
        }

        private class ScopeEntry
        implements Map.Entry<String, V> {
            private final String key;

            public ScopeEntry(String string) {
                this.key = string;
            }

            @Override
            public String getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return ScopeMap.this.getAttribute(this.key);
            }

            @Override
            public V setValue(Object object) {
                if (object == null) {
                    ScopeMap.this.removeAttribute(this.key);
                } else {
                    ScopeMap.this.setAttribute(this.key, object);
                }
                return null;
            }

            @Override
            public boolean equals(Object object) {
                return object != null && this.hashCode() == object.hashCode();
            }

            @Override
            public int hashCode() {
                return this.key.hashCode();
            }
        }
    }

    private static class ScopeManager {
        private static final String MNGR_KEY = ScopeManager.class.getName();
        private final PageContext page;
        private Map<String, Object> applicationScope;
        private Map<String, Cookie> cookie;
        private Map<String, String> header;
        private Map<String, String[]> headerValues;
        private Map<String, String> initParam;
        private Map<String, Object> pageScope;
        private Map<String, String> param;
        private Map<String, String[]> paramValues;
        private Map<String, Object> requestScope;
        private Map<String, Object> sessionScope;

        public ScopeManager(PageContext pageContext) {
            this.page = pageContext;
        }

        public static ScopeManager get(PageContext pageContext) {
            ScopeManager scopeManager = (ScopeManager)pageContext.getAttribute(MNGR_KEY);
            if (scopeManager == null) {
                scopeManager = new ScopeManager(pageContext);
                pageContext.setAttribute(MNGR_KEY, scopeManager);
            }
            return scopeManager;
        }

        public Map<String, Object> getApplicationScope() {
            if (this.applicationScope == null) {
                this.applicationScope = new ScopeMap<Object>(){

                    @Override
                    protected void setAttribute(String string, Object object) {
                        page.getServletContext().setAttribute(string, object);
                    }

                    @Override
                    protected void removeAttribute(String string) {
                        page.getServletContext().removeAttribute(string);
                    }

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        return page.getServletContext().getAttributeNames();
                    }

                    @Override
                    protected Object getAttribute(String string) {
                        return page.getServletContext().getAttribute(string);
                    }
                };
            }
            return this.applicationScope;
        }

        public Map<String, Cookie> getCookie() {
            if (this.cookie == null) {
                this.cookie = new ScopeMap<Cookie>(){

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        Cookie[] cookieArray = ((HttpServletRequest)page.getRequest()).getCookies();
                        if (cookieArray != null) {
                            ArrayList<String> arrayList = new ArrayList<String>(cookieArray.length);
                            for (Cookie cookie : cookieArray) {
                                arrayList.add(cookie.getName());
                            }
                            return Collections.enumeration(arrayList);
                        }
                        return null;
                    }

                    @Override
                    protected Cookie getAttribute(String string) {
                        Cookie[] cookieArray = ((HttpServletRequest)page.getRequest()).getCookies();
                        if (cookieArray != null) {
                            for (Cookie cookie : cookieArray) {
                                if (!string.equals(cookie.getName())) continue;
                                return cookie;
                            }
                        }
                        return null;
                    }
                };
            }
            return this.cookie;
        }

        public Map<String, String> getHeader() {
            if (this.header == null) {
                this.header = new ScopeMap<String>(){

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        return ((HttpServletRequest)page.getRequest()).getHeaderNames();
                    }

                    @Override
                    protected String getAttribute(String string) {
                        return ((HttpServletRequest)page.getRequest()).getHeader(string);
                    }
                };
            }
            return this.header;
        }

        public Map<String, String[]> getHeaderValues() {
            if (this.headerValues == null) {
                this.headerValues = new ScopeMap<String[]>(){

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        return ((HttpServletRequest)page.getRequest()).getHeaderNames();
                    }

                    @Override
                    protected String[] getAttribute(String string) {
                        Enumeration enumeration = ((HttpServletRequest)page.getRequest()).getHeaders(string);
                        if (enumeration != null) {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            while (enumeration.hasMoreElements()) {
                                arrayList.add((String)enumeration.nextElement());
                            }
                            return arrayList.toArray(new String[0]);
                        }
                        return null;
                    }
                };
            }
            return this.headerValues;
        }

        public Map<String, String> getInitParam() {
            if (this.initParam == null) {
                this.initParam = new ScopeMap<String>(){

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        return page.getServletContext().getInitParameterNames();
                    }

                    @Override
                    protected String getAttribute(String string) {
                        return page.getServletContext().getInitParameter(string);
                    }
                };
            }
            return this.initParam;
        }

        public PageContext getPageContext() {
            return this.page;
        }

        public Map<String, Object> getPageScope() {
            if (this.pageScope == null) {
                this.pageScope = new ScopeMap<Object>(){

                    @Override
                    protected void setAttribute(String string, Object object) {
                        page.setAttribute(string, object);
                    }

                    @Override
                    protected void removeAttribute(String string) {
                        page.removeAttribute(string);
                    }

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        return page.getAttributeNamesInScope(1);
                    }

                    @Override
                    protected Object getAttribute(String string) {
                        return page.getAttribute(string);
                    }
                };
            }
            return this.pageScope;
        }

        public Map<String, String> getParam() {
            if (this.param == null) {
                this.param = new ScopeMap<String>(){

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        return page.getRequest().getParameterNames();
                    }

                    @Override
                    protected String getAttribute(String string) {
                        return page.getRequest().getParameter(string);
                    }
                };
            }
            return this.param;
        }

        public Map<String, String[]> getParamValues() {
            if (this.paramValues == null) {
                this.paramValues = new ScopeMap<String[]>(){

                    @Override
                    protected String[] getAttribute(String string) {
                        return page.getRequest().getParameterValues(string);
                    }

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        return page.getRequest().getParameterNames();
                    }
                };
            }
            return this.paramValues;
        }

        public Map<String, Object> getRequestScope() {
            if (this.requestScope == null) {
                this.requestScope = new ScopeMap<Object>(){

                    @Override
                    protected void setAttribute(String string, Object object) {
                        page.getRequest().setAttribute(string, object);
                    }

                    @Override
                    protected void removeAttribute(String string) {
                        page.getRequest().removeAttribute(string);
                    }

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        return page.getRequest().getAttributeNames();
                    }

                    @Override
                    protected Object getAttribute(String string) {
                        return page.getRequest().getAttribute(string);
                    }
                };
            }
            return this.requestScope;
        }

        public Map<String, Object> getSessionScope() {
            if (this.sessionScope == null) {
                this.sessionScope = new ScopeMap<Object>(){

                    @Override
                    protected void setAttribute(String string, Object object) {
                        ((HttpServletRequest)page.getRequest()).getSession().setAttribute(string, object);
                    }

                    @Override
                    protected void removeAttribute(String string) {
                        HttpSession httpSession = page.getSession();
                        if (httpSession != null) {
                            httpSession.removeAttribute(string);
                        }
                    }

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        HttpSession httpSession = page.getSession();
                        if (httpSession != null) {
                            return httpSession.getAttributeNames();
                        }
                        return null;
                    }

                    @Override
                    protected Object getAttribute(String string) {
                        HttpSession httpSession = page.getSession();
                        if (httpSession != null) {
                            return httpSession.getAttribute(string);
                        }
                        return null;
                    }
                };
            }
            return this.sessionScope;
        }
    }
}

