/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.io.PrintWriter;
import java.util.Deque;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectState;
import org.apache.tomcat.dbcp.pool2.TrackedUse;
import org.apache.tomcat.dbcp.pool2.impl.CallStack;
import org.apache.tomcat.dbcp.pool2.impl.CallStackUtils;
import org.apache.tomcat.dbcp.pool2.impl.NoOpCallStack;

public class DefaultPooledObject<T>
implements PooledObject<T> {
    private final T object;
    private PooledObjectState state = PooledObjectState.IDLE;
    private final long createTimeMillis;
    private volatile long lastBorrowTimeMillis = this.createTimeMillis = System.currentTimeMillis();
    private volatile long lastUseTimeMillis = this.createTimeMillis;
    private volatile long lastReturnTimeMillis = this.createTimeMillis;
    private volatile boolean logAbandoned = false;
    private volatile CallStack borrowedBy = NoOpCallStack.INSTANCE;
    private volatile CallStack usedBy = NoOpCallStack.INSTANCE;
    private volatile long borrowedCount = 0L;

    public DefaultPooledObject(T t) {
        this.object = t;
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public long getCreateTime() {
        return this.createTimeMillis;
    }

    @Override
    public long getActiveTimeMillis() {
        long l = this.lastReturnTimeMillis;
        long l2 = this.lastBorrowTimeMillis;
        if (l > l2) {
            return l - l2;
        }
        return System.currentTimeMillis() - l2;
    }

    @Override
    public long getIdleTimeMillis() {
        long l = System.currentTimeMillis() - this.lastReturnTimeMillis;
        return l >= 0L ? l : 0L;
    }

    @Override
    public long getLastBorrowTime() {
        return this.lastBorrowTimeMillis;
    }

    @Override
    public long getLastReturnTime() {
        return this.lastReturnTimeMillis;
    }

    @Override
    public long getBorrowedCount() {
        return this.borrowedCount;
    }

    @Override
    public long getLastUsedTime() {
        if (this.object instanceof TrackedUse) {
            return Math.max(((TrackedUse)this.object).getLastUsed(), this.lastUseTimeMillis);
        }
        return this.lastUseTimeMillis;
    }

    @Override
    public int compareTo(PooledObject<T> pooledObject) {
        long l = this.getLastReturnTime() - pooledObject.getLastReturnTime();
        if (l == 0L) {
            return System.identityHashCode(this) - System.identityHashCode(pooledObject);
        }
        return (int)Math.min(Math.max(l, Integer.MIN_VALUE), Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Object: ");
        stringBuilder.append(this.object.toString());
        stringBuilder.append(", State: ");
        DefaultPooledObject defaultPooledObject = this;
        synchronized (defaultPooledObject) {
            stringBuilder.append(this.state.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public synchronized boolean startEvictionTest() {
        if (this.state == PooledObjectState.IDLE) {
            this.state = PooledObjectState.EVICTION;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean endEvictionTest(Deque<PooledObject<T>> deque) {
        if (this.state == PooledObjectState.EVICTION) {
            this.state = PooledObjectState.IDLE;
            return true;
        }
        if (this.state == PooledObjectState.EVICTION_RETURN_TO_HEAD) {
            this.state = PooledObjectState.IDLE;
            if (!deque.offerFirst(this)) {
                // empty if block
            }
        }
        return false;
    }

    @Override
    public synchronized boolean allocate() {
        if (this.state == PooledObjectState.IDLE) {
            this.state = PooledObjectState.ALLOCATED;
            this.lastUseTimeMillis = this.lastBorrowTimeMillis = System.currentTimeMillis();
            ++this.borrowedCount;
            if (this.logAbandoned) {
                this.borrowedBy.fillInStackTrace();
            }
            return true;
        }
        if (this.state == PooledObjectState.EVICTION) {
            this.state = PooledObjectState.EVICTION_RETURN_TO_HEAD;
            return false;
        }
        return false;
    }

    @Override
    public synchronized boolean deallocate() {
        if (this.state == PooledObjectState.ALLOCATED || this.state == PooledObjectState.RETURNING) {
            this.state = PooledObjectState.IDLE;
            this.lastReturnTimeMillis = System.currentTimeMillis();
            this.borrowedBy.clear();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void invalidate() {
        this.state = PooledObjectState.INVALID;
    }

    @Override
    public void use() {
        this.lastUseTimeMillis = System.currentTimeMillis();
        this.usedBy.fillInStackTrace();
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        boolean bl = this.borrowedBy.printStackTrace(printWriter);
        if (bl |= this.usedBy.printStackTrace(printWriter)) {
            printWriter.flush();
        }
    }

    @Override
    public synchronized PooledObjectState getState() {
        return this.state;
    }

    @Override
    public synchronized void markAbandoned() {
        this.state = PooledObjectState.ABANDONED;
    }

    @Override
    public synchronized void markReturning() {
        this.state = PooledObjectState.RETURNING;
    }

    @Override
    public void setLogAbandoned(boolean bl) {
        this.logAbandoned = bl;
    }

    @Override
    public void setRequireFullStackTrace(boolean bl) {
        this.borrowedBy = CallStackUtils.newCallStack("'Pooled object created' yyyy-MM-dd HH:mm:ss Z 'by the following code has not been returned to the pool:'", true, bl);
        this.usedBy = CallStackUtils.newCallStack("The last code to use this object was:", false, bl);
    }
}

