/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.ErrorPageSupport;
import org.apache.catalina.util.IOTools;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.ActionCode;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.Escape;

public class ErrorReportValve
extends ValveBase {
    private boolean showReport = true;
    private boolean showServerInfo = true;
    private final ErrorPageSupport errorPageSupport = new ErrorPageSupport();

    public ErrorReportValve() {
        super(true);
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
        if (response.isCommitted()) {
            if (response.setErrorReported()) {
                AtomicBoolean atomicBoolean = new AtomicBoolean(true);
                response.getCoyoteResponse().action(ActionCode.IS_IO_ALLOWED, (Object)atomicBoolean);
                if (atomicBoolean.get()) {
                    try {
                        response.flushBuffer();
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                    }
                    response.getCoyoteResponse().action(ActionCode.CLOSE_NOW, request.getAttribute("javax.servlet.error.exception"));
                }
            }
            return;
        }
        Throwable throwable = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (request.isAsync() && !request.isAsyncCompleting()) {
            return;
        }
        if (throwable != null && !response.isError()) {
            response.reset();
            response.sendError(500);
        }
        response.setSuspended(false);
        try {
            this.report(request, response, throwable);
        }
        catch (Throwable throwable2) {
            ExceptionUtils.handleThrowable((Throwable)throwable2);
        }
    }

    protected void report(Request request, Response response, Throwable throwable) {
        Object object;
        Object object2;
        Object object3;
        String string;
        int n = response.getStatus();
        if (n < 400 || response.getContentWritten() > 0L || !response.setErrorReported()) {
            return;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        response.getCoyoteResponse().action(ActionCode.IS_IO_ALLOWED, (Object)atomicBoolean);
        if (!atomicBoolean.get()) {
            return;
        }
        ErrorPage errorPage = null;
        if (throwable != null) {
            errorPage = this.errorPageSupport.find(throwable);
        }
        if (errorPage == null) {
            errorPage = this.errorPageSupport.find(n);
        }
        if (errorPage == null) {
            errorPage = this.errorPageSupport.find(0);
        }
        if (errorPage != null && this.sendErrorPage(errorPage.getLocation(), response)) {
            return;
        }
        String string2 = Escape.htmlElementContent((String)response.getMessage());
        if (string2 == null) {
            if (throwable != null && (string = throwable.getMessage()) != null && string.length() > 0) {
                object3 = new Scanner(string);
                object2 = null;
                try {
                    string2 = Escape.htmlElementContent((String)((Scanner)object3).nextLine());
                }
                catch (Throwable throwable2) {
                    object2 = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object3 != null) {
                        if (object2 != null) {
                            try {
                                ((Scanner)object3).close();
                            }
                            catch (Throwable throwable3) {
                                ((Throwable)object2).addSuppressed(throwable3);
                            }
                        } else {
                            ((Scanner)object3).close();
                        }
                    }
                }
            }
            if (string2 == null) {
                string2 = "";
            }
        }
        string = null;
        object3 = null;
        object2 = StringManager.getManager((String)"org.apache.catalina.valves", request.getLocales());
        response.setLocale(object2.getLocale());
        try {
            string = object2.getString("http." + n + ".reason");
            object3 = object2.getString("http." + n + ".desc");
        }
        catch (Throwable throwable4) {
            ExceptionUtils.handleThrowable((Throwable)throwable4);
        }
        if (string == null || object3 == null) {
            if (string2.isEmpty()) {
                return;
            }
            string = object2.getString("errorReportValve.unknownReason");
            object3 = object2.getString("errorReportValve.noDescription");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<!doctype html><html lang=\"");
        stringBuilder.append(object2.getLocale().getLanguage()).append("\">");
        stringBuilder.append("<head>");
        stringBuilder.append("<title>");
        stringBuilder.append(object2.getString("errorReportValve.statusHeader", new Object[]{String.valueOf(n), string}));
        stringBuilder.append("</title>");
        stringBuilder.append("<style type=\"text/css\">");
        stringBuilder.append("body {font-family:Tahoma,Arial,sans-serif;} h1, h2, h3, b {color:white;background-color:#525D76;} h1 {font-size:22px;} h2 {font-size:16px;} h3 {font-size:14px;} p {font-size:12px;} a {color:black;} .line {height:1px;background-color:#525D76;border:none;}");
        stringBuilder.append("</style>");
        stringBuilder.append("</head><body>");
        stringBuilder.append("<h1>");
        stringBuilder.append(object2.getString("errorReportValve.statusHeader", new Object[]{String.valueOf(n), string})).append("</h1>");
        if (this.isShowReport()) {
            stringBuilder.append("<hr class=\"line\" />");
            stringBuilder.append("<p><b>");
            stringBuilder.append(object2.getString("errorReportValve.type"));
            stringBuilder.append("</b> ");
            if (throwable != null) {
                stringBuilder.append(object2.getString("errorReportValve.exceptionReport"));
            } else {
                stringBuilder.append(object2.getString("errorReportValve.statusReport"));
            }
            stringBuilder.append("</p>");
            if (!string2.isEmpty()) {
                stringBuilder.append("<p><b>");
                stringBuilder.append(object2.getString("errorReportValve.message"));
                stringBuilder.append("</b> ");
                stringBuilder.append(string2).append("</p>");
            }
            stringBuilder.append("<p><b>");
            stringBuilder.append(object2.getString("errorReportValve.description"));
            stringBuilder.append("</b> ");
            stringBuilder.append((String)object3);
            stringBuilder.append("</p>");
            if (throwable != null) {
                object = this.getPartialServletStackTrace(throwable);
                stringBuilder.append("<p><b>");
                stringBuilder.append(object2.getString("errorReportValve.exception"));
                stringBuilder.append("</b></p><pre>");
                stringBuilder.append(Escape.htmlElementContent((String)object));
                stringBuilder.append("</pre>");
                int n2 = 0;
                for (Throwable throwable5 = throwable.getCause(); throwable5 != null && n2 < 10; throwable5 = throwable5.getCause(), ++n2) {
                    object = this.getPartialServletStackTrace(throwable5);
                    stringBuilder.append("<p><b>");
                    stringBuilder.append(object2.getString("errorReportValve.rootCause"));
                    stringBuilder.append("</b></p><pre>");
                    stringBuilder.append(Escape.htmlElementContent((String)object));
                    stringBuilder.append("</pre>");
                }
                stringBuilder.append("<p><b>");
                stringBuilder.append(object2.getString("errorReportValve.note"));
                stringBuilder.append("</b> ");
                stringBuilder.append(object2.getString("errorReportValve.rootCauseInLogs"));
                stringBuilder.append("</p>");
            }
            stringBuilder.append("<hr class=\"line\" />");
        }
        if (this.isShowServerInfo()) {
            stringBuilder.append("<h3>").append(ServerInfo.getServerInfo()).append("</h3>");
        }
        stringBuilder.append("</body></html>");
        try {
            block38: {
                try {
                    response.setContentType("text/html");
                    response.setCharacterEncoding("utf-8");
                }
                catch (Throwable throwable6) {
                    ExceptionUtils.handleThrowable((Throwable)throwable6);
                    if (!this.container.getLogger().isDebugEnabled()) break block38;
                    this.container.getLogger().debug((Object)"Failure to set the content-type of response", throwable6);
                }
            }
            object = response.getReporter();
            if (object != null) {
                ((Writer)object).write(stringBuilder.toString());
                response.finishResponse();
            }
        }
        catch (IOException | IllegalStateException exception) {
            // empty catch block
        }
    }

    protected String getPartialServletStackTrace(Throwable throwable) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(throwable.toString()).append(System.lineSeparator());
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n2 = stackTraceElementArray.length;
        for (n = stackTraceElementArray.length - 1; n >= 0; --n) {
            if (!stackTraceElementArray[n].getClassName().startsWith("org.apache.catalina.core.ApplicationFilterChain") || !stackTraceElementArray[n].getMethodName().equals("internalDoFilter")) continue;
            n2 = n;
            break;
        }
        for (n = 0; n < n2; ++n) {
            if (stackTraceElementArray[n].getClassName().startsWith("org.apache.catalina.core.")) continue;
            stringBuilder.append('\t').append(stackTraceElementArray[n].toString()).append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    private boolean sendErrorPage(String string, Response response) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.getContainer().getCatalinaBase(), string);
        }
        if (!file.isFile() || !file.canRead()) {
            this.getContainer().getLogger().warn((Object)sm.getString("errorReportValve.errorPageNotFound", new Object[]{string}));
            return false;
        }
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        try (ServletOutputStream servletOutputStream = response.getOutputStream();
             FileInputStream fileInputStream = new FileInputStream(file);){
            IOTools.flow(fileInputStream, (OutputStream)servletOutputStream);
        }
        catch (IOException iOException) {
            this.getContainer().getLogger().warn((Object)sm.getString("errorReportValve.errorPageIOException", new Object[]{string}), (Throwable)iOException);
            return false;
        }
        return true;
    }

    public void setShowReport(boolean bl) {
        this.showReport = bl;
    }

    public boolean isShowReport() {
        return this.showReport;
    }

    public void setShowServerInfo(boolean bl) {
        this.showServerInfo = bl;
    }

    public boolean isShowServerInfo() {
        return this.showServerInfo;
    }

    public boolean setProperty(String string, String string2) {
        if (string.startsWith("errorCode.")) {
            int n = Integer.parseInt(string.substring(10));
            ErrorPage errorPage = new ErrorPage();
            errorPage.setErrorCode(n);
            errorPage.setLocation(string2);
            this.errorPageSupport.add(errorPage);
            return true;
        }
        if (string.startsWith("exceptionType.")) {
            String string3 = string.substring(14);
            ErrorPage errorPage = new ErrorPage();
            errorPage.setExceptionType(string3);
            errorPage.setLocation(string2);
            this.errorPageSupport.add(errorPage);
            return true;
        }
        return false;
    }

    public String getProperty(String string) {
        String string2;
        ErrorPage errorPage;
        int n;
        ErrorPage errorPage2;
        Object object = string.startsWith("errorCode.") ? ((errorPage2 = this.errorPageSupport.find(n = Integer.parseInt(string.substring(10)))) == null ? null : errorPage2.getLocation()) : (string.startsWith("exceptionType.") ? ((errorPage = this.errorPageSupport.find(string2 = string.substring(14))) == null ? null : errorPage.getLocation()) : null);
        return object;
    }
}

