/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.coyote.http2.AbstractNonZeroStream;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.StreamException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

abstract class AbstractStream {
    private static final Log log = LogFactory.getLog(AbstractStream.class);
    private static final StringManager sm = StringManager.getManager(AbstractStream.class);
    private final Integer identifier;
    private final String idAsString;
    private volatile AbstractStream parentStream = null;
    private final Set<AbstractNonZeroStream> childStreams = ConcurrentHashMap.newKeySet();
    private long windowSize = 65535L;
    private volatile int connectionAllocationRequested = 0;
    private volatile int connectionAllocationMade = 0;

    AbstractStream(Integer n) {
        this.identifier = n;
        this.idAsString = n.toString();
    }

    final Integer getIdentifier() {
        return this.identifier;
    }

    final String getIdAsString() {
        return this.idAsString;
    }

    final int getIdAsInt() {
        return this.identifier;
    }

    final void detachFromParent() {
        if (this.parentStream != null) {
            this.parentStream.getChildStreams().remove(this);
            this.parentStream = null;
        }
    }

    final void addChild(AbstractNonZeroStream abstractNonZeroStream) {
        abstractNonZeroStream.setParentStream(this);
        this.childStreams.add(abstractNonZeroStream);
    }

    final boolean isDescendant(AbstractStream abstractStream) {
        AbstractStream abstractStream2;
        for (abstractStream2 = abstractStream.getParentStream(); abstractStream2 != null && abstractStream2 != this; abstractStream2 = abstractStream2.getParentStream()) {
        }
        return abstractStream2 != null;
    }

    final AbstractStream getParentStream() {
        return this.parentStream;
    }

    final void setParentStream(AbstractStream abstractStream) {
        this.parentStream = abstractStream;
    }

    final Set<AbstractNonZeroStream> getChildStreams() {
        return this.childStreams;
    }

    final synchronized void setWindowSize(long l) {
        this.windowSize = l;
    }

    final synchronized long getWindowSize() {
        return this.windowSize;
    }

    synchronized void incrementWindowSize(int n) throws Http2Exception {
        this.windowSize += (long)n;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("abstractStream.windowSizeInc", new Object[]{this.getConnectionId(), this.getIdAsString(), Integer.toString(n), Long.toString(this.windowSize)}));
        }
        if (this.windowSize > Integer.MAX_VALUE) {
            String string = sm.getString("abstractStream.windowSizeTooBig", new Object[]{this.getConnectionId(), this.identifier, Integer.toString(n), Long.toString(this.windowSize)});
            if (this.identifier == 0) {
                throw new ConnectionException(string, Http2Error.FLOW_CONTROL_ERROR);
            }
            throw new StreamException(string, Http2Error.FLOW_CONTROL_ERROR, this.identifier);
        }
    }

    final synchronized void decrementWindowSize(int n) {
        this.windowSize -= (long)n;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("abstractStream.windowSizeDec", new Object[]{this.getConnectionId(), this.getIdAsString(), Integer.toString(n), Long.toString(this.windowSize)}));
        }
    }

    final int getConnectionAllocationRequested() {
        return this.connectionAllocationRequested;
    }

    final void setConnectionAllocationRequested(int n) {
        log.debug((Object)sm.getString("abstractStream.setConnectionAllocationRequested", new Object[]{this.getConnectionId(), this.getIdAsString(), Integer.toString(this.connectionAllocationRequested), Integer.toString(n)}));
        this.connectionAllocationRequested = n;
    }

    final int getConnectionAllocationMade() {
        return this.connectionAllocationMade;
    }

    final void setConnectionAllocationMade(int n) {
        log.debug((Object)sm.getString("abstractStream.setConnectionAllocationMade", new Object[]{this.getConnectionId(), this.getIdAsString(), Integer.toString(this.connectionAllocationMade), Integer.toString(n)}));
        this.connectionAllocationMade = n;
    }

    abstract String getConnectionId();

    abstract int getWeight();
}

