/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.backend;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.apache.catalina.ha.backend.HeartbeatListener;
import org.apache.catalina.ha.backend.Sender;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class MultiCastSender
implements Sender {
    private static final Log log = LogFactory.getLog(HeartbeatListener.class);
    private static final StringManager sm = StringManager.getManager(MultiCastSender.class);
    HeartbeatListener config = null;
    MulticastSocket s = null;
    InetAddress group = null;

    @Override
    public void init(HeartbeatListener heartbeatListener) throws Exception {
        this.config = heartbeatListener;
    }

    @Override
    public int send(String string) throws Exception {
        Object object;
        Object object2;
        if (this.s == null) {
            try {
                this.group = InetAddress.getByName(this.config.getGroup());
                if (this.config.getHost() != null) {
                    object2 = InetAddress.getByName(this.config.getHost());
                    object = new InetSocketAddress((InetAddress)object2, this.config.getMultiport());
                    this.s = new MulticastSocket((SocketAddress)object);
                } else {
                    this.s = new MulticastSocket(this.config.getMultiport());
                }
                this.s.setTimeToLive(this.config.getTtl());
                this.s.joinGroup(this.group);
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("multiCastSender.multiCastFailed"), (Throwable)exception);
                this.s = null;
                return -1;
            }
        }
        object2 = string.getBytes(StandardCharsets.US_ASCII);
        object = new DatagramPacket((byte[])object2, ((byte[])object2).length, this.group, this.config.getMultiport());
        try {
            this.s.send((DatagramPacket)object);
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("multiCastSender.sendFailed"), (Throwable)exception);
            this.s.close();
            this.s = null;
            return -1;
        }
        return 0;
    }
}

