/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.jdk9.model.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.jfr.EventType;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingFile;
import org.graalvm.visualvm.jfr.jdk9.model.impl.JFRJDK9Event;
import org.graalvm.visualvm.jfr.jdk9.model.impl.JFRJDK9EventType;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventType;
import org.graalvm.visualvm.jfr.model.JFREventTypeVisitor;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;

public class JFRJDK9Model
extends JFRModel {
    private static final Logger LOGGER = Logger.getLogger(JFRModel.class.getName());
    protected static final String SNAPSHOT_V1_PREFIX = "com.oracle.";
    protected static final int SNAPSHOT_V1_PREFIX_LENGTH = "com.oracle.".length();
    private final File snapshotFile;

    protected JFRJDK9Model(String id, File file) throws IOException {
        super(id);
        this.snapshotFile = file;
        RecordingFile events = new RecordingFile(this.snapshotFile.toPath());
        Throwable throwable = null;
        JFRJDK9Model.$closeResource(throwable, events);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitEvents(JFREventVisitor ... visitors) {
        for (JFREventVisitor visitor : visitors) {
            visitor.init();
        }
        try (JFREventVisitor[] events = new RecordingFile(this.snapshotFile.toPath());){
            ArrayList<JFREventVisitor> _visitors = new ArrayList<JFREventVisitor>(Arrays.asList(visitors));
            long id = 0L;
            while (!_visitors.isEmpty() && events.hasMoreEvents()) {
                RecordedEvent revent = events.readEvent();
                String typeId = this.getTypeId(revent.getEventType());
                JFREvent event = this.createEvent(revent, id++);
                Iterator _visitorsI = _visitors.iterator();
                while (_visitorsI.hasNext()) {
                    if (!((JFREventVisitor)_visitorsI.next()).visit(typeId, event)) continue;
                    _visitorsI.remove();
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Error visiting JFR events (" + this.getID() + ")", e);
        }
        finally {
            for (JFREventVisitor visitor : visitors) {
                visitor.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitEventTypes(JFREventTypeVisitor ... visitors) {
        for (JFREventTypeVisitor visitor : visitors) {
            visitor.initTypes();
        }
        try (JFREventTypeVisitor[] events = new RecordingFile(this.snapshotFile.toPath());){
            Iterator<EventType> types = events.readEventTypes().iterator();
            ArrayList<JFREventTypeVisitor> _visitors = new ArrayList<JFREventTypeVisitor>(Arrays.asList(visitors));
            while (!_visitors.isEmpty() && types.hasNext()) {
                EventType etype = types.next();
                String typeId = this.getTypeId(etype);
                JFRJDK9EventType type = new JFRJDK9EventType(etype);
                Iterator _visitorsI = _visitors.iterator();
                while (_visitorsI.hasNext()) {
                    if (!((JFREventTypeVisitor)_visitorsI.next()).visitType(typeId, (JFREventType)type)) continue;
                    _visitorsI.remove();
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Error visiting JFR event types (" + this.getID() + ")", e);
        }
        finally {
            for (JFREventTypeVisitor visitor : visitors) {
                visitor.doneTypes();
            }
        }
    }

    protected String getTypeId(EventType eventType) {
        return JFRJDK9Model.normalizeV1Id(eventType.getName());
    }

    protected static boolean isV1Id(String typeId) {
        return typeId.startsWith(SNAPSHOT_V1_PREFIX);
    }

    protected static String normalizeV1Id(String typeId) {
        return typeId.substring(SNAPSHOT_V1_PREFIX_LENGTH);
    }

    protected JFREvent createEvent(RecordedEvent revent, long id) {
        return new JFRJDK9Event(revent, id);
    }
}

