/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.monitor;

import org.graalvm.visualvm.lib.charts.Timeline;
import org.graalvm.visualvm.lib.charts.swing.LongRect;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItem;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItemsModel;
import org.graalvm.visualvm.lib.jfluid.results.DataManagerListener;
import org.graalvm.visualvm.lib.jfluid.results.monitor.VMTelemetryDataManager;
import org.graalvm.visualvm.lib.ui.charts.xy.ProfilerGCXYItem;
import org.graalvm.visualvm.lib.ui.graphs.GraphsUI;

public final class VMTelemetryModels {
    private final VMTelemetryDataManager dataManager;
    private final DataManagerListener listener;
    private final Timeline timeline;
    private final SynchronousXYItemsModel cpuItemsModel;
    private final SynchronousXYItemsModel memoryItemsModel;
    private final SynchronousXYItemsModel generationsItemsModel;
    private final SynchronousXYItemsModel threadsItemsModel;

    public VMTelemetryModels(VMTelemetryDataManager dataManager) {
        this.dataManager = dataManager;
        this.timeline = this.createTimeline();
        this.cpuItemsModel = this.createCPUItemsModel(this.timeline);
        this.memoryItemsModel = this.createMemoryItemsModel(this.timeline);
        this.generationsItemsModel = this.createGenerationsItemsModel(this.timeline);
        this.threadsItemsModel = this.createThreadsItemsModel(this.timeline);
        this.listener = new DataManagerListener(){

            public void dataChanged() {
                VMTelemetryModels.this.dataChangedImpl();
            }

            public void dataReset() {
                VMTelemetryModels.this.dataResetImpl();
            }
        };
        dataManager.addDataListener(this.listener);
    }

    public VMTelemetryDataManager getDataManager() {
        return this.dataManager;
    }

    public SynchronousXYItemsModel cpuItemsModel() {
        return this.cpuItemsModel;
    }

    public SynchronousXYItemsModel memoryItemsModel() {
        return this.memoryItemsModel;
    }

    public SynchronousXYItemsModel generationsItemsModel() {
        return this.generationsItemsModel;
    }

    public SynchronousXYItemsModel threadsItemsModel() {
        return this.threadsItemsModel;
    }

    public void cleanup() {
        this.dataManager.removeDataListener(this.listener);
    }

    private void dataChangedImpl() {
        this.cpuItemsModel.valuesAdded();
        this.memoryItemsModel.valuesAdded();
        this.generationsItemsModel.valuesAdded();
        this.threadsItemsModel.valuesAdded();
    }

    private void dataResetImpl() {
        this.cpuItemsModel.valuesReset();
        this.memoryItemsModel.valuesReset();
        this.generationsItemsModel.valuesReset();
        this.threadsItemsModel.valuesReset();
    }

    private Timeline createTimeline() {
        return new Timeline(){

            public int getTimestampsCount() {
                return VMTelemetryModels.this.dataManager.getItemCount();
            }

            public long getTimestamp(int index) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.timeStamps[index];
            }
        };
    }

    private SynchronousXYItemsModel createCPUItemsModel(Timeline timeline) {
        SynchronousXYItem cpuTimeItem = new SynchronousXYItem("CPU Time", 0L, 1000L){

            public long getYValue(int index) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.processCPUTimeInPromile[index];
            }
        };
        cpuTimeItem.setInitialBounds(new LongRect(0L, 0L, 0L, 1000L));
        SynchronousXYItem gcTimeItem = new SynchronousXYItem(GraphsUI.GC_TIME_NAME, 0L, 1000L){

            public long getYValue(int index) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.relativeGCTimeInPerMil[index];
            }
        };
        gcTimeItem.setInitialBounds(new LongRect(0L, 0L, 0L, 1000L));
        SynchronousXYItemsModel model = new SynchronousXYItemsModel(timeline, new SynchronousXYItem[]{cpuTimeItem, gcTimeItem});
        return model;
    }

    private SynchronousXYItemsModel createMemoryItemsModel(Timeline timeline) {
        SynchronousXYItem heapSizeItem = new SynchronousXYItem(GraphsUI.HEAP_SIZE_NAME, 0L){

            public long getYValue(int index) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.totalMemory[index];
            }
        };
        heapSizeItem.setInitialBounds(new LongRect(0L, 0L, 0L, 0x4000000L));
        SynchronousXYItem usedHeapItem = new SynchronousXYItem(GraphsUI.USED_HEAP_NAME, 0L){

            public long getYValue(int index) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.usedMemory[index];
            }
        };
        usedHeapItem.setInitialBounds(new LongRect(0L, 0L, 0L, 0x1000000L));
        SynchronousXYItemsModel model = new SynchronousXYItemsModel(timeline, new SynchronousXYItem[]{heapSizeItem, usedHeapItem});
        return model;
    }

    private SynchronousXYItemsModel createGenerationsItemsModel(Timeline timeline) {
        SynchronousXYItem survivingGenerationsItem = new SynchronousXYItem(GraphsUI.SURVGEN_NAME, 0L){

            public long getYValue(int index) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.nSurvivingGenerations[index];
            }
        };
        survivingGenerationsItem.setInitialBounds(new LongRect(0L, 0L, 0L, 11L));
        ProfilerGCXYItem gcIntervalsItem = new ProfilerGCXYItem(""){

            @Override
            public long[] getGCStarts(int index) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.gcStarts[index];
            }

            @Override
            public long[] getGCEnds(int index) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.gcFinishs[index];
            }
        };
        SynchronousXYItemsModel model = new SynchronousXYItemsModel(timeline, new SynchronousXYItem[]{gcIntervalsItem, survivingGenerationsItem});
        return model;
    }

    private SynchronousXYItemsModel createThreadsItemsModel(Timeline timeline) {
        SynchronousXYItem threadsItem = new SynchronousXYItem(GraphsUI.THREADS_NAME, 0L){

            public long getYValue(int index) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.nTotalThreads[index];
            }
        };
        threadsItem.setInitialBounds(new LongRect(0L, 0L, 0L, 3L));
        SynchronousXYItem loadedClassesItem = new SynchronousXYItem(GraphsUI.LOADED_CLASSES_NAME, 0L){

            public long getYValue(int index) {
                return ((VMTelemetryModels)VMTelemetryModels.this).dataManager.loadedClassesCount[index];
            }
        };
        loadedClassesItem.setInitialBounds(new LongRect(0L, 0L, 0L, 732L));
        SynchronousXYItemsModel model = new SynchronousXYItemsModel(timeline, new SynchronousXYItem[]{threadsItem, loadedClassesItem});
        return model;
    }
}

