/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.storage.querybuilder;

import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.ReferenceExpression;

public class SeriesSelectionQueryBuilder {
    public static String build(String metricName, Expression filterCondition) {
        if (filterCondition != null) {
            SeriesSelectionExpressionNodeVisitor seriesSelectionExpressionNodeVisitor = new SeriesSelectionExpressionNodeVisitor();
            String selectorQuery = (String)filterCondition.accept((ExpressionNodeVisitor)seriesSelectionExpressionNodeVisitor, null);
            return metricName + "{" + selectorQuery + "}";
        }
        return metricName;
    }

    @Generated
    public SeriesSelectionQueryBuilder() {
    }

    static class SeriesSelectionExpressionNodeVisitor
    extends ExpressionNodeVisitor<String, Object> {
        SeriesSelectionExpressionNodeVisitor() {
        }

        public String visitFunction(FunctionExpression func, Object context) {
            if (func.getFunctionName().getFunctionName().equals("and")) {
                return func.getArguments().stream().map(arg -> this.visitFunction((FunctionExpression)arg, context)).filter(StringUtils::isNotEmpty).collect(Collectors.joining(" , "));
            }
            if (func.getFunctionName().getFunctionName().contains("=")) {
                ReferenceExpression ref = (ReferenceExpression)func.getArguments().get(0);
                if (!ref.getAttr().equals("@timestamp")) {
                    return func.getArguments().get(0) + func.getFunctionName().getFunctionName() + func.getArguments().get(1);
                }
                return null;
            }
            throw new RuntimeException(String.format("Prometheus Catalog doesn't support %s in where command.", func.getFunctionName().getFunctionName()));
        }
    }
}

