/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.logical.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import java.util.Set;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.opensearch.planner.logical.OpenSearchLogicalIndexScan;
import org.opensearch.sql.opensearch.planner.logical.rule.OptimizationRuleUtils;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalProject;
import org.opensearch.sql.planner.optimizer.Rule;
import org.opensearch.sql.planner.optimizer.pattern.Patterns;

public class PushProjectAndIndexScan
implements Rule<LogicalProject> {
    private final Capture<OpenSearchLogicalIndexScan> indexScanCapture = Capture.newCapture();
    private final Pattern<LogicalProject> pattern = Pattern.typeOf(LogicalProject.class).matching(project -> {
        this.pushDownProjects = OptimizationRuleUtils.findReferenceExpressions(project.getProjectList());
        return !this.pushDownProjects.isEmpty();
    }).with(Patterns.source().matching(Pattern.typeOf(OpenSearchLogicalIndexScan.class).matching(indexScan -> !indexScan.hasProjects()).capturedAs(this.indexScanCapture)));
    private Set<ReferenceExpression> pushDownProjects;

    public Pattern<LogicalProject> pattern() {
        return this.pattern;
    }

    public LogicalPlan apply(LogicalProject project, Captures captures) {
        OpenSearchLogicalIndexScan indexScan = (OpenSearchLogicalIndexScan)((Object)captures.get(this.indexScanCapture));
        indexScan.setProjectList(this.pushDownProjects);
        return new LogicalProject((LogicalPlan)indexScan, project.getProjectList(), project.getNamedParseExpressions());
    }
}

