/* BackgroundManager.c generated by valac 0.56.3, the Vala compiler
 * generated from BackgroundManager.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <meta/meta-background-group.h>
#include <glib-object.h>
#include <meta/display.h>
#include <glib.h>
#include <meta/meta-background-actor.h>
#include <clutter/clutter.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <meta/meta-background-content.h>
#include <meta/meta-background.h>
#include <granite.h>
#include <meta/boxes.h>

#define GALA_BACKGROUND_MANAGER_GNOME_BACKGROUND_SCHEMA "org.gnome.desktop.background"
#define GALA_BACKGROUND_MANAGER_GALA_BACKGROUND_SCHEMA "io.elementary.desktop.background"
#define GALA_BACKGROUND_MANAGER_DIM_WALLPAPER_KEY "dim-wallpaper-in-dark-style"
#define GALA_BACKGROUND_MANAGER_DIM_OPACITY 0.85
#define GALA_BACKGROUND_MANAGER_FADE_ANIMATION_TIME 1000
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_BACKGROUND_MANAGER (gala_background_manager_get_type ())
#define GALA_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager))
#define GALA_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))
#define GALA_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))

typedef struct _GalaBackgroundManager GalaBackgroundManager;
typedef struct _GalaBackgroundManagerClass GalaBackgroundManagerClass;
typedef struct _GalaBackgroundManagerPrivate GalaBackgroundManagerPrivate;

#define GALA_TYPE_BACKGROUND_SOURCE (gala_background_source_get_type ())
#define GALA_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSource))
#define GALA_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSourceClass))
#define GALA_IS_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_SOURCE))
#define GALA_IS_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_SOURCE))
#define GALA_BACKGROUND_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSourceClass))

typedef struct _GalaBackgroundSource GalaBackgroundSource;
typedef struct _GalaBackgroundSourceClass GalaBackgroundSourceClass;
enum  {
	GALA_BACKGROUND_MANAGER_0_PROPERTY,
	GALA_BACKGROUND_MANAGER_DISPLAY_PROPERTY,
	GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY,
	GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY,
	GALA_BACKGROUND_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gala_background_manager_properties[GALA_BACKGROUND_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_BACKGROUND_CACHE (gala_background_cache_get_type ())
#define GALA_BACKGROUND_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCache))
#define GALA_BACKGROUND_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCacheClass))
#define GALA_IS_BACKGROUND_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_CACHE))
#define GALA_IS_BACKGROUND_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_CACHE))
#define GALA_BACKGROUND_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCacheClass))

typedef struct _GalaBackgroundCache GalaBackgroundCache;
typedef struct _GalaBackgroundCacheClass GalaBackgroundCacheClass;
typedef struct _Block48Data Block48Data;

#define GALA_TYPE_BACKGROUND (gala_background_get_type ())
#define GALA_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND, GalaBackground))
#define GALA_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND, GalaBackgroundClass))
#define GALA_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND))
#define GALA_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND))
#define GALA_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND, GalaBackgroundClass))

typedef struct _GalaBackground GalaBackground;
typedef struct _GalaBackgroundClass GalaBackgroundClass;
typedef struct _Block49Data Block49Data;
typedef struct _Block50Data Block50Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GALA_BACKGROUND_MANAGER_TYPE_OPACITY_DIM_ACTOR (gala_background_manager_opacity_dim_actor_get_type ())
#define GALA_BACKGROUND_MANAGER_OPACITY_DIM_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_BACKGROUND_MANAGER_TYPE_OPACITY_DIM_ACTOR, GalaBackgroundManagerOpacityDimActor))
#define GALA_BACKGROUND_MANAGER_OPACITY_DIM_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_BACKGROUND_MANAGER_TYPE_OPACITY_DIM_ACTOR, GalaBackgroundManagerOpacityDimActorClass))
#define GALA_BACKGROUND_MANAGER_IS_OPACITY_DIM_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_BACKGROUND_MANAGER_TYPE_OPACITY_DIM_ACTOR))
#define GALA_BACKGROUND_MANAGER_IS_OPACITY_DIM_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_BACKGROUND_MANAGER_TYPE_OPACITY_DIM_ACTOR))
#define GALA_BACKGROUND_MANAGER_OPACITY_DIM_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_BACKGROUND_MANAGER_TYPE_OPACITY_DIM_ACTOR, GalaBackgroundManagerOpacityDimActorClass))

typedef struct _GalaBackgroundManagerOpacityDimActor GalaBackgroundManagerOpacityDimActor;
typedef struct _GalaBackgroundManagerOpacityDimActorClass GalaBackgroundManagerOpacityDimActorClass;
typedef struct _Block51Data Block51Data;
typedef struct _GalaBackgroundManagerOpacityDimActorPrivate GalaBackgroundManagerOpacityDimActorPrivate;
enum  {
	GALA_BACKGROUND_MANAGER_OPACITY_DIM_ACTOR_0_PROPERTY,
	GALA_BACKGROUND_MANAGER_OPACITY_DIM_ACTOR_OPACITY_PROPERTY,
	GALA_BACKGROUND_MANAGER_OPACITY_DIM_ACTOR_NUM_PROPERTIES
};
static GParamSpec* gala_background_manager_opacity_dim_actor_properties[GALA_BACKGROUND_MANAGER_OPACITY_DIM_ACTOR_NUM_PROPERTIES];
enum  {
	GALA_BACKGROUND_MANAGER_CHANGED_SIGNAL,
	GALA_BACKGROUND_MANAGER_NUM_SIGNALS
};
static guint gala_background_manager_signals[GALA_BACKGROUND_MANAGER_NUM_SIGNALS] = {0};

struct _GalaBackgroundManager {
	MetaBackgroundGroup parent_instance;
	GalaBackgroundManagerPrivate * priv;
};

struct _GalaBackgroundManagerClass {
	MetaBackgroundGroupClass parent_class;
};

struct _GalaBackgroundManagerPrivate {
	MetaDisplay* _display;
	gint _monitor_index;
	gboolean _control_position;
	GalaBackgroundSource* background_source;
	MetaBackgroundActor* background_actor;
	MetaBackgroundActor* new_background_actor;
	ClutterPropertyTransition* last_dim_transition;
};

struct _Block48Data {
	int _ref_count_;
	GalaBackgroundManager* self;
	MetaBackgroundActor* old_background_actor;
};

struct _Block49Data {
	int _ref_count_;
	GalaBackgroundManager* self;
	GalaBackground* background;
	gulong handler;
	gboolean animate;
};

struct _Block50Data {
	int _ref_count_;
	GalaBackgroundManager* self;
	GalaBackground* background;
	gulong changed_handler;
};

struct _Block51Data {
	int _ref_count_;
	GalaBackgroundManager* self;
	GalaBackgroundManagerOpacityDimActor* dim_actor;
	GBinding* binding;
};

struct _GalaBackgroundManagerOpacityDimActor {
	ClutterActor parent_instance;
	GalaBackgroundManagerOpacityDimActorPrivate * priv;
};

struct _GalaBackgroundManagerOpacityDimActorClass {
	ClutterActorClass parent_class;
};

struct _GalaBackgroundManagerOpacityDimActorPrivate {
	gdouble _opacity;
};

static gint GalaBackgroundManager_private_offset;
static gpointer gala_background_manager_parent_class = NULL;
static GSettings* gala_background_manager_gala_background_settings;
static GSettings* gala_background_manager_gala_background_settings = NULL;
static gint GalaBackgroundManagerOpacityDimActor_private_offset;
static gpointer gala_background_manager_opacity_dim_actor_parent_class = NULL;

VALA_EXTERN GType gala_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManager, g_object_unref)
VALA_EXTERN GType gala_background_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundSource, g_object_unref)
VALA_EXTERN GalaBackgroundManager* gala_background_manager_new (MetaDisplay* display,
                                                    gint monitor_index,
                                                    gboolean control_position);
VALA_EXTERN GalaBackgroundManager* gala_background_manager_construct (GType object_type,
                                                          MetaDisplay* display,
                                                          gint monitor_index,
                                                          gboolean control_position);
static void gala_background_manager_on_destroy (GalaBackgroundManager* self);
VALA_EXTERN GType gala_background_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundCache, g_object_unref)
VALA_EXTERN GalaBackgroundCache* gala_background_cache_get_default (void);
VALA_EXTERN void gala_background_cache_release_background_source (GalaBackgroundCache* self,
                                                      const gchar* settings_schema);
static void gala_background_manager_swap_background_actor (GalaBackgroundManager* self,
                                                    gboolean animate);
static Block48Data* block48_data_ref (Block48Data* _data48_);
static void block48_data_unref (void * _userdata_);
static void ___lambda58_ (Block48Data* _data48_);
static void ____lambda58__clutter_timeline_completed (ClutterTimeline* _sender,
                                               gpointer self);
static void gala_background_manager_update_background_actor (GalaBackgroundManager* self,
                                                      gboolean animate);
VALA_EXTERN GType gala_background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackground, g_object_unref)
static Block49Data* block49_data_ref (Block49Data* _data49_);
static void block49_data_unref (void * _userdata_);
static MetaBackgroundActor* gala_background_manager_create_background_actor (GalaBackgroundManager* self);
VALA_EXTERN gboolean gala_background_get_is_loaded (GalaBackground* self);
static void __lambda62_ (Block49Data* _data49_);
static void ___lambda62__gala_background_loaded (GalaBackground* _sender,
                                          gpointer self);
VALA_EXTERN void gala_background_manager_set_size (GalaBackgroundManager* self,
                                       gfloat width,
                                       gfloat height);
static Block50Data* block50_data_ref (Block50Data* _data50_);
static void block50_data_unref (void * _userdata_);
VALA_EXTERN GalaBackground* gala_background_source_get_background (GalaBackgroundSource* self,
                                                       gint monitor_index);
VALA_EXTERN gint gala_background_manager_get_monitor_index (GalaBackgroundManager* self);
VALA_EXTERN MetaDisplay* gala_background_manager_get_display (GalaBackgroundManager* self);
VALA_EXTERN MetaBackground* gala_background_get_background (GalaBackground* self);
static gboolean gala_background_manager_should_dim (GalaBackgroundManager* self);
static void gala_background_manager_update_dim_wallpaper (GalaBackgroundManager* self);
static void _gala_background_manager_update_dim_wallpaper_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static void _gala_background_manager_update_dim_wallpaper_g_settings_changed (GSettings* _sender,
                                                                       const gchar* key,
                                                                       gpointer self);
VALA_EXTERN gboolean gala_background_manager_get_control_position (GalaBackgroundManager* self);
static void __lambda60_ (Block50Data* _data50_);
static void ___lambda60__gala_background_changed (GalaBackground* _sender,
                                           gpointer self);
static void __lambda61_ (Block50Data* _data50_);
static void ___lambda61__clutter_actor_destroy (ClutterActor* _sender,
                                         gpointer self);
static GType gala_background_manager_opacity_dim_actor_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManagerOpacityDimActor, g_object_unref)
static Block51Data* block51_data_ref (Block51Data* _data51_);
static void block51_data_unref (void * _userdata_);
static GalaBackgroundManagerOpacityDimActor* gala_background_manager_opacity_dim_actor_new (void);
static GalaBackgroundManagerOpacityDimActor* gala_background_manager_opacity_dim_actor_construct (GType object_type);
static void __lambda59_ (Block51Data* _data51_);
static void ___lambda59__clutter_timeline_completed (ClutterTimeline* _sender,
                                              gpointer self);
static void gala_background_manager_set_display (GalaBackgroundManager* self,
                                          MetaDisplay* value);
static void gala_background_manager_set_monitor_index (GalaBackgroundManager* self,
                                                gint value);
static void gala_background_manager_set_control_position (GalaBackgroundManager* self,
                                                   gboolean value);
static gdouble gala_background_manager_opacity_dim_actor_get_opacity (GalaBackgroundManagerOpacityDimActor* self);
static void gala_background_manager_opacity_dim_actor_set_opacity (GalaBackgroundManagerOpacityDimActor* self,
                                                            gdouble value);
static void gala_background_manager_opacity_dim_actor_finalize (GObject * obj);
static GType gala_background_manager_opacity_dim_actor_get_type_once (void);
static void _vala_gala_background_manager_opacity_dim_actor_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec);
static void _vala_gala_background_manager_opacity_dim_actor_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec);
static GObject * gala_background_manager_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
VALA_EXTERN GalaBackgroundSource* gala_background_cache_get_background_source (GalaBackgroundCache* self,
                                                                   MetaDisplay* display,
                                                                   const gchar* settings_schema);
static void _gala_background_manager_on_destroy_clutter_actor_destroy (ClutterActor* _sender,
                                                                gpointer self);
static void gala_background_manager_finalize (GObject * obj);
static GType gala_background_manager_get_type_once (void);
static void _vala_gala_background_manager_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_gala_background_manager_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_background_manager_get_instance_private (GalaBackgroundManager* self)
{
	return G_STRUCT_MEMBER_P (self, GalaBackgroundManager_private_offset);
}

GalaBackgroundManager*
gala_background_manager_construct (GType object_type,
                                   MetaDisplay* display,
                                   gint monitor_index,
                                   gboolean control_position)
{
	GalaBackgroundManager * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GalaBackgroundManager*) g_object_new (object_type, "display", display, "monitor-index", monitor_index, "control-position", control_position, NULL);
	return self;
}

GalaBackgroundManager*
gala_background_manager_new (MetaDisplay* display,
                             gint monitor_index,
                             gboolean control_position)
{
	return gala_background_manager_construct (GALA_TYPE_BACKGROUND_MANAGER, display, monitor_index, control_position);
}

static void
gala_background_manager_on_destroy (GalaBackgroundManager* self)
{
	GalaBackgroundCache* _tmp0_;
	MetaBackgroundActor* _tmp1_;
	MetaBackgroundActor* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_background_cache_get_default ();
	gala_background_cache_release_background_source (_tmp0_, GALA_BACKGROUND_MANAGER_GNOME_BACKGROUND_SCHEMA);
	_g_object_unref0 (self->priv->background_source);
	self->priv->background_source = NULL;
	_tmp1_ = self->priv->new_background_actor;
	if (_tmp1_ != NULL) {
		MetaBackgroundActor* _tmp2_;
		_tmp2_ = self->priv->new_background_actor;
		clutter_actor_destroy ((ClutterActor*) _tmp2_);
		_g_object_unref0 (self->priv->new_background_actor);
		self->priv->new_background_actor = NULL;
	}
	_tmp3_ = self->priv->background_actor;
	if (_tmp3_ != NULL) {
		MetaBackgroundActor* _tmp4_;
		_tmp4_ = self->priv->background_actor;
		clutter_actor_destroy ((ClutterActor*) _tmp4_);
		_g_object_unref0 (self->priv->background_actor);
		self->priv->background_actor = NULL;
	}
}

static Block48Data*
block48_data_ref (Block48Data* _data48_)
{
	g_atomic_int_inc (&_data48_->_ref_count_);
	return _data48_;
}

static void
block48_data_unref (void * _userdata_)
{
	Block48Data* _data48_;
	_data48_ = (Block48Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data48_->_ref_count_)) {
		GalaBackgroundManager* self;
		self = _data48_->self;
		_g_object_unref0 (_data48_->old_background_actor);
		_g_object_unref0 (self);
		g_slice_free (Block48Data, _data48_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda58_ (Block48Data* _data48_)
{
	GalaBackgroundManager* self;
	MetaBackgroundActor* _tmp0_;
	self = _data48_->self;
	_tmp0_ = _data48_->old_background_actor;
	clutter_actor_destroy ((ClutterActor*) _tmp0_);
	g_signal_emit (self, gala_background_manager_signals[GALA_BACKGROUND_MANAGER_CHANGED_SIGNAL], 0);
}

static void
____lambda58__clutter_timeline_completed (ClutterTimeline* _sender,
                                          gpointer self)
{
	___lambda58_ (self);
}

static void
gala_background_manager_swap_background_actor (GalaBackgroundManager* self,
                                               gboolean animate)
{
	Block48Data* _data48_;
	MetaBackgroundActor* _tmp0_;
	MetaBackgroundActor* _tmp1_;
	MetaBackgroundActor* _tmp2_;
	MetaBackgroundActor* _tmp3_;
	MetaBackgroundActor* _tmp4_;
	MetaBackgroundActor* _tmp5_;
	g_return_if_fail (self != NULL);
	_data48_ = g_slice_new0 (Block48Data);
	_data48_->_ref_count_ = 1;
	_data48_->self = g_object_ref (self);
	_tmp0_ = self->priv->new_background_actor;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->background_actor;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data48_->old_background_actor = _tmp2_;
	_tmp3_ = self->priv->new_background_actor;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->background_actor);
	self->priv->background_actor = _tmp4_;
	_g_object_unref0 (self->priv->new_background_actor);
	self->priv->new_background_actor = NULL;
	_tmp5_ = _data48_->old_background_actor;
	if (_tmp5_ == NULL) {
		block48_data_unref (_data48_);
		_data48_ = NULL;
		return;
	}
	if (animate) {
		ClutterPropertyTransition* transition = NULL;
		ClutterPropertyTransition* _tmp6_;
		ClutterPropertyTransition* _tmp7_;
		GValue _tmp8_ = {0};
		ClutterPropertyTransition* _tmp9_;
		GValue _tmp10_ = {0};
		ClutterPropertyTransition* _tmp11_;
		ClutterPropertyTransition* _tmp12_;
		ClutterPropertyTransition* _tmp13_;
		ClutterPropertyTransition* _tmp14_;
		MetaBackgroundActor* _tmp15_;
		ClutterPropertyTransition* _tmp16_;
		_tmp6_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
		transition = _tmp6_;
		_tmp7_ = transition;
		g_value_init (&_tmp8_, G_TYPE_INT);
		g_value_set_int (&_tmp8_, 255);
		clutter_transition_set_from_value ((ClutterTransition*) _tmp7_, &_tmp8_);
		G_IS_VALUE (&_tmp8_) ? (g_value_unset (&_tmp8_), NULL) : NULL;
		_tmp9_ = transition;
		g_value_init (&_tmp10_, G_TYPE_INT);
		g_value_set_int (&_tmp10_, 0);
		clutter_transition_set_to_value ((ClutterTransition*) _tmp9_, &_tmp10_);
		G_IS_VALUE (&_tmp10_) ? (g_value_unset (&_tmp10_), NULL) : NULL;
		_tmp11_ = transition;
		clutter_timeline_set_duration ((ClutterTimeline*) _tmp11_, (guint) GALA_BACKGROUND_MANAGER_FADE_ANIMATION_TIME);
		_tmp12_ = transition;
		clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp12_, CLUTTER_EASE_OUT_QUAD);
		_tmp13_ = transition;
		clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp13_, TRUE);
		_tmp14_ = transition;
		g_signal_connect_data ((ClutterTimeline*) _tmp14_, "completed", (GCallback) ____lambda58__clutter_timeline_completed, block48_data_ref (_data48_), (GClosureNotify) block48_data_unref, 0);
		_tmp15_ = _data48_->old_background_actor;
		_tmp16_ = transition;
		clutter_actor_add_transition ((ClutterActor*) _tmp15_, "fade-out", (ClutterTransition*) _tmp16_);
		_g_object_unref0 (transition);
	} else {
		MetaBackgroundActor* _tmp17_;
		_tmp17_ = _data48_->old_background_actor;
		clutter_actor_destroy ((ClutterActor*) _tmp17_);
		g_signal_emit (self, gala_background_manager_signals[GALA_BACKGROUND_MANAGER_CHANGED_SIGNAL], 0);
	}
	block48_data_unref (_data48_);
	_data48_ = NULL;
}

static Block49Data*
block49_data_ref (Block49Data* _data49_)
{
	g_atomic_int_inc (&_data49_->_ref_count_);
	return _data49_;
}

static void
block49_data_unref (void * _userdata_)
{
	Block49Data* _data49_;
	_data49_ = (Block49Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data49_->_ref_count_)) {
		GalaBackgroundManager* self;
		self = _data49_->self;
		_g_object_unref0 (_data49_->background);
		_g_object_unref0 (self);
		g_slice_free (Block49Data, _data49_);
	}
}

static void
__lambda62_ (Block49Data* _data49_)
{
	GalaBackgroundManager* self;
	GalaBackground* _tmp0_;
	GalaBackground* _tmp1_;
	self = _data49_->self;
	_tmp0_ = _data49_->background;
	g_signal_handler_disconnect (_tmp0_, _data49_->handler);
	_tmp1_ = _data49_->background;
	g_object_set_data_full ((GObject*) _tmp1_, "background-loaded-handler", (gpointer) ((guintptr) 0), NULL);
	gala_background_manager_swap_background_actor (self, _data49_->animate);
}

static void
___lambda62__gala_background_loaded (GalaBackground* _sender,
                                     gpointer self)
{
	__lambda62_ (self);
}

static void
gala_background_manager_update_background_actor (GalaBackgroundManager* self,
                                                 gboolean animate)
{
	Block49Data* _data49_;
	MetaBackgroundActor* _tmp0_;
	MetaBackgroundActor* _tmp2_;
	MetaBackgroundContent* new_content = NULL;
	MetaBackgroundActor* _tmp3_;
	ClutterContent* _tmp4_;
	ClutterContent* _tmp5_;
	MetaBackgroundContent* _tmp6_;
	MetaBackgroundContent* old_content = NULL;
	MetaBackgroundActor* _tmp7_;
	ClutterContent* _tmp8_;
	ClutterContent* _tmp9_;
	MetaBackgroundContent* _tmp10_;
	MetaBackgroundContent* _tmp11_;
	MetaBackgroundContent* _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	MetaBackgroundContent* _tmp15_;
	MetaBackgroundContent* _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	MetaBackgroundActor* _tmp19_;
	MetaBackgroundActor* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	MetaBackgroundContent* _tmp23_;
	MetaBackground* _tmp24_;
	MetaBackground* _tmp25_;
	MetaBackground* _tmp26_;
	gconstpointer _tmp27_;
	GalaBackground* _tmp28_;
	GalaBackground* _tmp29_;
	GalaBackground* _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	GalaBackground* _tmp33_;
	gulong _tmp34_;
	GalaBackground* _tmp35_;
	g_return_if_fail (self != NULL);
	_data49_ = g_slice_new0 (Block49Data);
	_data49_->_ref_count_ = 1;
	_data49_->self = g_object_ref (self);
	_data49_->animate = animate;
	_tmp0_ = self->priv->new_background_actor;
	if (_tmp0_ != NULL) {
		MetaBackgroundActor* _tmp1_;
		_tmp1_ = self->priv->new_background_actor;
		clutter_actor_destroy ((ClutterActor*) _tmp1_);
		_g_object_unref0 (self->priv->new_background_actor);
		self->priv->new_background_actor = NULL;
	}
	_tmp2_ = gala_background_manager_create_background_actor (self);
	_g_object_unref0 (self->priv->new_background_actor);
	self->priv->new_background_actor = _tmp2_;
	_tmp3_ = self->priv->new_background_actor;
	_tmp4_ = clutter_actor_get_content ((ClutterActor*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, meta_background_content_get_type (), MetaBackgroundContent));
	new_content = _tmp6_;
	_tmp7_ = self->priv->background_actor;
	_tmp8_ = clutter_actor_get_content ((ClutterActor*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, meta_background_content_get_type (), MetaBackgroundContent));
	old_content = _tmp10_;
	_tmp11_ = new_content;
	_tmp12_ = old_content;
	g_object_get (_tmp12_, "vignette-sharpness", &_tmp13_, NULL);
	_tmp14_ = _tmp13_;
	g_object_set (_tmp11_, "vignette-sharpness", _tmp14_, NULL);
	_tmp15_ = new_content;
	_tmp16_ = old_content;
	g_object_get (_tmp16_, "brightness", &_tmp17_, NULL);
	_tmp18_ = _tmp17_;
	g_object_set (_tmp15_, "brightness", _tmp18_, NULL);
	_tmp19_ = self->priv->new_background_actor;
	_tmp20_ = self->priv->background_actor;
	g_object_get ((ClutterActor*) _tmp20_, "visible", &_tmp21_, NULL);
	_tmp22_ = _tmp21_;
	g_object_set ((ClutterActor*) _tmp19_, "visible", _tmp22_, NULL);
	_tmp23_ = new_content;
	g_object_get (_tmp23_, "background", &_tmp24_, NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp27_ = g_object_get_data ((GObject*) _tmp26_, "delegate");
	_tmp28_ = _g_object_ref0 ((GalaBackground*) _tmp27_);
	_tmp29_ = _tmp28_;
	_g_object_unref0 (_tmp26_);
	_data49_->background = _tmp29_;
	_tmp30_ = _data49_->background;
	_tmp31_ = gala_background_get_is_loaded (_tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_) {
		gala_background_manager_swap_background_actor (self, _data49_->animate);
		_g_object_unref0 (old_content);
		_g_object_unref0 (new_content);
		block49_data_unref (_data49_);
		_data49_ = NULL;
		return;
	}
	_data49_->handler = (gulong) 0;
	_tmp33_ = _data49_->background;
	_tmp34_ = g_signal_connect_data (_tmp33_, "loaded", (GCallback) ___lambda62__gala_background_loaded, block49_data_ref (_data49_), (GClosureNotify) block49_data_unref, 0);
	_data49_->handler = _tmp34_;
	_tmp35_ = _data49_->background;
	g_object_set_data_full ((GObject*) _tmp35_, "background-loaded-handler", (gpointer) ((guintptr) _data49_->handler), NULL);
	_g_object_unref0 (old_content);
	_g_object_unref0 (new_content);
	block49_data_unref (_data49_);
	_data49_ = NULL;
}

void
gala_background_manager_set_size (GalaBackgroundManager* self,
                                  gfloat width,
                                  gfloat height)
{
	gboolean _tmp0_ = FALSE;
	MetaBackgroundActor* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->background_actor;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (width != _tmp3_) {
		_tmp0_ = TRUE;
	} else {
		MetaBackgroundActor* _tmp4_;
		gfloat _tmp5_;
		gfloat _tmp6_;
		_tmp4_ = self->priv->background_actor;
		_tmp5_ = clutter_actor_get_height ((ClutterActor*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = height != _tmp6_;
	}
	if (_tmp0_) {
		gala_background_manager_update_background_actor (self, FALSE);
	}
}

static Block50Data*
block50_data_ref (Block50Data* _data50_)
{
	g_atomic_int_inc (&_data50_->_ref_count_);
	return _data50_;
}

static void
block50_data_unref (void * _userdata_)
{
	Block50Data* _data50_;
	_data50_ = (Block50Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data50_->_ref_count_)) {
		GalaBackgroundManager* self;
		self = _data50_->self;
		_g_object_unref0 (_data50_->background);
		_g_object_unref0 (self);
		g_slice_free (Block50Data, _data50_);
	}
}

static void
_gala_background_manager_update_dim_wallpaper_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	gala_background_manager_update_dim_wallpaper ((GalaBackgroundManager*) self);
}

static void
_gala_background_manager_update_dim_wallpaper_g_settings_changed (GSettings* _sender,
                                                                  const gchar* key,
                                                                  gpointer self)
{
	gala_background_manager_update_dim_wallpaper ((GalaBackgroundManager*) self);
}

static void
__lambda60_ (Block50Data* _data50_)
{
	GalaBackgroundManager* self;
	GalaBackground* _tmp0_;
	self = _data50_->self;
	_tmp0_ = _data50_->background;
	g_signal_handler_disconnect (_tmp0_, _data50_->changed_handler);
	_data50_->changed_handler = (gulong) 0;
	gala_background_manager_update_background_actor (self, TRUE);
}

static void
___lambda60__gala_background_changed (GalaBackground* _sender,
                                      gpointer self)
{
	__lambda60_ (self);
}

static void
__lambda61_ (Block50Data* _data50_)
{
	GalaBackgroundManager* self;
	gulong loaded_handler = 0UL;
	GalaBackground* _tmp1_;
	gconstpointer _tmp2_;
	self = _data50_->self;
	if (_data50_->changed_handler != ((gulong) 0)) {
		GalaBackground* _tmp0_;
		_tmp0_ = _data50_->background;
		g_signal_handler_disconnect (_tmp0_, _data50_->changed_handler);
		_data50_->changed_handler = (gulong) 0;
	}
	_tmp1_ = _data50_->background;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "background-loaded-handler");
	loaded_handler = (gulong) ((guintptr) _tmp2_);
	if (loaded_handler != ((gulong) 0)) {
		GalaBackground* _tmp3_;
		GalaBackground* _tmp4_;
		_tmp3_ = _data50_->background;
		g_signal_handler_disconnect (_tmp3_, loaded_handler);
		_tmp4_ = _data50_->background;
		g_object_set_data_full ((GObject*) _tmp4_, "background-loaded-handler", (gpointer) ((guintptr) 0), NULL);
	}
}

static void
___lambda61__clutter_actor_destroy (ClutterActor* _sender,
                                    gpointer self)
{
	__lambda61_ (self);
}

static MetaBackgroundActor*
gala_background_manager_create_background_actor (GalaBackgroundManager* self)
{
	Block50Data* _data50_;
	GalaBackgroundSource* _tmp0_;
	gint _tmp1_;
	GalaBackground* _tmp2_;
	MetaBackgroundActor* background_actor = NULL;
	MetaDisplay* _tmp3_;
	gint _tmp4_;
	MetaBackgroundActor* _tmp5_;
	MetaBackgroundActor* _tmp6_;
	ClutterContent* _tmp7_;
	ClutterContent* _tmp8_;
	GalaBackground* _tmp9_;
	MetaBackground* _tmp10_;
	MetaBackground* _tmp11_;
	MetaBackgroundActor* _tmp12_;
	ClutterContent* _tmp13_;
	ClutterContent* _tmp14_;
	GraniteSettings* _tmp18_;
	GSettings* _tmp19_;
	gchar* _tmp20_;
	MetaBackgroundActor* _tmp21_;
	MetaRectangle monitor = {0};
	MetaDisplay* _tmp22_;
	gint _tmp23_;
	MetaRectangle _tmp24_ = {0};
	MetaBackgroundActor* _tmp25_;
	MetaRectangle _tmp26_;
	MetaRectangle _tmp27_;
	gboolean _tmp28_;
	GalaBackground* _tmp32_;
	gulong _tmp33_;
	MetaBackgroundActor* _tmp34_;
	MetaBackgroundActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data50_ = g_slice_new0 (Block50Data);
	_data50_->_ref_count_ = 1;
	_data50_->self = g_object_ref (self);
	_tmp0_ = self->priv->background_source;
	_tmp1_ = self->priv->_monitor_index;
	_tmp2_ = gala_background_source_get_background (_tmp0_, _tmp1_);
	_data50_->background = _tmp2_;
	_tmp3_ = self->priv->_display;
	_tmp4_ = self->priv->_monitor_index;
	_tmp5_ = (MetaBackgroundActor*) meta_background_actor_new (_tmp3_, _tmp4_);
	g_object_ref_sink (_tmp5_);
	background_actor = _tmp5_;
	_tmp6_ = background_actor;
	_tmp7_ = clutter_actor_get_content ((ClutterActor*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _data50_->background;
	_tmp10_ = gala_background_get_background (_tmp9_);
	_tmp11_ = _tmp10_;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, meta_background_content_get_type (), MetaBackgroundContent), "background", _tmp11_, NULL);
	_tmp12_ = background_actor;
	_tmp13_ = clutter_actor_get_content ((ClutterActor*) _tmp12_);
	_tmp14_ = _tmp13_;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, meta_background_content_get_type (), MetaBackgroundContent), "vignette", TRUE, NULL);
	if (gala_background_manager_should_dim (self)) {
		MetaBackgroundActor* _tmp15_;
		ClutterContent* _tmp16_;
		ClutterContent* _tmp17_;
		_tmp15_ = background_actor;
		_tmp16_ = clutter_actor_get_content ((ClutterActor*) _tmp15_);
		_tmp17_ = _tmp16_;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, meta_background_content_get_type (), MetaBackgroundContent), "brightness", GALA_BACKGROUND_MANAGER_DIM_OPACITY, NULL);
	}
	_tmp18_ = granite_settings_get_default ();
	g_signal_connect_object ((GObject*) _tmp18_, "notify::prefers-color-scheme", (GCallback) _gala_background_manager_update_dim_wallpaper_g_object_notify, self, 0);
	_tmp19_ = gala_background_manager_gala_background_settings;
	_tmp20_ = g_strconcat ("changed::", GALA_BACKGROUND_MANAGER_DIM_WALLPAPER_KEY, NULL);
	g_signal_connect_object (_tmp19_, _tmp20_, (GCallback) _gala_background_manager_update_dim_wallpaper_g_settings_changed, self, 0);
	_g_free0 (_tmp20_);
	_tmp21_ = background_actor;
	clutter_actor_insert_child_below ((ClutterActor*) self, (ClutterActor*) _tmp21_, NULL);
	_tmp22_ = self->priv->_display;
	_tmp23_ = self->priv->_monitor_index;
	meta_display_get_monitor_geometry (_tmp22_, _tmp23_, &_tmp24_);
	monitor = _tmp24_;
	_tmp25_ = background_actor;
	_tmp26_ = monitor;
	_tmp27_ = monitor;
	clutter_actor_set_size ((ClutterActor*) _tmp25_, (gfloat) _tmp26_.width, (gfloat) _tmp27_.height);
	_tmp28_ = self->priv->_control_position;
	if (_tmp28_) {
		MetaBackgroundActor* _tmp29_;
		MetaRectangle _tmp30_;
		MetaRectangle _tmp31_;
		_tmp29_ = background_actor;
		_tmp30_ = monitor;
		_tmp31_ = monitor;
		clutter_actor_set_position ((ClutterActor*) _tmp29_, (gfloat) _tmp30_.x, (gfloat) _tmp31_.y);
	}
	_data50_->changed_handler = (gulong) 0;
	_tmp32_ = _data50_->background;
	_tmp33_ = g_signal_connect_data (_tmp32_, "changed", (GCallback) ___lambda60__gala_background_changed, block50_data_ref (_data50_), (GClosureNotify) block50_data_unref, 0);
	_data50_->changed_handler = _tmp33_;
	_tmp34_ = background_actor;
	g_signal_connect_data ((ClutterActor*) _tmp34_, "destroy", (GCallback) ___lambda61__clutter_actor_destroy, block50_data_ref (_data50_), (GClosureNotify) block50_data_unref, 0);
	result = background_actor;
	block50_data_unref (_data50_);
	_data50_ = NULL;
	return result;
}

static gboolean
gala_background_manager_should_dim (GalaBackgroundManager* self)
{
	gboolean _tmp0_ = FALSE;
	GraniteSettings* _tmp1_;
	GraniteSettingsColorScheme _tmp2_;
	GraniteSettingsColorScheme _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = granite_settings_get_default ();
	_tmp2_ = granite_settings_get_prefers_color_scheme (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK) {
		GSettings* _tmp4_;
		_tmp4_ = gala_background_manager_gala_background_settings;
		_tmp0_ = g_settings_get_boolean (_tmp4_, GALA_BACKGROUND_MANAGER_DIM_WALLPAPER_KEY);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static Block51Data*
block51_data_ref (Block51Data* _data51_)
{
	g_atomic_int_inc (&_data51_->_ref_count_);
	return _data51_;
}

static void
block51_data_unref (void * _userdata_)
{
	Block51Data* _data51_;
	_data51_ = (Block51Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data51_->_ref_count_)) {
		GalaBackgroundManager* self;
		self = _data51_->self;
		_g_object_unref0 (_data51_->binding);
		_g_object_unref0 (_data51_->dim_actor);
		_g_object_unref0 (self);
		g_slice_free (Block51Data, _data51_);
	}
}

static void
__lambda59_ (Block51Data* _data51_)
{
	GalaBackgroundManager* self;
	GBinding* _tmp0_;
	GBinding* _tmp1_;
	MetaBackgroundActor* _tmp2_;
	GalaBackgroundManagerOpacityDimActor* _tmp3_;
	GalaBackgroundManagerOpacityDimActor* _tmp4_;
	self = _data51_->self;
	_tmp0_ = _data51_->binding;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	g_binding_unbind (_tmp1_);
	_tmp2_ = self->priv->background_actor;
	_tmp3_ = _data51_->dim_actor;
	clutter_actor_remove_child ((ClutterActor*) _tmp2_, (ClutterActor*) _tmp3_);
	_tmp4_ = _data51_->dim_actor;
	clutter_actor_destroy ((ClutterActor*) _tmp4_);
}

static void
___lambda59__clutter_timeline_completed (ClutterTimeline* _sender,
                                         gpointer self)
{
	__lambda59_ (self);
}

static void
gala_background_manager_update_dim_wallpaper (GalaBackgroundManager* self)
{
	Block51Data* _data51_;
	ClutterPropertyTransition* _tmp0_;
	GalaBackgroundManagerOpacityDimActor* _tmp2_;
	MetaBackgroundActor* _tmp3_;
	GalaBackgroundManagerOpacityDimActor* _tmp4_;
	GalaBackgroundManagerOpacityDimActor* _tmp5_;
	MetaBackgroundActor* _tmp6_;
	ClutterContent* _tmp7_;
	ClutterContent* _tmp8_;
	GBinding* _tmp9_;
	GBinding* _tmp10_;
	ClutterPropertyTransition* transition = NULL;
	ClutterPropertyTransition* _tmp11_;
	ClutterPropertyTransition* _tmp12_;
	MetaBackgroundActor* _tmp13_;
	ClutterContent* _tmp14_;
	ClutterContent* _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	GValue _tmp18_ = {0};
	gdouble _tmp19_ = 0.0;
	ClutterPropertyTransition* _tmp20_;
	GValue _tmp21_ = {0};
	ClutterPropertyTransition* _tmp22_;
	ClutterPropertyTransition* _tmp23_;
	ClutterPropertyTransition* _tmp24_;
	ClutterPropertyTransition* _tmp25_;
	GalaBackgroundManagerOpacityDimActor* _tmp26_;
	ClutterPropertyTransition* _tmp27_;
	ClutterPropertyTransition* _tmp28_;
	ClutterPropertyTransition* _tmp29_;
	g_return_if_fail (self != NULL);
	_data51_ = g_slice_new0 (Block51Data);
	_data51_->_ref_count_ = 1;
	_data51_->self = g_object_ref (self);
	_tmp0_ = self->priv->last_dim_transition;
	if (_tmp0_ != NULL) {
		ClutterPropertyTransition* _tmp1_;
		_tmp1_ = self->priv->last_dim_transition;
		clutter_timeline_stop ((ClutterTimeline*) _tmp1_);
	}
	_tmp2_ = gala_background_manager_opacity_dim_actor_new ();
	g_object_ref_sink (_tmp2_);
	_data51_->dim_actor = _tmp2_;
	_tmp3_ = self->priv->background_actor;
	_tmp4_ = _data51_->dim_actor;
	clutter_actor_add_child ((ClutterActor*) _tmp3_, (ClutterActor*) _tmp4_);
	_tmp5_ = _data51_->dim_actor;
	_tmp6_ = self->priv->background_actor;
	_tmp7_ = clutter_actor_get_content ((ClutterActor*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_object_bind_property_with_closures ((GObject*) _tmp5_, "opacity", (GObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, meta_background_content_get_type (), MetaBackgroundContent), "brightness", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_data51_->binding = _tmp10_;
	_tmp11_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
	transition = _tmp11_;
	_tmp12_ = transition;
	_tmp13_ = self->priv->background_actor;
	_tmp14_ = clutter_actor_get_content ((ClutterActor*) _tmp13_);
	_tmp15_ = _tmp14_;
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, meta_background_content_get_type (), MetaBackgroundContent), "brightness", &_tmp16_, NULL);
	_tmp17_ = _tmp16_;
	g_value_init (&_tmp18_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp18_, _tmp17_);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp12_, &_tmp18_);
	G_IS_VALUE (&_tmp18_) ? (g_value_unset (&_tmp18_), NULL) : NULL;
	if (gala_background_manager_should_dim (self)) {
		_tmp19_ = GALA_BACKGROUND_MANAGER_DIM_OPACITY;
	} else {
		_tmp19_ = 1.0;
	}
	_tmp20_ = transition;
	g_value_init (&_tmp21_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp21_, _tmp19_);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp20_, &_tmp21_);
	G_IS_VALUE (&_tmp21_) ? (g_value_unset (&_tmp21_), NULL) : NULL;
	_tmp22_ = transition;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp22_, (guint) GALA_BACKGROUND_MANAGER_FADE_ANIMATION_TIME);
	_tmp23_ = transition;
	clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp23_, CLUTTER_EASE_OUT_QUAD);
	_tmp24_ = transition;
	clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp24_, TRUE);
	_tmp25_ = transition;
	g_signal_connect_data ((ClutterTimeline*) _tmp25_, "completed", (GCallback) ___lambda59__clutter_timeline_completed, block51_data_ref (_data51_), (GClosureNotify) block51_data_unref, 0);
	_tmp26_ = _data51_->dim_actor;
	_tmp27_ = transition;
	clutter_actor_add_transition ((ClutterActor*) _tmp26_, "wallpaper-dim", (ClutterTransition*) _tmp27_);
	_tmp28_ = transition;
	_tmp29_ = _g_object_ref0 (_tmp28_);
	_g_object_unref0 (self->priv->last_dim_transition);
	self->priv->last_dim_transition = _tmp29_;
	_g_object_unref0 (transition);
	block51_data_unref (_data51_);
	_data51_ = NULL;
}

MetaDisplay*
gala_background_manager_get_display (GalaBackgroundManager* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
gala_background_manager_set_display (GalaBackgroundManager* self,
                                     MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_manager_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_DISPLAY_PROPERTY]);
	}
}

gint
gala_background_manager_get_monitor_index (GalaBackgroundManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_monitor_index;
	return result;
}

static void
gala_background_manager_set_monitor_index (GalaBackgroundManager* self,
                                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_manager_get_monitor_index (self);
	if (old_value != value) {
		self->priv->_monitor_index = value;
		g_object_notify_by_pspec ((GObject *) self, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY]);
	}
}

gboolean
gala_background_manager_get_control_position (GalaBackgroundManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_control_position;
	return result;
}

static void
gala_background_manager_set_control_position (GalaBackgroundManager* self,
                                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_manager_get_control_position (self);
	if (old_value != value) {
		self->priv->_control_position = value;
		g_object_notify_by_pspec ((GObject *) self, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY]);
	}
}

static inline gpointer
gala_background_manager_opacity_dim_actor_get_instance_private (GalaBackgroundManagerOpacityDimActor* self)
{
	return G_STRUCT_MEMBER_P (self, GalaBackgroundManagerOpacityDimActor_private_offset);
}

static GalaBackgroundManagerOpacityDimActor*
gala_background_manager_opacity_dim_actor_construct (GType object_type)
{
	GalaBackgroundManagerOpacityDimActor * self = NULL;
	self = (GalaBackgroundManagerOpacityDimActor*) g_object_new (object_type, NULL);
	return self;
}

static GalaBackgroundManagerOpacityDimActor*
gala_background_manager_opacity_dim_actor_new (void)
{
	return gala_background_manager_opacity_dim_actor_construct (GALA_BACKGROUND_MANAGER_TYPE_OPACITY_DIM_ACTOR);
}

static gdouble
gala_background_manager_opacity_dim_actor_get_opacity (GalaBackgroundManagerOpacityDimActor* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_opacity;
	return result;
}

static void
gala_background_manager_opacity_dim_actor_set_opacity (GalaBackgroundManagerOpacityDimActor* self,
                                                       gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_manager_opacity_dim_actor_get_opacity (self);
	if (old_value != value) {
		self->priv->_opacity = value;
		g_object_notify_by_pspec ((GObject *) self, gala_background_manager_opacity_dim_actor_properties[GALA_BACKGROUND_MANAGER_OPACITY_DIM_ACTOR_OPACITY_PROPERTY]);
	}
}

static void
gala_background_manager_opacity_dim_actor_class_init (GalaBackgroundManagerOpacityDimActorClass * klass,
                                                      gpointer klass_data)
{
	gala_background_manager_opacity_dim_actor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaBackgroundManagerOpacityDimActor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_background_manager_opacity_dim_actor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_background_manager_opacity_dim_actor_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_background_manager_opacity_dim_actor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_MANAGER_OPACITY_DIM_ACTOR_OPACITY_PROPERTY, gala_background_manager_opacity_dim_actor_properties[GALA_BACKGROUND_MANAGER_OPACITY_DIM_ACTOR_OPACITY_PROPERTY] = g_param_spec_double ("opacity", "opacity", "opacity", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gala_background_manager_opacity_dim_actor_instance_init (GalaBackgroundManagerOpacityDimActor * self,
                                                         gpointer klass)
{
	self->priv = gala_background_manager_opacity_dim_actor_get_instance_private (self);
}

static void
gala_background_manager_opacity_dim_actor_finalize (GObject * obj)
{
	GalaBackgroundManagerOpacityDimActor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_BACKGROUND_MANAGER_TYPE_OPACITY_DIM_ACTOR, GalaBackgroundManagerOpacityDimActor);
	G_OBJECT_CLASS (gala_background_manager_opacity_dim_actor_parent_class)->finalize (obj);
}

static GType
gala_background_manager_opacity_dim_actor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaBackgroundManagerOpacityDimActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_background_manager_opacity_dim_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaBackgroundManagerOpacityDimActor), 0, (GInstanceInitFunc) gala_background_manager_opacity_dim_actor_instance_init, NULL };
	GType gala_background_manager_opacity_dim_actor_type_id;
	gala_background_manager_opacity_dim_actor_type_id = g_type_register_static (clutter_actor_get_type (), "GalaBackgroundManagerOpacityDimActor", &g_define_type_info, 0);
	GalaBackgroundManagerOpacityDimActor_private_offset = g_type_add_instance_private (gala_background_manager_opacity_dim_actor_type_id, sizeof (GalaBackgroundManagerOpacityDimActorPrivate));
	return gala_background_manager_opacity_dim_actor_type_id;
}

static GType
gala_background_manager_opacity_dim_actor_get_type (void)
{
	static volatile gsize gala_background_manager_opacity_dim_actor_type_id__once = 0;
	if (g_once_init_enter (&gala_background_manager_opacity_dim_actor_type_id__once)) {
		GType gala_background_manager_opacity_dim_actor_type_id;
		gala_background_manager_opacity_dim_actor_type_id = gala_background_manager_opacity_dim_actor_get_type_once ();
		g_once_init_leave (&gala_background_manager_opacity_dim_actor_type_id__once, gala_background_manager_opacity_dim_actor_type_id);
	}
	return gala_background_manager_opacity_dim_actor_type_id__once;
}

static void
_vala_gala_background_manager_opacity_dim_actor_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec)
{
	GalaBackgroundManagerOpacityDimActor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_BACKGROUND_MANAGER_TYPE_OPACITY_DIM_ACTOR, GalaBackgroundManagerOpacityDimActor);
	switch (property_id) {
		case GALA_BACKGROUND_MANAGER_OPACITY_DIM_ACTOR_OPACITY_PROPERTY:
		g_value_set_double (value, gala_background_manager_opacity_dim_actor_get_opacity (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_background_manager_opacity_dim_actor_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec)
{
	GalaBackgroundManagerOpacityDimActor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_BACKGROUND_MANAGER_TYPE_OPACITY_DIM_ACTOR, GalaBackgroundManagerOpacityDimActor);
	switch (property_id) {
		case GALA_BACKGROUND_MANAGER_OPACITY_DIM_ACTOR_OPACITY_PROPERTY:
		gala_background_manager_opacity_dim_actor_set_opacity (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_gala_background_manager_on_destroy_clutter_actor_destroy (ClutterActor* _sender,
                                                           gpointer self)
{
	gala_background_manager_on_destroy ((GalaBackgroundManager*) self);
}

static GObject *
gala_background_manager_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaBackgroundManager * self;
	GalaBackgroundCache* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaBackgroundSource* _tmp2_;
	MetaBackgroundActor* _tmp3_;
	parent_class = G_OBJECT_CLASS (gala_background_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager);
	_tmp0_ = gala_background_cache_get_default ();
	_tmp1_ = self->priv->_display;
	_tmp2_ = gala_background_cache_get_background_source (_tmp0_, _tmp1_, GALA_BACKGROUND_MANAGER_GNOME_BACKGROUND_SCHEMA);
	_g_object_unref0 (self->priv->background_source);
	self->priv->background_source = _tmp2_;
	_tmp3_ = gala_background_manager_create_background_actor (self);
	_g_object_unref0 (self->priv->background_actor);
	self->priv->background_actor = _tmp3_;
	g_signal_connect_object ((ClutterActor*) self, "destroy", (GCallback) _gala_background_manager_on_destroy_clutter_actor_destroy, self, 0);
	return obj;
}

static void
gala_background_manager_class_init (GalaBackgroundManagerClass * klass,
                                    gpointer klass_data)
{
	GSettings* _tmp0_;
	gala_background_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaBackgroundManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_background_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_background_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_background_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_background_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_MANAGER_DISPLAY_PROPERTY, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY] = g_param_spec_int ("monitor-index", "monitor-index", "monitor-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY] = g_param_spec_boolean ("control-position", "control-position", "control-position", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gala_background_manager_signals[GALA_BACKGROUND_MANAGER_CHANGED_SIGNAL] = g_signal_new ("changed", GALA_TYPE_BACKGROUND_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_settings_new (GALA_BACKGROUND_MANAGER_GALA_BACKGROUND_SCHEMA);
	_g_object_unref0 (gala_background_manager_gala_background_settings);
	gala_background_manager_gala_background_settings = _tmp0_;
}

static void
gala_background_manager_instance_init (GalaBackgroundManager * self,
                                       gpointer klass)
{
	self->priv = gala_background_manager_get_instance_private (self);
	self->priv->new_background_actor = NULL;
	self->priv->last_dim_transition = NULL;
}

static void
gala_background_manager_finalize (GObject * obj)
{
	GalaBackgroundManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->background_source);
	_g_object_unref0 (self->priv->background_actor);
	_g_object_unref0 (self->priv->new_background_actor);
	_g_object_unref0 (self->priv->last_dim_transition);
	G_OBJECT_CLASS (gala_background_manager_parent_class)->finalize (obj);
}

static GType
gala_background_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaBackgroundManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_background_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaBackgroundManager), 0, (GInstanceInitFunc) gala_background_manager_instance_init, NULL };
	GType gala_background_manager_type_id;
	gala_background_manager_type_id = g_type_register_static (meta_background_group_get_type (), "GalaBackgroundManager", &g_define_type_info, 0);
	GalaBackgroundManager_private_offset = g_type_add_instance_private (gala_background_manager_type_id, sizeof (GalaBackgroundManagerPrivate));
	return gala_background_manager_type_id;
}

GType
gala_background_manager_get_type (void)
{
	static volatile gsize gala_background_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_background_manager_type_id__once)) {
		GType gala_background_manager_type_id;
		gala_background_manager_type_id = gala_background_manager_get_type_once ();
		g_once_init_leave (&gala_background_manager_type_id__once, gala_background_manager_type_id);
	}
	return gala_background_manager_type_id__once;
}

static void
_vala_gala_background_manager_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GalaBackgroundManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager);
	switch (property_id) {
		case GALA_BACKGROUND_MANAGER_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_background_manager_get_display (self));
		break;
		case GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY:
		g_value_set_int (value, gala_background_manager_get_monitor_index (self));
		break;
		case GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY:
		g_value_set_boolean (value, gala_background_manager_get_control_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_background_manager_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GalaBackgroundManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager);
	switch (property_id) {
		case GALA_BACKGROUND_MANAGER_DISPLAY_PROPERTY:
		gala_background_manager_set_display (self, g_value_get_object (value));
		break;
		case GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY:
		gala_background_manager_set_monitor_index (self, g_value_get_int (value));
		break;
		case GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY:
		gala_background_manager_set_control_position (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

