/* DwellClickTimer.c generated by valac 0.56.3, the Vala compiler
 * generated from DwellClickTimer.vala, do not modify */

/**/
/*  Copyright 2020 elementary, Inc. (https://elementary.io)*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <clutter/clutter.h>
#include <glib-object.h>
#include <glib.h>
#include <cogl/cogl.h>
#include <cairo-gobject.h>
#include <gio/gio.h>
#include "gala.h"
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <meta/meta-cursor-tracker.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <graphene-gobject.h>

#define GALA_DWELL_CLICK_TIMER_BACKGROUND_OPACITY 0.7
#define GALA_DWELL_CLICK_TIMER_BORDER_WIDTH_PX ((guint) 1)
#define GALA_DWELL_CLICK_TIMER_START_ANGLE ((3 * G_PI) / 2)
#define GALA_DWELL_CLICK_TIMER_DELAY_TIMEOUT ((gdouble) 185)
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_DWELL_CLICK_TIMER (gala_dwell_click_timer_get_type ())
#define GALA_DWELL_CLICK_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_DWELL_CLICK_TIMER, GalaDwellClickTimer))
#define GALA_DWELL_CLICK_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_DWELL_CLICK_TIMER, GalaDwellClickTimerClass))
#define GALA_IS_DWELL_CLICK_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_DWELL_CLICK_TIMER))
#define GALA_IS_DWELL_CLICK_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_DWELL_CLICK_TIMER))
#define GALA_DWELL_CLICK_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_DWELL_CLICK_TIMER, GalaDwellClickTimerClass))

typedef struct _GalaDwellClickTimer GalaDwellClickTimer;
typedef struct _GalaDwellClickTimerClass GalaDwellClickTimerClass;
typedef struct _GalaDwellClickTimerPrivate GalaDwellClickTimerPrivate;
enum  {
	GALA_DWELL_CLICK_TIMER_0_PROPERTY,
	GALA_DWELL_CLICK_TIMER_WM_PROPERTY,
	GALA_DWELL_CLICK_TIMER_ANGLE_PROPERTY,
	GALA_DWELL_CLICK_TIMER_NUM_PROPERTIES
};
static GParamSpec* gala_dwell_click_timer_properties[GALA_DWELL_CLICK_TIMER_NUM_PROPERTIES];
#define _cogl_object_unref0(var) ((var == NULL) ? NULL : (var = (cogl_object_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _GalaDwellClickTimer {
	ClutterActor parent_instance;
	GalaDwellClickTimerPrivate * priv;
};

struct _GalaDwellClickTimerClass {
	ClutterActorClass parent_class;
};

struct _GalaDwellClickTimerPrivate {
	gint scaling_factor;
	gint cursor_size;
	CoglPipeline* pipeline;
	ClutterPropertyTransition* transition;
	cairo_pattern_t* stroke_color;
	cairo_pattern_t* fill_color;
	GSettings* interface_settings;
	cairo_surface_t* surface;
	GalaWindowManager* _wm;
	gdouble _angle;
};

static gint GalaDwellClickTimer_private_offset;
static gpointer gala_dwell_click_timer_parent_class = NULL;
static ClutterAnimatableInterface * gala_dwell_click_timer_clutter_animatable_parent_iface = NULL;

VALA_EXTERN GType gala_dwell_click_timer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDwellClickTimer, g_object_unref)
VALA_EXTERN GalaDwellClickTimer* gala_dwell_click_timer_new (GalaWindowManager* wm);
VALA_EXTERN GalaDwellClickTimer* gala_dwell_click_timer_construct (GType object_type,
                                                       GalaWindowManager* wm);
static void gala_dwell_click_timer_update_cursor_size (GalaDwellClickTimer* self);
static void gala_dwell_click_timer_real_paint (ClutterActor* base,
                                        ClutterPaintContext* context);
VALA_EXTERN gdouble gala_dwell_click_timer_get_angle (GalaDwellClickTimer* self);
VALA_EXTERN void gala_internal_utils_get_theme_accent_color (GdkRGBA* result);
static gboolean gala_dwell_click_timer_real_interpolate_value (ClutterAnimatable* base,
                                                        const gchar* property_name,
                                                        ClutterInterval* interval,
                                                        gdouble progress,
                                                        GValue* value);
VALA_EXTERN GalaWindowManager* gala_dwell_click_timer_get_wm (GalaDwellClickTimer* self);
static void gala_dwell_click_timer_set_wm (GalaDwellClickTimer* self,
                                    GalaWindowManager* value);
VALA_EXTERN void gala_dwell_click_timer_set_angle (GalaDwellClickTimer* self,
                                       gdouble value);
static GObject * gala_dwell_click_timer_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _gala_dwell_click_timer___lambda65_ (GalaDwellClickTimer* self);
static void __gala_dwell_click_timer___lambda65__clutter_timeline_new_frame (ClutterTimeline* _sender,
                                                                      gint msecs,
                                                                      gpointer self);
VALA_EXTERN gint gala_internal_utils_get_ui_scaling_factor (void);
static void _gala_dwell_click_timer___lambda66_ (GalaDwellClickTimer* self,
                                          ClutterInputDevice* device,
                                          ClutterPointerA11yTimeoutType type,
                                          guint timeout);
static void __gala_dwell_click_timer___lambda66__clutter_seat_ptr_a11y_timeout_started (ClutterSeat* _sender,
                                                                                 ClutterInputDevice* device,
                                                                                 ClutterPointerA11yTimeoutType timeout_type,
                                                                                 guint delay,
                                                                                 gpointer self);
static void _gala_dwell_click_timer___lambda67_ (GalaDwellClickTimer* self,
                                          ClutterInputDevice* device,
                                          ClutterPointerA11yTimeoutType type,
                                          gboolean clicked);
static void __gala_dwell_click_timer___lambda67__clutter_seat_ptr_a11y_timeout_stopped (ClutterSeat* _sender,
                                                                                 ClutterInputDevice* device,
                                                                                 ClutterPointerA11yTimeoutType timeout_type,
                                                                                 gboolean clicked,
                                                                                 gpointer self);
static void _gala_dwell_click_timer___lambda68_ (GalaDwellClickTimer* self);
static void __gala_dwell_click_timer___lambda68__g_settings_changed (GSettings* _sender,
                                                              const gchar* key,
                                                              gpointer self);
static void gala_dwell_click_timer_finalize (GObject * obj);
static GType gala_dwell_click_timer_get_type_once (void);
static void _vala_gala_dwell_click_timer_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_gala_dwell_click_timer_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_dwell_click_timer_get_instance_private (GalaDwellClickTimer* self)
{
	return G_STRUCT_MEMBER_P (self, GalaDwellClickTimer_private_offset);
}

GalaDwellClickTimer*
gala_dwell_click_timer_construct (GType object_type,
                                  GalaWindowManager* wm)
{
	GalaDwellClickTimer * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaDwellClickTimer*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

GalaDwellClickTimer*
gala_dwell_click_timer_new (GalaWindowManager* wm)
{
	return gala_dwell_click_timer_construct (GALA_TYPE_DWELL_CLICK_TIMER, wm);
}

static void
gala_dwell_click_timer_update_cursor_size (GalaDwellClickTimer* self)
{
	GSettings* _tmp0_;
	cairo_surface_t* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->interface_settings;
	self->priv->cursor_size = (gint) ((g_settings_get_int (_tmp0_, "cursor-size") * self->priv->scaling_factor) * 1.25);
	_tmp1_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, self->priv->cursor_size, self->priv->cursor_size);
	_cairo_surface_destroy0 (self->priv->surface);
	self->priv->surface = _tmp1_;
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) self->priv->cursor_size, (gfloat) self->priv->cursor_size);
}

static gpointer
_cogl_object_ref0 (gpointer self)
{
	return self ? cogl_object_ref (self) : NULL;
}

static void
gala_dwell_click_timer_real_paint (ClutterActor* base,
                                   ClutterPaintContext* context)
{
	GalaDwellClickTimer * self;
	gdouble _tmp0_;
	GdkRGBA rgba = {0};
	GdkRGBA _tmp1_ = {0};
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	GdkRGBA _tmp4_;
	cairo_pattern_t* _tmp5_;
	GdkRGBA _tmp6_;
	GdkRGBA _tmp7_;
	GdkRGBA _tmp8_;
	cairo_pattern_t* _tmp9_;
	gint radius = 0;
	gdouble end_angle = 0.0;
	gdouble _tmp10_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp11_;
	cairo_t* _tmp12_;
	cairo_t* _tmp13_;
	cairo_t* _tmp14_;
	cairo_t* _tmp15_;
	cairo_t* _tmp16_;
	cairo_t* _tmp17_;
	cairo_t* _tmp18_;
	cairo_t* _tmp19_;
	cairo_t* _tmp20_;
	cairo_t* _tmp21_;
	cairo_t* _tmp22_;
	cairo_t* _tmp23_;
	cairo_t* _tmp24_;
	cairo_t* _tmp25_;
	cairo_t* _tmp26_;
	cairo_pattern_t* _tmp27_;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	cairo_t* _tmp30_;
	cairo_pattern_t* _tmp31_;
	cairo_t* _tmp32_;
	CoglContext* cogl_context = NULL;
	CoglFramebuffer* _tmp33_;
	CoglContext* _tmp34_;
	CoglContext* _tmp35_;
	GError* _inner_error0_ = NULL;
	self = (GalaDwellClickTimer*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->_angle;
	if (_tmp0_ == ((gdouble) 0)) {
		return;
	}
	gala_internal_utils_get_theme_accent_color (&_tmp1_);
	rgba = _tmp1_;
	_tmp2_ = rgba;
	_tmp3_ = rgba;
	_tmp4_ = rgba;
	_tmp5_ = cairo_pattern_create_rgb (_tmp2_.red, _tmp3_.green, _tmp4_.blue);
	_cairo_pattern_destroy0 (self->priv->stroke_color);
	self->priv->stroke_color = _tmp5_;
	_tmp6_ = rgba;
	_tmp7_ = rgba;
	_tmp8_ = rgba;
	_tmp9_ = cairo_pattern_create_rgba (_tmp6_.red, _tmp7_.green, _tmp8_.blue, GALA_DWELL_CLICK_TIMER_BACKGROUND_OPACITY);
	_cairo_pattern_destroy0 (self->priv->fill_color);
	self->priv->fill_color = _tmp9_;
	radius = MIN (self->priv->cursor_size / 2, self->priv->cursor_size / 2);
	_tmp10_ = self->priv->_angle;
	end_angle = GALA_DWELL_CLICK_TIMER_START_ANGLE + _tmp10_;
	_tmp11_ = self->priv->surface;
	_tmp12_ = cairo_create (_tmp11_);
	cr = _tmp12_;
	_tmp13_ = cr;
	cairo_save (_tmp13_);
	_tmp14_ = cr;
	cairo_set_source_rgba (_tmp14_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp15_ = cr;
	cairo_set_operator (_tmp15_, CAIRO_OPERATOR_SOURCE);
	_tmp16_ = cr;
	cairo_paint (_tmp16_);
	_tmp17_ = cr;
	cairo_restore (_tmp17_);
	_tmp18_ = cr;
	cairo_set_line_cap (_tmp18_, CAIRO_LINE_CAP_ROUND);
	_tmp19_ = cr;
	cairo_set_line_join (_tmp19_, CAIRO_LINE_JOIN_ROUND);
	_tmp20_ = cr;
	cairo_translate (_tmp20_, (gdouble) (self->priv->cursor_size / 2), (gdouble) (self->priv->cursor_size / 2));
	_tmp21_ = cr;
	cairo_move_to (_tmp21_, (gdouble) 0, (gdouble) 0);
	_tmp22_ = cr;
	cairo_arc (_tmp22_, (gdouble) 0, (gdouble) 0, (gdouble) (radius - (GALA_DWELL_CLICK_TIMER_BORDER_WIDTH_PX * self->priv->scaling_factor)), GALA_DWELL_CLICK_TIMER_START_ANGLE, end_angle);
	_tmp23_ = cr;
	cairo_line_to (_tmp23_, (gdouble) 0, (gdouble) 0);
	_tmp24_ = cr;
	cairo_close_path (_tmp24_);
	_tmp25_ = cr;
	cairo_set_line_width (_tmp25_, (gdouble) 0);
	_tmp26_ = cr;
	_tmp27_ = self->priv->fill_color;
	cairo_set_source (_tmp26_, _tmp27_);
	_tmp28_ = cr;
	cairo_fill_preserve (_tmp28_);
	_tmp29_ = cr;
	cairo_set_line_width (_tmp29_, (gdouble) (GALA_DWELL_CLICK_TIMER_BORDER_WIDTH_PX * self->priv->scaling_factor));
	_tmp30_ = cr;
	_tmp31_ = self->priv->stroke_color;
	cairo_set_source (_tmp30_, _tmp31_);
	_tmp32_ = cr;
	cairo_stroke (_tmp32_);
	_tmp33_ = clutter_paint_context_get_framebuffer (context);
	_tmp34_ = cogl_framebuffer_get_context (_tmp33_);
	_tmp35_ = _cogl_object_ref0 (_tmp34_);
	cogl_context = _tmp35_;
	{
		CoglTexture2D* texture = NULL;
		CoglContext* _tmp36_;
		cairo_surface_t* _tmp37_;
		cairo_surface_t* _tmp38_;
		guchar* _tmp39_;
		CoglTexture2D* _tmp40_;
		CoglPipeline* _tmp41_;
		CoglTexture2D* _tmp42_;
		CoglFramebuffer* _tmp43_;
		CoglPipeline* _tmp44_;
		_tmp36_ = cogl_context;
		_tmp37_ = self->priv->surface;
		_tmp38_ = self->priv->surface;
		_tmp39_ = cairo_image_surface_get_data (_tmp38_);
		_tmp40_ = cogl_texture_2d_new_from_data (_tmp36_, self->priv->cursor_size, self->priv->cursor_size, COGL_PIXEL_FORMAT_BGRA_8888_PRE, cairo_image_surface_get_stride (_tmp37_), (const uint8_t*) _tmp39_, &_inner_error0_);
		texture = _tmp40_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp41_ = self->priv->pipeline;
		_tmp42_ = texture;
		cogl_pipeline_set_layer_texture (_tmp41_, 0, (CoglTexture*) _tmp42_);
		_tmp43_ = clutter_paint_context_get_framebuffer (context);
		_tmp44_ = self->priv->pipeline;
		cogl_framebuffer_draw_rectangle (_tmp43_, _tmp44_, (gfloat) 0, (gfloat) 0, (gfloat) self->priv->cursor_size, (gfloat) self->priv->cursor_size);
		_cogl_object_unref0 (texture);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_cogl_object_unref0 (cogl_context);
		_cairo_destroy0 (cr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	CLUTTER_ACTOR_CLASS (gala_dwell_click_timer_parent_class)->paint (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor), context);
	_cogl_object_unref0 (cogl_context);
	_cairo_destroy0 (cr);
}

static gboolean
gala_dwell_click_timer_real_interpolate_value (ClutterAnimatable* base,
                                               const gchar* property_name,
                                               ClutterInterval* interval,
                                               gdouble progress,
                                               GValue* value)
{
	GalaDwellClickTimer * self;
	GValue _vala_value = {0};
	GValue _tmp6_ = {0};
	gboolean _tmp7_;
	gboolean result;
	self = (GalaDwellClickTimer*) base;
	g_return_val_if_fail (property_name != NULL, FALSE);
	g_return_val_if_fail (interval != NULL, FALSE);
	if (g_strcmp0 (property_name, "angle") == 0) {
		GValue _tmp0_ = {0};
		guint elapsed_time = 0U;
		ClutterPropertyTransition* _tmp1_;
		g_value_init (&_tmp0_, G_TYPE_INT);
		g_value_set_int (&_tmp0_, 0);
		G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
		_vala_value = _tmp0_;
		_tmp1_ = self->priv->transition;
		elapsed_time = clutter_timeline_get_elapsed_time ((ClutterTimeline*) _tmp1_);
		if (((gdouble) elapsed_time) > GALA_DWELL_CLICK_TIMER_DELAY_TIMEOUT) {
			gdouble delayed_progress = 0.0;
			ClutterPropertyTransition* _tmp2_;
			guint _tmp3_;
			guint _tmp4_;
			GValue _tmp5_ = {0};
			_tmp2_ = self->priv->transition;
			_tmp3_ = clutter_timeline_get_duration ((ClutterTimeline*) _tmp2_);
			_tmp4_ = _tmp3_;
			delayed_progress = (elapsed_time - GALA_DWELL_CLICK_TIMER_DELAY_TIMEOUT) / (_tmp4_ - GALA_DWELL_CLICK_TIMER_DELAY_TIMEOUT);
			g_value_init (&_tmp5_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp5_, (delayed_progress * 2) * G_PI);
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
			_vala_value = _tmp5_;
		}
		result = TRUE;
		if (value) {
			*value = _vala_value;
		} else {
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
		}
		return result;
	}
	_tmp7_ = gala_dwell_click_timer_clutter_animatable_parent_iface->interpolate_value ((ClutterAnimatable*) G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor), property_name, interval, progress, &_tmp6_);
	G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
	_vala_value = _tmp6_;
	result = _tmp7_;
	if (value) {
		*value = _vala_value;
	} else {
		G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
	}
	return result;
}

GalaWindowManager*
gala_dwell_click_timer_get_wm (GalaDwellClickTimer* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_dwell_click_timer_set_wm (GalaDwellClickTimer* self,
                               GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_dwell_click_timer_get_wm (self);
	if (old_value != value) {
		self->priv->_wm = value;
		g_object_notify_by_pspec ((GObject *) self, gala_dwell_click_timer_properties[GALA_DWELL_CLICK_TIMER_WM_PROPERTY]);
	}
}

gdouble
gala_dwell_click_timer_get_angle (GalaDwellClickTimer* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_angle;
	return result;
}

void
gala_dwell_click_timer_set_angle (GalaDwellClickTimer* self,
                                  gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_dwell_click_timer_get_angle (self);
	if (old_value != value) {
		self->priv->_angle = value;
		g_object_notify_by_pspec ((GObject *) self, gala_dwell_click_timer_properties[GALA_DWELL_CLICK_TIMER_ANGLE_PROPERTY]);
	}
}

static void
_gala_dwell_click_timer___lambda65_ (GalaDwellClickTimer* self)
{
	clutter_actor_queue_redraw ((ClutterActor*) self);
}

static void
__gala_dwell_click_timer___lambda65__clutter_timeline_new_frame (ClutterTimeline* _sender,
                                                                 gint msecs,
                                                                 gpointer self)
{
	_gala_dwell_click_timer___lambda65_ ((GalaDwellClickTimer*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_gala_dwell_click_timer___lambda66_ (GalaDwellClickTimer* self,
                                     ClutterInputDevice* device,
                                     ClutterPointerA11yTimeoutType type,
                                     guint timeout)
{
	MetaCursorTracker* tracker = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaCursorTracker* _tmp2_;
	MetaCursorTracker* _tmp3_;
	graphene_point_t coords = {0};
	graphene_point_t _tmp4_ = {0};
	MetaCursorTracker* _tmp5_;
	graphene_point_t _tmp6_ = {0};
	graphene_point_t _tmp7_;
	gfloat _tmp8_;
	gfloat _tmp9_;
	graphene_point_t _tmp10_;
	gfloat _tmp11_;
	gfloat _tmp12_;
	ClutterPropertyTransition* _tmp13_;
	ClutterPropertyTransition* _tmp14_;
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_cursor_tracker_get_for_display (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	tracker = _tmp3_;
	coords = _tmp4_;
	_tmp5_ = tracker;
	meta_cursor_tracker_get_pointer (_tmp5_, &_tmp6_, NULL);
	coords = _tmp6_;
	_tmp7_ = coords;
	_tmp8_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp9_ = _tmp8_;
	clutter_actor_set_x ((ClutterActor*) self, _tmp7_.x - (_tmp9_ / 2));
	_tmp10_ = coords;
	_tmp11_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp12_ = _tmp11_;
	clutter_actor_set_y ((ClutterActor*) self, _tmp10_.y - (_tmp12_ / 2));
	_tmp13_ = self->priv->transition;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp13_, timeout);
	g_object_set ((ClutterActor*) self, "visible", TRUE, NULL);
	_tmp14_ = self->priv->transition;
	clutter_timeline_start ((ClutterTimeline*) _tmp14_);
	_g_object_unref0 (tracker);
}

static void
__gala_dwell_click_timer___lambda66__clutter_seat_ptr_a11y_timeout_started (ClutterSeat* _sender,
                                                                            ClutterInputDevice* device,
                                                                            ClutterPointerA11yTimeoutType timeout_type,
                                                                            guint delay,
                                                                            gpointer self)
{
	_gala_dwell_click_timer___lambda66_ ((GalaDwellClickTimer*) self, device, timeout_type, delay);
}

static void
_gala_dwell_click_timer___lambda67_ (GalaDwellClickTimer* self,
                                     ClutterInputDevice* device,
                                     ClutterPointerA11yTimeoutType type,
                                     gboolean clicked)
{
	ClutterPropertyTransition* _tmp0_;
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->transition;
	clutter_timeline_stop ((ClutterTimeline*) _tmp0_);
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
}

static void
__gala_dwell_click_timer___lambda67__clutter_seat_ptr_a11y_timeout_stopped (ClutterSeat* _sender,
                                                                            ClutterInputDevice* device,
                                                                            ClutterPointerA11yTimeoutType timeout_type,
                                                                            gboolean clicked,
                                                                            gpointer self)
{
	_gala_dwell_click_timer___lambda67_ ((GalaDwellClickTimer*) self, device, timeout_type, clicked);
}

static void
_gala_dwell_click_timer___lambda68_ (GalaDwellClickTimer* self)
{
	gala_dwell_click_timer_update_cursor_size (self);
}

static void
__gala_dwell_click_timer___lambda68__g_settings_changed (GSettings* _sender,
                                                         const gchar* key,
                                                         gpointer self)
{
	_gala_dwell_click_timer___lambda68_ ((GalaDwellClickTimer*) self);
}

static GObject *
gala_dwell_click_timer_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaDwellClickTimer * self;
	ClutterBackend* _tmp0_;
	CoglContext* _tmp1_;
	CoglPipeline* _tmp2_;
	ClutterPropertyTransition* _tmp3_;
	ClutterPropertyTransition* _tmp4_;
	ClutterPropertyTransition* _tmp5_;
	ClutterPropertyTransition* _tmp6_;
	GValue _tmp7_ = {0};
	ClutterPropertyTransition* _tmp8_;
	GValue _tmp9_ = {0};
	ClutterPropertyTransition* _tmp10_;
	GSettings* _tmp11_;
	ClutterSeat* seat = NULL;
	ClutterBackend* _tmp12_;
	ClutterSeat* _tmp13_;
	ClutterSeat* _tmp14_;
	ClutterSeat* _tmp15_;
	ClutterSeat* _tmp16_;
	ClutterSeat* _tmp17_;
	GSettings* _tmp18_;
	parent_class = G_OBJECT_CLASS (gala_dwell_click_timer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_DWELL_CLICK_TIMER, GalaDwellClickTimer);
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	clutter_actor_set_reactive ((ClutterActor*) self, FALSE);
	_tmp0_ = clutter_get_default_backend ();
	_tmp1_ = clutter_backend_get_cogl_context (_tmp0_);
	_tmp2_ = cogl_pipeline_new (_tmp1_);
	_cogl_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp2_;
	_tmp3_ = (ClutterPropertyTransition*) clutter_property_transition_new ("angle");
	_g_object_unref0 (self->priv->transition);
	self->priv->transition = _tmp3_;
	_tmp4_ = self->priv->transition;
	clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp4_, CLUTTER_EASE_OUT_QUAD);
	_tmp5_ = self->priv->transition;
	clutter_transition_set_animatable ((ClutterTransition*) _tmp5_, (ClutterAnimatable*) self);
	_tmp6_ = self->priv->transition;
	g_value_init (&_tmp7_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp7_, GALA_DWELL_CLICK_TIMER_START_ANGLE);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp6_, &_tmp7_);
	G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
	_tmp8_ = self->priv->transition;
	g_value_init (&_tmp9_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp9_, GALA_DWELL_CLICK_TIMER_START_ANGLE + (2 * G_PI));
	clutter_transition_set_to_value ((ClutterTransition*) _tmp8_, &_tmp9_);
	G_IS_VALUE (&_tmp9_) ? (g_value_unset (&_tmp9_), NULL) : NULL;
	_tmp10_ = self->priv->transition;
	g_signal_connect_object ((ClutterTimeline*) _tmp10_, "new-frame", (GCallback) __gala_dwell_click_timer___lambda65__clutter_timeline_new_frame, self, 0);
	_tmp11_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->interface_settings);
	self->priv->interface_settings = _tmp11_;
	self->priv->scaling_factor = gala_internal_utils_get_ui_scaling_factor ();
	gala_dwell_click_timer_update_cursor_size (self);
	_tmp12_ = clutter_get_default_backend ();
	_tmp13_ = clutter_backend_get_default_seat (_tmp12_);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	seat = _tmp14_;
	_tmp15_ = seat;
	clutter_seat_set_pointer_a11y_dwell_click_type (_tmp15_, CLUTTER_A11Y_DWELL_CLICK_TYPE_PRIMARY);
	_tmp16_ = seat;
	g_signal_connect_object (_tmp16_, "ptr-a11y-timeout-started", (GCallback) __gala_dwell_click_timer___lambda66__clutter_seat_ptr_a11y_timeout_started, self, 0);
	_tmp17_ = seat;
	g_signal_connect_object (_tmp17_, "ptr-a11y-timeout-stopped", (GCallback) __gala_dwell_click_timer___lambda67__clutter_seat_ptr_a11y_timeout_stopped, self, 0);
	_tmp18_ = self->priv->interface_settings;
	g_signal_connect_object (_tmp18_, "changed::cursor-size", (GCallback) __gala_dwell_click_timer___lambda68__g_settings_changed, self, 0);
	_g_object_unref0 (seat);
	return obj;
}

static void
gala_dwell_click_timer_class_init (GalaDwellClickTimerClass * klass,
                                   gpointer klass_data)
{
	gala_dwell_click_timer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaDwellClickTimer_private_offset);
	((ClutterActorClass *) klass)->paint = (void (*) (ClutterActor*, ClutterPaintContext*)) gala_dwell_click_timer_real_paint;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_dwell_click_timer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_dwell_click_timer_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_dwell_click_timer_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_dwell_click_timer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DWELL_CLICK_TIMER_WM_PROPERTY, gala_dwell_click_timer_properties[GALA_DWELL_CLICK_TIMER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DWELL_CLICK_TIMER_ANGLE_PROPERTY, gala_dwell_click_timer_properties[GALA_DWELL_CLICK_TIMER_ANGLE_PROPERTY] = g_param_spec_double ("angle", "angle", "angle", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gala_dwell_click_timer_clutter_animatable_interface_init (ClutterAnimatableInterface * iface,
                                                          gpointer iface_data)
{
	gala_dwell_click_timer_clutter_animatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->interpolate_value = (gboolean (*) (ClutterAnimatable*, const gchar*, ClutterInterval*, gdouble, GValue*)) gala_dwell_click_timer_real_interpolate_value;
}

static void
gala_dwell_click_timer_instance_init (GalaDwellClickTimer * self,
                                      gpointer klass)
{
	self->priv = gala_dwell_click_timer_get_instance_private (self);
	self->priv->scaling_factor = 1;
	self->priv->cursor_size = 24;
}

static void
gala_dwell_click_timer_finalize (GObject * obj)
{
	GalaDwellClickTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_DWELL_CLICK_TIMER, GalaDwellClickTimer);
	_cogl_object_unref0 (self->priv->pipeline);
	_g_object_unref0 (self->priv->transition);
	_cairo_pattern_destroy0 (self->priv->stroke_color);
	_cairo_pattern_destroy0 (self->priv->fill_color);
	_g_object_unref0 (self->priv->interface_settings);
	_cairo_surface_destroy0 (self->priv->surface);
	G_OBJECT_CLASS (gala_dwell_click_timer_parent_class)->finalize (obj);
}

static GType
gala_dwell_click_timer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDwellClickTimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_dwell_click_timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaDwellClickTimer), 0, (GInstanceInitFunc) gala_dwell_click_timer_instance_init, NULL };
	static const GInterfaceInfo clutter_animatable_info = { (GInterfaceInitFunc) gala_dwell_click_timer_clutter_animatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_dwell_click_timer_type_id;
	gala_dwell_click_timer_type_id = g_type_register_static (clutter_actor_get_type (), "GalaDwellClickTimer", &g_define_type_info, 0);
	g_type_add_interface_static (gala_dwell_click_timer_type_id, clutter_animatable_get_type (), &clutter_animatable_info);
	GalaDwellClickTimer_private_offset = g_type_add_instance_private (gala_dwell_click_timer_type_id, sizeof (GalaDwellClickTimerPrivate));
	return gala_dwell_click_timer_type_id;
}

GType
gala_dwell_click_timer_get_type (void)
{
	static volatile gsize gala_dwell_click_timer_type_id__once = 0;
	if (g_once_init_enter (&gala_dwell_click_timer_type_id__once)) {
		GType gala_dwell_click_timer_type_id;
		gala_dwell_click_timer_type_id = gala_dwell_click_timer_get_type_once ();
		g_once_init_leave (&gala_dwell_click_timer_type_id__once, gala_dwell_click_timer_type_id);
	}
	return gala_dwell_click_timer_type_id__once;
}

static void
_vala_gala_dwell_click_timer_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GalaDwellClickTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_DWELL_CLICK_TIMER, GalaDwellClickTimer);
	switch (property_id) {
		case GALA_DWELL_CLICK_TIMER_WM_PROPERTY:
		g_value_set_object (value, gala_dwell_click_timer_get_wm (self));
		break;
		case GALA_DWELL_CLICK_TIMER_ANGLE_PROPERTY:
		g_value_set_double (value, gala_dwell_click_timer_get_angle (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_dwell_click_timer_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GalaDwellClickTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_DWELL_CLICK_TIMER, GalaDwellClickTimer);
	switch (property_id) {
		case GALA_DWELL_CLICK_TIMER_WM_PROPERTY:
		gala_dwell_click_timer_set_wm (self, g_value_get_object (value));
		break;
		case GALA_DWELL_CLICK_TIMER_ANGLE_PROPERTY:
		gala_dwell_click_timer_set_angle (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

