/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.track;

import com.topografix.gpx._1._0.BoundsType;
import com.topografix.gpx._1._0.Gpx;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.fibs.geotag.track.GpxReader;
import org.fibs.geotag.track.TrackStore;
import org.fibs.geotag.util.BoundsTypeUtil;

public class TrackStoreTest
extends TestCase {
    public void testTrackStore() {
        TrackStoreTest.assertNotNull((Object)TrackStore.getTrackStore());
        TrackStoreTest.assertFalse((boolean)TrackStore.getTrackStore().hasTracks());
        TrackStoreTest.assertNull((Object)TrackStore.getTrackStore().getGpx());
        TrackStoreTest.assertNull(TrackStore.getTrackStore().getTracks());
        InputStream stream = TrackStoreTest.class.getClassLoader().getResourceAsStream("all.gpx");
        TrackStoreTest.assertNotNull((Object)stream);
        Gpx gpx = GpxReader.read(stream);
        try {
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TrackStoreTest.assertNotNull((Object)gpx);
        TrackStore.getTrackStore().addGPX(gpx);
        TrackStoreTest.assertTrue((boolean)TrackStore.getTrackStore().hasTracks());
        TrackStoreTest.assertNotNull((Object)TrackStore.getTrackStore().getGpx());
        TrackStoreTest.assertNotNull(TrackStore.getTrackStore().getTracks());
        BoundsType gpxBounds = gpx.getBounds();
        for (Gpx.Trk track : TrackStore.getTrackStore().getTracks()) {
            for (Gpx.Trk.Trkseg segment : track.getTrkseg()) {
                BoundsType segmentBounds = TrackStore.getTrackStore().getSegmentBounds(segment);
                if (segmentBounds == null) continue;
                TrackStoreTest.assertTrue((boolean)BoundsTypeUtil.intersect(gpxBounds, segmentBounds));
            }
        }
    }
}

