/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.types;

import java.awt.Color;

public class EdgeColor {
    private final Mode mode;
    private final Color customColor;

    public EdgeColor(Mode mode) {
        this.customColor = Color.BLACK;
        this.mode = mode;
    }

    public EdgeColor(Color customColor) {
        this.customColor = customColor;
        this.mode = Mode.CUSTOM;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Color getCustomColor() {
        return this.customColor;
    }

    public Color getColor(Color edgeColor, Color sourceColor, Color targetColor) {
        switch (this.mode) {
            case ORIGINAL: {
                return edgeColor != null ? edgeColor : Color.BLACK;
            }
            case SOURCE: {
                return sourceColor;
            }
            case TARGET: {
                return targetColor;
            }
            case MIXED: {
                return new Color((int)((float)(sourceColor.getRed() + targetColor.getRed()) / 2.0f), (int)((float)(sourceColor.getGreen() + targetColor.getGreen()) / 2.0f), (int)((float)(sourceColor.getBlue() + targetColor.getBlue()) / 2.0f), (int)((float)(sourceColor.getAlpha() + targetColor.getAlpha()) / 2.0f));
            }
            case CUSTOM: {
                return this.customColor;
            }
        }
        return null;
    }

    public static enum Mode {
        SOURCE,
        TARGET,
        MIXED,
        CUSTOM,
        ORIGINAL;

    }
}

