/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.importer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gephi.desktop.importer.EdgesMergeStrategyWrapper;
import org.gephi.io.importer.api.Container;
import org.gephi.io.importer.api.EdgeDirectionDefault;
import org.gephi.io.importer.api.EdgeMergeStrategy;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.Report;
import org.gephi.io.processor.spi.Processor;
import org.gephi.io.processor.spi.ProcessorUI;
import org.gephi.ui.components.BusyUtils;
import org.jdesktop.swingx.JXHyperlink;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.netbeans.swing.outline.RowModel;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ReportPanel
extends JPanel {
    private static final String SHOW_ISSUES = "ReportPanel_Show_Issues";
    private static final String SHOW_REPORT = "ReportPanel_Show_Report";
    private static final int ISSUES_LIMIT = 5000;
    private static final String PREF_MORE_OPTIONS_PANEL_VISIBLE = "ReportPanel_moreOptionsPanelVisible";
    private static final String PREF_EDGE_MERGE_STRATEGY = "ReportPanel_edgeMergeStrategy";
    private static final String PREF_AUTOSCALE = "ReportPanel_autoscale";
    private static final String PREF_CREATE_MISSING_NODES = "ReportPanel_createMissingNodes";
    private static final String PREF_SELF_LOOP = "ReportPanel_selfLoops";
    private static final Object PROCESSOR_KEY = new Object();
    private final ThreadGroup fillingThreads;
    private final ButtonGroup processorGroup = new ButtonGroup();
    private ImageIcon infoIcon;
    private ImageIcon warningIcon;
    private ImageIcon severeIcon;
    private ImageIcon criticalIcon;
    private Container[] containers;
    private JCheckBox autoscaleCheckbox;
    private JCheckBox createMissingNodesCheckbox;
    private JLabel dynamicAttsLabel;
    private JLabel dynamicLabel;
    private JLabel edgeCountLabel;
    private JComboBox edgesMergeStrategyCombo;
    private JLabel graphCountLabel;
    private JComboBox graphTypeCombo;
    private Outline issuesOutline;
    private JLabel labelDynamic;
    private JLabel labelDynamicAtts;
    private JLabel labelEdgeCount;
    private JLabel labelGraphCount;
    private JLabel labelGraphType;
    private JLabel labelMultiGraph;
    private JLabel labelNodeCount;
    private JLabel labelParallelEdgesMergeStrategy;
    private JLabel labelSrc;
    private JPanel moreOptionsLeftPanel;
    private JXHyperlink moreOptionsLink;
    private JPanel moreOptionsPanel;
    private JLabel multigraphLabel;
    private JLabel nodeCountLabel;
    private JPanel processorPanel;
    private ButtonGroup processorStrategyRadio;
    private JEditorPane reportEditor;
    private JCheckBox selfLoopCheckBox;
    private JLabel sourceLabel;
    private JPanel statsPanel;
    private JScrollPane tab1ScrollPane;
    private JScrollPane tab2ScrollPane;
    private JTabbedPane tabbedPane;

    public ReportPanel() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ReportPanel.this.initComponents();
                    ReportPanel.this.initIcons();
                    ReportPanel.this.initProcessors();
                    ReportPanel.this.initMoreOptionsPanel();
                    ReportPanel.this.initMergeStrategyCombo();
                }
            });
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fillingThreads = new ThreadGroup("Report Panel Issues");
        this.autoscaleCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean s = ReportPanel.this.autoscaleCheckbox.isSelected();
                NbPreferences.forModule(ReportPanel.class).putBoolean(ReportPanel.PREF_AUTOSCALE, s);
                for (Container container : ReportPanel.this.containers) {
                    container.getLoader().setAutoScale(s);
                }
            }
        });
        this.createMissingNodesCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean s = ReportPanel.this.createMissingNodesCheckbox.isSelected();
                NbPreferences.forModule(ReportPanel.class).putBoolean(ReportPanel.PREF_CREATE_MISSING_NODES, s);
                for (Container container : ReportPanel.this.containers) {
                    container.getLoader().setAllowAutoNode(s);
                }
            }
        });
        this.moreOptionsLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportPanel.this.moreOptionsPanel.setVisible(!ReportPanel.this.moreOptionsPanel.isVisible());
                NbPreferences.forModule(ReportPanel.class).putBoolean(ReportPanel.PREF_MORE_OPTIONS_PANEL_VISIBLE, ReportPanel.this.moreOptionsPanel.isVisible());
                JRootPane rootPane = SwingUtilities.getRootPane(ReportPanel.this);
                ((JDialog)rootPane.getParent()).pack();
            }
        });
        this.edgesMergeStrategyCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EdgeMergeStrategy strategy = ((EdgesMergeStrategyWrapper)ReportPanel.this.edgesMergeStrategyCombo.getSelectedItem()).getInstance();
                NbPreferences.forModule(ReportPanel.class).put(ReportPanel.PREF_EDGE_MERGE_STRATEGY, strategy.name());
                for (Container container : ReportPanel.this.containers) {
                    container.getLoader().setEdgesMergeStrategy(strategy);
                }
            }
        });
        this.selfLoopCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean s = ReportPanel.this.selfLoopCheckBox.isSelected();
                NbPreferences.forModule(ReportPanel.class).putBoolean(ReportPanel.PREF_SELF_LOOP, s);
                for (Container container : ReportPanel.this.containers) {
                    container.getLoader().setAllowSelfLoop(s);
                }
            }
        });
        this.reportEditor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu contextMenu = new JPopupMenu();
                    JMenuItem menuItem = new JMenuItem();
                    menuItem.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.reportCopy.text"));
                    menuItem.setToolTipText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.reportCopy.description"));
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                            clpbrd.setContents(new StringSelection(ReportPanel.this.reportEditor.getText()), null);
                        }
                    });
                    contextMenu.add(menuItem);
                    contextMenu.show(ReportPanel.this.reportEditor, e.getX(), e.getY());
                }
            }
        });
    }

    public void initIcons() {
        this.infoIcon = new ImageIcon(this.getClass().getResource("/org/gephi/desktop/importer/resources/info.png"));
        this.warningIcon = new ImageIcon(this.getClass().getResource("/org/gephi/desktop/importer/resources/warning.gif"));
        this.severeIcon = new ImageIcon(this.getClass().getResource("/org/gephi/desktop/importer/resources/severe.png"));
        this.criticalIcon = new ImageIcon(this.getClass().getResource("/org/gephi/desktop/importer/resources/critical.png"));
    }

    public void setData(Report report, Container[] containers) {
        this.containers = containers;
        this.initGraphTypeCombo(containers);
        this.initProcessorsUI();
        this.fillIssues(report);
        this.fillReport(report);
        this.fillStats(containers);
        this.fillParameters(containers);
    }

    private void removeTabbedPane() {
        this.tabbedPane.setVisible(false);
    }

    private void initMergeStrategyCombo() {
        DefaultComboBoxModel<EdgesMergeStrategyWrapper> mergeStrategryModel = new DefaultComboBoxModel<EdgesMergeStrategyWrapper>(new EdgesMergeStrategyWrapper[]{new EdgesMergeStrategyWrapper(EdgeMergeStrategy.SUM), new EdgesMergeStrategyWrapper(EdgeMergeStrategy.AVG), new EdgesMergeStrategyWrapper(EdgeMergeStrategy.MIN), new EdgesMergeStrategyWrapper(EdgeMergeStrategy.MAX), new EdgesMergeStrategyWrapper(EdgeMergeStrategy.FIRST), new EdgesMergeStrategyWrapper(EdgeMergeStrategy.LAST), new EdgesMergeStrategyWrapper(EdgeMergeStrategy.NO_MERGE)});
        this.edgesMergeStrategyCombo.setModel(mergeStrategryModel);
    }

    private void initMoreOptionsPanel() {
        boolean moreOptionsPanelVisible = NbPreferences.forModule(ReportPanel.class).getBoolean(PREF_MORE_OPTIONS_PANEL_VISIBLE, false);
        if (!moreOptionsPanelVisible) {
            this.moreOptionsPanel.setVisible(false);
        }
    }

    private void initGraphTypeCombo(final Container[] containers) {
        final String directedStr = NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.graphType.directed");
        final String undirectedStr = NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.graphType.undirected");
        final String mixedStr = NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.graphType.mixed");
        EdgeDirectionDefault edd = null;
        for (Container container : containers) {
            EdgeDirectionDefault d = container.getUnloader().getEdgeDefault();
            if (edd == null) {
                edd = d;
                continue;
            }
            if (d.equals((Object)EdgeDirectionDefault.UNDIRECTED) && !edd.equals((Object)EdgeDirectionDefault.UNDIRECTED)) {
                edd = EdgeDirectionDefault.MIXED;
                continue;
            }
            if (!d.equals((Object)EdgeDirectionDefault.DIRECTED) || edd.equals((Object)EdgeDirectionDefault.DIRECTED)) continue;
            edd = EdgeDirectionDefault.MIXED;
        }
        final EdgeDirectionDefault dir = edd;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultComboBoxModel<String> comboModel = new DefaultComboBoxModel<String>();
                switch (dir) {
                    case DIRECTED: {
                        comboModel.addElement(directedStr);
                        comboModel.addElement(undirectedStr);
                        comboModel.addElement(mixedStr);
                        comboModel.setSelectedItem(directedStr);
                        break;
                    }
                    case UNDIRECTED: {
                        comboModel.addElement(undirectedStr);
                        comboModel.addElement(mixedStr);
                        comboModel.setSelectedItem(undirectedStr);
                        break;
                    }
                    case MIXED: {
                        comboModel.addElement(directedStr);
                        comboModel.addElement(undirectedStr);
                        comboModel.addElement(mixedStr);
                        comboModel.setSelectedItem(mixedStr);
                    }
                }
                ReportPanel.this.graphTypeCombo.setModel(comboModel);
            }
        });
        this.graphTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object g = e.getItem();
                    if (g.equals(directedStr)) {
                        for (Container container : containers) {
                            container.getLoader().setEdgeDefault(EdgeDirectionDefault.DIRECTED);
                        }
                    } else if (g.equals(undirectedStr)) {
                        for (Container container : containers) {
                            container.getLoader().setEdgeDefault(EdgeDirectionDefault.UNDIRECTED);
                        }
                    } else if (g.equals(mixedStr)) {
                        for (Container container : containers) {
                            container.getLoader().setEdgeDefault(EdgeDirectionDefault.MIXED);
                        }
                    }
                    ReportPanel.this.fillStats(containers);
                }
            }
        });
    }

    private void fillIssues(Report report) {
        final ArrayList<Issue> issues = new ArrayList<Issue>();
        Iterator itr = report.getIssues(5000);
        while (itr.hasNext()) {
            issues.add((Issue)itr.next());
        }
        if (issues.isEmpty()) {
            JLabel label = new JLabel(NbBundle.getMessage(this.getClass(), (String)"ReportPanel.noIssues"));
            label.setHorizontalAlignment(0);
            this.tab1ScrollPane.setViewportView(label);
        } else {
            final BusyUtils.BusyLabel busyLabel = BusyUtils.createCenteredBusyLabel((JScrollPane)this.tab1ScrollPane, (String)"Retrieving issues...", (JComponent)this.issuesOutline);
            Thread thread = new Thread(this.fillingThreads, new Runnable(){

                @Override
                public void run() {
                    busyLabel.setBusy(true);
                    IssueTreeModel treeMdl = new IssueTreeModel(issues);
                    final OutlineModel mdl = DefaultOutlineModel.createOutlineModel((TreeModel)treeMdl, (RowModel)new IssueRowModel(), (boolean)true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ReportPanel.this.issuesOutline.setRootVisible(false);
                            ReportPanel.this.issuesOutline.setRenderDataProvider((RenderDataProvider)new IssueRenderer());
                            ReportPanel.this.issuesOutline.setModel((TableModel)mdl);
                            busyLabel.setBusy(false);
                        }
                    });
                }
            }, "Report Panel Issues Outline");
            if (NbPreferences.forModule(ReportPanel.class).getBoolean(SHOW_ISSUES, true)) {
                thread.start();
            }
        }
    }

    private void fillReport(final Report report) {
        Thread thread = new Thread(this.fillingThreads, new Runnable(){

            @Override
            public void run() {
                final String str = report.getText();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ReportPanel.this.reportEditor.setText(str);
                    }
                });
            }
        }, "Report Panel Issues Report");
        if (NbPreferences.forModule(ReportPanel.class).getBoolean(SHOW_REPORT, true)) {
            thread.start();
        }
    }

    private void fillParameters(final Container[] containers) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean autoscalePref = NbPreferences.forModule(ReportPanel.class).getBoolean(ReportPanel.PREF_AUTOSCALE, containers[0].getUnloader().isAutoScale());
                boolean selfLoopPref = NbPreferences.forModule(ReportPanel.class).getBoolean(ReportPanel.PREF_SELF_LOOP, containers[0].getUnloader().allowSelfLoop());
                boolean createMissingNodesPref = NbPreferences.forModule(ReportPanel.class).getBoolean(ReportPanel.PREF_CREATE_MISSING_NODES, containers[0].getUnloader().allowAutoNode());
                EdgeMergeStrategy strategyPref = containers[0].getUnloader().getEdgesMergeStrategy();
                try {
                    strategyPref = EdgeMergeStrategy.valueOf((String)NbPreferences.forModule(ReportPanel.class).get(ReportPanel.PREF_EDGE_MERGE_STRATEGY, strategyPref.name()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (Container container : containers) {
                    container.getLoader().setAllowSelfLoop(selfLoopPref);
                    container.getLoader().setAutoScale(autoscalePref);
                    container.getLoader().setAllowAutoNode(createMissingNodesPref);
                    container.getLoader().setEdgesMergeStrategy(strategyPref);
                }
                ReportPanel.this.createMissingNodesCheckbox.setEnabled(containers[0].getUnloader().containsAutoNodes());
                ReportPanel.this.selfLoopCheckBox.setEnabled(containers[0].hasSelfLoops());
                ReportPanel.this.autoscaleCheckbox.setSelected(autoscalePref);
                ReportPanel.this.selfLoopCheckBox.setSelected(selfLoopPref);
                ReportPanel.this.createMissingNodesCheckbox.setSelected(createMissingNodesPref);
                ReportPanel.this.edgesMergeStrategyCombo.setSelectedItem(new EdgesMergeStrategyWrapper(strategyPref));
            }
        });
    }

    private void fillStats(final Container[] containers) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String source;
                if (containers.length == 1) {
                    source = containers[0].getSource();
                    String[] label = source.split("\\.");
                    if (label.length > 2 && label[label.length - 2].matches("\\d+")) {
                        source = source.replaceFirst("." + label[label.length - 2], "");
                    }
                } else {
                    source = NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.multiSourceLabel.text");
                }
                ReportPanel.this.sourceLabel.setText(source);
                int nodeCount = 0;
                int edgeCount = 0;
                boolean dynamic = false;
                boolean dynamicAtts = false;
                boolean multiGraph = false;
                for (Container container : containers) {
                    nodeCount += container.getUnloader().getNodeCount();
                    edgeCount += container.getUnloader().getEdgeCount();
                    if (container.getUnloader().getEdgeDefault().equals((Object)EdgeDirectionDefault.UNDIRECTED)) {
                        edgeCount -= container.getUnloader().getMutualEdgeCount();
                    }
                    dynamic |= container.isDynamicGraph();
                    dynamicAtts |= container.hasDynamicAttributes();
                    multiGraph |= container.isMultiGraph();
                }
                ReportPanel.this.graphCountLabel.setText("" + containers.length);
                ReportPanel.this.nodeCountLabel.setText("" + nodeCount);
                ReportPanel.this.edgeCountLabel.setText("" + edgeCount);
                String yes = NbBundle.getMessage(this.getClass(), (String)"ReportPanel.yes");
                String no = NbBundle.getMessage(this.getClass(), (String)"ReportPanel.no");
                ReportPanel.this.dynamicLabel.setText(dynamic ? yes : no);
                ReportPanel.this.dynamicAttsLabel.setText(dynamicAtts ? yes : no);
                ReportPanel.this.multigraphLabel.setText(multiGraph ? yes : no);
                if (containers.length == 1) {
                    ReportPanel.this.graphCountLabel.setVisible(false);
                    ReportPanel.this.labelGraphCount.setVisible(false);
                }
            }
        });
    }

    private void initProcessors() {
        boolean i = false;
        for (Processor processor : Lookup.getDefault().lookupAll(Processor.class)) {
            JRadioButton radio = new JRadioButton(processor.getDisplayName());
            radio.setToolTipText(processor.getDisplayName());
            radio.putClientProperty(PROCESSOR_KEY, processor);
            this.processorGroup.add(radio);
        }
    }

    private void initProcessorsUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArrayList<AbstractButton> validButtons = new ArrayList<AbstractButton>();
                Enumeration<AbstractButton> enumeration = ReportPanel.this.processorGroup.getElements();
                while (enumeration.hasMoreElements()) {
                    boolean isValid;
                    AbstractButton radioButton = enumeration.nextElement();
                    Processor p = (Processor)radioButton.getClientProperty(PROCESSOR_KEY);
                    ProcessorUI pui = ReportPanel.this.getProcessorUI(p);
                    if (pui == null || !(isValid = pui.isValid(ReportPanel.this.containers))) continue;
                    validButtons.add(radioButton);
                }
                int i = 0;
                for (AbstractButton radio : validButtons) {
                    radio.setSelected(i == 0);
                    GridBagConstraints constraints = new GridBagConstraints(0, i++, 1, 1, 1.0, i == validButtons.size() ? 1.0 : 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
                    ReportPanel.this.processorPanel.add((Component)radio, constraints);
                }
            }
        });
    }

    public void destroy() {
        this.fillingThreads.interrupt();
    }

    public Processor getProcessor() {
        Enumeration<AbstractButton> enumeration = this.processorGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton radioButton = enumeration.nextElement();
            if (!radioButton.isSelected()) continue;
            return (Processor)radioButton.getClientProperty(PROCESSOR_KEY);
        }
        return null;
    }

    private ProcessorUI getProcessorUI(Processor processor) {
        for (ProcessorUI pui : Lookup.getDefault().lookupAll(ProcessorUI.class)) {
            if (!pui.isUIFoProcessor(processor)) continue;
            return pui;
        }
        return null;
    }

    private void initComponents() {
        this.processorStrategyRadio = new ButtonGroup();
        this.labelSrc = new JLabel();
        this.sourceLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.tab1ScrollPane = new JScrollPane();
        this.issuesOutline = new Outline();
        this.tab2ScrollPane = new JScrollPane();
        this.reportEditor = new JEditorPane();
        this.labelGraphType = new JLabel();
        this.processorPanel = new JPanel();
        this.statsPanel = new JPanel();
        this.labelNodeCount = new JLabel();
        this.labelEdgeCount = new JLabel();
        this.nodeCountLabel = new JLabel();
        this.edgeCountLabel = new JLabel();
        this.dynamicLabel = new JLabel();
        this.labelDynamic = new JLabel();
        this.labelMultiGraph = new JLabel();
        this.multigraphLabel = new JLabel();
        this.labelDynamicAtts = new JLabel();
        this.dynamicAttsLabel = new JLabel();
        this.labelGraphCount = new JLabel();
        this.graphCountLabel = new JLabel();
        this.moreOptionsPanel = new JPanel();
        this.moreOptionsLeftPanel = new JPanel();
        this.autoscaleCheckbox = new JCheckBox();
        this.createMissingNodesCheckbox = new JCheckBox();
        this.selfLoopCheckBox = new JCheckBox();
        this.labelParallelEdgesMergeStrategy = new JLabel();
        this.edgesMergeStrategyCombo = new JComboBox();
        this.graphTypeCombo = new JComboBox();
        this.moreOptionsLink = new JXHyperlink();
        this.labelSrc.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.labelSrc.text"));
        this.sourceLabel.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.sourceLabel.text"));
        this.tab1ScrollPane.setViewportView((Component)this.issuesOutline);
        this.tabbedPane.addTab(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.tab1ScrollPane.TabConstraints.tabTitle"), this.tab1ScrollPane);
        this.reportEditor.setEditable(false);
        this.reportEditor.setFocusable(false);
        this.tab2ScrollPane.setViewportView(this.reportEditor);
        this.tabbedPane.addTab(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.tab2ScrollPane.TabConstraints.tabTitle"), this.tab2ScrollPane);
        this.labelGraphType.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.labelGraphType.text"));
        this.processorPanel.setLayout(new GridBagLayout());
        this.statsPanel.setLayout(new GridBagLayout());
        this.labelNodeCount.setFont(this.labelNodeCount.getFont().deriveFont(this.labelNodeCount.getFont().getStyle() | 1));
        this.labelNodeCount.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.labelNodeCount.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 6, 0);
        this.statsPanel.add((Component)this.labelNodeCount, gridBagConstraints);
        this.labelEdgeCount.setFont(this.labelEdgeCount.getFont().deriveFont(this.labelEdgeCount.getFont().getStyle() | 1));
        this.labelEdgeCount.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.labelEdgeCount.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 10, 0);
        this.statsPanel.add((Component)this.labelEdgeCount, gridBagConstraints);
        this.nodeCountLabel.setFont(new Font("Tahoma", 1, 11));
        this.nodeCountLabel.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.nodeCountLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 6, 0);
        this.statsPanel.add((Component)this.nodeCountLabel, gridBagConstraints);
        this.edgeCountLabel.setFont(new Font("Tahoma", 1, 11));
        this.edgeCountLabel.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.edgeCountLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.statsPanel.add((Component)this.edgeCountLabel, gridBagConstraints);
        this.dynamicLabel.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.dynamicLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 6, 0);
        this.statsPanel.add((Component)this.dynamicLabel, gridBagConstraints);
        this.labelDynamic.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.labelDynamic.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 6, 0);
        this.statsPanel.add((Component)this.labelDynamic, gridBagConstraints);
        this.labelMultiGraph.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.labelMultiGraph.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 6, 0);
        this.statsPanel.add((Component)this.labelMultiGraph, gridBagConstraints);
        this.multigraphLabel.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.multigraphLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 6, 0);
        this.statsPanel.add((Component)this.multigraphLabel, gridBagConstraints);
        this.labelDynamicAtts.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.labelDynamicAtts.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 6, 0);
        this.statsPanel.add((Component)this.labelDynamicAtts, gridBagConstraints);
        this.dynamicAttsLabel.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.dynamicAttsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 6, 0);
        this.statsPanel.add((Component)this.dynamicAttsLabel, gridBagConstraints);
        this.labelGraphCount.setFont(this.labelGraphCount.getFont().deriveFont(this.labelGraphCount.getFont().getStyle() | 1));
        this.labelGraphCount.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.labelGraphCount.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 6, 0);
        this.statsPanel.add((Component)this.labelGraphCount, gridBagConstraints);
        this.graphCountLabel.setFont(new Font("Tahoma", 1, 11));
        this.graphCountLabel.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.graphCountLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 6, 0);
        this.statsPanel.add((Component)this.graphCountLabel, gridBagConstraints);
        this.moreOptionsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.moreOptionsPanel.setLayout(new GridBagLayout());
        this.moreOptionsLeftPanel.setLayout(new GridBagLayout());
        this.autoscaleCheckbox.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.autoscaleCheckbox.text"));
        this.autoscaleCheckbox.setToolTipText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.autoscaleCheckbox.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.moreOptionsLeftPanel.add((Component)this.autoscaleCheckbox, gridBagConstraints);
        this.createMissingNodesCheckbox.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.createMissingNodesCheckbox.text"));
        this.createMissingNodesCheckbox.setToolTipText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.createMissingNodesCheckbox.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.moreOptionsLeftPanel.add((Component)this.createMissingNodesCheckbox, gridBagConstraints);
        this.selfLoopCheckBox.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.selfLoopCheckBox.text"));
        this.selfLoopCheckBox.setToolTipText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.selfLoopCheckBox.toolTipText"));
        this.selfLoopCheckBox.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.moreOptionsLeftPanel.add((Component)this.selfLoopCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.moreOptionsPanel.add((Component)this.moreOptionsLeftPanel, gridBagConstraints);
        this.labelParallelEdgesMergeStrategy.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.labelParallelEdgesMergeStrategy.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.moreOptionsPanel.add((Component)this.labelParallelEdgesMergeStrategy, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.moreOptionsPanel.add((Component)this.edgesMergeStrategyCombo, gridBagConstraints);
        this.moreOptionsLink.setText(NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.moreOptionsLink.text"));
        this.moreOptionsLink.setClickedColor(new Color(0, 51, 255));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, -1, 625, Short.MAX_VALUE).addComponent(this.moreOptionsPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.labelSrc).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceLabel, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.statsPanel, -2, 329, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.processorPanel, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.labelGraphType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.graphTypeCombo, -2, 152, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.moreOptionsLink, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSrc).addComponent(this.sourceLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabbedPane, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelGraphType).addComponent(this.graphTypeCombo, -2, -1, -2).addComponent((Component)this.moreOptionsLink, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moreOptionsPanel, -2, 94, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.processorPanel, -2, 145, -2).addComponent(this.statsPanel, -2, -1, -2))));
    }

    private class IssueRenderer
    implements RenderDataProvider {
        private IssueRenderer() {
        }

        public String getDisplayName(Object o) {
            Issue issue = (Issue)o;
            return issue.getMessage();
        }

        public boolean isHtmlDisplayName(Object o) {
            return false;
        }

        public Color getBackground(Object o) {
            return null;
        }

        public Color getForeground(Object o) {
            return null;
        }

        public String getTooltipText(Object o) {
            return "";
        }

        public Icon getIcon(Object o) {
            Issue issue = (Issue)o;
            switch (issue.getLevel()) {
                case INFO: {
                    return ReportPanel.this.infoIcon;
                }
                case WARNING: {
                    return ReportPanel.this.warningIcon;
                }
                case SEVERE: {
                    return ReportPanel.this.severeIcon;
                }
                case CRITICAL: {
                    return ReportPanel.this.criticalIcon;
                }
            }
            return null;
        }
    }

    private class IssueRowModel
    implements RowModel {
        private IssueRowModel() {
        }

        public int getColumnCount() {
            return 1;
        }

        public Object getValueFor(Object node, int column) {
            if (node instanceof Issue) {
                Issue issue = (Issue)node;
                return issue.getLevel().toString();
            }
            return "";
        }

        public Class getColumnClass(int column) {
            return String.class;
        }

        public boolean isCellEditable(Object node, int column) {
            return false;
        }

        public void setValueFor(Object node, int column, Object value) {
        }

        public String getColumnName(int column) {
            return NbBundle.getMessage(ReportPanel.class, (String)"ReportPanel.issueTable.issues");
        }
    }

    private class IssueTreeModel
    implements TreeModel {
        private final List<Issue> issues;

        public IssueTreeModel(List<Issue> issues) {
            this.issues = issues;
        }

        @Override
        public Object getRoot() {
            return "root";
        }

        @Override
        public Object getChild(Object parent, int index) {
            return this.issues.get(index);
        }

        @Override
        public int getChildCount(Object parent) {
            return this.issues.size();
        }

        @Override
        public boolean isLeaf(Object node) {
            return node instanceof Issue;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            return this.issues.indexOf(child);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }
    }
}

