/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.preview;

import com.itextpdf.text.Rectangle;
import javax.swing.JPanel;
import org.gephi.io.exporter.preview.PDFExporter;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.preview.AbstractExporterSettings;
import org.gephi.ui.exporter.preview.UIExporterPDFPanel;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;

public class UIExporterPDF
implements ExporterUI {
    private final ExporterPDFSettings settings = new ExporterPDFSettings();
    private UIExporterPDFPanel panel;
    private ValidationPanel validationPanel;
    private PDFExporter exporterPDF;

    public void setup(Exporter exporter) {
        this.exporterPDF = (PDFExporter)exporter;
        this.settings.load(this.exporterPDF);
        this.panel.setup(this.exporterPDF);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporterPDF);
            this.settings.save(this.exporterPDF);
        }
        this.panel = null;
        this.exporterPDF = null;
    }

    public JPanel getPanel() {
        this.panel = new UIExporterPDFPanel();
        this.validationPanel = UIExporterPDFPanel.createValidationPanel(this.panel);
        return this.validationPanel;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof PDFExporter;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterPDF.class, (String)"UIExporterPDF.name");
    }

    private static class ExporterPDFSettings
    extends AbstractExporterSettings {
        private static final String MARGIN_TOP = "PDF_marginTop";
        private static final String MARGIN_BOTTOM = "PDF_marginBottom";
        private static final String MARGIN_LEFT = "PDF_marginLeft";
        private static final String MARGIN_RIGHT = "PDF_marginRight";
        private static final String LANDSCAPE = "PDF_landscape";
        private static final String PAGE_SIZE_WIDTH = "PDF_pageSizeWidth";
        private static final String PAGE_SIZE_HEIGHT = "PDF_pageSizeHeight";
        private static final PDFExporter DEFAULT = new PDFExporter();

        private ExporterPDFSettings() {
        }

        private void load(PDFExporter exporter) {
            exporter.setMarginTop(this.get(MARGIN_TOP, DEFAULT.getMarginTop()));
            exporter.setMarginBottom(this.get(MARGIN_BOTTOM, DEFAULT.getMarginBottom()));
            exporter.setMarginLeft(this.get(MARGIN_LEFT, DEFAULT.getMarginLeft()));
            exporter.setMarginRight(this.get(MARGIN_RIGHT, DEFAULT.getMarginRight()));
            exporter.setLandscape(this.get(LANDSCAPE, DEFAULT.isLandscape()));
            float width = this.get(PAGE_SIZE_WIDTH, DEFAULT.getPageSize().getWidth());
            float height = this.get(PAGE_SIZE_HEIGHT, DEFAULT.getPageSize().getHeight());
            exporter.setPageSize(new Rectangle(width, height));
        }

        private void save(PDFExporter exporter) {
            this.put(MARGIN_TOP, exporter.getMarginTop());
            this.put(MARGIN_BOTTOM, exporter.getMarginBottom());
            this.put(MARGIN_LEFT, exporter.getMarginLeft());
            this.put(MARGIN_RIGHT, exporter.getMarginRight());
            this.put(LANDSCAPE, exporter.isLandscape());
            this.put(PAGE_SIZE_WIDTH, exporter.getPageSize().getWidth());
            this.put(PAGE_SIZE_HEIGHT, exporter.getPageSize().getHeight());
        }
    }
}

