/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.gephi.desktop.importer.api.ImportControllerUI;
import org.gephi.desktop.mrufiles.api.MostRecentFiles;
import org.gephi.desktop.project.api.ProjectControllerUI;
import org.gephi.io.importer.api.FileType;
import org.gephi.io.importer.spi.FileImporterBuilder;
import org.gephi.project.api.GephiFormatException;
import org.gephi.project.api.LegacyGephiFormatException;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.ProjectInformation;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceProvider;
import org.gephi.project.spi.ProjectPropertiesUI;
import org.gephi.ui.utils.DialogFileFilter;
import org.gephi.utils.longtask.api.LongTaskErrorHandler;
import org.gephi.utils.longtask.api.LongTaskExecutor;
import org.gephi.utils.longtask.api.LongTaskListener;
import org.gephi.utils.longtask.spi.LongTask;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public class ProjectControllerUIImpl
implements ProjectControllerUI {
    private final ProjectController controller = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
    private final ImportControllerUI importControllerUI = (ImportControllerUI)Lookup.getDefault().lookup(ImportControllerUI.class);
    private final LongTaskExecutor longTaskExecutor = new LongTaskExecutor(true, "Project IO");
    private boolean openProject = true;
    private boolean newProject = true;
    private boolean openFile = true;
    private boolean saveProject = false;
    private boolean saveAsProject = false;
    private boolean projectProperties = false;
    private boolean closeProject = false;
    private boolean newWorkspace = false;
    private boolean deleteWorkspace = false;
    private boolean duplicateWorkspace = false;
    private boolean renameWorkspace = false;

    public ProjectControllerUIImpl() {
        this.longTaskExecutor.setDefaultErrorHandler(new LongTaskErrorHandler(){

            public void fatalError(Throwable t) {
                ProjectControllerUIImpl.this.unlockProjectActions();
                if (t instanceof LegacyGephiFormatException || t instanceof GephiFormatException) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)t.getLocalizedMessage(), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                }
                if (!(t instanceof LegacyGephiFormatException)) {
                    Exceptions.printStackTrace((Throwable)t);
                }
            }
        });
        this.longTaskExecutor.setLongTaskListener(new LongTaskListener(){

            public void taskFinished(LongTask task) {
                ProjectControllerUIImpl.this.unlockProjectActions();
            }
        });
    }

    private void saveProject(Project project, File file) {
        this.lockProjectActions();
        final Runnable saveTask = this.controller.saveProject(project, file);
        final String fileName = file.getName();
        Runnable saveRunnable = new Runnable(){

            @Override
            public void run() {
                saveTask.run();
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"ProjectControllerUI.status.saved", (Object)fileName));
            }
        };
        if (saveTask instanceof LongTask) {
            this.longTaskExecutor.execute((LongTask)saveTask, saveRunnable);
        } else {
            this.longTaskExecutor.execute(null, saveRunnable);
        }
        MostRecentFiles mostRecentFiles = (MostRecentFiles)Lookup.getDefault().lookup(MostRecentFiles.class);
        mostRecentFiles.addFile(file.getAbsolutePath());
    }

    @Override
    public void saveProject() {
        Project project = this.controller.getCurrentProject();
        if (((ProjectInformation)project.getLookup().lookup(ProjectInformation.class)).hasFile()) {
            File file = ((ProjectInformation)project.getLookup().lookup(ProjectInformation.class)).getFile();
            this.saveProject(project, file);
        } else {
            this.saveAsProject();
        }
    }

    @Override
    public void saveAsProject() {
        int returnFile;
        String LAST_PATH = "SaveAsProject_Last_Path";
        String LAST_PATH_DEFAULT = "SaveAsProject_Last_Path_Default";
        DialogFileFilter filter = new DialogFileFilter(NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"SaveAsProject_filechooser_filter"));
        filter.addExtension(".gephi");
        String lastPathDefault = NbPreferences.forModule(ProjectControllerUIImpl.class).get("SaveAsProject_Last_Path_Default", null);
        String lastPath = NbPreferences.forModule(ProjectControllerUIImpl.class).get("SaveAsProject_Last_Path", lastPathDefault);
        File lastPathDir = null;
        if (lastPath != null) {
            for (lastPathDir = new File(lastPath).getParentFile(); lastPathDir != null && !lastPathDir.exists(); lastPathDir = lastPathDir.getParentFile()) {
            }
        }
        JFileChooser chooser = new JFileChooser(lastPathDir){

            @Override
            public void approveSelection() {
                if (ProjectControllerUIImpl.this.canExport(this)) {
                    super.approveSelection();
                }
            }
        };
        chooser.addChoosableFileFilter((FileFilter)filter);
        if (lastPathDir != null && lastPathDir.exists() && lastPathDir.isDirectory()) {
            chooser.setSelectedFile(new File(lastPath));
        }
        if ((returnFile = chooser.showSaveDialog(null)) == 0) {
            File file = chooser.getSelectedFile();
            file = FileUtil.normalizeFile((File)file);
            NbPreferences.forModule(ProjectControllerUIImpl.class).put("SaveAsProject_Last_Path", file.getAbsolutePath());
            try {
                final String SaveAsFileName = file.getName();
                Project project = this.controller.getCurrentProject();
                this.saveProject(project, file);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
                        Object title = frame.getTitle();
                        title = ((String)title).substring(0, ((String)title).indexOf(" - ")) + " - " + SaveAsFileName;
                        frame.setTitle((String)title);
                    }
                });
            }
            catch (Exception e) {
                Logger.getLogger("").log(Level.WARNING, "", e);
            }
        }
    }

    private boolean canExport(JFileChooser chooser) {
        File file = chooser.getSelectedFile();
        if (!file.getPath().endsWith(".gephi")) {
            file = new File(file.getPath() + ".gephi");
            chooser.setSelectedFile(file);
        }
        try {
            if (!file.exists()) {
                if (!file.createNewFile()) {
                    String failMsg = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"SaveAsProject_SaveFailed", (Object[])new Object[]{file.getPath()});
                    JOptionPane.showMessageDialog(null, failMsg);
                    return false;
                }
            } else {
                String overwriteMsg = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"SaveAsProject_Overwrite", (Object[])new Object[]{file.getPath()});
                if (JOptionPane.showConfirmDialog(null, overwriteMsg) != 0) {
                    return false;
                }
            }
        }
        catch (IOException ex) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getMessage(), 2);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
            return false;
        }
        return true;
    }

    public boolean closeCurrentProject() {
        if (this.controller.getCurrentProject() != null) {
            String messageBundle = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"CloseProject_confirm_message");
            String titleBundle = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"CloseProject_confirm_title");
            String saveBundle = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"CloseProject_confirm_save");
            String doNotSaveBundle = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"CloseProject_confirm_doNotSave");
            String cancelBundle = NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"CloseProject_confirm_cancel");
            NotifyDescriptor msg = new NotifyDescriptor((Object)messageBundle, titleBundle, 1, 1, new Object[]{saveBundle, doNotSaveBundle, cancelBundle}, (Object)saveBundle);
            Object result = DialogDisplayer.getDefault().notify(msg);
            if (result == saveBundle) {
                this.saveProject();
            } else if (result == cancelBundle) {
                return false;
            }
            this.controller.closeCurrentProject();
            this.saveProject = false;
            this.saveAsProject = false;
            this.projectProperties = false;
            this.closeProject = false;
            this.newWorkspace = false;
            this.deleteWorkspace = false;
            this.duplicateWorkspace = false;
            this.renameWorkspace = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
                    String title = frame.getTitle();
                    title = title.substring(0, title.indexOf(" - "));
                    frame.setTitle(title);
                }
            });
        }
        return true;
    }

    @Override
    public void openProject(File file) {
        if (this.controller.getCurrentProject() != null && !this.closeCurrentProject()) {
            return;
        }
        this.loadProject(file);
    }

    private void loadProject(File file) {
        this.lockProjectActions();
        final Runnable loadTask = this.controller.openProject(file);
        final String fileName = file.getName();
        Runnable loadRunnable = new Runnable(){

            @Override
            public void run() {
                loadTask.run();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
                        String title = frame.getTitle() + " - " + fileName;
                        frame.setTitle(title);
                    }
                });
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"ProjectControllerUI.status.opened", (Object)fileName));
            }
        };
        if (loadTask instanceof LongTask) {
            this.longTaskExecutor.execute((LongTask)loadTask, loadRunnable);
        } else {
            this.longTaskExecutor.execute(null, loadRunnable);
        }
        MostRecentFiles mostRecentFiles = (MostRecentFiles)Lookup.getDefault().lookup(MostRecentFiles.class);
        mostRecentFiles.addFile(file.getAbsolutePath());
    }

    @Override
    public void renameProject(final String name) {
        this.controller.renameProject(this.controller.getCurrentProject(), name);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
                Object title = frame.getTitle();
                title = ((String)title).substring(0, ((String)title).indexOf(" - "));
                title = (String)title + " - " + name;
                frame.setTitle((String)title);
            }
        });
    }

    @Override
    public boolean canCloseProject() {
        return this.closeProject;
    }

    @Override
    public boolean canDeleteWorkspace() {
        return this.deleteWorkspace;
    }

    @Override
    public boolean canNewProject() {
        return this.newProject;
    }

    @Override
    public boolean canNewWorkspace() {
        return this.newWorkspace;
    }

    @Override
    public boolean canDuplicateWorkspace() {
        return this.duplicateWorkspace;
    }

    @Override
    public boolean canRenameWorkspace() {
        return this.renameWorkspace;
    }

    @Override
    public boolean canOpenFile() {
        return this.openFile;
    }

    @Override
    public boolean canSave() {
        return this.saveProject;
    }

    @Override
    public boolean canSaveAs() {
        return this.saveAsProject;
    }

    @Override
    public boolean canProjectProperties() {
        return this.projectProperties;
    }

    private void lockProjectActions() {
        this.saveProject = false;
        this.saveAsProject = false;
        this.openProject = false;
        this.closeProject = false;
        this.newProject = false;
        this.openFile = false;
        this.newWorkspace = false;
        this.deleteWorkspace = false;
        this.duplicateWorkspace = false;
        this.renameWorkspace = false;
    }

    private void unlockProjectActions() {
        if (this.controller.getCurrentProject() != null) {
            this.saveProject = true;
            this.saveAsProject = true;
            this.closeProject = true;
            this.newWorkspace = true;
            this.projectProperties = true;
            if (((WorkspaceProvider)this.controller.getCurrentProject().getLookup().lookup(WorkspaceProvider.class)).hasCurrentWorkspace()) {
                this.deleteWorkspace = true;
                this.duplicateWorkspace = true;
                this.renameWorkspace = true;
            }
        }
        this.openProject = true;
        this.newProject = true;
        this.openFile = true;
    }

    @Override
    public void projectProperties() {
        Project project = this.controller.getCurrentProject();
        ProjectPropertiesUI ui = (ProjectPropertiesUI)Lookup.getDefault().lookup(ProjectPropertiesUI.class);
        if (ui != null) {
            JPanel panel = ui.getPanel();
            ui.setup(project);
            DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"ProjectProperties_dialog_title"));
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (result == NotifyDescriptor.OK_OPTION) {
                ui.unsetup(project);
            }
        }
    }

    @Override
    public void openFile() {
        this.openFile(null);
    }

    @Override
    public void openFile(FileImporterBuilder[] builders) {
        List<FileType> fileTypes;
        ArrayList<DialogFileFilter> filters = new ArrayList<DialogFileFilter>();
        DialogFileFilter graphFilter = new DialogFileFilter(NbBundle.getMessage(this.getClass(), (String)"OpenFile_filechooser_graphfilter"));
        if (builders != null) {
            fileTypes = new ArrayList<FileType>();
            for (FileImporterBuilder builder : builders) {
                fileTypes.addAll(Arrays.asList(builder.getFileTypes()));
            }
        } else {
            DialogFileFilter gephiFilter = new DialogFileFilter(NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"OpenProject_filechooser_filter"));
            gephiFilter.addExtension(".gephi");
            filters.add(gephiFilter);
            graphFilter.addExtension(".gephi");
            fileTypes = Arrays.asList(this.importControllerUI.getImportController().getFileTypes());
        }
        for (FileType fileType : fileTypes) {
            DialogFileFilter dialogFileFilter = new DialogFileFilter(fileType.getName());
            dialogFileFilter.addExtensions(fileType.getExtensions());
            filters.add(dialogFileFilter);
            graphFilter.addExtensions(fileType.getExtensions());
        }
        DialogFileFilter zipFileFilter = new DialogFileFilter(NbBundle.getMessage(this.getClass(), (String)"OpenFile_filechooser_zipfilter"));
        zipFileFilter.addExtensions(new String[]{".zip", ".gz", ".bz2"});
        filters.add(graphFilter);
        filters.add(zipFileFilter);
        this.openFile(filters.toArray(new FileFilter[0]), null);
    }

    private void openFile(FileFilter[] fileFilters, FileFilter initialFilter) {
        int returnFile;
        String LAST_PATH = "OpenFile_Last_Path";
        String LAST_PATH_DEFAULT = "OpenFile_Last_Path_Default";
        String lastPathDefault = NbPreferences.forModule(ProjectControllerUIImpl.class).get("OpenFile_Last_Path_Default", null);
        String lastPath = NbPreferences.forModule(ProjectControllerUIImpl.class).get("OpenFile_Last_Path", lastPathDefault);
        JFileChooser chooser = new JFileChooser(lastPath);
        chooser.setMultiSelectionEnabled(true);
        for (FileFilter fileFilter : fileFilters) {
            chooser.addChoosableFileFilter(fileFilter);
        }
        if (initialFilter != null) {
            chooser.setFileFilter(initialFilter);
        }
        if ((returnFile = chooser.showOpenDialog(null)) == 0) {
            File[] files = chooser.getSelectedFiles();
            FileObject[] fileObjects = new FileObject[files.length];
            int i = 0;
            File gephiFile = null;
            for (File file : files) {
                file = FileUtil.normalizeFile((File)file);
                FileObject fileObject = FileUtil.toFileObject((File)file);
                fileObjects[i++] = fileObject;
                if (fileObject.getExt().equalsIgnoreCase("gephi")) {
                    if (gephiFile != null) {
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"ProjectControllerUI.error.multipleGephi"), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                        return;
                    }
                    gephiFile = file;
                }
                NbPreferences.forModule(ProjectControllerUIImpl.class).put("OpenFile_Last_Path", file.getAbsolutePath());
            }
            if (gephiFile != null) {
                if (this.controller.getCurrentProject() != null && !this.closeCurrentProject()) {
                    return;
                }
                try {
                    this.loadProject(gephiFile);
                }
                catch (Exception ew) {
                    Exceptions.printStackTrace((Throwable)ew);
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ProjectControllerUIImpl.class, (String)"OpenProject.defaulterror"), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                }
            } else {
                this.importControllerUI.importFiles(fileObjects);
            }
        }
    }

    @Override
    public Project getCurrentProject() {
        return this.controller.getCurrentProject();
    }

    @Override
    public Project newProject() {
        if (this.closeCurrentProject()) {
            this.controller.newProject();
            final Project project = this.controller.getCurrentProject();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
                    String title = frame.getTitle() + " - " + ((ProjectInformation)project.getLookup().lookup(ProjectInformation.class)).getName();
                    frame.setTitle(title);
                }
            });
            this.unlockProjectActions();
            return project;
        }
        return null;
    }

    @Override
    public void closeProject() {
        this.closeCurrentProject();
    }

    @Override
    public Workspace newWorkspace() {
        return this.controller.newWorkspace(this.controller.getCurrentProject());
    }

    @Override
    public void deleteWorkspace() {
        this.deleteWorkspace(this.controller.getCurrentWorkspace());
    }

    @Override
    public void deleteWorkspace(Workspace workspace) {
        if (((WorkspaceProvider)this.controller.getCurrentProject().getLookup().lookup(WorkspaceProvider.class)).getWorkspaces().length == 1) {
            this.saveProject = false;
            this.saveAsProject = false;
            this.projectProperties = false;
            this.closeProject = false;
            this.newWorkspace = false;
            this.deleteWorkspace = false;
            this.duplicateWorkspace = false;
            this.renameWorkspace = false;
            this.controller.closeCurrentProject();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
                    String title = frame.getTitle();
                    title = title.substring(0, title.indexOf(" - "));
                    frame.setTitle(title);
                }
            });
        } else {
            this.controller.deleteWorkspace(workspace);
        }
    }

    @Override
    public void renameWorkspace(String name) {
        this.controller.renameWorkspace(this.controller.getCurrentWorkspace(), name);
    }

    @Override
    public Workspace duplicateWorkspace() {
        return this.controller.duplicateWorkspace(this.controller.getCurrentWorkspace());
    }
}

