#pragma once

#include "IO.h"

namespace APE
{
#pragma pack(push, 1)

class CBufferIO : public CIO
{
public:
    // construction / destruction
    CBufferIO(CIO * pSource, int nBufferBytes);
    ~CBufferIO();

    // open / close
    int Open(const wchar_t * pName, bool bOpenReadOnly = false);
    int Close();

    // read / write
    int Read(void * pBuffer, unsigned int nBytesToRead, unsigned int * pBytesRead);
    int Write(const void * pBuffer, unsigned int nBytesToWrite, unsigned int * pBytesWritten);

    // seek
    int64 PerformSeek();

    // other functions
    int SetEOF();
    unsigned char * GetBuffer(int * pnBufferBytes);

    // creation / destruction
    int Create(const wchar_t * pName);
    int Delete();

    // attributes
    int64 GetPosition();
    int64 GetSize();
    int GetName(wchar_t * pBuffer);

private:

    CSmartPtr<CIO> m_spSource;
    CSmartPtr<unsigned char> m_spBuffer;
    int m_nBufferBytes;
    int m_nBufferTotalBytes;
    bool m_bReadToBuffer;
};

#pragma pack(pop)

}
