#pragma once

#include <cmath>

inline CString FormatDuration(double dSeconds, BOOL bAddDecimal = FALSE)
{
    if (std::isinf(dSeconds))
    {
        return _T("Unknown time");
    }

    int nHours = int(dSeconds) / 3600;
    dSeconds -= double(nHours) * 3600;

    int nMinutes = int(dSeconds) / 60;
    dSeconds -= double(nMinutes) * 60;

    int nSeconds = int(dSeconds);

    CString strDuration;

    if (bAddDecimal)
    {
        int nDecimal = int((dSeconds - double(nSeconds)) * 100);
        if (nHours > 0)
            strDuration.Format(_T("%d:%02d:%02d.%02d"), nHours, nMinutes, nSeconds, nDecimal);
        else
            strDuration.Format(_T("%d:%02d.%02d"), nMinutes, nSeconds, nDecimal);
    }
    else
    {
        if (nHours > 0)
            strDuration.Format(_T("%d:%02d:%02d"), nHours, nMinutes, nSeconds);
        else
            strDuration.Format(_T("%d:%02d"), nMinutes, nSeconds);
    }

    return strDuration;
}
