"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REQUEST = exports.NODE_API = exports.BASE_API_PATH = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const BASE_API_PATH = "/api/ism";
exports.BASE_API_PATH = BASE_API_PATH;
const NODE_API = Object.freeze({
  _SEARCH: `${BASE_API_PATH}/_search`,
  _SEARCH_SAMPLE_DATA: `${BASE_API_PATH}/_searchSampleData`,
  _INDICES: `${BASE_API_PATH}/_indices`,
  _DATA_STREAMS: `${BASE_API_PATH}/_data_streams`,
  _MAPPINGS: `${BASE_API_PATH}/_mappings`,
  APPLY_POLICY: `${BASE_API_PATH}/applyPolicy`,
  EDIT_ROLLOVER_ALIAS: `${BASE_API_PATH}/editRolloverAlias`,
  POLICIES: `${BASE_API_PATH}/policies`,
  _RECOVERY: `${BASE_API_PATH}/_recovery`,
  ROLLUPS: `${BASE_API_PATH}/rollups`,
  TRANSFORMS: `${BASE_API_PATH}/transforms`,
  MANAGED_INDICES: `${BASE_API_PATH}/managedIndices`,
  CHANNELS: `${BASE_API_PATH}/_notifications/channels`,
  RETRY: `${BASE_API_PATH}/retry`,
  CHANGE_POLICY: `${BASE_API_PATH}/changePolicy`,
  REMOVE_POLICY: `${BASE_API_PATH}/removePolicy`,
  SMPolicies: `${BASE_API_PATH}/smPolicies`,
  _SNAPSHOTS: `${BASE_API_PATH}/_snapshots`,
  _REPOSITORIES: `${BASE_API_PATH}/_repositores`
});
exports.NODE_API = NODE_API;
const REQUEST = Object.freeze({
  PUT: "PUT",
  DELETE: "DELETE",
  GET: "GET",
  POST: "POST",
  HEAD: "HEAD"
});
exports.REQUEST = REQUEST;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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