/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateRestoreImageTaskRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateRestoreImageTaskRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateRestoreImageTaskRequest> {
    private String bucket;
    private String objectKey;
    private String name;
    private SdkInternalList<TagSpecification> tagSpecifications;

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    public CreateRestoreImageTaskRequest withBucket(String bucket) {
        this.setBucket(bucket);
        return this;
    }

    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public CreateRestoreImageTaskRequest withObjectKey(String objectKey) {
        this.setObjectKey(objectKey);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateRestoreImageTaskRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public CreateRestoreImageTaskRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public CreateRestoreImageTaskRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    @Override
    public Request<CreateRestoreImageTaskRequest> getDryRunRequest() {
        Request<CreateRestoreImageTaskRequest> request = new CreateRestoreImageTaskRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucket() != null) {
            sb.append("Bucket: ").append(this.getBucket()).append(",");
        }
        if (this.getObjectKey() != null) {
            sb.append("ObjectKey: ").append(this.getObjectKey()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestoreImageTaskRequest)) {
            return false;
        }
        CreateRestoreImageTaskRequest other = (CreateRestoreImageTaskRequest)obj;
        if (other.getBucket() == null ^ this.getBucket() == null) {
            return false;
        }
        if (other.getBucket() != null && !other.getBucket().equals(this.getBucket())) {
            return false;
        }
        if (other.getObjectKey() == null ^ this.getObjectKey() == null) {
            return false;
        }
        if (other.getObjectKey() != null && !other.getObjectKey().equals(this.getObjectKey())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        return other.getTagSpecifications() == null || other.getTagSpecifications().equals(this.getTagSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucket() == null ? 0 : this.getBucket().hashCode());
        hashCode = 31 * hashCode + (this.getObjectKey() == null ? 0 : this.getObjectKey().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        return hashCode;
    }

    public CreateRestoreImageTaskRequest clone() {
        return (CreateRestoreImageTaskRequest)super.clone();
    }
}

