/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateRestoreImageTaskRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateRestoreImageTaskRequestMarshaller
implements Marshaller<Request<CreateRestoreImageTaskRequest>, CreateRestoreImageTaskRequest> {
    public Request<CreateRestoreImageTaskRequest> marshall(CreateRestoreImageTaskRequest createRestoreImageTaskRequest) {
        SdkInternalList createRestoreImageTaskRequestTagSpecificationsList;
        if (createRestoreImageTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createRestoreImageTaskRequest, "AmazonEC2");
        request.addParameter("Action", "CreateRestoreImageTask");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRestoreImageTaskRequest.getBucket() != null) {
            request.addParameter("Bucket", StringUtils.fromString((String)createRestoreImageTaskRequest.getBucket()));
        }
        if (createRestoreImageTaskRequest.getObjectKey() != null) {
            request.addParameter("ObjectKey", StringUtils.fromString((String)createRestoreImageTaskRequest.getObjectKey()));
        }
        if (createRestoreImageTaskRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString((String)createRestoreImageTaskRequest.getName()));
        }
        if (!(createRestoreImageTaskRequestTagSpecificationsList = (SdkInternalList)createRestoreImageTaskRequest.getTagSpecifications()).isEmpty() || !createRestoreImageTaskRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createRestoreImageTaskRequestTagSpecificationsListValue : createRestoreImageTaskRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createRestoreImageTaskRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createRestoreImageTaskRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createRestoreImageTaskRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

