/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateSnapshotsRequest;
import com.amazonaws.services.ec2.model.InstanceSpecification;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateSnapshotsRequestMarshaller
implements Marshaller<Request<CreateSnapshotsRequest>, CreateSnapshotsRequest> {
    public Request<CreateSnapshotsRequest> marshall(CreateSnapshotsRequest createSnapshotsRequest) {
        SdkInternalList createSnapshotsRequestTagSpecificationsList;
        InstanceSpecification instanceSpecification;
        if (createSnapshotsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSnapshotsRequest, "AmazonEC2");
        request.addParameter("Action", "CreateSnapshots");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSnapshotsRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createSnapshotsRequest.getDescription()));
        }
        if ((instanceSpecification = createSnapshotsRequest.getInstanceSpecification()) != null) {
            if (instanceSpecification.getInstanceId() != null) {
                request.addParameter("InstanceSpecification.InstanceId", StringUtils.fromString((String)instanceSpecification.getInstanceId()));
            }
            if (instanceSpecification.getExcludeBootVolume() != null) {
                request.addParameter("InstanceSpecification.ExcludeBootVolume", StringUtils.fromBoolean((Boolean)instanceSpecification.getExcludeBootVolume()));
            }
        }
        if (createSnapshotsRequest.getOutpostArn() != null) {
            request.addParameter("OutpostArn", StringUtils.fromString((String)createSnapshotsRequest.getOutpostArn()));
        }
        if (!(createSnapshotsRequestTagSpecificationsList = (SdkInternalList)createSnapshotsRequest.getTagSpecifications()).isEmpty() || !createSnapshotsRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createSnapshotsRequestTagSpecificationsListValue : createSnapshotsRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createSnapshotsRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createSnapshotsRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createSnapshotsRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createSnapshotsRequest.getCopyTagsFromSource() != null) {
            request.addParameter("CopyTagsFromSource", StringUtils.fromString((String)createSnapshotsRequest.getCopyTagsFromSource()));
        }
        return request;
    }
}

