/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AcceleratorCount;
import com.amazonaws.services.ec2.model.AcceleratorTotalMemoryMiB;
import com.amazonaws.services.ec2.model.BaselineEbsBandwidthMbps;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateSpecification;
import com.amazonaws.services.ec2.model.InstanceRequirements;
import com.amazonaws.services.ec2.model.LaunchTemplateConfig;
import com.amazonaws.services.ec2.model.LaunchTemplateOverrides;
import com.amazonaws.services.ec2.model.MemoryGiBPerVCpu;
import com.amazonaws.services.ec2.model.MemoryMiB;
import com.amazonaws.services.ec2.model.ModifySpotFleetRequestRequest;
import com.amazonaws.services.ec2.model.NetworkInterfaceCount;
import com.amazonaws.services.ec2.model.TotalLocalStorageGB;
import com.amazonaws.services.ec2.model.VCpuCountRange;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifySpotFleetRequestRequestMarshaller
implements Marshaller<Request<ModifySpotFleetRequestRequest>, ModifySpotFleetRequestRequest> {
    public Request<ModifySpotFleetRequestRequest> marshall(ModifySpotFleetRequestRequest modifySpotFleetRequestRequest) {
        SdkInternalList modifySpotFleetRequestRequestLaunchTemplateConfigsList;
        if (modifySpotFleetRequestRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifySpotFleetRequestRequest, "AmazonEC2");
        request.addParameter("Action", "ModifySpotFleetRequest");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifySpotFleetRequestRequest.getExcessCapacityTerminationPolicy() != null) {
            request.addParameter("ExcessCapacityTerminationPolicy", StringUtils.fromString((String)modifySpotFleetRequestRequest.getExcessCapacityTerminationPolicy()));
        }
        if (!(modifySpotFleetRequestRequestLaunchTemplateConfigsList = (SdkInternalList)modifySpotFleetRequestRequest.getLaunchTemplateConfigs()).isEmpty() || !modifySpotFleetRequestRequestLaunchTemplateConfigsList.isAutoConstruct()) {
            int launchTemplateConfigsListIndex = 1;
            for (LaunchTemplateConfig modifySpotFleetRequestRequestLaunchTemplateConfigsListValue : modifySpotFleetRequestRequestLaunchTemplateConfigsList) {
                SdkInternalList launchTemplateConfigOverridesList;
                FleetLaunchTemplateSpecification launchTemplateSpecification = modifySpotFleetRequestRequestLaunchTemplateConfigsListValue.getLaunchTemplateSpecification();
                if (launchTemplateSpecification != null) {
                    if (launchTemplateSpecification.getLaunchTemplateId() != null) {
                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateId", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateId()));
                    }
                    if (launchTemplateSpecification.getLaunchTemplateName() != null) {
                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateName", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateName()));
                    }
                    if (launchTemplateSpecification.getVersion() != null) {
                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.Version", StringUtils.fromString((String)launchTemplateSpecification.getVersion()));
                    }
                }
                if (!(launchTemplateConfigOverridesList = (SdkInternalList)modifySpotFleetRequestRequestLaunchTemplateConfigsListValue.getOverrides()).isEmpty() || !launchTemplateConfigOverridesList.isAutoConstruct()) {
                    int overridesListIndex = 1;
                    for (LaunchTemplateOverrides launchTemplateConfigOverridesListValue : launchTemplateConfigOverridesList) {
                        InstanceRequirements instanceRequirements;
                        if (launchTemplateConfigOverridesListValue.getInstanceType() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceType", StringUtils.fromString((String)launchTemplateConfigOverridesListValue.getInstanceType()));
                        }
                        if (launchTemplateConfigOverridesListValue.getSpotPrice() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SpotPrice", StringUtils.fromString((String)launchTemplateConfigOverridesListValue.getSpotPrice()));
                        }
                        if (launchTemplateConfigOverridesListValue.getSubnetId() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SubnetId", StringUtils.fromString((String)launchTemplateConfigOverridesListValue.getSubnetId()));
                        }
                        if (launchTemplateConfigOverridesListValue.getAvailabilityZone() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".AvailabilityZone", StringUtils.fromString((String)launchTemplateConfigOverridesListValue.getAvailabilityZone()));
                        }
                        if (launchTemplateConfigOverridesListValue.getWeightedCapacity() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".WeightedCapacity", StringUtils.fromDouble((Double)launchTemplateConfigOverridesListValue.getWeightedCapacity()));
                        }
                        if (launchTemplateConfigOverridesListValue.getPriority() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Priority", StringUtils.fromDouble((Double)launchTemplateConfigOverridesListValue.getPriority()));
                        }
                        if ((instanceRequirements = launchTemplateConfigOverridesListValue.getInstanceRequirements()) != null) {
                            AcceleratorTotalMemoryMiB acceleratorTotalMemoryMiB;
                            SdkInternalList instanceRequirementsAcceleratorNamesList;
                            SdkInternalList instanceRequirementsAcceleratorManufacturersList;
                            AcceleratorCount acceleratorCount;
                            SdkInternalList instanceRequirementsAcceleratorTypesList;
                            BaselineEbsBandwidthMbps baselineEbsBandwidthMbps;
                            TotalLocalStorageGB totalLocalStorageGB;
                            SdkInternalList instanceRequirementsLocalStorageTypesList;
                            NetworkInterfaceCount networkInterfaceCount;
                            SdkInternalList instanceRequirementsInstanceGenerationsList;
                            SdkInternalList instanceRequirementsExcludedInstanceTypesList;
                            MemoryGiBPerVCpu memoryGiBPerVCpu;
                            SdkInternalList instanceRequirementsCpuManufacturersList;
                            MemoryMiB memoryMiB;
                            VCpuCountRange vCpuCount = instanceRequirements.getVCpuCount();
                            if (vCpuCount != null) {
                                if (vCpuCount.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.VCpuCount.Min", StringUtils.fromInteger((Integer)vCpuCount.getMin()));
                                }
                                if (vCpuCount.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.VCpuCount.Max", StringUtils.fromInteger((Integer)vCpuCount.getMax()));
                                }
                            }
                            if ((memoryMiB = instanceRequirements.getMemoryMiB()) != null) {
                                if (memoryMiB.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryMiB.Min", StringUtils.fromInteger((Integer)memoryMiB.getMin()));
                                }
                                if (memoryMiB.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryMiB.Max", StringUtils.fromInteger((Integer)memoryMiB.getMax()));
                                }
                            }
                            if (!(instanceRequirementsCpuManufacturersList = (SdkInternalList)instanceRequirements.getCpuManufacturers()).isEmpty() || !instanceRequirementsCpuManufacturersList.isAutoConstruct()) {
                                int cpuManufacturersListIndex = 1;
                                for (String instanceRequirementsCpuManufacturersListValue : instanceRequirementsCpuManufacturersList) {
                                    if (instanceRequirementsCpuManufacturersListValue != null) {
                                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.CpuManufacturerSet." + cpuManufacturersListIndex, StringUtils.fromString((String)instanceRequirementsCpuManufacturersListValue));
                                    }
                                    ++cpuManufacturersListIndex;
                                }
                            }
                            if ((memoryGiBPerVCpu = instanceRequirements.getMemoryGiBPerVCpu()) != null) {
                                if (memoryGiBPerVCpu.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryGiBPerVCpu.Min", StringUtils.fromDouble((Double)memoryGiBPerVCpu.getMin()));
                                }
                                if (memoryGiBPerVCpu.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryGiBPerVCpu.Max", StringUtils.fromDouble((Double)memoryGiBPerVCpu.getMax()));
                                }
                            }
                            if (!(instanceRequirementsExcludedInstanceTypesList = (SdkInternalList)instanceRequirements.getExcludedInstanceTypes()).isEmpty() || !instanceRequirementsExcludedInstanceTypesList.isAutoConstruct()) {
                                int excludedInstanceTypesListIndex = 1;
                                for (Object instanceRequirementsExcludedInstanceTypesListValue : instanceRequirementsExcludedInstanceTypesList) {
                                    if (instanceRequirementsExcludedInstanceTypesListValue != null) {
                                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.ExcludedInstanceTypeSet." + excludedInstanceTypesListIndex, StringUtils.fromString((String)instanceRequirementsExcludedInstanceTypesListValue));
                                    }
                                    ++excludedInstanceTypesListIndex;
                                }
                            }
                            if (!(instanceRequirementsInstanceGenerationsList = (SdkInternalList)instanceRequirements.getInstanceGenerations()).isEmpty() || !instanceRequirementsInstanceGenerationsList.isAutoConstruct()) {
                                Object instanceRequirementsExcludedInstanceTypesListValue;
                                int instanceGenerationsListIndex = 1;
                                instanceRequirementsExcludedInstanceTypesListValue = instanceRequirementsInstanceGenerationsList.iterator();
                                while (instanceRequirementsExcludedInstanceTypesListValue.hasNext()) {
                                    String instanceRequirementsInstanceGenerationsListValue = (String)instanceRequirementsExcludedInstanceTypesListValue.next();
                                    if (instanceRequirementsInstanceGenerationsListValue != null) {
                                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.InstanceGenerationSet." + instanceGenerationsListIndex, StringUtils.fromString((String)instanceRequirementsInstanceGenerationsListValue));
                                    }
                                    ++instanceGenerationsListIndex;
                                }
                            }
                            if (instanceRequirements.getSpotMaxPricePercentageOverLowestPrice() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.SpotMaxPricePercentageOverLowestPrice", StringUtils.fromInteger((Integer)instanceRequirements.getSpotMaxPricePercentageOverLowestPrice()));
                            }
                            if (instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.OnDemandMaxPricePercentageOverLowestPrice", StringUtils.fromInteger((Integer)instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice()));
                            }
                            if (instanceRequirements.getBareMetal() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BareMetal", StringUtils.fromString((String)instanceRequirements.getBareMetal()));
                            }
                            if (instanceRequirements.getBurstablePerformance() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BurstablePerformance", StringUtils.fromString((String)instanceRequirements.getBurstablePerformance()));
                            }
                            if (instanceRequirements.getRequireHibernateSupport() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.RequireHibernateSupport", StringUtils.fromBoolean((Boolean)instanceRequirements.getRequireHibernateSupport()));
                            }
                            if ((networkInterfaceCount = instanceRequirements.getNetworkInterfaceCount()) != null) {
                                if (networkInterfaceCount.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.NetworkInterfaceCount.Min", StringUtils.fromInteger((Integer)networkInterfaceCount.getMin()));
                                }
                                if (networkInterfaceCount.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.NetworkInterfaceCount.Max", StringUtils.fromInteger((Integer)networkInterfaceCount.getMax()));
                                }
                            }
                            if (instanceRequirements.getLocalStorage() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.LocalStorage", StringUtils.fromString((String)instanceRequirements.getLocalStorage()));
                            }
                            if (!(instanceRequirementsLocalStorageTypesList = (SdkInternalList)instanceRequirements.getLocalStorageTypes()).isEmpty() || !instanceRequirementsLocalStorageTypesList.isAutoConstruct()) {
                                int localStorageTypesListIndex = 1;
                                for (String instanceRequirementsLocalStorageTypesListValue : instanceRequirementsLocalStorageTypesList) {
                                    if (instanceRequirementsLocalStorageTypesListValue != null) {
                                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.LocalStorageTypeSet." + localStorageTypesListIndex, StringUtils.fromString((String)instanceRequirementsLocalStorageTypesListValue));
                                    }
                                    ++localStorageTypesListIndex;
                                }
                            }
                            if ((totalLocalStorageGB = instanceRequirements.getTotalLocalStorageGB()) != null) {
                                if (totalLocalStorageGB.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.TotalLocalStorageGB.Min", StringUtils.fromDouble((Double)totalLocalStorageGB.getMin()));
                                }
                                if (totalLocalStorageGB.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.TotalLocalStorageGB.Max", StringUtils.fromDouble((Double)totalLocalStorageGB.getMax()));
                                }
                            }
                            if ((baselineEbsBandwidthMbps = instanceRequirements.getBaselineEbsBandwidthMbps()) != null) {
                                if (baselineEbsBandwidthMbps.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BaselineEbsBandwidthMbps.Min", StringUtils.fromInteger((Integer)baselineEbsBandwidthMbps.getMin()));
                                }
                                if (baselineEbsBandwidthMbps.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BaselineEbsBandwidthMbps.Max", StringUtils.fromInteger((Integer)baselineEbsBandwidthMbps.getMax()));
                                }
                            }
                            if (!(instanceRequirementsAcceleratorTypesList = (SdkInternalList)instanceRequirements.getAcceleratorTypes()).isEmpty() || !instanceRequirementsAcceleratorTypesList.isAutoConstruct()) {
                                int acceleratorTypesListIndex = 1;
                                for (String instanceRequirementsAcceleratorTypesListValue : instanceRequirementsAcceleratorTypesList) {
                                    if (instanceRequirementsAcceleratorTypesListValue != null) {
                                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorTypeSet." + acceleratorTypesListIndex, StringUtils.fromString((String)instanceRequirementsAcceleratorTypesListValue));
                                    }
                                    ++acceleratorTypesListIndex;
                                }
                            }
                            if ((acceleratorCount = instanceRequirements.getAcceleratorCount()) != null) {
                                if (acceleratorCount.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorCount.Min", StringUtils.fromInteger((Integer)acceleratorCount.getMin()));
                                }
                                if (acceleratorCount.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorCount.Max", StringUtils.fromInteger((Integer)acceleratorCount.getMax()));
                                }
                            }
                            if (!(instanceRequirementsAcceleratorManufacturersList = (SdkInternalList)instanceRequirements.getAcceleratorManufacturers()).isEmpty() || !instanceRequirementsAcceleratorManufacturersList.isAutoConstruct()) {
                                int acceleratorManufacturersListIndex = 1;
                                for (String instanceRequirementsAcceleratorManufacturersListValue : instanceRequirementsAcceleratorManufacturersList) {
                                    if (instanceRequirementsAcceleratorManufacturersListValue != null) {
                                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorManufacturerSet." + acceleratorManufacturersListIndex, StringUtils.fromString((String)instanceRequirementsAcceleratorManufacturersListValue));
                                    }
                                    ++acceleratorManufacturersListIndex;
                                }
                            }
                            if (!(instanceRequirementsAcceleratorNamesList = (SdkInternalList)instanceRequirements.getAcceleratorNames()).isEmpty() || !instanceRequirementsAcceleratorNamesList.isAutoConstruct()) {
                                int acceleratorNamesListIndex = 1;
                                for (String instanceRequirementsAcceleratorNamesListValue : instanceRequirementsAcceleratorNamesList) {
                                    if (instanceRequirementsAcceleratorNamesListValue != null) {
                                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorNameSet." + acceleratorNamesListIndex, StringUtils.fromString((String)instanceRequirementsAcceleratorNamesListValue));
                                    }
                                    ++acceleratorNamesListIndex;
                                }
                            }
                            if ((acceleratorTotalMemoryMiB = instanceRequirements.getAcceleratorTotalMemoryMiB()) != null) {
                                if (acceleratorTotalMemoryMiB.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorTotalMemoryMiB.Min", StringUtils.fromInteger((Integer)acceleratorTotalMemoryMiB.getMin()));
                                }
                                if (acceleratorTotalMemoryMiB.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorTotalMemoryMiB.Max", StringUtils.fromInteger((Integer)acceleratorTotalMemoryMiB.getMax()));
                                }
                            }
                        }
                        ++overridesListIndex;
                    }
                }
                ++launchTemplateConfigsListIndex;
            }
        }
        if (modifySpotFleetRequestRequest.getSpotFleetRequestId() != null) {
            request.addParameter("SpotFleetRequestId", StringUtils.fromString((String)modifySpotFleetRequestRequest.getSpotFleetRequestId()));
        }
        if (modifySpotFleetRequestRequest.getTargetCapacity() != null) {
            request.addParameter("TargetCapacity", StringUtils.fromInteger((Integer)modifySpotFleetRequestRequest.getTargetCapacity()));
        }
        if (modifySpotFleetRequestRequest.getOnDemandTargetCapacity() != null) {
            request.addParameter("OnDemandTargetCapacity", StringUtils.fromInteger((Integer)modifySpotFleetRequestRequest.getOnDemandTargetCapacity()));
        }
        if (modifySpotFleetRequestRequest.getContext() != null) {
            request.addParameter("Context", StringUtils.fromString((String)modifySpotFleetRequestRequest.getContext()));
        }
        return request;
    }
}

