/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.RelevanceQuery;

abstract class MultiFieldQuery<T extends QueryBuilder>
extends RelevanceQuery<T> {
    public MultiFieldQuery(Map<String, RelevanceQuery.QueryBuilderStep<T>> queryBuildActions) {
        super(queryBuildActions);
    }

    @Override
    public T createQueryBuilder(List<NamedArgumentExpression> arguments) {
        NamedArgumentExpression fields = arguments.stream().filter(a -> a.getArgName().equalsIgnoreCase("fields")).findFirst().orElseThrow(() -> new SemanticCheckException("'fields' parameter is missing."));
        NamedArgumentExpression query = arguments.stream().filter(a -> a.getArgName().equalsIgnoreCase("query")).findFirst().orElseThrow(() -> new SemanticCheckException("'query' parameter is missing"));
        ImmutableMap fieldsAndWeights = (ImmutableMap)fields.getValue().valueOf(null).tupleValue().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (String)e.getKey(), e -> ((ExprValue)e.getValue()).floatValue()));
        return this.createBuilder((ImmutableMap<String, Float>)fieldsAndWeights, query.getValue().valueOf(null).stringValue());
    }

    protected abstract T createBuilder(ImmutableMap<String, Float> var1, String var2);
}

