/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl.config;

import org.opensearch.sql.catalog.CatalogService;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.expression.config.ExpressionConfig;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.ppl.PPLService;
import org.opensearch.sql.ppl.antlr.PPLSyntaxParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={ExpressionConfig.class})
public class PPLServiceConfig {
    @Autowired
    private ExecutionEngine executionEngine;
    @Autowired
    private CatalogService catalogService;
    @Autowired
    private BuiltinFunctionRepository functionRepository;

    @Bean
    public PPLService pplService() {
        this.catalogService.getCatalogs().forEach(catalog -> catalog.getStorageEngine().getFunctions().forEach(functionResolver -> this.functionRepository.register(catalog.getName(), functionResolver)));
        return new PPLService(new PPLSyntaxParser(), this.executionEngine, this.functionRepository, this.catalogService);
    }
}

