/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.functions.resolver;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.function.FunctionSignature;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.functions.implementation.QueryRangeFunctionImplementation;

public class QueryRangeTableFunctionResolver
implements FunctionResolver {
    private final PrometheusClient prometheusClient;
    public static final String QUERY_RANGE = "query_range";
    public static final String QUERY = "query";
    public static final String STARTTIME = "starttime";
    public static final String ENDTIME = "endtime";
    public static final String STEP = "step";

    public Pair<FunctionSignature, FunctionBuilder> resolve(FunctionSignature unresolvedSignature) {
        FunctionName functionName = FunctionName.of((String)QUERY_RANGE);
        FunctionSignature functionSignature = new FunctionSignature(functionName, List.of(ExprCoreType.STRING, ExprCoreType.LONG, ExprCoreType.LONG, ExprCoreType.LONG));
        List<String> argumentNames = List.of(QUERY, STARTTIME, ENDTIME, STEP);
        FunctionBuilder functionBuilder = arguments -> {
            Boolean argumentsPassedByName = arguments.stream().noneMatch(arg -> StringUtils.isEmpty((CharSequence)((NamedArgumentExpression)arg).getArgName()));
            Boolean argumentsPassedByPosition = arguments.stream().allMatch(arg -> StringUtils.isEmpty((CharSequence)((NamedArgumentExpression)arg).getArgName()));
            if (!argumentsPassedByName.booleanValue() && !argumentsPassedByPosition.booleanValue()) {
                throw new SemanticCheckException("Arguments should be either passed by name or position");
            }
            if (arguments.size() != argumentNames.size()) {
                throw new SemanticCheckException(this.generateErrorMessageForMissingArguments(argumentsPassedByPosition, arguments, argumentNames));
            }
            if (argumentsPassedByPosition.booleanValue()) {
                ArrayList<Expression> namedArguments = new ArrayList<Expression>();
                for (int i = 0; i < arguments.size(); ++i) {
                    namedArguments.add((Expression)new NamedArgumentExpression((String)argumentNames.get(i), ((NamedArgumentExpression)arguments.get(i)).getValue()));
                }
                return new QueryRangeFunctionImplementation(functionName, namedArguments, this.prometheusClient);
            }
            return new QueryRangeFunctionImplementation(functionName, arguments, this.prometheusClient);
        };
        return Pair.of((Object)functionSignature, (Object)functionBuilder);
    }

    private String generateErrorMessageForMissingArguments(Boolean argumentsPassedByPosition, List<Expression> arguments, List<String> argumentNames) {
        if (argumentsPassedByPosition.booleanValue()) {
            return String.format("Missing arguments:[%s]", String.join((CharSequence)",", argumentNames.subList(arguments.size(), argumentNames.size())));
        }
        HashSet<String> requiredArguments = new HashSet<String>(argumentNames);
        Set providedArguments = arguments.stream().map(expression -> ((NamedArgumentExpression)expression).getArgName()).collect(Collectors.toSet());
        requiredArguments.removeAll(providedArguments);
        return String.format("Missing arguments:[%s]", String.join((CharSequence)",", requiredArguments));
    }

    public FunctionName getFunctionName() {
        return FunctionName.of((String)QUERY_RANGE);
    }

    @Generated
    public QueryRangeTableFunctionResolver(PrometheusClient prometheusClient) {
        this.prometheusClient = prometheusClient;
    }
}

