/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.storage;

import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.opensearch.sql.CatalogSchemaName;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.functions.resolver.QueryRangeTableFunctionResolver;
import org.opensearch.sql.prometheus.storage.PrometheusMetricTable;
import org.opensearch.sql.prometheus.storage.system.PrometheusSystemTable;
import org.opensearch.sql.storage.StorageEngine;
import org.opensearch.sql.storage.Table;
import org.opensearch.sql.utils.SystemIndexUtils;

public class PrometheusStorageEngine
implements StorageEngine {
    private final PrometheusClient prometheusClient;

    public Collection<FunctionResolver> getFunctions() {
        return Collections.singletonList(new QueryRangeTableFunctionResolver(this.prometheusClient));
    }

    public Table getTable(CatalogSchemaName catalogSchemaName, String tableName) {
        if (SystemIndexUtils.isSystemIndex((String)tableName).booleanValue()) {
            return new PrometheusSystemTable(this.prometheusClient, catalogSchemaName, tableName);
        }
        if ("information_schema".equals(catalogSchemaName.getSchemaName())) {
            return this.resolveInformationSchemaTable(catalogSchemaName, tableName);
        }
        return new PrometheusMetricTable(this.prometheusClient, tableName);
    }

    private Table resolveInformationSchemaTable(CatalogSchemaName catalogSchemaName, String tableName) {
        if ("tables".equals(tableName)) {
            return new PrometheusSystemTable(this.prometheusClient, catalogSchemaName, "ALL.META_ODFE_SYS_TABLE");
        }
        throw new SemanticCheckException(String.format("Information Schema doesn't contain %s table", tableName));
    }

    @Generated
    public PrometheusStorageEngine(PrometheusClient prometheusClient) {
        this.prometheusClient = prometheusClient;
    }
}

