/* LanguageListBox.c generated by valac 0.56.3, the Vala compiler
 * generated from LanguageListBox.vala, do not modify */

/* Copyright 2015-2019 elementary, Inc. (https://elementary.io)
*
* This program is free software: you can redistribute it
* and/or modify it under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program. If not, see http://www.gnu.org/licenses/.
*/

#include "locale-plug.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libgnome-desktop/gnome-languages.h>
#include <glib/gi18n-lib.h>
#include <granite.h>

#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW (switchboard_plug_locale_widgets_language_list_box_language_row_get_type ())
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow))
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowClass))
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_IS_LANGUAGE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW))
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_IS_LANGUAGE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW))
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowClass))

typedef struct _SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow;
typedef struct _SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowClass SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowClass;
enum  {
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_0_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_locale_widgets_language_list_box_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowPrivate SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowPrivate;
enum  {
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_0_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CODE_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_TEXT_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CURRENT_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_locale_widgets_language_list_box_language_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_NUM_PROPERTIES];

struct _SwitchboardPlugLocaleWidgetsLanguageListBoxPrivate {
	GeeHashMap* languages;
	SwitchboardPlugLocaleLocaleManager* lm;
	GtkLabel* installed_languages_label;
};

struct _SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow {
	GtkListBoxRow parent_instance;
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowPrivate * priv;
};

struct _SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowClass {
	GtkListBoxRowClass parent_class;
};

struct _SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowPrivate {
	gchar* _code;
	gchar* _text;
	gboolean _current;
	GtkImage* image;
};

static gint SwitchboardPlugLocaleWidgetsLanguageListBox_private_offset;
static gpointer switchboard_plug_locale_widgets_language_list_box_parent_class = NULL;
static gint SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow_private_offset;
static gpointer switchboard_plug_locale_widgets_language_list_box_language_row_parent_class = NULL;

static GType switchboard_plug_locale_widgets_language_list_box_language_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void __lambda4_ (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                 GtkWidget* item);
static void ___lambda4__gtk_callback (GtkWidget* widget,
                               gpointer self);
static gint __lambda5_ (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                 const gchar* a,
                 const gchar* b);
static gint ___lambda5__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static void switchboard_plug_locale_widgets_language_list_box_add_language (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                                                                     const gchar* code);
static gboolean switchboard_plug_locale_widgets_language_list_box_language_row_get_current (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self);
static SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* switchboard_plug_locale_widgets_language_list_box_language_row_new (const gchar* code,
                                                                                                                            const gchar* text,
                                                                                                                            gboolean current);
static SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* switchboard_plug_locale_widgets_language_list_box_language_row_construct (GType object_type,
                                                                                                                                  const gchar* code,
                                                                                                                                  const gchar* text,
                                                                                                                                  gboolean current);
static const gchar* switchboard_plug_locale_widgets_language_list_box_language_row_get_code (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self);
static void switchboard_plug_locale_widgets_language_list_box_language_row_set_current (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self,
                                                                                 gboolean value);
static void switchboard_plug_locale_widgets_language_list_box_update_headers (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                                                                       GtkListBoxRow* row,
                                                                       GtkListBoxRow* before);
static void switchboard_plug_locale_widgets_language_list_box_language_row_set_code (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self,
                                                                              const gchar* value);
static const gchar* switchboard_plug_locale_widgets_language_list_box_language_row_get_text (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self);
static void switchboard_plug_locale_widgets_language_list_box_language_row_set_text (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self,
                                                                              const gchar* value);
static GObject * switchboard_plug_locale_widgets_language_list_box_language_row_constructor (GType type,
                                                                                      guint n_construct_properties,
                                                                                      GObjectConstructParam * construct_properties);
static void switchboard_plug_locale_widgets_language_list_box_language_row_finalize (GObject * obj);
static GType switchboard_plug_locale_widgets_language_list_box_language_row_get_type_once (void);
static void _vala_switchboard_plug_locale_widgets_language_list_box_language_row_get_property (GObject * object,
                                                                                        guint property_id,
                                                                                        GValue * value,
                                                                                        GParamSpec * pspec);
static void _vala_switchboard_plug_locale_widgets_language_list_box_language_row_set_property (GObject * object,
                                                                                        guint property_id,
                                                                                        const GValue * value,
                                                                                        GParamSpec * pspec);
static GObject * switchboard_plug_locale_widgets_language_list_box_constructor (GType type,
                                                                         guint n_construct_properties,
                                                                         GObjectConstructParam * construct_properties);
static void _switchboard_plug_locale_widgets_language_list_box_update_headers_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                                        GtkListBoxRow* before,
                                                                                                        gpointer self);
static void switchboard_plug_locale_widgets_language_list_box_finalize (GObject * obj);
static GType switchboard_plug_locale_widgets_language_list_box_get_type_once (void);

static inline gpointer
switchboard_plug_locale_widgets_language_list_box_get_instance_private (SwitchboardPlugLocaleWidgetsLanguageListBox* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugLocaleWidgetsLanguageListBox_private_offset);
}

static void
__lambda4_ (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
            GtkWidget* item)
{
	g_return_if_fail (item != NULL);
	gtk_container_remove ((GtkContainer*) self, item);
}

static void
___lambda4__gtk_callback (GtkWidget* widget,
                          gpointer self)
{
	__lambda4_ ((SwitchboardPlugLocaleWidgetsLanguageListBox*) self, widget);
}

static gint
__lambda5_ (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
            const gchar* a,
            const gchar* b)
{
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = g_utf8_collate (a, b);
	return result;
}

static gint
___lambda5__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda5_ ((SwitchboardPlugLocaleWidgetsLanguageListBox*) self, (const gchar*) a, (const gchar*) b);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
switchboard_plug_locale_widgets_language_list_box_reload_languages (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                                                                    GeeArrayList* langs)
{
	GeeHashMap* _tmp0_;
	GList* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (langs != NULL);
	_tmp0_ = self->priv->languages;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	gtk_container_foreach ((GtkContainer*) self, ___lambda4__gtk_callback, self);
	gee_list_sort ((GeeList*) langs, ___lambda5__gcompare_data_func, g_object_ref (self), g_object_unref);
	{
		GeeArrayList* _locale_list = NULL;
		gint _locale_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _locale_index = 0;
		_locale_list = langs;
		_tmp1_ = _locale_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_locale_size = _tmp3_;
		_locale_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gchar* locale = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gchar* code = NULL;
			const gchar* _tmp8_;
			gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			const gchar* _tmp11_;
			_locale_index = _locale_index + 1;
			_tmp4_ = _locale_index;
			_tmp5_ = _locale_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _locale_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _locale_index);
			locale = (gchar*) _tmp7_;
			_tmp8_ = locale;
			_tmp10_ = gnome_parse_locale (_tmp8_, &_tmp9_, NULL, NULL, NULL);
			_g_free0 (code);
			code = _tmp9_;
			if (!_tmp10_) {
				_g_free0 (code);
				_g_free0 (locale);
				continue;
			}
			_tmp11_ = code;
			switchboard_plug_locale_widgets_language_list_box_add_language (self, _tmp11_);
			_g_free0 (code);
			_g_free0 (locale);
		}
	}
	_tmp12_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp12_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* _tmp13_;
			GtkWidget* row = NULL;
			_tmp13_ = _g_object_ref0 ((GtkWidget*) row_it->data);
			row = _tmp13_;
			{
				GtkWidget* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				_tmp14_ = row;
				_tmp15_ = switchboard_plug_locale_widgets_language_list_box_language_row_get_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow));
				_tmp16_ = _tmp15_;
				if (_tmp16_) {
					GtkWidget* _tmp17_;
					_tmp17_ = row;
					gtk_list_box_select_row ((GtkListBox*) self, (GtkListBoxRow*) G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow));
				}
				_g_object_unref0 (row);
			}
		}
		(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
	}
	gtk_widget_show_all ((GtkWidget*) self);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
switchboard_plug_locale_widgets_language_list_box_add_language (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                                                                const gchar* code)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (code != NULL);
	_tmp0_ = self->priv->languages;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, code)) {
		gchar* language_string = NULL;
		gchar* _tmp1_;
		SwitchboardPlugLocaleLocaleManager* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		GeeHashMap* _tmp16_;
		gpointer _tmp17_;
		SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp18_;
		_tmp1_ = switchboard_plug_locale_utils_translate (code, NULL);
		language_string = _tmp1_;
		_tmp2_ = self->priv->lm;
		_tmp3_ = switchboard_plug_locale_locale_manager_get_user_language (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = string_slice (_tmp4_, (glong) 0, (glong) 2);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp6_, code) == 0;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		if (_tmp7_) {
			GeeHashMap* _tmp8_;
			const gchar* _tmp9_;
			SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp10_;
			SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp11_;
			_tmp8_ = self->priv->languages;
			_tmp9_ = language_string;
			_tmp10_ = switchboard_plug_locale_widgets_language_list_box_language_row_new (code, _tmp9_, TRUE);
			g_object_ref_sink (_tmp10_);
			_tmp11_ = _tmp10_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, code, _tmp11_);
			_g_object_unref0 (_tmp11_);
		} else {
			GeeHashMap* _tmp12_;
			const gchar* _tmp13_;
			SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp14_;
			SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp15_;
			_tmp12_ = self->priv->languages;
			_tmp13_ = language_string;
			_tmp14_ = switchboard_plug_locale_widgets_language_list_box_language_row_new (code, _tmp13_, FALSE);
			g_object_ref_sink (_tmp14_);
			_tmp15_ = _tmp14_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, code, _tmp15_);
			_g_object_unref0 (_tmp15_);
		}
		_tmp16_ = self->priv->languages;
		_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, code);
		_tmp18_ = (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow*) _tmp17_;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp18_);
		_g_object_unref0 (_tmp18_);
		_g_free0 (language_string);
	}
	gtk_widget_show_all ((GtkWidget*) self);
}

void
switchboard_plug_locale_widgets_language_list_box_set_current (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                                                               const gchar* code)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (code != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp0_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* _tmp1_;
			GtkWidget* row = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWidget*) row_it->data);
			row = _tmp1_;
			{
				GtkWidget* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = row;
				_tmp3_ = switchboard_plug_locale_widgets_language_list_box_language_row_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow));
				_tmp4_ = _tmp3_;
				if (g_strcmp0 (_tmp4_, code) == 0) {
					GtkWidget* _tmp5_;
					_tmp5_ = row;
					switchboard_plug_locale_widgets_language_list_box_language_row_set_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow), TRUE);
				} else {
					GtkWidget* _tmp6_;
					_tmp6_ = row;
					switchboard_plug_locale_widgets_language_list_box_language_row_set_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow), FALSE);
				}
				_g_object_unref0 (row);
			}
		}
		(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
	}
}

static void
switchboard_plug_locale_widgets_language_list_box_update_headers (SwitchboardPlugLocaleWidgetsLanguageListBox* self,
                                                                  GtkListBoxRow* row,
                                                                  GtkListBoxRow* before)
{
	GtkListBoxRow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = gtk_list_box_get_row_at_index ((GtkListBox*) self, 0);
	if (row == _tmp0_) {
		GtkLabel* _tmp1_;
		_tmp1_ = self->priv->installed_languages_label;
		gtk_list_box_row_set_header (row, (GtkWidget*) _tmp1_);
	}
}

gchar*
switchboard_plug_locale_widgets_language_list_box_get_selected_language_code (SwitchboardPlugLocaleWidgetsLanguageListBox* self)
{
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* selected_row = NULL;
	GtkListBoxRow* _tmp0_;
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp1_;
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_IS_LANGUAGE_ROW (_tmp0_) ? ((SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow*) _tmp0_) : NULL);
	selected_row = _tmp1_;
	_tmp2_ = selected_row;
	if (_tmp2_ != NULL) {
		SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = selected_row;
		_tmp4_ = switchboard_plug_locale_widgets_language_list_box_language_row_get_code (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		_g_object_unref0 (selected_row);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (selected_row);
		return result;
	}
}

SwitchboardPlugLocaleWidgetsLanguageListBox*
switchboard_plug_locale_widgets_language_list_box_construct (GType object_type)
{
	SwitchboardPlugLocaleWidgetsLanguageListBox * self = NULL;
	self = (SwitchboardPlugLocaleWidgetsLanguageListBox*) g_object_new (object_type, NULL);
	return self;
}

SwitchboardPlugLocaleWidgetsLanguageListBox*
switchboard_plug_locale_widgets_language_list_box_new (void)
{
	return switchboard_plug_locale_widgets_language_list_box_construct (SWITCHBOARD_PLUG_LOCALE_WIDGETS_TYPE_LANGUAGE_LIST_BOX);
}

static inline gpointer
switchboard_plug_locale_widgets_language_list_box_language_row_get_instance_private (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow_private_offset);
}

static SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow*
switchboard_plug_locale_widgets_language_list_box_language_row_construct (GType object_type,
                                                                          const gchar* code,
                                                                          const gchar* text,
                                                                          gboolean current)
{
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow * self = NULL;
	g_return_val_if_fail (code != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	self = (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow*) g_object_new (object_type, "code", code, "current", current, "text", text, NULL);
	return self;
}

static SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow*
switchboard_plug_locale_widgets_language_list_box_language_row_new (const gchar* code,
                                                                    const gchar* text,
                                                                    gboolean current)
{
	return switchboard_plug_locale_widgets_language_list_box_language_row_construct (SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, code, text, current);
}

static const gchar*
switchboard_plug_locale_widgets_language_list_box_language_row_get_code (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_code;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_locale_widgets_language_list_box_language_row_set_code (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self,
                                                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_locale_widgets_language_list_box_language_row_get_code (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_code);
		self->priv->_code = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_widgets_language_list_box_language_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CODE_PROPERTY]);
	}
}

static const gchar*
switchboard_plug_locale_widgets_language_list_box_language_row_get_text (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_locale_widgets_language_list_box_language_row_set_text (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self,
                                                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_locale_widgets_language_list_box_language_row_get_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_text);
		self->priv->_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_widgets_language_list_box_language_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_TEXT_PROPERTY]);
	}
}

static gboolean
switchboard_plug_locale_widgets_language_list_box_language_row_get_current (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_current;
	return result;
}

static void
switchboard_plug_locale_widgets_language_list_box_language_row_set_current (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow* self,
                                                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		GtkImage* _tmp0_;
		GtkImage* _tmp1_;
		_tmp0_ = self->priv->image;
		g_object_set (_tmp0_, "icon-name", "selection-checked", NULL);
		_tmp1_ = self->priv->image;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp1_, _ ("Currently active language"));
	} else {
		GtkImage* _tmp2_;
		GtkImage* _tmp3_;
		_tmp2_ = self->priv->image;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, "");
		_tmp3_ = self->priv->image;
		gtk_image_clear (_tmp3_);
	}
	self->priv->_current = value;
	g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_widgets_language_list_box_language_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CURRENT_PROPERTY]);
}

static GObject *
switchboard_plug_locale_widgets_language_list_box_language_row_constructor (GType type,
                                                                            guint n_construct_properties,
                                                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow * self;
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkImage* _tmp3_;
	GtkLabel* label = NULL;
	const gchar* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	GtkGrid* _tmp9_;
	GtkGrid* _tmp10_;
	GtkLabel* _tmp11_;
	GtkGrid* _tmp12_;
	GtkImage* _tmp13_;
	GtkGrid* _tmp14_;
	parent_class = G_OBJECT_CLASS (switchboard_plug_locale_widgets_language_list_box_language_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow);
	_tmp0_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp0_;
	_tmp1_ = self->priv->image;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->image;
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_END);
	_tmp3_ = self->priv->image;
	g_object_set (_tmp3_, "icon-size", (gint) GTK_ICON_SIZE_BUTTON, NULL);
	_tmp4_ = self->priv->_text;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	label = _tmp5_;
	_tmp6_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_START);
	_tmp7_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp7_);
	grid = _tmp7_;
	_tmp8_ = grid;
	gtk_grid_set_column_spacing (_tmp8_, 6);
	_tmp9_ = grid;
	g_object_set ((GtkWidget*) _tmp9_, "margin", 6, NULL);
	_tmp10_ = grid;
	_tmp11_ = label;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = grid;
	_tmp13_ = self->priv->image;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp14_);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (grid);
	_g_object_unref0 (label);
	return obj;
}

static void
switchboard_plug_locale_widgets_language_list_box_language_row_class_init (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowClass * klass,
                                                                           gpointer klass_data)
{
	switchboard_plug_locale_widgets_language_list_box_language_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_plug_locale_widgets_language_list_box_language_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_plug_locale_widgets_language_list_box_language_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_plug_locale_widgets_language_list_box_language_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_locale_widgets_language_list_box_language_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CODE_PROPERTY, switchboard_plug_locale_widgets_language_list_box_language_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CODE_PROPERTY] = g_param_spec_string ("code", "code", "code", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_TEXT_PROPERTY, switchboard_plug_locale_widgets_language_list_box_language_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CURRENT_PROPERTY, switchboard_plug_locale_widgets_language_list_box_language_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CURRENT_PROPERTY] = g_param_spec_boolean ("current", "current", "current", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
switchboard_plug_locale_widgets_language_list_box_language_row_instance_init (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow * self,
                                                                              gpointer klass)
{
	self->priv = switchboard_plug_locale_widgets_language_list_box_language_row_get_instance_private (self);
}

static void
switchboard_plug_locale_widgets_language_list_box_language_row_finalize (GObject * obj)
{
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow);
	_g_free0 (self->priv->_code);
	_g_free0 (self->priv->_text);
	_g_object_unref0 (self->priv->image);
	G_OBJECT_CLASS (switchboard_plug_locale_widgets_language_list_box_language_row_parent_class)->finalize (obj);
}

static GType
switchboard_plug_locale_widgets_language_list_box_language_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_locale_widgets_language_list_box_language_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow), 0, (GInstanceInitFunc) switchboard_plug_locale_widgets_language_list_box_language_row_instance_init, NULL };
	GType switchboard_plug_locale_widgets_language_list_box_language_row_type_id;
	switchboard_plug_locale_widgets_language_list_box_language_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow", &g_define_type_info, 0);
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow_private_offset = g_type_add_instance_private (switchboard_plug_locale_widgets_language_list_box_language_row_type_id, sizeof (SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRowPrivate));
	return switchboard_plug_locale_widgets_language_list_box_language_row_type_id;
}

static GType
switchboard_plug_locale_widgets_language_list_box_language_row_get_type (void)
{
	static volatile gsize switchboard_plug_locale_widgets_language_list_box_language_row_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_locale_widgets_language_list_box_language_row_type_id__once)) {
		GType switchboard_plug_locale_widgets_language_list_box_language_row_type_id;
		switchboard_plug_locale_widgets_language_list_box_language_row_type_id = switchboard_plug_locale_widgets_language_list_box_language_row_get_type_once ();
		g_once_init_leave (&switchboard_plug_locale_widgets_language_list_box_language_row_type_id__once, switchboard_plug_locale_widgets_language_list_box_language_row_type_id);
	}
	return switchboard_plug_locale_widgets_language_list_box_language_row_type_id__once;
}

static void
_vala_switchboard_plug_locale_widgets_language_list_box_language_row_get_property (GObject * object,
                                                                                   guint property_id,
                                                                                   GValue * value,
                                                                                   GParamSpec * pspec)
{
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow);
	switch (property_id) {
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CODE_PROPERTY:
		g_value_set_string (value, switchboard_plug_locale_widgets_language_list_box_language_row_get_code (self));
		break;
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_TEXT_PROPERTY:
		g_value_set_string (value, switchboard_plug_locale_widgets_language_list_box_language_row_get_text (self));
		break;
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CURRENT_PROPERTY:
		g_value_set_boolean (value, switchboard_plug_locale_widgets_language_list_box_language_row_get_current (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_plug_locale_widgets_language_list_box_language_row_set_property (GObject * object,
                                                                                   guint property_id,
                                                                                   const GValue * value,
                                                                                   GParamSpec * pspec)
{
	SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, SwitchboardPlugLocaleWidgetsLanguageListBoxLanguageRow);
	switch (property_id) {
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CODE_PROPERTY:
		switchboard_plug_locale_widgets_language_list_box_language_row_set_code (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_TEXT_PROPERTY:
		switchboard_plug_locale_widgets_language_list_box_language_row_set_text (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_LANGUAGE_ROW_CURRENT_PROPERTY:
		switchboard_plug_locale_widgets_language_list_box_language_row_set_current (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_switchboard_plug_locale_widgets_language_list_box_update_headers_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                                   GtkListBoxRow* before,
                                                                                                   gpointer self)
{
	switchboard_plug_locale_widgets_language_list_box_update_headers ((SwitchboardPlugLocaleWidgetsLanguageListBox*) self, row, before);
}

static GObject *
switchboard_plug_locale_widgets_language_list_box_constructor (GType type,
                                                               guint n_construct_properties,
                                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardPlugLocaleWidgetsLanguageListBox * self;
	GeeHashMap* _tmp0_;
	SwitchboardPlugLocaleLocaleManager* _tmp1_;
	SwitchboardPlugLocaleLocaleManager* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkStyleContext* _tmp6_;
	parent_class = G_OBJECT_CLASS (switchboard_plug_locale_widgets_language_list_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_WIDGETS_TYPE_LANGUAGE_LIST_BOX, SwitchboardPlugLocaleWidgetsLanguageListBox);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LANGUAGE_LIST_BOX_TYPE_LANGUAGE_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->languages);
	self->priv->languages = _tmp0_;
	_tmp1_ = switchboard_plug_locale_locale_manager_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->lm);
	self->priv->lm = _tmp2_;
	_tmp3_ = (GtkLabel*) gtk_label_new (_ ("Installed Languages"));
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->installed_languages_label);
	self->priv->installed_languages_label = _tmp3_;
	_tmp4_ = self->priv->installed_languages_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	_tmp5_ = self->priv->installed_languages_label;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, GRANITE_STYLE_CLASS_H4_LABEL);
	gtk_list_box_set_header_func ((GtkListBox*) self, _switchboard_plug_locale_widgets_language_list_box_update_headers_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	return obj;
}

static void
switchboard_plug_locale_widgets_language_list_box_class_init (SwitchboardPlugLocaleWidgetsLanguageListBoxClass * klass,
                                                              gpointer klass_data)
{
	switchboard_plug_locale_widgets_language_list_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugLocaleWidgetsLanguageListBox_private_offset);
	G_OBJECT_CLASS (klass)->constructor = switchboard_plug_locale_widgets_language_list_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_locale_widgets_language_list_box_finalize;
}

static void
switchboard_plug_locale_widgets_language_list_box_instance_init (SwitchboardPlugLocaleWidgetsLanguageListBox * self,
                                                                 gpointer klass)
{
	self->priv = switchboard_plug_locale_widgets_language_list_box_get_instance_private (self);
}

static void
switchboard_plug_locale_widgets_language_list_box_finalize (GObject * obj)
{
	SwitchboardPlugLocaleWidgetsLanguageListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_WIDGETS_TYPE_LANGUAGE_LIST_BOX, SwitchboardPlugLocaleWidgetsLanguageListBox);
	_g_object_unref0 (self->priv->languages);
	_g_object_unref0 (self->priv->lm);
	_g_object_unref0 (self->priv->installed_languages_label);
	G_OBJECT_CLASS (switchboard_plug_locale_widgets_language_list_box_parent_class)->finalize (obj);
}

static GType
switchboard_plug_locale_widgets_language_list_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugLocaleWidgetsLanguageListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_locale_widgets_language_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugLocaleWidgetsLanguageListBox), 0, (GInstanceInitFunc) switchboard_plug_locale_widgets_language_list_box_instance_init, NULL };
	GType switchboard_plug_locale_widgets_language_list_box_type_id;
	switchboard_plug_locale_widgets_language_list_box_type_id = g_type_register_static (gtk_list_box_get_type (), "SwitchboardPlugLocaleWidgetsLanguageListBox", &g_define_type_info, 0);
	SwitchboardPlugLocaleWidgetsLanguageListBox_private_offset = g_type_add_instance_private (switchboard_plug_locale_widgets_language_list_box_type_id, sizeof (SwitchboardPlugLocaleWidgetsLanguageListBoxPrivate));
	return switchboard_plug_locale_widgets_language_list_box_type_id;
}

GType
switchboard_plug_locale_widgets_language_list_box_get_type (void)
{
	static volatile gsize switchboard_plug_locale_widgets_language_list_box_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_locale_widgets_language_list_box_type_id__once)) {
		GType switchboard_plug_locale_widgets_language_list_box_type_id;
		switchboard_plug_locale_widgets_language_list_box_type_id = switchboard_plug_locale_widgets_language_list_box_get_type_once ();
		g_once_init_leave (&switchboard_plug_locale_widgets_language_list_box_type_id__once, switchboard_plug_locale_widgets_language_list_box_type_id);
	}
	return switchboard_plug_locale_widgets_language_list_box_type_id__once;
}

