import vscodeUri from 'vscode-uri';
import { tsp } from '../ts-protocol.js';
import { ExecutionTarget } from './server.js';
import CommandTypes = tsp.CommandTypes;
export declare enum ServerType {
    Syntax = "syntax",
    Semantic = "semantic"
}
export declare namespace ServerResponse {
    class Cancelled {
        readonly reason: string;
        readonly type = "cancelled";
        constructor(reason: string);
    }
    const NoContent: {
        readonly type: "noContent";
    };
    const NoServer: {
        readonly type: "noServer";
    };
    type Response<T extends tsp.Response> = T | Cancelled | typeof NoContent | typeof NoServer;
}
export interface TypeScriptRequestTypes {
    [CommandTypes.ApplyCodeActionCommand]: [tsp.ApplyCodeActionCommandRequestArgs, tsp.ApplyCodeActionCommandResponse];
    [CommandTypes.Change]: [tsp.ChangeRequestArgs, null];
    [CommandTypes.Close]: [tsp.FileRequestArgs, null];
    [CommandTypes.CompilerOptionsForInferredProjects]: [tsp.SetCompilerOptionsForInferredProjectsArgs, tsp.SetCompilerOptionsForInferredProjectsResponse];
    [CommandTypes.CompletionDetails]: [tsp.CompletionDetailsRequestArgs, tsp.CompletionDetailsResponse];
    [CommandTypes.CompletionInfo]: [tsp.CompletionsRequestArgs, tsp.CompletionInfoResponse];
    [CommandTypes.Configure]: [tsp.ConfigureRequestArguments, tsp.ConfigureResponse];
    [CommandTypes.ConfigurePlugin]: [tsp.ConfigurePluginRequestArguments, tsp.ConfigurePluginResponse];
    [CommandTypes.Definition]: [tsp.FileLocationRequestArgs, tsp.DefinitionResponse];
    [CommandTypes.DefinitionAndBoundSpan]: [tsp.FileLocationRequestArgs, tsp.DefinitionInfoAndBoundSpanResponse];
    [CommandTypes.DocCommentTemplate]: [tsp.FileLocationRequestArgs, tsp.DocCommandTemplateResponse];
    [CommandTypes.DocumentHighlights]: [tsp.DocumentHighlightsRequestArgs, tsp.DocumentHighlightsResponse];
    [CommandTypes.EncodedSemanticClassificationsFull]: [tsp.EncodedSemanticClassificationsRequestArgs, tsp.EncodedSemanticClassificationsResponse];
    [CommandTypes.FindSourceDefinition]: [tsp.FileLocationRequestArgs, tsp.DefinitionResponse];
    [CommandTypes.Format]: [tsp.FormatRequestArgs, tsp.FormatResponse];
    [CommandTypes.Formatonkey]: [tsp.FormatOnKeyRequestArgs, tsp.FormatResponse];
    [CommandTypes.GetApplicableRefactors]: [tsp.GetApplicableRefactorsRequestArgs, tsp.GetApplicableRefactorsResponse];
    [CommandTypes.GetCodeFixes]: [tsp.CodeFixRequestArgs, tsp.CodeFixResponse];
    [CommandTypes.GetCombinedCodeFix]: [tsp.GetCombinedCodeFixRequestArgs, tsp.GetCombinedCodeFixResponse];
    [CommandTypes.GetEditsForFileRename]: [tsp.GetEditsForFileRenameRequestArgs, tsp.GetEditsForFileRenameResponse];
    [CommandTypes.GetEditsForRefactor]: [tsp.GetEditsForRefactorRequestArgs, tsp.GetEditsForRefactorResponse];
    [CommandTypes.Geterr]: [tsp.GeterrRequestArgs, any];
    [CommandTypes.GetOutliningSpans]: [tsp.FileRequestArgs, tsp.OutliningSpansResponse];
    [CommandTypes.GetSupportedCodeFixes]: [null, tsp.GetSupportedCodeFixesResponse];
    [CommandTypes.Implementation]: [tsp.FileLocationRequestArgs, tsp.ImplementationResponse];
    [CommandTypes.JsxClosingTag]: [tsp.JsxClosingTagRequestArgs, tsp.JsxClosingTagResponse];
    [CommandTypes.Navto]: [tsp.NavtoRequestArgs, tsp.NavtoResponse];
    [CommandTypes.NavTree]: [tsp.FileRequestArgs, tsp.NavTreeResponse];
    [CommandTypes.Open]: [tsp.OpenRequestArgs, null];
    [CommandTypes.OrganizeImports]: [tsp.OrganizeImportsRequestArgs, tsp.OrganizeImportsResponse];
    [CommandTypes.PrepareCallHierarchy]: [tsp.FileLocationRequestArgs, tsp.PrepareCallHierarchyResponse];
    [CommandTypes.ProvideCallHierarchyIncomingCalls]: [tsp.FileLocationRequestArgs, tsp.ProvideCallHierarchyIncomingCallsResponse];
    [CommandTypes.ProvideCallHierarchyOutgoingCalls]: [tsp.FileLocationRequestArgs, tsp.ProvideCallHierarchyOutgoingCallsResponse];
    [CommandTypes.ProjectInfo]: [tsp.ProjectInfoRequestArgs, tsp.ProjectInfoResponse];
    [CommandTypes.ProvideInlayHints]: [tsp.InlayHintsRequestArgs, tsp.InlayHintsResponse];
    [CommandTypes.Quickinfo]: [tsp.FileLocationRequestArgs, tsp.QuickInfoResponse];
    [CommandTypes.References]: [tsp.FileLocationRequestArgs, tsp.ReferencesResponse];
    [CommandTypes.Rename]: [tsp.RenameRequestArgs, tsp.RenameResponse];
    [CommandTypes.SelectionRange]: [tsp.SelectionRangeRequestArgs, tsp.SelectionRangeResponse];
    [CommandTypes.SignatureHelp]: [tsp.SignatureHelpRequestArgs, tsp.SignatureHelpResponse];
    [CommandTypes.TypeDefinition]: [tsp.FileLocationRequestArgs, tsp.TypeDefinitionResponse];
    [CommandTypes.UpdateOpen]: [tsp.UpdateOpenRequestArgs, tsp.Response];
}
export type ExecConfig = {
    readonly lowPriority?: boolean;
    readonly nonRecoverable?: boolean;
    readonly cancelOnResourceChange?: vscodeUri.URI;
    readonly executionTarget?: ExecutionTarget;
};
//# sourceMappingURL=requests.d.ts.map