/* ShadowEffect.c generated by valac 0.56.3, the Vala compiler
 * generated from ShadowEffect.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "gala-pip.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cogl/cogl.h>
#include <stdlib.h>
#include <string.h>
#include <clutter/clutter.h>
#include <gee.h>
#include <glib-object.h>
#include "gala.h"
#include <cairo-gobject.h>
#include <gobject/gvaluecollector.h>

enum  {
	GALA_PLUGINS_PIP_SHADOW_EFFECT_0_PROPERTY,
	GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_SIZE_PROPERTY,
	GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_SPREAD_PROPERTY,
	GALA_PLUGINS_PIP_SHADOW_EFFECT_SCALE_FACTOR_PROPERTY,
	GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY,
	GALA_PLUGINS_PIP_SHADOW_EFFECT_NUM_PROPERTIES
};
static GParamSpec* gala_plugins_pip_shadow_effect_properties[GALA_PLUGINS_PIP_SHADOW_EFFECT_NUM_PROPERTIES];

#define GALA_PLUGINS_PIP_SHADOW_EFFECT_TYPE_SHADOW (gala_plugins_pip_shadow_effect_shadow_get_type ())
#define GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_PLUGINS_PIP_SHADOW_EFFECT_TYPE_SHADOW, GalaPluginsPIPShadowEffectShadow))
#define GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_PLUGINS_PIP_SHADOW_EFFECT_TYPE_SHADOW, GalaPluginsPIPShadowEffectShadowClass))
#define GALA_PLUGINS_PIP_SHADOW_EFFECT_IS_SHADOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_PLUGINS_PIP_SHADOW_EFFECT_TYPE_SHADOW))
#define GALA_PLUGINS_PIP_SHADOW_EFFECT_IS_SHADOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_PLUGINS_PIP_SHADOW_EFFECT_TYPE_SHADOW))
#define GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_PLUGINS_PIP_SHADOW_EFFECT_TYPE_SHADOW, GalaPluginsPIPShadowEffectShadowClass))

typedef struct _GalaPluginsPIPShadowEffectShadow GalaPluginsPIPShadowEffectShadow;
typedef struct _GalaPluginsPIPShadowEffectShadowClass GalaPluginsPIPShadowEffectShadowClass;
#define _cogl_object_unref0(var) ((var == NULL) ? NULL : (var = (cogl_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gala_plugins_pip_shadow_effect_shadow_unref0(var) ((var == NULL) ? NULL : (var = (gala_plugins_pip_shadow_effect_shadow_unref (var), NULL)))
typedef struct _GalaPluginsPIPShadowEffectShadowPrivate GalaPluginsPIPShadowEffectShadowPrivate;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GalaPluginsPIPShadowEffectParamSpecShadow GalaPluginsPIPShadowEffectParamSpecShadow;

struct _GalaPluginsPIPShadowEffectPrivate {
	gint _shadow_size;
	gint _shadow_spread;
	gfloat _scale_factor;
	guint8 _shadow_opacity;
	CoglPipeline* pipeline;
	gchar* current_key;
};

struct _GalaPluginsPIPShadowEffectShadow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GalaPluginsPIPShadowEffectShadowPrivate * priv;
	gint users;
	CoglTexture* texture;
};

struct _GalaPluginsPIPShadowEffectShadowClass {
	GTypeClass parent_class;
	void (*finalize) (GalaPluginsPIPShadowEffectShadow *self);
};

struct _GalaPluginsPIPShadowEffectParamSpecShadow {
	GParamSpec parent_instance;
};

static gint GalaPluginsPIPShadowEffect_private_offset;
static gpointer gala_plugins_pip_shadow_effect_parent_class = NULL;
static GeeHashMap* gala_plugins_pip_shadow_effect_shadow_cache;
static GeeHashMap* gala_plugins_pip_shadow_effect_shadow_cache = NULL;
static gpointer gala_plugins_pip_shadow_effect_shadow_parent_class = NULL;

static void gala_plugins_pip_shadow_effect_decrement_shadow_users (GalaPluginsPIPShadowEffect* self,
                                                            const gchar* key);
static gpointer gala_plugins_pip_shadow_effect_shadow_ref (gpointer instance);
static void gala_plugins_pip_shadow_effect_shadow_unref (gpointer instance);
static GParamSpec* gala_plugins_pip_shadow_effect_param_spec_shadow (const gchar* name,
                                                              const gchar* nick,
                                                              const gchar* blurb,
                                                              GType object_type,
                                                              GParamFlags flags) G_GNUC_UNUSED ;
static void gala_plugins_pip_shadow_effect_value_set_shadow (GValue* value,
                                                      gpointer v_object) G_GNUC_UNUSED ;
static void gala_plugins_pip_shadow_effect_value_take_shadow (GValue* value,
                                                       gpointer v_object) G_GNUC_UNUSED ;
static gpointer gala_plugins_pip_shadow_effect_value_get_shadow (const GValue* value) G_GNUC_UNUSED ;
static GType gala_plugins_pip_shadow_effect_shadow_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static CoglTexture* gala_plugins_pip_shadow_effect_get_shadow (GalaPluginsPIPShadowEffect* self,
                                                        CoglContext* context,
                                                        gint width,
                                                        gint height,
                                                        gint shadow_size,
                                                        gint shadow_spread);
static GalaPluginsPIPShadowEffectShadow* gala_plugins_pip_shadow_effect_shadow_new (CoglTexture* _texture);
static GalaPluginsPIPShadowEffectShadow* gala_plugins_pip_shadow_effect_shadow_construct (GType object_type,
                                                                                   CoglTexture* _texture);
static void gala_plugins_pip_shadow_effect_real_paint (ClutterEffect* base,
                                                ClutterPaintNode* node,
                                                ClutterPaintContext* context,
                                                ClutterEffectPaintFlags flags);
static void gala_plugins_pip_shadow_effect_real_get_bounding_box (GalaPluginsPIPShadowEffect* self,
                                                           ClutterActorBox* result);
static void gala_plugins_pip_shadow_effect_shadow_finalize (GalaPluginsPIPShadowEffectShadow * obj);
static GType gala_plugins_pip_shadow_effect_shadow_get_type_once (void);
static GObject * gala_plugins_pip_shadow_effect_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static void gala_plugins_pip_shadow_effect_finalize (GObject * obj);
static GType gala_plugins_pip_shadow_effect_get_type_once (void);
static void _vala_gala_plugins_pip_shadow_effect_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_gala_plugins_pip_shadow_effect_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);

static inline gpointer
gala_plugins_pip_shadow_effect_get_instance_private (GalaPluginsPIPShadowEffect* self)
{
	return G_STRUCT_MEMBER_P (self, GalaPluginsPIPShadowEffect_private_offset);
}

GalaPluginsPIPShadowEffect*
gala_plugins_pip_shadow_effect_construct (GType object_type,
                                          gint shadow_size,
                                          gint shadow_spread)
{
	GalaPluginsPIPShadowEffect * self = NULL;
	self = (GalaPluginsPIPShadowEffect*) g_object_new (object_type, "shadow-size", shadow_size, "shadow-spread", shadow_spread, NULL);
	return self;
}

GalaPluginsPIPShadowEffect*
gala_plugins_pip_shadow_effect_new (gint shadow_size,
                                    gint shadow_spread)
{
	return gala_plugins_pip_shadow_effect_construct (GALA_PLUGINS_PIP_TYPE_SHADOW_EFFECT, shadow_size, shadow_spread);
}

static gpointer
_cogl_object_ref0 (gpointer self)
{
	return self ? cogl_object_ref (self) : NULL;
}

static CoglTexture*
gala_plugins_pip_shadow_effect_get_shadow (GalaPluginsPIPShadowEffect* self,
                                           CoglContext* context,
                                           gint width,
                                           gint height,
                                           gint shadow_size,
                                           gint shadow_spread)
{
	gchar* old_key = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GalaPluginsPIPShadowEffectShadow* shadow = NULL;
	GeeHashMap* _tmp7_;
	const gchar* _tmp8_;
	gpointer _tmp9_;
	GalaPluginsPIPShadowEffectShadow* _tmp10_;
	GalaDrawingBufferSurface* buffer = NULL;
	GalaDrawingBufferSurface* _tmp16_;
	GalaDrawingBufferSurface* _tmp17_;
	cairo_t* _tmp18_;
	cairo_t* _tmp19_;
	GalaDrawingBufferSurface* _tmp20_;
	cairo_t* _tmp21_;
	cairo_t* _tmp22_;
	GalaDrawingBufferSurface* _tmp23_;
	cairo_t* _tmp24_;
	cairo_t* _tmp25_;
	GalaDrawingBufferSurface* _tmp26_;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp27_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp28_;
	cairo_t* _tmp29_;
	cairo_t* _tmp30_;
	GalaDrawingBufferSurface* _tmp31_;
	cairo_surface_t* _tmp32_;
	cairo_surface_t* _tmp33_;
	cairo_t* _tmp34_;
	GError* _inner_error0_ = NULL;
	CoglTexture* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = self->priv->current_key;
	_tmp1_ = g_strdup (_tmp0_);
	old_key = _tmp1_;
	_tmp2_ = g_strdup_printf ("%ix%i:%i:%i", width, height, shadow_size, shadow_spread);
	_g_free0 (self->priv->current_key);
	self->priv->current_key = _tmp2_;
	_tmp3_ = old_key;
	_tmp4_ = self->priv->current_key;
	if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
		result = NULL;
		_g_free0 (old_key);
		return result;
	}
	_tmp5_ = old_key;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = old_key;
		gala_plugins_pip_shadow_effect_decrement_shadow_users (self, _tmp6_);
	}
	shadow = NULL;
	_tmp7_ = gala_plugins_pip_shadow_effect_shadow_cache;
	_tmp8_ = self->priv->current_key;
	_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, _tmp8_);
	_gala_plugins_pip_shadow_effect_shadow_unref0 (shadow);
	shadow = (GalaPluginsPIPShadowEffectShadow*) _tmp9_;
	_tmp10_ = shadow;
	if (_tmp10_ != NULL) {
		GalaPluginsPIPShadowEffectShadow* _tmp11_;
		gint _tmp12_;
		GalaPluginsPIPShadowEffectShadow* _tmp13_;
		CoglTexture* _tmp14_;
		CoglTexture* _tmp15_;
		_tmp11_ = shadow;
		_tmp12_ = _tmp11_->users;
		_tmp11_->users = _tmp12_ + 1;
		_tmp13_ = shadow;
		_tmp14_ = _tmp13_->texture;
		_tmp15_ = _cogl_object_ref0 (_tmp14_);
		result = _tmp15_;
		_gala_plugins_pip_shadow_effect_shadow_unref0 (shadow);
		_g_free0 (old_key);
		return result;
	}
	_tmp16_ = gala_drawing_buffer_surface_new (width, height);
	buffer = _tmp16_;
	_tmp17_ = buffer;
	_tmp18_ = gala_drawing_buffer_surface_get_context (_tmp17_);
	_tmp19_ = _tmp18_;
	cairo_rectangle (_tmp19_, (gdouble) (shadow_size - shadow_spread), (gdouble) (shadow_size - shadow_spread), (gdouble) ((width - (shadow_size * 2)) + (shadow_spread * 2)), (gdouble) ((height - (shadow_size * 2)) + (shadow_spread * 2)));
	_tmp20_ = buffer;
	_tmp21_ = gala_drawing_buffer_surface_get_context (_tmp20_);
	_tmp22_ = _tmp21_;
	cairo_set_source_rgba (_tmp22_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.7);
	_tmp23_ = buffer;
	_tmp24_ = gala_drawing_buffer_surface_get_context (_tmp23_);
	_tmp25_ = _tmp24_;
	cairo_fill (_tmp25_);
	_tmp26_ = buffer;
	gala_drawing_buffer_surface_exponential_blur (_tmp26_, shadow_size / 2);
	_tmp27_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width, height);
	surface = _tmp27_;
	_tmp28_ = surface;
	_tmp29_ = cairo_create (_tmp28_);
	cr = _tmp29_;
	_tmp30_ = cr;
	_tmp31_ = buffer;
	_tmp32_ = gala_drawing_buffer_surface_get_surface (_tmp31_);
	_tmp33_ = _tmp32_;
	cairo_set_source_surface (_tmp30_, _tmp33_, (gdouble) 0, (gdouble) 0);
	_tmp34_ = cr;
	cairo_paint (_tmp34_);
	{
		CoglTexture2D* texture = NULL;
		cairo_surface_t* _tmp35_;
		cairo_surface_t* _tmp36_;
		guchar* _tmp37_;
		CoglTexture2D* _tmp38_;
		GeeHashMap* _tmp39_;
		const gchar* _tmp40_;
		CoglTexture2D* _tmp41_;
		GalaPluginsPIPShadowEffectShadow* _tmp42_;
		GalaPluginsPIPShadowEffectShadow* _tmp43_;
		_tmp35_ = surface;
		_tmp36_ = surface;
		_tmp37_ = cairo_image_surface_get_data (_tmp36_);
		_tmp38_ = cogl_texture_2d_new_from_data (context, width, height, COGL_PIXEL_FORMAT_BGRA_8888_PRE, cairo_image_surface_get_stride (_tmp35_), (const uint8_t*) _tmp37_, &_inner_error0_);
		texture = _tmp38_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp39_ = gala_plugins_pip_shadow_effect_shadow_cache;
		_tmp40_ = self->priv->current_key;
		_tmp41_ = texture;
		_tmp42_ = gala_plugins_pip_shadow_effect_shadow_new ((CoglTexture*) _tmp41_);
		_tmp43_ = _tmp42_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp39_, _tmp40_, _tmp43_);
		_gala_plugins_pip_shadow_effect_shadow_unref0 (_tmp43_);
		result = (CoglTexture*) texture;
		_cairo_destroy0 (cr);
		_cairo_surface_destroy0 (surface);
		_g_object_unref0 (buffer);
		_gala_plugins_pip_shadow_effect_shadow_unref0 (shadow);
		_g_free0 (old_key);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp44_;
		const gchar* _tmp45_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		g_debug ("ShadowEffect.vala:101: %s", _tmp45_);
		result = NULL;
		_g_error_free0 (e);
		_cairo_destroy0 (cr);
		_cairo_surface_destroy0 (surface);
		_g_object_unref0 (buffer);
		_gala_plugins_pip_shadow_effect_shadow_unref0 (shadow);
		_g_free0 (old_key);
		return result;
	}
	__finally0:
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (surface);
	_g_object_unref0 (buffer);
	_gala_plugins_pip_shadow_effect_shadow_unref0 (shadow);
	_g_free0 (old_key);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
gala_plugins_pip_shadow_effect_decrement_shadow_users (GalaPluginsPIPShadowEffect* self,
                                                       const gchar* key)
{
	GalaPluginsPIPShadowEffectShadow* shadow = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GalaPluginsPIPShadowEffectShadow* _tmp2_;
	GalaPluginsPIPShadowEffectShadow* _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = gala_plugins_pip_shadow_effect_shadow_cache;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, key);
	shadow = (GalaPluginsPIPShadowEffectShadow*) _tmp1_;
	_tmp2_ = shadow;
	if (_tmp2_ == NULL) {
		_gala_plugins_pip_shadow_effect_shadow_unref0 (shadow);
		return;
	}
	_tmp3_ = shadow;
	_tmp3_->users = _tmp3_->users - 1;
	_tmp4_ = _tmp3_->users;
	if (_tmp4_ == 0) {
		GeeHashMap* _tmp5_;
		_tmp5_ = gala_plugins_pip_shadow_effect_shadow_cache;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, key, NULL);
	}
	_gala_plugins_pip_shadow_effect_shadow_unref0 (shadow);
}

static void
gala_plugins_pip_shadow_effect_real_paint (ClutterEffect* base,
                                           ClutterPaintNode* node,
                                           ClutterPaintContext* context,
                                           ClutterEffectPaintFlags flags)
{
	GalaPluginsPIPShadowEffect * self;
	ClutterActorBox bounding_box = {0};
	ClutterActorBox _tmp0_ = {0};
	CoglTexture* shadow = NULL;
	CoglFramebuffer* _tmp1_;
	CoglContext* _tmp2_;
	ClutterActorBox _tmp3_;
	ClutterActorBox _tmp4_;
	ClutterActorBox _tmp5_;
	ClutterActorBox _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	CoglTexture* _tmp9_;
	CoglTexture* _tmp10_;
	gint opacity = 0;
	ClutterActor* _tmp13_;
	ClutterActor* _tmp14_;
	guint8 _tmp15_;
	CoglColor alpha = {0};
	CoglPipeline* _tmp16_;
	CoglColor _tmp17_;
	CoglFramebuffer* _tmp18_;
	CoglPipeline* _tmp19_;
	ClutterActorBox _tmp20_;
	ClutterActorBox _tmp21_;
	ClutterActorBox _tmp22_;
	ClutterActorBox _tmp23_;
	ClutterActor* _tmp24_;
	ClutterActor* _tmp25_;
	self = (GalaPluginsPIPShadowEffect*) base;
	g_return_if_fail (node != NULL);
	g_return_if_fail (context != NULL);
	gala_plugins_pip_shadow_effect_get_bounding_box (self, &_tmp0_);
	bounding_box = _tmp0_;
	_tmp1_ = clutter_paint_context_get_framebuffer (context);
	_tmp2_ = cogl_framebuffer_get_context (_tmp1_);
	_tmp3_ = bounding_box;
	_tmp4_ = bounding_box;
	_tmp5_ = bounding_box;
	_tmp6_ = bounding_box;
	_tmp7_ = self->priv->_shadow_size;
	_tmp8_ = self->priv->_shadow_spread;
	_tmp9_ = gala_plugins_pip_shadow_effect_get_shadow (self, _tmp2_, (gint) (_tmp3_.x2 - _tmp4_.x1), (gint) (_tmp5_.y2 - _tmp6_.y1), _tmp7_, _tmp8_);
	shadow = _tmp9_;
	_tmp10_ = shadow;
	if (_tmp10_ != NULL) {
		CoglPipeline* _tmp11_;
		CoglTexture* _tmp12_;
		_tmp11_ = self->priv->pipeline;
		_tmp12_ = shadow;
		cogl_pipeline_set_layer_texture (_tmp11_, 0, _tmp12_);
	}
	_tmp13_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->_shadow_opacity;
	opacity = (clutter_actor_get_paint_opacity (_tmp14_) * _tmp15_) / 255;
	cogl_color_init_from_4ub (&alpha, (guint8) 255, (guint8) 255, (guint8) 255, (guint8) opacity);
	cogl_color_premultiply (&alpha);
	_tmp16_ = self->priv->pipeline;
	_tmp17_ = alpha;
	cogl_pipeline_set_color (_tmp16_, &_tmp17_);
	_tmp18_ = clutter_paint_context_get_framebuffer (context);
	_tmp19_ = self->priv->pipeline;
	_tmp20_ = bounding_box;
	_tmp21_ = bounding_box;
	_tmp22_ = bounding_box;
	_tmp23_ = bounding_box;
	cogl_framebuffer_draw_rectangle (_tmp18_, _tmp19_, _tmp20_.x1, _tmp21_.y1, _tmp22_.x2, _tmp23_.y2);
	_tmp24_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp25_ = _tmp24_;
	clutter_actor_continue_paint (_tmp25_, context);
	_cogl_object_unref0 (shadow);
}

static void
gala_plugins_pip_shadow_effect_real_get_bounding_box (GalaPluginsPIPShadowEffect* self,
                                                      ClutterActorBox* result)
{
	gfloat size = 0.0F;
	gint _tmp0_;
	gfloat _tmp1_;
	ClutterActorBox bounding_box = {0};
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	gfloat _tmp8_;
	gfloat _tmp9_;
	_tmp0_ = self->priv->_shadow_size;
	_tmp1_ = self->priv->_scale_factor;
	size = _tmp0_ * _tmp1_;
	memset (&bounding_box, 0, sizeof (ClutterActorBox));
	clutter_actor_box_set_origin (&bounding_box, -size, -size);
	_tmp2_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = clutter_actor_get_width (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = clutter_actor_get_height (_tmp7_);
	_tmp9_ = _tmp8_;
	clutter_actor_box_set_size (&bounding_box, _tmp5_ + (size * 2), _tmp9_ + (size * 2));
	*result = bounding_box;
	return;
}

void
gala_plugins_pip_shadow_effect_get_bounding_box (GalaPluginsPIPShadowEffect* self,
                                                 ClutterActorBox* result)
{
	GalaPluginsPIPShadowEffectClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GALA_PLUGINS_PIP_SHADOW_EFFECT_GET_CLASS (self);
	if (_klass_->get_bounding_box) {
		_klass_->get_bounding_box (self, result);
	}
}

gint
gala_plugins_pip_shadow_effect_get_shadow_size (GalaPluginsPIPShadowEffect* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_shadow_size;
	return result;
}

static void
gala_plugins_pip_shadow_effect_set_shadow_size (GalaPluginsPIPShadowEffect* self,
                                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_plugins_pip_shadow_effect_get_shadow_size (self);
	if (old_value != value) {
		self->priv->_shadow_size = value;
		g_object_notify_by_pspec ((GObject *) self, gala_plugins_pip_shadow_effect_properties[GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_SIZE_PROPERTY]);
	}
}

gint
gala_plugins_pip_shadow_effect_get_shadow_spread (GalaPluginsPIPShadowEffect* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_shadow_spread;
	return result;
}

static void
gala_plugins_pip_shadow_effect_set_shadow_spread (GalaPluginsPIPShadowEffect* self,
                                                  gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_plugins_pip_shadow_effect_get_shadow_spread (self);
	if (old_value != value) {
		self->priv->_shadow_spread = value;
		g_object_notify_by_pspec ((GObject *) self, gala_plugins_pip_shadow_effect_properties[GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_SPREAD_PROPERTY]);
	}
}

gfloat
gala_plugins_pip_shadow_effect_get_scale_factor (GalaPluginsPIPShadowEffect* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_scale_factor;
	return result;
}

void
gala_plugins_pip_shadow_effect_set_scale_factor (GalaPluginsPIPShadowEffect* self,
                                                 gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_plugins_pip_shadow_effect_get_scale_factor (self);
	if (old_value != value) {
		self->priv->_scale_factor = value;
		g_object_notify_by_pspec ((GObject *) self, gala_plugins_pip_shadow_effect_properties[GALA_PLUGINS_PIP_SHADOW_EFFECT_SCALE_FACTOR_PROPERTY]);
	}
}

guint8
gala_plugins_pip_shadow_effect_get_shadow_opacity (GalaPluginsPIPShadowEffect* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_shadow_opacity;
	return result;
}

void
gala_plugins_pip_shadow_effect_set_shadow_opacity (GalaPluginsPIPShadowEffect* self,
                                                   guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_plugins_pip_shadow_effect_get_shadow_opacity (self);
	if (old_value != value) {
		self->priv->_shadow_opacity = value;
		g_object_notify_by_pspec ((GObject *) self, gala_plugins_pip_shadow_effect_properties[GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY]);
	}
}

static GalaPluginsPIPShadowEffectShadow*
gala_plugins_pip_shadow_effect_shadow_construct (GType object_type,
                                                 CoglTexture* _texture)
{
	GalaPluginsPIPShadowEffectShadow* self = NULL;
	CoglTexture* _tmp0_;
	g_return_val_if_fail (_texture != NULL, NULL);
	self = (GalaPluginsPIPShadowEffectShadow*) g_type_create_instance (object_type);
	_tmp0_ = _cogl_object_ref0 (_texture);
	_cogl_object_unref0 (self->texture);
	self->texture = _tmp0_;
	self->users = 1;
	return self;
}

static GalaPluginsPIPShadowEffectShadow*
gala_plugins_pip_shadow_effect_shadow_new (CoglTexture* _texture)
{
	return gala_plugins_pip_shadow_effect_shadow_construct (GALA_PLUGINS_PIP_SHADOW_EFFECT_TYPE_SHADOW, _texture);
}

static void
gala_plugins_pip_shadow_effect_value_shadow_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gala_plugins_pip_shadow_effect_value_shadow_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gala_plugins_pip_shadow_effect_shadow_unref (value->data[0].v_pointer);
	}
}

static void
gala_plugins_pip_shadow_effect_value_shadow_copy_value (const GValue* src_value,
                                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gala_plugins_pip_shadow_effect_shadow_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gala_plugins_pip_shadow_effect_value_shadow_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gala_plugins_pip_shadow_effect_value_shadow_collect_value (GValue* value,
                                                           guint n_collect_values,
                                                           GTypeCValue* collect_values,
                                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GalaPluginsPIPShadowEffectShadow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gala_plugins_pip_shadow_effect_shadow_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gala_plugins_pip_shadow_effect_value_shadow_lcopy_value (const GValue* value,
                                                         guint n_collect_values,
                                                         GTypeCValue* collect_values,
                                                         guint collect_flags)
{
	GalaPluginsPIPShadowEffectShadow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gala_plugins_pip_shadow_effect_shadow_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
gala_plugins_pip_shadow_effect_param_spec_shadow (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags)
{
	GalaPluginsPIPShadowEffectParamSpecShadow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GALA_PLUGINS_PIP_SHADOW_EFFECT_TYPE_SHADOW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
gala_plugins_pip_shadow_effect_value_get_shadow (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_PLUGINS_PIP_SHADOW_EFFECT_TYPE_SHADOW), NULL);
	return value->data[0].v_pointer;
}

static void
gala_plugins_pip_shadow_effect_value_set_shadow (GValue* value,
                                                 gpointer v_object)
{
	GalaPluginsPIPShadowEffectShadow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_PLUGINS_PIP_SHADOW_EFFECT_TYPE_SHADOW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_PLUGINS_PIP_SHADOW_EFFECT_TYPE_SHADOW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gala_plugins_pip_shadow_effect_shadow_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_plugins_pip_shadow_effect_shadow_unref (old);
	}
}

static void
gala_plugins_pip_shadow_effect_value_take_shadow (GValue* value,
                                                  gpointer v_object)
{
	GalaPluginsPIPShadowEffectShadow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_PLUGINS_PIP_SHADOW_EFFECT_TYPE_SHADOW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_PLUGINS_PIP_SHADOW_EFFECT_TYPE_SHADOW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_plugins_pip_shadow_effect_shadow_unref (old);
	}
}

static void
gala_plugins_pip_shadow_effect_shadow_class_init (GalaPluginsPIPShadowEffectShadowClass * klass,
                                                  gpointer klass_data)
{
	gala_plugins_pip_shadow_effect_shadow_parent_class = g_type_class_peek_parent (klass);
	((GalaPluginsPIPShadowEffectShadowClass *) klass)->finalize = gala_plugins_pip_shadow_effect_shadow_finalize;
}

static void
gala_plugins_pip_shadow_effect_shadow_instance_init (GalaPluginsPIPShadowEffectShadow * self,
                                                     gpointer klass)
{
	self->ref_count = 1;
}

static void
gala_plugins_pip_shadow_effect_shadow_finalize (GalaPluginsPIPShadowEffectShadow * obj)
{
	GalaPluginsPIPShadowEffectShadow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_PLUGINS_PIP_SHADOW_EFFECT_TYPE_SHADOW, GalaPluginsPIPShadowEffectShadow);
	g_signal_handlers_destroy (self);
	_cogl_object_unref0 (self->texture);
}

static GType
gala_plugins_pip_shadow_effect_shadow_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gala_plugins_pip_shadow_effect_value_shadow_init, gala_plugins_pip_shadow_effect_value_shadow_free_value, gala_plugins_pip_shadow_effect_value_shadow_copy_value, gala_plugins_pip_shadow_effect_value_shadow_peek_pointer, "p", gala_plugins_pip_shadow_effect_value_shadow_collect_value, "p", gala_plugins_pip_shadow_effect_value_shadow_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GalaPluginsPIPShadowEffectShadowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_plugins_pip_shadow_effect_shadow_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaPluginsPIPShadowEffectShadow), 0, (GInstanceInitFunc) gala_plugins_pip_shadow_effect_shadow_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gala_plugins_pip_shadow_effect_shadow_type_id;
	gala_plugins_pip_shadow_effect_shadow_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GalaPluginsPIPShadowEffectShadow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gala_plugins_pip_shadow_effect_shadow_type_id;
}

static GType
gala_plugins_pip_shadow_effect_shadow_get_type (void)
{
	static volatile gsize gala_plugins_pip_shadow_effect_shadow_type_id__once = 0;
	if (g_once_init_enter (&gala_plugins_pip_shadow_effect_shadow_type_id__once)) {
		GType gala_plugins_pip_shadow_effect_shadow_type_id;
		gala_plugins_pip_shadow_effect_shadow_type_id = gala_plugins_pip_shadow_effect_shadow_get_type_once ();
		g_once_init_leave (&gala_plugins_pip_shadow_effect_shadow_type_id__once, gala_plugins_pip_shadow_effect_shadow_type_id);
	}
	return gala_plugins_pip_shadow_effect_shadow_type_id__once;
}

static gpointer
gala_plugins_pip_shadow_effect_shadow_ref (gpointer instance)
{
	GalaPluginsPIPShadowEffectShadow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
gala_plugins_pip_shadow_effect_shadow_unref (gpointer instance)
{
	GalaPluginsPIPShadowEffectShadow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GObject *
gala_plugins_pip_shadow_effect_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaPluginsPIPShadowEffect * self;
	ClutterBackend* _tmp0_;
	CoglContext* _tmp1_;
	CoglPipeline* _tmp2_;
	parent_class = G_OBJECT_CLASS (gala_plugins_pip_shadow_effect_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_PLUGINS_PIP_TYPE_SHADOW_EFFECT, GalaPluginsPIPShadowEffect);
	_tmp0_ = clutter_get_default_backend ();
	_tmp1_ = clutter_backend_get_cogl_context (_tmp0_);
	_tmp2_ = cogl_pipeline_new (_tmp1_);
	_cogl_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp2_;
	return obj;
}

static void
gala_plugins_pip_shadow_effect_class_init (GalaPluginsPIPShadowEffectClass * klass,
                                           gpointer klass_data)
{
	GeeHashMap* _tmp0_;
	gala_plugins_pip_shadow_effect_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaPluginsPIPShadowEffect_private_offset);
	((ClutterEffectClass *) klass)->paint = (void (*) (ClutterEffect*, ClutterPaintNode*, ClutterPaintContext*, ClutterEffectPaintFlags)) gala_plugins_pip_shadow_effect_real_paint;
	((GalaPluginsPIPShadowEffectClass *) klass)->get_bounding_box = (void (*) (GalaPluginsPIPShadowEffect*, ClutterActorBox*)) gala_plugins_pip_shadow_effect_real_get_bounding_box;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_plugins_pip_shadow_effect_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_plugins_pip_shadow_effect_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_plugins_pip_shadow_effect_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_plugins_pip_shadow_effect_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_SIZE_PROPERTY, gala_plugins_pip_shadow_effect_properties[GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_SIZE_PROPERTY] = g_param_spec_int ("shadow-size", "shadow-size", "shadow-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_SPREAD_PROPERTY, gala_plugins_pip_shadow_effect_properties[GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_SPREAD_PROPERTY] = g_param_spec_int ("shadow-spread", "shadow-spread", "shadow-spread", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PLUGINS_PIP_SHADOW_EFFECT_SCALE_FACTOR_PROPERTY, gala_plugins_pip_shadow_effect_properties[GALA_PLUGINS_PIP_SHADOW_EFFECT_SCALE_FACTOR_PROPERTY] = g_param_spec_float ("scale-factor", "scale-factor", "scale-factor", -G_MAXFLOAT, G_MAXFLOAT, (gfloat) 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY, gala_plugins_pip_shadow_effect_properties[GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY] = g_param_spec_uchar ("shadow-opacity", "shadow-opacity", "shadow-opacity", 0, G_MAXUINT8, (guint8) 255, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GALA_PLUGINS_PIP_SHADOW_EFFECT_TYPE_SHADOW, (GBoxedCopyFunc) gala_plugins_pip_shadow_effect_shadow_ref, (GDestroyNotify) gala_plugins_pip_shadow_effect_shadow_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (gala_plugins_pip_shadow_effect_shadow_cache);
	gala_plugins_pip_shadow_effect_shadow_cache = _tmp0_;
}

static void
gala_plugins_pip_shadow_effect_instance_init (GalaPluginsPIPShadowEffect * self,
                                              gpointer klass)
{
	self->priv = gala_plugins_pip_shadow_effect_get_instance_private (self);
	self->priv->_scale_factor = (gfloat) 1;
	self->priv->_shadow_opacity = (guint8) 255;
	self->priv->current_key = NULL;
}

static void
gala_plugins_pip_shadow_effect_finalize (GObject * obj)
{
	GalaPluginsPIPShadowEffect * self;
	const gchar* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_PLUGINS_PIP_TYPE_SHADOW_EFFECT, GalaPluginsPIPShadowEffect);
	_tmp0_ = self->priv->current_key;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->current_key;
		gala_plugins_pip_shadow_effect_decrement_shadow_users (self, _tmp1_);
	}
	_cogl_object_unref0 (self->priv->pipeline);
	_g_free0 (self->priv->current_key);
	G_OBJECT_CLASS (gala_plugins_pip_shadow_effect_parent_class)->finalize (obj);
}

static GType
gala_plugins_pip_shadow_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaPluginsPIPShadowEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_plugins_pip_shadow_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaPluginsPIPShadowEffect), 0, (GInstanceInitFunc) gala_plugins_pip_shadow_effect_instance_init, NULL };
	GType gala_plugins_pip_shadow_effect_type_id;
	gala_plugins_pip_shadow_effect_type_id = g_type_register_static (clutter_effect_get_type (), "GalaPluginsPIPShadowEffect", &g_define_type_info, 0);
	GalaPluginsPIPShadowEffect_private_offset = g_type_add_instance_private (gala_plugins_pip_shadow_effect_type_id, sizeof (GalaPluginsPIPShadowEffectPrivate));
	return gala_plugins_pip_shadow_effect_type_id;
}

GType
gala_plugins_pip_shadow_effect_get_type (void)
{
	static volatile gsize gala_plugins_pip_shadow_effect_type_id__once = 0;
	if (g_once_init_enter (&gala_plugins_pip_shadow_effect_type_id__once)) {
		GType gala_plugins_pip_shadow_effect_type_id;
		gala_plugins_pip_shadow_effect_type_id = gala_plugins_pip_shadow_effect_get_type_once ();
		g_once_init_leave (&gala_plugins_pip_shadow_effect_type_id__once, gala_plugins_pip_shadow_effect_type_id);
	}
	return gala_plugins_pip_shadow_effect_type_id__once;
}

static void
_vala_gala_plugins_pip_shadow_effect_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	GalaPluginsPIPShadowEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_PLUGINS_PIP_TYPE_SHADOW_EFFECT, GalaPluginsPIPShadowEffect);
	switch (property_id) {
		case GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_SIZE_PROPERTY:
		g_value_set_int (value, gala_plugins_pip_shadow_effect_get_shadow_size (self));
		break;
		case GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_SPREAD_PROPERTY:
		g_value_set_int (value, gala_plugins_pip_shadow_effect_get_shadow_spread (self));
		break;
		case GALA_PLUGINS_PIP_SHADOW_EFFECT_SCALE_FACTOR_PROPERTY:
		g_value_set_float (value, gala_plugins_pip_shadow_effect_get_scale_factor (self));
		break;
		case GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY:
		g_value_set_uchar (value, gala_plugins_pip_shadow_effect_get_shadow_opacity (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_plugins_pip_shadow_effect_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	GalaPluginsPIPShadowEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_PLUGINS_PIP_TYPE_SHADOW_EFFECT, GalaPluginsPIPShadowEffect);
	switch (property_id) {
		case GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_SIZE_PROPERTY:
		gala_plugins_pip_shadow_effect_set_shadow_size (self, g_value_get_int (value));
		break;
		case GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_SPREAD_PROPERTY:
		gala_plugins_pip_shadow_effect_set_shadow_spread (self, g_value_get_int (value));
		break;
		case GALA_PLUGINS_PIP_SHADOW_EFFECT_SCALE_FACTOR_PROPERTY:
		gala_plugins_pip_shadow_effect_set_scale_factor (self, g_value_get_float (value));
		break;
		case GALA_PLUGINS_PIP_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY:
		gala_plugins_pip_shadow_effect_set_shadow_opacity (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

