/* BackgroundSource.c generated by valac 0.56.3, the Vala compiler
 * generated from BackgroundSource.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <glib-object.h>
#include <meta/display.h>
#include <gio/gio.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gsettings-desktop-schemas/gdesktop-enums.h>
#include <meta/meta-monitor-manager.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_BACKGROUND_SOURCE (gala_background_source_get_type ())
#define GALA_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSource))
#define GALA_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSourceClass))
#define GALA_IS_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_SOURCE))
#define GALA_IS_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_SOURCE))
#define GALA_BACKGROUND_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSourceClass))

typedef struct _GalaBackgroundSource GalaBackgroundSource;
typedef struct _GalaBackgroundSourceClass GalaBackgroundSourceClass;
typedef struct _GalaBackgroundSourcePrivate GalaBackgroundSourcePrivate;

#define GALA_TYPE_BACKGROUND (gala_background_get_type ())
#define GALA_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND, GalaBackground))
#define GALA_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND, GalaBackgroundClass))
#define GALA_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND))
#define GALA_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND))
#define GALA_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND, GalaBackgroundClass))

typedef struct _GalaBackground GalaBackground;
typedef struct _GalaBackgroundClass GalaBackgroundClass;
enum  {
	GALA_BACKGROUND_SOURCE_0_PROPERTY,
	GALA_BACKGROUND_SOURCE_DISPLAY_PROPERTY,
	GALA_BACKGROUND_SOURCE_SETTINGS_PROPERTY,
	GALA_BACKGROUND_SOURCE_USE_COUNT_PROPERTY,
	GALA_BACKGROUND_SOURCE_NUM_PROPERTIES
};
static GParamSpec* gala_background_source_properties[GALA_BACKGROUND_SOURCE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	GALA_BACKGROUND_SOURCE_CHANGED_SIGNAL,
	GALA_BACKGROUND_SOURCE_NUM_SIGNALS
};
static guint gala_background_source_signals[GALA_BACKGROUND_SOURCE_NUM_SIGNALS] = {0};

struct _GalaBackgroundSource {
	GObject parent_instance;
	GalaBackgroundSourcePrivate * priv;
};

struct _GalaBackgroundSourceClass {
	GObjectClass parent_class;
};

struct _GalaBackgroundSourcePrivate {
	MetaDisplay* _display;
	GSettings* _settings;
	gint _use_count;
	GeeHashMap* backgrounds;
	guint* hash_cache;
	gint hash_cache_length1;
	gint _hash_cache_size_;
};

static gint GalaBackgroundSource_private_offset;
static gpointer gala_background_source_parent_class = NULL;

VALA_EXTERN GType gala_background_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundSource, g_object_unref)
VALA_EXTERN GType gala_background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackground, g_object_unref)
VALA_EXTERN GalaBackgroundSource* gala_background_source_new (MetaDisplay* display,
                                                  const gchar* settings_schema);
VALA_EXTERN GalaBackgroundSource* gala_background_source_construct (GType object_type,
                                                        MetaDisplay* display,
                                                        const gchar* settings_schema);
static void gala_background_source_monitors_changed (GalaBackgroundSource* self);
VALA_EXTERN MetaDisplay* gala_background_source_get_display (GalaBackgroundSource* self);
VALA_EXTERN void gala_background_update_resolution (GalaBackground* self);
static void gala_background_source_background_changed (GalaBackgroundSource* self,
                                                GalaBackground* background);
static void _gala_background_source_background_changed_gala_background_changed (GalaBackground* _sender,
                                                                         gpointer self);
VALA_EXTERN void gala_background_destroy (GalaBackground* self);
VALA_EXTERN GalaBackground* gala_background_source_get_background (GalaBackgroundSource* self,
                                                       gint monitor_index);
VALA_EXTERN GSettings* gala_background_source_get_settings (GalaBackgroundSource* self);
VALA_EXTERN GalaBackground* gala_background_new (MetaDisplay* display,
                                     gint monitor_index,
                                     const gchar* filename,
                                     GalaBackgroundSource* background_source,
                                     GDesktopBackgroundStyle style);
VALA_EXTERN GalaBackground* gala_background_construct (GType object_type,
                                           MetaDisplay* display,
                                           gint monitor_index,
                                           const gchar* filename,
                                           GalaBackgroundSource* background_source,
                                           GDesktopBackgroundStyle style);
VALA_EXTERN gint gala_background_get_monitor_index (GalaBackground* self);
VALA_EXTERN void gala_background_source_destroy (GalaBackgroundSource* self);
static void _gala_background_source_monitors_changed_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                     gpointer self);
static void gala_background_source_set_display (GalaBackgroundSource* self,
                                         MetaDisplay* value);
static void gala_background_source_set_settings (GalaBackgroundSource* self,
                                          GSettings* value);
 G_GNUC_INTERNAL gint gala_background_source_get_use_count (GalaBackgroundSource* self);
 G_GNUC_INTERNAL void gala_background_source_set_use_count (GalaBackgroundSource* self,
                                           gint value);
static GObject * gala_background_source_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _gala_background_source___lambda57_ (GalaBackgroundSource* self,
                                          const gchar* key);
static void __gala_background_source___lambda57__g_settings_changed (GSettings* _sender,
                                                              const gchar* key,
                                                              gpointer self);
static void gala_background_source_finalize (GObject * obj);
static GType gala_background_source_get_type_once (void);
static void _vala_gala_background_source_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_gala_background_source_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const gchar* GALA_BACKGROUND_SOURCE_OPTIONS[6] = {"color-shading-type", "picture-opacity", "picture-options", "picture-uri", "primary-color", "secondary-color"};

static inline gpointer
gala_background_source_get_instance_private (GalaBackgroundSource* self)
{
	return G_STRUCT_MEMBER_P (self, GalaBackgroundSource_private_offset);
}

GalaBackgroundSource*
gala_background_source_construct (GType object_type,
                                  MetaDisplay* display,
                                  const gchar* settings_schema)
{
	GalaBackgroundSource * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_val_if_fail (display != NULL, NULL);
	g_return_val_if_fail (settings_schema != NULL, NULL);
	_tmp0_ = g_settings_new (settings_schema);
	_tmp1_ = _tmp0_;
	self = (GalaBackgroundSource*) g_object_new (object_type, "display", display, "settings", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

GalaBackgroundSource*
gala_background_source_new (MetaDisplay* display,
                            const gchar* settings_schema)
{
	return gala_background_source_construct (GALA_TYPE_BACKGROUND_SOURCE, display, settings_schema);
}

static void
_gala_background_source_background_changed_gala_background_changed (GalaBackground* _sender,
                                                                    gpointer self)
{
	gala_background_source_background_changed ((GalaBackgroundSource*) self, _sender);
}

static void
gala_background_source_monitors_changed (GalaBackgroundSource* self)
{
	gint n = 0;
	MetaDisplay* _tmp0_;
	gint i = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_display;
	n = meta_display_get_n_monitors (_tmp0_);
	i = 0;
	{
		GeeIterator* _background_it = NULL;
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = self->priv->backgrounds;
		_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_background_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			GalaBackground* background = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GalaBackground* _tmp13_;
			guint _tmp14_;
			GalaBackground* _tmp15_;
			GeeHashMap* _tmp16_;
			_tmp7_ = _background_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _background_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			background = (GalaBackground*) _tmp9_;
			_tmp10_ = i;
			i = _tmp10_ + 1;
			_tmp11_ = n;
			if (_tmp10_ < _tmp11_) {
				GalaBackground* _tmp12_;
				_tmp12_ = background;
				gala_background_update_resolution (_tmp12_);
				_g_object_unref0 (background);
				continue;
			}
			_tmp13_ = background;
			g_signal_parse_name ("changed", GALA_TYPE_BACKGROUND, &_tmp14_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _gala_background_source_background_changed_gala_background_changed, self);
			_tmp15_ = background;
			gala_background_destroy (_tmp15_);
			_tmp16_ = self->priv->backgrounds;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp16_, (gpointer) ((gintptr) i), NULL);
			_g_object_unref0 (background);
		}
		_g_object_unref0 (_background_it);
	}
}

GalaBackground*
gala_background_source_get_background (GalaBackgroundSource* self,
                                       gint monitor_index)
{
	gchar* filename = NULL;
	gint style = 0;
	GSettings* _tmp0_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	GeeHashMap* _tmp16_;
	GeeHashMap* _tmp23_;
	gpointer _tmp24_;
	GalaBackground* result;
	g_return_val_if_fail (self != NULL, NULL);
	filename = NULL;
	_tmp0_ = self->priv->_settings;
	style = g_settings_get_enum (_tmp0_, "picture-options");
	if (style != ((gint) G_DESKTOP_BACKGROUND_STYLE_NONE)) {
		gchar* uri = NULL;
		GSettings* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gboolean _tmp6_;
		_tmp1_ = self->priv->_settings;
		_tmp2_ = g_settings_get_string (_tmp1_, "picture-uri");
		uri = _tmp2_;
		_tmp3_ = uri;
		_tmp4_ = g_uri_parse_scheme (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_ != NULL;
		_g_free0 (_tmp5_);
		if (_tmp6_) {
			const gchar* _tmp7_;
			GFile* _tmp8_;
			GFile* _tmp9_;
			gchar* _tmp10_;
			_tmp7_ = uri;
			_tmp8_ = g_file_new_for_uri (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_file_get_path (_tmp9_);
			_g_free0 (filename);
			filename = _tmp10_;
			_g_object_unref0 (_tmp9_);
		} else {
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp11_ = uri;
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (filename);
			filename = _tmp12_;
		}
		_g_free0 (uri);
	}
	_tmp14_ = filename;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp15_;
		_tmp15_ = filename;
		_tmp13_ = !g_str_has_suffix (_tmp15_, ".xml");
	}
	if (_tmp13_) {
		monitor_index = 0;
	}
	_tmp16_ = self->priv->backgrounds;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp16_, (gpointer) ((gintptr) monitor_index))) {
		GalaBackground* background = NULL;
		MetaDisplay* _tmp17_;
		const gchar* _tmp18_;
		GalaBackground* _tmp19_;
		GalaBackground* _tmp20_;
		GeeHashMap* _tmp21_;
		GalaBackground* _tmp22_;
		_tmp17_ = self->priv->_display;
		_tmp18_ = filename;
		_tmp19_ = gala_background_new (_tmp17_, monitor_index, _tmp18_, self, (GDesktopBackgroundStyle) style);
		background = _tmp19_;
		_tmp20_ = background;
		g_signal_connect_object (_tmp20_, "changed", (GCallback) _gala_background_source_background_changed_gala_background_changed, self, 0);
		_tmp21_ = self->priv->backgrounds;
		_tmp22_ = background;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, (gpointer) ((gintptr) monitor_index), _tmp22_);
		_g_object_unref0 (background);
	}
	_tmp23_ = self->priv->backgrounds;
	_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, (gpointer) ((gintptr) monitor_index));
	result = (GalaBackground*) _tmp24_;
	_g_free0 (filename);
	return result;
}

static void
gala_background_source_background_changed (GalaBackgroundSource* self,
                                           GalaBackground* background)
{
	guint _tmp0_;
	GeeHashMap* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (background != NULL);
	g_signal_parse_name ("changed", GALA_TYPE_BACKGROUND, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (background, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _gala_background_source_background_changed_gala_background_changed, self);
	gala_background_destroy (background);
	_tmp1_ = self->priv->backgrounds;
	_tmp2_ = gala_background_get_monitor_index (background);
	_tmp3_ = _tmp2_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) _tmp3_), NULL);
}

static void
_gala_background_source_monitors_changed_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                gpointer self)
{
	gala_background_source_monitors_changed ((GalaBackgroundSource*) self);
}

void
gala_background_source_destroy (GalaBackgroundSource* self)
{
	MetaMonitorManager* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = meta_monitor_manager_get ();
	g_signal_parse_name ("monitors-changed", meta_monitor_manager_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gala_background_source_monitors_changed_meta_monitor_manager_monitors_changed, self);
	{
		GeeIterator* _background_it = NULL;
		GeeHashMap* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp2_ = self->priv->backgrounds;
		_tmp3_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_background_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			GalaBackground* background = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			GalaBackground* _tmp11_;
			guint _tmp12_;
			GalaBackground* _tmp13_;
			_tmp8_ = _background_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _background_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			background = (GalaBackground*) _tmp10_;
			_tmp11_ = background;
			g_signal_parse_name ("changed", GALA_TYPE_BACKGROUND, &_tmp12_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _gala_background_source_background_changed_gala_background_changed, self);
			_tmp13_ = background;
			gala_background_destroy (_tmp13_);
			_g_object_unref0 (background);
		}
		_g_object_unref0 (_background_it);
	}
}

MetaDisplay*
gala_background_source_get_display (GalaBackgroundSource* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_background_source_set_display (GalaBackgroundSource* self,
                                    MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_source_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_background_source_properties[GALA_BACKGROUND_SOURCE_DISPLAY_PROPERTY]);
	}
}

GSettings*
gala_background_source_get_settings (GalaBackgroundSource* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

static void
gala_background_source_set_settings (GalaBackgroundSource* self,
                                     GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_source_get_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_background_source_properties[GALA_BACKGROUND_SOURCE_SETTINGS_PROPERTY]);
	}
}

 G_GNUC_INTERNAL gint
gala_background_source_get_use_count (GalaBackgroundSource* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_use_count;
	return result;
}

 G_GNUC_INTERNAL void
gala_background_source_set_use_count (GalaBackgroundSource* self,
                                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_source_get_use_count (self);
	if (old_value != value) {
		self->priv->_use_count = value;
		g_object_notify_by_pspec ((GObject *) self, gala_background_source_properties[GALA_BACKGROUND_SOURCE_USE_COUNT_PROPERTY]);
	}
}

static void
_gala_background_source___lambda57_ (GalaBackgroundSource* self,
                                     const gchar* key)
{
	g_return_if_fail (key != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < G_N_ELEMENTS (GALA_BACKGROUND_SOURCE_OPTIONS))) {
					break;
				}
				_tmp2_ = GALA_BACKGROUND_SOURCE_OPTIONS[i];
				if (g_strcmp0 (key, _tmp2_) == 0) {
					guint new_hash = 0U;
					GSettings* _tmp3_;
					GVariant* _tmp4_;
					GVariant* _tmp5_;
					guint _tmp6_;
					guint* _tmp7_;
					gint _tmp7__length1;
					guint _tmp8_;
					_tmp3_ = self->priv->_settings;
					_tmp4_ = g_settings_get_value (_tmp3_, key);
					_tmp5_ = _tmp4_;
					_tmp6_ = g_variant_hash (_tmp5_);
					_g_variant_unref0 (_tmp5_);
					new_hash = _tmp6_;
					_tmp7_ = self->priv->hash_cache;
					_tmp7__length1 = self->priv->hash_cache_length1;
					_tmp8_ = _tmp7_[i];
					if (_tmp8_ != new_hash) {
						guint* _tmp9_;
						gint _tmp9__length1;
						_tmp9_ = self->priv->hash_cache;
						_tmp9__length1 = self->priv->hash_cache_length1;
						_tmp9_[i] = new_hash;
						g_signal_emit (self, gala_background_source_signals[GALA_BACKGROUND_SOURCE_CHANGED_SIGNAL], 0);
						break;
					}
				}
			}
		}
	}
}

static void
__gala_background_source___lambda57__g_settings_changed (GSettings* _sender,
                                                         const gchar* key,
                                                         gpointer self)
{
	_gala_background_source___lambda57_ ((GalaBackgroundSource*) self, key);
}

static GObject *
gala_background_source_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaBackgroundSource * self;
	GeeHashMap* _tmp0_;
	guint* _tmp1_;
	MetaMonitorManager* _tmp2_;
	GSettings* _tmp10_;
	parent_class = G_OBJECT_CLASS (gala_background_source_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSource);
	_tmp0_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, GALA_TYPE_BACKGROUND, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->backgrounds);
	self->priv->backgrounds = _tmp0_;
	_tmp1_ = g_new0 (guint, G_N_ELEMENTS (GALA_BACKGROUND_SOURCE_OPTIONS));
	self->priv->hash_cache = (g_free (self->priv->hash_cache), NULL);
	self->priv->hash_cache = _tmp1_;
	self->priv->hash_cache_length1 = G_N_ELEMENTS (GALA_BACKGROUND_SOURCE_OPTIONS);
	self->priv->_hash_cache_size_ = self->priv->hash_cache_length1;
	_tmp2_ = meta_monitor_manager_get ();
	g_signal_connect_object (_tmp2_, "monitors-changed", (GCallback) _gala_background_source_monitors_changed_meta_monitor_manager_monitors_changed, self, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				guint* _tmp5_;
				gint _tmp5__length1;
				GSettings* _tmp6_;
				const gchar* _tmp7_;
				GVariant* _tmp8_;
				GVariant* _tmp9_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(i < G_N_ELEMENTS (GALA_BACKGROUND_SOURCE_OPTIONS))) {
					break;
				}
				_tmp5_ = self->priv->hash_cache;
				_tmp5__length1 = self->priv->hash_cache_length1;
				_tmp6_ = self->priv->_settings;
				_tmp7_ = GALA_BACKGROUND_SOURCE_OPTIONS[i];
				_tmp8_ = g_settings_get_value (_tmp6_, _tmp7_);
				_tmp9_ = _tmp8_;
				_tmp5_[i] = g_variant_hash (_tmp9_);
				_g_variant_unref0 (_tmp9_);
			}
		}
	}
	_tmp10_ = self->priv->_settings;
	g_signal_connect_object (_tmp10_, "changed", (GCallback) __gala_background_source___lambda57__g_settings_changed, self, 0);
	return obj;
}

static void
gala_background_source_class_init (GalaBackgroundSourceClass * klass,
                                   gpointer klass_data)
{
	gala_background_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaBackgroundSource_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_background_source_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_background_source_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_background_source_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_background_source_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_SOURCE_DISPLAY_PROPERTY, gala_background_source_properties[GALA_BACKGROUND_SOURCE_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_SOURCE_SETTINGS_PROPERTY, gala_background_source_properties[GALA_BACKGROUND_SOURCE_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_SOURCE_USE_COUNT_PROPERTY, gala_background_source_properties[GALA_BACKGROUND_SOURCE_USE_COUNT_PROPERTY] = g_param_spec_int ("use-count", "use-count", "use-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gala_background_source_signals[GALA_BACKGROUND_SOURCE_CHANGED_SIGNAL] = g_signal_new ("changed", GALA_TYPE_BACKGROUND_SOURCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_background_source_instance_init (GalaBackgroundSource * self,
                                      gpointer klass)
{
	self->priv = gala_background_source_get_instance_private (self);
	self->priv->_use_count = 0;
}

static void
gala_background_source_finalize (GObject * obj)
{
	GalaBackgroundSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSource);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->backgrounds);
	self->priv->hash_cache = (g_free (self->priv->hash_cache), NULL);
	G_OBJECT_CLASS (gala_background_source_parent_class)->finalize (obj);
}

static GType
gala_background_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaBackgroundSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_background_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaBackgroundSource), 0, (GInstanceInitFunc) gala_background_source_instance_init, NULL };
	GType gala_background_source_type_id;
	gala_background_source_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaBackgroundSource", &g_define_type_info, 0);
	GalaBackgroundSource_private_offset = g_type_add_instance_private (gala_background_source_type_id, sizeof (GalaBackgroundSourcePrivate));
	return gala_background_source_type_id;
}

GType
gala_background_source_get_type (void)
{
	static volatile gsize gala_background_source_type_id__once = 0;
	if (g_once_init_enter (&gala_background_source_type_id__once)) {
		GType gala_background_source_type_id;
		gala_background_source_type_id = gala_background_source_get_type_once ();
		g_once_init_leave (&gala_background_source_type_id__once, gala_background_source_type_id);
	}
	return gala_background_source_type_id__once;
}

static void
_vala_gala_background_source_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GalaBackgroundSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSource);
	switch (property_id) {
		case GALA_BACKGROUND_SOURCE_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_background_source_get_display (self));
		break;
		case GALA_BACKGROUND_SOURCE_SETTINGS_PROPERTY:
		g_value_set_object (value, gala_background_source_get_settings (self));
		break;
		case GALA_BACKGROUND_SOURCE_USE_COUNT_PROPERTY:
		g_value_set_int (value, gala_background_source_get_use_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_background_source_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GalaBackgroundSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSource);
	switch (property_id) {
		case GALA_BACKGROUND_SOURCE_DISPLAY_PROPERTY:
		gala_background_source_set_display (self, g_value_get_object (value));
		break;
		case GALA_BACKGROUND_SOURCE_SETTINGS_PROPERTY:
		gala_background_source_set_settings (self, g_value_get_object (value));
		break;
		case GALA_BACKGROUND_SOURCE_USE_COUNT_PROPERTY:
		gala_background_source_set_use_count (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

