/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelkit;

import java.util.Map;
import org.jmol.api.SC;
import org.jmol.i18n.GT;
import org.jmol.modelkit.ModelKit;
import org.jmol.modelkit.ModelKitPopupResourceBundle;
import org.jmol.popup.JmolGenericPopup;
import org.jmol.popup.PopupResource;

public abstract class ModelKitPopup
extends JmolGenericPopup {
    private static PopupResource bundle = new ModelKitPopupResourceBundle(null, null);
    private static final int MAX_LABEL = 32;
    ModelKit modelkit;
    boolean hidden = false;
    boolean allowPopup = true;
    String activeMenu;
    protected SC bondRotationCheckBox;
    protected SC prevBondCheckBox;
    private String bondRotationName = ".modelkitMenu.bondMenu.rotateBondP!RD";
    private boolean haveOperators;

    protected abstract void menuHidePopup(SC var1);

    @Override
    protected PopupResource getBundle(String menu) {
        return bundle;
    }

    @Override
    public void jpiShow(int x, int y) {
        if (!this.hidden) {
            this.updateCheckBoxesForModelKit(null);
            super.jpiShow(x, y);
        }
    }

    @Override
    public void jpiUpdateComputedMenus() {
        ((SC)this.htMenus.get("xtalMenu")).setEnabled(this.modelkit.setHasUnitCell());
        if (this.modelkit.checkNewModel()) {
            this.haveOperators = false;
            this.updateOperatorMenu();
        }
        this.updateAllXtalMenuOptions();
    }

    @Override
    protected void appUpdateForShow() {
        this.jpiUpdateComputedMenus();
    }

    void hidePopup() {
        this.menuHidePopup(this.popupMenu);
    }

    public void clearLastModelSet() {
        this.modelkit.lastModelSet = null;
    }

    protected void updateOperatorMenu() {
        if (this.haveOperators) {
            return;
        }
        this.haveOperators = true;
        SC menu = (SC)this.htMenus.get("xtalOp!PersistMenu");
        if (menu != null) {
            this.addAllCheckboxItems(menu, this.modelkit.getAllOperators());
        }
    }

    private void addAllCheckboxItems(SC menu, String[] labels) {
        this.menuRemoveAll(menu, 0);
        SC subMenu = menu;
        int pt = labels.length > 32 ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < labels.length; ++i) {
            if (pt >= 0 && pt++ % 32 == 0) {
                String id = "mtsymop" + pt + "Menu";
                subMenu = this.menuNewSubMenu(i + 1 + "..." + Math.min(i + 32, labels.length), this.menuGetId(menu) + "." + id);
                this.menuAddSubMenu(menu, subMenu);
                this.htMenus.put(id, subMenu);
                pt = 1;
            }
            if (i == 0) {
                this.menuEnable(this.menuCreateItem(subMenu, GT.$("none"), "draw sym_* delete", null), true);
            }
            String sym = labels[i];
            this.menuEnable(this.menuCreateItem(subMenu, sym, sym, subMenu.getName() + ".mkop_" + (i + 1)), true);
        }
    }

    protected void updateAllXtalMenuOptions() {
        String text = "";
        switch (this.modelkit.getMKState()) {
            case 0: {
                text = " (not enabled)";
                break;
            }
            case 1: {
                text = " (view)";
                break;
            }
            case 2: {
                text = " (edit)";
            }
        }
        this.setLabel("xtalModePersistMenu", "Crystal Mode: " + text);
        text = this.modelkit.getCenterText();
        this.setLabel("xtalSelPersistMenu", "Center: " + (text == null ? "(not selected)" : text));
        text = this.modelkit.getSymopText();
        this.setLabel("operator", text == null ? "(no operator selected)" : text);
        switch (this.modelkit.getSymEditState()) {
            case 0: {
                text = "do not apply symmetry";
                break;
            }
            case 64: {
                text = "retain local symmetry";
                break;
            }
            case 32: {
                text = "apply local symmetry";
                break;
            }
            case 128: {
                text = "apply full symmetry";
            }
        }
        this.setLabel("xtalEditOptPersistMenu", "Edit option: " + text);
        switch (this.modelkit.getUnitCellState()) {
            case 0: {
                text = "packed";
                break;
            }
            case 256: {
                text = "unpacked" + (this.modelkit.viewOffset == null ? "(no view offset)" : "(view offset=" + this.modelkit.viewOffset + ")");
            }
        }
        this.setLabel("xtalPackingPersistMenu", "Packing: " + text);
    }

    private void setLabel(String key, String label) {
        this.menuSetLabel((SC)this.htMenus.get(key), label);
    }

    public String setActiveMenu(String name) {
        String active;
        String string = name.indexOf("xtalMenu") >= 0 ? "xtalMenu" : (name.indexOf("atomMenu") >= 0 ? "atomMenu" : (active = name.indexOf("bondMenu") >= 0 ? "bondMenu" : null));
        if (active != null) {
            this.activeMenu = active;
            if (active == "xtalMenu" == (this.modelkit.getMKState() == 0)) {
                this.modelkit.setMKState(active == "xtalMenu" ? 1 : 0);
            }
            this.vwr.refresh(1, "modelkit");
            if (active == "bondMenu" && this.prevBondCheckBox == null) {
                this.prevBondCheckBox = (SC)this.htMenus.get("assignBond_pP!RD");
            }
        } else if (name.indexOf("optionsMenu") >= 0) {
            ((SC)this.htMenus.get("undo")).setEnabled(this.vwr.undoMoveAction(4165, 1275068425) > 0);
            ((SC)this.htMenus.get("redo")).setEnabled(this.vwr.undoMoveAction(4140, 1275068425) > 0);
        }
        return active;
    }

    @Override
    protected void appUpdateSpecialCheckBoxValue(SC source, String actionCommand, boolean selected) {
        String mode;
        if (source == null || !selected) {
            return;
        }
        String name = source.getName();
        if (!this.updatingForShow && (mode = this.setActiveMenu(name)) != null) {
            String text = source.getText();
            if (mode == "bondMenu") {
                if (name.equals(this.bondRotationName)) {
                    this.bondRotationCheckBox = source;
                } else {
                    this.prevBondCheckBox = source;
                }
            }
            this.modelkit.setHoverLabel(this.activeMenu, text);
        }
    }

    protected void exitBondRotation() {
        this.modelkit.exitBondRotation(this.prevBondCheckBox == null ? null : this.prevBondCheckBox.getText());
        this.vwr.setPickingMode(null, 33);
        if (this.bondRotationCheckBox != null) {
            this.bondRotationCheckBox.setSelected(false);
        }
        if (this.prevBondCheckBox != null) {
            this.prevBondCheckBox.setSelected(true);
        }
    }

    @Override
    protected boolean appGetBooleanProperty(String name) {
        if (name.startsWith("mk")) {
            return (Boolean)this.modelkit.getProperty(name.substring(2));
        }
        return this.vwr.getBooleanProperty(name);
    }

    @Override
    public String getUnknownCheckBoxScriptToRun(SC item, String name, String what, boolean TF) {
        if (name.startsWith("mk")) {
            this.modelkit.processMKPropertyItem(name, TF);
            return null;
        }
        String element = this.modelkit.getElementFromUser();
        if (element == null) {
            return null;
        }
        this.menuSetLabel(item, element);
        item.setActionCommand("assignAtom_" + element + "P!:??");
        return "set picking assignAtom_" + element;
    }

    @Override
    public void menuFocusCallback(String name, String actionCommand, boolean gained) {
        if (gained && !this.modelkit.processSymop(name, true)) {
            this.setActiveMenu(name);
        }
    }

    @Override
    public void menuClickCallback(SC source, String script) {
        if (this.modelkit.processSymop(source.getName(), false)) {
            return;
        }
        if (script.equals("clearQPersist")) {
            for (SC item : this.htCheckbox.values()) {
                if (item.getActionCommand().indexOf(":??") < 0) continue;
                this.menuSetLabel(item, "??");
                item.setActionCommand("_??P!:");
            }
            this.appRunScript("set picking assignAtom_C");
            return;
        }
        this.doMenuClickCallback(source, script);
    }

    @Override
    protected String getScriptForCallback(SC source, String id, String script) {
        if (script.startsWith("mk")) {
            this.modelkit.processXtalClick(id, script);
            script = null;
        }
        return script;
    }

    @Override
    protected boolean appRunSpecialCheckBox(SC item, String basename, String script, boolean TF) {
        if (basename.indexOf("assignAtom_Xx") == 0) {
            this.modelkit.resetAtomPickType();
        }
        if (TF && !this.updatingForShow && basename.indexOf("Bond") < 0) {
            this.updatingForShow = true;
            this.exitBondRotation();
            this.updatingForShow = false;
        }
        return super.appRunSpecialCheckBox(item, basename, script, TF);
    }

    public void updateCheckBoxesForModelKit(String menuName) {
        String thisAtomType = "assignAtom_" + this.modelkit.pickAtomAssignType + "P";
        String thisBondType = "assignBond_" + this.modelkit.pickBondAssignType;
        for (Map.Entry entry : this.htCheckbox.entrySet()) {
            SC item = (SC)entry.getValue();
            String key = item.getActionCommand();
            if (!key.startsWith(thisBondType) && !key.startsWith(thisAtomType)) continue;
            this.updatingForShow = true;
            item.setSelected(false);
            item.setSelected(true);
            this.updatingForShow = false;
        }
    }
}

