/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class TextBlockBordered
extends AbstractTextBlock
implements TextBlock {
    private final double cornersize;
    private final HColor backgroundColor;
    private final HColor borderColor;
    private final double top;
    private final double right;
    private final double bottom;
    private final double left;
    private final UStroke stroke;
    private final boolean withShadow;
    private final String id;
    private final TextBlock textBlock;

    TextBlockBordered(TextBlock textBlock, UStroke stroke, HColor borderColor, HColor backgroundColor, double cornersize, ClockwiseTopRightBottomLeft margins, String id) {
        this.top = margins.getTop();
        this.right = margins.getRight();
        this.bottom = margins.getBottom();
        this.left = margins.getLeft();
        this.cornersize = cornersize;
        this.textBlock = textBlock;
        this.withShadow = false;
        this.stroke = stroke;
        this.borderColor = borderColor;
        this.backgroundColor = backgroundColor;
        this.id = id;
    }

    private double getTextHeight(StringBounder stringBounder) {
        XDimension2D size = this.textBlock.calculateDimension(stringBounder);
        return size.getHeight() + this.top + this.bottom;
    }

    private double getPureTextWidth(StringBounder stringBounder) {
        XDimension2D size = this.textBlock.calculateDimension(stringBounder);
        return size.getWidth();
    }

    private double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + this.left + this.right;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double height = this.getTextHeight(stringBounder);
        double width = this.getTextWidth(stringBounder);
        return new XDimension2D(width + 1.0, height + 1.0);
    }

    private UGraphic applyStroke(UGraphic ug) {
        if (this.stroke == null) {
            return ug;
        }
        return ug.apply(this.stroke);
    }

    private boolean noBorder() {
        if (this.stroke == null) {
            return false;
        }
        return this.stroke.getThickness() == 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        HColor color;
        StringBounder stringBounder = ug.getStringBounder();
        Shadowable polygon = this.getPolygonNormal(stringBounder);
        UGraphic ugOriginal = ug;
        if (this.withShadow) {
            polygon.setDeltaShadow(4.0);
        }
        HColor back = this.backgroundColor == null || this.backgroundColor.isTransparent() || this.backgroundColor.equals(ug.getDefaultBackground()) ? HColors.none() : this.backgroundColor;
        HColor hColor = color = this.noBorder() ? back : this.borderColor;
        if (color == null) {
            color = HColors.none();
        }
        if (!back.isTransparent() || !color.isTransparent()) {
            ug = ug.apply(back.bg());
            ug = ug.apply(color);
            ug = this.applyStroke(ug);
            ug.draw(polygon);
        }
        TextBlock toDraw = this.textBlock;
        if (this.textBlock instanceof SheetBlock2) {
            toDraw = ((SheetBlock2)this.textBlock).enlargeMe(this.left, this.right);
        }
        toDraw.drawU(ugOriginal.apply(color).apply(new UTranslate(this.left, this.top)));
    }

    private Shadowable getPolygonNormal(StringBounder stringBounder) {
        double height = this.getTextHeight(stringBounder);
        double width = this.getTextWidth(stringBounder);
        return new URectangle(width, height).rounded(this.cornersize).withCommentAndCodeLine(this.id, null);
    }
}

