/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.ArrowAndNoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ConstraintSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.Frontier;
import net.sourceforge.plantuml.sequencediagram.graphic.InGroupablesStack;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.MessageExoArrow;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantRange;
import net.sourceforge.plantuml.sequencediagram.graphic.Step1Abstract;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;

class Step1MessageExo
extends Step1Abstract {
    private final MessageExoArrow messageArrow;

    Step1MessageExo(ParticipantRange range, StringBounder stringBounder, MessageExo message, DrawableSet drawingSet, Frontier freeY) {
        super(range, stringBounder, message, drawingSet, freeY);
        this.setConfig(this.getArrowType(message));
        ArrowComponent comp = drawingSet.getSkin().createComponentArrow(message.getUsedStyles(), this.getConfig(), drawingSet.getSkinParam(), message.getLabelNumbered());
        this.messageArrow = new MessageExoArrow(freeY.getFreeY(range), drawingSet.getSkin(), comp, this.getLivingParticipantBox(), message.getType(), message.getUrl(), message.isShortArrow(), message.getArrowConfiguration());
        List<Note> noteOnMessages = message.getNoteOnMessages();
        for (Note noteOnMessage : noteOnMessages) {
            ISkinParam skinParam = noteOnMessage.getSkinParamBackcolored(drawingSet.getSkinParam());
            Component note = drawingSet.getSkin().createComponentNote(noteOnMessage.getUsedStyles(), ComponentType.NOTE, skinParam, noteOnMessage.getStrings(), noteOnMessage.getColors());
            this.addNote(note);
        }
    }

    @Override
    Frontier prepareMessage(ConstraintSet constraintSet, InGroupablesStack inGroupablesStack) {
        Arrow graphic = this.createArrow();
        double arrowYStartLevel = graphic.getArrowYStartLevel(this.getStringBounder());
        double arrowYEndLevel = graphic.getArrowYEndLevel(this.getStringBounder());
        this.getMessage().setPosYstartLevel(arrowYStartLevel);
        double length = graphic.getArrowOnlyWidth(this.getStringBounder());
        this.incFreeY(graphic.getPreferredHeight(this.getStringBounder()));
        double marginActivateAndDeactive = 0.0;
        if (this.getMessage().isActivateAndDeactive()) {
            marginActivateAndDeactive = 30.0;
            this.incFreeY(marginActivateAndDeactive);
        }
        this.getDrawingSet().addEvent(this.getMessage(), graphic);
        LivingParticipantBox livingParticipantBox = this.getLivingParticipantBox();
        if (this.messageArrow.getType().isRightBorder()) {
            constraintSet.getConstraint(livingParticipantBox.getParticipantBox(), constraintSet.getLastborder()).ensureValue(length);
        } else {
            constraintSet.getConstraint(constraintSet.getFirstBorder(), livingParticipantBox.getParticipantBox()).ensureValue(length);
        }
        double posYendLevel = arrowYEndLevel + marginActivateAndDeactive;
        this.getMessage().setPosYendLevel(posYendLevel);
        assert (graphic instanceof InGroupable);
        if (graphic instanceof InGroupable) {
            inGroupablesStack.addElement(graphic);
            inGroupablesStack.addElement(livingParticipantBox);
        }
        return this.getFreeY();
    }

    private LivingParticipantBox getLivingParticipantBox() {
        return this.getDrawingSet().getLivingParticipantBox(((MessageExo)this.getMessage()).getParticipant());
    }

    private Arrow createArrow() {
        if (this.getMessage().getNoteOnMessages().size() == 0) {
            return this.messageArrow;
        }
        ArrayList<NoteBox> noteBoxes = new ArrayList<NoteBox>();
        for (int i = 0; i < this.getNotes().size(); ++i) {
            Component note = this.getNotes().get(i);
            Note noteOnMessage = this.getMessage().getNoteOnMessages().get(i);
            noteBoxes.add(this.createNoteBox(this.getStringBounder(), this.messageArrow, note, noteOnMessage));
        }
        return new ArrowAndNoteBox(this.getStringBounder(), this.messageArrow, noteBoxes);
    }

    private ArrowConfiguration getArrowType(MessageExo m) {
        MessageExoType type = m.getType();
        ArrowConfiguration result = null;
        result = type.getDirection() == 1 ? m.getArrowConfiguration() : m.getArrowConfiguration().reverse();
        return result;
    }
}

