from typing import Any

class Range:
    def __init__(self, lower: Any | None = ..., upper: Any | None = ..., bounds: str = ..., empty: bool = ...) -> None: ...
    @property
    def lower(self): ...
    @property
    def upper(self): ...
    @property
    def isempty(self): ...
    @property
    def lower_inf(self): ...
    @property
    def upper_inf(self): ...
    @property
    def lower_inc(self): ...
    @property
    def upper_inc(self): ...
    def __contains__(self, x): ...
    def __bool__(self) -> bool: ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __hash__(self) -> int: ...
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __gt__(self, other): ...
    def __ge__(self, other): ...

def register_range(pgrange, pyrange, conn_or_curs, globally: bool = ...): ...

class RangeAdapter:
    name: Any
    adapted: Any
    def __init__(self, adapted) -> None: ...
    def __conform__(self, proto): ...
    def prepare(self, conn) -> None: ...
    def getquoted(self): ...

class RangeCaster:
    subtype_oid: Any
    typecaster: Any
    array_typecaster: Any
    def __init__(self, pgrange, pyrange, oid, subtype_oid, array_oid: Any | None = ...) -> None: ...
    def parse(self, s, cur: Any | None = ...): ...

class NumericRange(Range): ...
class DateRange(Range): ...
class DateTimeRange(Range): ...
class DateTimeTZRange(Range): ...

class NumberRangeAdapter(RangeAdapter):
    def getquoted(self): ...

int4range_caster: Any
int8range_caster: Any
numrange_caster: Any
daterange_caster: Any
tsrange_caster: Any
tstzrange_caster: Any
