/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.AbstractArtifact;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ArtifactRevisionId;
import org.apache.ivy.core.module.id.ModuleRevisionId;

public class DefaultArtifact
extends AbstractArtifact {
    private Date publicationDate;
    private ArtifactRevisionId arid;
    private URL url;
    private boolean isMetadata = false;

    public static Artifact newIvyArtifact(ModuleRevisionId moduleRevisionId, Date date) {
        return new DefaultArtifact(moduleRevisionId, date, "ivy", "ivy", "xml", true);
    }

    public static Artifact newPomArtifact(ModuleRevisionId moduleRevisionId, Date date) {
        return new DefaultArtifact(moduleRevisionId, date, moduleRevisionId.getName(), "pom", "pom", true);
    }

    public static Artifact cloneWithAnotherType(Artifact artifact, String string) {
        return DefaultArtifact.cloneWithAnotherTypeAndExt(artifact, string, artifact.getExt());
    }

    public static Artifact cloneWithAnotherTypeAndExt(Artifact artifact, String string, String string2) {
        return new DefaultArtifact(ArtifactRevisionId.newInstance(artifact.getModuleRevisionId(), artifact.getName(), string, string2, artifact.getQualifiedExtraAttributes()), artifact.getPublicationDate(), artifact.getUrl(), artifact.isMetadata());
    }

    public DefaultArtifact(ModuleRevisionId moduleRevisionId, Date date, String string, String string2, String string3) {
        this(moduleRevisionId, date, string, string2, string3, null, null);
    }

    public DefaultArtifact(ModuleRevisionId moduleRevisionId, Date date, String string, String string2, String string3, boolean bl) {
        this(moduleRevisionId, date, string, string2, string3, null, null);
        this.isMetadata = bl;
    }

    public DefaultArtifact(ModuleRevisionId moduleRevisionId, Date date, String string, String string2, String string3, Map map) {
        this(moduleRevisionId, date, string, string2, string3, null, map);
    }

    public DefaultArtifact(ModuleRevisionId moduleRevisionId, Date date, String string, String string2, String string3, URL uRL, Map map) {
        this(ArtifactRevisionId.newInstance(moduleRevisionId, string, string2, string3, map), date, uRL, false);
    }

    public DefaultArtifact(ArtifactRevisionId artifactRevisionId, Date date, URL uRL, boolean bl) {
        if (artifactRevisionId == null) {
            throw new NullPointerException("null arid not allowed");
        }
        if (date == null) {
            date = new Date();
        }
        this.publicationDate = date;
        this.arid = artifactRevisionId;
        this.url = uRL;
        this.isMetadata = bl;
    }

    @Override
    public ModuleRevisionId getModuleRevisionId() {
        return this.arid.getModuleRevisionId();
    }

    @Override
    public String getName() {
        return this.arid.getName();
    }

    @Override
    public Date getPublicationDate() {
        return this.publicationDate;
    }

    @Override
    public String getType() {
        return this.arid.getType();
    }

    @Override
    public String getExt() {
        return this.arid.getExt();
    }

    @Override
    public ArtifactRevisionId getId() {
        return this.arid;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public boolean isMetadata() {
        return this.isMetadata;
    }
}

