// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32f215.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32f215
// +build stm32,stm32f215

// STM32F215
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32F215"
	CPU          = "CM3"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Window watchdog
	IRQ_WWDG = 0

	// Power control
	IRQ_PVD = 1

	// External interrupt/event controller
	IRQ_TAMP_STAMP = 2

	// Real-time clock
	IRQ_RTC_WKUP = 3

	// FLASH
	IRQ_FLASH = 4

	// Reset and clock control
	IRQ_RCC = 5

	// External interrupt/event controller
	IRQ_EXTI0 = 6

	// External interrupt/event controller
	IRQ_EXTI1 = 7

	// External interrupt/event controller
	IRQ_EXTI2 = 8

	// External interrupt/event controller
	IRQ_EXTI3 = 9

	// External interrupt/event controller
	IRQ_EXTI4 = 10

	IRQ_DMA1_Stream0 = 11

	IRQ_DMA1_Stream1 = 12

	IRQ_DMA1_Stream2 = 13

	IRQ_DMA1_Stream3 = 14

	IRQ_DMA1_Stream4 = 15

	IRQ_DMA1_Stream5 = 16

	IRQ_DMA1_Stream6 = 17

	// Analog-to-digital converter //
	IRQ_ADC = 18

	IRQ_CAN1_TX = 19

	IRQ_CAN1_RX0 = 20

	IRQ_CAN1_RX1 = 21

	IRQ_CAN1_SCE = 22

	// External interrupt/event controller
	IRQ_EXTI9_5 = 23

	// Advanced-timers // General-purpose-timers
	IRQ_TIM1_BRK_TIM9 = 24

	// Advanced-timers // General-purpose-timers
	IRQ_TIM1_UP_TIM10 = 25

	// Advanced-timers //
	IRQ_TIM1_TRG_COM_TIM11 = 26

	// Advanced-timers
	IRQ_TIM1_CC = 27

	// General-purpose-timers
	IRQ_TIM2 = 28

	// General-purpose-timers
	IRQ_TIM3 = 29

	IRQ_TIM4 = 30

	// Inter-integrated circuit
	IRQ_I2C1_EV = 31

	// Inter-integrated circuit
	IRQ_I2C1_ER = 32

	IRQ_I2C2_EV = 33

	IRQ_I2C2_ER = 34

	// Serial peripheral interface
	IRQ_SPI1 = 35

	IRQ_SPI2 = 36

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 37

	IRQ_USART2 = 38

	IRQ_USART3 = 39

	// External interrupt/event controller
	IRQ_EXTI15_10 = 40

	// Real-time clock
	IRQ_RTC_Alarm = 41

	// USB on the go full speed
	IRQ_OTG_FS_WKUP = 42

	IRQ_TIM8_BRK_TIM12 = 43

	IRQ_TIM8_UP_TIM13 = 44

	IRQ_TIM8_TRG_COM_TIM14 = 45

	IRQ_TIM8_CC = 46

	IRQ_DMA1_Stream7 = 47

	// Flexible static memory controller
	IRQ_FSMC = 48

	// Secure digital input/output interface
	IRQ_SDIO = 49

	// General-purpose-timers
	IRQ_TIM5 = 50

	IRQ_SPI3 = 51

	// Universal synchronous asynchronous receiver transmitter
	IRQ_UART4 = 52

	IRQ_UART5 = 53

	// Digital-to-analog converter // Basic-timers
	IRQ_TIM6_DAC = 54

	IRQ_TIM7 = 55

	// DMA controller
	IRQ_DMA2_Stream0 = 56

	// DMA controller
	IRQ_DMA2_Stream1 = 57

	// DMA controller
	IRQ_DMA2_Stream2 = 58

	// DMA controller
	IRQ_DMA2_Stream3 = 59

	// DMA controller
	IRQ_DMA2_Stream4 = 60

	// Ethernet: media access control (MAC)
	IRQ_ETH = 61

	// Ethernet: media access control (MAC)
	IRQ_ETH_WKUP = 62

	// Controller area network
	IRQ_CAN2_TX = 63

	// Controller area network
	IRQ_CAN2_RX0 = 64

	// Controller area network
	IRQ_CAN2_RX1 = 65

	// Controller area network
	IRQ_CAN2_SCE = 66

	// USB on the go full speed
	IRQ_OTG_FS = 67

	// DMA controller
	IRQ_DMA2_Stream5 = 68

	// DMA controller
	IRQ_DMA2_Stream6 = 69

	// DMA controller
	IRQ_DMA2_Stream7 = 70

	IRQ_USART6 = 71

	IRQ_I2C3_EV = 72

	IRQ_I2C3_ER = 73

	// USB on the go high speed
	IRQ_OTG_HS_EP1_OUT = 74

	// USB on the go high speed
	IRQ_OTG_HS_EP1_IN = 75

	// USB on the go high speed
	IRQ_OTG_HS_WKUP = 76

	// USB on the go high speed
	IRQ_OTG_HS = 77

	// Digital camera interface
	IRQ_DCMI = 78

	// Cryptographic processor
	IRQ_CRYP = 79

	// Random number generator // Hash processor
	IRQ_HASH_RNG = 80

	// Highest interrupt number on this device.
	IRQ_max = 80
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG_IRQHandler
func interruptWWDG() {
	callHandlers(IRQ_WWDG)
}

//export PVD_IRQHandler
func interruptPVD() {
	callHandlers(IRQ_PVD)
}

//export TAMP_STAMP_IRQHandler
func interruptTAMP_STAMP() {
	callHandlers(IRQ_TAMP_STAMP)
}

//export RTC_WKUP_IRQHandler
func interruptRTC_WKUP() {
	callHandlers(IRQ_RTC_WKUP)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export RCC_IRQHandler
func interruptRCC() {
	callHandlers(IRQ_RCC)
}

//export EXTI0_IRQHandler
func interruptEXTI0() {
	callHandlers(IRQ_EXTI0)
}

//export EXTI1_IRQHandler
func interruptEXTI1() {
	callHandlers(IRQ_EXTI1)
}

//export EXTI2_IRQHandler
func interruptEXTI2() {
	callHandlers(IRQ_EXTI2)
}

//export EXTI3_IRQHandler
func interruptEXTI3() {
	callHandlers(IRQ_EXTI3)
}

//export EXTI4_IRQHandler
func interruptEXTI4() {
	callHandlers(IRQ_EXTI4)
}

//export DMA1_Stream0_IRQHandler
func interruptDMA1_Stream0() {
	callHandlers(IRQ_DMA1_Stream0)
}

//export DMA1_Stream1_IRQHandler
func interruptDMA1_Stream1() {
	callHandlers(IRQ_DMA1_Stream1)
}

//export DMA1_Stream2_IRQHandler
func interruptDMA1_Stream2() {
	callHandlers(IRQ_DMA1_Stream2)
}

//export DMA1_Stream3_IRQHandler
func interruptDMA1_Stream3() {
	callHandlers(IRQ_DMA1_Stream3)
}

//export DMA1_Stream4_IRQHandler
func interruptDMA1_Stream4() {
	callHandlers(IRQ_DMA1_Stream4)
}

//export DMA1_Stream5_IRQHandler
func interruptDMA1_Stream5() {
	callHandlers(IRQ_DMA1_Stream5)
}

//export DMA1_Stream6_IRQHandler
func interruptDMA1_Stream6() {
	callHandlers(IRQ_DMA1_Stream6)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export CAN1_TX_IRQHandler
func interruptCAN1_TX() {
	callHandlers(IRQ_CAN1_TX)
}

//export CAN1_RX0_IRQHandler
func interruptCAN1_RX0() {
	callHandlers(IRQ_CAN1_RX0)
}

//export CAN1_RX1_IRQHandler
func interruptCAN1_RX1() {
	callHandlers(IRQ_CAN1_RX1)
}

//export CAN1_SCE_IRQHandler
func interruptCAN1_SCE() {
	callHandlers(IRQ_CAN1_SCE)
}

//export EXTI9_5_IRQHandler
func interruptEXTI9_5() {
	callHandlers(IRQ_EXTI9_5)
}

//export TIM1_BRK_TIM9_IRQHandler
func interruptTIM1_BRK_TIM9() {
	callHandlers(IRQ_TIM1_BRK_TIM9)
}

//export TIM1_UP_TIM10_IRQHandler
func interruptTIM1_UP_TIM10() {
	callHandlers(IRQ_TIM1_UP_TIM10)
}

//export TIM1_TRG_COM_TIM11_IRQHandler
func interruptTIM1_TRG_COM_TIM11() {
	callHandlers(IRQ_TIM1_TRG_COM_TIM11)
}

//export TIM1_CC_IRQHandler
func interruptTIM1_CC() {
	callHandlers(IRQ_TIM1_CC)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM3_IRQHandler
func interruptTIM3() {
	callHandlers(IRQ_TIM3)
}

//export TIM4_IRQHandler
func interruptTIM4() {
	callHandlers(IRQ_TIM4)
}

//export I2C1_EV_IRQHandler
func interruptI2C1_EV() {
	callHandlers(IRQ_I2C1_EV)
}

//export I2C1_ER_IRQHandler
func interruptI2C1_ER() {
	callHandlers(IRQ_I2C1_ER)
}

//export I2C2_EV_IRQHandler
func interruptI2C2_EV() {
	callHandlers(IRQ_I2C2_EV)
}

//export I2C2_ER_IRQHandler
func interruptI2C2_ER() {
	callHandlers(IRQ_I2C2_ER)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2_IRQHandler
func interruptSPI2() {
	callHandlers(IRQ_SPI2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export USART3_IRQHandler
func interruptUSART3() {
	callHandlers(IRQ_USART3)
}

//export EXTI15_10_IRQHandler
func interruptEXTI15_10() {
	callHandlers(IRQ_EXTI15_10)
}

//export RTC_Alarm_IRQHandler
func interruptRTC_Alarm() {
	callHandlers(IRQ_RTC_Alarm)
}

//export OTG_FS_WKUP_IRQHandler
func interruptOTG_FS_WKUP() {
	callHandlers(IRQ_OTG_FS_WKUP)
}

//export TIM8_BRK_TIM12_IRQHandler
func interruptTIM8_BRK_TIM12() {
	callHandlers(IRQ_TIM8_BRK_TIM12)
}

//export TIM8_UP_TIM13_IRQHandler
func interruptTIM8_UP_TIM13() {
	callHandlers(IRQ_TIM8_UP_TIM13)
}

//export TIM8_TRG_COM_TIM14_IRQHandler
func interruptTIM8_TRG_COM_TIM14() {
	callHandlers(IRQ_TIM8_TRG_COM_TIM14)
}

//export TIM8_CC_IRQHandler
func interruptTIM8_CC() {
	callHandlers(IRQ_TIM8_CC)
}

//export DMA1_Stream7_IRQHandler
func interruptDMA1_Stream7() {
	callHandlers(IRQ_DMA1_Stream7)
}

//export FSMC_IRQHandler
func interruptFSMC() {
	callHandlers(IRQ_FSMC)
}

//export SDIO_IRQHandler
func interruptSDIO() {
	callHandlers(IRQ_SDIO)
}

//export TIM5_IRQHandler
func interruptTIM5() {
	callHandlers(IRQ_TIM5)
}

//export SPI3_IRQHandler
func interruptSPI3() {
	callHandlers(IRQ_SPI3)
}

//export UART4_IRQHandler
func interruptUART4() {
	callHandlers(IRQ_UART4)
}

//export UART5_IRQHandler
func interruptUART5() {
	callHandlers(IRQ_UART5)
}

//export TIM6_DAC_IRQHandler
func interruptTIM6_DAC() {
	callHandlers(IRQ_TIM6_DAC)
}

//export TIM7_IRQHandler
func interruptTIM7() {
	callHandlers(IRQ_TIM7)
}

//export DMA2_Stream0_IRQHandler
func interruptDMA2_Stream0() {
	callHandlers(IRQ_DMA2_Stream0)
}

//export DMA2_Stream1_IRQHandler
func interruptDMA2_Stream1() {
	callHandlers(IRQ_DMA2_Stream1)
}

//export DMA2_Stream2_IRQHandler
func interruptDMA2_Stream2() {
	callHandlers(IRQ_DMA2_Stream2)
}

//export DMA2_Stream3_IRQHandler
func interruptDMA2_Stream3() {
	callHandlers(IRQ_DMA2_Stream3)
}

//export DMA2_Stream4_IRQHandler
func interruptDMA2_Stream4() {
	callHandlers(IRQ_DMA2_Stream4)
}

//export ETH_IRQHandler
func interruptETH() {
	callHandlers(IRQ_ETH)
}

//export ETH_WKUP_IRQHandler
func interruptETH_WKUP() {
	callHandlers(IRQ_ETH_WKUP)
}

//export CAN2_TX_IRQHandler
func interruptCAN2_TX() {
	callHandlers(IRQ_CAN2_TX)
}

//export CAN2_RX0_IRQHandler
func interruptCAN2_RX0() {
	callHandlers(IRQ_CAN2_RX0)
}

//export CAN2_RX1_IRQHandler
func interruptCAN2_RX1() {
	callHandlers(IRQ_CAN2_RX1)
}

//export CAN2_SCE_IRQHandler
func interruptCAN2_SCE() {
	callHandlers(IRQ_CAN2_SCE)
}

//export OTG_FS_IRQHandler
func interruptOTG_FS() {
	callHandlers(IRQ_OTG_FS)
}

//export DMA2_Stream5_IRQHandler
func interruptDMA2_Stream5() {
	callHandlers(IRQ_DMA2_Stream5)
}

//export DMA2_Stream6_IRQHandler
func interruptDMA2_Stream6() {
	callHandlers(IRQ_DMA2_Stream6)
}

//export DMA2_Stream7_IRQHandler
func interruptDMA2_Stream7() {
	callHandlers(IRQ_DMA2_Stream7)
}

//export USART6_IRQHandler
func interruptUSART6() {
	callHandlers(IRQ_USART6)
}

//export I2C3_EV_IRQHandler
func interruptI2C3_EV() {
	callHandlers(IRQ_I2C3_EV)
}

//export I2C3_ER_IRQHandler
func interruptI2C3_ER() {
	callHandlers(IRQ_I2C3_ER)
}

//export OTG_HS_EP1_OUT_IRQHandler
func interruptOTG_HS_EP1_OUT() {
	callHandlers(IRQ_OTG_HS_EP1_OUT)
}

//export OTG_HS_EP1_IN_IRQHandler
func interruptOTG_HS_EP1_IN() {
	callHandlers(IRQ_OTG_HS_EP1_IN)
}

//export OTG_HS_WKUP_IRQHandler
func interruptOTG_HS_WKUP() {
	callHandlers(IRQ_OTG_HS_WKUP)
}

//export OTG_HS_IRQHandler
func interruptOTG_HS() {
	callHandlers(IRQ_OTG_HS)
}

//export DCMI_IRQHandler
func interruptDCMI() {
	callHandlers(IRQ_DCMI)
}

//export CRYP_IRQHandler
func interruptCRYP() {
	callHandlers(IRQ_CRYP)
}

//export HASH_RNG_IRQHandler
func interruptHASH_RNG() {
	callHandlers(IRQ_HASH_RNG)
}

// Peripherals.
var (
	// Random number generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x50060800)))

	// cyclic redundancy check calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Digital camera interface
	DCMI = (*DCMI_Type)(unsafe.Pointer(uintptr(0x50050000)))

	// Flexible static memory controller
	FSMC = (*FSMC_Type)(unsafe.Pointer(uintptr(0xa0000000)))

	// Debug support
	DBGMCU = (*DBG_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// DMA controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026400)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40023800)))

	// General-purpose I/Os
	GPIOI = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Serial peripheral interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Secure digital input/output interface
	SDIO = (*SDIO_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// Analog-to-digital converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012000)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011000)))

	// Digital-to-analog converter
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// Controller area network
	CAN2 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006800)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Universal synchronous asynchronous receiver transmitter
	UART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Common ADC registers
	ADC_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012300)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// General-purpose-timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General-purpose-timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// General-purpose-timers
	TIM5 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// General-purpose-timers
	TIM9 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General-purpose-timers
	TIM10 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// Basic-timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// Ethernet: media access control (MAC)
	Ethernet_MAC = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// Ethernet: MAC management counters
	Ethernet_MMC = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40028100)))

	// Ethernet: Precision time protocol
	Ethernet_PTP = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40028700)))

	// Ethernet: DMA controller operation
	Ethernet_DMA = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40029000)))

	// USB on the go full speed
	OTG_FS_GLOBAL = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// USB on the go full speed
	OTG_FS_HOST = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000400)))

	// USB on the go full speed
	OTG_FS_DEVICE = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000800)))

	// USB on the go full speed
	OTG_FS_PWRCLK = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000e00)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40013c00)))

	// FLASH
	FLASH = (*FLASH_Type)(unsafe.Pointer(uintptr(0x40023c00)))

	// Hash processor
	HASH = (*HASH_Type)(unsafe.Pointer(uintptr(0x50060400)))

	// Cryptographic processor
	CRYP = (*CRYP_Type)(unsafe.Pointer(uintptr(0x50060000)))

	// USB on the go high speed
	OTG_HS_GLOBAL = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// USB on the go high speed
	OTG_HS_HOST = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040400)))

	// USB on the go high speed
	OTG_HS_DEVICE = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040800)))

	// USB on the go high speed
	OTG_HS_PWRCLK = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040e00)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// DMA controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026000)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021c00)))

	// General-purpose I/Os
	GPIOG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021800)))

	// General-purpose I/Os
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021400)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020c00)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// Serial peripheral interface
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// Serial peripheral interface
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Analog-to-digital converter
	ADC2 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012100)))

	// Analog-to-digital converter
	ADC3 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012200)))

	// Universal synchronous asynchronous receiver transmitter
	USART6 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011400)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Controller area network
	CAN1 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006400)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Universal synchronous asynchronous receiver transmitter
	UART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Advanced-timers
	TIM8 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// General-purpose-timers
	TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// General-purpose-timers
	TIM12 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001800)))

	// General-purpose-timers
	TIM11 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// General-purpose-timers
	TIM13 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001c00)))

	// General-purpose-timers
	TIM14 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// Basic-timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))
)

// Random number generator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// RNG.CR: control register
func (o *RNG_Type) SetCR_IE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RNG_Type) GetCR_IE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RNG_Type) SetCR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetCR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}

// RNG.SR: status register
func (o *RNG_Type) SetSR_SEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *RNG_Type) GetSR_SEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *RNG_Type) SetSR_CEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *RNG_Type) GetSR_CEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *RNG_Type) SetSR_SECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetSR_SECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetSR_CECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RNG_Type) GetSR_CECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RNG_Type) SetSR_DRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetSR_DRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// RNG.DR: data register
func (o *RNG_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *RNG_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// cyclic redundancy check calculation unit
type CRC_Type struct {
	DR  volatile.Register32 // 0x0
	IDR volatile.Register32 // 0x4
	CR  volatile.Register32 // 0x8
}

// CRC.DR: Data register
func (o *CRC_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *CRC_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// CRC.IDR: Independent data register
func (o *CRC_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xff)|value)
}
func (o *CRC_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0xff
}

// CRC.CR: Control register
func (o *CRC_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRC_Type) GetCR_RESET() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// Digital camera interface
type DCMI_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	RIS    volatile.Register32 // 0x8
	IER    volatile.Register32 // 0xC
	MIS    volatile.Register32 // 0x10
	ICR    volatile.Register32 // 0x14
	ESCR   volatile.Register32 // 0x18
	ESUR   volatile.Register32 // 0x1C
	CWSTRT volatile.Register32 // 0x20
	CWSIZE volatile.Register32 // 0x24
	DR     volatile.Register32 // 0x28
}

// DCMI.CR: control register 1
func (o *DCMI_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *DCMI_Type) GetCR_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *DCMI_Type) SetCR_EDM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00)|value<<10)
}
func (o *DCMI_Type) GetCR_EDM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00) >> 10
}
func (o *DCMI_Type) SetCR_FCRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *DCMI_Type) GetCR_FCRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *DCMI_Type) SetCR_VSPOL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DCMI_Type) GetCR_VSPOL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DCMI_Type) SetCR_HSPOL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DCMI_Type) GetCR_HSPOL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DCMI_Type) SetCR_PCKPOL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DCMI_Type) GetCR_PCKPOL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DCMI_Type) SetCR_ESS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetCR_ESS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetCR_JPEG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetCR_JPEG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetCR_CROP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetCR_CROP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetCR_CM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetCR_CM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetCR_CAPTURE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetCR_CAPTURE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DCMI.SR: status register
func (o *DCMI_Type) SetSR_FNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetSR_FNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetSR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetSR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetSR_HSYNC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetSR_HSYNC() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// DCMI.RIS: raw interrupt status register
func (o *DCMI_Type) SetRIS_LINE_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetRIS_LINE_RIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetRIS_VSYNC_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetRIS_VSYNC_RIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetRIS_ERR_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetRIS_ERR_RIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetRIS_OVR_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetRIS_OVR_RIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetRIS_FRAME_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetRIS_FRAME_RIS() uint32 {
	return volatile.LoadUint32(&o.RIS.Reg) & 0x1
}

// DCMI.IER: interrupt enable register
func (o *DCMI_Type) SetIER_LINE_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetIER_LINE_IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetIER_VSYNC_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetIER_VSYNC_IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetIER_ERR_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetIER_ERR_IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetIER_OVR_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetIER_OVR_IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetIER_FRAME_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetIER_FRAME_IE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// DCMI.MIS: masked interrupt status register
func (o *DCMI_Type) SetMIS_LINE_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetMIS_LINE_MIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetMIS_VSYNC_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetMIS_VSYNC_MIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetMIS_ERR_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetMIS_ERR_MIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetMIS_OVR_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetMIS_OVR_MIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetMIS_FRAME_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetMIS_FRAME_MIS() uint32 {
	return volatile.LoadUint32(&o.MIS.Reg) & 0x1
}

// DCMI.ICR: interrupt clear register
func (o *DCMI_Type) SetICR_LINE_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetICR_LINE_ISC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetICR_VSYNC_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetICR_VSYNC_ISC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetICR_ERR_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetICR_ERR_ISC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetICR_OVR_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetICR_OVR_ISC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetICR_FRAME_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetICR_FRAME_ISC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// DCMI.ESCR: embedded synchronization code register
func (o *DCMI_Type) SetESCR_FEC(value uint32) {
	volatile.StoreUint32(&o.ESCR.Reg, volatile.LoadUint32(&o.ESCR.Reg)&^(0xff000000)|value<<24)
}
func (o *DCMI_Type) GetESCR_FEC() uint32 {
	return (volatile.LoadUint32(&o.ESCR.Reg) & 0xff000000) >> 24
}
func (o *DCMI_Type) SetESCR_LEC(value uint32) {
	volatile.StoreUint32(&o.ESCR.Reg, volatile.LoadUint32(&o.ESCR.Reg)&^(0xff0000)|value<<16)
}
func (o *DCMI_Type) GetESCR_LEC() uint32 {
	return (volatile.LoadUint32(&o.ESCR.Reg) & 0xff0000) >> 16
}
func (o *DCMI_Type) SetESCR_LSC(value uint32) {
	volatile.StoreUint32(&o.ESCR.Reg, volatile.LoadUint32(&o.ESCR.Reg)&^(0xff00)|value<<8)
}
func (o *DCMI_Type) GetESCR_LSC() uint32 {
	return (volatile.LoadUint32(&o.ESCR.Reg) & 0xff00) >> 8
}
func (o *DCMI_Type) SetESCR_FSC(value uint32) {
	volatile.StoreUint32(&o.ESCR.Reg, volatile.LoadUint32(&o.ESCR.Reg)&^(0xff)|value)
}
func (o *DCMI_Type) GetESCR_FSC() uint32 {
	return volatile.LoadUint32(&o.ESCR.Reg) & 0xff
}

// DCMI.ESUR: embedded synchronization unmask register
func (o *DCMI_Type) SetESUR_FEU(value uint32) {
	volatile.StoreUint32(&o.ESUR.Reg, volatile.LoadUint32(&o.ESUR.Reg)&^(0xff000000)|value<<24)
}
func (o *DCMI_Type) GetESUR_FEU() uint32 {
	return (volatile.LoadUint32(&o.ESUR.Reg) & 0xff000000) >> 24
}
func (o *DCMI_Type) SetESUR_LEU(value uint32) {
	volatile.StoreUint32(&o.ESUR.Reg, volatile.LoadUint32(&o.ESUR.Reg)&^(0xff0000)|value<<16)
}
func (o *DCMI_Type) GetESUR_LEU() uint32 {
	return (volatile.LoadUint32(&o.ESUR.Reg) & 0xff0000) >> 16
}
func (o *DCMI_Type) SetESUR_LSU(value uint32) {
	volatile.StoreUint32(&o.ESUR.Reg, volatile.LoadUint32(&o.ESUR.Reg)&^(0xff00)|value<<8)
}
func (o *DCMI_Type) GetESUR_LSU() uint32 {
	return (volatile.LoadUint32(&o.ESUR.Reg) & 0xff00) >> 8
}
func (o *DCMI_Type) SetESUR_FSU(value uint32) {
	volatile.StoreUint32(&o.ESUR.Reg, volatile.LoadUint32(&o.ESUR.Reg)&^(0xff)|value)
}
func (o *DCMI_Type) GetESUR_FSU() uint32 {
	return volatile.LoadUint32(&o.ESUR.Reg) & 0xff
}

// DCMI.CWSTRT: crop window start
func (o *DCMI_Type) SetCWSTRT_VST(value uint32) {
	volatile.StoreUint32(&o.CWSTRT.Reg, volatile.LoadUint32(&o.CWSTRT.Reg)&^(0x1fff0000)|value<<16)
}
func (o *DCMI_Type) GetCWSTRT_VST() uint32 {
	return (volatile.LoadUint32(&o.CWSTRT.Reg) & 0x1fff0000) >> 16
}
func (o *DCMI_Type) SetCWSTRT_HOFFCNT(value uint32) {
	volatile.StoreUint32(&o.CWSTRT.Reg, volatile.LoadUint32(&o.CWSTRT.Reg)&^(0x3fff)|value)
}
func (o *DCMI_Type) GetCWSTRT_HOFFCNT() uint32 {
	return volatile.LoadUint32(&o.CWSTRT.Reg) & 0x3fff
}

// DCMI.CWSIZE: crop window size
func (o *DCMI_Type) SetCWSIZE_VLINE(value uint32) {
	volatile.StoreUint32(&o.CWSIZE.Reg, volatile.LoadUint32(&o.CWSIZE.Reg)&^(0x3fff0000)|value<<16)
}
func (o *DCMI_Type) GetCWSIZE_VLINE() uint32 {
	return (volatile.LoadUint32(&o.CWSIZE.Reg) & 0x3fff0000) >> 16
}
func (o *DCMI_Type) SetCWSIZE_CAPCNT(value uint32) {
	volatile.StoreUint32(&o.CWSIZE.Reg, volatile.LoadUint32(&o.CWSIZE.Reg)&^(0x3fff)|value)
}
func (o *DCMI_Type) GetCWSIZE_CAPCNT() uint32 {
	return volatile.LoadUint32(&o.CWSIZE.Reg) & 0x3fff
}

// DCMI.DR: data register
func (o *DCMI_Type) SetDR_Byte3(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff000000)|value<<24)
}
func (o *DCMI_Type) GetDR_Byte3() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xff000000) >> 24
}
func (o *DCMI_Type) SetDR_Byte2(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff0000)|value<<16)
}
func (o *DCMI_Type) GetDR_Byte2() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xff0000) >> 16
}
func (o *DCMI_Type) SetDR_Byte1(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff00)|value<<8)
}
func (o *DCMI_Type) GetDR_Byte1() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xff00) >> 8
}
func (o *DCMI_Type) SetDR_Byte0(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff)|value)
}
func (o *DCMI_Type) GetDR_Byte0() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xff
}

// Flexible static memory controller
type FSMC_Type struct {
	BCR1  volatile.Register32 // 0x0
	BTR1  volatile.Register32 // 0x4
	BCR2  volatile.Register32 // 0x8
	BTR2  volatile.Register32 // 0xC
	BCR3  volatile.Register32 // 0x10
	BTR3  volatile.Register32 // 0x14
	BCR4  volatile.Register32 // 0x18
	BTR4  volatile.Register32 // 0x1C
	_     [64]byte
	PCR2  volatile.Register32 // 0x60
	SR2   volatile.Register32 // 0x64
	PMEM2 volatile.Register32 // 0x68
	PATT2 volatile.Register32 // 0x6C
	_     [4]byte
	ECCR2 volatile.Register32 // 0x74
	_     [8]byte
	PCR3  volatile.Register32 // 0x80
	SR3   volatile.Register32 // 0x84
	PMEM3 volatile.Register32 // 0x88
	PATT3 volatile.Register32 // 0x8C
	_     [4]byte
	ECCR3 volatile.Register32 // 0x94
	_     [8]byte
	PCR4  volatile.Register32 // 0xA0
	SR4   volatile.Register32 // 0xA4
	PMEM4 volatile.Register32 // 0xA8
	PATT4 volatile.Register32 // 0xAC
	PIO4  volatile.Register32 // 0xB0
	_     [80]byte
	BWTR1 volatile.Register32 // 0x104
	_     [4]byte
	BWTR2 volatile.Register32 // 0x10C
	_     [4]byte
	BWTR3 volatile.Register32 // 0x114
	_     [4]byte
	BWTR4 volatile.Register32 // 0x11C
}

// FSMC.BCR1: SRAM/NOR-Flash chip-select control register 1
func (o *FSMC_Type) SetBCR1_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR1_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR1_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR1_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR1_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR1_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR1_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR1_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR1_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR1_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR1_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR1_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR1_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR1_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR1_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR1_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR1_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR1_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR1_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR1_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR1_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR1_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR1_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR1_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR1_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR1_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR1.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR1_WRAPMOD(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x400)|value<<10)
}
func (o *FSMC_Type) GetBCR1_WRAPMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x400) >> 10
}
func (o *FSMC_Type) SetBCR1_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR1_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x70000) >> 16
}

// FSMC.BTR1: SRAM/NOR-Flash chip-select timing register 1
func (o *FSMC_Type) SetBTR1_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR1_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR1_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR1_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBTR1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR1_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR1_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR1_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR1_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR1_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR1_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR1_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR1_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR1.Reg) & 0xf
}

// FSMC.BCR2: SRAM/NOR-Flash chip-select control register 2
func (o *FSMC_Type) SetBCR2_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR2_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR2_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR2_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR2_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR2_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR2_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR2_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR2_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR2_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR2_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR2_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR2_WRAPMOD(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x400)|value<<10)
}
func (o *FSMC_Type) GetBCR2_WRAPMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x400) >> 10
}
func (o *FSMC_Type) SetBCR2_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR2_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR2_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR2_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR2_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR2_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR2_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR2_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR2_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR2_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR2_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR2_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR2_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR2_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR2.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR2_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR2_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x70000) >> 16
}

// FSMC.BTR2: SRAM/NOR-Flash chip-select timing register 1
func (o *FSMC_Type) SetBTR2_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR2_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR2_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR2_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBTR2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR2_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR2_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR2_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR2_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR2_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR2_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR2_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR2_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR2.Reg) & 0xf
}

// FSMC.BCR3: SRAM/NOR-Flash chip-select control register 2
func (o *FSMC_Type) SetBCR3_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR3_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR3_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR3_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR3_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR3_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR3_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR3_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR3_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR3_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR3_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR3_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR3_WRAPMOD(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x400)|value<<10)
}
func (o *FSMC_Type) GetBCR3_WRAPMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x400) >> 10
}
func (o *FSMC_Type) SetBCR3_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR3_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR3_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR3_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR3_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR3_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR3_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR3_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR3_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR3_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR3_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR3_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR3_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR3_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR3.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR3_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR3_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x70000) >> 16
}

// FSMC.BTR3: SRAM/NOR-Flash chip-select timing register 1
func (o *FSMC_Type) SetBTR3_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR3_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR3_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR3_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBTR3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR3_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR3_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR3_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR3_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR3_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR3_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR3_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR3_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR3.Reg) & 0xf
}

// FSMC.BCR4: SRAM/NOR-Flash chip-select control register 2
func (o *FSMC_Type) SetBCR4_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR4_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR4_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR4_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR4_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR4_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR4_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR4_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR4_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR4_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR4_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR4_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR4_WRAPMOD(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x400)|value<<10)
}
func (o *FSMC_Type) GetBCR4_WRAPMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x400) >> 10
}
func (o *FSMC_Type) SetBCR4_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR4_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR4_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR4_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR4_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR4_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR4_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR4_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR4_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR4_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR4_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR4_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR4_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR4_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR4.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR4_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR4_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x70000) >> 16
}

// FSMC.BTR4: SRAM/NOR-Flash chip-select timing register 1
func (o *FSMC_Type) SetBTR4_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR4_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR4_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR4_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBTR4_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR4_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR4_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR4_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR4_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR4_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR4_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR4_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR4_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR4_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR4.Reg) & 0xf
}

// FSMC.PCR2: PC Card/NAND Flash control register 2
func (o *FSMC_Type) SetPCR2_ECCPS(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0xe0000)|value<<17)
}
func (o *FSMC_Type) GetPCR2_ECCPS() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0xe0000) >> 17
}
func (o *FSMC_Type) SetPCR2_TAR(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x1e000)|value<<13)
}
func (o *FSMC_Type) GetPCR2_TAR() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x1e000) >> 13
}
func (o *FSMC_Type) SetPCR2_TCLR(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x1e00)|value<<9)
}
func (o *FSMC_Type) GetPCR2_TCLR() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x1e00) >> 9
}
func (o *FSMC_Type) SetPCR2_ECCEN(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetPCR2_ECCEN() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetPCR2_PWID(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetPCR2_PWID() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetPCR2_PTYP(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x8)|value<<3)
}
func (o *FSMC_Type) GetPCR2_PTYP() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x8) >> 3
}
func (o *FSMC_Type) SetPCR2_PBKEN(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x4)|value<<2)
}
func (o *FSMC_Type) GetPCR2_PBKEN() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x4) >> 2
}
func (o *FSMC_Type) SetPCR2_PWAITEN(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetPCR2_PWAITEN() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x2) >> 1
}

// FSMC.SR2: FIFO status and interrupt register 2
func (o *FSMC_Type) SetSR2_FEMPT(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetSR2_FEMPT() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetSR2_IFEN(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20)|value<<5)
}
func (o *FSMC_Type) GetSR2_IFEN() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20) >> 5
}
func (o *FSMC_Type) SetSR2_ILEN(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10)|value<<4)
}
func (o *FSMC_Type) GetSR2_ILEN() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10) >> 4
}
func (o *FSMC_Type) SetSR2_IREN(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x8)|value<<3)
}
func (o *FSMC_Type) GetSR2_IREN() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x8) >> 3
}
func (o *FSMC_Type) SetSR2_IFS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4)|value<<2)
}
func (o *FSMC_Type) GetSR2_IFS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4) >> 2
}
func (o *FSMC_Type) SetSR2_ILS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetSR2_ILS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetSR2_IRS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetSR2_IRS() uint32 {
	return volatile.LoadUint32(&o.SR2.Reg) & 0x1
}

// FSMC.PMEM2: Common memory space timing register 2
func (o *FSMC_Type) SetPMEM2_MEMHIZ(value uint32) {
	volatile.StoreUint32(&o.PMEM2.Reg, volatile.LoadUint32(&o.PMEM2.Reg)&^(0xff000000)|value<<24)
}
func (o *FSMC_Type) GetPMEM2_MEMHIZ() uint32 {
	return (volatile.LoadUint32(&o.PMEM2.Reg) & 0xff000000) >> 24
}
func (o *FSMC_Type) SetPMEM2_MEMHOLD(value uint32) {
	volatile.StoreUint32(&o.PMEM2.Reg, volatile.LoadUint32(&o.PMEM2.Reg)&^(0xff0000)|value<<16)
}
func (o *FSMC_Type) GetPMEM2_MEMHOLD() uint32 {
	return (volatile.LoadUint32(&o.PMEM2.Reg) & 0xff0000) >> 16
}
func (o *FSMC_Type) SetPMEM2_MEMWAIT(value uint32) {
	volatile.StoreUint32(&o.PMEM2.Reg, volatile.LoadUint32(&o.PMEM2.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetPMEM2_MEMWAIT() uint32 {
	return (volatile.LoadUint32(&o.PMEM2.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetPMEM2_MEMSET(value uint32) {
	volatile.StoreUint32(&o.PMEM2.Reg, volatile.LoadUint32(&o.PMEM2.Reg)&^(0xff)|value)
}
func (o *FSMC_Type) GetPMEM2_MEMSET() uint32 {
	return volatile.LoadUint32(&o.PMEM2.Reg) & 0xff
}

// FSMC.PATT2: Attribute memory space timing register 2
func (o *FSMC_Type) SetPATT2_ATTHIZ(value uint32) {
	volatile.StoreUint32(&o.PATT2.Reg, volatile.LoadUint32(&o.PATT2.Reg)&^(0xff000000)|value<<24)
}
func (o *FSMC_Type) GetPATT2_ATTHIZ() uint32 {
	return (volatile.LoadUint32(&o.PATT2.Reg) & 0xff000000) >> 24
}
func (o *FSMC_Type) SetPATT2_ATTHOLD(value uint32) {
	volatile.StoreUint32(&o.PATT2.Reg, volatile.LoadUint32(&o.PATT2.Reg)&^(0xff0000)|value<<16)
}
func (o *FSMC_Type) GetPATT2_ATTHOLD() uint32 {
	return (volatile.LoadUint32(&o.PATT2.Reg) & 0xff0000) >> 16
}
func (o *FSMC_Type) SetPATT2_ATTWAIT(value uint32) {
	volatile.StoreUint32(&o.PATT2.Reg, volatile.LoadUint32(&o.PATT2.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetPATT2_ATTWAIT() uint32 {
	return (volatile.LoadUint32(&o.PATT2.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetPATT2_ATTSET(value uint32) {
	volatile.StoreUint32(&o.PATT2.Reg, volatile.LoadUint32(&o.PATT2.Reg)&^(0xff)|value)
}
func (o *FSMC_Type) GetPATT2_ATTSET() uint32 {
	return volatile.LoadUint32(&o.PATT2.Reg) & 0xff
}

// FSMC.ECCR2: ECC result register 2
func (o *FSMC_Type) SetECCR2(value uint32) {
	volatile.StoreUint32(&o.ECCR2.Reg, value)
}
func (o *FSMC_Type) GetECCR2() uint32 {
	return volatile.LoadUint32(&o.ECCR2.Reg)
}

// FSMC.PCR3: PC Card/NAND Flash control register 2
func (o *FSMC_Type) SetPCR3_ECCPS(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0xe0000)|value<<17)
}
func (o *FSMC_Type) GetPCR3_ECCPS() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0xe0000) >> 17
}
func (o *FSMC_Type) SetPCR3_TAR(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x1e000)|value<<13)
}
func (o *FSMC_Type) GetPCR3_TAR() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x1e000) >> 13
}
func (o *FSMC_Type) SetPCR3_TCLR(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x1e00)|value<<9)
}
func (o *FSMC_Type) GetPCR3_TCLR() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x1e00) >> 9
}
func (o *FSMC_Type) SetPCR3_ECCEN(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetPCR3_ECCEN() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetPCR3_PWID(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetPCR3_PWID() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetPCR3_PTYP(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x8)|value<<3)
}
func (o *FSMC_Type) GetPCR3_PTYP() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x8) >> 3
}
func (o *FSMC_Type) SetPCR3_PBKEN(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x4)|value<<2)
}
func (o *FSMC_Type) GetPCR3_PBKEN() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x4) >> 2
}
func (o *FSMC_Type) SetPCR3_PWAITEN(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetPCR3_PWAITEN() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x2) >> 1
}

// FSMC.SR3: FIFO status and interrupt register 2
func (o *FSMC_Type) SetSR3_FEMPT(value uint32) {
	volatile.StoreUint32(&o.SR3.Reg, volatile.LoadUint32(&o.SR3.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetSR3_FEMPT() uint32 {
	return (volatile.LoadUint32(&o.SR3.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetSR3_IFEN(value uint32) {
	volatile.StoreUint32(&o.SR3.Reg, volatile.LoadUint32(&o.SR3.Reg)&^(0x20)|value<<5)
}
func (o *FSMC_Type) GetSR3_IFEN() uint32 {
	return (volatile.LoadUint32(&o.SR3.Reg) & 0x20) >> 5
}
func (o *FSMC_Type) SetSR3_ILEN(value uint32) {
	volatile.StoreUint32(&o.SR3.Reg, volatile.LoadUint32(&o.SR3.Reg)&^(0x10)|value<<4)
}
func (o *FSMC_Type) GetSR3_ILEN() uint32 {
	return (volatile.LoadUint32(&o.SR3.Reg) & 0x10) >> 4
}
func (o *FSMC_Type) SetSR3_IREN(value uint32) {
	volatile.StoreUint32(&o.SR3.Reg, volatile.LoadUint32(&o.SR3.Reg)&^(0x8)|value<<3)
}
func (o *FSMC_Type) GetSR3_IREN() uint32 {
	return (volatile.LoadUint32(&o.SR3.Reg) & 0x8) >> 3
}
func (o *FSMC_Type) SetSR3_IFS(value uint32) {
	volatile.StoreUint32(&o.SR3.Reg, volatile.LoadUint32(&o.SR3.Reg)&^(0x4)|value<<2)
}
func (o *FSMC_Type) GetSR3_IFS() uint32 {
	return (volatile.LoadUint32(&o.SR3.Reg) & 0x4) >> 2
}
func (o *FSMC_Type) SetSR3_ILS(value uint32) {
	volatile.StoreUint32(&o.SR3.Reg, volatile.LoadUint32(&o.SR3.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetSR3_ILS() uint32 {
	return (volatile.LoadUint32(&o.SR3.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetSR3_IRS(value uint32) {
	volatile.StoreUint32(&o.SR3.Reg, volatile.LoadUint32(&o.SR3.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetSR3_IRS() uint32 {
	return volatile.LoadUint32(&o.SR3.Reg) & 0x1
}

// FSMC.PMEM3: Common memory space timing register 3
func (o *FSMC_Type) SetPMEM3_MEMHIZ(value uint32) {
	volatile.StoreUint32(&o.PMEM3.Reg, volatile.LoadUint32(&o.PMEM3.Reg)&^(0xff000000)|value<<24)
}
func (o *FSMC_Type) GetPMEM3_MEMHIZ() uint32 {
	return (volatile.LoadUint32(&o.PMEM3.Reg) & 0xff000000) >> 24
}
func (o *FSMC_Type) SetPMEM3_MEMHOLD(value uint32) {
	volatile.StoreUint32(&o.PMEM3.Reg, volatile.LoadUint32(&o.PMEM3.Reg)&^(0xff0000)|value<<16)
}
func (o *FSMC_Type) GetPMEM3_MEMHOLD() uint32 {
	return (volatile.LoadUint32(&o.PMEM3.Reg) & 0xff0000) >> 16
}
func (o *FSMC_Type) SetPMEM3_MEMWAIT(value uint32) {
	volatile.StoreUint32(&o.PMEM3.Reg, volatile.LoadUint32(&o.PMEM3.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetPMEM3_MEMWAIT() uint32 {
	return (volatile.LoadUint32(&o.PMEM3.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetPMEM3_MEMSET(value uint32) {
	volatile.StoreUint32(&o.PMEM3.Reg, volatile.LoadUint32(&o.PMEM3.Reg)&^(0xff)|value)
}
func (o *FSMC_Type) GetPMEM3_MEMSET() uint32 {
	return volatile.LoadUint32(&o.PMEM3.Reg) & 0xff
}

// FSMC.PATT3: Attribute memory space timing register 3
func (o *FSMC_Type) SetPATT3_ATTHIZ(value uint32) {
	volatile.StoreUint32(&o.PATT3.Reg, volatile.LoadUint32(&o.PATT3.Reg)&^(0xff000000)|value<<24)
}
func (o *FSMC_Type) GetPATT3_ATTHIZ() uint32 {
	return (volatile.LoadUint32(&o.PATT3.Reg) & 0xff000000) >> 24
}
func (o *FSMC_Type) SetPATT3_ATTHOLD(value uint32) {
	volatile.StoreUint32(&o.PATT3.Reg, volatile.LoadUint32(&o.PATT3.Reg)&^(0xff0000)|value<<16)
}
func (o *FSMC_Type) GetPATT3_ATTHOLD() uint32 {
	return (volatile.LoadUint32(&o.PATT3.Reg) & 0xff0000) >> 16
}
func (o *FSMC_Type) SetPATT3_ATTWAIT(value uint32) {
	volatile.StoreUint32(&o.PATT3.Reg, volatile.LoadUint32(&o.PATT3.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetPATT3_ATTWAIT() uint32 {
	return (volatile.LoadUint32(&o.PATT3.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetPATT3_ATTSET(value uint32) {
	volatile.StoreUint32(&o.PATT3.Reg, volatile.LoadUint32(&o.PATT3.Reg)&^(0xff)|value)
}
func (o *FSMC_Type) GetPATT3_ATTSET() uint32 {
	return volatile.LoadUint32(&o.PATT3.Reg) & 0xff
}

// FSMC.ECCR3: ECC result register 3
func (o *FSMC_Type) SetECCR3(value uint32) {
	volatile.StoreUint32(&o.ECCR3.Reg, value)
}
func (o *FSMC_Type) GetECCR3() uint32 {
	return volatile.LoadUint32(&o.ECCR3.Reg)
}

// FSMC.PCR4: PC Card/NAND Flash control register 2
func (o *FSMC_Type) SetPCR4_ECCPS(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0xe0000)|value<<17)
}
func (o *FSMC_Type) GetPCR4_ECCPS() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0xe0000) >> 17
}
func (o *FSMC_Type) SetPCR4_TAR(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x1e000)|value<<13)
}
func (o *FSMC_Type) GetPCR4_TAR() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x1e000) >> 13
}
func (o *FSMC_Type) SetPCR4_TCLR(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x1e00)|value<<9)
}
func (o *FSMC_Type) GetPCR4_TCLR() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x1e00) >> 9
}
func (o *FSMC_Type) SetPCR4_ECCEN(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetPCR4_ECCEN() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetPCR4_PWID(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetPCR4_PWID() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetPCR4_PTYP(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x8)|value<<3)
}
func (o *FSMC_Type) GetPCR4_PTYP() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x8) >> 3
}
func (o *FSMC_Type) SetPCR4_PBKEN(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x4)|value<<2)
}
func (o *FSMC_Type) GetPCR4_PBKEN() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x4) >> 2
}
func (o *FSMC_Type) SetPCR4_PWAITEN(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetPCR4_PWAITEN() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x2) >> 1
}

// FSMC.SR4: FIFO status and interrupt register 2
func (o *FSMC_Type) SetSR4_FEMPT(value uint32) {
	volatile.StoreUint32(&o.SR4.Reg, volatile.LoadUint32(&o.SR4.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetSR4_FEMPT() uint32 {
	return (volatile.LoadUint32(&o.SR4.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetSR4_IFEN(value uint32) {
	volatile.StoreUint32(&o.SR4.Reg, volatile.LoadUint32(&o.SR4.Reg)&^(0x20)|value<<5)
}
func (o *FSMC_Type) GetSR4_IFEN() uint32 {
	return (volatile.LoadUint32(&o.SR4.Reg) & 0x20) >> 5
}
func (o *FSMC_Type) SetSR4_ILEN(value uint32) {
	volatile.StoreUint32(&o.SR4.Reg, volatile.LoadUint32(&o.SR4.Reg)&^(0x10)|value<<4)
}
func (o *FSMC_Type) GetSR4_ILEN() uint32 {
	return (volatile.LoadUint32(&o.SR4.Reg) & 0x10) >> 4
}
func (o *FSMC_Type) SetSR4_IREN(value uint32) {
	volatile.StoreUint32(&o.SR4.Reg, volatile.LoadUint32(&o.SR4.Reg)&^(0x8)|value<<3)
}
func (o *FSMC_Type) GetSR4_IREN() uint32 {
	return (volatile.LoadUint32(&o.SR4.Reg) & 0x8) >> 3
}
func (o *FSMC_Type) SetSR4_IFS(value uint32) {
	volatile.StoreUint32(&o.SR4.Reg, volatile.LoadUint32(&o.SR4.Reg)&^(0x4)|value<<2)
}
func (o *FSMC_Type) GetSR4_IFS() uint32 {
	return (volatile.LoadUint32(&o.SR4.Reg) & 0x4) >> 2
}
func (o *FSMC_Type) SetSR4_ILS(value uint32) {
	volatile.StoreUint32(&o.SR4.Reg, volatile.LoadUint32(&o.SR4.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetSR4_ILS() uint32 {
	return (volatile.LoadUint32(&o.SR4.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetSR4_IRS(value uint32) {
	volatile.StoreUint32(&o.SR4.Reg, volatile.LoadUint32(&o.SR4.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetSR4_IRS() uint32 {
	return volatile.LoadUint32(&o.SR4.Reg) & 0x1
}

// FSMC.PMEM4: Common memory space timing register 4
func (o *FSMC_Type) SetPMEM4_MEMHIZ(value uint32) {
	volatile.StoreUint32(&o.PMEM4.Reg, volatile.LoadUint32(&o.PMEM4.Reg)&^(0xff000000)|value<<24)
}
func (o *FSMC_Type) GetPMEM4_MEMHIZ() uint32 {
	return (volatile.LoadUint32(&o.PMEM4.Reg) & 0xff000000) >> 24
}
func (o *FSMC_Type) SetPMEM4_MEMHOLD(value uint32) {
	volatile.StoreUint32(&o.PMEM4.Reg, volatile.LoadUint32(&o.PMEM4.Reg)&^(0xff0000)|value<<16)
}
func (o *FSMC_Type) GetPMEM4_MEMHOLD() uint32 {
	return (volatile.LoadUint32(&o.PMEM4.Reg) & 0xff0000) >> 16
}
func (o *FSMC_Type) SetPMEM4_MEMWAIT(value uint32) {
	volatile.StoreUint32(&o.PMEM4.Reg, volatile.LoadUint32(&o.PMEM4.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetPMEM4_MEMWAIT() uint32 {
	return (volatile.LoadUint32(&o.PMEM4.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetPMEM4_MEMSET(value uint32) {
	volatile.StoreUint32(&o.PMEM4.Reg, volatile.LoadUint32(&o.PMEM4.Reg)&^(0xff)|value)
}
func (o *FSMC_Type) GetPMEM4_MEMSET() uint32 {
	return volatile.LoadUint32(&o.PMEM4.Reg) & 0xff
}

// FSMC.PATT4: Attribute memory space timing register 4
func (o *FSMC_Type) SetPATT4_ATTHIZ(value uint32) {
	volatile.StoreUint32(&o.PATT4.Reg, volatile.LoadUint32(&o.PATT4.Reg)&^(0xff000000)|value<<24)
}
func (o *FSMC_Type) GetPATT4_ATTHIZ() uint32 {
	return (volatile.LoadUint32(&o.PATT4.Reg) & 0xff000000) >> 24
}
func (o *FSMC_Type) SetPATT4_ATTHOLD(value uint32) {
	volatile.StoreUint32(&o.PATT4.Reg, volatile.LoadUint32(&o.PATT4.Reg)&^(0xff0000)|value<<16)
}
func (o *FSMC_Type) GetPATT4_ATTHOLD() uint32 {
	return (volatile.LoadUint32(&o.PATT4.Reg) & 0xff0000) >> 16
}
func (o *FSMC_Type) SetPATT4_ATTWAIT(value uint32) {
	volatile.StoreUint32(&o.PATT4.Reg, volatile.LoadUint32(&o.PATT4.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetPATT4_ATTWAIT() uint32 {
	return (volatile.LoadUint32(&o.PATT4.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetPATT4_ATTSET(value uint32) {
	volatile.StoreUint32(&o.PATT4.Reg, volatile.LoadUint32(&o.PATT4.Reg)&^(0xff)|value)
}
func (o *FSMC_Type) GetPATT4_ATTSET() uint32 {
	return volatile.LoadUint32(&o.PATT4.Reg) & 0xff
}

// FSMC.PIO4: I/O space timing register 4
func (o *FSMC_Type) SetPIO4_IOHIZx(value uint32) {
	volatile.StoreUint32(&o.PIO4.Reg, volatile.LoadUint32(&o.PIO4.Reg)&^(0xff000000)|value<<24)
}
func (o *FSMC_Type) GetPIO4_IOHIZx() uint32 {
	return (volatile.LoadUint32(&o.PIO4.Reg) & 0xff000000) >> 24
}
func (o *FSMC_Type) SetPIO4_IOHOLDx(value uint32) {
	volatile.StoreUint32(&o.PIO4.Reg, volatile.LoadUint32(&o.PIO4.Reg)&^(0xff0000)|value<<16)
}
func (o *FSMC_Type) GetPIO4_IOHOLDx() uint32 {
	return (volatile.LoadUint32(&o.PIO4.Reg) & 0xff0000) >> 16
}
func (o *FSMC_Type) SetPIO4_IOWAITx(value uint32) {
	volatile.StoreUint32(&o.PIO4.Reg, volatile.LoadUint32(&o.PIO4.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetPIO4_IOWAITx() uint32 {
	return (volatile.LoadUint32(&o.PIO4.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetPIO4_IOSETx(value uint32) {
	volatile.StoreUint32(&o.PIO4.Reg, volatile.LoadUint32(&o.PIO4.Reg)&^(0xff)|value)
}
func (o *FSMC_Type) GetPIO4_IOSETx() uint32 {
	return volatile.LoadUint32(&o.PIO4.Reg) & 0xff
}

// FSMC.BWTR1: SRAM/NOR-Flash write timing registers 1
func (o *FSMC_Type) SetBWTR1_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR1_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR1_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBWTR1_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBWTR1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBWTR1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBWTR1_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR1_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR1_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR1_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR1_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR1_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR1.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR1_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR1_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf0000) >> 16
}

// FSMC.BWTR2: SRAM/NOR-Flash write timing registers 1
func (o *FSMC_Type) SetBWTR2_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR2_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR2_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBWTR2_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBWTR2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBWTR2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBWTR2_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR2_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR2_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR2_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR2_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR2_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR2.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR2_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR2_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf0000) >> 16
}

// FSMC.BWTR3: SRAM/NOR-Flash write timing registers 1
func (o *FSMC_Type) SetBWTR3_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR3_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR3_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBWTR3_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBWTR3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBWTR3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBWTR3_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR3_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR3_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR3_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR3_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR3_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR3.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR3_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR3_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf0000) >> 16
}

// FSMC.BWTR4: SRAM/NOR-Flash write timing registers 1
func (o *FSMC_Type) SetBWTR4_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR4_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR4_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBWTR4_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBWTR4_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBWTR4_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBWTR4_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR4_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR4_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR4_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR4_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR4_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR4.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR4_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR4_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf0000) >> 16
}

// Debug support
type DBG_Type struct {
	IDCODE  volatile.Register32 // 0x0
	CR      volatile.Register32 // 0x4
	APB1_FZ volatile.Register32 // 0x8
	APB2_FZ volatile.Register32 // 0xC
}

// DBG.IDCODE: IDCODE
func (o *DBG_Type) SetIDCODE_DEV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xfff)|value)
}
func (o *DBG_Type) GetIDCODE_DEV_ID() uint32 {
	return volatile.LoadUint32(&o.IDCODE.Reg) & 0xfff
}
func (o *DBG_Type) SetIDCODE_REV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xffff0000)|value<<16)
}
func (o *DBG_Type) GetIDCODE_REV_ID() uint32 {
	return (volatile.LoadUint32(&o.IDCODE.Reg) & 0xffff0000) >> 16
}

// DBG.CR: Control Register
func (o *DBG_Type) SetCR_DBG_SLEEP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetCR_DBG_SLEEP() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DBG_Type) SetCR_DBG_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetCR_DBG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetCR_DBG_STANDBY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBG_Type) GetCR_DBG_STANDBY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DBG_Type) SetCR_TRACE_IOEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DBG_Type) GetCR_TRACE_IOEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DBG_Type) SetCR_TRACE_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DBG_Type) GetCR_TRACE_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}

// DBG.APB1_FZ: Debug MCU APB1 Freeze registe
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM2_STOP() uint32 {
	return volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x1
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM3_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM3_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM4_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x4)|value<<2)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM4_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x4) >> 2
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM5_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x8)|value<<3)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM5_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x8) >> 3
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM6_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x10)|value<<4)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM6_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x10) >> 4
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM7_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x20)|value<<5)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM7_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x20) >> 5
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM12_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x40)|value<<6)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM12_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x40) >> 6
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM13_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x80)|value<<7)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM13_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x80) >> 7
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM14_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x100)|value<<8)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM14_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x100) >> 8
}
func (o *DBG_Type) SetAPB1_FZ_DBG_RTC_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x400)|value<<10)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_RTC_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x400) >> 10
}
func (o *DBG_Type) SetAPB1_FZ_DBG_WWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x800)|value<<11)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_WWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x800) >> 11
}
func (o *DBG_Type) SetAPB1_FZ_DBG_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x1000)|value<<12)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x1000) >> 12
}
func (o *DBG_Type) SetAPB1_FZ_DBG_J2C1_SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x200000)|value<<21)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_J2C1_SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x200000) >> 21
}
func (o *DBG_Type) SetAPB1_FZ_DBG_J2C2_SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x400000)|value<<22)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_J2C2_SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x400000) >> 22
}
func (o *DBG_Type) SetAPB1_FZ_DBG_J2C3SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x800000)|value<<23)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_J2C3SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x800000) >> 23
}
func (o *DBG_Type) SetAPB1_FZ_DBG_CAN1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x2000000)|value<<25)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_CAN1_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x2000000) >> 25
}
func (o *DBG_Type) SetAPB1_FZ_DBG_CAN2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x4000000)|value<<26)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_CAN2_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x4000000) >> 26
}

// DBG.APB2_FZ: Debug MCU APB2 Freeze registe
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM1_STOP() uint32 {
	return volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x1
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM8_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM8_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM9_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x10000)|value<<16)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM9_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x10000) >> 16
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM10_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x20000)|value<<17)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM10_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x20000) >> 17
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM11_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x40000)|value<<18)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM11_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x40000) >> 18
}

// DMA controller
type DMA_Type struct {
	LISR  volatile.Register32 // 0x0
	HISR  volatile.Register32 // 0x4
	LIFCR volatile.Register32 // 0x8
	HIFCR volatile.Register32 // 0xC
	ST    [8]DMA_ST_Type      // 0x10
}

// DMA.LISR: low interrupt status register
func (o *DMA_Type) SetLISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetLISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetLISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetLISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetLISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetLISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetLISR_DMEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetLISR_DMEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetLISR_FEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetLISR_FEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetLISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetLISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetLISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetLISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetLISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetLISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetLISR_DMEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetLISR_DMEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetLISR_FEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetLISR_FEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetLISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetLISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetLISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetLISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetLISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetLISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetLISR_DMEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetLISR_DMEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetLISR_FEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetLISR_FEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetLISR_TCIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetLISR_TCIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetLISR_HTIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetLISR_HTIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetLISR_TEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetLISR_TEIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetLISR_DMEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetLISR_DMEIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetLISR_FEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetLISR_FEIF0() uint32 {
	return volatile.LoadUint32(&o.LISR.Reg) & 0x1
}

// DMA.HISR: high interrupt status register
func (o *DMA_Type) SetHISR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetHISR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetHISR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetHISR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetHISR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetHISR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetHISR_DMEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetHISR_DMEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetHISR_FEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetHISR_FEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetHISR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetHISR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetHISR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetHISR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetHISR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetHISR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetHISR_DMEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetHISR_DMEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetHISR_FEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetHISR_FEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetHISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetHISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetHISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetHISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetHISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetHISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetHISR_DMEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetHISR_DMEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetHISR_FEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetHISR_FEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetHISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetHISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetHISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetHISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetHISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetHISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetHISR_DMEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetHISR_DMEIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetHISR_FEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetHISR_FEIF4() uint32 {
	return volatile.LoadUint32(&o.HISR.Reg) & 0x1
}

// DMA.LIFCR: low interrupt flag clear register
func (o *DMA_Type) SetLIFCR_CTCIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetLIFCR_CTCIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetLIFCR_CHTIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetLIFCR_CHTIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetLIFCR_CTEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetLIFCR_CTEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetLIFCR_CDMEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetLIFCR_CDMEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetLIFCR_CFEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetLIFCR_CFEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetLIFCR_CTCIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetLIFCR_CTCIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetLIFCR_CHTIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetLIFCR_CHTIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetLIFCR_CTEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetLIFCR_CTEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetLIFCR_CDMEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetLIFCR_CDMEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetLIFCR_CFEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetLIFCR_CFEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetLIFCR_CTCIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetLIFCR_CTCIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetLIFCR_CHTIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetLIFCR_CHTIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetLIFCR_CTEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetLIFCR_CTEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetLIFCR_CDMEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetLIFCR_CDMEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetLIFCR_CFEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetLIFCR_CFEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetLIFCR_CTCIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetLIFCR_CTCIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetLIFCR_CHTIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetLIFCR_CHTIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetLIFCR_CTEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetLIFCR_CTEIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetLIFCR_CDMEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetLIFCR_CDMEIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetLIFCR_CFEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetLIFCR_CFEIF0() uint32 {
	return volatile.LoadUint32(&o.LIFCR.Reg) & 0x1
}

// DMA.HIFCR: high interrupt flag clear register
func (o *DMA_Type) SetHIFCR_CTCIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetHIFCR_CTCIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetHIFCR_CHTIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetHIFCR_CHTIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetHIFCR_CTEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetHIFCR_CTEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetHIFCR_CDMEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetHIFCR_CDMEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetHIFCR_CFEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetHIFCR_CFEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetHIFCR_CTCIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetHIFCR_CTCIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetHIFCR_CHTIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetHIFCR_CHTIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetHIFCR_CTEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetHIFCR_CTEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetHIFCR_CDMEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetHIFCR_CDMEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetHIFCR_CFEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetHIFCR_CFEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetHIFCR_CTCIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetHIFCR_CTCIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetHIFCR_CHTIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetHIFCR_CHTIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetHIFCR_CTEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetHIFCR_CTEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetHIFCR_CDMEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetHIFCR_CDMEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetHIFCR_CFEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetHIFCR_CFEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetHIFCR_CTCIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetHIFCR_CTCIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetHIFCR_CHTIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetHIFCR_CHTIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetHIFCR_CTEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetHIFCR_CTEIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetHIFCR_CDMEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetHIFCR_CDMEIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetHIFCR_CFEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetHIFCR_CFEIF4() uint32 {
	return volatile.LoadUint32(&o.HIFCR.Reg) & 0x1
}

type DMA_ST_Type struct {
	CR   volatile.Register32 // 0x10
	NDTR volatile.Register32 // 0x14
	PAR  volatile.Register32 // 0x18
	M0AR volatile.Register32 // 0x1C
	M1AR volatile.Register32 // 0x20
	FCR  volatile.Register32 // 0x24
}

// DMA_ST.CR: stream x configuration register
func (o *DMA_ST_Type) SetCR_CHSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xe000000)|value<<25)
}
func (o *DMA_ST_Type) GetCR_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xe000000) >> 25
}
func (o *DMA_ST_Type) SetCR_MBURST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1800000)|value<<23)
}
func (o *DMA_ST_Type) GetCR_MBURST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1800000) >> 23
}
func (o *DMA_ST_Type) SetCR_PBURST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *DMA_ST_Type) GetCR_PBURST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *DMA_ST_Type) SetCR_CT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_ST_Type) GetCR_CT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *DMA_ST_Type) SetCR_DBM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_ST_Type) GetCR_DBM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *DMA_ST_Type) SetCR_PL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_ST_Type) GetCR_PL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000) >> 16
}
func (o *DMA_ST_Type) SetCR_PINCOS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_ST_Type) GetCR_PINCOS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *DMA_ST_Type) SetCR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_ST_Type) GetCR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x6000) >> 13
}
func (o *DMA_ST_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1800)|value<<11)
}
func (o *DMA_ST_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1800) >> 11
}
func (o *DMA_ST_Type) SetCR_MINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_ST_Type) GetCR_MINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *DMA_ST_Type) SetCR_PINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_ST_Type) GetCR_PINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *DMA_ST_Type) SetCR_CIRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_ST_Type) GetCR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *DMA_ST_Type) SetCR_DIR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_ST_Type) GetCR_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *DMA_ST_Type) SetCR_PFCTRL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_ST_Type) GetCR_PFCTRL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DMA_ST_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_ST_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DMA_ST_Type) SetCR_HTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_ST_Type) GetCR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DMA_ST_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_ST_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA_ST_Type) SetCR_DMEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_ST_Type) GetCR_DMEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA_ST_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DMA_ST_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DMA_ST.NDTR: stream x number of data register
func (o *DMA_ST_Type) SetNDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.NDTR.Reg, volatile.LoadUint32(&o.NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA_ST_Type) GetNDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.NDTR.Reg) & 0xffff
}

// DMA_ST.PAR: stream x peripheral address register
func (o *DMA_ST_Type) SetPAR(value uint32) {
	volatile.StoreUint32(&o.PAR.Reg, value)
}
func (o *DMA_ST_Type) GetPAR() uint32 {
	return volatile.LoadUint32(&o.PAR.Reg)
}

// DMA_ST.M0AR: stream x memory 0 address register
func (o *DMA_ST_Type) SetM0AR(value uint32) {
	volatile.StoreUint32(&o.M0AR.Reg, value)
}
func (o *DMA_ST_Type) GetM0AR() uint32 {
	return volatile.LoadUint32(&o.M0AR.Reg)
}

// DMA_ST.M1AR: stream x memory 1 address register
func (o *DMA_ST_Type) SetM1AR(value uint32) {
	volatile.StoreUint32(&o.M1AR.Reg, value)
}
func (o *DMA_ST_Type) GetM1AR() uint32 {
	return volatile.LoadUint32(&o.M1AR.Reg)
}

// DMA_ST.FCR: stream x FIFO control register
func (o *DMA_ST_Type) SetFCR_FEIE(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_ST_Type) GetFCR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x80) >> 7
}
func (o *DMA_ST_Type) SetFCR_FS(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x38)|value<<3)
}
func (o *DMA_ST_Type) GetFCR_FS() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x38) >> 3
}
func (o *DMA_ST_Type) SetFCR_DMDIS(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_ST_Type) GetFCR_DMDIS() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x4) >> 2
}
func (o *DMA_ST_Type) SetFCR_FTH(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x3)|value)
}
func (o *DMA_ST_Type) GetFCR_FTH() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0x3
}

// Reset and clock control
type RCC_Type struct {
	CR         volatile.Register32 // 0x0
	PLLCFGR    volatile.Register32 // 0x4
	CFGR       volatile.Register32 // 0x8
	CIR        volatile.Register32 // 0xC
	AHB1RSTR   volatile.Register32 // 0x10
	AHB2RSTR   volatile.Register32 // 0x14
	AHB3RSTR   volatile.Register32 // 0x18
	_          [4]byte
	APB1RSTR   volatile.Register32 // 0x20
	APB2RSTR   volatile.Register32 // 0x24
	_          [8]byte
	AHB1ENR    volatile.Register32 // 0x30
	AHB2ENR    volatile.Register32 // 0x34
	AHB3ENR    volatile.Register32 // 0x38
	_          [4]byte
	APB1ENR    volatile.Register32 // 0x40
	APB2ENR    volatile.Register32 // 0x44
	_          [8]byte
	AHB1LPENR  volatile.Register32 // 0x50
	AHB2LPENR  volatile.Register32 // 0x54
	AHB3LPENR  volatile.Register32 // 0x58
	_          [4]byte
	APB1LPENR  volatile.Register32 // 0x60
	APB2LPENR  volatile.Register32 // 0x64
	_          [8]byte
	BDCR       volatile.Register32 // 0x70
	CSR        volatile.Register32 // 0x74
	_          [8]byte
	SSCGR      volatile.Register32 // 0x80
	PLLI2SCFGR volatile.Register32 // 0x84
}

// RCC.CR: clock control register
func (o *RCC_Type) SetCR_PLLI2SRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCR_PLLI2SRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCR_PLLI2SON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCR_PLLI2SON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCR_PLLRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCR_PLLRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCR_PLLON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCR_PLLON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCR_CSSON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCR_CSSON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCR_HSEBYP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCR_HSEBYP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCR_HSERDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCR_HSERDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCR_HSEON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCR_HSEON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCR_HSICAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff00)|value<<8)
}
func (o *RCC_Type) GetCR_HSICAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff00) >> 8
}
func (o *RCC_Type) SetCR_HSITRIM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf8)|value<<3)
}
func (o *RCC_Type) GetCR_HSITRIM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf8) >> 3
}
func (o *RCC_Type) SetCR_HSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCR_HSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCR_HSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCR_HSION() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// RCC.PLLCFGR: PLL configuration register
func (o *RCC_Type) SetPLLCFGR_PLLSRC(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetPLLCFGR_PLLSRC() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetPLLCFGR_PLLM(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x3f)|value)
}
func (o *RCC_Type) GetPLLCFGR_PLLM() uint32 {
	return volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x3f
}
func (o *RCC_Type) SetPLLCFGR_PLLN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x7fc0)|value<<6)
}
func (o *RCC_Type) GetPLLCFGR_PLLN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x7fc0) >> 6
}
func (o *RCC_Type) SetPLLCFGR_PLLP(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetPLLCFGR_PLLP() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x30000) >> 16
}
func (o *RCC_Type) SetPLLCFGR_PLLQ(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xf000000)|value<<24)
}
func (o *RCC_Type) GetPLLCFGR_PLLQ() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xf000000) >> 24
}

// RCC.CFGR: clock configuration register
func (o *RCC_Type) SetCFGR_I2SSRC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCFGR_I2SSRC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCFGR_MCO1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x600000)|value<<21)
}
func (o *RCC_Type) GetCFGR_MCO1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x600000) >> 21
}
func (o *RCC_Type) SetCFGR_MCO1PRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7000000)|value<<24)
}
func (o *RCC_Type) GetCFGR_MCO1PRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7000000) >> 24
}
func (o *RCC_Type) SetCFGR_MCO2PRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x38000000)|value<<27)
}
func (o *RCC_Type) GetCFGR_MCO2PRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x38000000) >> 27
}
func (o *RCC_Type) SetCFGR_MCO2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc0000000)|value<<30)
}
func (o *RCC_Type) GetCFGR_MCO2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc0000000) >> 30
}
func (o *RCC_Type) SetCFGR_RTCPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1f0000)|value<<16)
}
func (o *RCC_Type) GetCFGR_RTCPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1f0000) >> 16
}
func (o *RCC_Type) SetCFGR_PPRE2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe000)|value<<13)
}
func (o *RCC_Type) GetCFGR_PPRE2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe000) >> 13
}
func (o *RCC_Type) SetCFGR_PPRE1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1c00)|value<<10)
}
func (o *RCC_Type) GetCFGR_PPRE1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1c00) >> 10
}
func (o *RCC_Type) SetCFGR_HPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetCFGR_HPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetCFGR_SW(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCFGR_SW() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x3
}
func (o *RCC_Type) SetCFGR_SWS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetCFGR_SWS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc) >> 2
}

// RCC.CIR: clock interrupt register
func (o *RCC_Type) SetCIR_CSSC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCIR_CSSC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCIR_PLLI2SRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetCIR_PLLI2SRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetCIR_PLLRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetCIR_PLLRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetCIR_HSERDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCIR_HSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCIR_HSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCIR_HSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCIR_LSERDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCIR_LSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCIR_LSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCIR_LSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCIR_PLLI2SRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetCIR_PLLI2SRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetCIR_PLLRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetCIR_PLLRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetCIR_HSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetCIR_HSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetCIR_HSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCIR_HSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCIR_LSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIR_LSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCIR_LSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCIR_LSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCIR_CSSF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetCIR_CSSF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetCIR_PLLI2SRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIR_PLLI2SRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIR_PLLRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIR_PLLRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIR_HSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIR_HSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIR_HSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCIR_HSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCIR_LSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIR_LSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIR_LSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIR_LSIRDYF() uint32 {
	return volatile.LoadUint32(&o.CIR.Reg) & 0x1
}

// RCC.AHB1RSTR: AHB1 peripheral reset register
func (o *RCC_Type) SetAHB1RSTR_OTGHSRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAHB1RSTR_OTGHSRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAHB1RSTR_ETHMACRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB1RSTR_ETHMACRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHB1RSTR_DMA2RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHB1RSTR_DMA2RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAHB1RSTR_DMA1RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB1RSTR_DMA1RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB1RSTR_CRCRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1RSTR_CRCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1RSTR_GPIOIRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOIRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB1RSTR_GPIOHRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOHRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB1RSTR_GPIOGRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB1RSTR_GPIOFRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOFRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB1RSTR_GPIOERST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOERST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1RSTR_GPIODRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1RSTR_GPIODRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1RSTR_GPIOCRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1RSTR_GPIOBRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOBRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1RSTR_GPIOARST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOARST() uint32 {
	return volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1
}

// RCC.AHB2RSTR: AHB2 peripheral reset register
func (o *RCC_Type) SetAHB2RSTR_OTGFSRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2RSTR_OTGFSRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2RSTR_RNGRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2RSTR_RNGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2RSTR_HSAHRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB2RSTR_HSAHRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB2RSTR_CRYPRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2RSTR_CRYPRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2RSTR_DCMIRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2RSTR_DCMIRST() uint32 {
	return volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x1
}

// RCC.AHB3RSTR: AHB3 peripheral reset register
func (o *RCC_Type) SetAHB3RSTR_FSMCRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3RSTR_FSMCRST() uint32 {
	return volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x1
}

// RCC.APB1RSTR: APB1 peripheral reset register
func (o *RCC_Type) SetAPB1RSTR_DACRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1RSTR_DACRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1RSTR_PWRRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1RSTR_PWRRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1RSTR_CAN2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB1RSTR_CAN2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPB1RSTR_CAN1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1RSTR_CAN1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1RSTR_I2C3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1RSTR_I2C3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1RSTR_I2C2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1RSTR_I2C2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1RSTR_I2C1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1RSTR_I2C1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1RSTR_UART5RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1RSTR_UART5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1RSTR_UART4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1RSTR_UART4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1RSTR_USART3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1RSTR_USART3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1RSTR_USART2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1RSTR_USART2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1RSTR_SPI3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1RSTR_SPI3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1RSTR_SPI2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1RSTR_SPI2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1RSTR_WWDGRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1RSTR_WWDGRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1RSTR_TIM14RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1RSTR_TIM14RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1RSTR_TIM13RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB1RSTR_TIM13RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB1RSTR_TIM12RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1RSTR_TIM12RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1RSTR_TIM7RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1RSTR_TIM7RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1RSTR_TIM6RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1RSTR_TIM6RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1RSTR_TIM5RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1RSTR_TIM5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1RSTR_TIM4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1RSTR_TIM4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1RSTR_TIM3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1RSTR_TIM3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1RSTR_TIM2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1RSTR_TIM2RST() uint32 {
	return volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x1
}

// RCC.APB2RSTR: APB2 peripheral reset register
func (o *RCC_Type) SetAPB2RSTR_TIM11RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2RSTR_TIM11RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2RSTR_TIM10RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2RSTR_TIM10RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2RSTR_TIM9RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2RSTR_TIM9RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2RSTR_SYSCFGRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2RSTR_SYSCFGRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2RSTR_SPI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2RSTR_SPI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2RSTR_SDIORST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2RSTR_SDIORST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2RSTR_ADCRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB2RSTR_ADCRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB2RSTR_USART6RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2RSTR_USART6RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2RSTR_USART1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2RSTR_USART1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2RSTR_TIM8RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB2RSTR_TIM8RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB2RSTR_TIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2RSTR_TIM1RST() uint32 {
	return volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1
}

// RCC.AHB1ENR: AHB1 peripheral clock register
func (o *RCC_Type) SetAHB1ENR_OTGHSULPIEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAHB1ENR_OTGHSULPIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAHB1ENR_OTGHSEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAHB1ENR_OTGHSEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAHB1ENR_ETHMACPTPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAHB1ENR_ETHMACPTPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAHB1ENR_ETHMACRXEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAHB1ENR_ETHMACRXEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAHB1ENR_ETHMACTXEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAHB1ENR_ETHMACTXEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAHB1ENR_ETHMACEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB1ENR_ETHMACEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHB1ENR_DMA2EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHB1ENR_DMA2EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAHB1ENR_DMA1EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB1ENR_DMA1EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB1ENR_BKPSRAMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB1ENR_BKPSRAMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB1ENR_CRCEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1ENR_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1ENR_GPIOIEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB1ENR_GPIOIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB1ENR_GPIOHEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB1ENR_GPIOHEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB1ENR_GPIOGEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB1ENR_GPIOGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB1ENR_GPIOFEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB1ENR_GPIOFEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB1ENR_GPIOEEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1ENR_GPIOEEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1ENR_GPIODEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1ENR_GPIODEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1ENR_GPIOCEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1ENR_GPIOCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1ENR_GPIOBEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1ENR_GPIOBEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1ENR_GPIOAEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1ENR_GPIOAEN() uint32 {
	return volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1
}

// RCC.AHB2ENR: AHB2 peripheral clock enable register
func (o *RCC_Type) SetAHB2ENR_OTGFSEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2ENR_OTGFSEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2ENR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2ENR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2ENR_HASHEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB2ENR_HASHEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB2ENR_CRYPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2ENR_CRYPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2ENR_DCMIEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2ENR_DCMIEN() uint32 {
	return volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x1
}

// RCC.AHB3ENR: AHB3 peripheral clock enable register
func (o *RCC_Type) SetAHB3ENR_FSMCEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3ENR_FSMCEN() uint32 {
	return volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x1
}

// RCC.APB1ENR: APB1 peripheral clock enable register
func (o *RCC_Type) SetAPB1ENR_DACEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1ENR_DACEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1ENR_PWREN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1ENR_PWREN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1ENR_CAN2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB1ENR_CAN2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPB1ENR_CAN1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1ENR_CAN1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1ENR_I2C3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1ENR_I2C3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1ENR_I2C2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1ENR_I2C2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1ENR_I2C1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1ENR_I2C1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1ENR_UART5EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1ENR_UART5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1ENR_UART4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1ENR_UART4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1ENR_USART3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1ENR_USART3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1ENR_USART2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1ENR_USART2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1ENR_SPI3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1ENR_SPI3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1ENR_SPI2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1ENR_SPI2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1ENR_WWDGEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1ENR_WWDGEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1ENR_TIM14EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1ENR_TIM14EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1ENR_TIM13EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB1ENR_TIM13EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB1ENR_TIM12EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1ENR_TIM12EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1ENR_TIM7EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1ENR_TIM7EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1ENR_TIM6EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1ENR_TIM6EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1ENR_TIM5EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1ENR_TIM5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1ENR_TIM4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1ENR_TIM4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1ENR_TIM3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1ENR_TIM3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1ENR_TIM2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1ENR_TIM2EN() uint32 {
	return volatile.LoadUint32(&o.APB1ENR.Reg) & 0x1
}

// RCC.APB2ENR: APB2 peripheral clock enable register
func (o *RCC_Type) SetAPB2ENR_TIM11EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2ENR_TIM11EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2ENR_TIM10EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2ENR_TIM10EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2ENR_TIM9EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2ENR_TIM9EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2ENR_SYSCFGEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2ENR_SYSCFGEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2ENR_SPI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2ENR_SPI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2ENR_SDIOEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2ENR_SDIOEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2ENR_ADC3EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB2ENR_ADC3EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB2ENR_ADC2EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB2ENR_ADC2EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB2ENR_ADC1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB2ENR_ADC1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB2ENR_USART6EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2ENR_USART6EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2ENR_USART1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2ENR_USART1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2ENR_TIM8EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB2ENR_TIM8EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB2ENR_TIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2ENR_TIM1EN() uint32 {
	return volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1
}

// RCC.AHB1LPENR: AHB1 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAHB1LPENR_OTGHSULPILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAHB1LPENR_OTGHSULPILPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAHB1LPENR_OTGHSLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAHB1LPENR_OTGHSLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAHB1LPENR_ETHMACPTPLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAHB1LPENR_ETHMACPTPLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAHB1LPENR_ETHMACRXLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAHB1LPENR_ETHMACRXLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAHB1LPENR_ETHMACTXLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAHB1LPENR_ETHMACTXLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAHB1LPENR_ETHMACLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB1LPENR_ETHMACLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHB1LPENR_DMA2LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHB1LPENR_DMA2LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAHB1LPENR_DMA1LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB1LPENR_DMA1LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB1LPENR_BKPSRAMLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB1LPENR_BKPSRAMLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB1LPENR_SRAM2LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB1LPENR_SRAM2LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAHB1LPENR_SRAM1LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB1LPENR_SRAM1LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB1LPENR_FLITFLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAHB1LPENR_FLITFLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAHB1LPENR_CRCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1LPENR_CRCLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1LPENR_GPIOILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOILPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB1LPENR_GPIOHLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOHLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB1LPENR_GPIOGLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOGLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB1LPENR_GPIOFLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOFLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB1LPENR_GPIOELPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOELPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1LPENR_GPIODLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1LPENR_GPIODLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1LPENR_GPIOCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOCLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1LPENR_GPIOBLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOBLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1LPENR_GPIOALPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOALPEN() uint32 {
	return volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x1
}

// RCC.AHB2LPENR: AHB2 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAHB2LPENR_OTGFSLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2LPENR_OTGFSLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2LPENR_RNGLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2LPENR_RNGLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2LPENR_HASHLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB2LPENR_HASHLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB2LPENR_CRYPLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2LPENR_CRYPLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2LPENR_DCMILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2LPENR_DCMILPEN() uint32 {
	return volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x1
}

// RCC.AHB3LPENR: AHB3 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAHB3LPENR_FSMCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3LPENR_FSMCLPEN() uint32 {
	return volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x1
}

// RCC.APB1LPENR: APB1 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAPB1LPENR_DACLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1LPENR_DACLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1LPENR_PWRLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1LPENR_PWRLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1LPENR_CAN2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB1LPENR_CAN2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPB1LPENR_CAN1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1LPENR_CAN1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1LPENR_I2C3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1LPENR_I2C3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1LPENR_I2C2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1LPENR_I2C2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1LPENR_I2C1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1LPENR_I2C1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1LPENR_UART5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1LPENR_UART5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1LPENR_UART4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1LPENR_UART4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1LPENR_USART3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1LPENR_USART3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1LPENR_USART2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1LPENR_USART2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1LPENR_SPI3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1LPENR_SPI3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1LPENR_SPI2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1LPENR_SPI2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1LPENR_WWDGLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1LPENR_WWDGLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1LPENR_TIM14LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1LPENR_TIM14LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1LPENR_TIM13LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB1LPENR_TIM13LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB1LPENR_TIM12LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1LPENR_TIM12LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1LPENR_TIM7LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1LPENR_TIM7LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1LPENR_TIM6LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1LPENR_TIM6LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1LPENR_TIM5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1LPENR_TIM5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1LPENR_TIM4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1LPENR_TIM4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1LPENR_TIM3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1LPENR_TIM3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1LPENR_TIM2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1LPENR_TIM2LPEN() uint32 {
	return volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x1
}

// RCC.APB2LPENR: APB2 peripheral clock enabled in low power mode register
func (o *RCC_Type) SetAPB2LPENR_TIM11LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2LPENR_TIM11LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2LPENR_TIM10LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2LPENR_TIM10LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2LPENR_TIM9LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2LPENR_TIM9LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2LPENR_SYSCFGLPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2LPENR_SYSCFGLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2LPENR_SPI1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2LPENR_SPI1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2LPENR_SDIOLPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2LPENR_SDIOLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2LPENR_ADC3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB2LPENR_ADC3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB2LPENR_ADC2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB2LPENR_ADC2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB2LPENR_ADC1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB2LPENR_ADC1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB2LPENR_USART6LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2LPENR_USART6LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2LPENR_USART1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2LPENR_USART1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2LPENR_TIM8LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB2LPENR_TIM8LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB2LPENR_TIM1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2LPENR_TIM1LPEN() uint32 {
	return volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x1
}

// RCC.BDCR: Backup domain control register
func (o *RCC_Type) SetBDCR_BDRST(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetBDCR_BDRST() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetBDCR_RTCEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetBDCR_RTCEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetBDCR_LSEBYP(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetBDCR_LSEBYP() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetBDCR_LSERDY(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetBDCR_LSERDY() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetBDCR_LSEON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetBDCR_LSEON() uint32 {
	return volatile.LoadUint32(&o.BDCR.Reg) & 0x1
}
func (o *RCC_Type) SetBDCR_RTCSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetBDCR_RTCSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x300) >> 8
}

// RCC.CSR: clock control & status register
func (o *RCC_Type) SetCSR_LPWRRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetCSR_LPWRRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetCSR_WWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetCSR_WWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetCSR_WDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCSR_WDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetCSR_SFTRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCSR_SFTRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetCSR_PORRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCSR_PORRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCSR_PADRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCSR_PADRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCSR_BORRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCSR_BORRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCSR_RMVF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCSR_RMVF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCSR_LSIRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCSR_LSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCSR_LSION(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCSR_LSION() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}

// RCC.SSCGR: spread spectrum clock generation register
func (o *RCC_Type) SetSSCGR_SSCGEN(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetSSCGR_SSCGEN() uint32 {
	return (volatile.LoadUint32(&o.SSCGR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetSSCGR_SPREADSEL(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetSSCGR_SPREADSEL() uint32 {
	return (volatile.LoadUint32(&o.SSCGR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetSSCGR_INCSTEP(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0xfffe000)|value<<13)
}
func (o *RCC_Type) GetSSCGR_INCSTEP() uint32 {
	return (volatile.LoadUint32(&o.SSCGR.Reg) & 0xfffe000) >> 13
}
func (o *RCC_Type) SetSSCGR_MODPER(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0x1fff)|value)
}
func (o *RCC_Type) GetSSCGR_MODPER() uint32 {
	return volatile.LoadUint32(&o.SSCGR.Reg) & 0x1fff
}

// RCC.PLLI2SCFGR: PLLI2S configuration register
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SR(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0x70000000)|value<<28)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SR() uint32 {
	return (volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0x70000000) >> 28
}
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SN(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0x7fc0)|value<<6)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SN() uint32 {
	return (volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0x7fc0) >> 6
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
}

// GPIO.MODER: GPIO port mode register
func (o *GPIO_Type) SetMODER_MODER15(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetMODER_MODER15() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetMODER_MODER14(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetMODER_MODER14() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetMODER_MODER13(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetMODER_MODER13() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetMODER_MODER12(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetMODER_MODER12() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetMODER_MODER11(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetMODER_MODER11() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetMODER_MODER10(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetMODER_MODER10() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetMODER_MODER9(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetMODER_MODER9() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetMODER_MODER8(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetMODER_MODER8() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetMODER_MODER7(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetMODER_MODER7() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetMODER_MODER6(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetMODER_MODER6() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetMODER_MODER5(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetMODER_MODER5() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetMODER_MODER4(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetMODER_MODER4() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetMODER_MODER3(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetMODER_MODER3() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetMODER_MODER2(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetMODER_MODER2() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetMODER_MODER1(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetMODER_MODER1() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetMODER_MODER0(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetMODER_MODER0() uint32 {
	return volatile.LoadUint32(&o.MODER.Reg) & 0x3
}

// GPIO.OTYPER: GPIO port output type register
func (o *GPIO_Type) SetOTYPER_OT15(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOTYPER_OT15() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOTYPER_OT14(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOTYPER_OT14() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOTYPER_OT13(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOTYPER_OT13() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOTYPER_OT12(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOTYPER_OT12() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOTYPER_OT11(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOTYPER_OT11() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOTYPER_OT10(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOTYPER_OT10() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOTYPER_OT9(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOTYPER_OT9() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOTYPER_OT8(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOTYPER_OT8() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOTYPER_OT7(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOTYPER_OT7() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOTYPER_OT6(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOTYPER_OT6() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOTYPER_OT5(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOTYPER_OT5() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOTYPER_OT4(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOTYPER_OT4() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOTYPER_OT3(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOTYPER_OT3() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOTYPER_OT2(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOTYPER_OT2() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOTYPER_OT1(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOTYPER_OT1() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOTYPER_OT0(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOTYPER_OT0() uint32 {
	return volatile.LoadUint32(&o.OTYPER.Reg) & 0x1
}

// GPIO.OSPEEDR: GPIO port output speed register
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR15(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR15() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR14(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR14() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR13(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR13() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR12(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR12() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR11(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR11() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR10(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR10() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR9(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR9() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR8(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR8() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR7(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR7() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR6(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR6() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR5(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR5() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR4(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR4() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR3(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR3() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR2(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR2() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR1(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR1() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR0(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR0() uint32 {
	return volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3
}

// GPIO.PUPDR: GPIO port pull-up/pull-down register
func (o *GPIO_Type) SetPUPDR_PUPDR15(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetPUPDR_PUPDR15() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetPUPDR_PUPDR14(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetPUPDR_PUPDR14() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetPUPDR_PUPDR13(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetPUPDR_PUPDR13() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetPUPDR_PUPDR12(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetPUPDR_PUPDR12() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetPUPDR_PUPDR11(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetPUPDR_PUPDR11() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetPUPDR_PUPDR10(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetPUPDR_PUPDR10() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetPUPDR_PUPDR9(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetPUPDR_PUPDR9() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetPUPDR_PUPDR8(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPUPDR_PUPDR8() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPUPDR_PUPDR7(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetPUPDR_PUPDR7() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetPUPDR_PUPDR6(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetPUPDR_PUPDR6() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetPUPDR_PUPDR5(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetPUPDR_PUPDR5() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetPUPDR_PUPDR4(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetPUPDR_PUPDR4() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetPUPDR_PUPDR3(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetPUPDR_PUPDR3() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetPUPDR_PUPDR2(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetPUPDR_PUPDR2() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetPUPDR_PUPDR1(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPUPDR_PUPDR1() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPUPDR_PUPDR0(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPUPDR_PUPDR0() uint32 {
	return volatile.LoadUint32(&o.PUPDR.Reg) & 0x3
}

// GPIO.IDR: GPIO port input data register
func (o *GPIO_Type) SetIDR_IDR15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIDR_IDR15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIDR_IDR14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIDR_IDR14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIDR_IDR13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIDR_IDR13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIDR_IDR12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIDR_IDR12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIDR_IDR11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIDR_IDR11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIDR_IDR10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIDR_IDR10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIDR_IDR9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIDR_IDR9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIDR_IDR8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIDR_IDR8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIDR_IDR7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIDR_IDR7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIDR_IDR6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIDR_IDR6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIDR_IDR5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIDR_IDR5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIDR_IDR4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIDR_IDR4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIDR_IDR3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIDR_IDR3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIDR_IDR2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIDR_IDR2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIDR_IDR1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIDR_IDR1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIDR_IDR0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIDR_IDR0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// GPIO.ODR: GPIO port output data register
func (o *GPIO_Type) SetODR_ODR15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetODR_ODR15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetODR_ODR14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetODR_ODR14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetODR_ODR13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetODR_ODR13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetODR_ODR12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetODR_ODR12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetODR_ODR11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetODR_ODR11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetODR_ODR10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetODR_ODR10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetODR_ODR9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetODR_ODR9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetODR_ODR8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetODR_ODR8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetODR_ODR7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetODR_ODR7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetODR_ODR6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetODR_ODR6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetODR_ODR5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetODR_ODR5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetODR_ODR4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetODR_ODR4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetODR_ODR3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetODR_ODR3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetODR_ODR2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetODR_ODR2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetODR_ODR1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetODR_ODR1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetODR_ODR0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetODR_ODR0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}

// GPIO.BSRR: GPIO port bit set/reset register
func (o *GPIO_Type) SetBSRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetBSRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000000) >> 31
}
func (o *GPIO_Type) SetBSRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetBSRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetBSRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetBSRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetBSRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetBSRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetBSRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetBSRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetBSRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetBSRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetBSRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetBSRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetBSRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetBSRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetBSRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetBSRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetBSRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetBSRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetBSRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetBSRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetBSRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetBSRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetBSRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetBSRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetBSRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetBSRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetBSRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetBSRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetBSRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetBSRR_BR0() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetBSRR_BS15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBSRR_BS15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetBSRR_BS14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBSRR_BS14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBSRR_BS13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBSRR_BS13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBSRR_BS12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBSRR_BS12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBSRR_BS11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBSRR_BS11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBSRR_BS10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBSRR_BS10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBSRR_BS9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBSRR_BS9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBSRR_BS8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBSRR_BS8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBSRR_BS7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBSRR_BS7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBSRR_BS6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBSRR_BS6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBSRR_BS5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBSRR_BS5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBSRR_BS4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBSRR_BS4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBSRR_BS3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBSRR_BS3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBSRR_BS2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBSRR_BS2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBSRR_BS1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBSRR_BS1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBSRR_BS0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBSRR_BS0() uint32 {
	return volatile.LoadUint32(&o.BSRR.Reg) & 0x1
}

// GPIO.LCKR: GPIO port configuration lock register
func (o *GPIO_Type) SetLCKR_LCKK(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLCKR_LCKK() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLCKR_LCK15(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLCKR_LCK15() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLCKR_LCK14(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLCKR_LCK14() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLCKR_LCK13(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLCKR_LCK13() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLCKR_LCK12(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLCKR_LCK12() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLCKR_LCK11(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLCKR_LCK11() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLCKR_LCK10(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLCKR_LCK10() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLCKR_LCK9(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLCKR_LCK9() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLCKR_LCK8(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLCKR_LCK8() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLCKR_LCK7(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLCKR_LCK7() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLCKR_LCK6(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLCKR_LCK6() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLCKR_LCK5(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLCKR_LCK5() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLCKR_LCK4(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLCKR_LCK4() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLCKR_LCK3(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLCKR_LCK3() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLCKR_LCK2(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLCKR_LCK2() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLCKR_LCK1(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLCKR_LCK1() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLCKR_LCK0(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLCKR_LCK0() uint32 {
	return volatile.LoadUint32(&o.LCKR.Reg) & 0x1
}

// GPIO.AFRL: GPIO alternate function low register
func (o *GPIO_Type) SetAFRL_AFRL7(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRL_AFRL7() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRL_AFRL6(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRL_AFRL6() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRL_AFRL5(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRL_AFRL5() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRL_AFRL4(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRL_AFRL4() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRL_AFRL3(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRL_AFRL3() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRL_AFRL2(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRL_AFRL2() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRL_AFRL1(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRL_AFRL1() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRL_AFRL0(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRL_AFRL0() uint32 {
	return volatile.LoadUint32(&o.AFRL.Reg) & 0xf
}

// GPIO.AFRH: GPIO alternate function high register
func (o *GPIO_Type) SetAFRH_AFRH15(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRH_AFRH15() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRH_AFRH14(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRH_AFRH14() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRH_AFRH13(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRH_AFRH13() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRH_AFRH12(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRH_AFRH12() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRH_AFRH11(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRH_AFRH11() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRH_AFRH10(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRH_AFRH10() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRH_AFRH9(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRH_AFRH9() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRH_AFRH8(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRH_AFRH8() uint32 {
	return volatile.LoadUint32(&o.AFRH.Reg) & 0xf
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRM   volatile.Register32 // 0x0
	PMC     volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	_       [8]byte
	CMPCR   volatile.Register32 // 0x20
}

// SYSCFG.MEMRM: memory remap register
func (o *SYSCFG_Type) SetMEMRM_MEM_MODE(value uint32) {
	volatile.StoreUint32(&o.MEMRM.Reg, volatile.LoadUint32(&o.MEMRM.Reg)&^(0x3)|value)
}
func (o *SYSCFG_Type) GetMEMRM_MEM_MODE() uint32 {
	return volatile.LoadUint32(&o.MEMRM.Reg) & 0x3
}

// SYSCFG.PMC: peripheral mode configuration register
func (o *SYSCFG_Type) SetPMC_MII_RMII_SEL(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCFG_Type) GetPMC_MII_RMII_SEL() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x800000) >> 23
}

// SYSCFG.EXTICR1: external interrupt configuration register 1
func (o *SYSCFG_Type) SetEXTICR1_EXTI3(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI3() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI2(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI2() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI1(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI1() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI0(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI0() uint32 {
	return volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf
}

// SYSCFG.EXTICR2: external interrupt configuration register 2
func (o *SYSCFG_Type) SetEXTICR2_EXTI7(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI7() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI6(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI6() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI5(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI5() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI4(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI4() uint32 {
	return volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf
}

// SYSCFG.EXTICR3: external interrupt configuration register 3
func (o *SYSCFG_Type) SetEXTICR3_EXTI11(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI11() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI10(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI10() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI9(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI9() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI8(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI8() uint32 {
	return volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf
}

// SYSCFG.EXTICR4: external interrupt configuration register 4
func (o *SYSCFG_Type) SetEXTICR4_EXTI15(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI14(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI14() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI13(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI13() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI12(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI12() uint32 {
	return volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf
}

// SYSCFG.CMPCR: Compensation cell control register
func (o *SYSCFG_Type) SetCMPCR_READY(value uint32) {
	volatile.StoreUint32(&o.CMPCR.Reg, volatile.LoadUint32(&o.CMPCR.Reg)&^(0x80)|value<<7)
}
func (o *SYSCFG_Type) GetCMPCR_READY() uint32 {
	return (volatile.LoadUint32(&o.CMPCR.Reg) & 0x80) >> 7
}
func (o *SYSCFG_Type) SetCMPCR_CMP_PD(value uint32) {
	volatile.StoreUint32(&o.CMPCR.Reg, volatile.LoadUint32(&o.CMPCR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetCMPCR_CMP_PD() uint32 {
	return volatile.LoadUint32(&o.CMPCR.Reg) & 0x1
}

// Serial peripheral interface
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// SPI.CR1: control register 1
func (o *SPI_Type) SetCR1_BIDIMODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetCR1_BIDIMODE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetCR1_BIDIOE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR1_BIDIOE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetCR1_CRCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR1_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR1_CRCNEXT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR1_CRCNEXT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR1_DFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetCR1_DFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetCR1_RXONLY(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetCR1_RXONLY() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetCR1_SSM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetCR1_SSM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetCR1_SSI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetCR1_SSI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR1_SPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR1_SPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR1_BR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x38)|value<<3)
}
func (o *SPI_Type) GetCR1_BR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x38) >> 3
}
func (o *SPI_Type) SetCR1_MSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR1_MSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR1_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR1_CPHA() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// SPI.CR2: control register 2
func (o *SPI_Type) SetCR2_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR2_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR2_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR2_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR2_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetCR2_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetCR2_FRF(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetCR2_FRF() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetCR2_SSOE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR2_SSOE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR2_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR2_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR2_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR2_RXDMAEN() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// SPI.SR: status register
func (o *SPI_Type) SetSR_TIFRFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_TIFRFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_CRCERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_CRCERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_UDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_UDR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_CHSIDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_CHSIDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_TXE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TXE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RXNE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// SPI.DR: data register
func (o *SPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// SPI.CRCPR: CRC polynomial register
func (o *SPI_Type) SetCRCPR_CRCPOLY(value uint32) {
	volatile.StoreUint32(&o.CRCPR.Reg, volatile.LoadUint32(&o.CRCPR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetCRCPR_CRCPOLY() uint32 {
	return volatile.LoadUint32(&o.CRCPR.Reg) & 0xffff
}

// SPI.RXCRCR: RX CRC register
func (o *SPI_Type) SetRXCRCR_RxCRC(value uint32) {
	volatile.StoreUint32(&o.RXCRCR.Reg, volatile.LoadUint32(&o.RXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRXCRCR_RxCRC() uint32 {
	return volatile.LoadUint32(&o.RXCRCR.Reg) & 0xffff
}

// SPI.TXCRCR: TX CRC register
func (o *SPI_Type) SetTXCRCR_TxCRC(value uint32) {
	volatile.StoreUint32(&o.TXCRCR.Reg, volatile.LoadUint32(&o.TXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXCRCR_TxCRC() uint32 {
	return volatile.LoadUint32(&o.TXCRCR.Reg) & 0xffff
}

// SPI.I2SCFGR: I2S configuration register
func (o *SPI_Type) SetI2SCFGR_I2SMOD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetI2SCFGR_I2SMOD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetI2SCFGR_I2SE(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetI2SCFGR_I2SE() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetI2SCFGR_I2SCFG(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x300)|value<<8)
}
func (o *SPI_Type) GetI2SCFGR_I2SCFG() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x300) >> 8
}
func (o *SPI_Type) SetI2SCFGR_PCMSYNC(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetI2SCFGR_PCMSYNC() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetI2SCFGR_I2SSTD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x30)|value<<4)
}
func (o *SPI_Type) GetI2SCFGR_I2SSTD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x30) >> 4
}
func (o *SPI_Type) SetI2SCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetI2SCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetI2SCFGR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x6)|value<<1)
}
func (o *SPI_Type) GetI2SCFGR_DATLEN() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x6) >> 1
}
func (o *SPI_Type) SetI2SCFGR_CHLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetI2SCFGR_CHLEN() uint32 {
	return volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x1
}

// SPI.I2SPR: I2S prescaler register
func (o *SPI_Type) SetI2SPR_MCKOE(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetI2SPR_MCKOE() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetI2SPR_ODD(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetI2SPR_ODD() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetI2SPR_I2SDIV(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0xff)|value)
}
func (o *SPI_Type) GetI2SPR_I2SDIV() uint32 {
	return volatile.LoadUint32(&o.I2SPR.Reg) & 0xff
}

// Secure digital input/output interface
type SDIO_Type struct {
	POWER   volatile.Register32 // 0x0
	CLKCR   volatile.Register32 // 0x4
	ARG     volatile.Register32 // 0x8
	CMD     volatile.Register32 // 0xC
	RESPCMD volatile.Register32 // 0x10
	RESP1   volatile.Register32 // 0x14
	RESP2   volatile.Register32 // 0x18
	RESP3   volatile.Register32 // 0x1C
	RESP4   volatile.Register32 // 0x20
	DTIMER  volatile.Register32 // 0x24
	DLEN    volatile.Register32 // 0x28
	DCTRL   volatile.Register32 // 0x2C
	DCOUNT  volatile.Register32 // 0x30
	STA     volatile.Register32 // 0x34
	ICR     volatile.Register32 // 0x38
	MASK    volatile.Register32 // 0x3C
	_       [8]byte
	FIFOCNT volatile.Register32 // 0x48
	_       [52]byte
	FIFO    volatile.Register32 // 0x80
}

// SDIO.POWER: power control register
func (o *SDIO_Type) SetPOWER_PWRCTRL(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x3)|value)
}
func (o *SDIO_Type) GetPOWER_PWRCTRL() uint32 {
	return volatile.LoadUint32(&o.POWER.Reg) & 0x3
}

// SDIO.CLKCR: SDI clock control register
func (o *SDIO_Type) SetCLKCR_HWFC_EN(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetCLKCR_HWFC_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetCLKCR_NEGEDGE(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetCLKCR_NEGEDGE() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetCLKCR_WIDBUS(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x1800)|value<<11)
}
func (o *SDIO_Type) GetCLKCR_WIDBUS() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x1800) >> 11
}
func (o *SDIO_Type) SetCLKCR_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetCLKCR_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetCLKCR_PWRSAV(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetCLKCR_PWRSAV() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetCLKCR_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetCLKCR_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetCLKCR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0xff)|value)
}
func (o *SDIO_Type) GetCLKCR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.CLKCR.Reg) & 0xff
}

// SDIO.ARG: argument register
func (o *SDIO_Type) SetARG(value uint32) {
	volatile.StoreUint32(&o.ARG.Reg, value)
}
func (o *SDIO_Type) GetARG() uint32 {
	return volatile.LoadUint32(&o.ARG.Reg)
}

// SDIO.CMD: command register
func (o *SDIO_Type) SetCMD_CE_ATACMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetCMD_CE_ATACMD() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetCMD_NIEN(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetCMD_NIEN() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetCMD_ENCMDcompl(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x1000)|value<<12)
}
func (o *SDIO_Type) GetCMD_ENCMDcompl() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x1000) >> 12
}
func (o *SDIO_Type) SetCMD_SDIOSuspend(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetCMD_SDIOSuspend() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetCMD_CPSMEN(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetCMD_CPSMEN() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetCMD_WAITPEND(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetCMD_WAITPEND() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetCMD_WAITINT(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetCMD_WAITINT() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetCMD_WAITRESP(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0xc0)|value<<6)
}
func (o *SDIO_Type) GetCMD_WAITRESP() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0xc0) >> 6
}
func (o *SDIO_Type) SetCMD_CMDINDEX(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x3f)|value)
}
func (o *SDIO_Type) GetCMD_CMDINDEX() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x3f
}

// SDIO.RESPCMD: command response register
func (o *SDIO_Type) SetRESPCMD(value uint32) {
	volatile.StoreUint32(&o.RESPCMD.Reg, volatile.LoadUint32(&o.RESPCMD.Reg)&^(0x3f)|value)
}
func (o *SDIO_Type) GetRESPCMD() uint32 {
	return volatile.LoadUint32(&o.RESPCMD.Reg) & 0x3f
}

// SDIO.RESP1: response 1..4 register
func (o *SDIO_Type) SetRESP1(value uint32) {
	volatile.StoreUint32(&o.RESP1.Reg, value)
}
func (o *SDIO_Type) GetRESP1() uint32 {
	return volatile.LoadUint32(&o.RESP1.Reg)
}

// SDIO.RESP2: response 1..4 register
func (o *SDIO_Type) SetRESP2(value uint32) {
	volatile.StoreUint32(&o.RESP2.Reg, value)
}
func (o *SDIO_Type) GetRESP2() uint32 {
	return volatile.LoadUint32(&o.RESP2.Reg)
}

// SDIO.RESP3: response 1..4 register
func (o *SDIO_Type) SetRESP3(value uint32) {
	volatile.StoreUint32(&o.RESP3.Reg, value)
}
func (o *SDIO_Type) GetRESP3() uint32 {
	return volatile.LoadUint32(&o.RESP3.Reg)
}

// SDIO.RESP4: response 1..4 register
func (o *SDIO_Type) SetRESP4(value uint32) {
	volatile.StoreUint32(&o.RESP4.Reg, value)
}
func (o *SDIO_Type) GetRESP4() uint32 {
	return volatile.LoadUint32(&o.RESP4.Reg)
}

// SDIO.DTIMER: data timer register
func (o *SDIO_Type) SetDTIMER(value uint32) {
	volatile.StoreUint32(&o.DTIMER.Reg, value)
}
func (o *SDIO_Type) GetDTIMER() uint32 {
	return volatile.LoadUint32(&o.DTIMER.Reg)
}

// SDIO.DLEN: data length register
func (o *SDIO_Type) SetDLEN_DATALENGTH(value uint32) {
	volatile.StoreUint32(&o.DLEN.Reg, volatile.LoadUint32(&o.DLEN.Reg)&^(0x1ffffff)|value)
}
func (o *SDIO_Type) GetDLEN_DATALENGTH() uint32 {
	return volatile.LoadUint32(&o.DLEN.Reg) & 0x1ffffff
}

// SDIO.DCTRL: data control register
func (o *SDIO_Type) SetDCTRL_SDIOEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetDCTRL_SDIOEN() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetDCTRL_RWMOD(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetDCTRL_RWMOD() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetDCTRL_RWSTOP(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetDCTRL_RWSTOP() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetDCTRL_RWSTART(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetDCTRL_RWSTART() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetDCTRL_DBLOCKSIZE(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0xf0)|value<<4)
}
func (o *SDIO_Type) GetDCTRL_DBLOCKSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0xf0) >> 4
}
func (o *SDIO_Type) SetDCTRL_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetDCTRL_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetDCTRL_DTMODE(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetDCTRL_DTMODE() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetDCTRL_DTDIR(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetDCTRL_DTDIR() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetDCTRL_DTEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetDCTRL_DTEN() uint32 {
	return volatile.LoadUint32(&o.DCTRL.Reg) & 0x1
}

// SDIO.DCOUNT: data counter register
func (o *SDIO_Type) SetDCOUNT_DATACOUNT(value uint32) {
	volatile.StoreUint32(&o.DCOUNT.Reg, volatile.LoadUint32(&o.DCOUNT.Reg)&^(0x1ffffff)|value)
}
func (o *SDIO_Type) GetDCOUNT_DATACOUNT() uint32 {
	return volatile.LoadUint32(&o.DCOUNT.Reg) & 0x1ffffff
}

// SDIO.STA: status register
func (o *SDIO_Type) SetSTA_CEATAEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x800000)|value<<23)
}
func (o *SDIO_Type) GetSTA_CEATAEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x800000) >> 23
}
func (o *SDIO_Type) SetSTA_SDIOIT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x400000)|value<<22)
}
func (o *SDIO_Type) GetSTA_SDIOIT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x400000) >> 22
}
func (o *SDIO_Type) SetSTA_RXDAVL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x200000)|value<<21)
}
func (o *SDIO_Type) GetSTA_RXDAVL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x200000) >> 21
}
func (o *SDIO_Type) SetSTA_TXDAVL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x100000)|value<<20)
}
func (o *SDIO_Type) GetSTA_TXDAVL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x100000) >> 20
}
func (o *SDIO_Type) SetSTA_RXFIFOE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x80000)|value<<19)
}
func (o *SDIO_Type) GetSTA_RXFIFOE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x80000) >> 19
}
func (o *SDIO_Type) SetSTA_TXFIFOE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x40000)|value<<18)
}
func (o *SDIO_Type) GetSTA_TXFIFOE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x40000) >> 18
}
func (o *SDIO_Type) SetSTA_RXFIFOF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x20000)|value<<17)
}
func (o *SDIO_Type) GetSTA_RXFIFOF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x20000) >> 17
}
func (o *SDIO_Type) SetSTA_TXFIFOF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x10000)|value<<16)
}
func (o *SDIO_Type) GetSTA_TXFIFOF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x10000) >> 16
}
func (o *SDIO_Type) SetSTA_RXFIFOHF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x8000)|value<<15)
}
func (o *SDIO_Type) GetSTA_RXFIFOHF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x8000) >> 15
}
func (o *SDIO_Type) SetSTA_TXFIFOHE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetSTA_TXFIFOHE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetSTA_RXACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetSTA_RXACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetSTA_TXACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x1000)|value<<12)
}
func (o *SDIO_Type) GetSTA_TXACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x1000) >> 12
}
func (o *SDIO_Type) SetSTA_CMDACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetSTA_CMDACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetSTA_DBCKEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetSTA_DBCKEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetSTA_STBITERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetSTA_STBITERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetSTA_DATAEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetSTA_DATAEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetSTA_CMDSENT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x80)|value<<7)
}
func (o *SDIO_Type) GetSTA_CMDSENT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x80) >> 7
}
func (o *SDIO_Type) SetSTA_CMDREND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x40)|value<<6)
}
func (o *SDIO_Type) GetSTA_CMDREND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x40) >> 6
}
func (o *SDIO_Type) SetSTA_RXOVERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x20)|value<<5)
}
func (o *SDIO_Type) GetSTA_RXOVERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x20) >> 5
}
func (o *SDIO_Type) SetSTA_TXUNDERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x10)|value<<4)
}
func (o *SDIO_Type) GetSTA_TXUNDERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x10) >> 4
}
func (o *SDIO_Type) SetSTA_DTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetSTA_DTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetSTA_CTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetSTA_CTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetSTA_DCRCFAIL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetSTA_DCRCFAIL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetSTA_CCRCFAIL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetSTA_CCRCFAIL() uint32 {
	return volatile.LoadUint32(&o.STA.Reg) & 0x1
}

// SDIO.ICR: interrupt clear register
func (o *SDIO_Type) SetICR_CEATAENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800000)|value<<23)
}
func (o *SDIO_Type) GetICR_CEATAENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800000) >> 23
}
func (o *SDIO_Type) SetICR_SDIOITC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400000)|value<<22)
}
func (o *SDIO_Type) GetICR_SDIOITC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400000) >> 22
}
func (o *SDIO_Type) SetICR_DBCKENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetICR_DBCKENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetICR_STBITERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetICR_STBITERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetICR_DATAENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetICR_DATAENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetICR_CMDSENTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *SDIO_Type) GetICR_CMDSENTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *SDIO_Type) SetICR_CMDRENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *SDIO_Type) GetICR_CMDRENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *SDIO_Type) SetICR_RXOVERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *SDIO_Type) GetICR_RXOVERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *SDIO_Type) SetICR_TXUNDERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *SDIO_Type) GetICR_TXUNDERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *SDIO_Type) SetICR_DTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetICR_DTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetICR_CTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetICR_CTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetICR_DCRCFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetICR_DCRCFAILC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetICR_CCRCFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetICR_CCRCFAILC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// SDIO.MASK: mask register
func (o *SDIO_Type) SetMASK_CEATAENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x800000)|value<<23)
}
func (o *SDIO_Type) GetMASK_CEATAENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x800000) >> 23
}
func (o *SDIO_Type) SetMASK_SDIOITIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x400000)|value<<22)
}
func (o *SDIO_Type) GetMASK_SDIOITIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x400000) >> 22
}
func (o *SDIO_Type) SetMASK_RXDAVLIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x200000)|value<<21)
}
func (o *SDIO_Type) GetMASK_RXDAVLIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x200000) >> 21
}
func (o *SDIO_Type) SetMASK_TXDAVLIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x100000)|value<<20)
}
func (o *SDIO_Type) GetMASK_TXDAVLIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x100000) >> 20
}
func (o *SDIO_Type) SetMASK_RXFIFOEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x80000)|value<<19)
}
func (o *SDIO_Type) GetMASK_RXFIFOEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x80000) >> 19
}
func (o *SDIO_Type) SetMASK_TXFIFOEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x40000)|value<<18)
}
func (o *SDIO_Type) GetMASK_TXFIFOEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x40000) >> 18
}
func (o *SDIO_Type) SetMASK_RXFIFOFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x20000)|value<<17)
}
func (o *SDIO_Type) GetMASK_RXFIFOFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x20000) >> 17
}
func (o *SDIO_Type) SetMASK_TXFIFOFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x10000)|value<<16)
}
func (o *SDIO_Type) GetMASK_TXFIFOFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x10000) >> 16
}
func (o *SDIO_Type) SetMASK_RXFIFOHFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x8000)|value<<15)
}
func (o *SDIO_Type) GetMASK_RXFIFOHFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x8000) >> 15
}
func (o *SDIO_Type) SetMASK_TXFIFOHEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetMASK_TXFIFOHEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetMASK_RXACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetMASK_RXACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetMASK_TXACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x1000)|value<<12)
}
func (o *SDIO_Type) GetMASK_TXACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x1000) >> 12
}
func (o *SDIO_Type) SetMASK_CMDACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetMASK_CMDACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetMASK_DBCKENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetMASK_DBCKENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetMASK_STBITERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetMASK_STBITERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetMASK_DATAENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetMASK_DATAENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetMASK_CMDSENTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x80)|value<<7)
}
func (o *SDIO_Type) GetMASK_CMDSENTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x80) >> 7
}
func (o *SDIO_Type) SetMASK_CMDRENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x40)|value<<6)
}
func (o *SDIO_Type) GetMASK_CMDRENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x40) >> 6
}
func (o *SDIO_Type) SetMASK_RXOVERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x20)|value<<5)
}
func (o *SDIO_Type) GetMASK_RXOVERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x20) >> 5
}
func (o *SDIO_Type) SetMASK_TXUNDERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x10)|value<<4)
}
func (o *SDIO_Type) GetMASK_TXUNDERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x10) >> 4
}
func (o *SDIO_Type) SetMASK_DTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetMASK_DTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetMASK_CTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetMASK_CTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetMASK_DCRCFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetMASK_DCRCFAILIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetMASK_CCRCFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetMASK_CCRCFAILIE() uint32 {
	return volatile.LoadUint32(&o.MASK.Reg) & 0x1
}

// SDIO.FIFOCNT: FIFO counter register
func (o *SDIO_Type) SetFIFOCNT_FIFOCOUNT(value uint32) {
	volatile.StoreUint32(&o.FIFOCNT.Reg, volatile.LoadUint32(&o.FIFOCNT.Reg)&^(0xffffff)|value)
}
func (o *SDIO_Type) GetFIFOCNT_FIFOCOUNT() uint32 {
	return volatile.LoadUint32(&o.FIFOCNT.Reg) & 0xffffff
}

// SDIO.FIFO: data FIFO register
func (o *SDIO_Type) SetFIFO(value uint32) {
	volatile.StoreUint32(&o.FIFO.Reg, value)
}
func (o *SDIO_Type) GetFIFO() uint32 {
	return volatile.LoadUint32(&o.FIFO.Reg)
}

// Analog-to-digital converter
type ADC_Type struct {
	SR    volatile.Register32 // 0x0
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	SMPR1 volatile.Register32 // 0xC
	SMPR2 volatile.Register32 // 0x10
	JOFR1 volatile.Register32 // 0x14
	JOFR2 volatile.Register32 // 0x18
	JOFR3 volatile.Register32 // 0x1C
	JOFR4 volatile.Register32 // 0x20
	HTR   volatile.Register32 // 0x24
	LTR   volatile.Register32 // 0x28
	SQR1  volatile.Register32 // 0x2C
	SQR2  volatile.Register32 // 0x30
	SQR3  volatile.Register32 // 0x34
	JSQR  volatile.Register32 // 0x38
	JDR1  volatile.Register32 // 0x3C
	JDR2  volatile.Register32 // 0x40
	JDR3  volatile.Register32 // 0x44
	JDR4  volatile.Register32 // 0x48
	DR    volatile.Register32 // 0x4C
}

// ADC.SR: status register
func (o *ADC_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetSR_STRT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetSR_STRT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetSR_JSTRT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetSR_JSTRT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetSR_JEOC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetSR_JEOC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetSR_EOC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetSR_EOC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetSR_AWD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetSR_AWD() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// ADC.CR1: control register 1
func (o *ADC_Type) SetCR1_OVRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetCR1_OVRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetCR1_RES(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3000000)|value<<24)
}
func (o *ADC_Type) GetCR1_RES() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x3000000) >> 24
}
func (o *ADC_Type) SetCR1_AWDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCR1_AWDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCR1_JAWDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCR1_JAWDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCR1_DISCNUM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xe000)|value<<13)
}
func (o *ADC_Type) GetCR1_DISCNUM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xe000) >> 13
}
func (o *ADC_Type) SetCR1_JDISCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCR1_JDISCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCR1_DISCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCR1_DISCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCR1_JAUTO(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCR1_JAUTO() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCR1_AWDSGL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCR1_AWDSGL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCR1_SCAN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCR1_SCAN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCR1_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCR1_JEOCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCR1_AWDIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCR1_AWDIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCR1_EOCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCR1_EOCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCR1_AWDCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetCR1_AWDCH() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1f
}

// ADC.CR2: control register 2
func (o *ADC_Type) SetCR2_SWSTART(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetCR2_SWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetCR2_EXTEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x30000000)|value<<28)
}
func (o *ADC_Type) GetCR2_EXTEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x30000000) >> 28
}
func (o *ADC_Type) SetCR2_EXTSEL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetCR2_EXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetCR2_JSWSTART(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCR2_JSWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCR2_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x300000)|value<<20)
}
func (o *ADC_Type) GetCR2_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x300000) >> 20
}
func (o *ADC_Type) SetCR2_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetCR2_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetCR2_ALIGN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCR2_ALIGN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCR2_EOCS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCR2_EOCS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCR2_DDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCR2_DDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCR2_DMA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCR2_DMA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCR2_CONT(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR2_CONT() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR2_ADON(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR2_ADON() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// ADC.SMPR1: sample time register 1
func (o *ADC_Type) SetSMPR1_SMP10(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR1_SMP10() uint32 {
	return volatile.LoadUint32(&o.SMPR1.Reg) & 0x7
}
func (o *ADC_Type) SetSMPR1_SMP11(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR1_SMP11() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR1_SMP12(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR1_SMP12() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR1_SMP13(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR1_SMP13() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR1_SMP14(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR1_SMP14() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR1_SMP15(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR1_SMP15() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR1_SMP16(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR1_SMP16() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR1_SMP17(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR1_SMP17() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR1_SMP18(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR1_SMP18() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000000) >> 24
}

// ADC.SMPR2: sample time register 2
func (o *ADC_Type) SetSMPR2_SMP0(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR2_SMP0() uint32 {
	return volatile.LoadUint32(&o.SMPR2.Reg) & 0x7
}
func (o *ADC_Type) SetSMPR2_SMP1(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR2_SMP1() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR2_SMP2(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR2_SMP2() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR2_SMP3(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR2_SMP3() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR2_SMP4(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR2_SMP4() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR2_SMP5(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR2_SMP5() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR2_SMP6(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR2_SMP6() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR2_SMP7(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR2_SMP7() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR2_SMP8(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR2_SMP8() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetSMPR2_SMP9(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38000000)|value<<27)
}
func (o *ADC_Type) GetSMPR2_SMP9() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38000000) >> 27
}

// ADC.JOFR1: injected channel data offset register x
func (o *ADC_Type) SetJOFR1_JOFFSET(value uint32) {
	volatile.StoreUint32(&o.JOFR1.Reg, volatile.LoadUint32(&o.JOFR1.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR1_JOFFSET() uint32 {
	return volatile.LoadUint32(&o.JOFR1.Reg) & 0xfff
}

// ADC.JOFR2: injected channel data offset register x
func (o *ADC_Type) SetJOFR2_JOFFSET(value uint32) {
	volatile.StoreUint32(&o.JOFR2.Reg, volatile.LoadUint32(&o.JOFR2.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR2_JOFFSET() uint32 {
	return volatile.LoadUint32(&o.JOFR2.Reg) & 0xfff
}

// ADC.JOFR3: injected channel data offset register x
func (o *ADC_Type) SetJOFR3_JOFFSET(value uint32) {
	volatile.StoreUint32(&o.JOFR3.Reg, volatile.LoadUint32(&o.JOFR3.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR3_JOFFSET() uint32 {
	return volatile.LoadUint32(&o.JOFR3.Reg) & 0xfff
}

// ADC.JOFR4: injected channel data offset register x
func (o *ADC_Type) SetJOFR4_JOFFSET(value uint32) {
	volatile.StoreUint32(&o.JOFR4.Reg, volatile.LoadUint32(&o.JOFR4.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR4_JOFFSET() uint32 {
	return volatile.LoadUint32(&o.JOFR4.Reg) & 0xfff
}

// ADC.HTR: watchdog higher threshold register
func (o *ADC_Type) SetHTR_HT(value uint32) {
	volatile.StoreUint32(&o.HTR.Reg, volatile.LoadUint32(&o.HTR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetHTR_HT() uint32 {
	return volatile.LoadUint32(&o.HTR.Reg) & 0xfff
}

// ADC.LTR: watchdog lower threshold register
func (o *ADC_Type) SetLTR_LT(value uint32) {
	volatile.StoreUint32(&o.LTR.Reg, volatile.LoadUint32(&o.LTR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetLTR_LT() uint32 {
	return volatile.LoadUint32(&o.LTR.Reg) & 0xfff
}

// ADC.SQR1: regular sequence register 1
func (o *ADC_Type) SetSQR1_L(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetSQR1_L() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetSQR1_SQ16(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR1_SQ16() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR1_SQ15(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR1_SQ15() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR1_SQ14(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR1_SQ14() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR1_SQ13(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR1_SQ13() uint32 {
	return volatile.LoadUint32(&o.SQR1.Reg) & 0x1f
}

// ADC.SQR2: regular sequence register 2
func (o *ADC_Type) SetSQR2_SQ12(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x3e000000)|value<<25)
}
func (o *ADC_Type) GetSQR2_SQ12() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x3e000000) >> 25
}
func (o *ADC_Type) SetSQR2_SQ11(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f00000)|value<<20)
}
func (o *ADC_Type) GetSQR2_SQ11() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f00000) >> 20
}
func (o *ADC_Type) SetSQR2_SQ10(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR2_SQ10() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR2_SQ9(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR2_SQ9() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR2_SQ8(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR2_SQ8() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR2_SQ7(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR2_SQ7() uint32 {
	return volatile.LoadUint32(&o.SQR2.Reg) & 0x1f
}

// ADC.SQR3: regular sequence register 3
func (o *ADC_Type) SetSQR3_SQ6(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x3e000000)|value<<25)
}
func (o *ADC_Type) GetSQR3_SQ6() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x3e000000) >> 25
}
func (o *ADC_Type) SetSQR3_SQ5(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f00000)|value<<20)
}
func (o *ADC_Type) GetSQR3_SQ5() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f00000) >> 20
}
func (o *ADC_Type) SetSQR3_SQ4(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR3_SQ4() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR3_SQ3(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR3_SQ3() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR3_SQ2(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR3_SQ2() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR3_SQ1(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR3_SQ1() uint32 {
	return volatile.LoadUint32(&o.SQR3.Reg) & 0x1f
}

// ADC.JSQR: injected sequence register
func (o *ADC_Type) SetJSQR_JL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x300000)|value<<20)
}
func (o *ADC_Type) GetJSQR_JL() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x300000) >> 20
}
func (o *ADC_Type) SetJSQR_JSQ4(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetJSQR_JSQ4() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetJSQR_JSQ3(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetJSQR_JSQ3() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetJSQR_JSQ2(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetJSQR_JSQ2() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetJSQR_JSQ1(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetJSQR_JSQ1() uint32 {
	return volatile.LoadUint32(&o.JSQR.Reg) & 0x1f
}

// ADC.JDR1: injected data register x
func (o *ADC_Type) SetJDR1_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR1.Reg, volatile.LoadUint32(&o.JDR1.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR1_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR1.Reg) & 0xffff
}

// ADC.JDR2: injected data register x
func (o *ADC_Type) SetJDR2_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR2.Reg, volatile.LoadUint32(&o.JDR2.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR2_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR2.Reg) & 0xffff
}

// ADC.JDR3: injected data register x
func (o *ADC_Type) SetJDR3_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR3.Reg, volatile.LoadUint32(&o.JDR3.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR3_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR3.Reg) & 0xffff
}

// ADC.JDR4: injected data register x
func (o *ADC_Type) SetJDR4_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR4.Reg, volatile.LoadUint32(&o.JDR4.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR4_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR4.Reg) & 0xffff
}

// ADC.DR: regular data register
func (o *ADC_Type) SetDR_DATA(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetDR_DATA() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	SR   volatile.Register32 // 0x0
	DR   volatile.Register32 // 0x4
	BRR  volatile.Register32 // 0x8
	CR1  volatile.Register32 // 0xC
	CR2  volatile.Register32 // 0x10
	CR3  volatile.Register32 // 0x14
	GTPR volatile.Register32 // 0x18
}

// USART.SR: Status register
func (o *USART_Type) SetSR_CTS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetSR_LBD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetSR_LBD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetSR_TXE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetSR_TXE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetSR_TC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetSR_TC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetSR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetSR_IDLE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetSR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetSR_ORE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetSR_ORE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetSR_NF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetSR_NF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetSR_FE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetSR_FE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetSR_PE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetSR_PE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// USART.DR: Data register
func (o *USART_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0x1ff
}

// USART.BRR: Baud rate register
func (o *USART_Type) SetBRR_DIV_Mantissa(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xfff0)|value<<4)
}
func (o *USART_Type) GetBRR_DIV_Mantissa() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0xfff0) >> 4
}
func (o *USART_Type) SetBRR_DIV_Fraction(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetBRR_DIV_Fraction() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0xf
}

// USART.CR1: Control register 1
func (o *USART_Type) SetCR1_OVER8(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR1_OVER8() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR1_UE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR1_UE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR1_M(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR1_M() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR1_WAKE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR1_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR1_PCE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR1_PCE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR1_PS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR1_PS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR1_PEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR1_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR1_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR1_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR1_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR1_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR1_IDLEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR1_IDLEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR1_TE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR1_TE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR1_RE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR1_RE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR1_RWU(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR1_RWU() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR1_SBK(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR1_SBK() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// USART.CR2: Control register 2
func (o *USART_Type) SetCR2_LINEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR2_LINEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR2_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR2_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR2_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR2_LBCL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR2_LBCL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR2_LBDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR2_LBDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR2_LBDL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR2_LBDL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR2_ADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetCR2_ADD() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0xf
}

// USART.CR3: Control register 3
func (o *USART_Type) SetCR3_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR3_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR3_CTSIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR3_CTSIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR3_CTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR3_CTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR3_RTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR3_RTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR3_DMAT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR3_DMAT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR3_DMAR(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR3_DMAR() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR3_SCEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR3_SCEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR3_NACK(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR3_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR3_HDSEL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR3_HDSEL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR3_IRLP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR3_IRLP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR3_IREN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR3_IREN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR3_EIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR3_EIE() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}

// USART.GTPR: Guard time and prescaler register
func (o *USART_Type) SetGTPR_GT(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetGTPR_GT() uint32 {
	return (volatile.LoadUint32(&o.GTPR.Reg) & 0xff00) >> 8
}
func (o *USART_Type) SetGTPR_PSC(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetGTPR_PSC() uint32 {
	return volatile.LoadUint32(&o.GTPR.Reg) & 0xff
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
}

// DAC.CR: control register
func (o *DAC_Type) SetCR_DMAUDRIE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetCR_DMAUDRIE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetCR_DMAEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *DAC_Type) GetCR_DMAEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *DAC_Type) SetCR_MAMP2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf000000)|value<<24)
}
func (o *DAC_Type) GetCR_MAMP2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf000000) >> 24
}
func (o *DAC_Type) SetCR_WAVE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00000)|value<<22)
}
func (o *DAC_Type) GetCR_WAVE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00000) >> 22
}
func (o *DAC_Type) SetCR_TSEL2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x380000)|value<<19)
}
func (o *DAC_Type) GetCR_TSEL2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x380000) >> 19
}
func (o *DAC_Type) SetCR_TEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *DAC_Type) GetCR_TEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *DAC_Type) SetCR_BOFF2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *DAC_Type) GetCR_BOFF2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *DAC_Type) SetCR_EN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *DAC_Type) GetCR_EN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *DAC_Type) SetCR_DMAUDRIE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetCR_DMAUDRIE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetCR_DMAEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *DAC_Type) GetCR_DMAEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *DAC_Type) SetCR_MAMP1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *DAC_Type) GetCR_MAMP1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *DAC_Type) SetCR_WAVE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DAC_Type) GetCR_WAVE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *DAC_Type) SetCR_TSEL1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x38)|value<<3)
}
func (o *DAC_Type) GetCR_TSEL1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x38) >> 3
}
func (o *DAC_Type) SetCR_TEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetCR_TEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DAC_Type) SetCR_BOFF1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetCR_BOFF1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetCR_EN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCR_EN1() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DAC.SWTRIGR: software trigger register
func (o *DAC_Type) SetSWTRIGR_SWTRIG2(value uint32) {
	volatile.StoreUint32(&o.SWTRIGR.Reg, volatile.LoadUint32(&o.SWTRIGR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetSWTRIGR_SWTRIG2() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetSWTRIGR_SWTRIG1(value uint32) {
	volatile.StoreUint32(&o.SWTRIGR.Reg, volatile.LoadUint32(&o.SWTRIGR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetSWTRIGR_SWTRIG1() uint32 {
	return volatile.LoadUint32(&o.SWTRIGR.Reg) & 0x1
}

// DAC.DHR12R1: channel1 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R1.Reg, volatile.LoadUint32(&o.DHR12R1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R1.Reg) & 0xfff
}

// DAC.DHR12L1: channel1 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L1.Reg, volatile.LoadUint32(&o.DHR12L1.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L1_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L1.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R1: channel1 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R1.Reg, volatile.LoadUint32(&o.DHR8R1.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R1.Reg) & 0xff
}

// DAC.DHR12R2: channel2 12-bit right aligned data holding register
func (o *DAC_Type) SetDHR12R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R2.Reg, volatile.LoadUint32(&o.DHR12R2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R2.Reg) & 0xfff
}

// DAC.DHR12L2: channel2 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L2.Reg, volatile.LoadUint32(&o.DHR12L2.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L2_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L2.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R2: channel2 8-bit right-aligned data holding register
func (o *DAC_Type) SetDHR8R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R2.Reg, volatile.LoadUint32(&o.DHR8R2.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R2.Reg) & 0xff
}

// DAC.DHR12RD: Dual DAC 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff0000)|value<<16)
}
func (o *DAC_Type) GetDHR12RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff0000) >> 16
}
func (o *DAC_Type) SetDHR12RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff
}

// DAC.DHR12LD: DUAL DAC 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12LD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff00000)|value<<20)
}
func (o *DAC_Type) GetDHR12LD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff00000) >> 20
}
func (o *DAC_Type) SetDHR12LD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12LD_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff0) >> 4
}

// DAC.DHR8RD: DUAL DAC 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff00)|value<<8)
}
func (o *DAC_Type) GetDHR8RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff00) >> 8
}
func (o *DAC_Type) SetDHR8RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff
}

// DAC.DOR1: channel1 data output register
func (o *DAC_Type) SetDOR1_DACC1DOR(value uint32) {
	volatile.StoreUint32(&o.DOR1.Reg, volatile.LoadUint32(&o.DOR1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR1_DACC1DOR() uint32 {
	return volatile.LoadUint32(&o.DOR1.Reg) & 0xfff
}

// DAC.DOR2: channel2 data output register
func (o *DAC_Type) SetDOR2_DACC2DOR(value uint32) {
	volatile.StoreUint32(&o.DOR2.Reg, volatile.LoadUint32(&o.DOR2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR2_DACC2DOR() uint32 {
	return volatile.LoadUint32(&o.DOR2.Reg) & 0xfff
}

// DAC.SR: status register
func (o *DAC_Type) SetSR_DMAUDR2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetSR_DMAUDR2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetSR_DMAUDR1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetSR_DMAUDR1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}

// Power control
type PWR_Type struct {
	CR  volatile.Register32 // 0x0
	CSR volatile.Register32 // 0x4
}

// PWR.CR: power control register
func (o *PWR_Type) SetCR_FPDS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR_FPDS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR_DBP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR_DBP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR_PLS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xe0)|value<<5)
}
func (o *PWR_Type) GetCR_PLS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xe0) >> 5
}
func (o *PWR_Type) SetCR_PVDE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR_PVDE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR_CSBF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR_CSBF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR_CWUF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR_CWUF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR_PDDS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR_PDDS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR_LPDS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR_LPDS() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// PWR.CSR: power control/status register
func (o *PWR_Type) SetCSR_BRE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCSR_BRE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCSR_EWUP(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCSR_EWUP() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCSR_BRR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCSR_BRR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCSR_PVDO(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCSR_PVDO() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCSR_SBF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCSR_SBF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCSR_WUF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCSR_WUF() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}

// Controller area network
type CAN_Type struct {
	MCR   volatile.Register32 // 0x0
	MSR   volatile.Register32 // 0x4
	TSR   volatile.Register32 // 0x8
	RF0R  volatile.Register32 // 0xC
	RF1R  volatile.Register32 // 0x10
	IER   volatile.Register32 // 0x14
	ESR   volatile.Register32 // 0x18
	BTR   volatile.Register32 // 0x1C
	_     [352]byte
	TX    [3]CAN_TX_Type // 0x180
	RX    [2]CAN_RX_Type // 0x1B0
	_     [48]byte
	FMR   volatile.Register32 // 0x200
	FM1R  volatile.Register32 // 0x204
	_     [4]byte
	FS1R  volatile.Register32 // 0x20C
	_     [4]byte
	FFA1R volatile.Register32 // 0x214
	_     [4]byte
	FA1R  volatile.Register32 // 0x21C
	_     [32]byte
	FB    [28]CAN_FB_Type // 0x240
}

// CAN.MCR: master control register
func (o *CAN_Type) SetMCR_DBF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetMCR_DBF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetMCR_RESET(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetMCR_RESET() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetMCR_TTCM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetMCR_TTCM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetMCR_ABOM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetMCR_ABOM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetMCR_AWUM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetMCR_AWUM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetMCR_NART(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetMCR_NART() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetMCR_RFLM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetMCR_RFLM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetMCR_TXFP(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetMCR_TXFP() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetMCR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetMCR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetMCR_INRQ(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetMCR_INRQ() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}

// CAN.MSR: master status register
func (o *CAN_Type) SetMSR_RX(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetMSR_RX() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetMSR_SAMP(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetMSR_SAMP() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetMSR_RXM(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetMSR_RXM() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetMSR_TXM(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetMSR_TXM() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetMSR_SLAKI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetMSR_SLAKI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetMSR_WKUI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetMSR_WKUI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetMSR_ERRI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetMSR_ERRI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetMSR_SLAK(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetMSR_SLAK() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetMSR_INAK(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetMSR_INAK() uint32 {
	return volatile.LoadUint32(&o.MSR.Reg) & 0x1
}

// CAN.TSR: transmit status register
func (o *CAN_Type) SetTSR_LOW2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetTSR_LOW2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80000000) >> 31
}
func (o *CAN_Type) SetTSR_LOW1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetTSR_LOW1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetTSR_LOW0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetTSR_LOW0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20000000) >> 29
}
func (o *CAN_Type) SetTSR_TME2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN_Type) GetTSR_TME2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10000000) >> 28
}
func (o *CAN_Type) SetTSR_TME1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetTSR_TME1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8000000) >> 27
}
func (o *CAN_Type) SetTSR_TME0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetTSR_TME0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetTSR_CODE(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x3000000)|value<<24)
}
func (o *CAN_Type) GetTSR_CODE() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x3000000) >> 24
}
func (o *CAN_Type) SetTSR_ABRQ2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetTSR_ABRQ2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetTSR_TERR2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetTSR_TERR2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetTSR_ALST2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetTSR_ALST2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetTSR_TXOK2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetTSR_TXOK2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetTSR_RQCP2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetTSR_RQCP2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetTSR_ABRQ1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetTSR_ABRQ1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetTSR_TERR1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetTSR_TERR1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetTSR_ALST1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetTSR_ALST1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetTSR_TXOK1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetTSR_TXOK1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetTSR_RQCP1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetTSR_RQCP1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetTSR_ABRQ0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetTSR_ABRQ0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetTSR_TERR0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetTSR_TERR0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetTSR_ALST0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetTSR_ALST0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetTSR_TXOK0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetTSR_TXOK0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetTSR_RQCP0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetTSR_RQCP0() uint32 {
	return volatile.LoadUint32(&o.TSR.Reg) & 0x1
}

// CAN.RF0R: receive FIFO %s register
func (o *CAN_Type) SetRF0R_RFOM(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetRF0R_RFOM() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetRF0R_FOVR(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetRF0R_FOVR() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetRF0R_FULL(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetRF0R_FULL() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetRF0R_FMP(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x3)|value)
}
func (o *CAN_Type) GetRF0R_FMP() uint32 {
	return volatile.LoadUint32(&o.RF0R.Reg) & 0x3
}

// CAN.RF1R: receive FIFO %s register
func (o *CAN_Type) SetRF1R_RFOM(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetRF1R_RFOM() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetRF1R_FOVR(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetRF1R_FOVR() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetRF1R_FULL(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetRF1R_FULL() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetRF1R_FMP(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x3)|value)
}
func (o *CAN_Type) GetRF1R_FMP() uint32 {
	return volatile.LoadUint32(&o.RF1R.Reg) & 0x3
}

// CAN.IER: interrupt enable register
func (o *CAN_Type) SetIER_SLKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetIER_SLKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetIER_WKUIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetIER_WKUIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetIER_ERRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetIER_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetIER_LECIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetIER_LECIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetIER_BOFIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetIER_BOFIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetIER_EPVIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetIER_EPVIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetIER_EWGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetIER_EWGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetIER_FOVIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetIER_FOVIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetIER_FFIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetIER_FFIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetIER_FMPIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetIER_FMPIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetIER_FOVIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetIER_FOVIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetIER_FFIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetIER_FFIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetIER_FMPIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetIER_FMPIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetIER_TMEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetIER_TMEIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// CAN.ESR: interrupt enable register
func (o *CAN_Type) SetESR_REC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetESR_REC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0xff000000) >> 24
}
func (o *CAN_Type) SetESR_TEC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_Type) GetESR_TEC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0xff0000) >> 16
}
func (o *CAN_Type) SetESR_LEC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x70)|value<<4)
}
func (o *CAN_Type) GetESR_LEC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x70) >> 4
}
func (o *CAN_Type) SetESR_BOFF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetESR_BOFF() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetESR_EPVF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetESR_EPVF() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetESR_EWGF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetESR_EWGF() uint32 {
	return volatile.LoadUint32(&o.ESR.Reg) & 0x1
}

// CAN.BTR: bit timing register
func (o *CAN_Type) SetBTR_SILM(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetBTR_SILM() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x80000000) >> 31
}
func (o *CAN_Type) SetBTR_LBKM(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetBTR_LBKM() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetBTR_SJW(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x3000000)|value<<24)
}
func (o *CAN_Type) GetBTR_SJW() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x3000000) >> 24
}
func (o *CAN_Type) SetBTR_TS2(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x700000)|value<<20)
}
func (o *CAN_Type) GetBTR_TS2() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x700000) >> 20
}
func (o *CAN_Type) SetBTR_TS1(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetBTR_TS1() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetBTR_BRP(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x3ff)|value)
}
func (o *CAN_Type) GetBTR_BRP() uint32 {
	return volatile.LoadUint32(&o.BTR.Reg) & 0x3ff
}

// CAN.FMR: filter master register
func (o *CAN_Type) SetFMR_CAN2SB(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x3f00)|value<<8)
}
func (o *CAN_Type) GetFMR_CAN2SB() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x3f00) >> 8
}
func (o *CAN_Type) SetFMR_FINIT(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFMR_FINIT() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0x1
}

// CAN.FM1R: filter mode register
func (o *CAN_Type) SetFM1R_FBM0(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFM1R_FBM0() uint32 {
	return volatile.LoadUint32(&o.FM1R.Reg) & 0x1
}
func (o *CAN_Type) SetFM1R_FBM1(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFM1R_FBM1() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFM1R_FBM2(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFM1R_FBM2() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFM1R_FBM3(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFM1R_FBM3() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFM1R_FBM4(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFM1R_FBM4() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFM1R_FBM5(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFM1R_FBM5() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFM1R_FBM6(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFM1R_FBM6() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFM1R_FBM7(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFM1R_FBM7() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFM1R_FBM8(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFM1R_FBM8() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFM1R_FBM9(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFM1R_FBM9() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFM1R_FBM10(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFM1R_FBM10() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFM1R_FBM11(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFM1R_FBM11() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFM1R_FBM12(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFM1R_FBM12() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFM1R_FBM13(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFM1R_FBM13() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFM1R_FBM14(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFM1R_FBM14() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFM1R_FBM15(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFM1R_FBM15() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFM1R_FBM16(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFM1R_FBM16() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFM1R_FBM17(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFM1R_FBM17() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFM1R_FBM18(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFM1R_FBM18() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFM1R_FBM19(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFM1R_FBM19() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFM1R_FBM20(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFM1R_FBM20() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFM1R_FBM21(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFM1R_FBM21() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFM1R_FBM22(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFM1R_FBM22() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFM1R_FBM23(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFM1R_FBM23() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFM1R_FBM24(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFM1R_FBM24() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFM1R_FBM25(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFM1R_FBM25() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFM1R_FBM26(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFM1R_FBM26() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFM1R_FBM27(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFM1R_FBM27() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x8000000) >> 27
}

// CAN.FS1R: filter scale register
func (o *CAN_Type) SetFS1R_FSC0(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFS1R_FSC0() uint32 {
	return volatile.LoadUint32(&o.FS1R.Reg) & 0x1
}
func (o *CAN_Type) SetFS1R_FSC1(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFS1R_FSC1() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFS1R_FSC2(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFS1R_FSC2() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFS1R_FSC3(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFS1R_FSC3() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFS1R_FSC4(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFS1R_FSC4() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFS1R_FSC5(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFS1R_FSC5() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFS1R_FSC6(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFS1R_FSC6() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFS1R_FSC7(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFS1R_FSC7() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFS1R_FSC8(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFS1R_FSC8() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFS1R_FSC9(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFS1R_FSC9() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFS1R_FSC10(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFS1R_FSC10() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFS1R_FSC11(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFS1R_FSC11() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFS1R_FSC12(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFS1R_FSC12() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFS1R_FSC13(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFS1R_FSC13() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFS1R_FSC14(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFS1R_FSC14() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFS1R_FSC15(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFS1R_FSC15() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFS1R_FSC16(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFS1R_FSC16() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFS1R_FSC17(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFS1R_FSC17() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFS1R_FSC18(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFS1R_FSC18() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFS1R_FSC19(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFS1R_FSC19() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFS1R_FSC20(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFS1R_FSC20() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFS1R_FSC21(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFS1R_FSC21() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFS1R_FSC22(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFS1R_FSC22() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFS1R_FSC23(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFS1R_FSC23() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFS1R_FSC24(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFS1R_FSC24() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFS1R_FSC25(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFS1R_FSC25() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFS1R_FSC26(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFS1R_FSC26() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFS1R_FSC27(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFS1R_FSC27() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x8000000) >> 27
}

// CAN.FFA1R: filter FIFO assignment register
func (o *CAN_Type) SetFFA1R_FFA0(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFFA1R_FFA0() uint32 {
	return volatile.LoadUint32(&o.FFA1R.Reg) & 0x1
}
func (o *CAN_Type) SetFFA1R_FFA1(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFFA1R_FFA1() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFFA1R_FFA2(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFFA1R_FFA2() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFFA1R_FFA3(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFFA1R_FFA3() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFFA1R_FFA4(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFFA1R_FFA4() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFFA1R_FFA5(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFFA1R_FFA5() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFFA1R_FFA6(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFFA1R_FFA6() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFFA1R_FFA7(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFFA1R_FFA7() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFFA1R_FFA8(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFFA1R_FFA8() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFFA1R_FFA9(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFFA1R_FFA9() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFFA1R_FFA10(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFFA1R_FFA10() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFFA1R_FFA11(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFFA1R_FFA11() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFFA1R_FFA12(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFFA1R_FFA12() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFFA1R_FFA13(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFFA1R_FFA13() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFFA1R_FFA14(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFFA1R_FFA14() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFFA1R_FFA15(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFFA1R_FFA15() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFFA1R_FFA16(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFFA1R_FFA16() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFFA1R_FFA17(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFFA1R_FFA17() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFFA1R_FFA18(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFFA1R_FFA18() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFFA1R_FFA19(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFFA1R_FFA19() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFFA1R_FFA20(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFFA1R_FFA20() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFFA1R_FFA21(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFFA1R_FFA21() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFFA1R_FFA22(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFFA1R_FFA22() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFFA1R_FFA23(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFFA1R_FFA23() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFFA1R_FFA24(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFFA1R_FFA24() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFFA1R_FFA25(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFFA1R_FFA25() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFFA1R_FFA26(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFFA1R_FFA26() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFFA1R_FFA27(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFFA1R_FFA27() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x8000000) >> 27
}

// CAN.FA1R: filter activation register
func (o *CAN_Type) SetFA1R_FACT0(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFA1R_FACT0() uint32 {
	return volatile.LoadUint32(&o.FA1R.Reg) & 0x1
}
func (o *CAN_Type) SetFA1R_FACT1(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFA1R_FACT1() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFA1R_FACT2(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFA1R_FACT2() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFA1R_FACT3(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFA1R_FACT3() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFA1R_FACT4(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFA1R_FACT4() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFA1R_FACT5(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFA1R_FACT5() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFA1R_FACT6(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFA1R_FACT6() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFA1R_FACT7(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFA1R_FACT7() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFA1R_FACT8(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFA1R_FACT8() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFA1R_FACT9(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFA1R_FACT9() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFA1R_FACT10(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFA1R_FACT10() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFA1R_FACT11(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFA1R_FACT11() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFA1R_FACT12(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFA1R_FACT12() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFA1R_FACT13(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFA1R_FACT13() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFA1R_FACT14(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFA1R_FACT14() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFA1R_FACT15(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFA1R_FACT15() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFA1R_FACT16(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFA1R_FACT16() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFA1R_FACT17(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFA1R_FACT17() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFA1R_FACT18(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFA1R_FACT18() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFA1R_FACT19(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFA1R_FACT19() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFA1R_FACT20(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFA1R_FACT20() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFA1R_FACT21(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFA1R_FACT21() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFA1R_FACT22(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFA1R_FACT22() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFA1R_FACT23(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFA1R_FACT23() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFA1R_FACT24(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFA1R_FACT24() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFA1R_FACT25(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFA1R_FACT25() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFA1R_FACT26(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFA1R_FACT26() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFA1R_FACT27(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFA1R_FACT27() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x8000000) >> 27
}

type CAN_TX_Type struct {
	TIR  volatile.Register32 // 0x180
	TDTR volatile.Register32 // 0x184
	TDLR volatile.Register32 // 0x188
	TDHR volatile.Register32 // 0x18C
}

// CAN_TX.TIR: TX mailbox identifier register
func (o *CAN_TX_Type) SetTIR_STID(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0xffe00000)|value<<21)
}
func (o *CAN_TX_Type) GetTIR_STID() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0xffe00000) >> 21
}
func (o *CAN_TX_Type) SetTIR_EXID(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x1ffff8)|value<<3)
}
func (o *CAN_TX_Type) GetTIR_EXID() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x1ffff8) >> 3
}
func (o *CAN_TX_Type) SetTIR_IDE(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_TX_Type) GetTIR_IDE() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x4) >> 2
}
func (o *CAN_TX_Type) SetTIR_RTR(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_TX_Type) GetTIR_RTR() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x2) >> 1
}
func (o *CAN_TX_Type) SetTIR_TXRQ(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x1)|value)
}
func (o *CAN_TX_Type) GetTIR_TXRQ() uint32 {
	return volatile.LoadUint32(&o.TIR.Reg) & 0x1
}

// CAN_TX.TDTR: mailbox data length control and time stamp register
func (o *CAN_TX_Type) SetTDTR_TIME(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDTR_TIME() uint32 {
	return (volatile.LoadUint32(&o.TDTR.Reg) & 0xffff0000) >> 16
}
func (o *CAN_TX_Type) SetTDTR_TGT(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_TX_Type) GetTDTR_TGT() uint32 {
	return (volatile.LoadUint32(&o.TDTR.Reg) & 0x100) >> 8
}
func (o *CAN_TX_Type) SetTDTR_DLC(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0xf)|value)
}
func (o *CAN_TX_Type) GetTDTR_DLC() uint32 {
	return volatile.LoadUint32(&o.TDTR.Reg) & 0xf
}

// CAN_TX.TDLR: mailbox data low register
func (o *CAN_TX_Type) SetTDLR_DATA3(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_TX_Type) GetTDLR_DATA3() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff000000) >> 24
}
func (o *CAN_TX_Type) SetTDLR_DATA2(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDLR_DATA2() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff0000) >> 16
}
func (o *CAN_TX_Type) SetTDLR_DATA1(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_TX_Type) GetTDLR_DATA1() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff00) >> 8
}
func (o *CAN_TX_Type) SetTDLR_DATA0(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff)|value)
}
func (o *CAN_TX_Type) GetTDLR_DATA0() uint32 {
	return volatile.LoadUint32(&o.TDLR.Reg) & 0xff
}

// CAN_TX.TDHR: mailbox data high register
func (o *CAN_TX_Type) SetTDHR_DATA7(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_TX_Type) GetTDHR_DATA7() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff000000) >> 24
}
func (o *CAN_TX_Type) SetTDHR_DATA6(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDHR_DATA6() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff0000) >> 16
}
func (o *CAN_TX_Type) SetTDHR_DATA5(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_TX_Type) GetTDHR_DATA5() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff00) >> 8
}
func (o *CAN_TX_Type) SetTDHR_DATA4(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff)|value)
}
func (o *CAN_TX_Type) GetTDHR_DATA4() uint32 {
	return volatile.LoadUint32(&o.TDHR.Reg) & 0xff
}

type CAN_RX_Type struct {
	RIR  volatile.Register32 // 0x1B0
	RDTR volatile.Register32 // 0x1B4
	RDLR volatile.Register32 // 0x1B8
	RDHR volatile.Register32 // 0x1BC
}

// CAN_RX.RIR: receive FIFO mailbox identifier register
func (o *CAN_RX_Type) SetRIR_STID(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0xffe00000)|value<<21)
}
func (o *CAN_RX_Type) GetRIR_STID() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0xffe00000) >> 21
}
func (o *CAN_RX_Type) SetRIR_EXID(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x1ffff8)|value<<3)
}
func (o *CAN_RX_Type) GetRIR_EXID() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x1ffff8) >> 3
}
func (o *CAN_RX_Type) SetRIR_IDE(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_RX_Type) GetRIR_IDE() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x4) >> 2
}
func (o *CAN_RX_Type) SetRIR_RTR(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_RX_Type) GetRIR_RTR() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x2) >> 1
}

// CAN_RX.RDTR: mailbox data high register
func (o *CAN_RX_Type) SetRDTR_TIME(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDTR_TIME() uint32 {
	return (volatile.LoadUint32(&o.RDTR.Reg) & 0xffff0000) >> 16
}
func (o *CAN_RX_Type) SetRDTR_FMI(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDTR_FMI() uint32 {
	return (volatile.LoadUint32(&o.RDTR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDTR_DLC(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xf)|value)
}
func (o *CAN_RX_Type) GetRDTR_DLC() uint32 {
	return volatile.LoadUint32(&o.RDTR.Reg) & 0xf
}

// CAN_RX.RDLR: mailbox data high register
func (o *CAN_RX_Type) SetRDLR_DATA3(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_RX_Type) GetRDLR_DATA3() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff000000) >> 24
}
func (o *CAN_RX_Type) SetRDLR_DATA2(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDLR_DATA2() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff0000) >> 16
}
func (o *CAN_RX_Type) SetRDLR_DATA1(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDLR_DATA1() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDLR_DATA0(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff)|value)
}
func (o *CAN_RX_Type) GetRDLR_DATA0() uint32 {
	return volatile.LoadUint32(&o.RDLR.Reg) & 0xff
}

// CAN_RX.RDHR: receive FIFO mailbox data high register
func (o *CAN_RX_Type) SetRDHR_DATA7(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_RX_Type) GetRDHR_DATA7() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff000000) >> 24
}
func (o *CAN_RX_Type) SetRDHR_DATA6(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDHR_DATA6() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff0000) >> 16
}
func (o *CAN_RX_Type) SetRDHR_DATA5(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDHR_DATA5() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDHR_DATA4(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff)|value)
}
func (o *CAN_RX_Type) GetRDHR_DATA4() uint32 {
	return volatile.LoadUint32(&o.RDHR.Reg) & 0xff
}

type CAN_FB_Type struct {
	FR1 volatile.Register32 // 0x240
	FR2 volatile.Register32 // 0x244
}

// CAN_FB.FR1: Filter bank 0 register 1
func (o *CAN_FB_Type) SetFR1(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, value)
}
func (o *CAN_FB_Type) GetFR1() uint32 {
	return volatile.LoadUint32(&o.FR1.Reg)
}

// CAN_FB.FR2: Filter bank 0 register 2
func (o *CAN_FB_Type) SetFR2(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, value)
}
func (o *CAN_FB_Type) GetFR2() uint32 {
	return volatile.LoadUint32(&o.FR2.Reg)
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	OAR1  volatile.Register32 // 0x8
	OAR2  volatile.Register32 // 0xC
	DR    volatile.Register32 // 0x10
	SR1   volatile.Register32 // 0x14
	SR2   volatile.Register32 // 0x18
	CCR   volatile.Register32 // 0x1C
	TRISE volatile.Register32 // 0x20
}

// I2C.CR1: Control register 1
func (o *I2C_Type) SetCR1_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR1_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR1_ALERT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCR1_ALERT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCR1_PEC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR1_PEC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR1_POS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR1_POS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR1_ACK(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR1_ACK() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR1_STOP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetCR1_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetCR1_START(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetCR1_START() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetCR1_NOSTRETCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCR1_NOSTRETCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCR1_ENGC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCR1_ENGC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCR1_ENPEC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCR1_ENPEC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCR1_ENARP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCR1_ENARP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCR1_SMBTYPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCR1_SMBTYPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCR1_SMBUS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCR1_SMBUS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCR1_PE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCR1_PE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// I2C.CR2: Control register 2
func (o *I2C_Type) SetCR2_LAST(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR2_LAST() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR2_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR2_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR2_ITBUFEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR2_ITBUFEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR2_ITEVTEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetCR2_ITEVTEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetCR2_ITERREN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetCR2_ITERREN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetCR2_FREQ(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3f)|value)
}
func (o *I2C_Type) GetCR2_FREQ() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x3f
}

// I2C.OAR1: Own address register 1
func (o *I2C_Type) SetOAR1_ADDMODE(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR1_ADDMODE() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetOAR1_ADD(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetOAR1_ADD() uint32 {
	return volatile.LoadUint32(&o.OAR1.Reg) & 0x3ff
}

// I2C.OAR2: Own address register 2
func (o *I2C_Type) SetOAR2_ADD2(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetOAR2_ADD2() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetOAR2_ENDUAL(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetOAR2_ENDUAL() uint32 {
	return volatile.LoadUint32(&o.OAR2.Reg) & 0x1
}

// I2C.DR: Data register
func (o *I2C_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xff
}

// I2C.SR1: Status register 1
func (o *I2C_Type) SetSR1_SMBALERT(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetSR1_SMBALERT() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetSR1_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetSR1_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetSR1_PECERR(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetSR1_PECERR() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetSR1_OVR(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetSR1_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetSR1_AF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetSR1_AF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetSR1_ARLO(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetSR1_ARLO() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetSR1_BERR(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetSR1_BERR() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetSR1_TxE(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetSR1_TxE() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetSR1_RxNE(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetSR1_RxNE() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetSR1_STOPF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSR1_STOPF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetSR1_ADD10(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetSR1_ADD10() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetSR1_BTF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetSR1_BTF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetSR1_ADDR(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetSR1_ADDR() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetSR1_SB(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSR1_SB() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}

// I2C.SR2: Status register 2
func (o *I2C_Type) SetSR2_PEC(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetSR2_PEC() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetSR2_DUALF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetSR2_DUALF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetSR2_SMBHOST(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetSR2_SMBHOST() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetSR2_SMBDEFAULT(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetSR2_SMBDEFAULT() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetSR2_GENCALL(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSR2_GENCALL() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetSR2_TRA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetSR2_TRA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetSR2_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetSR2_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetSR2_MSL(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSR2_MSL() uint32 {
	return volatile.LoadUint32(&o.SR2.Reg) & 0x1
}

// I2C.CCR: Clock control register
func (o *I2C_Type) SetCCR_F_S(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCCR_F_S() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCCR_DUTY(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCCR_DUTY() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCCR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xfff)|value)
}
func (o *I2C_Type) GetCCR() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0xfff
}

// I2C.TRISE: TRISE register
func (o *I2C_Type) SetTRISE(value uint32) {
	volatile.StoreUint32(&o.TRISE.Reg, volatile.LoadUint32(&o.TRISE.Reg)&^(0x3f)|value)
}
func (o *I2C_Type) GetTRISE() uint32 {
	return volatile.LoadUint32(&o.TRISE.Reg) & 0x3f
}

// Independent watchdog
type IWDG_Type struct {
	KR  volatile.Register32 // 0x0
	PR  volatile.Register32 // 0x4
	RLR volatile.Register32 // 0x8
	SR  volatile.Register32 // 0xC
}

// IWDG.KR: Key register
func (o *IWDG_Type) SetKR_KEY(value uint32) {
	volatile.StoreUint32(&o.KR.Reg, volatile.LoadUint32(&o.KR.Reg)&^(0xffff)|value)
}
func (o *IWDG_Type) GetKR_KEY() uint32 {
	return volatile.LoadUint32(&o.KR.Reg) & 0xffff
}

// IWDG.PR: Prescaler register
func (o *IWDG_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x7)|value)
}
func (o *IWDG_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x7
}

// IWDG.RLR: Reload register
func (o *IWDG_Type) SetRLR_RL(value uint32) {
	volatile.StoreUint32(&o.RLR.Reg, volatile.LoadUint32(&o.RLR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetRLR_RL() uint32 {
	return volatile.LoadUint32(&o.RLR.Reg) & 0xfff
}

// IWDG.SR: Status register
func (o *IWDG_Type) SetSR_RVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *IWDG_Type) GetSR_RVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *IWDG_Type) SetSR_PVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *IWDG_Type) GetSR_PVU() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// WWDG.CR: Control register
func (o *WWDG_Type) SetCR_WDGA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *WWDG_Type) GetCR_WDGA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *WWDG_Type) SetCR_T(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCR_T() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7f
}

// WWDG.CFR: Configuration register
func (o *WWDG_Type) SetCFR_EWI(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *WWDG_Type) GetCFR_EWI() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *WWDG_Type) SetCFR_W(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCFR_W() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x7f
}
func (o *WWDG_Type) SetCFR_WDGTB(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x180)|value<<7)
}
func (o *WWDG_Type) GetCFR_WDGTB() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x180) >> 7
}

// WWDG.SR: Status register
func (o *WWDG_Type) SetSR_EWIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *WWDG_Type) GetSR_EWIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Real-time clock
type RTC_Type struct {
	TR     volatile.Register32 // 0x0
	DR     volatile.Register32 // 0x4
	CR     volatile.Register32 // 0x8
	ISR    volatile.Register32 // 0xC
	PRER   volatile.Register32 // 0x10
	WUTR   volatile.Register32 // 0x14
	CALIBR volatile.Register32 // 0x18
	ALRMAR volatile.Register32 // 0x1C
	ALRMBR volatile.Register32 // 0x20
	WPR    volatile.Register32 // 0x24
	_      [8]byte
	TSTR   volatile.Register32 // 0x30
	TSDR   volatile.Register32 // 0x34
	_      [8]byte
	TAFCR  volatile.Register32 // 0x40
	_      [12]byte
	BKP0R  volatile.Register32 // 0x50
	BKP1R  volatile.Register32 // 0x54
	BKP2R  volatile.Register32 // 0x58
	BKP3R  volatile.Register32 // 0x5C
	BKP4R  volatile.Register32 // 0x60
	BKP5R  volatile.Register32 // 0x64
	BKP6R  volatile.Register32 // 0x68
	BKP7R  volatile.Register32 // 0x6C
	BKP8R  volatile.Register32 // 0x70
	BKP9R  volatile.Register32 // 0x74
	BKP10R volatile.Register32 // 0x78
	BKP11R volatile.Register32 // 0x7C
	BKP12R volatile.Register32 // 0x80
	BKP13R volatile.Register32 // 0x84
	BKP14R volatile.Register32 // 0x88
	BKP15R volatile.Register32 // 0x8C
	BKP16R volatile.Register32 // 0x90
	BKP17R volatile.Register32 // 0x94
	BKP18R volatile.Register32 // 0x98
	BKP19R volatile.Register32 // 0x9C
}

// RTC.TR: time register
func (o *RTC_Type) SetTR_PM(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTR_HT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTR_HU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTR_ST(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTR_SU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTR_SU() uint32 {
	return volatile.LoadUint32(&o.TR.Reg) & 0xf
}

// RTC.DR: date register
func (o *RTC_Type) SetDR_YT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00000)|value<<20)
}
func (o *RTC_Type) GetDR_YT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00000) >> 20
}
func (o *RTC_Type) SetDR_YU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetDR_YU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetDR_WDU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetDR_MT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetDR_MT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetDR_MU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetDR_MU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetDR_DT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetDR_DT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetDR_DU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetDR_DU() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xf
}

// RTC.CR: control register
func (o *RTC_Type) SetCR_COE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetCR_COE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetCR_OSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *RTC_Type) GetCR_OSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *RTC_Type) SetCR_POL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetCR_POL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetCR_BKP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetCR_BKP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetCR_SUB1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetCR_SUB1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetCR_ADD1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetCR_ADD1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetCR_TSIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCR_TSIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCR_WUTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCR_WUTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCR_ALRBIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCR_ALRBIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCR_ALRAIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCR_ALRAIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCR_TSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetCR_TSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetCR_WUTE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetCR_WUTE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetCR_ALRBE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetCR_ALRBE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetCR_ALRAE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetCR_ALRAE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetCR_DCE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetCR_DCE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetCR_FMT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCR_FMT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCR_REFCKON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCR_REFCKON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCR_TSEDGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCR_TSEDGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCR_WUCKSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetCR_WUCKSEL() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7
}

// RTC.ISR: initialization and status register
func (o *RTC_Type) SetISR_TAMP1F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetISR_TAMP1F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetISR_TSOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetISR_TSOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetISR_TSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetISR_TSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetISR_WUTF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetISR_WUTF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetISR_ALRBF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetISR_ALRBF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetISR_ALRAF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetISR_ALRAF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetISR_INIT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetISR_INIT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetISR_INITF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetISR_INITF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetISR_RSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetISR_RSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetISR_INITS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetISR_INITS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetISR_WUTWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetISR_WUTWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetISR_ALRBWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetISR_ALRBWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetISR_ALRAWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetISR_ALRAWF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// RTC.PRER: prescaler register
func (o *RTC_Type) SetPRER_PREDIV_A(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7f0000)|value<<16)
}
func (o *RTC_Type) GetPRER_PREDIV_A() uint32 {
	return (volatile.LoadUint32(&o.PRER.Reg) & 0x7f0000) >> 16
}
func (o *RTC_Type) SetPRER_PREDIV_S(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x1fff)|value)
}
func (o *RTC_Type) GetPRER_PREDIV_S() uint32 {
	return volatile.LoadUint32(&o.PRER.Reg) & 0x1fff
}

// RTC.WUTR: wakeup timer register
func (o *RTC_Type) SetWUTR_WUT(value uint32) {
	volatile.StoreUint32(&o.WUTR.Reg, volatile.LoadUint32(&o.WUTR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetWUTR_WUT() uint32 {
	return volatile.LoadUint32(&o.WUTR.Reg) & 0xffff
}

// RTC.CALIBR: calibration register
func (o *RTC_Type) SetCALIBR_DCS(value uint32) {
	volatile.StoreUint32(&o.CALIBR.Reg, volatile.LoadUint32(&o.CALIBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetCALIBR_DCS() uint32 {
	return (volatile.LoadUint32(&o.CALIBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetCALIBR_DC(value uint32) {
	volatile.StoreUint32(&o.CALIBR.Reg, volatile.LoadUint32(&o.CALIBR.Reg)&^(0x1f)|value)
}
func (o *RTC_Type) GetCALIBR_DC() uint32 {
	return volatile.LoadUint32(&o.CALIBR.Reg) & 0x1f
}

// RTC.ALRMAR: alarm A register
func (o *RTC_Type) SetALRMAR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMAR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMAR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMAR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMAR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMAR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMAR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMAR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMAR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMAR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMAR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMAR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMAR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMAR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMAR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMAR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMAR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMAR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMAR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMAR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMAR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMAR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMAR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMAR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMAR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMAR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMAR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMAR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf
}

// RTC.ALRMBR: alarm B register
func (o *RTC_Type) SetALRMBR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMBR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMBR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMBR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMBR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMBR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMBR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMBR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMBR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMBR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMBR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMBR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMBR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMBR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMBR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMBR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMBR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMBR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMBR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMBR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMBR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMBR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMBR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMBR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMBR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMBR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf
}

// RTC.WPR: write protection register
func (o *RTC_Type) SetWPR_KEY(value uint32) {
	volatile.StoreUint32(&o.WPR.Reg, volatile.LoadUint32(&o.WPR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetWPR_KEY() uint32 {
	return volatile.LoadUint32(&o.WPR.Reg) & 0xff
}

// RTC.TSTR: time stamp time register
func (o *RTC_Type) SetTSTR_SU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSTR_SU() uint32 {
	return volatile.LoadUint32(&o.TSTR.Reg) & 0xf
}
func (o *RTC_Type) SetTSTR_ST(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTSTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTSTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTSTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTSTR_HU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTSTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTSTR_HT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTSTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTSTR_PM(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTSTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x400000) >> 22
}

// RTC.TSDR: time stamp date register
func (o *RTC_Type) SetTSDR_WDU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetTSDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetTSDR_MT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetTSDR_MT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetTSDR_MU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSDR_MU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSDR_DT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetTSDR_DT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetTSDR_DU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSDR_DU() uint32 {
	return volatile.LoadUint32(&o.TSDR.Reg) & 0xf
}

// RTC.TAFCR: tamper and alternate function configuration register
func (o *RTC_Type) SetTAFCR_ALARMOUTTYPE(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetTAFCR_ALARMOUTTYPE() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetTAFCR_TSINSEL(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetTAFCR_TSINSEL() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetTAFCR_TAMP1INSEL(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetTAFCR_TAMP1INSEL() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetTAFCR_TAMPIE(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetTAFCR_TAMPIE() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetTAFCR_TAMP1TRG(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetTAFCR_TAMP1TRG() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetTAFCR_TAMP1E(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTAFCR_TAMP1E() uint32 {
	return volatile.LoadUint32(&o.TAFCR.Reg) & 0x1
}

// RTC.BKP0R: backup register
func (o *RTC_Type) SetBKP0R(value uint32) {
	volatile.StoreUint32(&o.BKP0R.Reg, value)
}
func (o *RTC_Type) GetBKP0R() uint32 {
	return volatile.LoadUint32(&o.BKP0R.Reg)
}

// RTC.BKP1R: backup register
func (o *RTC_Type) SetBKP1R(value uint32) {
	volatile.StoreUint32(&o.BKP1R.Reg, value)
}
func (o *RTC_Type) GetBKP1R() uint32 {
	return volatile.LoadUint32(&o.BKP1R.Reg)
}

// RTC.BKP2R: backup register
func (o *RTC_Type) SetBKP2R(value uint32) {
	volatile.StoreUint32(&o.BKP2R.Reg, value)
}
func (o *RTC_Type) GetBKP2R() uint32 {
	return volatile.LoadUint32(&o.BKP2R.Reg)
}

// RTC.BKP3R: backup register
func (o *RTC_Type) SetBKP3R(value uint32) {
	volatile.StoreUint32(&o.BKP3R.Reg, value)
}
func (o *RTC_Type) GetBKP3R() uint32 {
	return volatile.LoadUint32(&o.BKP3R.Reg)
}

// RTC.BKP4R: backup register
func (o *RTC_Type) SetBKP4R(value uint32) {
	volatile.StoreUint32(&o.BKP4R.Reg, value)
}
func (o *RTC_Type) GetBKP4R() uint32 {
	return volatile.LoadUint32(&o.BKP4R.Reg)
}

// RTC.BKP5R: backup register
func (o *RTC_Type) SetBKP5R(value uint32) {
	volatile.StoreUint32(&o.BKP5R.Reg, value)
}
func (o *RTC_Type) GetBKP5R() uint32 {
	return volatile.LoadUint32(&o.BKP5R.Reg)
}

// RTC.BKP6R: backup register
func (o *RTC_Type) SetBKP6R(value uint32) {
	volatile.StoreUint32(&o.BKP6R.Reg, value)
}
func (o *RTC_Type) GetBKP6R() uint32 {
	return volatile.LoadUint32(&o.BKP6R.Reg)
}

// RTC.BKP7R: backup register
func (o *RTC_Type) SetBKP7R(value uint32) {
	volatile.StoreUint32(&o.BKP7R.Reg, value)
}
func (o *RTC_Type) GetBKP7R() uint32 {
	return volatile.LoadUint32(&o.BKP7R.Reg)
}

// RTC.BKP8R: backup register
func (o *RTC_Type) SetBKP8R(value uint32) {
	volatile.StoreUint32(&o.BKP8R.Reg, value)
}
func (o *RTC_Type) GetBKP8R() uint32 {
	return volatile.LoadUint32(&o.BKP8R.Reg)
}

// RTC.BKP9R: backup register
func (o *RTC_Type) SetBKP9R(value uint32) {
	volatile.StoreUint32(&o.BKP9R.Reg, value)
}
func (o *RTC_Type) GetBKP9R() uint32 {
	return volatile.LoadUint32(&o.BKP9R.Reg)
}

// RTC.BKP10R: backup register
func (o *RTC_Type) SetBKP10R(value uint32) {
	volatile.StoreUint32(&o.BKP10R.Reg, value)
}
func (o *RTC_Type) GetBKP10R() uint32 {
	return volatile.LoadUint32(&o.BKP10R.Reg)
}

// RTC.BKP11R: backup register
func (o *RTC_Type) SetBKP11R(value uint32) {
	volatile.StoreUint32(&o.BKP11R.Reg, value)
}
func (o *RTC_Type) GetBKP11R() uint32 {
	return volatile.LoadUint32(&o.BKP11R.Reg)
}

// RTC.BKP12R: backup register
func (o *RTC_Type) SetBKP12R(value uint32) {
	volatile.StoreUint32(&o.BKP12R.Reg, value)
}
func (o *RTC_Type) GetBKP12R() uint32 {
	return volatile.LoadUint32(&o.BKP12R.Reg)
}

// RTC.BKP13R: backup register
func (o *RTC_Type) SetBKP13R(value uint32) {
	volatile.StoreUint32(&o.BKP13R.Reg, value)
}
func (o *RTC_Type) GetBKP13R() uint32 {
	return volatile.LoadUint32(&o.BKP13R.Reg)
}

// RTC.BKP14R: backup register
func (o *RTC_Type) SetBKP14R(value uint32) {
	volatile.StoreUint32(&o.BKP14R.Reg, value)
}
func (o *RTC_Type) GetBKP14R() uint32 {
	return volatile.LoadUint32(&o.BKP14R.Reg)
}

// RTC.BKP15R: backup register
func (o *RTC_Type) SetBKP15R(value uint32) {
	volatile.StoreUint32(&o.BKP15R.Reg, value)
}
func (o *RTC_Type) GetBKP15R() uint32 {
	return volatile.LoadUint32(&o.BKP15R.Reg)
}

// RTC.BKP16R: backup register
func (o *RTC_Type) SetBKP16R(value uint32) {
	volatile.StoreUint32(&o.BKP16R.Reg, value)
}
func (o *RTC_Type) GetBKP16R() uint32 {
	return volatile.LoadUint32(&o.BKP16R.Reg)
}

// RTC.BKP17R: backup register
func (o *RTC_Type) SetBKP17R(value uint32) {
	volatile.StoreUint32(&o.BKP17R.Reg, value)
}
func (o *RTC_Type) GetBKP17R() uint32 {
	return volatile.LoadUint32(&o.BKP17R.Reg)
}

// RTC.BKP18R: backup register
func (o *RTC_Type) SetBKP18R(value uint32) {
	volatile.StoreUint32(&o.BKP18R.Reg, value)
}
func (o *RTC_Type) GetBKP18R() uint32 {
	return volatile.LoadUint32(&o.BKP18R.Reg)
}

// RTC.BKP19R: backup register
func (o *RTC_Type) SetBKP19R(value uint32) {
	volatile.StoreUint32(&o.BKP19R.Reg, value)
}
func (o *RTC_Type) GetBKP19R() uint32 {
	return volatile.LoadUint32(&o.BKP19R.Reg)
}

// Advanced-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
}

// TIM.CR1: control register 1
func (o *TIM_Type) SetCR1_CKD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCR1_CKD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCR1_ARPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR1_ARPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR1_CMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x60)|value<<5)
}
func (o *TIM_Type) GetCR1_CMS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x60) >> 5
}
func (o *TIM_Type) SetCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCR1_OPM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR1_OPM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR1_URS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR1_URS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR1_UDIS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCR1_UDIS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCR1_CEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR1_CEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// TIM.CR2: control register 2
func (o *TIM_Type) SetCR2_OIS4(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetCR2_OIS4() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetCR2_OIS3N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCR2_OIS3N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCR2_OIS3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCR2_OIS3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCR2_OIS2N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCR2_OIS2N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCR2_OIS2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCR2_OIS2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCR2_OIS1N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCR2_OIS1N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCR2_OIS1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCR2_OIS1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCR2_TI1S(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR2_TI1S() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR2_MMS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCR2_MMS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCR2_CCDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR2_CCDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR2_CCUS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR2_CCUS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR2_CCPC(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR2_CCPC() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// TIM.SMCR: slave mode control register
func (o *TIM_Type) SetSMCR_ETP(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetSMCR_ETP() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetSMCR_ECE(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetSMCR_ECE() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetSMCR_ETPS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x3000)|value<<12)
}
func (o *TIM_Type) GetSMCR_ETPS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x3000) >> 12
}
func (o *TIM_Type) SetSMCR_ETF(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0xf00)|value<<8)
}
func (o *TIM_Type) GetSMCR_ETF() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0xf00) >> 8
}
func (o *TIM_Type) SetSMCR_MSM(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSMCR_MSM() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSMCR_TS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetSMCR_TS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetSMCR_SMS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x7)|value)
}
func (o *TIM_Type) GetSMCR_SMS() uint32 {
	return volatile.LoadUint32(&o.SMCR.Reg) & 0x7
}

// TIM.DIER: DMA/Interrupt enable register
func (o *TIM_Type) SetDIER_TDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetDIER_TDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetDIER_COMDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetDIER_COMDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetDIER_CC4DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetDIER_CC4DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetDIER_CC3DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetDIER_CC3DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetDIER_CC2DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetDIER_CC2DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetDIER_CC1DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetDIER_CC1DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetDIER_UDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetDIER_UDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetDIER_BIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetDIER_BIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetDIER_TIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetDIER_TIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetDIER_COMIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetDIER_COMIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetDIER_CC4IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetDIER_CC4IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetDIER_CC3IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetDIER_CC3IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetDIER_CC2IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetDIER_CC2IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetDIER_CC1IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetDIER_CC1IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetDIER_UIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetDIER_UIE() uint32 {
	return volatile.LoadUint32(&o.DIER.Reg) & 0x1
}

// TIM.SR: status register
func (o *TIM_Type) SetSR_CC4OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetSR_CC4OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetSR_CC3OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetSR_CC3OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetSR_CC2OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetSR_CC2OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetSR_CC1OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetSR_CC1OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetSR_BIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSR_BIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSR_TIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetSR_TIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetSR_COMIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetSR_COMIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetSR_CC4IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetSR_CC4IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetSR_CC3IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetSR_CC3IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetSR_CC2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetSR_CC2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetSR_CC1IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetSR_CC1IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetSR_UIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetSR_UIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// TIM.EGR: event generation register
func (o *TIM_Type) SetEGR_BG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetEGR_BG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetEGR_TG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetEGR_TG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetEGR_COMG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetEGR_COMG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetEGR_CC4G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetEGR_CC4G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetEGR_CC3G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetEGR_CC3G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetEGR_CC2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetEGR_CC2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetEGR_CC1G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetEGR_CC1G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetEGR_UG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetEGR_UG() uint32 {
	return volatile.LoadUint32(&o.EGR.Reg) & 0x1
}

// TIM.CCMR1_Output: capture/compare mode register (output mode)
func (o *TIM_Type) SetCCMR1_Output_OC2CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR1_Output_OC2CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR1_Output_OC2M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR1_Output_OC2PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR1_Output_OC2PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR1_Output_OC2FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR1_Output_OC2FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR1_Output_CC2S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR1_Output_CC2S() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR1_Output_OC1CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR1_Output_OC1CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR1_Output_OC1M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR1_Output_OC1PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR1_Output_OC1PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR1_Output_OC1FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR1_Output_OC1FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR1_Output_CC1S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR1_Output_CC1S() uint32 {
	return volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x3
}

// TIM.CCMR2_Output: capture/compare mode register (output mode)
func (o *TIM_Type) SetCCMR2_Output_OC4CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR2_Output_OC4CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR2_Output_OC4M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR2_Output_OC4PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR2_Output_OC4PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR2_Output_OC4FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR2_Output_OC4FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR2_Output_CC4S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR2_Output_CC4S() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR2_Output_OC3CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR2_Output_OC3CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR2_Output_OC3M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR2_Output_OC3PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR2_Output_OC3PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR2_Output_OC3FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR2_Output_OC3FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR2_Output_CC3S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR2_Output_CC3S() uint32 {
	return volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x3
}

// TIM.CCER: capture/compare enable register
func (o *TIM_Type) SetCCER_CC4P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCCER_CC4P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCCER_CC4E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCCER_CC4E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCCER_CC3NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCER_CC3NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCER_CC3NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCER_CC3NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCER_CC3P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCCER_CC3P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCCER_CC3E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCCER_CC3E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCCER_CC2NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCER_CC2NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCER_CC2NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetCCER_CC2NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetCCER_CC2P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetCCER_CC2P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetCCER_CC2E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCCER_CC2E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCCER_CC1NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCER_CC1NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCER_CC1NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCER_CC1NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCER_CC1P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCCER_CC1P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCCER_CC1E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCCER_CC1E() uint32 {
	return volatile.LoadUint32(&o.CCER.Reg) & 0x1
}

// TIM.CNT: counter
func (o *TIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// TIM.PSC: prescaler
func (o *TIM_Type) SetPSC(value uint32) {
	volatile.StoreUint32(&o.PSC.Reg, volatile.LoadUint32(&o.PSC.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetPSC() uint32 {
	return volatile.LoadUint32(&o.PSC.Reg) & 0xffff
}

// TIM.ARR: auto-reload register
func (o *TIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// TIM.RCR: repetition counter register
func (o *TIM_Type) SetRCR_REP(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xff)|value)
}
func (o *TIM_Type) GetRCR_REP() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xff
}

// TIM.CCR1: capture/compare register
func (o *TIM_Type) SetCCR1_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR1_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0xffff
}

// TIM.CCR2: capture/compare register
func (o *TIM_Type) SetCCR2_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR2_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0xffff
}

// TIM.CCR3: capture/compare register
func (o *TIM_Type) SetCCR3_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR3_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0xffff
}

// TIM.CCR4: capture/compare register
func (o *TIM_Type) SetCCR4_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR4_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0xffff
}

// TIM.BDTR: break and dead-time register
func (o *TIM_Type) SetBDTR_MOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetBDTR_MOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetBDTR_AOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetBDTR_AOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetBDTR_BKP(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetBDTR_BKP() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetBDTR_BKE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetBDTR_BKE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetBDTR_OSSR(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetBDTR_OSSR() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetBDTR_OSSI(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetBDTR_OSSI() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetBDTR_LOCK(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetBDTR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetBDTR_DTG(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xff)|value)
}
func (o *TIM_Type) GetBDTR_DTG() uint32 {
	return volatile.LoadUint32(&o.BDTR.Reg) & 0xff
}

// TIM.DCR: DMA control register
func (o *TIM_Type) SetDCR_DBL(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f00)|value<<8)
}
func (o *TIM_Type) GetDCR_DBL() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f00) >> 8
}
func (o *TIM_Type) SetDCR_DBA(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f)|value)
}
func (o *TIM_Type) GetDCR_DBA() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1f
}

// TIM.DMAR: DMA address for full transfer
func (o *TIM_Type) SetDMAR_DMAB(value uint32) {
	volatile.StoreUint32(&o.DMAR.Reg, volatile.LoadUint32(&o.DMAR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetDMAR_DMAB() uint32 {
	return volatile.LoadUint32(&o.DMAR.Reg) & 0xffff
}

// Ethernet: media access control (MAC)
type Ethernet_Type struct {
	MACCR     volatile.Register32 // 0x0
	MACFFR    volatile.Register32 // 0x4
	MACHTHR   volatile.Register32 // 0x8
	MACHTLR   volatile.Register32 // 0xC
	MACMIIAR  volatile.Register32 // 0x10
	MACMIIDR  volatile.Register32 // 0x14
	MACFCR    volatile.Register32 // 0x18
	MACVLANTR volatile.Register32 // 0x1C
	_         [8]byte
	MACRWUFFR volatile.Register32 // 0x28
	MACPMTCSR volatile.Register32 // 0x2C
	_         [4]byte
	MACDBGR   volatile.Register32 // 0x34
	MACSR     volatile.Register32 // 0x38
	MACIMR    volatile.Register32 // 0x3C
	MACA0HR   volatile.Register32 // 0x40
	MACA0LR   volatile.Register32 // 0x44
	MACA1HR   volatile.Register32 // 0x48
	MACA1LR   volatile.Register32 // 0x4C
	MACA2HR   volatile.Register32 // 0x50
	MACA2LR   volatile.Register32 // 0x54
	MACA3HR   volatile.Register32 // 0x58
	MACA3LR   volatile.Register32 // 0x5C
}

// Ethernet.MACCR: Ethernet MAC configuration register
func (o *Ethernet_Type) SetMACCR_RE(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACCR_RE() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACCR_TE(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACCR_TE() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACCR_DC(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACCR_DC() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACCR_BL(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x60)|value<<5)
}
func (o *Ethernet_Type) GetMACCR_BL() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x60) >> 5
}
func (o *Ethernet_Type) SetMACCR_APCS(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x80)|value<<7)
}
func (o *Ethernet_Type) GetMACCR_APCS() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x80) >> 7
}
func (o *Ethernet_Type) SetMACCR_RD(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x200)|value<<9)
}
func (o *Ethernet_Type) GetMACCR_RD() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x200) >> 9
}
func (o *Ethernet_Type) SetMACCR_IPCO(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x400)|value<<10)
}
func (o *Ethernet_Type) GetMACCR_IPCO() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x400) >> 10
}
func (o *Ethernet_Type) SetMACCR_DM(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x800)|value<<11)
}
func (o *Ethernet_Type) GetMACCR_DM() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x800) >> 11
}
func (o *Ethernet_Type) SetMACCR_LM(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x1000)|value<<12)
}
func (o *Ethernet_Type) GetMACCR_LM() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x1000) >> 12
}
func (o *Ethernet_Type) SetMACCR_ROD(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x2000)|value<<13)
}
func (o *Ethernet_Type) GetMACCR_ROD() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x2000) >> 13
}
func (o *Ethernet_Type) SetMACCR_FES(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x4000)|value<<14)
}
func (o *Ethernet_Type) GetMACCR_FES() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x4000) >> 14
}
func (o *Ethernet_Type) SetMACCR_CSD(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x10000)|value<<16)
}
func (o *Ethernet_Type) GetMACCR_CSD() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x10000) >> 16
}
func (o *Ethernet_Type) SetMACCR_IFG(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0xe0000)|value<<17)
}
func (o *Ethernet_Type) GetMACCR_IFG() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0xe0000) >> 17
}
func (o *Ethernet_Type) SetMACCR_JD(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x400000)|value<<22)
}
func (o *Ethernet_Type) GetMACCR_JD() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x400000) >> 22
}
func (o *Ethernet_Type) SetMACCR_WD(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x800000)|value<<23)
}
func (o *Ethernet_Type) GetMACCR_WD() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x800000) >> 23
}
func (o *Ethernet_Type) SetMACCR_CSTF(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x2000000)|value<<25)
}
func (o *Ethernet_Type) GetMACCR_CSTF() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x2000000) >> 25
}

// Ethernet.MACFFR: Ethernet MAC frame filter register
func (o *Ethernet_Type) SetMACFFR_PM(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACFFR_PM() uint32 {
	return volatile.LoadUint32(&o.MACFFR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACFFR_HU(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACFFR_HU() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACFFR_HM(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACFFR_HM() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACFFR_DAIF(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACFFR_DAIF() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACFFR_PAM(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACFFR_PAM() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACFFR_BFD(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACFFR_BFD() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACFFR_PCF(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0xc0)|value<<6)
}
func (o *Ethernet_Type) GetMACFFR_PCF() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0xc0) >> 6
}
func (o *Ethernet_Type) SetMACFFR_SAIF(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x100)|value<<8)
}
func (o *Ethernet_Type) GetMACFFR_SAIF() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x100) >> 8
}
func (o *Ethernet_Type) SetMACFFR_SAF(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x200)|value<<9)
}
func (o *Ethernet_Type) GetMACFFR_SAF() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x200) >> 9
}
func (o *Ethernet_Type) SetMACFFR_HPF(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x400)|value<<10)
}
func (o *Ethernet_Type) GetMACFFR_HPF() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x400) >> 10
}
func (o *Ethernet_Type) SetMACFFR_RA(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACFFR_RA() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACHTHR: Ethernet MAC hash table high register
func (o *Ethernet_Type) SetMACHTHR(value uint32) {
	volatile.StoreUint32(&o.MACHTHR.Reg, value)
}
func (o *Ethernet_Type) GetMACHTHR() uint32 {
	return volatile.LoadUint32(&o.MACHTHR.Reg)
}

// Ethernet.MACHTLR: Ethernet MAC hash table low register
func (o *Ethernet_Type) SetMACHTLR(value uint32) {
	volatile.StoreUint32(&o.MACHTLR.Reg, value)
}
func (o *Ethernet_Type) GetMACHTLR() uint32 {
	return volatile.LoadUint32(&o.MACHTLR.Reg)
}

// Ethernet.MACMIIAR: Ethernet MAC MII address register
func (o *Ethernet_Type) SetMACMIIAR_MB(value uint32) {
	volatile.StoreUint32(&o.MACMIIAR.Reg, volatile.LoadUint32(&o.MACMIIAR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACMIIAR_MB() uint32 {
	return volatile.LoadUint32(&o.MACMIIAR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACMIIAR_MW(value uint32) {
	volatile.StoreUint32(&o.MACMIIAR.Reg, volatile.LoadUint32(&o.MACMIIAR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACMIIAR_MW() uint32 {
	return (volatile.LoadUint32(&o.MACMIIAR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACMIIAR_CR(value uint32) {
	volatile.StoreUint32(&o.MACMIIAR.Reg, volatile.LoadUint32(&o.MACMIIAR.Reg)&^(0x1c)|value<<2)
}
func (o *Ethernet_Type) GetMACMIIAR_CR() uint32 {
	return (volatile.LoadUint32(&o.MACMIIAR.Reg) & 0x1c) >> 2
}
func (o *Ethernet_Type) SetMACMIIAR_MR(value uint32) {
	volatile.StoreUint32(&o.MACMIIAR.Reg, volatile.LoadUint32(&o.MACMIIAR.Reg)&^(0x7c0)|value<<6)
}
func (o *Ethernet_Type) GetMACMIIAR_MR() uint32 {
	return (volatile.LoadUint32(&o.MACMIIAR.Reg) & 0x7c0) >> 6
}
func (o *Ethernet_Type) SetMACMIIAR_PA(value uint32) {
	volatile.StoreUint32(&o.MACMIIAR.Reg, volatile.LoadUint32(&o.MACMIIAR.Reg)&^(0xf800)|value<<11)
}
func (o *Ethernet_Type) GetMACMIIAR_PA() uint32 {
	return (volatile.LoadUint32(&o.MACMIIAR.Reg) & 0xf800) >> 11
}

// Ethernet.MACMIIDR: Ethernet MAC MII data register
func (o *Ethernet_Type) SetMACMIIDR_MD(value uint32) {
	volatile.StoreUint32(&o.MACMIIDR.Reg, volatile.LoadUint32(&o.MACMIIDR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACMIIDR_MD() uint32 {
	return volatile.LoadUint32(&o.MACMIIDR.Reg) & 0xffff
}

// Ethernet.MACFCR: Ethernet MAC flow control register
func (o *Ethernet_Type) SetMACFCR_FCB(value uint32) {
	volatile.StoreUint32(&o.MACFCR.Reg, volatile.LoadUint32(&o.MACFCR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACFCR_FCB() uint32 {
	return volatile.LoadUint32(&o.MACFCR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACFCR_TFCE(value uint32) {
	volatile.StoreUint32(&o.MACFCR.Reg, volatile.LoadUint32(&o.MACFCR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACFCR_TFCE() uint32 {
	return (volatile.LoadUint32(&o.MACFCR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACFCR_RFCE(value uint32) {
	volatile.StoreUint32(&o.MACFCR.Reg, volatile.LoadUint32(&o.MACFCR.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACFCR_RFCE() uint32 {
	return (volatile.LoadUint32(&o.MACFCR.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACFCR_UPFD(value uint32) {
	volatile.StoreUint32(&o.MACFCR.Reg, volatile.LoadUint32(&o.MACFCR.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACFCR_UPFD() uint32 {
	return (volatile.LoadUint32(&o.MACFCR.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACFCR_PLT(value uint32) {
	volatile.StoreUint32(&o.MACFCR.Reg, volatile.LoadUint32(&o.MACFCR.Reg)&^(0x30)|value<<4)
}
func (o *Ethernet_Type) GetMACFCR_PLT() uint32 {
	return (volatile.LoadUint32(&o.MACFCR.Reg) & 0x30) >> 4
}
func (o *Ethernet_Type) SetMACFCR_ZQPD(value uint32) {
	volatile.StoreUint32(&o.MACFCR.Reg, volatile.LoadUint32(&o.MACFCR.Reg)&^(0x80)|value<<7)
}
func (o *Ethernet_Type) GetMACFCR_ZQPD() uint32 {
	return (volatile.LoadUint32(&o.MACFCR.Reg) & 0x80) >> 7
}
func (o *Ethernet_Type) SetMACFCR_PT(value uint32) {
	volatile.StoreUint32(&o.MACFCR.Reg, volatile.LoadUint32(&o.MACFCR.Reg)&^(0xffff0000)|value<<16)
}
func (o *Ethernet_Type) GetMACFCR_PT() uint32 {
	return (volatile.LoadUint32(&o.MACFCR.Reg) & 0xffff0000) >> 16
}

// Ethernet.MACVLANTR: Ethernet MAC VLAN tag register
func (o *Ethernet_Type) SetMACVLANTR_VLANTI(value uint32) {
	volatile.StoreUint32(&o.MACVLANTR.Reg, volatile.LoadUint32(&o.MACVLANTR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACVLANTR_VLANTI() uint32 {
	return volatile.LoadUint32(&o.MACVLANTR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACVLANTR_VLANTC(value uint32) {
	volatile.StoreUint32(&o.MACVLANTR.Reg, volatile.LoadUint32(&o.MACVLANTR.Reg)&^(0x10000)|value<<16)
}
func (o *Ethernet_Type) GetMACVLANTR_VLANTC() uint32 {
	return (volatile.LoadUint32(&o.MACVLANTR.Reg) & 0x10000) >> 16
}

// Ethernet.MACPMTCSR: Ethernet MAC PMT control and status register
func (o *Ethernet_Type) SetMACPMTCSR_PD(value uint32) {
	volatile.StoreUint32(&o.MACPMTCSR.Reg, volatile.LoadUint32(&o.MACPMTCSR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACPMTCSR_PD() uint32 {
	return volatile.LoadUint32(&o.MACPMTCSR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACPMTCSR_MPE(value uint32) {
	volatile.StoreUint32(&o.MACPMTCSR.Reg, volatile.LoadUint32(&o.MACPMTCSR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACPMTCSR_MPE() uint32 {
	return (volatile.LoadUint32(&o.MACPMTCSR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACPMTCSR_WFE(value uint32) {
	volatile.StoreUint32(&o.MACPMTCSR.Reg, volatile.LoadUint32(&o.MACPMTCSR.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACPMTCSR_WFE() uint32 {
	return (volatile.LoadUint32(&o.MACPMTCSR.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACPMTCSR_MPR(value uint32) {
	volatile.StoreUint32(&o.MACPMTCSR.Reg, volatile.LoadUint32(&o.MACPMTCSR.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACPMTCSR_MPR() uint32 {
	return (volatile.LoadUint32(&o.MACPMTCSR.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACPMTCSR_WFR(value uint32) {
	volatile.StoreUint32(&o.MACPMTCSR.Reg, volatile.LoadUint32(&o.MACPMTCSR.Reg)&^(0x40)|value<<6)
}
func (o *Ethernet_Type) GetMACPMTCSR_WFR() uint32 {
	return (volatile.LoadUint32(&o.MACPMTCSR.Reg) & 0x40) >> 6
}
func (o *Ethernet_Type) SetMACPMTCSR_GU(value uint32) {
	volatile.StoreUint32(&o.MACPMTCSR.Reg, volatile.LoadUint32(&o.MACPMTCSR.Reg)&^(0x200)|value<<9)
}
func (o *Ethernet_Type) GetMACPMTCSR_GU() uint32 {
	return (volatile.LoadUint32(&o.MACPMTCSR.Reg) & 0x200) >> 9
}
func (o *Ethernet_Type) SetMACPMTCSR_WFFRPR(value uint32) {
	volatile.StoreUint32(&o.MACPMTCSR.Reg, volatile.LoadUint32(&o.MACPMTCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACPMTCSR_WFFRPR() uint32 {
	return (volatile.LoadUint32(&o.MACPMTCSR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACDBGR: Ethernet MAC debug register
func (o *Ethernet_Type) SetMACDBGR_MMRPEA(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACDBGR_MMRPEA() uint32 {
	return volatile.LoadUint32(&o.MACDBGR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACDBGR_MSFRWCS(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACDBGR_MSFRWCS() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACDBGR_RFWRA(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACDBGR_RFWRA() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACDBGR_RFRCS(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACDBGR_RFRCS() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACDBGR_RFFL(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x100)|value<<8)
}
func (o *Ethernet_Type) GetMACDBGR_RFFL() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x100) >> 8
}
func (o *Ethernet_Type) SetMACDBGR_MMTEA(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x10000)|value<<16)
}
func (o *Ethernet_Type) GetMACDBGR_MMTEA() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x10000) >> 16
}
func (o *Ethernet_Type) SetMACDBGR_MTFCS(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x60000)|value<<17)
}
func (o *Ethernet_Type) GetMACDBGR_MTFCS() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x60000) >> 17
}
func (o *Ethernet_Type) SetMACDBGR_MTP(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x80000)|value<<19)
}
func (o *Ethernet_Type) GetMACDBGR_MTP() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x80000) >> 19
}
func (o *Ethernet_Type) SetMACDBGR_TFRS(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x300000)|value<<20)
}
func (o *Ethernet_Type) GetMACDBGR_TFRS() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x300000) >> 20
}
func (o *Ethernet_Type) SetMACDBGR_TFWA(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x400000)|value<<22)
}
func (o *Ethernet_Type) GetMACDBGR_TFWA() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x400000) >> 22
}
func (o *Ethernet_Type) SetMACDBGR_TFNE(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x1000000)|value<<24)
}
func (o *Ethernet_Type) GetMACDBGR_TFNE() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x1000000) >> 24
}
func (o *Ethernet_Type) SetMACDBGR_TFF(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x2000000)|value<<25)
}
func (o *Ethernet_Type) GetMACDBGR_TFF() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x2000000) >> 25
}

// Ethernet.MACSR: Ethernet MAC interrupt status register
func (o *Ethernet_Type) SetMACSR_PMTS(value uint32) {
	volatile.StoreUint32(&o.MACSR.Reg, volatile.LoadUint32(&o.MACSR.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACSR_PMTS() uint32 {
	return (volatile.LoadUint32(&o.MACSR.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACSR_MMCS(value uint32) {
	volatile.StoreUint32(&o.MACSR.Reg, volatile.LoadUint32(&o.MACSR.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACSR_MMCS() uint32 {
	return (volatile.LoadUint32(&o.MACSR.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACSR_MMCRS(value uint32) {
	volatile.StoreUint32(&o.MACSR.Reg, volatile.LoadUint32(&o.MACSR.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACSR_MMCRS() uint32 {
	return (volatile.LoadUint32(&o.MACSR.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACSR_MMCTS(value uint32) {
	volatile.StoreUint32(&o.MACSR.Reg, volatile.LoadUint32(&o.MACSR.Reg)&^(0x40)|value<<6)
}
func (o *Ethernet_Type) GetMACSR_MMCTS() uint32 {
	return (volatile.LoadUint32(&o.MACSR.Reg) & 0x40) >> 6
}
func (o *Ethernet_Type) SetMACSR_TSTS(value uint32) {
	volatile.StoreUint32(&o.MACSR.Reg, volatile.LoadUint32(&o.MACSR.Reg)&^(0x200)|value<<9)
}
func (o *Ethernet_Type) GetMACSR_TSTS() uint32 {
	return (volatile.LoadUint32(&o.MACSR.Reg) & 0x200) >> 9
}

// Ethernet.MACIMR: Ethernet MAC interrupt mask register
func (o *Ethernet_Type) SetMACIMR_PMTIM(value uint32) {
	volatile.StoreUint32(&o.MACIMR.Reg, volatile.LoadUint32(&o.MACIMR.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACIMR_PMTIM() uint32 {
	return (volatile.LoadUint32(&o.MACIMR.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACIMR_TSTIM(value uint32) {
	volatile.StoreUint32(&o.MACIMR.Reg, volatile.LoadUint32(&o.MACIMR.Reg)&^(0x200)|value<<9)
}
func (o *Ethernet_Type) GetMACIMR_TSTIM() uint32 {
	return (volatile.LoadUint32(&o.MACIMR.Reg) & 0x200) >> 9
}

// Ethernet.MACA0HR: Ethernet MAC address 0 high register
func (o *Ethernet_Type) SetMACA0HR_MACA0H(value uint32) {
	volatile.StoreUint32(&o.MACA0HR.Reg, volatile.LoadUint32(&o.MACA0HR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACA0HR_MACA0H() uint32 {
	return volatile.LoadUint32(&o.MACA0HR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACA0HR_MO(value uint32) {
	volatile.StoreUint32(&o.MACA0HR.Reg, volatile.LoadUint32(&o.MACA0HR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACA0HR_MO() uint32 {
	return (volatile.LoadUint32(&o.MACA0HR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACA0LR: Ethernet MAC address 0 low register
func (o *Ethernet_Type) SetMACA0LR(value uint32) {
	volatile.StoreUint32(&o.MACA0LR.Reg, value)
}
func (o *Ethernet_Type) GetMACA0LR() uint32 {
	return volatile.LoadUint32(&o.MACA0LR.Reg)
}

// Ethernet.MACA1HR: Ethernet MAC address 1 high register
func (o *Ethernet_Type) SetMACA1HR_MACA1H(value uint32) {
	volatile.StoreUint32(&o.MACA1HR.Reg, volatile.LoadUint32(&o.MACA1HR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACA1HR_MACA1H() uint32 {
	return volatile.LoadUint32(&o.MACA1HR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACA1HR_MBC(value uint32) {
	volatile.StoreUint32(&o.MACA1HR.Reg, volatile.LoadUint32(&o.MACA1HR.Reg)&^(0x3f000000)|value<<24)
}
func (o *Ethernet_Type) GetMACA1HR_MBC() uint32 {
	return (volatile.LoadUint32(&o.MACA1HR.Reg) & 0x3f000000) >> 24
}
func (o *Ethernet_Type) SetMACA1HR_SA(value uint32) {
	volatile.StoreUint32(&o.MACA1HR.Reg, volatile.LoadUint32(&o.MACA1HR.Reg)&^(0x40000000)|value<<30)
}
func (o *Ethernet_Type) GetMACA1HR_SA() uint32 {
	return (volatile.LoadUint32(&o.MACA1HR.Reg) & 0x40000000) >> 30
}
func (o *Ethernet_Type) SetMACA1HR_AE(value uint32) {
	volatile.StoreUint32(&o.MACA1HR.Reg, volatile.LoadUint32(&o.MACA1HR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACA1HR_AE() uint32 {
	return (volatile.LoadUint32(&o.MACA1HR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACA1LR: Ethernet MAC address1 low register
func (o *Ethernet_Type) SetMACA1LR(value uint32) {
	volatile.StoreUint32(&o.MACA1LR.Reg, value)
}
func (o *Ethernet_Type) GetMACA1LR() uint32 {
	return volatile.LoadUint32(&o.MACA1LR.Reg)
}

// Ethernet.MACA2HR: Ethernet MAC address 2 high register
func (o *Ethernet_Type) SetMACA2HR_MACA2H(value uint32) {
	volatile.StoreUint32(&o.MACA2HR.Reg, volatile.LoadUint32(&o.MACA2HR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACA2HR_MACA2H() uint32 {
	return volatile.LoadUint32(&o.MACA2HR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACA2HR_MBC(value uint32) {
	volatile.StoreUint32(&o.MACA2HR.Reg, volatile.LoadUint32(&o.MACA2HR.Reg)&^(0x3f000000)|value<<24)
}
func (o *Ethernet_Type) GetMACA2HR_MBC() uint32 {
	return (volatile.LoadUint32(&o.MACA2HR.Reg) & 0x3f000000) >> 24
}
func (o *Ethernet_Type) SetMACA2HR_SA(value uint32) {
	volatile.StoreUint32(&o.MACA2HR.Reg, volatile.LoadUint32(&o.MACA2HR.Reg)&^(0x40000000)|value<<30)
}
func (o *Ethernet_Type) GetMACA2HR_SA() uint32 {
	return (volatile.LoadUint32(&o.MACA2HR.Reg) & 0x40000000) >> 30
}
func (o *Ethernet_Type) SetMACA2HR_AE(value uint32) {
	volatile.StoreUint32(&o.MACA2HR.Reg, volatile.LoadUint32(&o.MACA2HR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACA2HR_AE() uint32 {
	return (volatile.LoadUint32(&o.MACA2HR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACA2LR: Ethernet MAC address 2 low register
func (o *Ethernet_Type) SetMACA2LR(value uint32) {
	volatile.StoreUint32(&o.MACA2LR.Reg, value)
}
func (o *Ethernet_Type) GetMACA2LR() uint32 {
	return volatile.LoadUint32(&o.MACA2LR.Reg)
}

// Ethernet.MACA3HR: Ethernet MAC address 3 high register
func (o *Ethernet_Type) SetMACA3HR_MACA3H(value uint32) {
	volatile.StoreUint32(&o.MACA3HR.Reg, volatile.LoadUint32(&o.MACA3HR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACA3HR_MACA3H() uint32 {
	return volatile.LoadUint32(&o.MACA3HR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACA3HR_MBC(value uint32) {
	volatile.StoreUint32(&o.MACA3HR.Reg, volatile.LoadUint32(&o.MACA3HR.Reg)&^(0x3f000000)|value<<24)
}
func (o *Ethernet_Type) GetMACA3HR_MBC() uint32 {
	return (volatile.LoadUint32(&o.MACA3HR.Reg) & 0x3f000000) >> 24
}
func (o *Ethernet_Type) SetMACA3HR_SA(value uint32) {
	volatile.StoreUint32(&o.MACA3HR.Reg, volatile.LoadUint32(&o.MACA3HR.Reg)&^(0x40000000)|value<<30)
}
func (o *Ethernet_Type) GetMACA3HR_SA() uint32 {
	return (volatile.LoadUint32(&o.MACA3HR.Reg) & 0x40000000) >> 30
}
func (o *Ethernet_Type) SetMACA3HR_AE(value uint32) {
	volatile.StoreUint32(&o.MACA3HR.Reg, volatile.LoadUint32(&o.MACA3HR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACA3HR_AE() uint32 {
	return (volatile.LoadUint32(&o.MACA3HR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACA3LR: Ethernet MAC address 3 low register
func (o *Ethernet_Type) SetMACA3LR(value uint32) {
	volatile.StoreUint32(&o.MACA3LR.Reg, value)
}
func (o *Ethernet_Type) GetMACA3LR() uint32 {
	return volatile.LoadUint32(&o.MACA3LR.Reg)
}

// USB on the go full speed
type USB_OTG_FS_Type struct {
	FS_GOTGCTL          volatile.Register32 // 0x0
	FS_GOTGINT          volatile.Register32 // 0x4
	FS_GAHBCFG          volatile.Register32 // 0x8
	FS_GUSBCFG          volatile.Register32 // 0xC
	FS_GRSTCTL          volatile.Register32 // 0x10
	FS_GINTSTS          volatile.Register32 // 0x14
	FS_GINTMSK          volatile.Register32 // 0x18
	FS_GRXSTSR_Device   volatile.Register32 // 0x1C
	_                   [4]byte
	FS_GRXFSIZ          volatile.Register32 // 0x24
	FS_GNPTXFSIZ_Device volatile.Register32 // 0x28
	FS_GNPTXSTS         volatile.Register32 // 0x2C
	_                   [8]byte
	FS_GCCFG            volatile.Register32 // 0x38
	FS_CID              volatile.Register32 // 0x3C
	_                   [192]byte
	FS_HPTXFSIZ         volatile.Register32 // 0x100
	FS_DIEPTXF1         volatile.Register32 // 0x104
	FS_DIEPTXF2         volatile.Register32 // 0x108
	FS_DIEPTXF3         volatile.Register32 // 0x10C
}

// USB_OTG_FS.FS_GOTGCTL: OTG_FS control and status register (OTG_FS_GOTGCTL)
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_SRQSCS(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_SRQSCS() uint32 {
	return volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_SRQ(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_SRQ() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_HNGSCS(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_HNGSCS() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x100) >> 8
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_HNPRQ(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_HNPRQ() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x200) >> 9
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_HSHNPEN(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_HSHNPEN() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x400) >> 10
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_DHNPEN(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_DHNPEN() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x800) >> 11
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_CIDSTS(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_CIDSTS() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_DBCT(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_DBCT() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_ASVLD(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_ASVLD() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_BSVLD(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_BSVLD() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x80000) >> 19
}

// USB_OTG_FS.FS_GOTGINT: OTG_FS interrupt register (OTG_FS_GOTGINT)
func (o *USB_OTG_FS_Type) SetFS_GOTGINT_SEDET(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGINT.Reg, volatile.LoadUint32(&o.FS_GOTGINT.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGINT_SEDET() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGINT.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetFS_GOTGINT_SRSSCHG(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGINT.Reg, volatile.LoadUint32(&o.FS_GOTGINT.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGINT_SRSSCHG() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGINT.Reg) & 0x100) >> 8
}
func (o *USB_OTG_FS_Type) SetFS_GOTGINT_HNSSCHG(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGINT.Reg, volatile.LoadUint32(&o.FS_GOTGINT.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGINT_HNSSCHG() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGINT.Reg) & 0x200) >> 9
}
func (o *USB_OTG_FS_Type) SetFS_GOTGINT_HNGDET(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGINT.Reg, volatile.LoadUint32(&o.FS_GOTGINT.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGINT_HNGDET() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGINT.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetFS_GOTGINT_ADTOCHG(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGINT.Reg, volatile.LoadUint32(&o.FS_GOTGINT.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGINT_ADTOCHG() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGINT.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetFS_GOTGINT_DBCDNE(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGINT.Reg, volatile.LoadUint32(&o.FS_GOTGINT.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGINT_DBCDNE() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGINT.Reg) & 0x80000) >> 19
}

// USB_OTG_FS.FS_GAHBCFG: OTG_FS AHB configuration register (OTG_FS_GAHBCFG)
func (o *USB_OTG_FS_Type) SetFS_GAHBCFG_GINT(value uint32) {
	volatile.StoreUint32(&o.FS_GAHBCFG.Reg, volatile.LoadUint32(&o.FS_GAHBCFG.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GAHBCFG_GINT() uint32 {
	return volatile.LoadUint32(&o.FS_GAHBCFG.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetFS_GAHBCFG_TXFELVL(value uint32) {
	volatile.StoreUint32(&o.FS_GAHBCFG.Reg, volatile.LoadUint32(&o.FS_GAHBCFG.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetFS_GAHBCFG_TXFELVL() uint32 {
	return (volatile.LoadUint32(&o.FS_GAHBCFG.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetFS_GAHBCFG_PTXFELVL(value uint32) {
	volatile.StoreUint32(&o.FS_GAHBCFG.Reg, volatile.LoadUint32(&o.FS_GAHBCFG.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetFS_GAHBCFG_PTXFELVL() uint32 {
	return (volatile.LoadUint32(&o.FS_GAHBCFG.Reg) & 0x100) >> 8
}

// USB_OTG_FS.FS_GUSBCFG: OTG_FS USB configuration register (OTG_FS_GUSBCFG)
func (o *USB_OTG_FS_Type) SetFS_GUSBCFG_TOCAL(value uint32) {
	volatile.StoreUint32(&o.FS_GUSBCFG.Reg, volatile.LoadUint32(&o.FS_GUSBCFG.Reg)&^(0x7)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GUSBCFG_TOCAL() uint32 {
	return volatile.LoadUint32(&o.FS_GUSBCFG.Reg) & 0x7
}
func (o *USB_OTG_FS_Type) SetFS_GUSBCFG_PHYSEL(value uint32) {
	volatile.StoreUint32(&o.FS_GUSBCFG.Reg, volatile.LoadUint32(&o.FS_GUSBCFG.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetFS_GUSBCFG_PHYSEL() uint32 {
	return (volatile.LoadUint32(&o.FS_GUSBCFG.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetFS_GUSBCFG_SRPCAP(value uint32) {
	volatile.StoreUint32(&o.FS_GUSBCFG.Reg, volatile.LoadUint32(&o.FS_GUSBCFG.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetFS_GUSBCFG_SRPCAP() uint32 {
	return (volatile.LoadUint32(&o.FS_GUSBCFG.Reg) & 0x100) >> 8
}
func (o *USB_OTG_FS_Type) SetFS_GUSBCFG_HNPCAP(value uint32) {
	volatile.StoreUint32(&o.FS_GUSBCFG.Reg, volatile.LoadUint32(&o.FS_GUSBCFG.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_FS_Type) GetFS_GUSBCFG_HNPCAP() uint32 {
	return (volatile.LoadUint32(&o.FS_GUSBCFG.Reg) & 0x200) >> 9
}
func (o *USB_OTG_FS_Type) SetFS_GUSBCFG_TRDT(value uint32) {
	volatile.StoreUint32(&o.FS_GUSBCFG.Reg, volatile.LoadUint32(&o.FS_GUSBCFG.Reg)&^(0x3c00)|value<<10)
}
func (o *USB_OTG_FS_Type) GetFS_GUSBCFG_TRDT() uint32 {
	return (volatile.LoadUint32(&o.FS_GUSBCFG.Reg) & 0x3c00) >> 10
}
func (o *USB_OTG_FS_Type) SetFS_GUSBCFG_FHMOD(value uint32) {
	volatile.StoreUint32(&o.FS_GUSBCFG.Reg, volatile.LoadUint32(&o.FS_GUSBCFG.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetFS_GUSBCFG_FHMOD() uint32 {
	return (volatile.LoadUint32(&o.FS_GUSBCFG.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetFS_GUSBCFG_FDMOD(value uint32) {
	volatile.StoreUint32(&o.FS_GUSBCFG.Reg, volatile.LoadUint32(&o.FS_GUSBCFG.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetFS_GUSBCFG_FDMOD() uint32 {
	return (volatile.LoadUint32(&o.FS_GUSBCFG.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetFS_GUSBCFG_CTXPKT(value uint32) {
	volatile.StoreUint32(&o.FS_GUSBCFG.Reg, volatile.LoadUint32(&o.FS_GUSBCFG.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetFS_GUSBCFG_CTXPKT() uint32 {
	return (volatile.LoadUint32(&o.FS_GUSBCFG.Reg) & 0x80000000) >> 31
}

// USB_OTG_FS.FS_GRSTCTL: OTG_FS reset register (OTG_FS_GRSTCTL)
func (o *USB_OTG_FS_Type) SetFS_GRSTCTL_CSRST(value uint32) {
	volatile.StoreUint32(&o.FS_GRSTCTL.Reg, volatile.LoadUint32(&o.FS_GRSTCTL.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GRSTCTL_CSRST() uint32 {
	return volatile.LoadUint32(&o.FS_GRSTCTL.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetFS_GRSTCTL_HSRST(value uint32) {
	volatile.StoreUint32(&o.FS_GRSTCTL.Reg, volatile.LoadUint32(&o.FS_GRSTCTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetFS_GRSTCTL_HSRST() uint32 {
	return (volatile.LoadUint32(&o.FS_GRSTCTL.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetFS_GRSTCTL_FCRST(value uint32) {
	volatile.StoreUint32(&o.FS_GRSTCTL.Reg, volatile.LoadUint32(&o.FS_GRSTCTL.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetFS_GRSTCTL_FCRST() uint32 {
	return (volatile.LoadUint32(&o.FS_GRSTCTL.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetFS_GRSTCTL_RXFFLSH(value uint32) {
	volatile.StoreUint32(&o.FS_GRSTCTL.Reg, volatile.LoadUint32(&o.FS_GRSTCTL.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetFS_GRSTCTL_RXFFLSH() uint32 {
	return (volatile.LoadUint32(&o.FS_GRSTCTL.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetFS_GRSTCTL_TXFFLSH(value uint32) {
	volatile.StoreUint32(&o.FS_GRSTCTL.Reg, volatile.LoadUint32(&o.FS_GRSTCTL.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_FS_Type) GetFS_GRSTCTL_TXFFLSH() uint32 {
	return (volatile.LoadUint32(&o.FS_GRSTCTL.Reg) & 0x20) >> 5
}
func (o *USB_OTG_FS_Type) SetFS_GRSTCTL_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.FS_GRSTCTL.Reg, volatile.LoadUint32(&o.FS_GRSTCTL.Reg)&^(0x7c0)|value<<6)
}
func (o *USB_OTG_FS_Type) GetFS_GRSTCTL_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.FS_GRSTCTL.Reg) & 0x7c0) >> 6
}
func (o *USB_OTG_FS_Type) SetFS_GRSTCTL_AHBIDL(value uint32) {
	volatile.StoreUint32(&o.FS_GRSTCTL.Reg, volatile.LoadUint32(&o.FS_GRSTCTL.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetFS_GRSTCTL_AHBIDL() uint32 {
	return (volatile.LoadUint32(&o.FS_GRSTCTL.Reg) & 0x80000000) >> 31
}

// USB_OTG_FS.FS_GINTSTS: OTG_FS core interrupt register (OTG_FS_GINTSTS)
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_CMOD(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_CMOD() uint32 {
	return volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_MMIS(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_MMIS() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_OTGINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_OTGINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_SOF(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_SOF() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_RXFLVL(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_RXFLVL() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_NPTXFE(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_NPTXFE() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x20) >> 5
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_GINAKEFF(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_GINAKEFF() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_GOUTNAKEFF(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_GOUTNAKEFF() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_ESUSP(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_ESUSP() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x400) >> 10
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_USBSUSP(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_USBSUSP() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x800) >> 11
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_USBRST(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_USBRST() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_ENUMDNE(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_ENUMDNE() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x2000) >> 13
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_ISOODRP(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x4000)|value<<14)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_ISOODRP() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x4000) >> 14
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_EOPF(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_EOPF() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_IEPINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_IEPINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_OEPINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_OEPINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_IISOIXFR(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_IISOIXFR() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_IPXFR_INCOMPISOOUT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_IPXFR_INCOMPISOOUT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_HPRTINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_HPRTINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_HCINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_HCINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x2000000) >> 25
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_PTXFE(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_PTXFE() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_CIDSCHG(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_CIDSCHG() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_DISCINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_DISCINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_SRQINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_SRQINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_WKUPINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_WKUPINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x80000000) >> 31
}

// USB_OTG_FS.FS_GINTMSK: OTG_FS interrupt mask register (OTG_FS_GINTMSK)
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_MMISM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_MMISM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_OTGINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_OTGINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_SOFM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_SOFM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_RXFLVLM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_RXFLVLM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_NPTXFEM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_NPTXFEM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x20) >> 5
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_GINAKEFFM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_GINAKEFFM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_GONAKEFFM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_GONAKEFFM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_ESUSPM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_ESUSPM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x400) >> 10
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_USBSUSPM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_USBSUSPM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x800) >> 11
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_USBRST(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_USBRST() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_ENUMDNEM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_ENUMDNEM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x2000) >> 13
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_ISOODRPM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x4000)|value<<14)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_ISOODRPM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x4000) >> 14
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_EOPFM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_EOPFM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_EPMISM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_EPMISM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_IEPINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_IEPINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_OEPINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_OEPINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_IISOIXFRM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_IISOIXFRM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_IPXFRM_IISOOXFRM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_IPXFRM_IISOOXFRM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_PRTIM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_PRTIM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_HCIM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_HCIM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x2000000) >> 25
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_PTXFEM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_PTXFEM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_CIDSCHGM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_CIDSCHGM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_DISCINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_DISCINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_SRQIM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_SRQIM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_WUIM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_WUIM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x80000000) >> 31
}

// USB_OTG_FS.FS_GRXSTSR_Device: OTG_FS Receive status debug read(Device mode)
func (o *USB_OTG_FS_Type) SetFS_GRXSTSR_Device_EPNUM(value uint32) {
	volatile.StoreUint32(&o.FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg)&^(0xf)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GRXSTSR_Device_EPNUM() uint32 {
	return volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg) & 0xf
}
func (o *USB_OTG_FS_Type) SetFS_GRXSTSR_Device_BCNT(value uint32) {
	volatile.StoreUint32(&o.FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg)&^(0x7ff0)|value<<4)
}
func (o *USB_OTG_FS_Type) GetFS_GRXSTSR_Device_BCNT() uint32 {
	return (volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg) & 0x7ff0) >> 4
}
func (o *USB_OTG_FS_Type) SetFS_GRXSTSR_Device_DPID(value uint32) {
	volatile.StoreUint32(&o.FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg)&^(0x18000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetFS_GRXSTSR_Device_DPID() uint32 {
	return (volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg) & 0x18000) >> 15
}
func (o *USB_OTG_FS_Type) SetFS_GRXSTSR_Device_PKTSTS(value uint32) {
	volatile.StoreUint32(&o.FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg)&^(0x1e0000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetFS_GRXSTSR_Device_PKTSTS() uint32 {
	return (volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg) & 0x1e0000) >> 17
}
func (o *USB_OTG_FS_Type) SetFS_GRXSTSR_Device_FRMNUM(value uint32) {
	volatile.StoreUint32(&o.FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg)&^(0x1e00000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetFS_GRXSTSR_Device_FRMNUM() uint32 {
	return (volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg) & 0x1e00000) >> 21
}

// USB_OTG_FS.FS_GRXFSIZ: OTG_FS Receive FIFO size register (OTG_FS_GRXFSIZ)
func (o *USB_OTG_FS_Type) SetFS_GRXFSIZ_RXFD(value uint32) {
	volatile.StoreUint32(&o.FS_GRXFSIZ.Reg, volatile.LoadUint32(&o.FS_GRXFSIZ.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GRXFSIZ_RXFD() uint32 {
	return volatile.LoadUint32(&o.FS_GRXFSIZ.Reg) & 0xffff
}

// USB_OTG_FS.FS_GNPTXFSIZ_Device: OTG_FS non-periodic transmit FIFO size register (Device mode)
func (o *USB_OTG_FS_Type) SetFS_GNPTXFSIZ_Device_TX0FSA(value uint32) {
	volatile.StoreUint32(&o.FS_GNPTXFSIZ_Device.Reg, volatile.LoadUint32(&o.FS_GNPTXFSIZ_Device.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GNPTXFSIZ_Device_TX0FSA() uint32 {
	return volatile.LoadUint32(&o.FS_GNPTXFSIZ_Device.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetFS_GNPTXFSIZ_Device_TX0FD(value uint32) {
	volatile.StoreUint32(&o.FS_GNPTXFSIZ_Device.Reg, volatile.LoadUint32(&o.FS_GNPTXFSIZ_Device.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetFS_GNPTXFSIZ_Device_TX0FD() uint32 {
	return (volatile.LoadUint32(&o.FS_GNPTXFSIZ_Device.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.FS_GNPTXSTS: OTG_FS non-periodic transmit FIFO/queue status register (OTG_FS_GNPTXSTS)
func (o *USB_OTG_FS_Type) SetFS_GNPTXSTS_NPTXFSAV(value uint32) {
	volatile.StoreUint32(&o.FS_GNPTXSTS.Reg, volatile.LoadUint32(&o.FS_GNPTXSTS.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GNPTXSTS_NPTXFSAV() uint32 {
	return volatile.LoadUint32(&o.FS_GNPTXSTS.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetFS_GNPTXSTS_NPTQXSAV(value uint32) {
	volatile.StoreUint32(&o.FS_GNPTXSTS.Reg, volatile.LoadUint32(&o.FS_GNPTXSTS.Reg)&^(0xff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetFS_GNPTXSTS_NPTQXSAV() uint32 {
	return (volatile.LoadUint32(&o.FS_GNPTXSTS.Reg) & 0xff0000) >> 16
}
func (o *USB_OTG_FS_Type) SetFS_GNPTXSTS_NPTXQTOP(value uint32) {
	volatile.StoreUint32(&o.FS_GNPTXSTS.Reg, volatile.LoadUint32(&o.FS_GNPTXSTS.Reg)&^(0x7f000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetFS_GNPTXSTS_NPTXQTOP() uint32 {
	return (volatile.LoadUint32(&o.FS_GNPTXSTS.Reg) & 0x7f000000) >> 24
}

// USB_OTG_FS.FS_GCCFG: OTG_FS general core configuration register (OTG_FS_GCCFG)
func (o *USB_OTG_FS_Type) SetFS_GCCFG_PWRDWN(value uint32) {
	volatile.StoreUint32(&o.FS_GCCFG.Reg, volatile.LoadUint32(&o.FS_GCCFG.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetFS_GCCFG_PWRDWN() uint32 {
	return (volatile.LoadUint32(&o.FS_GCCFG.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetFS_GCCFG_VBUSASEN(value uint32) {
	volatile.StoreUint32(&o.FS_GCCFG.Reg, volatile.LoadUint32(&o.FS_GCCFG.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetFS_GCCFG_VBUSASEN() uint32 {
	return (volatile.LoadUint32(&o.FS_GCCFG.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetFS_GCCFG_VBUSBSEN(value uint32) {
	volatile.StoreUint32(&o.FS_GCCFG.Reg, volatile.LoadUint32(&o.FS_GCCFG.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetFS_GCCFG_VBUSBSEN() uint32 {
	return (volatile.LoadUint32(&o.FS_GCCFG.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetFS_GCCFG_SOFOUTEN(value uint32) {
	volatile.StoreUint32(&o.FS_GCCFG.Reg, volatile.LoadUint32(&o.FS_GCCFG.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetFS_GCCFG_SOFOUTEN() uint32 {
	return (volatile.LoadUint32(&o.FS_GCCFG.Reg) & 0x100000) >> 20
}

// USB_OTG_FS.FS_CID: core ID register
func (o *USB_OTG_FS_Type) SetFS_CID(value uint32) {
	volatile.StoreUint32(&o.FS_CID.Reg, value)
}
func (o *USB_OTG_FS_Type) GetFS_CID() uint32 {
	return volatile.LoadUint32(&o.FS_CID.Reg)
}

// USB_OTG_FS.FS_HPTXFSIZ: OTG_FS Host periodic transmit FIFO size register (OTG_FS_HPTXFSIZ)
func (o *USB_OTG_FS_Type) SetFS_HPTXFSIZ_PTXSA(value uint32) {
	volatile.StoreUint32(&o.FS_HPTXFSIZ.Reg, volatile.LoadUint32(&o.FS_HPTXFSIZ.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetFS_HPTXFSIZ_PTXSA() uint32 {
	return volatile.LoadUint32(&o.FS_HPTXFSIZ.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetFS_HPTXFSIZ_PTXFSIZ(value uint32) {
	volatile.StoreUint32(&o.FS_HPTXFSIZ.Reg, volatile.LoadUint32(&o.FS_HPTXFSIZ.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetFS_HPTXFSIZ_PTXFSIZ() uint32 {
	return (volatile.LoadUint32(&o.FS_HPTXFSIZ.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.FS_DIEPTXF1: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF2)
func (o *USB_OTG_FS_Type) SetFS_DIEPTXF1_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.FS_DIEPTXF1.Reg, volatile.LoadUint32(&o.FS_DIEPTXF1.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetFS_DIEPTXF1_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.FS_DIEPTXF1.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetFS_DIEPTXF1_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.FS_DIEPTXF1.Reg, volatile.LoadUint32(&o.FS_DIEPTXF1.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetFS_DIEPTXF1_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.FS_DIEPTXF1.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.FS_DIEPTXF2: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF3)
func (o *USB_OTG_FS_Type) SetFS_DIEPTXF2_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.FS_DIEPTXF2.Reg, volatile.LoadUint32(&o.FS_DIEPTXF2.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetFS_DIEPTXF2_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.FS_DIEPTXF2.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetFS_DIEPTXF2_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.FS_DIEPTXF2.Reg, volatile.LoadUint32(&o.FS_DIEPTXF2.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetFS_DIEPTXF2_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.FS_DIEPTXF2.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.FS_DIEPTXF3: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF4)
func (o *USB_OTG_FS_Type) SetFS_DIEPTXF3_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.FS_DIEPTXF3.Reg, volatile.LoadUint32(&o.FS_DIEPTXF3.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetFS_DIEPTXF3_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.FS_DIEPTXF3.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetFS_DIEPTXF3_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.FS_DIEPTXF3.Reg, volatile.LoadUint32(&o.FS_DIEPTXF3.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetFS_DIEPTXF3_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.FS_DIEPTXF3.Reg) & 0xffff0000) >> 16
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// EXTI.IMR: Interrupt mask register (EXTI_IMR)
func (o *EXTI_Type) SetIMR_MR0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR_MR0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR_MR1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR_MR1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR_MR2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR_MR2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR_MR3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR_MR3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetIMR_MR4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetIMR_MR4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetIMR_MR5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetIMR_MR5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetIMR_MR6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetIMR_MR6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetIMR_MR7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetIMR_MR7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetIMR_MR8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetIMR_MR8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetIMR_MR9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetIMR_MR9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetIMR_MR10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetIMR_MR10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetIMR_MR11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetIMR_MR11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetIMR_MR12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetIMR_MR12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetIMR_MR13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetIMR_MR13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetIMR_MR14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetIMR_MR14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetIMR_MR15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetIMR_MR15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetIMR_MR16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetIMR_MR16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetIMR_MR17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetIMR_MR17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetIMR_MR18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetIMR_MR18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetIMR_MR19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetIMR_MR19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetIMR_MR20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetIMR_MR20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetIMR_MR21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetIMR_MR21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetIMR_MR22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetIMR_MR22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}

// EXTI.EMR: Event mask register (EXTI_EMR)
func (o *EXTI_Type) SetEMR_MR0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetEMR_MR0() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x1
}
func (o *EXTI_Type) SetEMR_MR1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetEMR_MR1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetEMR_MR2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetEMR_MR2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetEMR_MR3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetEMR_MR3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetEMR_MR4(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetEMR_MR4() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetEMR_MR5(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetEMR_MR5() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetEMR_MR6(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetEMR_MR6() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetEMR_MR7(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetEMR_MR7() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetEMR_MR8(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetEMR_MR8() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetEMR_MR9(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetEMR_MR9() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetEMR_MR10(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetEMR_MR10() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetEMR_MR11(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetEMR_MR11() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetEMR_MR12(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetEMR_MR12() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetEMR_MR13(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetEMR_MR13() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetEMR_MR14(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetEMR_MR14() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetEMR_MR15(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetEMR_MR15() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetEMR_MR16(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetEMR_MR16() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetEMR_MR17(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetEMR_MR17() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetEMR_MR18(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetEMR_MR18() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetEMR_MR19(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetEMR_MR19() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetEMR_MR20(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetEMR_MR20() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetEMR_MR21(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetEMR_MR21() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetEMR_MR22(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetEMR_MR22() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x400000) >> 22
}

// EXTI.RTSR: Rising Trigger selection register (EXTI_RTSR)
func (o *EXTI_Type) SetRTSR_TR0(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR_TR0() uint32 {
	return volatile.LoadUint32(&o.RTSR.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR_TR1(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR_TR1() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR_TR2(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR_TR2() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRTSR_TR3(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR_TR3() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR_TR4(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR_TR4() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR_TR5(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR_TR5() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR_TR6(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR_TR6() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRTSR_TR7(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRTSR_TR7() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRTSR_TR8(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR_TR8() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR_TR9(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR_TR9() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRTSR_TR10(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRTSR_TR10() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRTSR_TR11(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRTSR_TR11() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRTSR_TR12(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRTSR_TR12() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRTSR_TR13(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRTSR_TR13() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRTSR_TR14(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRTSR_TR14() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRTSR_TR15(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRTSR_TR15() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRTSR_TR16(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRTSR_TR16() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetRTSR_TR17(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetRTSR_TR17() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetRTSR_TR18(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetRTSR_TR18() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetRTSR_TR19(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetRTSR_TR19() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetRTSR_TR20(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetRTSR_TR20() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetRTSR_TR21(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRTSR_TR21() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetRTSR_TR22(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetRTSR_TR22() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x400000) >> 22
}

// EXTI.FTSR: Falling Trigger selection register (EXTI_FTSR)
func (o *EXTI_Type) SetFTSR_TR0(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR_TR0() uint32 {
	return volatile.LoadUint32(&o.FTSR.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR_TR1(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR_TR1() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR_TR2(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR_TR2() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFTSR_TR3(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR_TR3() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR_TR4(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR_TR4() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR_TR5(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR_TR5() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR_TR6(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR_TR6() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFTSR_TR7(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFTSR_TR7() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFTSR_TR8(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR_TR8() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR_TR9(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR_TR9() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFTSR_TR10(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFTSR_TR10() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFTSR_TR11(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFTSR_TR11() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFTSR_TR12(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFTSR_TR12() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFTSR_TR13(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFTSR_TR13() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFTSR_TR14(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFTSR_TR14() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFTSR_TR15(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFTSR_TR15() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFTSR_TR16(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFTSR_TR16() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetFTSR_TR17(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetFTSR_TR17() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetFTSR_TR18(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetFTSR_TR18() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetFTSR_TR19(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetFTSR_TR19() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetFTSR_TR20(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetFTSR_TR20() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetFTSR_TR21(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFTSR_TR21() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetFTSR_TR22(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetFTSR_TR22() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x400000) >> 22
}

// EXTI.SWIER: Software interrupt event register (EXTI_SWIER)
func (o *EXTI_Type) SetSWIER_SWIER0(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER_SWIER0() uint32 {
	return volatile.LoadUint32(&o.SWIER.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER_SWIER1(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER_SWIER1() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER_SWIER2(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER_SWIER2() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSWIER_SWIER3(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER_SWIER3() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER_SWIER4(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER_SWIER4() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER_SWIER5(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER_SWIER5() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER_SWIER6(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER_SWIER6() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSWIER_SWIER7(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSWIER_SWIER7() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSWIER_SWIER8(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER_SWIER8() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER_SWIER9(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER_SWIER9() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSWIER_SWIER10(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSWIER_SWIER10() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetSWIER_SWIER11(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetSWIER_SWIER11() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetSWIER_SWIER12(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetSWIER_SWIER12() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetSWIER_SWIER13(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSWIER_SWIER13() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetSWIER_SWIER14(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetSWIER_SWIER14() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetSWIER_SWIER15(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetSWIER_SWIER15() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetSWIER_SWIER16(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetSWIER_SWIER16() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetSWIER_SWIER17(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetSWIER_SWIER17() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetSWIER_SWIER18(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetSWIER_SWIER18() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetSWIER_SWIER19(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetSWIER_SWIER19() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetSWIER_SWIER20(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetSWIER_SWIER20() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetSWIER_SWIER21(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSWIER_SWIER21() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetSWIER_SWIER22(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetSWIER_SWIER22() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x400000) >> 22
}

// EXTI.PR: Pending register (EXTI_PR)
func (o *EXTI_Type) SetPR_PR0(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetPR_PR0() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x1
}
func (o *EXTI_Type) SetPR_PR1(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetPR_PR1() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetPR_PR2(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetPR_PR2() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetPR_PR3(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetPR_PR3() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetPR_PR4(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetPR_PR4() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetPR_PR5(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetPR_PR5() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetPR_PR6(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetPR_PR6() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetPR_PR7(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetPR_PR7() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetPR_PR8(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetPR_PR8() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetPR_PR9(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetPR_PR9() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetPR_PR10(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetPR_PR10() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetPR_PR11(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetPR_PR11() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetPR_PR12(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetPR_PR12() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetPR_PR13(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetPR_PR13() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetPR_PR14(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetPR_PR14() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetPR_PR15(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetPR_PR15() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetPR_PR16(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetPR_PR16() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetPR_PR17(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetPR_PR17() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetPR_PR18(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetPR_PR18() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetPR_PR19(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetPR_PR19() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetPR_PR20(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetPR_PR20() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetPR_PR21(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetPR_PR21() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetPR_PR22(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetPR_PR22() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x400000) >> 22
}

// FLASH
type FLASH_Type struct {
	ACR     volatile.Register32 // 0x0
	KEYR    volatile.Register32 // 0x4
	OPTKEYR volatile.Register32 // 0x8
	SR      volatile.Register32 // 0xC
	CR      volatile.Register32 // 0x10
	OPTCR   volatile.Register32 // 0x14
}

// FLASH.ACR: Flash access control register
func (o *FLASH_Type) SetACR_LATENCY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x7)|value)
}
func (o *FLASH_Type) GetACR_LATENCY() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x7
}
func (o *FLASH_Type) SetACR_PRFTEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x100)|value<<8)
}
func (o *FLASH_Type) GetACR_PRFTEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x100) >> 8
}
func (o *FLASH_Type) SetACR_ICEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x200)|value<<9)
}
func (o *FLASH_Type) GetACR_ICEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x200) >> 9
}
func (o *FLASH_Type) SetACR_DCEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x400)|value<<10)
}
func (o *FLASH_Type) GetACR_DCEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x400) >> 10
}
func (o *FLASH_Type) SetACR_ICRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x800)|value<<11)
}
func (o *FLASH_Type) GetACR_ICRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x800) >> 11
}
func (o *FLASH_Type) SetACR_DCRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1000)|value<<12)
}
func (o *FLASH_Type) GetACR_DCRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x1000) >> 12
}

// FLASH.KEYR: Flash key register
func (o *FLASH_Type) SetKEYR(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, value)
}
func (o *FLASH_Type) GetKEYR() uint32 {
	return volatile.LoadUint32(&o.KEYR.Reg)
}

// FLASH.OPTKEYR: Flash option key register
func (o *FLASH_Type) SetOPTKEYR(value uint32) {
	volatile.StoreUint32(&o.OPTKEYR.Reg, value)
}
func (o *FLASH_Type) GetOPTKEYR() uint32 {
	return volatile.LoadUint32(&o.OPTKEYR.Reg)
}

// FLASH.SR: Status register
func (o *FLASH_Type) SetSR_EOP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *FLASH_Type) GetSR_EOP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *FLASH_Type) SetSR_OPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_Type) GetSR_OPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *FLASH_Type) SetSR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *FLASH_Type) GetSR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *FLASH_Type) SetSR_PGAERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *FLASH_Type) GetSR_PGAERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *FLASH_Type) SetSR_PGPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *FLASH_Type) GetSR_PGPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *FLASH_Type) SetSR_PGSERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *FLASH_Type) GetSR_PGSERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *FLASH_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// FLASH.CR: Control register
func (o *FLASH_Type) SetCR_PG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *FLASH_Type) GetCR_PG() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *FLASH_Type) SetCR_SER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_Type) GetCR_SER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *FLASH_Type) SetCR_MER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *FLASH_Type) GetCR_MER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *FLASH_Type) SetCR_SNB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x78)|value<<3)
}
func (o *FLASH_Type) GetCR_SNB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x78) >> 3
}
func (o *FLASH_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *FLASH_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *FLASH_Type) SetCR_STRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_Type) GetCR_STRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *FLASH_Type) SetCR_EOPIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *FLASH_Type) GetCR_EOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *FLASH_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *FLASH_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *FLASH_Type) SetCR_LOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASH_Type) GetCR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}

// FLASH.OPTCR: Flash option control register
func (o *FLASH_Type) SetOPTCR_OPTLOCK(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x1)|value)
}
func (o *FLASH_Type) GetOPTCR_OPTLOCK() uint32 {
	return volatile.LoadUint32(&o.OPTCR.Reg) & 0x1
}
func (o *FLASH_Type) SetOPTCR_OPTSTRT(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_Type) GetOPTCR_OPTSTRT() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x2) >> 1
}
func (o *FLASH_Type) SetOPTCR_BOR_LEV(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0xc)|value<<2)
}
func (o *FLASH_Type) GetOPTCR_BOR_LEV() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0xc) >> 2
}
func (o *FLASH_Type) SetOPTCR_WDG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x20)|value<<5)
}
func (o *FLASH_Type) GetOPTCR_WDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x20) >> 5
}
func (o *FLASH_Type) SetOPTCR_NRST_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x40)|value<<6)
}
func (o *FLASH_Type) GetOPTCR_NRST_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x40) >> 6
}
func (o *FLASH_Type) SetOPTCR_NRST_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x80)|value<<7)
}
func (o *FLASH_Type) GetOPTCR_NRST_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x80) >> 7
}
func (o *FLASH_Type) SetOPTCR_RDP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0xff00)|value<<8)
}
func (o *FLASH_Type) GetOPTCR_RDP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0xff00) >> 8
}
func (o *FLASH_Type) SetOPTCR_NWRP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *FLASH_Type) GetOPTCR_NWRP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0xfff0000) >> 16
}

// Hash processor
type HASH_Type struct {
	CR    volatile.Register32 // 0x0
	DIN   volatile.Register32 // 0x4
	STR   volatile.Register32 // 0x8
	HR0   volatile.Register32 // 0xC
	HR1   volatile.Register32 // 0x10
	HR2   volatile.Register32 // 0x14
	HR3   volatile.Register32 // 0x18
	HR4   volatile.Register32 // 0x1C
	IMR   volatile.Register32 // 0x20
	SR    volatile.Register32 // 0x24
	_     [208]byte
	CSR0  volatile.Register32 // 0xF8
	CSR1  volatile.Register32 // 0xFC
	CSR2  volatile.Register32 // 0x100
	CSR3  volatile.Register32 // 0x104
	CSR4  volatile.Register32 // 0x108
	CSR5  volatile.Register32 // 0x10C
	CSR6  volatile.Register32 // 0x110
	CSR7  volatile.Register32 // 0x114
	CSR8  volatile.Register32 // 0x118
	CSR9  volatile.Register32 // 0x11C
	CSR10 volatile.Register32 // 0x120
	CSR11 volatile.Register32 // 0x124
	CSR12 volatile.Register32 // 0x128
	CSR13 volatile.Register32 // 0x12C
	CSR14 volatile.Register32 // 0x130
	CSR15 volatile.Register32 // 0x134
	CSR16 volatile.Register32 // 0x138
	CSR17 volatile.Register32 // 0x13C
	CSR18 volatile.Register32 // 0x140
	CSR19 volatile.Register32 // 0x144
	CSR20 volatile.Register32 // 0x148
	CSR21 volatile.Register32 // 0x14C
	CSR22 volatile.Register32 // 0x150
	CSR23 volatile.Register32 // 0x154
	CSR24 volatile.Register32 // 0x158
	CSR25 volatile.Register32 // 0x15C
	CSR26 volatile.Register32 // 0x160
	CSR27 volatile.Register32 // 0x164
	CSR28 volatile.Register32 // 0x168
	CSR29 volatile.Register32 // 0x16C
	CSR30 volatile.Register32 // 0x170
	CSR31 volatile.Register32 // 0x174
	CSR32 volatile.Register32 // 0x178
	CSR33 volatile.Register32 // 0x17C
	CSR34 volatile.Register32 // 0x180
	CSR35 volatile.Register32 // 0x184
	CSR36 volatile.Register32 // 0x188
	CSR37 volatile.Register32 // 0x18C
	CSR38 volatile.Register32 // 0x190
	CSR39 volatile.Register32 // 0x194
	CSR40 volatile.Register32 // 0x198
	CSR41 volatile.Register32 // 0x19C
	CSR42 volatile.Register32 // 0x1A0
	CSR43 volatile.Register32 // 0x1A4
	CSR44 volatile.Register32 // 0x1A8
	CSR45 volatile.Register32 // 0x1AC
	CSR46 volatile.Register32 // 0x1B0
	CSR47 volatile.Register32 // 0x1B4
	CSR48 volatile.Register32 // 0x1B8
	CSR49 volatile.Register32 // 0x1BC
	CSR50 volatile.Register32 // 0x1C0
}

// HASH.CR: control register
func (o *HASH_Type) SetCR_LKEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *HASH_Type) GetCR_LKEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *HASH_Type) SetCR_DINNE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *HASH_Type) GetCR_DINNE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *HASH_Type) SetCR_NBW(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *HASH_Type) GetCR_NBW() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *HASH_Type) SetCR_ALGO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *HASH_Type) GetCR_ALGO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *HASH_Type) SetCR_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *HASH_Type) GetCR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *HASH_Type) SetCR_DATATYPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30)|value<<4)
}
func (o *HASH_Type) GetCR_DATATYPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30) >> 4
}
func (o *HASH_Type) SetCR_DMAE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *HASH_Type) GetCR_DMAE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *HASH_Type) SetCR_INIT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *HASH_Type) GetCR_INIT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}

// HASH.DIN: data input register
func (o *HASH_Type) SetDIN(value uint32) {
	volatile.StoreUint32(&o.DIN.Reg, value)
}
func (o *HASH_Type) GetDIN() uint32 {
	return volatile.LoadUint32(&o.DIN.Reg)
}

// HASH.STR: start register
func (o *HASH_Type) SetSTR_DCAL(value uint32) {
	volatile.StoreUint32(&o.STR.Reg, volatile.LoadUint32(&o.STR.Reg)&^(0x100)|value<<8)
}
func (o *HASH_Type) GetSTR_DCAL() uint32 {
	return (volatile.LoadUint32(&o.STR.Reg) & 0x100) >> 8
}
func (o *HASH_Type) SetSTR_NBLW(value uint32) {
	volatile.StoreUint32(&o.STR.Reg, volatile.LoadUint32(&o.STR.Reg)&^(0x1f)|value)
}
func (o *HASH_Type) GetSTR_NBLW() uint32 {
	return volatile.LoadUint32(&o.STR.Reg) & 0x1f
}

// HASH.HR0: digest registers
func (o *HASH_Type) SetHR0(value uint32) {
	volatile.StoreUint32(&o.HR0.Reg, value)
}
func (o *HASH_Type) GetHR0() uint32 {
	return volatile.LoadUint32(&o.HR0.Reg)
}

// HASH.HR1: digest registers
func (o *HASH_Type) SetHR1(value uint32) {
	volatile.StoreUint32(&o.HR1.Reg, value)
}
func (o *HASH_Type) GetHR1() uint32 {
	return volatile.LoadUint32(&o.HR1.Reg)
}

// HASH.HR2: digest registers
func (o *HASH_Type) SetHR2(value uint32) {
	volatile.StoreUint32(&o.HR2.Reg, value)
}
func (o *HASH_Type) GetHR2() uint32 {
	return volatile.LoadUint32(&o.HR2.Reg)
}

// HASH.HR3: digest registers
func (o *HASH_Type) SetHR3(value uint32) {
	volatile.StoreUint32(&o.HR3.Reg, value)
}
func (o *HASH_Type) GetHR3() uint32 {
	return volatile.LoadUint32(&o.HR3.Reg)
}

// HASH.HR4: digest registers
func (o *HASH_Type) SetHR4(value uint32) {
	volatile.StoreUint32(&o.HR4.Reg, value)
}
func (o *HASH_Type) GetHR4() uint32 {
	return volatile.LoadUint32(&o.HR4.Reg)
}

// HASH.IMR: interrupt enable register
func (o *HASH_Type) SetIMR_DCIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *HASH_Type) GetIMR_DCIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *HASH_Type) SetIMR_DINIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *HASH_Type) GetIMR_DINIE() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}

// HASH.SR: status register
func (o *HASH_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *HASH_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *HASH_Type) SetSR_DMAS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *HASH_Type) GetSR_DMAS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *HASH_Type) SetSR_DCIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *HASH_Type) GetSR_DCIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *HASH_Type) SetSR_DINIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *HASH_Type) GetSR_DINIS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// HASH.CSR0: context swap registers
func (o *HASH_Type) SetCSR0(value uint32) {
	volatile.StoreUint32(&o.CSR0.Reg, value)
}
func (o *HASH_Type) GetCSR0() uint32 {
	return volatile.LoadUint32(&o.CSR0.Reg)
}

// HASH.CSR1: context swap registers
func (o *HASH_Type) SetCSR1(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, value)
}
func (o *HASH_Type) GetCSR1() uint32 {
	return volatile.LoadUint32(&o.CSR1.Reg)
}

// HASH.CSR2: context swap registers
func (o *HASH_Type) SetCSR2(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, value)
}
func (o *HASH_Type) GetCSR2() uint32 {
	return volatile.LoadUint32(&o.CSR2.Reg)
}

// HASH.CSR3: context swap registers
func (o *HASH_Type) SetCSR3(value uint32) {
	volatile.StoreUint32(&o.CSR3.Reg, value)
}
func (o *HASH_Type) GetCSR3() uint32 {
	return volatile.LoadUint32(&o.CSR3.Reg)
}

// HASH.CSR4: context swap registers
func (o *HASH_Type) SetCSR4(value uint32) {
	volatile.StoreUint32(&o.CSR4.Reg, value)
}
func (o *HASH_Type) GetCSR4() uint32 {
	return volatile.LoadUint32(&o.CSR4.Reg)
}

// HASH.CSR5: context swap registers
func (o *HASH_Type) SetCSR5(value uint32) {
	volatile.StoreUint32(&o.CSR5.Reg, value)
}
func (o *HASH_Type) GetCSR5() uint32 {
	return volatile.LoadUint32(&o.CSR5.Reg)
}

// HASH.CSR6: context swap registers
func (o *HASH_Type) SetCSR6(value uint32) {
	volatile.StoreUint32(&o.CSR6.Reg, value)
}
func (o *HASH_Type) GetCSR6() uint32 {
	return volatile.LoadUint32(&o.CSR6.Reg)
}

// HASH.CSR7: context swap registers
func (o *HASH_Type) SetCSR7(value uint32) {
	volatile.StoreUint32(&o.CSR7.Reg, value)
}
func (o *HASH_Type) GetCSR7() uint32 {
	return volatile.LoadUint32(&o.CSR7.Reg)
}

// HASH.CSR8: context swap registers
func (o *HASH_Type) SetCSR8(value uint32) {
	volatile.StoreUint32(&o.CSR8.Reg, value)
}
func (o *HASH_Type) GetCSR8() uint32 {
	return volatile.LoadUint32(&o.CSR8.Reg)
}

// HASH.CSR9: context swap registers
func (o *HASH_Type) SetCSR9(value uint32) {
	volatile.StoreUint32(&o.CSR9.Reg, value)
}
func (o *HASH_Type) GetCSR9() uint32 {
	return volatile.LoadUint32(&o.CSR9.Reg)
}

// HASH.CSR10: context swap registers
func (o *HASH_Type) SetCSR10(value uint32) {
	volatile.StoreUint32(&o.CSR10.Reg, value)
}
func (o *HASH_Type) GetCSR10() uint32 {
	return volatile.LoadUint32(&o.CSR10.Reg)
}

// HASH.CSR11: context swap registers
func (o *HASH_Type) SetCSR11(value uint32) {
	volatile.StoreUint32(&o.CSR11.Reg, value)
}
func (o *HASH_Type) GetCSR11() uint32 {
	return volatile.LoadUint32(&o.CSR11.Reg)
}

// HASH.CSR12: context swap registers
func (o *HASH_Type) SetCSR12(value uint32) {
	volatile.StoreUint32(&o.CSR12.Reg, value)
}
func (o *HASH_Type) GetCSR12() uint32 {
	return volatile.LoadUint32(&o.CSR12.Reg)
}

// HASH.CSR13: context swap registers
func (o *HASH_Type) SetCSR13(value uint32) {
	volatile.StoreUint32(&o.CSR13.Reg, value)
}
func (o *HASH_Type) GetCSR13() uint32 {
	return volatile.LoadUint32(&o.CSR13.Reg)
}

// HASH.CSR14: context swap registers
func (o *HASH_Type) SetCSR14(value uint32) {
	volatile.StoreUint32(&o.CSR14.Reg, value)
}
func (o *HASH_Type) GetCSR14() uint32 {
	return volatile.LoadUint32(&o.CSR14.Reg)
}

// HASH.CSR15: context swap registers
func (o *HASH_Type) SetCSR15(value uint32) {
	volatile.StoreUint32(&o.CSR15.Reg, value)
}
func (o *HASH_Type) GetCSR15() uint32 {
	return volatile.LoadUint32(&o.CSR15.Reg)
}

// HASH.CSR16: context swap registers
func (o *HASH_Type) SetCSR16(value uint32) {
	volatile.StoreUint32(&o.CSR16.Reg, value)
}
func (o *HASH_Type) GetCSR16() uint32 {
	return volatile.LoadUint32(&o.CSR16.Reg)
}

// HASH.CSR17: context swap registers
func (o *HASH_Type) SetCSR17(value uint32) {
	volatile.StoreUint32(&o.CSR17.Reg, value)
}
func (o *HASH_Type) GetCSR17() uint32 {
	return volatile.LoadUint32(&o.CSR17.Reg)
}

// HASH.CSR18: context swap registers
func (o *HASH_Type) SetCSR18(value uint32) {
	volatile.StoreUint32(&o.CSR18.Reg, value)
}
func (o *HASH_Type) GetCSR18() uint32 {
	return volatile.LoadUint32(&o.CSR18.Reg)
}

// HASH.CSR19: context swap registers
func (o *HASH_Type) SetCSR19(value uint32) {
	volatile.StoreUint32(&o.CSR19.Reg, value)
}
func (o *HASH_Type) GetCSR19() uint32 {
	return volatile.LoadUint32(&o.CSR19.Reg)
}

// HASH.CSR20: context swap registers
func (o *HASH_Type) SetCSR20(value uint32) {
	volatile.StoreUint32(&o.CSR20.Reg, value)
}
func (o *HASH_Type) GetCSR20() uint32 {
	return volatile.LoadUint32(&o.CSR20.Reg)
}

// HASH.CSR21: context swap registers
func (o *HASH_Type) SetCSR21(value uint32) {
	volatile.StoreUint32(&o.CSR21.Reg, value)
}
func (o *HASH_Type) GetCSR21() uint32 {
	return volatile.LoadUint32(&o.CSR21.Reg)
}

// HASH.CSR22: context swap registers
func (o *HASH_Type) SetCSR22(value uint32) {
	volatile.StoreUint32(&o.CSR22.Reg, value)
}
func (o *HASH_Type) GetCSR22() uint32 {
	return volatile.LoadUint32(&o.CSR22.Reg)
}

// HASH.CSR23: context swap registers
func (o *HASH_Type) SetCSR23(value uint32) {
	volatile.StoreUint32(&o.CSR23.Reg, value)
}
func (o *HASH_Type) GetCSR23() uint32 {
	return volatile.LoadUint32(&o.CSR23.Reg)
}

// HASH.CSR24: context swap registers
func (o *HASH_Type) SetCSR24(value uint32) {
	volatile.StoreUint32(&o.CSR24.Reg, value)
}
func (o *HASH_Type) GetCSR24() uint32 {
	return volatile.LoadUint32(&o.CSR24.Reg)
}

// HASH.CSR25: context swap registers
func (o *HASH_Type) SetCSR25(value uint32) {
	volatile.StoreUint32(&o.CSR25.Reg, value)
}
func (o *HASH_Type) GetCSR25() uint32 {
	return volatile.LoadUint32(&o.CSR25.Reg)
}

// HASH.CSR26: context swap registers
func (o *HASH_Type) SetCSR26(value uint32) {
	volatile.StoreUint32(&o.CSR26.Reg, value)
}
func (o *HASH_Type) GetCSR26() uint32 {
	return volatile.LoadUint32(&o.CSR26.Reg)
}

// HASH.CSR27: context swap registers
func (o *HASH_Type) SetCSR27(value uint32) {
	volatile.StoreUint32(&o.CSR27.Reg, value)
}
func (o *HASH_Type) GetCSR27() uint32 {
	return volatile.LoadUint32(&o.CSR27.Reg)
}

// HASH.CSR28: context swap registers
func (o *HASH_Type) SetCSR28(value uint32) {
	volatile.StoreUint32(&o.CSR28.Reg, value)
}
func (o *HASH_Type) GetCSR28() uint32 {
	return volatile.LoadUint32(&o.CSR28.Reg)
}

// HASH.CSR29: context swap registers
func (o *HASH_Type) SetCSR29(value uint32) {
	volatile.StoreUint32(&o.CSR29.Reg, value)
}
func (o *HASH_Type) GetCSR29() uint32 {
	return volatile.LoadUint32(&o.CSR29.Reg)
}

// HASH.CSR30: context swap registers
func (o *HASH_Type) SetCSR30(value uint32) {
	volatile.StoreUint32(&o.CSR30.Reg, value)
}
func (o *HASH_Type) GetCSR30() uint32 {
	return volatile.LoadUint32(&o.CSR30.Reg)
}

// HASH.CSR31: context swap registers
func (o *HASH_Type) SetCSR31(value uint32) {
	volatile.StoreUint32(&o.CSR31.Reg, value)
}
func (o *HASH_Type) GetCSR31() uint32 {
	return volatile.LoadUint32(&o.CSR31.Reg)
}

// HASH.CSR32: context swap registers
func (o *HASH_Type) SetCSR32(value uint32) {
	volatile.StoreUint32(&o.CSR32.Reg, value)
}
func (o *HASH_Type) GetCSR32() uint32 {
	return volatile.LoadUint32(&o.CSR32.Reg)
}

// HASH.CSR33: context swap registers
func (o *HASH_Type) SetCSR33(value uint32) {
	volatile.StoreUint32(&o.CSR33.Reg, value)
}
func (o *HASH_Type) GetCSR33() uint32 {
	return volatile.LoadUint32(&o.CSR33.Reg)
}

// HASH.CSR34: context swap registers
func (o *HASH_Type) SetCSR34(value uint32) {
	volatile.StoreUint32(&o.CSR34.Reg, value)
}
func (o *HASH_Type) GetCSR34() uint32 {
	return volatile.LoadUint32(&o.CSR34.Reg)
}

// HASH.CSR35: context swap registers
func (o *HASH_Type) SetCSR35(value uint32) {
	volatile.StoreUint32(&o.CSR35.Reg, value)
}
func (o *HASH_Type) GetCSR35() uint32 {
	return volatile.LoadUint32(&o.CSR35.Reg)
}

// HASH.CSR36: context swap registers
func (o *HASH_Type) SetCSR36(value uint32) {
	volatile.StoreUint32(&o.CSR36.Reg, value)
}
func (o *HASH_Type) GetCSR36() uint32 {
	return volatile.LoadUint32(&o.CSR36.Reg)
}

// HASH.CSR37: context swap registers
func (o *HASH_Type) SetCSR37(value uint32) {
	volatile.StoreUint32(&o.CSR37.Reg, value)
}
func (o *HASH_Type) GetCSR37() uint32 {
	return volatile.LoadUint32(&o.CSR37.Reg)
}

// HASH.CSR38: context swap registers
func (o *HASH_Type) SetCSR38(value uint32) {
	volatile.StoreUint32(&o.CSR38.Reg, value)
}
func (o *HASH_Type) GetCSR38() uint32 {
	return volatile.LoadUint32(&o.CSR38.Reg)
}

// HASH.CSR39: context swap registers
func (o *HASH_Type) SetCSR39(value uint32) {
	volatile.StoreUint32(&o.CSR39.Reg, value)
}
func (o *HASH_Type) GetCSR39() uint32 {
	return volatile.LoadUint32(&o.CSR39.Reg)
}

// HASH.CSR40: context swap registers
func (o *HASH_Type) SetCSR40(value uint32) {
	volatile.StoreUint32(&o.CSR40.Reg, value)
}
func (o *HASH_Type) GetCSR40() uint32 {
	return volatile.LoadUint32(&o.CSR40.Reg)
}

// HASH.CSR41: context swap registers
func (o *HASH_Type) SetCSR41(value uint32) {
	volatile.StoreUint32(&o.CSR41.Reg, value)
}
func (o *HASH_Type) GetCSR41() uint32 {
	return volatile.LoadUint32(&o.CSR41.Reg)
}

// HASH.CSR42: context swap registers
func (o *HASH_Type) SetCSR42(value uint32) {
	volatile.StoreUint32(&o.CSR42.Reg, value)
}
func (o *HASH_Type) GetCSR42() uint32 {
	return volatile.LoadUint32(&o.CSR42.Reg)
}

// HASH.CSR43: context swap registers
func (o *HASH_Type) SetCSR43(value uint32) {
	volatile.StoreUint32(&o.CSR43.Reg, value)
}
func (o *HASH_Type) GetCSR43() uint32 {
	return volatile.LoadUint32(&o.CSR43.Reg)
}

// HASH.CSR44: context swap registers
func (o *HASH_Type) SetCSR44(value uint32) {
	volatile.StoreUint32(&o.CSR44.Reg, value)
}
func (o *HASH_Type) GetCSR44() uint32 {
	return volatile.LoadUint32(&o.CSR44.Reg)
}

// HASH.CSR45: context swap registers
func (o *HASH_Type) SetCSR45(value uint32) {
	volatile.StoreUint32(&o.CSR45.Reg, value)
}
func (o *HASH_Type) GetCSR45() uint32 {
	return volatile.LoadUint32(&o.CSR45.Reg)
}

// HASH.CSR46: context swap registers
func (o *HASH_Type) SetCSR46(value uint32) {
	volatile.StoreUint32(&o.CSR46.Reg, value)
}
func (o *HASH_Type) GetCSR46() uint32 {
	return volatile.LoadUint32(&o.CSR46.Reg)
}

// HASH.CSR47: context swap registers
func (o *HASH_Type) SetCSR47(value uint32) {
	volatile.StoreUint32(&o.CSR47.Reg, value)
}
func (o *HASH_Type) GetCSR47() uint32 {
	return volatile.LoadUint32(&o.CSR47.Reg)
}

// HASH.CSR48: context swap registers
func (o *HASH_Type) SetCSR48(value uint32) {
	volatile.StoreUint32(&o.CSR48.Reg, value)
}
func (o *HASH_Type) GetCSR48() uint32 {
	return volatile.LoadUint32(&o.CSR48.Reg)
}

// HASH.CSR49: context swap registers
func (o *HASH_Type) SetCSR49(value uint32) {
	volatile.StoreUint32(&o.CSR49.Reg, value)
}
func (o *HASH_Type) GetCSR49() uint32 {
	return volatile.LoadUint32(&o.CSR49.Reg)
}

// HASH.CSR50: context swap registers
func (o *HASH_Type) SetCSR50(value uint32) {
	volatile.StoreUint32(&o.CSR50.Reg, value)
}
func (o *HASH_Type) GetCSR50() uint32 {
	return volatile.LoadUint32(&o.CSR50.Reg)
}

// Cryptographic processor
type CRYP_Type struct {
	CR    volatile.Register32 // 0x0
	SR    volatile.Register32 // 0x4
	DIN   volatile.Register32 // 0x8
	DOUT  volatile.Register32 // 0xC
	DMACR volatile.Register32 // 0x10
	IMSCR volatile.Register32 // 0x14
	RISR  volatile.Register32 // 0x18
	MISR  volatile.Register32 // 0x1C
	KEY   [4]CRYP_KEY_Type    // 0x20
	INIT  [2]CRYP_INIT_Type   // 0x40
}

// CRYP.CR: control register
func (o *CRYP_Type) SetCR_CRYPEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *CRYP_Type) GetCR_CRYPEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *CRYP_Type) SetCR_FFLUSH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *CRYP_Type) GetCR_FFLUSH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *CRYP_Type) SetCR_KEYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *CRYP_Type) GetCR_KEYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *CRYP_Type) SetCR_DATATYPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *CRYP_Type) GetCR_DATATYPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *CRYP_Type) SetCR_ALGOMODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x38)|value<<3)
}
func (o *CRYP_Type) GetCR_ALGOMODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x38) >> 3
}
func (o *CRYP_Type) SetCR_ALGODIR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *CRYP_Type) GetCR_ALGODIR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}

// CRYP.SR: status register
func (o *CRYP_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *CRYP_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *CRYP_Type) SetSR_OFFU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *CRYP_Type) GetSR_OFFU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *CRYP_Type) SetSR_OFNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *CRYP_Type) GetSR_OFNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *CRYP_Type) SetSR_IFNF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_Type) GetSR_IFNF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *CRYP_Type) SetSR_IFEM(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *CRYP_Type) GetSR_IFEM() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// CRYP.DIN: data input register
func (o *CRYP_Type) SetDIN(value uint32) {
	volatile.StoreUint32(&o.DIN.Reg, value)
}
func (o *CRYP_Type) GetDIN() uint32 {
	return volatile.LoadUint32(&o.DIN.Reg)
}

// CRYP.DOUT: data output register
func (o *CRYP_Type) SetDOUT(value uint32) {
	volatile.StoreUint32(&o.DOUT.Reg, value)
}
func (o *CRYP_Type) GetDOUT() uint32 {
	return volatile.LoadUint32(&o.DOUT.Reg)
}

// CRYP.DMACR: DMA control register
func (o *CRYP_Type) SetDMACR_DOEN(value uint32) {
	volatile.StoreUint32(&o.DMACR.Reg, volatile.LoadUint32(&o.DMACR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_Type) GetDMACR_DOEN() uint32 {
	return (volatile.LoadUint32(&o.DMACR.Reg) & 0x2) >> 1
}
func (o *CRYP_Type) SetDMACR_DIEN(value uint32) {
	volatile.StoreUint32(&o.DMACR.Reg, volatile.LoadUint32(&o.DMACR.Reg)&^(0x1)|value)
}
func (o *CRYP_Type) GetDMACR_DIEN() uint32 {
	return volatile.LoadUint32(&o.DMACR.Reg) & 0x1
}

// CRYP.IMSCR: interrupt mask set/clear register
func (o *CRYP_Type) SetIMSCR_OUTIM(value uint32) {
	volatile.StoreUint32(&o.IMSCR.Reg, volatile.LoadUint32(&o.IMSCR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_Type) GetIMSCR_OUTIM() uint32 {
	return (volatile.LoadUint32(&o.IMSCR.Reg) & 0x2) >> 1
}
func (o *CRYP_Type) SetIMSCR_INIM(value uint32) {
	volatile.StoreUint32(&o.IMSCR.Reg, volatile.LoadUint32(&o.IMSCR.Reg)&^(0x1)|value)
}
func (o *CRYP_Type) GetIMSCR_INIM() uint32 {
	return volatile.LoadUint32(&o.IMSCR.Reg) & 0x1
}

// CRYP.RISR: raw interrupt status register
func (o *CRYP_Type) SetRISR_OUTRIS(value uint32) {
	volatile.StoreUint32(&o.RISR.Reg, volatile.LoadUint32(&o.RISR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_Type) GetRISR_OUTRIS() uint32 {
	return (volatile.LoadUint32(&o.RISR.Reg) & 0x2) >> 1
}
func (o *CRYP_Type) SetRISR_INRIS(value uint32) {
	volatile.StoreUint32(&o.RISR.Reg, volatile.LoadUint32(&o.RISR.Reg)&^(0x1)|value)
}
func (o *CRYP_Type) GetRISR_INRIS() uint32 {
	return volatile.LoadUint32(&o.RISR.Reg) & 0x1
}

// CRYP.MISR: masked interrupt status register
func (o *CRYP_Type) SetMISR_OUTMIS(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_Type) GetMISR_OUTMIS() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x2) >> 1
}
func (o *CRYP_Type) SetMISR_INMIS(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x1)|value)
}
func (o *CRYP_Type) GetMISR_INMIS() uint32 {
	return volatile.LoadUint32(&o.MISR.Reg) & 0x1
}

type CRYP_KEY_Type struct {
	KLR volatile.Register32 // 0x20
	KRR volatile.Register32 // 0x24
}

// CRYP_KEY.KLR: key registers
func (o *CRYP_KEY_Type) SetKLR(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, value)
}
func (o *CRYP_KEY_Type) GetKLR() uint32 {
	return volatile.LoadUint32(&o.KLR.Reg)
}

// CRYP_KEY.KRR: key registers
func (o *CRYP_KEY_Type) SetKRR(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, value)
}
func (o *CRYP_KEY_Type) GetKRR() uint32 {
	return volatile.LoadUint32(&o.KRR.Reg)
}

type CRYP_INIT_Type struct {
	IVLR volatile.Register32 // 0x40
	IVRR volatile.Register32 // 0x44
}

// CRYP_INIT.IVLR: initialization vector registers
func (o *CRYP_INIT_Type) SetIVLR(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, value)
}
func (o *CRYP_INIT_Type) GetIVLR() uint32 {
	return volatile.LoadUint32(&o.IVLR.Reg)
}

// CRYP_INIT.IVRR: initialization vector registers
func (o *CRYP_INIT_Type) SetIVRR(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, value)
}
func (o *CRYP_INIT_Type) GetIVRR() uint32 {
	return volatile.LoadUint32(&o.IVRR.Reg)
}

// USB on the go high speed
type USB_OTG_HS_Type struct {
	OTG_HS_GOTGCTL        volatile.Register32 // 0x0
	OTG_HS_GOTGINT        volatile.Register32 // 0x4
	OTG_HS_GAHBCFG        volatile.Register32 // 0x8
	OTG_HS_GUSBCFG        volatile.Register32 // 0xC
	OTG_HS_GRSTCTL        volatile.Register32 // 0x10
	OTG_HS_GINTSTS        volatile.Register32 // 0x14
	OTG_HS_GINTMSK        volatile.Register32 // 0x18
	OTG_HS_GRXSTSR_Host   volatile.Register32 // 0x1C
	OTG_HS_GRXSTSP_Host   volatile.Register32 // 0x20
	OTG_HS_GRXFSIZ        volatile.Register32 // 0x24
	OTG_HS_GNPTXFSIZ_Host volatile.Register32 // 0x28
	OTG_HS_GNPTXSTS       volatile.Register32 // 0x2C
	_                     [8]byte
	OTG_HS_GCCFG          volatile.Register32 // 0x38
	OTG_HS_CID            volatile.Register32 // 0x3C
	_                     [192]byte
	OTG_HS_HPTXFSIZ       volatile.Register32 // 0x100
	OTG_HS_DIEPTXF1       volatile.Register32 // 0x104
	OTG_HS_DIEPTXF2       volatile.Register32 // 0x108
	_                     [16]byte
	OTG_HS_DIEPTXF3       volatile.Register32 // 0x11C
	OTG_HS_DIEPTXF4       volatile.Register32 // 0x120
	OTG_HS_DIEPTXF5       volatile.Register32 // 0x124
	OTG_HS_DIEPTXF6       volatile.Register32 // 0x128
	OTG_HS_DIEPTXF7       volatile.Register32 // 0x12C
}

// USB_OTG_HS.OTG_HS_GOTGCTL: OTG_HS control and status register
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_SRQSCS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_SRQSCS() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_SRQ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_SRQ() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_HNGSCS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_HNGSCS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_HNPRQ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_HNPRQ() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_HSHNPEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_HSHNPEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x400) >> 10
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_DHNPEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_DHNPEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_CIDSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_CIDSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_DBCT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_DBCT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_ASVLD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_ASVLD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_BSVLD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_BSVLD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x80000) >> 19
}

// USB_OTG_HS.OTG_HS_GOTGINT: OTG_HS interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGINT_SEDET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGINT_SEDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGINT_SRSSCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGINT_SRSSCHG() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGINT_HNSSCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGINT_HNSSCHG() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGINT_HNGDET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGINT_HNGDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGINT_ADTOCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGINT_ADTOCHG() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGINT_DBCDNE(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGINT_DBCDNE() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg) & 0x80000) >> 19
}

// USB_OTG_HS.OTG_HS_GAHBCFG: OTG_HS AHB configuration register
func (o *USB_OTG_HS_Type) SetOTG_HS_GAHBCFG_GINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GAHBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GAHBCFG_GINT() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GAHBCFG_HBSTLEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GAHBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg)&^(0x1e)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GAHBCFG_HBSTLEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg) & 0x1e) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GAHBCFG_DMAEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GAHBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GAHBCFG_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GAHBCFG_TXFELVL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GAHBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GAHBCFG_TXFELVL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GAHBCFG_PTXFELVL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GAHBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GAHBCFG_PTXFELVL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg) & 0x100) >> 8
}

// USB_OTG_HS.OTG_HS_GUSBCFG: OTG_HS USB configuration register
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_TOCAL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x7)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_TOCAL() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_PHYSEL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_PHYSEL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_SRPCAP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_SRPCAP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_HNPCAP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_HNPCAP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_TRDT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x3c00)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_TRDT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x3c00) >> 10
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_PHYLPCS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_PHYLPCS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_ULPIFSLS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_ULPIFSLS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_ULPIAR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_ULPIAR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_ULPICSM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_ULPICSM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_ULPIEVBUSD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_ULPIEVBUSD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_ULPIEVBUSI(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_ULPIEVBUSI() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_TSDPS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x400000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_TSDPS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x400000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_PCCI(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x800000)|value<<23)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_PCCI() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x800000) >> 23
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_PTCI(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_PTCI() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_ULPIIPD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_ULPIIPD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x2000000) >> 25
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_FHMOD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_FHMOD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_FDMOD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_FDMOD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_CTXPKT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_CTXPKT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_GRSTCTL: OTG_HS reset register
func (o *USB_OTG_HS_Type) SetOTG_HS_GRSTCTL_CSRST(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRSTCTL_CSRST() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRSTCTL_HSRST(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRSTCTL_HSRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRSTCTL_FCRST(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRSTCTL_FCRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRSTCTL_RXFFLSH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRSTCTL_RXFFLSH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRSTCTL_TXFFLSH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRSTCTL_TXFFLSH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRSTCTL_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg)&^(0x7c0)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRSTCTL_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg) & 0x7c0) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRSTCTL_DMAREQ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRSTCTL_DMAREQ() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRSTCTL_AHBIDL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRSTCTL_AHBIDL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_GINTSTS: OTG_HS core interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_CMOD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_CMOD() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_MMIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_MMIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_OTGINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_OTGINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_SOF(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_SOF() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_RXFLVL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_RXFLVL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_NPTXFE(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_NPTXFE() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_GINAKEFF(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_GINAKEFF() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_BOUTNAKEFF(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_BOUTNAKEFF() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_ESUSP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_ESUSP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x400) >> 10
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_USBSUSP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_USBSUSP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_USBRST(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_USBRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_ENUMDNE(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_ENUMDNE() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x2000) >> 13
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_ISOODRP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x4000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_ISOODRP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x4000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_EOPF(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_EOPF() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_IEPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_IEPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_OEPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_OEPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_IISOIXFR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_IISOIXFR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_PXFR_INCOMPISOOUT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_PXFR_INCOMPISOOUT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_DATAFSUSP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x400000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_DATAFSUSP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x400000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_HPRTINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_HPRTINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_HCINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_HCINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x2000000) >> 25
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_PTXFE(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_PTXFE() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_CIDSCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_CIDSCHG() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_DISCINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_DISCINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_SRQINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_SRQINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_WKUINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_WKUINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_GINTMSK: OTG_HS interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_MMISM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_MMISM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_OTGINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_OTGINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_SOFM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_SOFM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_RXFLVLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_RXFLVLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_NPTXFEM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_NPTXFEM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_GINAKEFFM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_GINAKEFFM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_GONAKEFFM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_GONAKEFFM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_ESUSPM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_ESUSPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x400) >> 10
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_USBSUSPM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_USBSUSPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_USBRST(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_USBRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_ENUMDNEM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_ENUMDNEM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x2000) >> 13
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_ISOODRPM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x4000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_ISOODRPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x4000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_EOPFM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_EOPFM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_EPMISM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_EPMISM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_IEPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_IEPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_OEPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_OEPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_IISOIXFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_IISOIXFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_PXFRM_IISOOXFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_PXFRM_IISOOXFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_FSUSPM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x400000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_FSUSPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x400000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_PRTIM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_PRTIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_HCIM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_HCIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x2000000) >> 25
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_PTXFEM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_PTXFEM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_CIDSCHGM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_CIDSCHGM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_DISCINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_DISCINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_SRQIM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_SRQIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_WUIM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_WUIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_GRXSTSR_Host: OTG_HS Receive status debug read register (host mode)
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXSTSR_Host_CHNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXSTSR_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GRXSTSR_Host.Reg)&^(0xf)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXSTSR_Host_CHNUM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GRXSTSR_Host.Reg) & 0xf
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXSTSR_Host_BCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXSTSR_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GRXSTSR_Host.Reg)&^(0x7ff0)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXSTSR_Host_BCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRXSTSR_Host.Reg) & 0x7ff0) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXSTSR_Host_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXSTSR_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GRXSTSR_Host.Reg)&^(0x18000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXSTSR_Host_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRXSTSR_Host.Reg) & 0x18000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXSTSR_Host_PKTSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXSTSR_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GRXSTSR_Host.Reg)&^(0x1e0000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXSTSR_Host_PKTSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRXSTSR_Host.Reg) & 0x1e0000) >> 17
}

// USB_OTG_HS.OTG_HS_GRXSTSP_Host: OTG_HS status read and pop register (host mode)
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXSTSP_Host_CHNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXSTSP_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GRXSTSP_Host.Reg)&^(0xf)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXSTSP_Host_CHNUM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GRXSTSP_Host.Reg) & 0xf
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXSTSP_Host_BCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXSTSP_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GRXSTSP_Host.Reg)&^(0x7ff0)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXSTSP_Host_BCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRXSTSP_Host.Reg) & 0x7ff0) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXSTSP_Host_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXSTSP_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GRXSTSP_Host.Reg)&^(0x18000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXSTSP_Host_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRXSTSP_Host.Reg) & 0x18000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXSTSP_Host_PKTSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXSTSP_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GRXSTSP_Host.Reg)&^(0x1e0000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXSTSP_Host_PKTSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRXSTSP_Host.Reg) & 0x1e0000) >> 17
}

// USB_OTG_HS.OTG_HS_GRXFSIZ: OTG_HS Receive FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXFSIZ_RXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXFSIZ.Reg, volatile.LoadUint32(&o.OTG_HS_GRXFSIZ.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXFSIZ_RXFD() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GRXFSIZ.Reg) & 0xffff
}

// USB_OTG_HS.OTG_HS_GNPTXFSIZ_Host: OTG_HS nonperiodic transmit FIFO size register (host mode)
func (o *USB_OTG_HS_Type) SetOTG_HS_GNPTXFSIZ_Host_NPTXFSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GNPTXFSIZ_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GNPTXFSIZ_Host.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GNPTXFSIZ_Host_NPTXFSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GNPTXFSIZ_Host.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GNPTXFSIZ_Host_NPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GNPTXFSIZ_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GNPTXFSIZ_Host.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GNPTXFSIZ_Host_NPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GNPTXFSIZ_Host.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_GNPTXSTS: OTG_HS nonperiodic transmit FIFO/queue status register
func (o *USB_OTG_HS_Type) SetOTG_HS_GNPTXSTS_NPTXFSAV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GNPTXSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GNPTXSTS.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GNPTXSTS_NPTXFSAV() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GNPTXSTS.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GNPTXSTS_NPTQXSAV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GNPTXSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GNPTXSTS.Reg)&^(0xff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GNPTXSTS_NPTQXSAV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GNPTXSTS.Reg) & 0xff0000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GNPTXSTS_NPTXQTOP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GNPTXSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GNPTXSTS.Reg)&^(0x7f000000)|value<<24)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GNPTXSTS_NPTXQTOP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GNPTXSTS.Reg) & 0x7f000000) >> 24
}

// USB_OTG_HS.OTG_HS_GCCFG: OTG_HS general core configuration register
func (o *USB_OTG_HS_Type) SetOTG_HS_GCCFG_PWRDWN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GCCFG_PWRDWN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GCCFG_I2CPADEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GCCFG_I2CPADEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GCCFG_VBUSASEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GCCFG_VBUSASEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GCCFG_VBUSBSEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GCCFG_VBUSBSEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GCCFG_SOFOUTEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GCCFG_SOFOUTEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GCCFG_NOVBUSSENS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GCCFG_NOVBUSSENS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg) & 0x200000) >> 21
}

// USB_OTG_HS.OTG_HS_CID: OTG_HS core ID register
func (o *USB_OTG_HS_Type) SetOTG_HS_CID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_CID.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_CID() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_CID.Reg)
}

// USB_OTG_HS.OTG_HS_HPTXFSIZ: OTG_HS Host periodic transmit FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HPTXFSIZ_PTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPTXFSIZ.Reg, volatile.LoadUint32(&o.OTG_HS_HPTXFSIZ.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPTXFSIZ_PTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HPTXFSIZ.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HPTXFSIZ_PTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPTXFSIZ.Reg, volatile.LoadUint32(&o.OTG_HS_HPTXFSIZ.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPTXFSIZ_PTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HPTXFSIZ.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_DIEPTXF1: OTG_HS device IN endpoint transmit FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF1_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF1.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF1.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF1_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_DIEPTXF1.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF1_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF1.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF1.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF1_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_DIEPTXF1.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_DIEPTXF2: OTG_HS device IN endpoint transmit FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF2_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF2.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF2.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF2_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_DIEPTXF2.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF2_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF2.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF2.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF2_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_DIEPTXF2.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_DIEPTXF3: OTG_HS device IN endpoint transmit FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF3_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF3.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF3.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF3_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_DIEPTXF3.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF3_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF3.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF3.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF3_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_DIEPTXF3.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_DIEPTXF4: OTG_HS device IN endpoint transmit FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF4_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF4.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF4.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF4_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_DIEPTXF4.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF4_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF4.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF4.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF4_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_DIEPTXF4.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_DIEPTXF5: OTG_HS device IN endpoint transmit FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF5_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF5.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF5.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF5_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_DIEPTXF5.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF5_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF5.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF5.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF5_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_DIEPTXF5.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_DIEPTXF6: OTG_HS device IN endpoint transmit FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF6_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF6.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF6.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF6_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_DIEPTXF6.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF6_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF6.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF6.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF6_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_DIEPTXF6.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_DIEPTXF7: OTG_HS device IN endpoint transmit FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF7_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF7.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF7.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF7_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_DIEPTXF7.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF7_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF7.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF7.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF7_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_DIEPTXF7.Reg) & 0xffff0000) >> 16
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	_     [116]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	_     [116]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	_     [116]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [116]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	_     [244]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
	IPR20 volatile.Register32 // 0x350
}

// NVIC.ISER0: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER0(value uint32) {
	volatile.StoreUint32(&o.ISER0.Reg, value)
}
func (o *NVIC_Type) GetISER0() uint32 {
	return volatile.LoadUint32(&o.ISER0.Reg)
}

// NVIC.ISER1: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER1(value uint32) {
	volatile.StoreUint32(&o.ISER1.Reg, value)
}
func (o *NVIC_Type) GetISER1() uint32 {
	return volatile.LoadUint32(&o.ISER1.Reg)
}

// NVIC.ISER2: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER2(value uint32) {
	volatile.StoreUint32(&o.ISER2.Reg, value)
}
func (o *NVIC_Type) GetISER2() uint32 {
	return volatile.LoadUint32(&o.ISER2.Reg)
}

// NVIC.ICER0: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER0(value uint32) {
	volatile.StoreUint32(&o.ICER0.Reg, value)
}
func (o *NVIC_Type) GetICER0() uint32 {
	return volatile.LoadUint32(&o.ICER0.Reg)
}

// NVIC.ICER1: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER1(value uint32) {
	volatile.StoreUint32(&o.ICER1.Reg, value)
}
func (o *NVIC_Type) GetICER1() uint32 {
	return volatile.LoadUint32(&o.ICER1.Reg)
}

// NVIC.ICER2: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER2(value uint32) {
	volatile.StoreUint32(&o.ICER2.Reg, value)
}
func (o *NVIC_Type) GetICER2() uint32 {
	return volatile.LoadUint32(&o.ICER2.Reg)
}

// NVIC.ISPR0: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR0(value uint32) {
	volatile.StoreUint32(&o.ISPR0.Reg, value)
}
func (o *NVIC_Type) GetISPR0() uint32 {
	return volatile.LoadUint32(&o.ISPR0.Reg)
}

// NVIC.ISPR1: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR1(value uint32) {
	volatile.StoreUint32(&o.ISPR1.Reg, value)
}
func (o *NVIC_Type) GetISPR1() uint32 {
	return volatile.LoadUint32(&o.ISPR1.Reg)
}

// NVIC.ISPR2: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR2(value uint32) {
	volatile.StoreUint32(&o.ISPR2.Reg, value)
}
func (o *NVIC_Type) GetISPR2() uint32 {
	return volatile.LoadUint32(&o.ISPR2.Reg)
}

// NVIC.ICPR0: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR0(value uint32) {
	volatile.StoreUint32(&o.ICPR0.Reg, value)
}
func (o *NVIC_Type) GetICPR0() uint32 {
	return volatile.LoadUint32(&o.ICPR0.Reg)
}

// NVIC.ICPR1: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR1(value uint32) {
	volatile.StoreUint32(&o.ICPR1.Reg, value)
}
func (o *NVIC_Type) GetICPR1() uint32 {
	return volatile.LoadUint32(&o.ICPR1.Reg)
}

// NVIC.ICPR2: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR2(value uint32) {
	volatile.StoreUint32(&o.ICPR2.Reg, value)
}
func (o *NVIC_Type) GetICPR2() uint32 {
	return volatile.LoadUint32(&o.ICPR2.Reg)
}

// NVIC.IABR0: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR0(value uint32) {
	volatile.StoreUint32(&o.IABR0.Reg, value)
}
func (o *NVIC_Type) GetIABR0() uint32 {
	return volatile.LoadUint32(&o.IABR0.Reg)
}

// NVIC.IABR1: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR1(value uint32) {
	volatile.StoreUint32(&o.IABR1.Reg, value)
}
func (o *NVIC_Type) GetIABR1() uint32 {
	return volatile.LoadUint32(&o.IABR1.Reg)
}

// NVIC.IABR2: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR2(value uint32) {
	volatile.StoreUint32(&o.IABR2.Reg, value)
}
func (o *NVIC_Type) GetIABR2() uint32 {
	return volatile.LoadUint32(&o.IABR2.Reg)
}

// NVIC.IPR0: Interrupt Priority Register
func (o *NVIC_Type) SetIPR0_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR0_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR0.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR0_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR0_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR0_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR0_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR0_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR0_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff000000) >> 24
}

// NVIC.IPR1: Interrupt Priority Register
func (o *NVIC_Type) SetIPR1_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR1_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR1.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR1_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR1_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR1_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR1_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR1_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR1_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff000000) >> 24
}

// NVIC.IPR2: Interrupt Priority Register
func (o *NVIC_Type) SetIPR2_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR2_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR2.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR2_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR2_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR2_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR2_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR2_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR2_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff000000) >> 24
}

// NVIC.IPR3: Interrupt Priority Register
func (o *NVIC_Type) SetIPR3_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR3_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR3.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR3_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR3_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR3_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR3_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR3_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR3_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff000000) >> 24
}

// NVIC.IPR4: Interrupt Priority Register
func (o *NVIC_Type) SetIPR4_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR4_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR4.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR4_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR4_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR4_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR4_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR4_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR4_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff000000) >> 24
}

// NVIC.IPR5: Interrupt Priority Register
func (o *NVIC_Type) SetIPR5_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR5_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR5.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR5_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR5_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR5_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR5_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR5_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR5_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff000000) >> 24
}

// NVIC.IPR6: Interrupt Priority Register
func (o *NVIC_Type) SetIPR6_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR6_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR6.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR6_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR6_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR6_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR6_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR6_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR6_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff000000) >> 24
}

// NVIC.IPR7: Interrupt Priority Register
func (o *NVIC_Type) SetIPR7_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR7_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR7.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR7_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR7_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR7_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR7_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR7_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR7_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff000000) >> 24
}

// NVIC.IPR8: Interrupt Priority Register
func (o *NVIC_Type) SetIPR8_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR8_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR8.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR8_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR8_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR8_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR8_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR8_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR8_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff000000) >> 24
}

// NVIC.IPR9: Interrupt Priority Register
func (o *NVIC_Type) SetIPR9_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR9_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR9.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR9_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR9_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR9_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR9_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR9_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR9_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff000000) >> 24
}

// NVIC.IPR10: Interrupt Priority Register
func (o *NVIC_Type) SetIPR10_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR10_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR10.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR10_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR10_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR10_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR10_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR10_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR10_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff000000) >> 24
}

// NVIC.IPR11: Interrupt Priority Register
func (o *NVIC_Type) SetIPR11_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR11_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR11.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR11_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR11_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR11_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR11_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR11_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR11_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff000000) >> 24
}

// NVIC.IPR12: Interrupt Priority Register
func (o *NVIC_Type) SetIPR12_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR12_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR12.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR12_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR12_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR12_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR12_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR12_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR12_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff000000) >> 24
}

// NVIC.IPR13: Interrupt Priority Register
func (o *NVIC_Type) SetIPR13_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR13_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR13.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR13_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR13_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR13_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR13_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR13_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR13_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff000000) >> 24
}

// NVIC.IPR14: Interrupt Priority Register
func (o *NVIC_Type) SetIPR14_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR14_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR14.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR14_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR14_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR14_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR14_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR14_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR14_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff000000) >> 24
}

// NVIC.IPR15: Interrupt Priority Register
func (o *NVIC_Type) SetIPR15_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR15_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR15.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR15_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR15_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR15_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR15_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR15_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR15_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff000000) >> 24
}

// NVIC.IPR16: Interrupt Priority Register
func (o *NVIC_Type) SetIPR16_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR16_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR16.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR16_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR16_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR16_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR16_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR16_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR16_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff000000) >> 24
}

// NVIC.IPR17: Interrupt Priority Register
func (o *NVIC_Type) SetIPR17_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR17_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR17.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR17_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR17_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR17_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR17_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR17_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR17_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff000000) >> 24
}

// NVIC.IPR18: Interrupt Priority Register
func (o *NVIC_Type) SetIPR18_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR18_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR18.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR18_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR18_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR18_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR18_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR18_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR18_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff000000) >> 24
}

// NVIC.IPR19: Interrupt Priority Register
func (o *NVIC_Type) SetIPR19_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR19_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR19.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR19_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR19_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR19_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR19_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR19_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR19_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff000000) >> 24
}

// NVIC.IPR20: Interrupt Priority Register
func (o *NVIC_Type) SetIPR20_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR20_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR20.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR20_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR20_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR20_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR20_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR20_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR20_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff000000) >> 24
}

// Memory protection unit
type MPU_Type struct {
	TYPER volatile.Register32 // 0x0
	CTRL  volatile.Register32 // 0x4
	RNR   volatile.Register32 // 0x8
	RBAR  volatile.Register32 // 0xC
	RASR  volatile.Register32 // 0x10
}

// MPU.TYPER: MPU type register
func (o *MPU_Type) SetTYPER_SEPARATE(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetTYPER_SEPARATE() uint32 {
	return volatile.LoadUint32(&o.TYPER.Reg) & 0x1
}
func (o *MPU_Type) SetTYPER_DREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetTYPER_DREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetTYPER_IREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff0000)|value<<16)
}
func (o *MPU_Type) GetTYPER_IREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff0000) >> 16
}

// MPU.CTRL: MPU control register
func (o *MPU_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *MPU_Type) SetCTRL_HFNMIENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *MPU_Type) GetCTRL_HFNMIENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *MPU_Type) SetCTRL_PRIVDEFENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *MPU_Type) GetCTRL_PRIVDEFENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}

// MPU.RNR: MPU region number register
func (o *MPU_Type) SetRNR_REGION(value uint32) {
	volatile.StoreUint32(&o.RNR.Reg, volatile.LoadUint32(&o.RNR.Reg)&^(0xff)|value)
}
func (o *MPU_Type) GetRNR_REGION() uint32 {
	return volatile.LoadUint32(&o.RNR.Reg) & 0xff
}

// MPU.RBAR: MPU region base address register
func (o *MPU_Type) SetRBAR_REGION(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xf)|value)
}
func (o *MPU_Type) GetRBAR_REGION() uint32 {
	return volatile.LoadUint32(&o.RBAR.Reg) & 0xf
}
func (o *MPU_Type) SetRBAR_VALID(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0x10)|value<<4)
}
func (o *MPU_Type) GetRBAR_VALID() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0x10) >> 4
}
func (o *MPU_Type) SetRBAR_ADDR(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *MPU_Type) GetRBAR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0xffffffe0) >> 5
}

// MPU.RASR: MPU region attribute and size register
func (o *MPU_Type) SetRASR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetRASR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.RASR.Reg) & 0x1
}
func (o *MPU_Type) SetRASR_SIZE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x3e)|value<<1)
}
func (o *MPU_Type) GetRASR_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x3e) >> 1
}
func (o *MPU_Type) SetRASR_SRD(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetRASR_SRD() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetRASR_B(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000)|value<<16)
}
func (o *MPU_Type) GetRASR_B() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000) >> 16
}
func (o *MPU_Type) SetRASR_C(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x20000)|value<<17)
}
func (o *MPU_Type) GetRASR_C() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x20000) >> 17
}
func (o *MPU_Type) SetRASR_S(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x40000)|value<<18)
}
func (o *MPU_Type) GetRASR_S() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x40000) >> 18
}
func (o *MPU_Type) SetRASR_TEX(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x380000)|value<<19)
}
func (o *MPU_Type) GetRASR_TEX() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x380000) >> 19
}
func (o *MPU_Type) SetRASR_AP(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x7000000)|value<<24)
}
func (o *MPU_Type) GetRASR_AP() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x7000000) >> 24
}
func (o *MPU_Type) SetRASR_XN(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000000)|value<<28)
}
func (o *MPU_Type) GetRASR_XN() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000000) >> 28
}

// System control block ACTLR
type SCB_Type struct {
	ACTRL volatile.Register32 // 0x0
}

// SCB.ACTRL: Auxiliary control register
func (o *SCB_Type) SetACTRL_DISFOLD(value uint32) {
	volatile.StoreUint32(&o.ACTRL.Reg, volatile.LoadUint32(&o.ACTRL.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetACTRL_DISFOLD() uint32 {
	return (volatile.LoadUint32(&o.ACTRL.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetACTRL_FPEXCODIS(value uint32) {
	volatile.StoreUint32(&o.ACTRL.Reg, volatile.LoadUint32(&o.ACTRL.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetACTRL_FPEXCODIS() uint32 {
	return (volatile.LoadUint32(&o.ACTRL.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetACTRL_DISRAMODE(value uint32) {
	volatile.StoreUint32(&o.ACTRL.Reg, volatile.LoadUint32(&o.ACTRL.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetACTRL_DISRAMODE() uint32 {
	return (volatile.LoadUint32(&o.ACTRL.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetACTRL_DISITMATBFLUSH(value uint32) {
	volatile.StoreUint32(&o.ACTRL.Reg, volatile.LoadUint32(&o.ACTRL.Reg)&^(0x1000)|value<<12)
}
func (o *SCB_Type) GetACTRL_DISITMATBFLUSH() uint32 {
	return (volatile.LoadUint32(&o.ACTRL.Reg) & 0x1000) >> 12
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD_ volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// STK.CTRL: SysTick control and status register
func (o *STK_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *STK_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *STK_Type) SetCTRL_TICKINT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *STK_Type) GetCTRL_TICKINT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *STK_Type) SetCTRL_CLKSOURCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *STK_Type) GetCTRL_CLKSOURCE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *STK_Type) SetCTRL_COUNTFLAG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *STK_Type) GetCTRL_COUNTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}

// STK.LOAD_: SysTick reload value register
func (o *STK_Type) SetLOAD__RELOAD(value uint32) {
	volatile.StoreUint32(&o.LOAD_.Reg, volatile.LoadUint32(&o.LOAD_.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetLOAD__RELOAD() uint32 {
	return volatile.LoadUint32(&o.LOAD_.Reg) & 0xffffff
}

// STK.VAL: SysTick current value register
func (o *STK_Type) SetVAL_CURRENT(value uint32) {
	volatile.StoreUint32(&o.VAL.Reg, volatile.LoadUint32(&o.VAL.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetVAL_CURRENT() uint32 {
	return volatile.LoadUint32(&o.VAL.Reg) & 0xffffff
}

// STK.CALIB: SysTick calibration value register
func (o *STK_Type) SetCALIB_TENMS(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetCALIB_TENMS() uint32 {
	return volatile.LoadUint32(&o.CALIB.Reg) & 0xffffff
}

// Constants for RNG: Random number generator
const (
	// CR: control register
	// Position of IE field.
	RNG_CR_IE_Pos = 0x3
	// Bit mask of IE field.
	RNG_CR_IE_Msk = 0x8
	// Bit IE.
	RNG_CR_IE = 0x8
	// Position of RNGEN field.
	RNG_CR_RNGEN_Pos = 0x2
	// Bit mask of RNGEN field.
	RNG_CR_RNGEN_Msk = 0x4
	// Bit RNGEN.
	RNG_CR_RNGEN = 0x4

	// SR: status register
	// Position of SEIS field.
	RNG_SR_SEIS_Pos = 0x6
	// Bit mask of SEIS field.
	RNG_SR_SEIS_Msk = 0x40
	// Bit SEIS.
	RNG_SR_SEIS = 0x40
	// Position of CEIS field.
	RNG_SR_CEIS_Pos = 0x5
	// Bit mask of CEIS field.
	RNG_SR_CEIS_Msk = 0x20
	// Bit CEIS.
	RNG_SR_CEIS = 0x20
	// Position of SECS field.
	RNG_SR_SECS_Pos = 0x2
	// Bit mask of SECS field.
	RNG_SR_SECS_Msk = 0x4
	// Bit SECS.
	RNG_SR_SECS = 0x4
	// Position of CECS field.
	RNG_SR_CECS_Pos = 0x1
	// Bit mask of CECS field.
	RNG_SR_CECS_Msk = 0x2
	// Bit CECS.
	RNG_SR_CECS = 0x2
	// Position of DRDY field.
	RNG_SR_DRDY_Pos = 0x0
	// Bit mask of DRDY field.
	RNG_SR_DRDY_Msk = 0x1
	// Bit DRDY.
	RNG_SR_DRDY = 0x1

	// DR: data register
	// Position of RNDATA field.
	RNG_DR_RNDATA_Pos = 0x0
	// Bit mask of RNDATA field.
	RNG_DR_RNDATA_Msk = 0xffffffff
)

// Constants for CRC: cyclic redundancy check calculation unit
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// IDR: Independent data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xff

	// CR: Control register
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1
	// Resets the CRC calculation unit and sets the data register to 0xFFFF FFFF
	CRC_CR_RESET_Reset = 0x1
)

// Constants for DCMI: Digital camera interface
const (
	// CR: control register 1
	// Position of ENABLE field.
	DCMI_CR_ENABLE_Pos = 0xe
	// Bit mask of ENABLE field.
	DCMI_CR_ENABLE_Msk = 0x4000
	// Bit ENABLE.
	DCMI_CR_ENABLE = 0x4000
	// Position of EDM field.
	DCMI_CR_EDM_Pos = 0xa
	// Bit mask of EDM field.
	DCMI_CR_EDM_Msk = 0xc00
	// Position of FCRC field.
	DCMI_CR_FCRC_Pos = 0x8
	// Bit mask of FCRC field.
	DCMI_CR_FCRC_Msk = 0x300
	// Position of VSPOL field.
	DCMI_CR_VSPOL_Pos = 0x7
	// Bit mask of VSPOL field.
	DCMI_CR_VSPOL_Msk = 0x80
	// Bit VSPOL.
	DCMI_CR_VSPOL = 0x80
	// Position of HSPOL field.
	DCMI_CR_HSPOL_Pos = 0x6
	// Bit mask of HSPOL field.
	DCMI_CR_HSPOL_Msk = 0x40
	// Bit HSPOL.
	DCMI_CR_HSPOL = 0x40
	// Position of PCKPOL field.
	DCMI_CR_PCKPOL_Pos = 0x5
	// Bit mask of PCKPOL field.
	DCMI_CR_PCKPOL_Msk = 0x20
	// Bit PCKPOL.
	DCMI_CR_PCKPOL = 0x20
	// Position of ESS field.
	DCMI_CR_ESS_Pos = 0x4
	// Bit mask of ESS field.
	DCMI_CR_ESS_Msk = 0x10
	// Bit ESS.
	DCMI_CR_ESS = 0x10
	// Position of JPEG field.
	DCMI_CR_JPEG_Pos = 0x3
	// Bit mask of JPEG field.
	DCMI_CR_JPEG_Msk = 0x8
	// Bit JPEG.
	DCMI_CR_JPEG = 0x8
	// Position of CROP field.
	DCMI_CR_CROP_Pos = 0x2
	// Bit mask of CROP field.
	DCMI_CR_CROP_Msk = 0x4
	// Bit CROP.
	DCMI_CR_CROP = 0x4
	// Position of CM field.
	DCMI_CR_CM_Pos = 0x1
	// Bit mask of CM field.
	DCMI_CR_CM_Msk = 0x2
	// Bit CM.
	DCMI_CR_CM = 0x2
	// Position of CAPTURE field.
	DCMI_CR_CAPTURE_Pos = 0x0
	// Bit mask of CAPTURE field.
	DCMI_CR_CAPTURE_Msk = 0x1
	// Bit CAPTURE.
	DCMI_CR_CAPTURE = 0x1

	// SR: status register
	// Position of FNE field.
	DCMI_SR_FNE_Pos = 0x2
	// Bit mask of FNE field.
	DCMI_SR_FNE_Msk = 0x4
	// Bit FNE.
	DCMI_SR_FNE = 0x4
	// Position of VSYNC field.
	DCMI_SR_VSYNC_Pos = 0x1
	// Bit mask of VSYNC field.
	DCMI_SR_VSYNC_Msk = 0x2
	// Bit VSYNC.
	DCMI_SR_VSYNC = 0x2
	// Position of HSYNC field.
	DCMI_SR_HSYNC_Pos = 0x0
	// Bit mask of HSYNC field.
	DCMI_SR_HSYNC_Msk = 0x1
	// Bit HSYNC.
	DCMI_SR_HSYNC = 0x1

	// RIS: raw interrupt status register
	// Position of LINE_RIS field.
	DCMI_RIS_LINE_RIS_Pos = 0x4
	// Bit mask of LINE_RIS field.
	DCMI_RIS_LINE_RIS_Msk = 0x10
	// Bit LINE_RIS.
	DCMI_RIS_LINE_RIS = 0x10
	// Position of VSYNC_RIS field.
	DCMI_RIS_VSYNC_RIS_Pos = 0x3
	// Bit mask of VSYNC_RIS field.
	DCMI_RIS_VSYNC_RIS_Msk = 0x8
	// Bit VSYNC_RIS.
	DCMI_RIS_VSYNC_RIS = 0x8
	// Position of ERR_RIS field.
	DCMI_RIS_ERR_RIS_Pos = 0x2
	// Bit mask of ERR_RIS field.
	DCMI_RIS_ERR_RIS_Msk = 0x4
	// Bit ERR_RIS.
	DCMI_RIS_ERR_RIS = 0x4
	// Position of OVR_RIS field.
	DCMI_RIS_OVR_RIS_Pos = 0x1
	// Bit mask of OVR_RIS field.
	DCMI_RIS_OVR_RIS_Msk = 0x2
	// Bit OVR_RIS.
	DCMI_RIS_OVR_RIS = 0x2
	// Position of FRAME_RIS field.
	DCMI_RIS_FRAME_RIS_Pos = 0x0
	// Bit mask of FRAME_RIS field.
	DCMI_RIS_FRAME_RIS_Msk = 0x1
	// Bit FRAME_RIS.
	DCMI_RIS_FRAME_RIS = 0x1

	// IER: interrupt enable register
	// Position of LINE_IE field.
	DCMI_IER_LINE_IE_Pos = 0x4
	// Bit mask of LINE_IE field.
	DCMI_IER_LINE_IE_Msk = 0x10
	// Bit LINE_IE.
	DCMI_IER_LINE_IE = 0x10
	// Position of VSYNC_IE field.
	DCMI_IER_VSYNC_IE_Pos = 0x3
	// Bit mask of VSYNC_IE field.
	DCMI_IER_VSYNC_IE_Msk = 0x8
	// Bit VSYNC_IE.
	DCMI_IER_VSYNC_IE = 0x8
	// Position of ERR_IE field.
	DCMI_IER_ERR_IE_Pos = 0x2
	// Bit mask of ERR_IE field.
	DCMI_IER_ERR_IE_Msk = 0x4
	// Bit ERR_IE.
	DCMI_IER_ERR_IE = 0x4
	// Position of OVR_IE field.
	DCMI_IER_OVR_IE_Pos = 0x1
	// Bit mask of OVR_IE field.
	DCMI_IER_OVR_IE_Msk = 0x2
	// Bit OVR_IE.
	DCMI_IER_OVR_IE = 0x2
	// Position of FRAME_IE field.
	DCMI_IER_FRAME_IE_Pos = 0x0
	// Bit mask of FRAME_IE field.
	DCMI_IER_FRAME_IE_Msk = 0x1
	// Bit FRAME_IE.
	DCMI_IER_FRAME_IE = 0x1

	// MIS: masked interrupt status register
	// Position of LINE_MIS field.
	DCMI_MIS_LINE_MIS_Pos = 0x4
	// Bit mask of LINE_MIS field.
	DCMI_MIS_LINE_MIS_Msk = 0x10
	// Bit LINE_MIS.
	DCMI_MIS_LINE_MIS = 0x10
	// Position of VSYNC_MIS field.
	DCMI_MIS_VSYNC_MIS_Pos = 0x3
	// Bit mask of VSYNC_MIS field.
	DCMI_MIS_VSYNC_MIS_Msk = 0x8
	// Bit VSYNC_MIS.
	DCMI_MIS_VSYNC_MIS = 0x8
	// Position of ERR_MIS field.
	DCMI_MIS_ERR_MIS_Pos = 0x2
	// Bit mask of ERR_MIS field.
	DCMI_MIS_ERR_MIS_Msk = 0x4
	// Bit ERR_MIS.
	DCMI_MIS_ERR_MIS = 0x4
	// Position of OVR_MIS field.
	DCMI_MIS_OVR_MIS_Pos = 0x1
	// Bit mask of OVR_MIS field.
	DCMI_MIS_OVR_MIS_Msk = 0x2
	// Bit OVR_MIS.
	DCMI_MIS_OVR_MIS = 0x2
	// Position of FRAME_MIS field.
	DCMI_MIS_FRAME_MIS_Pos = 0x0
	// Bit mask of FRAME_MIS field.
	DCMI_MIS_FRAME_MIS_Msk = 0x1
	// Bit FRAME_MIS.
	DCMI_MIS_FRAME_MIS = 0x1

	// ICR: interrupt clear register
	// Position of LINE_ISC field.
	DCMI_ICR_LINE_ISC_Pos = 0x4
	// Bit mask of LINE_ISC field.
	DCMI_ICR_LINE_ISC_Msk = 0x10
	// Bit LINE_ISC.
	DCMI_ICR_LINE_ISC = 0x10
	// Position of VSYNC_ISC field.
	DCMI_ICR_VSYNC_ISC_Pos = 0x3
	// Bit mask of VSYNC_ISC field.
	DCMI_ICR_VSYNC_ISC_Msk = 0x8
	// Bit VSYNC_ISC.
	DCMI_ICR_VSYNC_ISC = 0x8
	// Position of ERR_ISC field.
	DCMI_ICR_ERR_ISC_Pos = 0x2
	// Bit mask of ERR_ISC field.
	DCMI_ICR_ERR_ISC_Msk = 0x4
	// Bit ERR_ISC.
	DCMI_ICR_ERR_ISC = 0x4
	// Position of OVR_ISC field.
	DCMI_ICR_OVR_ISC_Pos = 0x1
	// Bit mask of OVR_ISC field.
	DCMI_ICR_OVR_ISC_Msk = 0x2
	// Bit OVR_ISC.
	DCMI_ICR_OVR_ISC = 0x2
	// Position of FRAME_ISC field.
	DCMI_ICR_FRAME_ISC_Pos = 0x0
	// Bit mask of FRAME_ISC field.
	DCMI_ICR_FRAME_ISC_Msk = 0x1
	// Bit FRAME_ISC.
	DCMI_ICR_FRAME_ISC = 0x1

	// ESCR: embedded synchronization code register
	// Position of FEC field.
	DCMI_ESCR_FEC_Pos = 0x18
	// Bit mask of FEC field.
	DCMI_ESCR_FEC_Msk = 0xff000000
	// Position of LEC field.
	DCMI_ESCR_LEC_Pos = 0x10
	// Bit mask of LEC field.
	DCMI_ESCR_LEC_Msk = 0xff0000
	// Position of LSC field.
	DCMI_ESCR_LSC_Pos = 0x8
	// Bit mask of LSC field.
	DCMI_ESCR_LSC_Msk = 0xff00
	// Position of FSC field.
	DCMI_ESCR_FSC_Pos = 0x0
	// Bit mask of FSC field.
	DCMI_ESCR_FSC_Msk = 0xff

	// ESUR: embedded synchronization unmask register
	// Position of FEU field.
	DCMI_ESUR_FEU_Pos = 0x18
	// Bit mask of FEU field.
	DCMI_ESUR_FEU_Msk = 0xff000000
	// Position of LEU field.
	DCMI_ESUR_LEU_Pos = 0x10
	// Bit mask of LEU field.
	DCMI_ESUR_LEU_Msk = 0xff0000
	// Position of LSU field.
	DCMI_ESUR_LSU_Pos = 0x8
	// Bit mask of LSU field.
	DCMI_ESUR_LSU_Msk = 0xff00
	// Position of FSU field.
	DCMI_ESUR_FSU_Pos = 0x0
	// Bit mask of FSU field.
	DCMI_ESUR_FSU_Msk = 0xff

	// CWSTRT: crop window start
	// Position of VST field.
	DCMI_CWSTRT_VST_Pos = 0x10
	// Bit mask of VST field.
	DCMI_CWSTRT_VST_Msk = 0x1fff0000
	// Position of HOFFCNT field.
	DCMI_CWSTRT_HOFFCNT_Pos = 0x0
	// Bit mask of HOFFCNT field.
	DCMI_CWSTRT_HOFFCNT_Msk = 0x3fff

	// CWSIZE: crop window size
	// Position of VLINE field.
	DCMI_CWSIZE_VLINE_Pos = 0x10
	// Bit mask of VLINE field.
	DCMI_CWSIZE_VLINE_Msk = 0x3fff0000
	// Position of CAPCNT field.
	DCMI_CWSIZE_CAPCNT_Pos = 0x0
	// Bit mask of CAPCNT field.
	DCMI_CWSIZE_CAPCNT_Msk = 0x3fff

	// DR: data register
	// Position of Byte3 field.
	DCMI_DR_Byte3_Pos = 0x18
	// Bit mask of Byte3 field.
	DCMI_DR_Byte3_Msk = 0xff000000
	// Position of Byte2 field.
	DCMI_DR_Byte2_Pos = 0x10
	// Bit mask of Byte2 field.
	DCMI_DR_Byte2_Msk = 0xff0000
	// Position of Byte1 field.
	DCMI_DR_Byte1_Pos = 0x8
	// Bit mask of Byte1 field.
	DCMI_DR_Byte1_Msk = 0xff00
	// Position of Byte0 field.
	DCMI_DR_Byte0_Pos = 0x0
	// Bit mask of Byte0 field.
	DCMI_DR_Byte0_Msk = 0xff
)

// Constants for FSMC: Flexible static memory controller
const (
	// BCR1: SRAM/NOR-Flash chip-select control register 1
	// Position of CBURSTRW field.
	FSMC_BCR1_CBURSTRW_Pos = 0x13
	// Bit mask of CBURSTRW field.
	FSMC_BCR1_CBURSTRW_Msk = 0x80000
	// Bit CBURSTRW.
	FSMC_BCR1_CBURSTRW = 0x80000
	// Write operations are performed in synchronous mode
	FSMC_BCR1_CBURSTRW_Enabled = 0x1
	// Write operations are always performed in asynchronous mode
	FSMC_BCR1_CBURSTRW_Disabled = 0x0
	// Position of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT_Pos = 0xf
	// Bit mask of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT_Msk = 0x8000
	// Bit ASYNCWAIT.
	FSMC_BCR1_ASYNCWAIT = 0x8000
	// Wait signal not used in asynchronous mode
	FSMC_BCR1_ASYNCWAIT_Disabled = 0x0
	// Wait signal used even in asynchronous mode
	FSMC_BCR1_ASYNCWAIT_Enabled = 0x1
	// Position of EXTMOD field.
	FSMC_BCR1_EXTMOD_Pos = 0xe
	// Bit mask of EXTMOD field.
	FSMC_BCR1_EXTMOD_Msk = 0x4000
	// Bit EXTMOD.
	FSMC_BCR1_EXTMOD = 0x4000
	// Values inside the FMC_BWTR are not taken into account
	FSMC_BCR1_EXTMOD_Disabled = 0x0
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR1_EXTMOD_Enabled = 0x1
	// Position of WAITEN field.
	FSMC_BCR1_WAITEN_Pos = 0xd
	// Bit mask of WAITEN field.
	FSMC_BCR1_WAITEN_Msk = 0x2000
	// Bit WAITEN.
	FSMC_BCR1_WAITEN = 0x2000
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR1_WAITEN_Disabled = 0x0
	// NWAIT signal enabled
	FSMC_BCR1_WAITEN_Enabled = 0x1
	// Position of WREN field.
	FSMC_BCR1_WREN_Pos = 0xc
	// Bit mask of WREN field.
	FSMC_BCR1_WREN_Msk = 0x1000
	// Bit WREN.
	FSMC_BCR1_WREN = 0x1000
	// Write operations disabled for the bank by the FMC
	FSMC_BCR1_WREN_Disabled = 0x0
	// Write operations enabled for the bank by the FMC
	FSMC_BCR1_WREN_Enabled = 0x1
	// Position of WAITCFG field.
	FSMC_BCR1_WAITCFG_Pos = 0xb
	// Bit mask of WAITCFG field.
	FSMC_BCR1_WAITCFG_Msk = 0x800
	// Bit WAITCFG.
	FSMC_BCR1_WAITCFG = 0x800
	// NWAIT signal is active one data cycle before wait state
	FSMC_BCR1_WAITCFG_BeforeWaitState = 0x0
	// NWAIT signal is active during wait state
	FSMC_BCR1_WAITCFG_DuringWaitState = 0x1
	// Position of WAITPOL field.
	FSMC_BCR1_WAITPOL_Pos = 0x9
	// Bit mask of WAITPOL field.
	FSMC_BCR1_WAITPOL_Msk = 0x200
	// Bit WAITPOL.
	FSMC_BCR1_WAITPOL = 0x200
	// NWAIT active low
	FSMC_BCR1_WAITPOL_ActiveLow = 0x0
	// NWAIT active high
	FSMC_BCR1_WAITPOL_ActiveHigh = 0x1
	// Position of BURSTEN field.
	FSMC_BCR1_BURSTEN_Pos = 0x8
	// Bit mask of BURSTEN field.
	FSMC_BCR1_BURSTEN_Msk = 0x100
	// Bit BURSTEN.
	FSMC_BCR1_BURSTEN = 0x100
	// Burst mode disabled
	FSMC_BCR1_BURSTEN_Disabled = 0x0
	// Burst mode enabled
	FSMC_BCR1_BURSTEN_Enabled = 0x1
	// Position of FACCEN field.
	FSMC_BCR1_FACCEN_Pos = 0x6
	// Bit mask of FACCEN field.
	FSMC_BCR1_FACCEN_Msk = 0x40
	// Bit FACCEN.
	FSMC_BCR1_FACCEN = 0x40
	// Corresponding NOR Flash memory access is disabled
	FSMC_BCR1_FACCEN_Disabled = 0x0
	// Corresponding NOR Flash memory access is enabled
	FSMC_BCR1_FACCEN_Enabled = 0x1
	// Position of MWID field.
	FSMC_BCR1_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FSMC_BCR1_MWID_Msk = 0x30
	// Memory data bus width 8 bits
	FSMC_BCR1_MWID_Bits8 = 0x0
	// Memory data bus width 16 bits
	FSMC_BCR1_MWID_Bits16 = 0x1
	// Memory data bus width 32 bits
	FSMC_BCR1_MWID_Bits32 = 0x2
	// Position of MTYP field.
	FSMC_BCR1_MTYP_Pos = 0x2
	// Bit mask of MTYP field.
	FSMC_BCR1_MTYP_Msk = 0xc
	// SRAM memory type
	FSMC_BCR1_MTYP_SRAM = 0x0
	// PSRAM (CRAM) memory type
	FSMC_BCR1_MTYP_PSRAM = 0x1
	// NOR Flash/OneNAND Flash
	FSMC_BCR1_MTYP_Flash = 0x2
	// Position of MUXEN field.
	FSMC_BCR1_MUXEN_Pos = 0x1
	// Bit mask of MUXEN field.
	FSMC_BCR1_MUXEN_Msk = 0x2
	// Bit MUXEN.
	FSMC_BCR1_MUXEN = 0x2
	// Address/Data non-multiplexed
	FSMC_BCR1_MUXEN_Disabled = 0x0
	// Address/Data multiplexed on databus
	FSMC_BCR1_MUXEN_Enabled = 0x1
	// Position of MBKEN field.
	FSMC_BCR1_MBKEN_Pos = 0x0
	// Bit mask of MBKEN field.
	FSMC_BCR1_MBKEN_Msk = 0x1
	// Bit MBKEN.
	FSMC_BCR1_MBKEN = 0x1
	// Corresponding memory bank is disabled
	FSMC_BCR1_MBKEN_Disabled = 0x0
	// Corresponding memory bank is enabled
	FSMC_BCR1_MBKEN_Enabled = 0x1
	// Position of WRAPMOD field.
	FSMC_BCR1_WRAPMOD_Pos = 0xa
	// Bit mask of WRAPMOD field.
	FSMC_BCR1_WRAPMOD_Msk = 0x400
	// Bit WRAPMOD.
	FSMC_BCR1_WRAPMOD = 0x400
	// Position of CPSIZE field.
	FSMC_BCR1_CPSIZE_Pos = 0x10
	// Bit mask of CPSIZE field.
	FSMC_BCR1_CPSIZE_Msk = 0x70000
	// No burst split when crossing page boundary
	FSMC_BCR1_CPSIZE_NoBurstSplit = 0x0
	// 128 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes128 = 0x1
	// 256 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes256 = 0x2
	// 512 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes512 = 0x3
	// 1024 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes1024 = 0x4

	// BTR1: SRAM/NOR-Flash chip-select timing register 1
	// Position of ACCMOD field.
	FSMC_BTR_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FSMC_BTR_ACCMOD_Msk = 0x30000000
	// Access mode A
	FSMC_BTR_ACCMOD_A = 0x0
	// Access mode B
	FSMC_BTR_ACCMOD_B = 0x1
	// Access mode C
	FSMC_BTR_ACCMOD_C = 0x2
	// Access mode D
	FSMC_BTR_ACCMOD_D = 0x3
	// Position of DATLAT field.
	FSMC_BTR_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FSMC_BTR_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FSMC_BTR_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FSMC_BTR_CLKDIV_Msk = 0xf00000
	// Position of BUSTURN field.
	FSMC_BTR_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FSMC_BTR_BUSTURN_Msk = 0xf0000
	// Position of DATAST field.
	FSMC_BTR_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FSMC_BTR_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FSMC_BTR_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FSMC_BTR_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FSMC_BTR_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FSMC_BTR_ADDSET_Msk = 0xf

	// BCR2: SRAM/NOR-Flash chip-select control register 2
	// Position of CBURSTRW field.
	FSMC_BCR_CBURSTRW_Pos = 0x13
	// Bit mask of CBURSTRW field.
	FSMC_BCR_CBURSTRW_Msk = 0x80000
	// Bit CBURSTRW.
	FSMC_BCR_CBURSTRW = 0x80000
	// Write operations are performed in synchronous mode
	FSMC_BCR_CBURSTRW_Enabled = 0x1
	// Write operations are always performed in asynchronous mode
	FSMC_BCR_CBURSTRW_Disabled = 0x0
	// Position of ASYNCWAIT field.
	FSMC_BCR_ASYNCWAIT_Pos = 0xf
	// Bit mask of ASYNCWAIT field.
	FSMC_BCR_ASYNCWAIT_Msk = 0x8000
	// Bit ASYNCWAIT.
	FSMC_BCR_ASYNCWAIT = 0x8000
	// Wait signal not used in asynchronous mode
	FSMC_BCR_ASYNCWAIT_Disabled = 0x0
	// Wait signal used even in asynchronous mode
	FSMC_BCR_ASYNCWAIT_Enabled = 0x1
	// Position of EXTMOD field.
	FSMC_BCR_EXTMOD_Pos = 0xe
	// Bit mask of EXTMOD field.
	FSMC_BCR_EXTMOD_Msk = 0x4000
	// Bit EXTMOD.
	FSMC_BCR_EXTMOD = 0x4000
	// Values inside the FMC_BWTR are not taken into account
	FSMC_BCR_EXTMOD_Disabled = 0x0
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR_EXTMOD_Enabled = 0x1
	// Position of WAITEN field.
	FSMC_BCR_WAITEN_Pos = 0xd
	// Bit mask of WAITEN field.
	FSMC_BCR_WAITEN_Msk = 0x2000
	// Bit WAITEN.
	FSMC_BCR_WAITEN = 0x2000
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR_WAITEN_Disabled = 0x0
	// NWAIT signal enabled
	FSMC_BCR_WAITEN_Enabled = 0x1
	// Position of WREN field.
	FSMC_BCR_WREN_Pos = 0xc
	// Bit mask of WREN field.
	FSMC_BCR_WREN_Msk = 0x1000
	// Bit WREN.
	FSMC_BCR_WREN = 0x1000
	// Write operations disabled for the bank by the FMC
	FSMC_BCR_WREN_Disabled = 0x0
	// Write operations enabled for the bank by the FMC
	FSMC_BCR_WREN_Enabled = 0x1
	// Position of WAITCFG field.
	FSMC_BCR_WAITCFG_Pos = 0xb
	// Bit mask of WAITCFG field.
	FSMC_BCR_WAITCFG_Msk = 0x800
	// Bit WAITCFG.
	FSMC_BCR_WAITCFG = 0x800
	// NWAIT signal is active one data cycle before wait state
	FSMC_BCR_WAITCFG_BeforeWaitState = 0x0
	// NWAIT signal is active during wait state
	FSMC_BCR_WAITCFG_DuringWaitState = 0x1
	// Position of WRAPMOD field.
	FSMC_BCR_WRAPMOD_Pos = 0xa
	// Bit mask of WRAPMOD field.
	FSMC_BCR_WRAPMOD_Msk = 0x400
	// Bit WRAPMOD.
	FSMC_BCR_WRAPMOD = 0x400
	// Position of WAITPOL field.
	FSMC_BCR_WAITPOL_Pos = 0x9
	// Bit mask of WAITPOL field.
	FSMC_BCR_WAITPOL_Msk = 0x200
	// Bit WAITPOL.
	FSMC_BCR_WAITPOL = 0x200
	// NWAIT active low
	FSMC_BCR_WAITPOL_ActiveLow = 0x0
	// NWAIT active high
	FSMC_BCR_WAITPOL_ActiveHigh = 0x1
	// Position of BURSTEN field.
	FSMC_BCR_BURSTEN_Pos = 0x8
	// Bit mask of BURSTEN field.
	FSMC_BCR_BURSTEN_Msk = 0x100
	// Bit BURSTEN.
	FSMC_BCR_BURSTEN = 0x100
	// Burst mode disabled
	FSMC_BCR_BURSTEN_Disabled = 0x0
	// Burst mode enabled
	FSMC_BCR_BURSTEN_Enabled = 0x1
	// Position of FACCEN field.
	FSMC_BCR_FACCEN_Pos = 0x6
	// Bit mask of FACCEN field.
	FSMC_BCR_FACCEN_Msk = 0x40
	// Bit FACCEN.
	FSMC_BCR_FACCEN = 0x40
	// Corresponding NOR Flash memory access is disabled
	FSMC_BCR_FACCEN_Disabled = 0x0
	// Corresponding NOR Flash memory access is enabled
	FSMC_BCR_FACCEN_Enabled = 0x1
	// Position of MWID field.
	FSMC_BCR_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FSMC_BCR_MWID_Msk = 0x30
	// Memory data bus width 8 bits
	FSMC_BCR_MWID_Bits8 = 0x0
	// Memory data bus width 16 bits
	FSMC_BCR_MWID_Bits16 = 0x1
	// Memory data bus width 32 bits
	FSMC_BCR_MWID_Bits32 = 0x2
	// Position of MTYP field.
	FSMC_BCR_MTYP_Pos = 0x2
	// Bit mask of MTYP field.
	FSMC_BCR_MTYP_Msk = 0xc
	// SRAM memory type
	FSMC_BCR_MTYP_SRAM = 0x0
	// PSRAM (CRAM) memory type
	FSMC_BCR_MTYP_PSRAM = 0x1
	// NOR Flash/OneNAND Flash
	FSMC_BCR_MTYP_Flash = 0x2
	// Position of MUXEN field.
	FSMC_BCR_MUXEN_Pos = 0x1
	// Bit mask of MUXEN field.
	FSMC_BCR_MUXEN_Msk = 0x2
	// Bit MUXEN.
	FSMC_BCR_MUXEN = 0x2
	// Address/Data non-multiplexed
	FSMC_BCR_MUXEN_Disabled = 0x0
	// Address/Data multiplexed on databus
	FSMC_BCR_MUXEN_Enabled = 0x1
	// Position of MBKEN field.
	FSMC_BCR_MBKEN_Pos = 0x0
	// Bit mask of MBKEN field.
	FSMC_BCR_MBKEN_Msk = 0x1
	// Bit MBKEN.
	FSMC_BCR_MBKEN = 0x1
	// Corresponding memory bank is disabled
	FSMC_BCR_MBKEN_Disabled = 0x0
	// Corresponding memory bank is enabled
	FSMC_BCR_MBKEN_Enabled = 0x1
	// Position of CPSIZE field.
	FSMC_BCR_CPSIZE_Pos = 0x10
	// Bit mask of CPSIZE field.
	FSMC_BCR_CPSIZE_Msk = 0x70000
	// No burst split when crossing page boundary
	FSMC_BCR_CPSIZE_NoBurstSplit = 0x0
	// 128 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes128 = 0x1
	// 256 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes256 = 0x2
	// 512 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes512 = 0x3
	// 1024 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes1024 = 0x4

	// PCR2: PC Card/NAND Flash control register 2
	// Position of ECCPS field.
	FSMC_PCR_ECCPS_Pos = 0x11
	// Bit mask of ECCPS field.
	FSMC_PCR_ECCPS_Msk = 0xe0000
	// ECC page size 256 bytes
	FSMC_PCR_ECCPS_Bytes256 = 0x0
	// ECC page size 512 bytes
	FSMC_PCR_ECCPS_Bytes512 = 0x1
	// ECC page size 1024 bytes
	FSMC_PCR_ECCPS_Bytes1024 = 0x2
	// ECC page size 2048 bytes
	FSMC_PCR_ECCPS_Bytes2048 = 0x3
	// ECC page size 4096 bytes
	FSMC_PCR_ECCPS_Bytes4096 = 0x4
	// ECC page size 8192 bytes
	FSMC_PCR_ECCPS_Bytes8192 = 0x5
	// Position of TAR field.
	FSMC_PCR_TAR_Pos = 0xd
	// Bit mask of TAR field.
	FSMC_PCR_TAR_Msk = 0x1e000
	// Position of TCLR field.
	FSMC_PCR_TCLR_Pos = 0x9
	// Bit mask of TCLR field.
	FSMC_PCR_TCLR_Msk = 0x1e00
	// Position of ECCEN field.
	FSMC_PCR_ECCEN_Pos = 0x6
	// Bit mask of ECCEN field.
	FSMC_PCR_ECCEN_Msk = 0x40
	// Bit ECCEN.
	FSMC_PCR_ECCEN = 0x40
	// ECC logic is disabled and reset
	FSMC_PCR_ECCEN_Disabled = 0x0
	// ECC logic is enabled
	FSMC_PCR_ECCEN_Enabled = 0x1
	// Position of PWID field.
	FSMC_PCR_PWID_Pos = 0x4
	// Bit mask of PWID field.
	FSMC_PCR_PWID_Msk = 0x30
	// External memory device width 8 bits
	FSMC_PCR_PWID_Bits8 = 0x0
	// External memory device width 16 bits
	FSMC_PCR_PWID_Bits16 = 0x1
	// Position of PTYP field.
	FSMC_PCR_PTYP_Pos = 0x3
	// Bit mask of PTYP field.
	FSMC_PCR_PTYP_Msk = 0x8
	// Bit PTYP.
	FSMC_PCR_PTYP = 0x8
	// NAND Flash
	FSMC_PCR_PTYP_NANDFlash = 0x1
	// Position of PBKEN field.
	FSMC_PCR_PBKEN_Pos = 0x2
	// Bit mask of PBKEN field.
	FSMC_PCR_PBKEN_Msk = 0x4
	// Bit PBKEN.
	FSMC_PCR_PBKEN = 0x4
	// Corresponding memory bank is disabled
	FSMC_PCR_PBKEN_Disabled = 0x0
	// Corresponding memory bank is enabled
	FSMC_PCR_PBKEN_Enabled = 0x1
	// Position of PWAITEN field.
	FSMC_PCR_PWAITEN_Pos = 0x1
	// Bit mask of PWAITEN field.
	FSMC_PCR_PWAITEN_Msk = 0x2
	// Bit PWAITEN.
	FSMC_PCR_PWAITEN = 0x2
	// Wait feature disabled
	FSMC_PCR_PWAITEN_Disabled = 0x0
	// Wait feature enabled
	FSMC_PCR_PWAITEN_Enabled = 0x1

	// SR2: FIFO status and interrupt register 2
	// Position of FEMPT field.
	FSMC_SR_FEMPT_Pos = 0x6
	// Bit mask of FEMPT field.
	FSMC_SR_FEMPT_Msk = 0x40
	// Bit FEMPT.
	FSMC_SR_FEMPT = 0x40
	// FIFO not empty
	FSMC_SR_FEMPT_NotEmpty = 0x0
	// FIFO empty
	FSMC_SR_FEMPT_Empty = 0x1
	// Position of IFEN field.
	FSMC_SR_IFEN_Pos = 0x5
	// Bit mask of IFEN field.
	FSMC_SR_IFEN_Msk = 0x20
	// Bit IFEN.
	FSMC_SR_IFEN = 0x20
	// Interrupt falling edge detection request disabled
	FSMC_SR_IFEN_Disabled = 0x0
	// Interrupt falling edge detection request enabled
	FSMC_SR_IFEN_Enabled = 0x1
	// Position of ILEN field.
	FSMC_SR_ILEN_Pos = 0x4
	// Bit mask of ILEN field.
	FSMC_SR_ILEN_Msk = 0x10
	// Bit ILEN.
	FSMC_SR_ILEN = 0x10
	// Interrupt high-level detection request disabled
	FSMC_SR_ILEN_Disabled = 0x0
	// Interrupt high-level detection request enabled
	FSMC_SR_ILEN_Enabled = 0x1
	// Position of IREN field.
	FSMC_SR_IREN_Pos = 0x3
	// Bit mask of IREN field.
	FSMC_SR_IREN_Msk = 0x8
	// Bit IREN.
	FSMC_SR_IREN = 0x8
	// Interrupt rising edge detection request disabled
	FSMC_SR_IREN_Disabled = 0x0
	// Interrupt rising edge detection request enabled
	FSMC_SR_IREN_Enabled = 0x1
	// Position of IFS field.
	FSMC_SR_IFS_Pos = 0x2
	// Bit mask of IFS field.
	FSMC_SR_IFS_Msk = 0x4
	// Bit IFS.
	FSMC_SR_IFS = 0x4
	// Interrupt falling edge did not occur
	FSMC_SR_IFS_DidNotOccur = 0x0
	// Interrupt falling edge occurred
	FSMC_SR_IFS_Occurred = 0x1
	// Position of ILS field.
	FSMC_SR_ILS_Pos = 0x1
	// Bit mask of ILS field.
	FSMC_SR_ILS_Msk = 0x2
	// Bit ILS.
	FSMC_SR_ILS = 0x2
	// Interrupt high-level did not occur
	FSMC_SR_ILS_DidNotOccur = 0x0
	// Interrupt high-level occurred
	FSMC_SR_ILS_Occurred = 0x1
	// Position of IRS field.
	FSMC_SR_IRS_Pos = 0x0
	// Bit mask of IRS field.
	FSMC_SR_IRS_Msk = 0x1
	// Bit IRS.
	FSMC_SR_IRS = 0x1
	// Interrupt rising edge did not occur
	FSMC_SR_IRS_DidNotOccur = 0x0
	// Interrupt rising edge occurred
	FSMC_SR_IRS_Occurred = 0x1

	// PMEM2: Common memory space timing register 2
	// Position of MEMHIZ field.
	FSMC_PMEM2_MEMHIZ_Pos = 0x18
	// Bit mask of MEMHIZ field.
	FSMC_PMEM2_MEMHIZ_Msk = 0xff000000
	// Position of MEMHOLD field.
	FSMC_PMEM2_MEMHOLD_Pos = 0x10
	// Bit mask of MEMHOLD field.
	FSMC_PMEM2_MEMHOLD_Msk = 0xff0000
	// Position of MEMWAIT field.
	FSMC_PMEM2_MEMWAIT_Pos = 0x8
	// Bit mask of MEMWAIT field.
	FSMC_PMEM2_MEMWAIT_Msk = 0xff00
	// Position of MEMSET field.
	FSMC_PMEM2_MEMSET_Pos = 0x0
	// Bit mask of MEMSET field.
	FSMC_PMEM2_MEMSET_Msk = 0xff

	// PATT2: Attribute memory space timing register 2
	// Position of ATTHIZ field.
	FSMC_PATT2_ATTHIZ_Pos = 0x18
	// Bit mask of ATTHIZ field.
	FSMC_PATT2_ATTHIZ_Msk = 0xff000000
	// Position of ATTHOLD field.
	FSMC_PATT2_ATTHOLD_Pos = 0x10
	// Bit mask of ATTHOLD field.
	FSMC_PATT2_ATTHOLD_Msk = 0xff0000
	// Position of ATTWAIT field.
	FSMC_PATT2_ATTWAIT_Pos = 0x8
	// Bit mask of ATTWAIT field.
	FSMC_PATT2_ATTWAIT_Msk = 0xff00
	// Position of ATTSET field.
	FSMC_PATT2_ATTSET_Pos = 0x0
	// Bit mask of ATTSET field.
	FSMC_PATT2_ATTSET_Msk = 0xff

	// ECCR2: ECC result register 2
	// Position of ECC field.
	FSMC_ECCR2_ECC_Pos = 0x0
	// Bit mask of ECC field.
	FSMC_ECCR2_ECC_Msk = 0xffffffff

	// PMEM3: Common memory space timing register 3
	// Position of MEMHIZ field.
	FSMC_PMEM3_MEMHIZ_Pos = 0x18
	// Bit mask of MEMHIZ field.
	FSMC_PMEM3_MEMHIZ_Msk = 0xff000000
	// Position of MEMHOLD field.
	FSMC_PMEM3_MEMHOLD_Pos = 0x10
	// Bit mask of MEMHOLD field.
	FSMC_PMEM3_MEMHOLD_Msk = 0xff0000
	// Position of MEMWAIT field.
	FSMC_PMEM3_MEMWAIT_Pos = 0x8
	// Bit mask of MEMWAIT field.
	FSMC_PMEM3_MEMWAIT_Msk = 0xff00
	// Position of MEMSET field.
	FSMC_PMEM3_MEMSET_Pos = 0x0
	// Bit mask of MEMSET field.
	FSMC_PMEM3_MEMSET_Msk = 0xff

	// PATT3: Attribute memory space timing register 3
	// Position of ATTHIZ field.
	FSMC_PATT3_ATTHIZ_Pos = 0x18
	// Bit mask of ATTHIZ field.
	FSMC_PATT3_ATTHIZ_Msk = 0xff000000
	// Position of ATTHOLD field.
	FSMC_PATT3_ATTHOLD_Pos = 0x10
	// Bit mask of ATTHOLD field.
	FSMC_PATT3_ATTHOLD_Msk = 0xff0000
	// Position of ATTWAIT field.
	FSMC_PATT3_ATTWAIT_Pos = 0x8
	// Bit mask of ATTWAIT field.
	FSMC_PATT3_ATTWAIT_Msk = 0xff00
	// Position of ATTSET field.
	FSMC_PATT3_ATTSET_Pos = 0x0
	// Bit mask of ATTSET field.
	FSMC_PATT3_ATTSET_Msk = 0xff

	// ECCR3: ECC result register 3
	// Position of ECC field.
	FSMC_ECCR3_ECC_Pos = 0x0
	// Bit mask of ECC field.
	FSMC_ECCR3_ECC_Msk = 0xffffffff

	// PMEM4: Common memory space timing register 4
	// Position of MEMHIZ field.
	FSMC_PMEM4_MEMHIZ_Pos = 0x18
	// Bit mask of MEMHIZ field.
	FSMC_PMEM4_MEMHIZ_Msk = 0xff000000
	// Position of MEMHOLD field.
	FSMC_PMEM4_MEMHOLD_Pos = 0x10
	// Bit mask of MEMHOLD field.
	FSMC_PMEM4_MEMHOLD_Msk = 0xff0000
	// Position of MEMWAIT field.
	FSMC_PMEM4_MEMWAIT_Pos = 0x8
	// Bit mask of MEMWAIT field.
	FSMC_PMEM4_MEMWAIT_Msk = 0xff00
	// Position of MEMSET field.
	FSMC_PMEM4_MEMSET_Pos = 0x0
	// Bit mask of MEMSET field.
	FSMC_PMEM4_MEMSET_Msk = 0xff

	// PATT4: Attribute memory space timing register 4
	// Position of ATTHIZ field.
	FSMC_PATT4_ATTHIZ_Pos = 0x18
	// Bit mask of ATTHIZ field.
	FSMC_PATT4_ATTHIZ_Msk = 0xff000000
	// Position of ATTHOLD field.
	FSMC_PATT4_ATTHOLD_Pos = 0x10
	// Bit mask of ATTHOLD field.
	FSMC_PATT4_ATTHOLD_Msk = 0xff0000
	// Position of ATTWAIT field.
	FSMC_PATT4_ATTWAIT_Pos = 0x8
	// Bit mask of ATTWAIT field.
	FSMC_PATT4_ATTWAIT_Msk = 0xff00
	// Position of ATTSET field.
	FSMC_PATT4_ATTSET_Pos = 0x0
	// Bit mask of ATTSET field.
	FSMC_PATT4_ATTSET_Msk = 0xff

	// PIO4: I/O space timing register 4
	// Position of IOHIZx field.
	FSMC_PIO4_IOHIZx_Pos = 0x18
	// Bit mask of IOHIZx field.
	FSMC_PIO4_IOHIZx_Msk = 0xff000000
	// Position of IOHOLDx field.
	FSMC_PIO4_IOHOLDx_Pos = 0x10
	// Bit mask of IOHOLDx field.
	FSMC_PIO4_IOHOLDx_Msk = 0xff0000
	// Position of IOWAITx field.
	FSMC_PIO4_IOWAITx_Pos = 0x8
	// Bit mask of IOWAITx field.
	FSMC_PIO4_IOWAITx_Msk = 0xff00
	// Position of IOSETx field.
	FSMC_PIO4_IOSETx_Pos = 0x0
	// Bit mask of IOSETx field.
	FSMC_PIO4_IOSETx_Msk = 0xff

	// BWTR1: SRAM/NOR-Flash write timing registers 1
	// Position of ACCMOD field.
	FSMC_BWTR_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FSMC_BWTR_ACCMOD_Msk = 0x30000000
	// Access mode A
	FSMC_BWTR_ACCMOD_A = 0x0
	// Access mode B
	FSMC_BWTR_ACCMOD_B = 0x1
	// Access mode C
	FSMC_BWTR_ACCMOD_C = 0x2
	// Access mode D
	FSMC_BWTR_ACCMOD_D = 0x3
	// Position of DATLAT field.
	FSMC_BWTR_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FSMC_BWTR_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FSMC_BWTR_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FSMC_BWTR_CLKDIV_Msk = 0xf00000
	// Position of DATAST field.
	FSMC_BWTR_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FSMC_BWTR_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FSMC_BWTR_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FSMC_BWTR_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FSMC_BWTR_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FSMC_BWTR_ADDSET_Msk = 0xf
	// Position of BUSTURN field.
	FSMC_BWTR_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FSMC_BWTR_BUSTURN_Msk = 0xf0000
)

// Constants for DBGMCU: Debug support
const (
	// IDCODE: IDCODE
	// Position of DEV_ID field.
	DBG_IDCODE_DEV_ID_Pos = 0x0
	// Bit mask of DEV_ID field.
	DBG_IDCODE_DEV_ID_Msk = 0xfff
	// Position of REV_ID field.
	DBG_IDCODE_REV_ID_Pos = 0x10
	// Bit mask of REV_ID field.
	DBG_IDCODE_REV_ID_Msk = 0xffff0000

	// CR: Control Register
	// Position of DBG_SLEEP field.
	DBG_CR_DBG_SLEEP_Pos = 0x0
	// Bit mask of DBG_SLEEP field.
	DBG_CR_DBG_SLEEP_Msk = 0x1
	// Bit DBG_SLEEP.
	DBG_CR_DBG_SLEEP = 0x1
	// Position of DBG_STOP field.
	DBG_CR_DBG_STOP_Pos = 0x1
	// Bit mask of DBG_STOP field.
	DBG_CR_DBG_STOP_Msk = 0x2
	// Bit DBG_STOP.
	DBG_CR_DBG_STOP = 0x2
	// Position of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Pos = 0x2
	// Bit mask of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Msk = 0x4
	// Bit DBG_STANDBY.
	DBG_CR_DBG_STANDBY = 0x4
	// Position of TRACE_IOEN field.
	DBG_CR_TRACE_IOEN_Pos = 0x5
	// Bit mask of TRACE_IOEN field.
	DBG_CR_TRACE_IOEN_Msk = 0x20
	// Bit TRACE_IOEN.
	DBG_CR_TRACE_IOEN = 0x20
	// Position of TRACE_MODE field.
	DBG_CR_TRACE_MODE_Pos = 0x6
	// Bit mask of TRACE_MODE field.
	DBG_CR_TRACE_MODE_Msk = 0xc0

	// APB1_FZ: Debug MCU APB1 Freeze registe
	// Position of DBG_TIM2_STOP field.
	DBG_APB1_FZ_DBG_TIM2_STOP_Pos = 0x0
	// Bit mask of DBG_TIM2_STOP field.
	DBG_APB1_FZ_DBG_TIM2_STOP_Msk = 0x1
	// Bit DBG_TIM2_STOP.
	DBG_APB1_FZ_DBG_TIM2_STOP = 0x1
	// Position of DBG_TIM3_STOP field.
	DBG_APB1_FZ_DBG_TIM3_STOP_Pos = 0x1
	// Bit mask of DBG_TIM3_STOP field.
	DBG_APB1_FZ_DBG_TIM3_STOP_Msk = 0x2
	// Bit DBG_TIM3_STOP.
	DBG_APB1_FZ_DBG_TIM3_STOP = 0x2
	// Position of DBG_TIM4_STOP field.
	DBG_APB1_FZ_DBG_TIM4_STOP_Pos = 0x2
	// Bit mask of DBG_TIM4_STOP field.
	DBG_APB1_FZ_DBG_TIM4_STOP_Msk = 0x4
	// Bit DBG_TIM4_STOP.
	DBG_APB1_FZ_DBG_TIM4_STOP = 0x4
	// Position of DBG_TIM5_STOP field.
	DBG_APB1_FZ_DBG_TIM5_STOP_Pos = 0x3
	// Bit mask of DBG_TIM5_STOP field.
	DBG_APB1_FZ_DBG_TIM5_STOP_Msk = 0x8
	// Bit DBG_TIM5_STOP.
	DBG_APB1_FZ_DBG_TIM5_STOP = 0x8
	// Position of DBG_TIM6_STOP field.
	DBG_APB1_FZ_DBG_TIM6_STOP_Pos = 0x4
	// Bit mask of DBG_TIM6_STOP field.
	DBG_APB1_FZ_DBG_TIM6_STOP_Msk = 0x10
	// Bit DBG_TIM6_STOP.
	DBG_APB1_FZ_DBG_TIM6_STOP = 0x10
	// Position of DBG_TIM7_STOP field.
	DBG_APB1_FZ_DBG_TIM7_STOP_Pos = 0x5
	// Bit mask of DBG_TIM7_STOP field.
	DBG_APB1_FZ_DBG_TIM7_STOP_Msk = 0x20
	// Bit DBG_TIM7_STOP.
	DBG_APB1_FZ_DBG_TIM7_STOP = 0x20
	// Position of DBG_TIM12_STOP field.
	DBG_APB1_FZ_DBG_TIM12_STOP_Pos = 0x6
	// Bit mask of DBG_TIM12_STOP field.
	DBG_APB1_FZ_DBG_TIM12_STOP_Msk = 0x40
	// Bit DBG_TIM12_STOP.
	DBG_APB1_FZ_DBG_TIM12_STOP = 0x40
	// Position of DBG_TIM13_STOP field.
	DBG_APB1_FZ_DBG_TIM13_STOP_Pos = 0x7
	// Bit mask of DBG_TIM13_STOP field.
	DBG_APB1_FZ_DBG_TIM13_STOP_Msk = 0x80
	// Bit DBG_TIM13_STOP.
	DBG_APB1_FZ_DBG_TIM13_STOP = 0x80
	// Position of DBG_TIM14_STOP field.
	DBG_APB1_FZ_DBG_TIM14_STOP_Pos = 0x8
	// Bit mask of DBG_TIM14_STOP field.
	DBG_APB1_FZ_DBG_TIM14_STOP_Msk = 0x100
	// Bit DBG_TIM14_STOP.
	DBG_APB1_FZ_DBG_TIM14_STOP = 0x100
	// Position of DBG_RTC_STOP field.
	DBG_APB1_FZ_DBG_RTC_STOP_Pos = 0xa
	// Bit mask of DBG_RTC_STOP field.
	DBG_APB1_FZ_DBG_RTC_STOP_Msk = 0x400
	// Bit DBG_RTC_STOP.
	DBG_APB1_FZ_DBG_RTC_STOP = 0x400
	// Position of DBG_WWDG_STOP field.
	DBG_APB1_FZ_DBG_WWDG_STOP_Pos = 0xb
	// Bit mask of DBG_WWDG_STOP field.
	DBG_APB1_FZ_DBG_WWDG_STOP_Msk = 0x800
	// Bit DBG_WWDG_STOP.
	DBG_APB1_FZ_DBG_WWDG_STOP = 0x800
	// Position of DBG_IWDG_STOP field.
	DBG_APB1_FZ_DBG_IWDG_STOP_Pos = 0xc
	// Bit mask of DBG_IWDG_STOP field.
	DBG_APB1_FZ_DBG_IWDG_STOP_Msk = 0x1000
	// Bit DBG_IWDG_STOP.
	DBG_APB1_FZ_DBG_IWDG_STOP = 0x1000
	// Position of DBG_J2C1_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_J2C1_SMBUS_TIMEOUT_Pos = 0x15
	// Bit mask of DBG_J2C1_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_J2C1_SMBUS_TIMEOUT_Msk = 0x200000
	// Bit DBG_J2C1_SMBUS_TIMEOUT.
	DBG_APB1_FZ_DBG_J2C1_SMBUS_TIMEOUT = 0x200000
	// Position of DBG_J2C2_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_J2C2_SMBUS_TIMEOUT_Pos = 0x16
	// Bit mask of DBG_J2C2_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_J2C2_SMBUS_TIMEOUT_Msk = 0x400000
	// Bit DBG_J2C2_SMBUS_TIMEOUT.
	DBG_APB1_FZ_DBG_J2C2_SMBUS_TIMEOUT = 0x400000
	// Position of DBG_J2C3SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_J2C3SMBUS_TIMEOUT_Pos = 0x17
	// Bit mask of DBG_J2C3SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_J2C3SMBUS_TIMEOUT_Msk = 0x800000
	// Bit DBG_J2C3SMBUS_TIMEOUT.
	DBG_APB1_FZ_DBG_J2C3SMBUS_TIMEOUT = 0x800000
	// Position of DBG_CAN1_STOP field.
	DBG_APB1_FZ_DBG_CAN1_STOP_Pos = 0x19
	// Bit mask of DBG_CAN1_STOP field.
	DBG_APB1_FZ_DBG_CAN1_STOP_Msk = 0x2000000
	// Bit DBG_CAN1_STOP.
	DBG_APB1_FZ_DBG_CAN1_STOP = 0x2000000
	// Position of DBG_CAN2_STOP field.
	DBG_APB1_FZ_DBG_CAN2_STOP_Pos = 0x1a
	// Bit mask of DBG_CAN2_STOP field.
	DBG_APB1_FZ_DBG_CAN2_STOP_Msk = 0x4000000
	// Bit DBG_CAN2_STOP.
	DBG_APB1_FZ_DBG_CAN2_STOP = 0x4000000

	// APB2_FZ: Debug MCU APB2 Freeze registe
	// Position of DBG_TIM1_STOP field.
	DBG_APB2_FZ_DBG_TIM1_STOP_Pos = 0x0
	// Bit mask of DBG_TIM1_STOP field.
	DBG_APB2_FZ_DBG_TIM1_STOP_Msk = 0x1
	// Bit DBG_TIM1_STOP.
	DBG_APB2_FZ_DBG_TIM1_STOP = 0x1
	// Position of DBG_TIM8_STOP field.
	DBG_APB2_FZ_DBG_TIM8_STOP_Pos = 0x1
	// Bit mask of DBG_TIM8_STOP field.
	DBG_APB2_FZ_DBG_TIM8_STOP_Msk = 0x2
	// Bit DBG_TIM8_STOP.
	DBG_APB2_FZ_DBG_TIM8_STOP = 0x2
	// Position of DBG_TIM9_STOP field.
	DBG_APB2_FZ_DBG_TIM9_STOP_Pos = 0x10
	// Bit mask of DBG_TIM9_STOP field.
	DBG_APB2_FZ_DBG_TIM9_STOP_Msk = 0x10000
	// Bit DBG_TIM9_STOP.
	DBG_APB2_FZ_DBG_TIM9_STOP = 0x10000
	// Position of DBG_TIM10_STOP field.
	DBG_APB2_FZ_DBG_TIM10_STOP_Pos = 0x11
	// Bit mask of DBG_TIM10_STOP field.
	DBG_APB2_FZ_DBG_TIM10_STOP_Msk = 0x20000
	// Bit DBG_TIM10_STOP.
	DBG_APB2_FZ_DBG_TIM10_STOP = 0x20000
	// Position of DBG_TIM11_STOP field.
	DBG_APB2_FZ_DBG_TIM11_STOP_Pos = 0x12
	// Bit mask of DBG_TIM11_STOP field.
	DBG_APB2_FZ_DBG_TIM11_STOP_Msk = 0x40000
	// Bit DBG_TIM11_STOP.
	DBG_APB2_FZ_DBG_TIM11_STOP = 0x40000
)

// Constants for DMA2: DMA controller
const (
	// LISR: low interrupt status register
	// Position of TCIF3 field.
	DMA_LISR_TCIF3_Pos = 0x1b
	// Bit mask of TCIF3 field.
	DMA_LISR_TCIF3_Msk = 0x8000000
	// Bit TCIF3.
	DMA_LISR_TCIF3 = 0x8000000
	// No transfer complete event on stream x
	DMA_LISR_TCIF3_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF3_Complete = 0x1
	// Position of HTIF3 field.
	DMA_LISR_HTIF3_Pos = 0x1a
	// Bit mask of HTIF3 field.
	DMA_LISR_HTIF3_Msk = 0x4000000
	// Bit HTIF3.
	DMA_LISR_HTIF3 = 0x4000000
	// No half transfer event on stream x
	DMA_LISR_HTIF3_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF3_Half = 0x1
	// Position of TEIF3 field.
	DMA_LISR_TEIF3_Pos = 0x19
	// Bit mask of TEIF3 field.
	DMA_LISR_TEIF3_Msk = 0x2000000
	// Bit TEIF3.
	DMA_LISR_TEIF3 = 0x2000000
	// No transfer error on stream x
	DMA_LISR_TEIF3_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF3_Error = 0x1
	// Position of DMEIF3 field.
	DMA_LISR_DMEIF3_Pos = 0x18
	// Bit mask of DMEIF3 field.
	DMA_LISR_DMEIF3_Msk = 0x1000000
	// Bit DMEIF3.
	DMA_LISR_DMEIF3 = 0x1000000
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF3_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF3_Error = 0x1
	// Position of FEIF3 field.
	DMA_LISR_FEIF3_Pos = 0x16
	// Bit mask of FEIF3 field.
	DMA_LISR_FEIF3_Msk = 0x400000
	// Bit FEIF3.
	DMA_LISR_FEIF3 = 0x400000
	// No FIFO error event on stream x
	DMA_LISR_FEIF3_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF3_Error = 0x1
	// Position of TCIF2 field.
	DMA_LISR_TCIF2_Pos = 0x15
	// Bit mask of TCIF2 field.
	DMA_LISR_TCIF2_Msk = 0x200000
	// Bit TCIF2.
	DMA_LISR_TCIF2 = 0x200000
	// No transfer complete event on stream x
	DMA_LISR_TCIF2_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF2_Complete = 0x1
	// Position of HTIF2 field.
	DMA_LISR_HTIF2_Pos = 0x14
	// Bit mask of HTIF2 field.
	DMA_LISR_HTIF2_Msk = 0x100000
	// Bit HTIF2.
	DMA_LISR_HTIF2 = 0x100000
	// No half transfer event on stream x
	DMA_LISR_HTIF2_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF2_Half = 0x1
	// Position of TEIF2 field.
	DMA_LISR_TEIF2_Pos = 0x13
	// Bit mask of TEIF2 field.
	DMA_LISR_TEIF2_Msk = 0x80000
	// Bit TEIF2.
	DMA_LISR_TEIF2 = 0x80000
	// No transfer error on stream x
	DMA_LISR_TEIF2_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF2_Error = 0x1
	// Position of DMEIF2 field.
	DMA_LISR_DMEIF2_Pos = 0x12
	// Bit mask of DMEIF2 field.
	DMA_LISR_DMEIF2_Msk = 0x40000
	// Bit DMEIF2.
	DMA_LISR_DMEIF2 = 0x40000
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF2_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF2_Error = 0x1
	// Position of FEIF2 field.
	DMA_LISR_FEIF2_Pos = 0x10
	// Bit mask of FEIF2 field.
	DMA_LISR_FEIF2_Msk = 0x10000
	// Bit FEIF2.
	DMA_LISR_FEIF2 = 0x10000
	// No FIFO error event on stream x
	DMA_LISR_FEIF2_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF2_Error = 0x1
	// Position of TCIF1 field.
	DMA_LISR_TCIF1_Pos = 0xb
	// Bit mask of TCIF1 field.
	DMA_LISR_TCIF1_Msk = 0x800
	// Bit TCIF1.
	DMA_LISR_TCIF1 = 0x800
	// No transfer complete event on stream x
	DMA_LISR_TCIF1_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF1_Complete = 0x1
	// Position of HTIF1 field.
	DMA_LISR_HTIF1_Pos = 0xa
	// Bit mask of HTIF1 field.
	DMA_LISR_HTIF1_Msk = 0x400
	// Bit HTIF1.
	DMA_LISR_HTIF1 = 0x400
	// No half transfer event on stream x
	DMA_LISR_HTIF1_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF1_Half = 0x1
	// Position of TEIF1 field.
	DMA_LISR_TEIF1_Pos = 0x9
	// Bit mask of TEIF1 field.
	DMA_LISR_TEIF1_Msk = 0x200
	// Bit TEIF1.
	DMA_LISR_TEIF1 = 0x200
	// No transfer error on stream x
	DMA_LISR_TEIF1_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF1_Error = 0x1
	// Position of DMEIF1 field.
	DMA_LISR_DMEIF1_Pos = 0x8
	// Bit mask of DMEIF1 field.
	DMA_LISR_DMEIF1_Msk = 0x100
	// Bit DMEIF1.
	DMA_LISR_DMEIF1 = 0x100
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF1_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF1_Error = 0x1
	// Position of FEIF1 field.
	DMA_LISR_FEIF1_Pos = 0x6
	// Bit mask of FEIF1 field.
	DMA_LISR_FEIF1_Msk = 0x40
	// Bit FEIF1.
	DMA_LISR_FEIF1 = 0x40
	// No FIFO error event on stream x
	DMA_LISR_FEIF1_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF1_Error = 0x1
	// Position of TCIF0 field.
	DMA_LISR_TCIF0_Pos = 0x5
	// Bit mask of TCIF0 field.
	DMA_LISR_TCIF0_Msk = 0x20
	// Bit TCIF0.
	DMA_LISR_TCIF0 = 0x20
	// No transfer complete event on stream x
	DMA_LISR_TCIF0_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF0_Complete = 0x1
	// Position of HTIF0 field.
	DMA_LISR_HTIF0_Pos = 0x4
	// Bit mask of HTIF0 field.
	DMA_LISR_HTIF0_Msk = 0x10
	// Bit HTIF0.
	DMA_LISR_HTIF0 = 0x10
	// No half transfer event on stream x
	DMA_LISR_HTIF0_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF0_Half = 0x1
	// Position of TEIF0 field.
	DMA_LISR_TEIF0_Pos = 0x3
	// Bit mask of TEIF0 field.
	DMA_LISR_TEIF0_Msk = 0x8
	// Bit TEIF0.
	DMA_LISR_TEIF0 = 0x8
	// No transfer error on stream x
	DMA_LISR_TEIF0_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF0_Error = 0x1
	// Position of DMEIF0 field.
	DMA_LISR_DMEIF0_Pos = 0x2
	// Bit mask of DMEIF0 field.
	DMA_LISR_DMEIF0_Msk = 0x4
	// Bit DMEIF0.
	DMA_LISR_DMEIF0 = 0x4
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF0_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF0_Error = 0x1
	// Position of FEIF0 field.
	DMA_LISR_FEIF0_Pos = 0x0
	// Bit mask of FEIF0 field.
	DMA_LISR_FEIF0_Msk = 0x1
	// Bit FEIF0.
	DMA_LISR_FEIF0 = 0x1
	// No FIFO error event on stream x
	DMA_LISR_FEIF0_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF0_Error = 0x1

	// HISR: high interrupt status register
	// Position of TCIF7 field.
	DMA_HISR_TCIF7_Pos = 0x1b
	// Bit mask of TCIF7 field.
	DMA_HISR_TCIF7_Msk = 0x8000000
	// Bit TCIF7.
	DMA_HISR_TCIF7 = 0x8000000
	// No transfer complete event on stream x
	DMA_HISR_TCIF7_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF7_Complete = 0x1
	// Position of HTIF7 field.
	DMA_HISR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_HISR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_HISR_HTIF7 = 0x4000000
	// No half transfer event on stream x
	DMA_HISR_HTIF7_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF7_Half = 0x1
	// Position of TEIF7 field.
	DMA_HISR_TEIF7_Pos = 0x19
	// Bit mask of TEIF7 field.
	DMA_HISR_TEIF7_Msk = 0x2000000
	// Bit TEIF7.
	DMA_HISR_TEIF7 = 0x2000000
	// No transfer error on stream x
	DMA_HISR_TEIF7_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF7_Error = 0x1
	// Position of DMEIF7 field.
	DMA_HISR_DMEIF7_Pos = 0x18
	// Bit mask of DMEIF7 field.
	DMA_HISR_DMEIF7_Msk = 0x1000000
	// Bit DMEIF7.
	DMA_HISR_DMEIF7 = 0x1000000
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF7_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF7_Error = 0x1
	// Position of FEIF7 field.
	DMA_HISR_FEIF7_Pos = 0x16
	// Bit mask of FEIF7 field.
	DMA_HISR_FEIF7_Msk = 0x400000
	// Bit FEIF7.
	DMA_HISR_FEIF7 = 0x400000
	// No FIFO error event on stream x
	DMA_HISR_FEIF7_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF7_Error = 0x1
	// Position of TCIF6 field.
	DMA_HISR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_HISR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_HISR_TCIF6 = 0x200000
	// No transfer complete event on stream x
	DMA_HISR_TCIF6_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF6_Complete = 0x1
	// Position of HTIF6 field.
	DMA_HISR_HTIF6_Pos = 0x14
	// Bit mask of HTIF6 field.
	DMA_HISR_HTIF6_Msk = 0x100000
	// Bit HTIF6.
	DMA_HISR_HTIF6 = 0x100000
	// No half transfer event on stream x
	DMA_HISR_HTIF6_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF6_Half = 0x1
	// Position of TEIF6 field.
	DMA_HISR_TEIF6_Pos = 0x13
	// Bit mask of TEIF6 field.
	DMA_HISR_TEIF6_Msk = 0x80000
	// Bit TEIF6.
	DMA_HISR_TEIF6 = 0x80000
	// No transfer error on stream x
	DMA_HISR_TEIF6_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF6_Error = 0x1
	// Position of DMEIF6 field.
	DMA_HISR_DMEIF6_Pos = 0x12
	// Bit mask of DMEIF6 field.
	DMA_HISR_DMEIF6_Msk = 0x40000
	// Bit DMEIF6.
	DMA_HISR_DMEIF6 = 0x40000
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF6_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF6_Error = 0x1
	// Position of FEIF6 field.
	DMA_HISR_FEIF6_Pos = 0x10
	// Bit mask of FEIF6 field.
	DMA_HISR_FEIF6_Msk = 0x10000
	// Bit FEIF6.
	DMA_HISR_FEIF6 = 0x10000
	// No FIFO error event on stream x
	DMA_HISR_FEIF6_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF6_Error = 0x1
	// Position of TCIF5 field.
	DMA_HISR_TCIF5_Pos = 0xb
	// Bit mask of TCIF5 field.
	DMA_HISR_TCIF5_Msk = 0x800
	// Bit TCIF5.
	DMA_HISR_TCIF5 = 0x800
	// No transfer complete event on stream x
	DMA_HISR_TCIF5_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF5_Complete = 0x1
	// Position of HTIF5 field.
	DMA_HISR_HTIF5_Pos = 0xa
	// Bit mask of HTIF5 field.
	DMA_HISR_HTIF5_Msk = 0x400
	// Bit HTIF5.
	DMA_HISR_HTIF5 = 0x400
	// No half transfer event on stream x
	DMA_HISR_HTIF5_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF5_Half = 0x1
	// Position of TEIF5 field.
	DMA_HISR_TEIF5_Pos = 0x9
	// Bit mask of TEIF5 field.
	DMA_HISR_TEIF5_Msk = 0x200
	// Bit TEIF5.
	DMA_HISR_TEIF5 = 0x200
	// No transfer error on stream x
	DMA_HISR_TEIF5_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF5_Error = 0x1
	// Position of DMEIF5 field.
	DMA_HISR_DMEIF5_Pos = 0x8
	// Bit mask of DMEIF5 field.
	DMA_HISR_DMEIF5_Msk = 0x100
	// Bit DMEIF5.
	DMA_HISR_DMEIF5 = 0x100
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF5_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF5_Error = 0x1
	// Position of FEIF5 field.
	DMA_HISR_FEIF5_Pos = 0x6
	// Bit mask of FEIF5 field.
	DMA_HISR_FEIF5_Msk = 0x40
	// Bit FEIF5.
	DMA_HISR_FEIF5 = 0x40
	// No FIFO error event on stream x
	DMA_HISR_FEIF5_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF5_Error = 0x1
	// Position of TCIF4 field.
	DMA_HISR_TCIF4_Pos = 0x5
	// Bit mask of TCIF4 field.
	DMA_HISR_TCIF4_Msk = 0x20
	// Bit TCIF4.
	DMA_HISR_TCIF4 = 0x20
	// No transfer complete event on stream x
	DMA_HISR_TCIF4_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF4_Complete = 0x1
	// Position of HTIF4 field.
	DMA_HISR_HTIF4_Pos = 0x4
	// Bit mask of HTIF4 field.
	DMA_HISR_HTIF4_Msk = 0x10
	// Bit HTIF4.
	DMA_HISR_HTIF4 = 0x10
	// No half transfer event on stream x
	DMA_HISR_HTIF4_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF4_Half = 0x1
	// Position of TEIF4 field.
	DMA_HISR_TEIF4_Pos = 0x3
	// Bit mask of TEIF4 field.
	DMA_HISR_TEIF4_Msk = 0x8
	// Bit TEIF4.
	DMA_HISR_TEIF4 = 0x8
	// No transfer error on stream x
	DMA_HISR_TEIF4_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF4_Error = 0x1
	// Position of DMEIF4 field.
	DMA_HISR_DMEIF4_Pos = 0x2
	// Bit mask of DMEIF4 field.
	DMA_HISR_DMEIF4_Msk = 0x4
	// Bit DMEIF4.
	DMA_HISR_DMEIF4 = 0x4
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF4_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF4_Error = 0x1
	// Position of FEIF4 field.
	DMA_HISR_FEIF4_Pos = 0x0
	// Bit mask of FEIF4 field.
	DMA_HISR_FEIF4_Msk = 0x1
	// Bit FEIF4.
	DMA_HISR_FEIF4 = 0x1
	// No FIFO error event on stream x
	DMA_HISR_FEIF4_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF4_Error = 0x1

	// LIFCR: low interrupt flag clear register
	// Position of CTCIF3 field.
	DMA_LIFCR_CTCIF3_Pos = 0x1b
	// Bit mask of CTCIF3 field.
	DMA_LIFCR_CTCIF3_Msk = 0x8000000
	// Bit CTCIF3.
	DMA_LIFCR_CTCIF3 = 0x8000000
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF3_Clear = 0x1
	// Position of CHTIF3 field.
	DMA_LIFCR_CHTIF3_Pos = 0x1a
	// Bit mask of CHTIF3 field.
	DMA_LIFCR_CHTIF3_Msk = 0x4000000
	// Bit CHTIF3.
	DMA_LIFCR_CHTIF3 = 0x4000000
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF3_Clear = 0x1
	// Position of CTEIF3 field.
	DMA_LIFCR_CTEIF3_Pos = 0x19
	// Bit mask of CTEIF3 field.
	DMA_LIFCR_CTEIF3_Msk = 0x2000000
	// Bit CTEIF3.
	DMA_LIFCR_CTEIF3 = 0x2000000
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF3_Clear = 0x1
	// Position of CDMEIF3 field.
	DMA_LIFCR_CDMEIF3_Pos = 0x18
	// Bit mask of CDMEIF3 field.
	DMA_LIFCR_CDMEIF3_Msk = 0x1000000
	// Bit CDMEIF3.
	DMA_LIFCR_CDMEIF3 = 0x1000000
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF3_Clear = 0x1
	// Position of CFEIF3 field.
	DMA_LIFCR_CFEIF3_Pos = 0x16
	// Bit mask of CFEIF3 field.
	DMA_LIFCR_CFEIF3_Msk = 0x400000
	// Bit CFEIF3.
	DMA_LIFCR_CFEIF3 = 0x400000
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF3_Clear = 0x1
	// Position of CTCIF2 field.
	DMA_LIFCR_CTCIF2_Pos = 0x15
	// Bit mask of CTCIF2 field.
	DMA_LIFCR_CTCIF2_Msk = 0x200000
	// Bit CTCIF2.
	DMA_LIFCR_CTCIF2 = 0x200000
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF2_Clear = 0x1
	// Position of CHTIF2 field.
	DMA_LIFCR_CHTIF2_Pos = 0x14
	// Bit mask of CHTIF2 field.
	DMA_LIFCR_CHTIF2_Msk = 0x100000
	// Bit CHTIF2.
	DMA_LIFCR_CHTIF2 = 0x100000
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF2_Clear = 0x1
	// Position of CTEIF2 field.
	DMA_LIFCR_CTEIF2_Pos = 0x13
	// Bit mask of CTEIF2 field.
	DMA_LIFCR_CTEIF2_Msk = 0x80000
	// Bit CTEIF2.
	DMA_LIFCR_CTEIF2 = 0x80000
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF2_Clear = 0x1
	// Position of CDMEIF2 field.
	DMA_LIFCR_CDMEIF2_Pos = 0x12
	// Bit mask of CDMEIF2 field.
	DMA_LIFCR_CDMEIF2_Msk = 0x40000
	// Bit CDMEIF2.
	DMA_LIFCR_CDMEIF2 = 0x40000
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF2_Clear = 0x1
	// Position of CFEIF2 field.
	DMA_LIFCR_CFEIF2_Pos = 0x10
	// Bit mask of CFEIF2 field.
	DMA_LIFCR_CFEIF2_Msk = 0x10000
	// Bit CFEIF2.
	DMA_LIFCR_CFEIF2 = 0x10000
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF2_Clear = 0x1
	// Position of CTCIF1 field.
	DMA_LIFCR_CTCIF1_Pos = 0xb
	// Bit mask of CTCIF1 field.
	DMA_LIFCR_CTCIF1_Msk = 0x800
	// Bit CTCIF1.
	DMA_LIFCR_CTCIF1 = 0x800
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF1_Clear = 0x1
	// Position of CHTIF1 field.
	DMA_LIFCR_CHTIF1_Pos = 0xa
	// Bit mask of CHTIF1 field.
	DMA_LIFCR_CHTIF1_Msk = 0x400
	// Bit CHTIF1.
	DMA_LIFCR_CHTIF1 = 0x400
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF1_Clear = 0x1
	// Position of CTEIF1 field.
	DMA_LIFCR_CTEIF1_Pos = 0x9
	// Bit mask of CTEIF1 field.
	DMA_LIFCR_CTEIF1_Msk = 0x200
	// Bit CTEIF1.
	DMA_LIFCR_CTEIF1 = 0x200
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF1_Clear = 0x1
	// Position of CDMEIF1 field.
	DMA_LIFCR_CDMEIF1_Pos = 0x8
	// Bit mask of CDMEIF1 field.
	DMA_LIFCR_CDMEIF1_Msk = 0x100
	// Bit CDMEIF1.
	DMA_LIFCR_CDMEIF1 = 0x100
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF1_Clear = 0x1
	// Position of CFEIF1 field.
	DMA_LIFCR_CFEIF1_Pos = 0x6
	// Bit mask of CFEIF1 field.
	DMA_LIFCR_CFEIF1_Msk = 0x40
	// Bit CFEIF1.
	DMA_LIFCR_CFEIF1 = 0x40
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF1_Clear = 0x1
	// Position of CTCIF0 field.
	DMA_LIFCR_CTCIF0_Pos = 0x5
	// Bit mask of CTCIF0 field.
	DMA_LIFCR_CTCIF0_Msk = 0x20
	// Bit CTCIF0.
	DMA_LIFCR_CTCIF0 = 0x20
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF0_Clear = 0x1
	// Position of CHTIF0 field.
	DMA_LIFCR_CHTIF0_Pos = 0x4
	// Bit mask of CHTIF0 field.
	DMA_LIFCR_CHTIF0_Msk = 0x10
	// Bit CHTIF0.
	DMA_LIFCR_CHTIF0 = 0x10
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF0_Clear = 0x1
	// Position of CTEIF0 field.
	DMA_LIFCR_CTEIF0_Pos = 0x3
	// Bit mask of CTEIF0 field.
	DMA_LIFCR_CTEIF0_Msk = 0x8
	// Bit CTEIF0.
	DMA_LIFCR_CTEIF0 = 0x8
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF0_Clear = 0x1
	// Position of CDMEIF0 field.
	DMA_LIFCR_CDMEIF0_Pos = 0x2
	// Bit mask of CDMEIF0 field.
	DMA_LIFCR_CDMEIF0_Msk = 0x4
	// Bit CDMEIF0.
	DMA_LIFCR_CDMEIF0 = 0x4
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF0_Clear = 0x1
	// Position of CFEIF0 field.
	DMA_LIFCR_CFEIF0_Pos = 0x0
	// Bit mask of CFEIF0 field.
	DMA_LIFCR_CFEIF0_Msk = 0x1
	// Bit CFEIF0.
	DMA_LIFCR_CFEIF0 = 0x1
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF0_Clear = 0x1

	// HIFCR: high interrupt flag clear register
	// Position of CTCIF7 field.
	DMA_HIFCR_CTCIF7_Pos = 0x1b
	// Bit mask of CTCIF7 field.
	DMA_HIFCR_CTCIF7_Msk = 0x8000000
	// Bit CTCIF7.
	DMA_HIFCR_CTCIF7 = 0x8000000
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF7_Clear = 0x1
	// Position of CHTIF7 field.
	DMA_HIFCR_CHTIF7_Pos = 0x1a
	// Bit mask of CHTIF7 field.
	DMA_HIFCR_CHTIF7_Msk = 0x4000000
	// Bit CHTIF7.
	DMA_HIFCR_CHTIF7 = 0x4000000
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF7_Clear = 0x1
	// Position of CTEIF7 field.
	DMA_HIFCR_CTEIF7_Pos = 0x19
	// Bit mask of CTEIF7 field.
	DMA_HIFCR_CTEIF7_Msk = 0x2000000
	// Bit CTEIF7.
	DMA_HIFCR_CTEIF7 = 0x2000000
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF7_Clear = 0x1
	// Position of CDMEIF7 field.
	DMA_HIFCR_CDMEIF7_Pos = 0x18
	// Bit mask of CDMEIF7 field.
	DMA_HIFCR_CDMEIF7_Msk = 0x1000000
	// Bit CDMEIF7.
	DMA_HIFCR_CDMEIF7 = 0x1000000
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF7_Clear = 0x1
	// Position of CFEIF7 field.
	DMA_HIFCR_CFEIF7_Pos = 0x16
	// Bit mask of CFEIF7 field.
	DMA_HIFCR_CFEIF7_Msk = 0x400000
	// Bit CFEIF7.
	DMA_HIFCR_CFEIF7 = 0x400000
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF7_Clear = 0x1
	// Position of CTCIF6 field.
	DMA_HIFCR_CTCIF6_Pos = 0x15
	// Bit mask of CTCIF6 field.
	DMA_HIFCR_CTCIF6_Msk = 0x200000
	// Bit CTCIF6.
	DMA_HIFCR_CTCIF6 = 0x200000
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF6_Clear = 0x1
	// Position of CHTIF6 field.
	DMA_HIFCR_CHTIF6_Pos = 0x14
	// Bit mask of CHTIF6 field.
	DMA_HIFCR_CHTIF6_Msk = 0x100000
	// Bit CHTIF6.
	DMA_HIFCR_CHTIF6 = 0x100000
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF6_Clear = 0x1
	// Position of CTEIF6 field.
	DMA_HIFCR_CTEIF6_Pos = 0x13
	// Bit mask of CTEIF6 field.
	DMA_HIFCR_CTEIF6_Msk = 0x80000
	// Bit CTEIF6.
	DMA_HIFCR_CTEIF6 = 0x80000
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF6_Clear = 0x1
	// Position of CDMEIF6 field.
	DMA_HIFCR_CDMEIF6_Pos = 0x12
	// Bit mask of CDMEIF6 field.
	DMA_HIFCR_CDMEIF6_Msk = 0x40000
	// Bit CDMEIF6.
	DMA_HIFCR_CDMEIF6 = 0x40000
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF6_Clear = 0x1
	// Position of CFEIF6 field.
	DMA_HIFCR_CFEIF6_Pos = 0x10
	// Bit mask of CFEIF6 field.
	DMA_HIFCR_CFEIF6_Msk = 0x10000
	// Bit CFEIF6.
	DMA_HIFCR_CFEIF6 = 0x10000
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF6_Clear = 0x1
	// Position of CTCIF5 field.
	DMA_HIFCR_CTCIF5_Pos = 0xb
	// Bit mask of CTCIF5 field.
	DMA_HIFCR_CTCIF5_Msk = 0x800
	// Bit CTCIF5.
	DMA_HIFCR_CTCIF5 = 0x800
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF5_Clear = 0x1
	// Position of CHTIF5 field.
	DMA_HIFCR_CHTIF5_Pos = 0xa
	// Bit mask of CHTIF5 field.
	DMA_HIFCR_CHTIF5_Msk = 0x400
	// Bit CHTIF5.
	DMA_HIFCR_CHTIF5 = 0x400
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF5_Clear = 0x1
	// Position of CTEIF5 field.
	DMA_HIFCR_CTEIF5_Pos = 0x9
	// Bit mask of CTEIF5 field.
	DMA_HIFCR_CTEIF5_Msk = 0x200
	// Bit CTEIF5.
	DMA_HIFCR_CTEIF5 = 0x200
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF5_Clear = 0x1
	// Position of CDMEIF5 field.
	DMA_HIFCR_CDMEIF5_Pos = 0x8
	// Bit mask of CDMEIF5 field.
	DMA_HIFCR_CDMEIF5_Msk = 0x100
	// Bit CDMEIF5.
	DMA_HIFCR_CDMEIF5 = 0x100
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF5_Clear = 0x1
	// Position of CFEIF5 field.
	DMA_HIFCR_CFEIF5_Pos = 0x6
	// Bit mask of CFEIF5 field.
	DMA_HIFCR_CFEIF5_Msk = 0x40
	// Bit CFEIF5.
	DMA_HIFCR_CFEIF5 = 0x40
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF5_Clear = 0x1
	// Position of CTCIF4 field.
	DMA_HIFCR_CTCIF4_Pos = 0x5
	// Bit mask of CTCIF4 field.
	DMA_HIFCR_CTCIF4_Msk = 0x20
	// Bit CTCIF4.
	DMA_HIFCR_CTCIF4 = 0x20
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF4_Clear = 0x1
	// Position of CHTIF4 field.
	DMA_HIFCR_CHTIF4_Pos = 0x4
	// Bit mask of CHTIF4 field.
	DMA_HIFCR_CHTIF4_Msk = 0x10
	// Bit CHTIF4.
	DMA_HIFCR_CHTIF4 = 0x10
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF4_Clear = 0x1
	// Position of CTEIF4 field.
	DMA_HIFCR_CTEIF4_Pos = 0x3
	// Bit mask of CTEIF4 field.
	DMA_HIFCR_CTEIF4_Msk = 0x8
	// Bit CTEIF4.
	DMA_HIFCR_CTEIF4 = 0x8
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF4_Clear = 0x1
	// Position of CDMEIF4 field.
	DMA_HIFCR_CDMEIF4_Pos = 0x2
	// Bit mask of CDMEIF4 field.
	DMA_HIFCR_CDMEIF4_Msk = 0x4
	// Bit CDMEIF4.
	DMA_HIFCR_CDMEIF4 = 0x4
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF4_Clear = 0x1
	// Position of CFEIF4 field.
	DMA_HIFCR_CFEIF4_Pos = 0x0
	// Bit mask of CFEIF4 field.
	DMA_HIFCR_CFEIF4_Msk = 0x1
	// Bit CFEIF4.
	DMA_HIFCR_CFEIF4 = 0x1
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF4_Clear = 0x1

	// ST.CR: stream x configuration register
	// Position of CHSEL field.
	DMA_ST_CR_CHSEL_Pos = 0x19
	// Bit mask of CHSEL field.
	DMA_ST_CR_CHSEL_Msk = 0xe000000
	// Position of MBURST field.
	DMA_ST_CR_MBURST_Pos = 0x17
	// Bit mask of MBURST field.
	DMA_ST_CR_MBURST_Msk = 0x1800000
	// Single transfer
	DMA_ST_CR_MBURST_Single = 0x0
	// Incremental burst of 4 beats
	DMA_ST_CR_MBURST_INCR4 = 0x1
	// Incremental burst of 8 beats
	DMA_ST_CR_MBURST_INCR8 = 0x2
	// Incremental burst of 16 beats
	DMA_ST_CR_MBURST_INCR16 = 0x3
	// Position of PBURST field.
	DMA_ST_CR_PBURST_Pos = 0x15
	// Bit mask of PBURST field.
	DMA_ST_CR_PBURST_Msk = 0x600000
	// Single transfer
	DMA_ST_CR_PBURST_Single = 0x0
	// Incremental burst of 4 beats
	DMA_ST_CR_PBURST_INCR4 = 0x1
	// Incremental burst of 8 beats
	DMA_ST_CR_PBURST_INCR8 = 0x2
	// Incremental burst of 16 beats
	DMA_ST_CR_PBURST_INCR16 = 0x3
	// Position of CT field.
	DMA_ST_CR_CT_Pos = 0x13
	// Bit mask of CT field.
	DMA_ST_CR_CT_Msk = 0x80000
	// Bit CT.
	DMA_ST_CR_CT = 0x80000
	// The current target memory is Memory 0
	DMA_ST_CR_CT_Memory0 = 0x0
	// The current target memory is Memory 1
	DMA_ST_CR_CT_Memory1 = 0x1
	// Position of DBM field.
	DMA_ST_CR_DBM_Pos = 0x12
	// Bit mask of DBM field.
	DMA_ST_CR_DBM_Msk = 0x40000
	// Bit DBM.
	DMA_ST_CR_DBM = 0x40000
	// No buffer switching at the end of transfer
	DMA_ST_CR_DBM_Disabled = 0x0
	// Memory target switched at the end of the DMA transfer
	DMA_ST_CR_DBM_Enabled = 0x1
	// Position of PL field.
	DMA_ST_CR_PL_Pos = 0x10
	// Bit mask of PL field.
	DMA_ST_CR_PL_Msk = 0x30000
	// Low
	DMA_ST_CR_PL_Low = 0x0
	// Medium
	DMA_ST_CR_PL_Medium = 0x1
	// High
	DMA_ST_CR_PL_High = 0x2
	// Very high
	DMA_ST_CR_PL_VeryHigh = 0x3
	// Position of PINCOS field.
	DMA_ST_CR_PINCOS_Pos = 0xf
	// Bit mask of PINCOS field.
	DMA_ST_CR_PINCOS_Msk = 0x8000
	// Bit PINCOS.
	DMA_ST_CR_PINCOS = 0x8000
	// The offset size for the peripheral address calculation is linked to the PSIZE
	DMA_ST_CR_PINCOS_PSIZE = 0x0
	// The offset size for the peripheral address calculation is fixed to 4 (32-bit alignment)
	DMA_ST_CR_PINCOS_Fixed4 = 0x1
	// Position of MSIZE field.
	DMA_ST_CR_MSIZE_Pos = 0xd
	// Bit mask of MSIZE field.
	DMA_ST_CR_MSIZE_Msk = 0x6000
	// Byte (8-bit)
	DMA_ST_CR_MSIZE_Bits8 = 0x0
	// Half-word (16-bit)
	DMA_ST_CR_MSIZE_Bits16 = 0x1
	// Word (32-bit)
	DMA_ST_CR_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_ST_CR_PSIZE_Pos = 0xb
	// Bit mask of PSIZE field.
	DMA_ST_CR_PSIZE_Msk = 0x1800
	// Byte (8-bit)
	DMA_ST_CR_PSIZE_Bits8 = 0x0
	// Half-word (16-bit)
	DMA_ST_CR_PSIZE_Bits16 = 0x1
	// Word (32-bit)
	DMA_ST_CR_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_ST_CR_MINC_Pos = 0xa
	// Bit mask of MINC field.
	DMA_ST_CR_MINC_Msk = 0x400
	// Bit MINC.
	DMA_ST_CR_MINC = 0x400
	// Address pointer is fixed
	DMA_ST_CR_MINC_Fixed = 0x0
	// Address pointer is incremented after each data transfer
	DMA_ST_CR_MINC_Incremented = 0x1
	// Position of PINC field.
	DMA_ST_CR_PINC_Pos = 0x9
	// Bit mask of PINC field.
	DMA_ST_CR_PINC_Msk = 0x200
	// Bit PINC.
	DMA_ST_CR_PINC = 0x200
	// Address pointer is fixed
	DMA_ST_CR_PINC_Fixed = 0x0
	// Address pointer is incremented after each data transfer
	DMA_ST_CR_PINC_Incremented = 0x1
	// Position of CIRC field.
	DMA_ST_CR_CIRC_Pos = 0x8
	// Bit mask of CIRC field.
	DMA_ST_CR_CIRC_Msk = 0x100
	// Bit CIRC.
	DMA_ST_CR_CIRC = 0x100
	// Circular mode disabled
	DMA_ST_CR_CIRC_Disabled = 0x0
	// Circular mode enabled
	DMA_ST_CR_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_ST_CR_DIR_Pos = 0x6
	// Bit mask of DIR field.
	DMA_ST_CR_DIR_Msk = 0xc0
	// Peripheral-to-memory
	DMA_ST_CR_DIR_PeripheralToMemory = 0x0
	// Memory-to-peripheral
	DMA_ST_CR_DIR_MemoryToPeripheral = 0x1
	// Memory-to-memory
	DMA_ST_CR_DIR_MemoryToMemory = 0x2
	// Position of PFCTRL field.
	DMA_ST_CR_PFCTRL_Pos = 0x5
	// Bit mask of PFCTRL field.
	DMA_ST_CR_PFCTRL_Msk = 0x20
	// Bit PFCTRL.
	DMA_ST_CR_PFCTRL = 0x20
	// The DMA is the flow controller
	DMA_ST_CR_PFCTRL_DMA = 0x0
	// The peripheral is the flow controller
	DMA_ST_CR_PFCTRL_Peripheral = 0x1
	// Position of TCIE field.
	DMA_ST_CR_TCIE_Pos = 0x4
	// Bit mask of TCIE field.
	DMA_ST_CR_TCIE_Msk = 0x10
	// Bit TCIE.
	DMA_ST_CR_TCIE = 0x10
	// TC interrupt disabled
	DMA_ST_CR_TCIE_Disabled = 0x0
	// TC interrupt enabled
	DMA_ST_CR_TCIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_ST_CR_HTIE_Pos = 0x3
	// Bit mask of HTIE field.
	DMA_ST_CR_HTIE_Msk = 0x8
	// Bit HTIE.
	DMA_ST_CR_HTIE = 0x8
	// HT interrupt disabled
	DMA_ST_CR_HTIE_Disabled = 0x0
	// HT interrupt enabled
	DMA_ST_CR_HTIE_Enabled = 0x1
	// Position of TEIE field.
	DMA_ST_CR_TEIE_Pos = 0x2
	// Bit mask of TEIE field.
	DMA_ST_CR_TEIE_Msk = 0x4
	// Bit TEIE.
	DMA_ST_CR_TEIE = 0x4
	// TE interrupt disabled
	DMA_ST_CR_TEIE_Disabled = 0x0
	// TE interrupt enabled
	DMA_ST_CR_TEIE_Enabled = 0x1
	// Position of DMEIE field.
	DMA_ST_CR_DMEIE_Pos = 0x1
	// Bit mask of DMEIE field.
	DMA_ST_CR_DMEIE_Msk = 0x2
	// Bit DMEIE.
	DMA_ST_CR_DMEIE = 0x2
	// DME interrupt disabled
	DMA_ST_CR_DMEIE_Disabled = 0x0
	// DME interrupt enabled
	DMA_ST_CR_DMEIE_Enabled = 0x1
	// Position of EN field.
	DMA_ST_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_ST_CR_EN_Msk = 0x1
	// Bit EN.
	DMA_ST_CR_EN = 0x1
	// Stream disabled
	DMA_ST_CR_EN_Disabled = 0x0
	// Stream enabled
	DMA_ST_CR_EN_Enabled = 0x1

	// ST.NDTR: stream x number of data register
	// Position of NDT field.
	DMA_ST_NDTR_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_ST_NDTR_NDT_Msk = 0xffff

	// ST.PAR: stream x peripheral address register
	// Position of PA field.
	DMA_ST_PAR_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_ST_PAR_PA_Msk = 0xffffffff

	// ST.M0AR: stream x memory 0 address register
	// Position of M0A field.
	DMA_ST_M0AR_M0A_Pos = 0x0
	// Bit mask of M0A field.
	DMA_ST_M0AR_M0A_Msk = 0xffffffff

	// ST.M1AR: stream x memory 1 address register
	// Position of M1A field.
	DMA_ST_M1AR_M1A_Pos = 0x0
	// Bit mask of M1A field.
	DMA_ST_M1AR_M1A_Msk = 0xffffffff

	// ST.FCR: stream x FIFO control register
	// Position of FEIE field.
	DMA_ST_FCR_FEIE_Pos = 0x7
	// Bit mask of FEIE field.
	DMA_ST_FCR_FEIE_Msk = 0x80
	// Bit FEIE.
	DMA_ST_FCR_FEIE = 0x80
	// FE interrupt disabled
	DMA_ST_FCR_FEIE_Disabled = 0x0
	// FE interrupt enabled
	DMA_ST_FCR_FEIE_Enabled = 0x1
	// Position of FS field.
	DMA_ST_FCR_FS_Pos = 0x3
	// Bit mask of FS field.
	DMA_ST_FCR_FS_Msk = 0x38
	// 0 < fifo_level < 1/4
	DMA_ST_FCR_FS_Quarter1 = 0x0
	// 1/4 <= fifo_level < 1/2
	DMA_ST_FCR_FS_Quarter2 = 0x1
	// 1/2 <= fifo_level < 3/4
	DMA_ST_FCR_FS_Quarter3 = 0x2
	// 3/4 <= fifo_level < full
	DMA_ST_FCR_FS_Quarter4 = 0x3
	// FIFO is empty
	DMA_ST_FCR_FS_Empty = 0x4
	// FIFO is full
	DMA_ST_FCR_FS_Full = 0x5
	// Position of DMDIS field.
	DMA_ST_FCR_DMDIS_Pos = 0x2
	// Bit mask of DMDIS field.
	DMA_ST_FCR_DMDIS_Msk = 0x4
	// Bit DMDIS.
	DMA_ST_FCR_DMDIS = 0x4
	// Direct mode is enabled
	DMA_ST_FCR_DMDIS_Enabled = 0x0
	// Direct mode is disabled
	DMA_ST_FCR_DMDIS_Disabled = 0x1
	// Position of FTH field.
	DMA_ST_FCR_FTH_Pos = 0x0
	// Bit mask of FTH field.
	DMA_ST_FCR_FTH_Msk = 0x3
	// 1/4 full FIFO
	DMA_ST_FCR_FTH_Quarter = 0x0
	// 1/2 full FIFO
	DMA_ST_FCR_FTH_Half = 0x1
	// 3/4 full FIFO
	DMA_ST_FCR_FTH_ThreeQuarters = 0x2
	// Full FIFO
	DMA_ST_FCR_FTH_Full = 0x3
)

// Constants for RCC: Reset and clock control
const (
	// CR: clock control register
	// Position of PLLI2SRDY field.
	RCC_CR_PLLI2SRDY_Pos = 0x1b
	// Bit mask of PLLI2SRDY field.
	RCC_CR_PLLI2SRDY_Msk = 0x8000000
	// Bit PLLI2SRDY.
	RCC_CR_PLLI2SRDY = 0x8000000
	// Clock not ready
	RCC_CR_PLLI2SRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_PLLI2SRDY_Ready = 0x1
	// Position of PLLI2SON field.
	RCC_CR_PLLI2SON_Pos = 0x1a
	// Bit mask of PLLI2SON field.
	RCC_CR_PLLI2SON_Msk = 0x4000000
	// Bit PLLI2SON.
	RCC_CR_PLLI2SON = 0x4000000
	// Clock Off
	RCC_CR_PLLI2SON_Off = 0x0
	// Clock On
	RCC_CR_PLLI2SON_On = 0x1
	// Position of PLLRDY field.
	RCC_CR_PLLRDY_Pos = 0x19
	// Bit mask of PLLRDY field.
	RCC_CR_PLLRDY_Msk = 0x2000000
	// Bit PLLRDY.
	RCC_CR_PLLRDY = 0x2000000
	// Clock not ready
	RCC_CR_PLLRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_PLLRDY_Ready = 0x1
	// Position of PLLON field.
	RCC_CR_PLLON_Pos = 0x18
	// Bit mask of PLLON field.
	RCC_CR_PLLON_Msk = 0x1000000
	// Bit PLLON.
	RCC_CR_PLLON = 0x1000000
	// Clock Off
	RCC_CR_PLLON_Off = 0x0
	// Clock On
	RCC_CR_PLLON_On = 0x1
	// Position of CSSON field.
	RCC_CR_CSSON_Pos = 0x13
	// Bit mask of CSSON field.
	RCC_CR_CSSON_Msk = 0x80000
	// Bit CSSON.
	RCC_CR_CSSON = 0x80000
	// Clock security system disabled (clock detector OFF)
	RCC_CR_CSSON_Off = 0x0
	// Clock security system enable (clock detector ON if the HSE is ready, OFF if not)
	RCC_CR_CSSON_On = 0x1
	// Position of HSEBYP field.
	RCC_CR_HSEBYP_Pos = 0x12
	// Bit mask of HSEBYP field.
	RCC_CR_HSEBYP_Msk = 0x40000
	// Bit HSEBYP.
	RCC_CR_HSEBYP = 0x40000
	// HSE crystal oscillator not bypassed
	RCC_CR_HSEBYP_NotBypassed = 0x0
	// HSE crystal oscillator bypassed with external clock
	RCC_CR_HSEBYP_Bypassed = 0x1
	// Position of HSERDY field.
	RCC_CR_HSERDY_Pos = 0x11
	// Bit mask of HSERDY field.
	RCC_CR_HSERDY_Msk = 0x20000
	// Bit HSERDY.
	RCC_CR_HSERDY = 0x20000
	// Clock not ready
	RCC_CR_HSERDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSERDY_Ready = 0x1
	// Position of HSEON field.
	RCC_CR_HSEON_Pos = 0x10
	// Bit mask of HSEON field.
	RCC_CR_HSEON_Msk = 0x10000
	// Bit HSEON.
	RCC_CR_HSEON = 0x10000
	// Clock Off
	RCC_CR_HSEON_Off = 0x0
	// Clock On
	RCC_CR_HSEON_On = 0x1
	// Position of HSICAL field.
	RCC_CR_HSICAL_Pos = 0x8
	// Bit mask of HSICAL field.
	RCC_CR_HSICAL_Msk = 0xff00
	// Position of HSITRIM field.
	RCC_CR_HSITRIM_Pos = 0x3
	// Bit mask of HSITRIM field.
	RCC_CR_HSITRIM_Msk = 0xf8
	// Position of HSIRDY field.
	RCC_CR_HSIRDY_Pos = 0x1
	// Bit mask of HSIRDY field.
	RCC_CR_HSIRDY_Msk = 0x2
	// Bit HSIRDY.
	RCC_CR_HSIRDY = 0x2
	// Clock not ready
	RCC_CR_HSIRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSIRDY_Ready = 0x1
	// Position of HSION field.
	RCC_CR_HSION_Pos = 0x0
	// Bit mask of HSION field.
	RCC_CR_HSION_Msk = 0x1
	// Bit HSION.
	RCC_CR_HSION = 0x1
	// Clock Off
	RCC_CR_HSION_Off = 0x0
	// Clock On
	RCC_CR_HSION_On = 0x1

	// PLLCFGR: PLL configuration register
	// Position of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Pos = 0x16
	// Bit mask of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Msk = 0x400000
	// Bit PLLSRC.
	RCC_PLLCFGR_PLLSRC = 0x400000
	// HSI clock selected as PLL and PLLI2S clock entry
	RCC_PLLCFGR_PLLSRC_HSI = 0x0
	// HSE oscillator clock selected as PLL and PLLI2S clock entry
	RCC_PLLCFGR_PLLSRC_HSE = 0x1
	// Position of PLLM field.
	RCC_PLLCFGR_PLLM_Pos = 0x0
	// Bit mask of PLLM field.
	RCC_PLLCFGR_PLLM_Msk = 0x3f
	// Position of PLLN field.
	RCC_PLLCFGR_PLLN_Pos = 0x6
	// Bit mask of PLLN field.
	RCC_PLLCFGR_PLLN_Msk = 0x7fc0
	// Position of PLLP field.
	RCC_PLLCFGR_PLLP_Pos = 0x10
	// Bit mask of PLLP field.
	RCC_PLLCFGR_PLLP_Msk = 0x30000
	// PLLP=2
	RCC_PLLCFGR_PLLP_Div2 = 0x0
	// PLLP=4
	RCC_PLLCFGR_PLLP_Div4 = 0x1
	// PLLP=6
	RCC_PLLCFGR_PLLP_Div6 = 0x2
	// PLLP=8
	RCC_PLLCFGR_PLLP_Div8 = 0x3
	// Position of PLLQ field.
	RCC_PLLCFGR_PLLQ_Pos = 0x18
	// Bit mask of PLLQ field.
	RCC_PLLCFGR_PLLQ_Msk = 0xf000000

	// CFGR: clock configuration register
	// Position of I2SSRC field.
	RCC_CFGR_I2SSRC_Pos = 0x17
	// Bit mask of I2SSRC field.
	RCC_CFGR_I2SSRC_Msk = 0x800000
	// Bit I2SSRC.
	RCC_CFGR_I2SSRC = 0x800000
	// PLLI2S clock used as I2S clock source
	RCC_CFGR_I2SSRC_PLLI2S = 0x0
	// External clock mapped on the I2S_CKIN pin used as I2S clock source
	RCC_CFGR_I2SSRC_CKIN = 0x1
	// Position of MCO1 field.
	RCC_CFGR_MCO1_Pos = 0x15
	// Bit mask of MCO1 field.
	RCC_CFGR_MCO1_Msk = 0x600000
	// HSI clock selected
	RCC_CFGR_MCO1_HSI = 0x0
	// LSE oscillator selected
	RCC_CFGR_MCO1_LSE = 0x1
	// HSE oscillator clock selected
	RCC_CFGR_MCO1_HSE = 0x2
	// PLL clock selected
	RCC_CFGR_MCO1_PLL = 0x3
	// Position of MCO1PRE field.
	RCC_CFGR_MCO1PRE_Pos = 0x18
	// Bit mask of MCO1PRE field.
	RCC_CFGR_MCO1PRE_Msk = 0x7000000
	// No division
	RCC_CFGR_MCO1PRE_Div1 = 0x0
	// Division by 2
	RCC_CFGR_MCO1PRE_Div2 = 0x4
	// Division by 3
	RCC_CFGR_MCO1PRE_Div3 = 0x5
	// Division by 4
	RCC_CFGR_MCO1PRE_Div4 = 0x6
	// Division by 5
	RCC_CFGR_MCO1PRE_Div5 = 0x7
	// Position of MCO2PRE field.
	RCC_CFGR_MCO2PRE_Pos = 0x1b
	// Bit mask of MCO2PRE field.
	RCC_CFGR_MCO2PRE_Msk = 0x38000000
	// No division
	RCC_CFGR_MCO2PRE_Div1 = 0x0
	// Division by 2
	RCC_CFGR_MCO2PRE_Div2 = 0x4
	// Division by 3
	RCC_CFGR_MCO2PRE_Div3 = 0x5
	// Division by 4
	RCC_CFGR_MCO2PRE_Div4 = 0x6
	// Division by 5
	RCC_CFGR_MCO2PRE_Div5 = 0x7
	// Position of MCO2 field.
	RCC_CFGR_MCO2_Pos = 0x1e
	// Bit mask of MCO2 field.
	RCC_CFGR_MCO2_Msk = 0xc0000000
	// System clock (SYSCLK) selected
	RCC_CFGR_MCO2_SYSCLK = 0x0
	// PLLI2S clock selected
	RCC_CFGR_MCO2_PLLI2S = 0x1
	// HSE oscillator clock selected
	RCC_CFGR_MCO2_HSE = 0x2
	// PLL clock selected
	RCC_CFGR_MCO2_PLL = 0x3
	// Position of RTCPRE field.
	RCC_CFGR_RTCPRE_Pos = 0x10
	// Bit mask of RTCPRE field.
	RCC_CFGR_RTCPRE_Msk = 0x1f0000
	// Position of PPRE2 field.
	RCC_CFGR_PPRE2_Pos = 0xd
	// Bit mask of PPRE2 field.
	RCC_CFGR_PPRE2_Msk = 0xe000
	// HCLK not divided
	RCC_CFGR_PPRE2_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE2_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE2_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE2_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE2_Div16 = 0x7
	// Position of PPRE1 field.
	RCC_CFGR_PPRE1_Pos = 0xa
	// Bit mask of PPRE1 field.
	RCC_CFGR_PPRE1_Msk = 0x1c00
	// HCLK not divided
	RCC_CFGR_PPRE1_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE1_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE1_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE1_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE1_Div16 = 0x7
	// Position of HPRE field.
	RCC_CFGR_HPRE_Pos = 0x4
	// Bit mask of HPRE field.
	RCC_CFGR_HPRE_Msk = 0xf0
	// SYSCLK not divided
	RCC_CFGR_HPRE_Div1 = 0x0
	// SYSCLK divided by 2
	RCC_CFGR_HPRE_Div2 = 0x8
	// SYSCLK divided by 4
	RCC_CFGR_HPRE_Div4 = 0x9
	// SYSCLK divided by 8
	RCC_CFGR_HPRE_Div8 = 0xa
	// SYSCLK divided by 16
	RCC_CFGR_HPRE_Div16 = 0xb
	// SYSCLK divided by 64
	RCC_CFGR_HPRE_Div64 = 0xc
	// SYSCLK divided by 128
	RCC_CFGR_HPRE_Div128 = 0xd
	// SYSCLK divided by 256
	RCC_CFGR_HPRE_Div256 = 0xe
	// SYSCLK divided by 512
	RCC_CFGR_HPRE_Div512 = 0xf
	// Position of SW field.
	RCC_CFGR_SW_Pos = 0x0
	// Bit mask of SW field.
	RCC_CFGR_SW_Msk = 0x3
	// HSI selected as system clock
	RCC_CFGR_SW_HSI = 0x0
	// HSE selected as system clock
	RCC_CFGR_SW_HSE = 0x1
	// PLL selected as system clock
	RCC_CFGR_SW_PLL = 0x2
	// Position of SWS field.
	RCC_CFGR_SWS_Pos = 0x2
	// Bit mask of SWS field.
	RCC_CFGR_SWS_Msk = 0xc
	// HSI oscillator used as system clock
	RCC_CFGR_SWS_HSI = 0x0
	// HSE oscillator used as system clock
	RCC_CFGR_SWS_HSE = 0x1
	// PLL used as system clock
	RCC_CFGR_SWS_PLL = 0x2

	// CIR: clock interrupt register
	// Position of CSSC field.
	RCC_CIR_CSSC_Pos = 0x17
	// Bit mask of CSSC field.
	RCC_CIR_CSSC_Msk = 0x800000
	// Bit CSSC.
	RCC_CIR_CSSC = 0x800000
	// Clear CSSF flag
	RCC_CIR_CSSC_Clear = 0x1
	// Position of PLLI2SRDYC field.
	RCC_CIR_PLLI2SRDYC_Pos = 0x15
	// Bit mask of PLLI2SRDYC field.
	RCC_CIR_PLLI2SRDYC_Msk = 0x200000
	// Bit PLLI2SRDYC.
	RCC_CIR_PLLI2SRDYC = 0x200000
	// Clear interrupt flag
	RCC_CIR_PLLI2SRDYC_Clear = 0x1
	// Position of PLLRDYC field.
	RCC_CIR_PLLRDYC_Pos = 0x14
	// Bit mask of PLLRDYC field.
	RCC_CIR_PLLRDYC_Msk = 0x100000
	// Bit PLLRDYC.
	RCC_CIR_PLLRDYC = 0x100000
	// Clear interrupt flag
	RCC_CIR_PLLRDYC_Clear = 0x1
	// Position of HSERDYC field.
	RCC_CIR_HSERDYC_Pos = 0x13
	// Bit mask of HSERDYC field.
	RCC_CIR_HSERDYC_Msk = 0x80000
	// Bit HSERDYC.
	RCC_CIR_HSERDYC = 0x80000
	// Clear interrupt flag
	RCC_CIR_HSERDYC_Clear = 0x1
	// Position of HSIRDYC field.
	RCC_CIR_HSIRDYC_Pos = 0x12
	// Bit mask of HSIRDYC field.
	RCC_CIR_HSIRDYC_Msk = 0x40000
	// Bit HSIRDYC.
	RCC_CIR_HSIRDYC = 0x40000
	// Clear interrupt flag
	RCC_CIR_HSIRDYC_Clear = 0x1
	// Position of LSERDYC field.
	RCC_CIR_LSERDYC_Pos = 0x11
	// Bit mask of LSERDYC field.
	RCC_CIR_LSERDYC_Msk = 0x20000
	// Bit LSERDYC.
	RCC_CIR_LSERDYC = 0x20000
	// Clear interrupt flag
	RCC_CIR_LSERDYC_Clear = 0x1
	// Position of LSIRDYC field.
	RCC_CIR_LSIRDYC_Pos = 0x10
	// Bit mask of LSIRDYC field.
	RCC_CIR_LSIRDYC_Msk = 0x10000
	// Bit LSIRDYC.
	RCC_CIR_LSIRDYC = 0x10000
	// Clear interrupt flag
	RCC_CIR_LSIRDYC_Clear = 0x1
	// Position of PLLI2SRDYIE field.
	RCC_CIR_PLLI2SRDYIE_Pos = 0xd
	// Bit mask of PLLI2SRDYIE field.
	RCC_CIR_PLLI2SRDYIE_Msk = 0x2000
	// Bit PLLI2SRDYIE.
	RCC_CIR_PLLI2SRDYIE = 0x2000
	// Interrupt disabled
	RCC_CIR_PLLI2SRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_PLLI2SRDYIE_Enabled = 0x1
	// Position of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Pos = 0xc
	// Bit mask of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Msk = 0x1000
	// Bit PLLRDYIE.
	RCC_CIR_PLLRDYIE = 0x1000
	// Interrupt disabled
	RCC_CIR_PLLRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_PLLRDYIE_Enabled = 0x1
	// Position of HSERDYIE field.
	RCC_CIR_HSERDYIE_Pos = 0xb
	// Bit mask of HSERDYIE field.
	RCC_CIR_HSERDYIE_Msk = 0x800
	// Bit HSERDYIE.
	RCC_CIR_HSERDYIE = 0x800
	// Interrupt disabled
	RCC_CIR_HSERDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_HSERDYIE_Enabled = 0x1
	// Position of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Pos = 0xa
	// Bit mask of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Msk = 0x400
	// Bit HSIRDYIE.
	RCC_CIR_HSIRDYIE = 0x400
	// Interrupt disabled
	RCC_CIR_HSIRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_HSIRDYIE_Enabled = 0x1
	// Position of LSERDYIE field.
	RCC_CIR_LSERDYIE_Pos = 0x9
	// Bit mask of LSERDYIE field.
	RCC_CIR_LSERDYIE_Msk = 0x200
	// Bit LSERDYIE.
	RCC_CIR_LSERDYIE = 0x200
	// Interrupt disabled
	RCC_CIR_LSERDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_LSERDYIE_Enabled = 0x1
	// Position of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Pos = 0x8
	// Bit mask of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Msk = 0x100
	// Bit LSIRDYIE.
	RCC_CIR_LSIRDYIE = 0x100
	// Interrupt disabled
	RCC_CIR_LSIRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_LSIRDYIE_Enabled = 0x1
	// Position of CSSF field.
	RCC_CIR_CSSF_Pos = 0x7
	// Bit mask of CSSF field.
	RCC_CIR_CSSF_Msk = 0x80
	// Bit CSSF.
	RCC_CIR_CSSF = 0x80
	// No clock security interrupt caused by HSE clock failure
	RCC_CIR_CSSF_NotInterrupted = 0x0
	// Clock security interrupt caused by HSE clock failure
	RCC_CIR_CSSF_Interrupted = 0x1
	// Position of PLLI2SRDYF field.
	RCC_CIR_PLLI2SRDYF_Pos = 0x5
	// Bit mask of PLLI2SRDYF field.
	RCC_CIR_PLLI2SRDYF_Msk = 0x20
	// Bit PLLI2SRDYF.
	RCC_CIR_PLLI2SRDYF = 0x20
	// No clock ready interrupt
	RCC_CIR_PLLI2SRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_PLLI2SRDYF_Interrupted = 0x1
	// Position of PLLRDYF field.
	RCC_CIR_PLLRDYF_Pos = 0x4
	// Bit mask of PLLRDYF field.
	RCC_CIR_PLLRDYF_Msk = 0x10
	// Bit PLLRDYF.
	RCC_CIR_PLLRDYF = 0x10
	// No clock ready interrupt
	RCC_CIR_PLLRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_PLLRDYF_Interrupted = 0x1
	// Position of HSERDYF field.
	RCC_CIR_HSERDYF_Pos = 0x3
	// Bit mask of HSERDYF field.
	RCC_CIR_HSERDYF_Msk = 0x8
	// Bit HSERDYF.
	RCC_CIR_HSERDYF = 0x8
	// No clock ready interrupt
	RCC_CIR_HSERDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_HSERDYF_Interrupted = 0x1
	// Position of HSIRDYF field.
	RCC_CIR_HSIRDYF_Pos = 0x2
	// Bit mask of HSIRDYF field.
	RCC_CIR_HSIRDYF_Msk = 0x4
	// Bit HSIRDYF.
	RCC_CIR_HSIRDYF = 0x4
	// No clock ready interrupt
	RCC_CIR_HSIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_HSIRDYF_Interrupted = 0x1
	// Position of LSERDYF field.
	RCC_CIR_LSERDYF_Pos = 0x1
	// Bit mask of LSERDYF field.
	RCC_CIR_LSERDYF_Msk = 0x2
	// Bit LSERDYF.
	RCC_CIR_LSERDYF = 0x2
	// No clock ready interrupt
	RCC_CIR_LSERDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_LSERDYF_Interrupted = 0x1
	// Position of LSIRDYF field.
	RCC_CIR_LSIRDYF_Pos = 0x0
	// Bit mask of LSIRDYF field.
	RCC_CIR_LSIRDYF_Msk = 0x1
	// Bit LSIRDYF.
	RCC_CIR_LSIRDYF = 0x1
	// No clock ready interrupt
	RCC_CIR_LSIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_LSIRDYF_Interrupted = 0x1

	// AHB1RSTR: AHB1 peripheral reset register
	// Position of OTGHSRST field.
	RCC_AHB1RSTR_OTGHSRST_Pos = 0x1d
	// Bit mask of OTGHSRST field.
	RCC_AHB1RSTR_OTGHSRST_Msk = 0x20000000
	// Bit OTGHSRST.
	RCC_AHB1RSTR_OTGHSRST = 0x20000000
	// Reset the selected module
	RCC_AHB1RSTR_OTGHSRST_Reset = 0x1
	// Position of ETHMACRST field.
	RCC_AHB1RSTR_ETHMACRST_Pos = 0x19
	// Bit mask of ETHMACRST field.
	RCC_AHB1RSTR_ETHMACRST_Msk = 0x2000000
	// Bit ETHMACRST.
	RCC_AHB1RSTR_ETHMACRST = 0x2000000
	// Reset the selected module
	RCC_AHB1RSTR_ETHMACRST_Reset = 0x1
	// Position of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Pos = 0x16
	// Bit mask of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Msk = 0x400000
	// Bit DMA2RST.
	RCC_AHB1RSTR_DMA2RST = 0x400000
	// Reset the selected module
	RCC_AHB1RSTR_DMA2RST_Reset = 0x1
	// Position of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Pos = 0x15
	// Bit mask of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Msk = 0x200000
	// Bit DMA1RST.
	RCC_AHB1RSTR_DMA1RST = 0x200000
	// Reset the selected module
	RCC_AHB1RSTR_DMA1RST_Reset = 0x1
	// Position of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Pos = 0xc
	// Bit mask of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Msk = 0x1000
	// Bit CRCRST.
	RCC_AHB1RSTR_CRCRST = 0x1000
	// Reset the selected module
	RCC_AHB1RSTR_CRCRST_Reset = 0x1
	// Position of GPIOIRST field.
	RCC_AHB1RSTR_GPIOIRST_Pos = 0x8
	// Bit mask of GPIOIRST field.
	RCC_AHB1RSTR_GPIOIRST_Msk = 0x100
	// Bit GPIOIRST.
	RCC_AHB1RSTR_GPIOIRST = 0x100
	// Reset the selected module
	RCC_AHB1RSTR_GPIOIRST_Reset = 0x1
	// Position of GPIOHRST field.
	RCC_AHB1RSTR_GPIOHRST_Pos = 0x7
	// Bit mask of GPIOHRST field.
	RCC_AHB1RSTR_GPIOHRST_Msk = 0x80
	// Bit GPIOHRST.
	RCC_AHB1RSTR_GPIOHRST = 0x80
	// Reset the selected module
	RCC_AHB1RSTR_GPIOHRST_Reset = 0x1
	// Position of GPIOGRST field.
	RCC_AHB1RSTR_GPIOGRST_Pos = 0x6
	// Bit mask of GPIOGRST field.
	RCC_AHB1RSTR_GPIOGRST_Msk = 0x40
	// Bit GPIOGRST.
	RCC_AHB1RSTR_GPIOGRST = 0x40
	// Reset the selected module
	RCC_AHB1RSTR_GPIOGRST_Reset = 0x1
	// Position of GPIOFRST field.
	RCC_AHB1RSTR_GPIOFRST_Pos = 0x5
	// Bit mask of GPIOFRST field.
	RCC_AHB1RSTR_GPIOFRST_Msk = 0x20
	// Bit GPIOFRST.
	RCC_AHB1RSTR_GPIOFRST = 0x20
	// Reset the selected module
	RCC_AHB1RSTR_GPIOFRST_Reset = 0x1
	// Position of GPIOERST field.
	RCC_AHB1RSTR_GPIOERST_Pos = 0x4
	// Bit mask of GPIOERST field.
	RCC_AHB1RSTR_GPIOERST_Msk = 0x10
	// Bit GPIOERST.
	RCC_AHB1RSTR_GPIOERST = 0x10
	// Reset the selected module
	RCC_AHB1RSTR_GPIOERST_Reset = 0x1
	// Position of GPIODRST field.
	RCC_AHB1RSTR_GPIODRST_Pos = 0x3
	// Bit mask of GPIODRST field.
	RCC_AHB1RSTR_GPIODRST_Msk = 0x8
	// Bit GPIODRST.
	RCC_AHB1RSTR_GPIODRST = 0x8
	// Reset the selected module
	RCC_AHB1RSTR_GPIODRST_Reset = 0x1
	// Position of GPIOCRST field.
	RCC_AHB1RSTR_GPIOCRST_Pos = 0x2
	// Bit mask of GPIOCRST field.
	RCC_AHB1RSTR_GPIOCRST_Msk = 0x4
	// Bit GPIOCRST.
	RCC_AHB1RSTR_GPIOCRST = 0x4
	// Reset the selected module
	RCC_AHB1RSTR_GPIOCRST_Reset = 0x1
	// Position of GPIOBRST field.
	RCC_AHB1RSTR_GPIOBRST_Pos = 0x1
	// Bit mask of GPIOBRST field.
	RCC_AHB1RSTR_GPIOBRST_Msk = 0x2
	// Bit GPIOBRST.
	RCC_AHB1RSTR_GPIOBRST = 0x2
	// Reset the selected module
	RCC_AHB1RSTR_GPIOBRST_Reset = 0x1
	// Position of GPIOARST field.
	RCC_AHB1RSTR_GPIOARST_Pos = 0x0
	// Bit mask of GPIOARST field.
	RCC_AHB1RSTR_GPIOARST_Msk = 0x1
	// Bit GPIOARST.
	RCC_AHB1RSTR_GPIOARST = 0x1
	// Reset the selected module
	RCC_AHB1RSTR_GPIOARST_Reset = 0x1

	// AHB2RSTR: AHB2 peripheral reset register
	// Position of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST_Pos = 0x7
	// Bit mask of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST_Msk = 0x80
	// Bit OTGFSRST.
	RCC_AHB2RSTR_OTGFSRST = 0x80
	// Reset the selected module
	RCC_AHB2RSTR_OTGFSRST_Reset = 0x1
	// Position of RNGRST field.
	RCC_AHB2RSTR_RNGRST_Pos = 0x6
	// Bit mask of RNGRST field.
	RCC_AHB2RSTR_RNGRST_Msk = 0x40
	// Bit RNGRST.
	RCC_AHB2RSTR_RNGRST = 0x40
	// Reset the selected module
	RCC_AHB2RSTR_RNGRST_Reset = 0x1
	// Position of HSAHRST field.
	RCC_AHB2RSTR_HSAHRST_Pos = 0x5
	// Bit mask of HSAHRST field.
	RCC_AHB2RSTR_HSAHRST_Msk = 0x20
	// Bit HSAHRST.
	RCC_AHB2RSTR_HSAHRST = 0x20
	// Reset the selected module
	RCC_AHB2RSTR_HSAHRST_Reset = 0x1
	// Position of CRYPRST field.
	RCC_AHB2RSTR_CRYPRST_Pos = 0x4
	// Bit mask of CRYPRST field.
	RCC_AHB2RSTR_CRYPRST_Msk = 0x10
	// Bit CRYPRST.
	RCC_AHB2RSTR_CRYPRST = 0x10
	// Reset the selected module
	RCC_AHB2RSTR_CRYPRST_Reset = 0x1
	// Position of DCMIRST field.
	RCC_AHB2RSTR_DCMIRST_Pos = 0x0
	// Bit mask of DCMIRST field.
	RCC_AHB2RSTR_DCMIRST_Msk = 0x1
	// Bit DCMIRST.
	RCC_AHB2RSTR_DCMIRST = 0x1
	// Reset the selected module
	RCC_AHB2RSTR_DCMIRST_Reset = 0x1

	// AHB3RSTR: AHB3 peripheral reset register
	// Position of FSMCRST field.
	RCC_AHB3RSTR_FSMCRST_Pos = 0x0
	// Bit mask of FSMCRST field.
	RCC_AHB3RSTR_FSMCRST_Msk = 0x1
	// Bit FSMCRST.
	RCC_AHB3RSTR_FSMCRST = 0x1
	// Reset the selected module
	RCC_AHB3RSTR_FSMCRST_Reset = 0x1

	// APB1RSTR: APB1 peripheral reset register
	// Position of DACRST field.
	RCC_APB1RSTR_DACRST_Pos = 0x1d
	// Bit mask of DACRST field.
	RCC_APB1RSTR_DACRST_Msk = 0x20000000
	// Bit DACRST.
	RCC_APB1RSTR_DACRST = 0x20000000
	// Reset the selected module
	RCC_APB1RSTR_DACRST_Reset = 0x1
	// Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Pos = 0x1c
	// Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk = 0x10000000
	// Bit PWRRST.
	RCC_APB1RSTR_PWRRST = 0x10000000
	// Reset the selected module
	RCC_APB1RSTR_PWRRST_Reset = 0x1
	// Position of CAN2RST field.
	RCC_APB1RSTR_CAN2RST_Pos = 0x1a
	// Bit mask of CAN2RST field.
	RCC_APB1RSTR_CAN2RST_Msk = 0x4000000
	// Bit CAN2RST.
	RCC_APB1RSTR_CAN2RST = 0x4000000
	// Reset the selected module
	RCC_APB1RSTR_CAN2RST_Reset = 0x1
	// Position of CAN1RST field.
	RCC_APB1RSTR_CAN1RST_Pos = 0x19
	// Bit mask of CAN1RST field.
	RCC_APB1RSTR_CAN1RST_Msk = 0x2000000
	// Bit CAN1RST.
	RCC_APB1RSTR_CAN1RST = 0x2000000
	// Reset the selected module
	RCC_APB1RSTR_CAN1RST_Reset = 0x1
	// Position of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Pos = 0x17
	// Bit mask of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Msk = 0x800000
	// Bit I2C3RST.
	RCC_APB1RSTR_I2C3RST = 0x800000
	// Reset the selected module
	RCC_APB1RSTR_I2C3RST_Reset = 0x1
	// Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Pos = 0x16
	// Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk = 0x400000
	// Bit I2C2RST.
	RCC_APB1RSTR_I2C2RST = 0x400000
	// Reset the selected module
	RCC_APB1RSTR_I2C2RST_Reset = 0x1
	// Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Pos = 0x15
	// Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk = 0x200000
	// Bit I2C1RST.
	RCC_APB1RSTR_I2C1RST = 0x200000
	// Reset the selected module
	RCC_APB1RSTR_I2C1RST_Reset = 0x1
	// Position of UART5RST field.
	RCC_APB1RSTR_UART5RST_Pos = 0x14
	// Bit mask of UART5RST field.
	RCC_APB1RSTR_UART5RST_Msk = 0x100000
	// Bit UART5RST.
	RCC_APB1RSTR_UART5RST = 0x100000
	// Reset the selected module
	RCC_APB1RSTR_UART5RST_Reset = 0x1
	// Position of UART4RST field.
	RCC_APB1RSTR_UART4RST_Pos = 0x13
	// Bit mask of UART4RST field.
	RCC_APB1RSTR_UART4RST_Msk = 0x80000
	// Bit UART4RST.
	RCC_APB1RSTR_UART4RST = 0x80000
	// Reset the selected module
	RCC_APB1RSTR_UART4RST_Reset = 0x1
	// Position of USART3RST field.
	RCC_APB1RSTR_USART3RST_Pos = 0x12
	// Bit mask of USART3RST field.
	RCC_APB1RSTR_USART3RST_Msk = 0x40000
	// Bit USART3RST.
	RCC_APB1RSTR_USART3RST = 0x40000
	// Reset the selected module
	RCC_APB1RSTR_USART3RST_Reset = 0x1
	// Position of USART2RST field.
	RCC_APB1RSTR_USART2RST_Pos = 0x11
	// Bit mask of USART2RST field.
	RCC_APB1RSTR_USART2RST_Msk = 0x20000
	// Bit USART2RST.
	RCC_APB1RSTR_USART2RST = 0x20000
	// Reset the selected module
	RCC_APB1RSTR_USART2RST_Reset = 0x1
	// Position of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Pos = 0xf
	// Bit mask of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Msk = 0x8000
	// Bit SPI3RST.
	RCC_APB1RSTR_SPI3RST = 0x8000
	// Reset the selected module
	RCC_APB1RSTR_SPI3RST_Reset = 0x1
	// Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Pos = 0xe
	// Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk = 0x4000
	// Bit SPI2RST.
	RCC_APB1RSTR_SPI2RST = 0x4000
	// Reset the selected module
	RCC_APB1RSTR_SPI2RST_Reset = 0x1
	// Position of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Pos = 0xb
	// Bit mask of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Msk = 0x800
	// Bit WWDGRST.
	RCC_APB1RSTR_WWDGRST = 0x800
	// Reset the selected module
	RCC_APB1RSTR_WWDGRST_Reset = 0x1
	// Position of TIM14RST field.
	RCC_APB1RSTR_TIM14RST_Pos = 0x8
	// Bit mask of TIM14RST field.
	RCC_APB1RSTR_TIM14RST_Msk = 0x100
	// Bit TIM14RST.
	RCC_APB1RSTR_TIM14RST = 0x100
	// Reset the selected module
	RCC_APB1RSTR_TIM14RST_Reset = 0x1
	// Position of TIM13RST field.
	RCC_APB1RSTR_TIM13RST_Pos = 0x7
	// Bit mask of TIM13RST field.
	RCC_APB1RSTR_TIM13RST_Msk = 0x80
	// Bit TIM13RST.
	RCC_APB1RSTR_TIM13RST = 0x80
	// Reset the selected module
	RCC_APB1RSTR_TIM13RST_Reset = 0x1
	// Position of TIM12RST field.
	RCC_APB1RSTR_TIM12RST_Pos = 0x6
	// Bit mask of TIM12RST field.
	RCC_APB1RSTR_TIM12RST_Msk = 0x40
	// Bit TIM12RST.
	RCC_APB1RSTR_TIM12RST = 0x40
	// Reset the selected module
	RCC_APB1RSTR_TIM12RST_Reset = 0x1
	// Position of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Pos = 0x5
	// Bit mask of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Msk = 0x20
	// Bit TIM7RST.
	RCC_APB1RSTR_TIM7RST = 0x20
	// Reset the selected module
	RCC_APB1RSTR_TIM7RST_Reset = 0x1
	// Position of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Pos = 0x4
	// Bit mask of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Msk = 0x10
	// Bit TIM6RST.
	RCC_APB1RSTR_TIM6RST = 0x10
	// Reset the selected module
	RCC_APB1RSTR_TIM6RST_Reset = 0x1
	// Position of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Pos = 0x3
	// Bit mask of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Msk = 0x8
	// Bit TIM5RST.
	RCC_APB1RSTR_TIM5RST = 0x8
	// Reset the selected module
	RCC_APB1RSTR_TIM5RST_Reset = 0x1
	// Position of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Pos = 0x2
	// Bit mask of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Msk = 0x4
	// Bit TIM4RST.
	RCC_APB1RSTR_TIM4RST = 0x4
	// Reset the selected module
	RCC_APB1RSTR_TIM4RST_Reset = 0x1
	// Position of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Pos = 0x1
	// Bit mask of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Msk = 0x2
	// Bit TIM3RST.
	RCC_APB1RSTR_TIM3RST = 0x2
	// Reset the selected module
	RCC_APB1RSTR_TIM3RST_Reset = 0x1
	// Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Pos = 0x0
	// Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk = 0x1
	// Bit TIM2RST.
	RCC_APB1RSTR_TIM2RST = 0x1
	// Reset the selected module
	RCC_APB1RSTR_TIM2RST_Reset = 0x1

	// APB2RSTR: APB2 peripheral reset register
	// Position of TIM11RST field.
	RCC_APB2RSTR_TIM11RST_Pos = 0x12
	// Bit mask of TIM11RST field.
	RCC_APB2RSTR_TIM11RST_Msk = 0x40000
	// Bit TIM11RST.
	RCC_APB2RSTR_TIM11RST = 0x40000
	// Reset the selected module
	RCC_APB2RSTR_TIM11RST_Reset = 0x1
	// Position of TIM10RST field.
	RCC_APB2RSTR_TIM10RST_Pos = 0x11
	// Bit mask of TIM10RST field.
	RCC_APB2RSTR_TIM10RST_Msk = 0x20000
	// Bit TIM10RST.
	RCC_APB2RSTR_TIM10RST = 0x20000
	// Reset the selected module
	RCC_APB2RSTR_TIM10RST_Reset = 0x1
	// Position of TIM9RST field.
	RCC_APB2RSTR_TIM9RST_Pos = 0x10
	// Bit mask of TIM9RST field.
	RCC_APB2RSTR_TIM9RST_Msk = 0x10000
	// Bit TIM9RST.
	RCC_APB2RSTR_TIM9RST = 0x10000
	// Reset the selected module
	RCC_APB2RSTR_TIM9RST_Reset = 0x1
	// Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Pos = 0xe
	// Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x4000
	// Bit SYSCFGRST.
	RCC_APB2RSTR_SYSCFGRST = 0x4000
	// Reset the selected module
	RCC_APB2RSTR_SYSCFGRST_Reset = 0x1
	// Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Pos = 0xc
	// Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk = 0x1000
	// Bit SPI1RST.
	RCC_APB2RSTR_SPI1RST = 0x1000
	// Reset the selected module
	RCC_APB2RSTR_SPI1RST_Reset = 0x1
	// Position of SDIORST field.
	RCC_APB2RSTR_SDIORST_Pos = 0xb
	// Bit mask of SDIORST field.
	RCC_APB2RSTR_SDIORST_Msk = 0x800
	// Bit SDIORST.
	RCC_APB2RSTR_SDIORST = 0x800
	// Reset the selected module
	RCC_APB2RSTR_SDIORST_Reset = 0x1
	// Position of ADCRST field.
	RCC_APB2RSTR_ADCRST_Pos = 0x8
	// Bit mask of ADCRST field.
	RCC_APB2RSTR_ADCRST_Msk = 0x100
	// Bit ADCRST.
	RCC_APB2RSTR_ADCRST = 0x100
	// Reset the selected module
	RCC_APB2RSTR_ADCRST_Reset = 0x1
	// Position of USART6RST field.
	RCC_APB2RSTR_USART6RST_Pos = 0x5
	// Bit mask of USART6RST field.
	RCC_APB2RSTR_USART6RST_Msk = 0x20
	// Bit USART6RST.
	RCC_APB2RSTR_USART6RST = 0x20
	// Reset the selected module
	RCC_APB2RSTR_USART6RST_Reset = 0x1
	// Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Pos = 0x4
	// Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x10
	// Bit USART1RST.
	RCC_APB2RSTR_USART1RST = 0x10
	// Reset the selected module
	RCC_APB2RSTR_USART1RST_Reset = 0x1
	// Position of TIM8RST field.
	RCC_APB2RSTR_TIM8RST_Pos = 0x1
	// Bit mask of TIM8RST field.
	RCC_APB2RSTR_TIM8RST_Msk = 0x2
	// Bit TIM8RST.
	RCC_APB2RSTR_TIM8RST = 0x2
	// Reset the selected module
	RCC_APB2RSTR_TIM8RST_Reset = 0x1
	// Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Pos = 0x0
	// Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk = 0x1
	// Bit TIM1RST.
	RCC_APB2RSTR_TIM1RST = 0x1
	// Reset the selected module
	RCC_APB2RSTR_TIM1RST_Reset = 0x1

	// AHB1ENR: AHB1 peripheral clock register
	// Position of OTGHSULPIEN field.
	RCC_AHB1ENR_OTGHSULPIEN_Pos = 0x1e
	// Bit mask of OTGHSULPIEN field.
	RCC_AHB1ENR_OTGHSULPIEN_Msk = 0x40000000
	// Bit OTGHSULPIEN.
	RCC_AHB1ENR_OTGHSULPIEN = 0x40000000
	// The selected clock is disabled
	RCC_AHB1ENR_OTGHSULPIEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_OTGHSULPIEN_Enabled = 0x1
	// Position of OTGHSEN field.
	RCC_AHB1ENR_OTGHSEN_Pos = 0x1d
	// Bit mask of OTGHSEN field.
	RCC_AHB1ENR_OTGHSEN_Msk = 0x20000000
	// Bit OTGHSEN.
	RCC_AHB1ENR_OTGHSEN = 0x20000000
	// The selected clock is disabled
	RCC_AHB1ENR_OTGHSEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_OTGHSEN_Enabled = 0x1
	// Position of ETHMACPTPEN field.
	RCC_AHB1ENR_ETHMACPTPEN_Pos = 0x1c
	// Bit mask of ETHMACPTPEN field.
	RCC_AHB1ENR_ETHMACPTPEN_Msk = 0x10000000
	// Bit ETHMACPTPEN.
	RCC_AHB1ENR_ETHMACPTPEN = 0x10000000
	// The selected clock is disabled
	RCC_AHB1ENR_ETHMACPTPEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_ETHMACPTPEN_Enabled = 0x1
	// Position of ETHMACRXEN field.
	RCC_AHB1ENR_ETHMACRXEN_Pos = 0x1b
	// Bit mask of ETHMACRXEN field.
	RCC_AHB1ENR_ETHMACRXEN_Msk = 0x8000000
	// Bit ETHMACRXEN.
	RCC_AHB1ENR_ETHMACRXEN = 0x8000000
	// The selected clock is disabled
	RCC_AHB1ENR_ETHMACRXEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_ETHMACRXEN_Enabled = 0x1
	// Position of ETHMACTXEN field.
	RCC_AHB1ENR_ETHMACTXEN_Pos = 0x1a
	// Bit mask of ETHMACTXEN field.
	RCC_AHB1ENR_ETHMACTXEN_Msk = 0x4000000
	// Bit ETHMACTXEN.
	RCC_AHB1ENR_ETHMACTXEN = 0x4000000
	// The selected clock is disabled
	RCC_AHB1ENR_ETHMACTXEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_ETHMACTXEN_Enabled = 0x1
	// Position of ETHMACEN field.
	RCC_AHB1ENR_ETHMACEN_Pos = 0x19
	// Bit mask of ETHMACEN field.
	RCC_AHB1ENR_ETHMACEN_Msk = 0x2000000
	// Bit ETHMACEN.
	RCC_AHB1ENR_ETHMACEN = 0x2000000
	// The selected clock is disabled
	RCC_AHB1ENR_ETHMACEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_ETHMACEN_Enabled = 0x1
	// Position of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Pos = 0x16
	// Bit mask of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Msk = 0x400000
	// Bit DMA2EN.
	RCC_AHB1ENR_DMA2EN = 0x400000
	// The selected clock is disabled
	RCC_AHB1ENR_DMA2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_DMA2EN_Enabled = 0x1
	// Position of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Pos = 0x15
	// Bit mask of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Msk = 0x200000
	// Bit DMA1EN.
	RCC_AHB1ENR_DMA1EN = 0x200000
	// The selected clock is disabled
	RCC_AHB1ENR_DMA1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_DMA1EN_Enabled = 0x1
	// Position of BKPSRAMEN field.
	RCC_AHB1ENR_BKPSRAMEN_Pos = 0x12
	// Bit mask of BKPSRAMEN field.
	RCC_AHB1ENR_BKPSRAMEN_Msk = 0x40000
	// Bit BKPSRAMEN.
	RCC_AHB1ENR_BKPSRAMEN = 0x40000
	// The selected clock is disabled
	RCC_AHB1ENR_BKPSRAMEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_BKPSRAMEN_Enabled = 0x1
	// Position of CRCEN field.
	RCC_AHB1ENR_CRCEN_Pos = 0xc
	// Bit mask of CRCEN field.
	RCC_AHB1ENR_CRCEN_Msk = 0x1000
	// Bit CRCEN.
	RCC_AHB1ENR_CRCEN = 0x1000
	// The selected clock is disabled
	RCC_AHB1ENR_CRCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_CRCEN_Enabled = 0x1
	// Position of GPIOIEN field.
	RCC_AHB1ENR_GPIOIEN_Pos = 0x8
	// Bit mask of GPIOIEN field.
	RCC_AHB1ENR_GPIOIEN_Msk = 0x100
	// Bit GPIOIEN.
	RCC_AHB1ENR_GPIOIEN = 0x100
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOIEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOIEN_Enabled = 0x1
	// Position of GPIOHEN field.
	RCC_AHB1ENR_GPIOHEN_Pos = 0x7
	// Bit mask of GPIOHEN field.
	RCC_AHB1ENR_GPIOHEN_Msk = 0x80
	// Bit GPIOHEN.
	RCC_AHB1ENR_GPIOHEN = 0x80
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOHEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOHEN_Enabled = 0x1
	// Position of GPIOGEN field.
	RCC_AHB1ENR_GPIOGEN_Pos = 0x6
	// Bit mask of GPIOGEN field.
	RCC_AHB1ENR_GPIOGEN_Msk = 0x40
	// Bit GPIOGEN.
	RCC_AHB1ENR_GPIOGEN = 0x40
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOGEN_Enabled = 0x1
	// Position of GPIOFEN field.
	RCC_AHB1ENR_GPIOFEN_Pos = 0x5
	// Bit mask of GPIOFEN field.
	RCC_AHB1ENR_GPIOFEN_Msk = 0x20
	// Bit GPIOFEN.
	RCC_AHB1ENR_GPIOFEN = 0x20
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOFEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOFEN_Enabled = 0x1
	// Position of GPIOEEN field.
	RCC_AHB1ENR_GPIOEEN_Pos = 0x4
	// Bit mask of GPIOEEN field.
	RCC_AHB1ENR_GPIOEEN_Msk = 0x10
	// Bit GPIOEEN.
	RCC_AHB1ENR_GPIOEEN = 0x10
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOEEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOEEN_Enabled = 0x1
	// Position of GPIODEN field.
	RCC_AHB1ENR_GPIODEN_Pos = 0x3
	// Bit mask of GPIODEN field.
	RCC_AHB1ENR_GPIODEN_Msk = 0x8
	// Bit GPIODEN.
	RCC_AHB1ENR_GPIODEN = 0x8
	// The selected clock is disabled
	RCC_AHB1ENR_GPIODEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIODEN_Enabled = 0x1
	// Position of GPIOCEN field.
	RCC_AHB1ENR_GPIOCEN_Pos = 0x2
	// Bit mask of GPIOCEN field.
	RCC_AHB1ENR_GPIOCEN_Msk = 0x4
	// Bit GPIOCEN.
	RCC_AHB1ENR_GPIOCEN = 0x4
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOCEN_Enabled = 0x1
	// Position of GPIOBEN field.
	RCC_AHB1ENR_GPIOBEN_Pos = 0x1
	// Bit mask of GPIOBEN field.
	RCC_AHB1ENR_GPIOBEN_Msk = 0x2
	// Bit GPIOBEN.
	RCC_AHB1ENR_GPIOBEN = 0x2
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOBEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOBEN_Enabled = 0x1
	// Position of GPIOAEN field.
	RCC_AHB1ENR_GPIOAEN_Pos = 0x0
	// Bit mask of GPIOAEN field.
	RCC_AHB1ENR_GPIOAEN_Msk = 0x1
	// Bit GPIOAEN.
	RCC_AHB1ENR_GPIOAEN = 0x1
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOAEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOAEN_Enabled = 0x1

	// AHB2ENR: AHB2 peripheral clock enable register
	// Position of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN_Pos = 0x7
	// Bit mask of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN_Msk = 0x80
	// Bit OTGFSEN.
	RCC_AHB2ENR_OTGFSEN = 0x80
	// The selected clock is disabled
	RCC_AHB2ENR_OTGFSEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_OTGFSEN_Enabled = 0x1
	// Position of RNGEN field.
	RCC_AHB2ENR_RNGEN_Pos = 0x6
	// Bit mask of RNGEN field.
	RCC_AHB2ENR_RNGEN_Msk = 0x40
	// Bit RNGEN.
	RCC_AHB2ENR_RNGEN = 0x40
	// The selected clock is disabled
	RCC_AHB2ENR_RNGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_RNGEN_Enabled = 0x1
	// Position of HASHEN field.
	RCC_AHB2ENR_HASHEN_Pos = 0x5
	// Bit mask of HASHEN field.
	RCC_AHB2ENR_HASHEN_Msk = 0x20
	// Bit HASHEN.
	RCC_AHB2ENR_HASHEN = 0x20
	// The selected clock is disabled
	RCC_AHB2ENR_HASHEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_HASHEN_Enabled = 0x1
	// Position of CRYPEN field.
	RCC_AHB2ENR_CRYPEN_Pos = 0x4
	// Bit mask of CRYPEN field.
	RCC_AHB2ENR_CRYPEN_Msk = 0x10
	// Bit CRYPEN.
	RCC_AHB2ENR_CRYPEN = 0x10
	// The selected clock is disabled
	RCC_AHB2ENR_CRYPEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_CRYPEN_Enabled = 0x1
	// Position of DCMIEN field.
	RCC_AHB2ENR_DCMIEN_Pos = 0x0
	// Bit mask of DCMIEN field.
	RCC_AHB2ENR_DCMIEN_Msk = 0x1
	// Bit DCMIEN.
	RCC_AHB2ENR_DCMIEN = 0x1
	// The selected clock is disabled
	RCC_AHB2ENR_DCMIEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_DCMIEN_Enabled = 0x1

	// AHB3ENR: AHB3 peripheral clock enable register
	// Position of FSMCEN field.
	RCC_AHB3ENR_FSMCEN_Pos = 0x0
	// Bit mask of FSMCEN field.
	RCC_AHB3ENR_FSMCEN_Msk = 0x1
	// Bit FSMCEN.
	RCC_AHB3ENR_FSMCEN = 0x1
	// The selected clock is disabled
	RCC_AHB3ENR_FSMCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB3ENR_FSMCEN_Enabled = 0x1

	// APB1ENR: APB1 peripheral clock enable register
	// Position of DACEN field.
	RCC_APB1ENR_DACEN_Pos = 0x1d
	// Bit mask of DACEN field.
	RCC_APB1ENR_DACEN_Msk = 0x20000000
	// Bit DACEN.
	RCC_APB1ENR_DACEN = 0x20000000
	// The selected clock is disabled
	RCC_APB1ENR_DACEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_DACEN_Enabled = 0x1
	// Position of PWREN field.
	RCC_APB1ENR_PWREN_Pos = 0x1c
	// Bit mask of PWREN field.
	RCC_APB1ENR_PWREN_Msk = 0x10000000
	// Bit PWREN.
	RCC_APB1ENR_PWREN = 0x10000000
	// The selected clock is disabled
	RCC_APB1ENR_PWREN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_PWREN_Enabled = 0x1
	// Position of CAN2EN field.
	RCC_APB1ENR_CAN2EN_Pos = 0x1a
	// Bit mask of CAN2EN field.
	RCC_APB1ENR_CAN2EN_Msk = 0x4000000
	// Bit CAN2EN.
	RCC_APB1ENR_CAN2EN = 0x4000000
	// The selected clock is disabled
	RCC_APB1ENR_CAN2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_CAN2EN_Enabled = 0x1
	// Position of CAN1EN field.
	RCC_APB1ENR_CAN1EN_Pos = 0x19
	// Bit mask of CAN1EN field.
	RCC_APB1ENR_CAN1EN_Msk = 0x2000000
	// Bit CAN1EN.
	RCC_APB1ENR_CAN1EN = 0x2000000
	// The selected clock is disabled
	RCC_APB1ENR_CAN1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_CAN1EN_Enabled = 0x1
	// Position of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Pos = 0x17
	// Bit mask of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Msk = 0x800000
	// Bit I2C3EN.
	RCC_APB1ENR_I2C3EN = 0x800000
	// The selected clock is disabled
	RCC_APB1ENR_I2C3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C3EN_Enabled = 0x1
	// Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Pos = 0x16
	// Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk = 0x400000
	// Bit I2C2EN.
	RCC_APB1ENR_I2C2EN = 0x400000
	// The selected clock is disabled
	RCC_APB1ENR_I2C2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C2EN_Enabled = 0x1
	// Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Pos = 0x15
	// Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk = 0x200000
	// Bit I2C1EN.
	RCC_APB1ENR_I2C1EN = 0x200000
	// The selected clock is disabled
	RCC_APB1ENR_I2C1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C1EN_Enabled = 0x1
	// Position of UART5EN field.
	RCC_APB1ENR_UART5EN_Pos = 0x14
	// Bit mask of UART5EN field.
	RCC_APB1ENR_UART5EN_Msk = 0x100000
	// Bit UART5EN.
	RCC_APB1ENR_UART5EN = 0x100000
	// The selected clock is disabled
	RCC_APB1ENR_UART5EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_UART5EN_Enabled = 0x1
	// Position of UART4EN field.
	RCC_APB1ENR_UART4EN_Pos = 0x13
	// Bit mask of UART4EN field.
	RCC_APB1ENR_UART4EN_Msk = 0x80000
	// Bit UART4EN.
	RCC_APB1ENR_UART4EN = 0x80000
	// The selected clock is disabled
	RCC_APB1ENR_UART4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_UART4EN_Enabled = 0x1
	// Position of USART3EN field.
	RCC_APB1ENR_USART3EN_Pos = 0x12
	// Bit mask of USART3EN field.
	RCC_APB1ENR_USART3EN_Msk = 0x40000
	// Bit USART3EN.
	RCC_APB1ENR_USART3EN = 0x40000
	// The selected clock is disabled
	RCC_APB1ENR_USART3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_USART3EN_Enabled = 0x1
	// Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Pos = 0x11
	// Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk = 0x20000
	// Bit USART2EN.
	RCC_APB1ENR_USART2EN = 0x20000
	// The selected clock is disabled
	RCC_APB1ENR_USART2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_USART2EN_Enabled = 0x1
	// Position of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Pos = 0xf
	// Bit mask of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Msk = 0x8000
	// Bit SPI3EN.
	RCC_APB1ENR_SPI3EN = 0x8000
	// The selected clock is disabled
	RCC_APB1ENR_SPI3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_SPI3EN_Enabled = 0x1
	// Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Pos = 0xe
	// Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk = 0x4000
	// Bit SPI2EN.
	RCC_APB1ENR_SPI2EN = 0x4000
	// The selected clock is disabled
	RCC_APB1ENR_SPI2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_SPI2EN_Enabled = 0x1
	// Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Pos = 0xb
	// Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk = 0x800
	// Bit WWDGEN.
	RCC_APB1ENR_WWDGEN = 0x800
	// The selected clock is disabled
	RCC_APB1ENR_WWDGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_WWDGEN_Enabled = 0x1
	// Position of TIM14EN field.
	RCC_APB1ENR_TIM14EN_Pos = 0x8
	// Bit mask of TIM14EN field.
	RCC_APB1ENR_TIM14EN_Msk = 0x100
	// Bit TIM14EN.
	RCC_APB1ENR_TIM14EN = 0x100
	// The selected clock is disabled
	RCC_APB1ENR_TIM14EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM14EN_Enabled = 0x1
	// Position of TIM13EN field.
	RCC_APB1ENR_TIM13EN_Pos = 0x7
	// Bit mask of TIM13EN field.
	RCC_APB1ENR_TIM13EN_Msk = 0x80
	// Bit TIM13EN.
	RCC_APB1ENR_TIM13EN = 0x80
	// The selected clock is disabled
	RCC_APB1ENR_TIM13EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM13EN_Enabled = 0x1
	// Position of TIM12EN field.
	RCC_APB1ENR_TIM12EN_Pos = 0x6
	// Bit mask of TIM12EN field.
	RCC_APB1ENR_TIM12EN_Msk = 0x40
	// Bit TIM12EN.
	RCC_APB1ENR_TIM12EN = 0x40
	// The selected clock is disabled
	RCC_APB1ENR_TIM12EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM12EN_Enabled = 0x1
	// Position of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Pos = 0x5
	// Bit mask of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Msk = 0x20
	// Bit TIM7EN.
	RCC_APB1ENR_TIM7EN = 0x20
	// The selected clock is disabled
	RCC_APB1ENR_TIM7EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM7EN_Enabled = 0x1
	// Position of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Pos = 0x4
	// Bit mask of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Msk = 0x10
	// Bit TIM6EN.
	RCC_APB1ENR_TIM6EN = 0x10
	// The selected clock is disabled
	RCC_APB1ENR_TIM6EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM6EN_Enabled = 0x1
	// Position of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Pos = 0x3
	// Bit mask of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Msk = 0x8
	// Bit TIM5EN.
	RCC_APB1ENR_TIM5EN = 0x8
	// The selected clock is disabled
	RCC_APB1ENR_TIM5EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM5EN_Enabled = 0x1
	// Position of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Pos = 0x2
	// Bit mask of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Msk = 0x4
	// Bit TIM4EN.
	RCC_APB1ENR_TIM4EN = 0x4
	// The selected clock is disabled
	RCC_APB1ENR_TIM4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM4EN_Enabled = 0x1
	// Position of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Pos = 0x1
	// Bit mask of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Msk = 0x2
	// Bit TIM3EN.
	RCC_APB1ENR_TIM3EN = 0x2
	// The selected clock is disabled
	RCC_APB1ENR_TIM3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM3EN_Enabled = 0x1
	// Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Pos = 0x0
	// Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk = 0x1
	// Bit TIM2EN.
	RCC_APB1ENR_TIM2EN = 0x1
	// The selected clock is disabled
	RCC_APB1ENR_TIM2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM2EN_Enabled = 0x1

	// APB2ENR: APB2 peripheral clock enable register
	// Position of TIM11EN field.
	RCC_APB2ENR_TIM11EN_Pos = 0x12
	// Bit mask of TIM11EN field.
	RCC_APB2ENR_TIM11EN_Msk = 0x40000
	// Bit TIM11EN.
	RCC_APB2ENR_TIM11EN = 0x40000
	// The selected clock is disabled
	RCC_APB2ENR_TIM11EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM11EN_Enabled = 0x1
	// Position of TIM10EN field.
	RCC_APB2ENR_TIM10EN_Pos = 0x11
	// Bit mask of TIM10EN field.
	RCC_APB2ENR_TIM10EN_Msk = 0x20000
	// Bit TIM10EN.
	RCC_APB2ENR_TIM10EN = 0x20000
	// The selected clock is disabled
	RCC_APB2ENR_TIM10EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM10EN_Enabled = 0x1
	// Position of TIM9EN field.
	RCC_APB2ENR_TIM9EN_Pos = 0x10
	// Bit mask of TIM9EN field.
	RCC_APB2ENR_TIM9EN_Msk = 0x10000
	// Bit TIM9EN.
	RCC_APB2ENR_TIM9EN = 0x10000
	// The selected clock is disabled
	RCC_APB2ENR_TIM9EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM9EN_Enabled = 0x1
	// Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Pos = 0xe
	// Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x4000
	// Bit SYSCFGEN.
	RCC_APB2ENR_SYSCFGEN = 0x4000
	// The selected clock is disabled
	RCC_APB2ENR_SYSCFGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SYSCFGEN_Enabled = 0x1
	// Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Pos = 0xc
	// Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk = 0x1000
	// Bit SPI1EN.
	RCC_APB2ENR_SPI1EN = 0x1000
	// The selected clock is disabled
	RCC_APB2ENR_SPI1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SPI1EN_Enabled = 0x1
	// Position of SDIOEN field.
	RCC_APB2ENR_SDIOEN_Pos = 0xb
	// Bit mask of SDIOEN field.
	RCC_APB2ENR_SDIOEN_Msk = 0x800
	// Bit SDIOEN.
	RCC_APB2ENR_SDIOEN = 0x800
	// The selected clock is disabled
	RCC_APB2ENR_SDIOEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SDIOEN_Enabled = 0x1
	// Position of ADC3EN field.
	RCC_APB2ENR_ADC3EN_Pos = 0xa
	// Bit mask of ADC3EN field.
	RCC_APB2ENR_ADC3EN_Msk = 0x400
	// Bit ADC3EN.
	RCC_APB2ENR_ADC3EN = 0x400
	// The selected clock is disabled
	RCC_APB2ENR_ADC3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_ADC3EN_Enabled = 0x1
	// Position of ADC2EN field.
	RCC_APB2ENR_ADC2EN_Pos = 0x9
	// Bit mask of ADC2EN field.
	RCC_APB2ENR_ADC2EN_Msk = 0x200
	// Bit ADC2EN.
	RCC_APB2ENR_ADC2EN = 0x200
	// The selected clock is disabled
	RCC_APB2ENR_ADC2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_ADC2EN_Enabled = 0x1
	// Position of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Pos = 0x8
	// Bit mask of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Msk = 0x100
	// Bit ADC1EN.
	RCC_APB2ENR_ADC1EN = 0x100
	// The selected clock is disabled
	RCC_APB2ENR_ADC1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_ADC1EN_Enabled = 0x1
	// Position of USART6EN field.
	RCC_APB2ENR_USART6EN_Pos = 0x5
	// Bit mask of USART6EN field.
	RCC_APB2ENR_USART6EN_Msk = 0x20
	// Bit USART6EN.
	RCC_APB2ENR_USART6EN = 0x20
	// The selected clock is disabled
	RCC_APB2ENR_USART6EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_USART6EN_Enabled = 0x1
	// Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Pos = 0x4
	// Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x10
	// Bit USART1EN.
	RCC_APB2ENR_USART1EN = 0x10
	// The selected clock is disabled
	RCC_APB2ENR_USART1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_USART1EN_Enabled = 0x1
	// Position of TIM8EN field.
	RCC_APB2ENR_TIM8EN_Pos = 0x1
	// Bit mask of TIM8EN field.
	RCC_APB2ENR_TIM8EN_Msk = 0x2
	// Bit TIM8EN.
	RCC_APB2ENR_TIM8EN = 0x2
	// The selected clock is disabled
	RCC_APB2ENR_TIM8EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM8EN_Enabled = 0x1
	// Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Pos = 0x0
	// Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk = 0x1
	// Bit TIM1EN.
	RCC_APB2ENR_TIM1EN = 0x1
	// The selected clock is disabled
	RCC_APB2ENR_TIM1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM1EN_Enabled = 0x1

	// AHB1LPENR: AHB1 peripheral clock enable in low power mode register
	// Position of OTGHSULPILPEN field.
	RCC_AHB1LPENR_OTGHSULPILPEN_Pos = 0x1e
	// Bit mask of OTGHSULPILPEN field.
	RCC_AHB1LPENR_OTGHSULPILPEN_Msk = 0x40000000
	// Bit OTGHSULPILPEN.
	RCC_AHB1LPENR_OTGHSULPILPEN = 0x40000000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_OTGHSULPILPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_OTGHSULPILPEN_EnabledInSleep = 0x1
	// Position of OTGHSLPEN field.
	RCC_AHB1LPENR_OTGHSLPEN_Pos = 0x1d
	// Bit mask of OTGHSLPEN field.
	RCC_AHB1LPENR_OTGHSLPEN_Msk = 0x20000000
	// Bit OTGHSLPEN.
	RCC_AHB1LPENR_OTGHSLPEN = 0x20000000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_OTGHSLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_OTGHSLPEN_EnabledInSleep = 0x1
	// Position of ETHMACPTPLPEN field.
	RCC_AHB1LPENR_ETHMACPTPLPEN_Pos = 0x1c
	// Bit mask of ETHMACPTPLPEN field.
	RCC_AHB1LPENR_ETHMACPTPLPEN_Msk = 0x10000000
	// Bit ETHMACPTPLPEN.
	RCC_AHB1LPENR_ETHMACPTPLPEN = 0x10000000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_ETHMACPTPLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_ETHMACPTPLPEN_EnabledInSleep = 0x1
	// Position of ETHMACRXLPEN field.
	RCC_AHB1LPENR_ETHMACRXLPEN_Pos = 0x1b
	// Bit mask of ETHMACRXLPEN field.
	RCC_AHB1LPENR_ETHMACRXLPEN_Msk = 0x8000000
	// Bit ETHMACRXLPEN.
	RCC_AHB1LPENR_ETHMACRXLPEN = 0x8000000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_ETHMACRXLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_ETHMACRXLPEN_EnabledInSleep = 0x1
	// Position of ETHMACTXLPEN field.
	RCC_AHB1LPENR_ETHMACTXLPEN_Pos = 0x1a
	// Bit mask of ETHMACTXLPEN field.
	RCC_AHB1LPENR_ETHMACTXLPEN_Msk = 0x4000000
	// Bit ETHMACTXLPEN.
	RCC_AHB1LPENR_ETHMACTXLPEN = 0x4000000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_ETHMACTXLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_ETHMACTXLPEN_EnabledInSleep = 0x1
	// Position of ETHMACLPEN field.
	RCC_AHB1LPENR_ETHMACLPEN_Pos = 0x19
	// Bit mask of ETHMACLPEN field.
	RCC_AHB1LPENR_ETHMACLPEN_Msk = 0x2000000
	// Bit ETHMACLPEN.
	RCC_AHB1LPENR_ETHMACLPEN = 0x2000000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_ETHMACLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_ETHMACLPEN_EnabledInSleep = 0x1
	// Position of DMA2LPEN field.
	RCC_AHB1LPENR_DMA2LPEN_Pos = 0x16
	// Bit mask of DMA2LPEN field.
	RCC_AHB1LPENR_DMA2LPEN_Msk = 0x400000
	// Bit DMA2LPEN.
	RCC_AHB1LPENR_DMA2LPEN = 0x400000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_DMA2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_DMA2LPEN_EnabledInSleep = 0x1
	// Position of DMA1LPEN field.
	RCC_AHB1LPENR_DMA1LPEN_Pos = 0x15
	// Bit mask of DMA1LPEN field.
	RCC_AHB1LPENR_DMA1LPEN_Msk = 0x200000
	// Bit DMA1LPEN.
	RCC_AHB1LPENR_DMA1LPEN = 0x200000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_DMA1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_DMA1LPEN_EnabledInSleep = 0x1
	// Position of BKPSRAMLPEN field.
	RCC_AHB1LPENR_BKPSRAMLPEN_Pos = 0x12
	// Bit mask of BKPSRAMLPEN field.
	RCC_AHB1LPENR_BKPSRAMLPEN_Msk = 0x40000
	// Bit BKPSRAMLPEN.
	RCC_AHB1LPENR_BKPSRAMLPEN = 0x40000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_BKPSRAMLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_BKPSRAMLPEN_EnabledInSleep = 0x1
	// Position of SRAM2LPEN field.
	RCC_AHB1LPENR_SRAM2LPEN_Pos = 0x11
	// Bit mask of SRAM2LPEN field.
	RCC_AHB1LPENR_SRAM2LPEN_Msk = 0x20000
	// Bit SRAM2LPEN.
	RCC_AHB1LPENR_SRAM2LPEN = 0x20000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_SRAM2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_SRAM2LPEN_EnabledInSleep = 0x1
	// Position of SRAM1LPEN field.
	RCC_AHB1LPENR_SRAM1LPEN_Pos = 0x10
	// Bit mask of SRAM1LPEN field.
	RCC_AHB1LPENR_SRAM1LPEN_Msk = 0x10000
	// Bit SRAM1LPEN.
	RCC_AHB1LPENR_SRAM1LPEN = 0x10000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_SRAM1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_SRAM1LPEN_EnabledInSleep = 0x1
	// Position of FLITFLPEN field.
	RCC_AHB1LPENR_FLITFLPEN_Pos = 0xf
	// Bit mask of FLITFLPEN field.
	RCC_AHB1LPENR_FLITFLPEN_Msk = 0x8000
	// Bit FLITFLPEN.
	RCC_AHB1LPENR_FLITFLPEN = 0x8000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_FLITFLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_FLITFLPEN_EnabledInSleep = 0x1
	// Position of CRCLPEN field.
	RCC_AHB1LPENR_CRCLPEN_Pos = 0xc
	// Bit mask of CRCLPEN field.
	RCC_AHB1LPENR_CRCLPEN_Msk = 0x1000
	// Bit CRCLPEN.
	RCC_AHB1LPENR_CRCLPEN = 0x1000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_CRCLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_CRCLPEN_EnabledInSleep = 0x1
	// Position of GPIOILPEN field.
	RCC_AHB1LPENR_GPIOILPEN_Pos = 0x8
	// Bit mask of GPIOILPEN field.
	RCC_AHB1LPENR_GPIOILPEN_Msk = 0x100
	// Bit GPIOILPEN.
	RCC_AHB1LPENR_GPIOILPEN = 0x100
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOILPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOILPEN_EnabledInSleep = 0x1
	// Position of GPIOHLPEN field.
	RCC_AHB1LPENR_GPIOHLPEN_Pos = 0x7
	// Bit mask of GPIOHLPEN field.
	RCC_AHB1LPENR_GPIOHLPEN_Msk = 0x80
	// Bit GPIOHLPEN.
	RCC_AHB1LPENR_GPIOHLPEN = 0x80
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOHLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOHLPEN_EnabledInSleep = 0x1
	// Position of GPIOGLPEN field.
	RCC_AHB1LPENR_GPIOGLPEN_Pos = 0x6
	// Bit mask of GPIOGLPEN field.
	RCC_AHB1LPENR_GPIOGLPEN_Msk = 0x40
	// Bit GPIOGLPEN.
	RCC_AHB1LPENR_GPIOGLPEN = 0x40
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOGLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOGLPEN_EnabledInSleep = 0x1
	// Position of GPIOFLPEN field.
	RCC_AHB1LPENR_GPIOFLPEN_Pos = 0x5
	// Bit mask of GPIOFLPEN field.
	RCC_AHB1LPENR_GPIOFLPEN_Msk = 0x20
	// Bit GPIOFLPEN.
	RCC_AHB1LPENR_GPIOFLPEN = 0x20
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOFLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOFLPEN_EnabledInSleep = 0x1
	// Position of GPIOELPEN field.
	RCC_AHB1LPENR_GPIOELPEN_Pos = 0x4
	// Bit mask of GPIOELPEN field.
	RCC_AHB1LPENR_GPIOELPEN_Msk = 0x10
	// Bit GPIOELPEN.
	RCC_AHB1LPENR_GPIOELPEN = 0x10
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOELPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOELPEN_EnabledInSleep = 0x1
	// Position of GPIODLPEN field.
	RCC_AHB1LPENR_GPIODLPEN_Pos = 0x3
	// Bit mask of GPIODLPEN field.
	RCC_AHB1LPENR_GPIODLPEN_Msk = 0x8
	// Bit GPIODLPEN.
	RCC_AHB1LPENR_GPIODLPEN = 0x8
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIODLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIODLPEN_EnabledInSleep = 0x1
	// Position of GPIOCLPEN field.
	RCC_AHB1LPENR_GPIOCLPEN_Pos = 0x2
	// Bit mask of GPIOCLPEN field.
	RCC_AHB1LPENR_GPIOCLPEN_Msk = 0x4
	// Bit GPIOCLPEN.
	RCC_AHB1LPENR_GPIOCLPEN = 0x4
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOCLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOCLPEN_EnabledInSleep = 0x1
	// Position of GPIOBLPEN field.
	RCC_AHB1LPENR_GPIOBLPEN_Pos = 0x1
	// Bit mask of GPIOBLPEN field.
	RCC_AHB1LPENR_GPIOBLPEN_Msk = 0x2
	// Bit GPIOBLPEN.
	RCC_AHB1LPENR_GPIOBLPEN = 0x2
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOBLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOBLPEN_EnabledInSleep = 0x1
	// Position of GPIOALPEN field.
	RCC_AHB1LPENR_GPIOALPEN_Pos = 0x0
	// Bit mask of GPIOALPEN field.
	RCC_AHB1LPENR_GPIOALPEN_Msk = 0x1
	// Bit GPIOALPEN.
	RCC_AHB1LPENR_GPIOALPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOALPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOALPEN_EnabledInSleep = 0x1

	// AHB2LPENR: AHB2 peripheral clock enable in low power mode register
	// Position of OTGFSLPEN field.
	RCC_AHB2LPENR_OTGFSLPEN_Pos = 0x7
	// Bit mask of OTGFSLPEN field.
	RCC_AHB2LPENR_OTGFSLPEN_Msk = 0x80
	// Bit OTGFSLPEN.
	RCC_AHB2LPENR_OTGFSLPEN = 0x80
	// Selected module is disabled during Sleep mode
	RCC_AHB2LPENR_OTGFSLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB2LPENR_OTGFSLPEN_EnabledInSleep = 0x1
	// Position of RNGLPEN field.
	RCC_AHB2LPENR_RNGLPEN_Pos = 0x6
	// Bit mask of RNGLPEN field.
	RCC_AHB2LPENR_RNGLPEN_Msk = 0x40
	// Bit RNGLPEN.
	RCC_AHB2LPENR_RNGLPEN = 0x40
	// Selected module is disabled during Sleep mode
	RCC_AHB2LPENR_RNGLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB2LPENR_RNGLPEN_EnabledInSleep = 0x1
	// Position of HASHLPEN field.
	RCC_AHB2LPENR_HASHLPEN_Pos = 0x5
	// Bit mask of HASHLPEN field.
	RCC_AHB2LPENR_HASHLPEN_Msk = 0x20
	// Bit HASHLPEN.
	RCC_AHB2LPENR_HASHLPEN = 0x20
	// Selected module is disabled during Sleep mode
	RCC_AHB2LPENR_HASHLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB2LPENR_HASHLPEN_EnabledInSleep = 0x1
	// Position of CRYPLPEN field.
	RCC_AHB2LPENR_CRYPLPEN_Pos = 0x4
	// Bit mask of CRYPLPEN field.
	RCC_AHB2LPENR_CRYPLPEN_Msk = 0x10
	// Bit CRYPLPEN.
	RCC_AHB2LPENR_CRYPLPEN = 0x10
	// Selected module is disabled during Sleep mode
	RCC_AHB2LPENR_CRYPLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB2LPENR_CRYPLPEN_EnabledInSleep = 0x1
	// Position of DCMILPEN field.
	RCC_AHB2LPENR_DCMILPEN_Pos = 0x0
	// Bit mask of DCMILPEN field.
	RCC_AHB2LPENR_DCMILPEN_Msk = 0x1
	// Bit DCMILPEN.
	RCC_AHB2LPENR_DCMILPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_AHB2LPENR_DCMILPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB2LPENR_DCMILPEN_EnabledInSleep = 0x1

	// AHB3LPENR: AHB3 peripheral clock enable in low power mode register
	// Position of FSMCLPEN field.
	RCC_AHB3LPENR_FSMCLPEN_Pos = 0x0
	// Bit mask of FSMCLPEN field.
	RCC_AHB3LPENR_FSMCLPEN_Msk = 0x1
	// Bit FSMCLPEN.
	RCC_AHB3LPENR_FSMCLPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_AHB3LPENR_FSMCLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB3LPENR_FSMCLPEN_EnabledInSleep = 0x1

	// APB1LPENR: APB1 peripheral clock enable in low power mode register
	// Position of DACLPEN field.
	RCC_APB1LPENR_DACLPEN_Pos = 0x1d
	// Bit mask of DACLPEN field.
	RCC_APB1LPENR_DACLPEN_Msk = 0x20000000
	// Bit DACLPEN.
	RCC_APB1LPENR_DACLPEN = 0x20000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_DACLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_DACLPEN_EnabledInSleep = 0x1
	// Position of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN_Pos = 0x1c
	// Bit mask of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN_Msk = 0x10000000
	// Bit PWRLPEN.
	RCC_APB1LPENR_PWRLPEN = 0x10000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_PWRLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_PWRLPEN_EnabledInSleep = 0x1
	// Position of CAN2LPEN field.
	RCC_APB1LPENR_CAN2LPEN_Pos = 0x1a
	// Bit mask of CAN2LPEN field.
	RCC_APB1LPENR_CAN2LPEN_Msk = 0x4000000
	// Bit CAN2LPEN.
	RCC_APB1LPENR_CAN2LPEN = 0x4000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_CAN2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_CAN2LPEN_EnabledInSleep = 0x1
	// Position of CAN1LPEN field.
	RCC_APB1LPENR_CAN1LPEN_Pos = 0x19
	// Bit mask of CAN1LPEN field.
	RCC_APB1LPENR_CAN1LPEN_Msk = 0x2000000
	// Bit CAN1LPEN.
	RCC_APB1LPENR_CAN1LPEN = 0x2000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_CAN1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_CAN1LPEN_EnabledInSleep = 0x1
	// Position of I2C3LPEN field.
	RCC_APB1LPENR_I2C3LPEN_Pos = 0x17
	// Bit mask of I2C3LPEN field.
	RCC_APB1LPENR_I2C3LPEN_Msk = 0x800000
	// Bit I2C3LPEN.
	RCC_APB1LPENR_I2C3LPEN = 0x800000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_I2C3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_I2C3LPEN_EnabledInSleep = 0x1
	// Position of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN_Pos = 0x16
	// Bit mask of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN_Msk = 0x400000
	// Bit I2C2LPEN.
	RCC_APB1LPENR_I2C2LPEN = 0x400000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_I2C2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_I2C2LPEN_EnabledInSleep = 0x1
	// Position of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN_Pos = 0x15
	// Bit mask of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN_Msk = 0x200000
	// Bit I2C1LPEN.
	RCC_APB1LPENR_I2C1LPEN = 0x200000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_I2C1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_I2C1LPEN_EnabledInSleep = 0x1
	// Position of UART5LPEN field.
	RCC_APB1LPENR_UART5LPEN_Pos = 0x14
	// Bit mask of UART5LPEN field.
	RCC_APB1LPENR_UART5LPEN_Msk = 0x100000
	// Bit UART5LPEN.
	RCC_APB1LPENR_UART5LPEN = 0x100000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_UART5LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_UART5LPEN_EnabledInSleep = 0x1
	// Position of UART4LPEN field.
	RCC_APB1LPENR_UART4LPEN_Pos = 0x13
	// Bit mask of UART4LPEN field.
	RCC_APB1LPENR_UART4LPEN_Msk = 0x80000
	// Bit UART4LPEN.
	RCC_APB1LPENR_UART4LPEN = 0x80000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_UART4LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_UART4LPEN_EnabledInSleep = 0x1
	// Position of USART3LPEN field.
	RCC_APB1LPENR_USART3LPEN_Pos = 0x12
	// Bit mask of USART3LPEN field.
	RCC_APB1LPENR_USART3LPEN_Msk = 0x40000
	// Bit USART3LPEN.
	RCC_APB1LPENR_USART3LPEN = 0x40000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_USART3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_USART3LPEN_EnabledInSleep = 0x1
	// Position of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN_Pos = 0x11
	// Bit mask of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN_Msk = 0x20000
	// Bit USART2LPEN.
	RCC_APB1LPENR_USART2LPEN = 0x20000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_USART2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_USART2LPEN_EnabledInSleep = 0x1
	// Position of SPI3LPEN field.
	RCC_APB1LPENR_SPI3LPEN_Pos = 0xf
	// Bit mask of SPI3LPEN field.
	RCC_APB1LPENR_SPI3LPEN_Msk = 0x8000
	// Bit SPI3LPEN.
	RCC_APB1LPENR_SPI3LPEN = 0x8000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_SPI3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_SPI3LPEN_EnabledInSleep = 0x1
	// Position of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN_Pos = 0xe
	// Bit mask of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN_Msk = 0x4000
	// Bit SPI2LPEN.
	RCC_APB1LPENR_SPI2LPEN = 0x4000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_SPI2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_SPI2LPEN_EnabledInSleep = 0x1
	// Position of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN_Pos = 0xb
	// Bit mask of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN_Msk = 0x800
	// Bit WWDGLPEN.
	RCC_APB1LPENR_WWDGLPEN = 0x800
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_WWDGLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_WWDGLPEN_EnabledInSleep = 0x1
	// Position of TIM14LPEN field.
	RCC_APB1LPENR_TIM14LPEN_Pos = 0x8
	// Bit mask of TIM14LPEN field.
	RCC_APB1LPENR_TIM14LPEN_Msk = 0x100
	// Bit TIM14LPEN.
	RCC_APB1LPENR_TIM14LPEN = 0x100
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM14LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM14LPEN_EnabledInSleep = 0x1
	// Position of TIM13LPEN field.
	RCC_APB1LPENR_TIM13LPEN_Pos = 0x7
	// Bit mask of TIM13LPEN field.
	RCC_APB1LPENR_TIM13LPEN_Msk = 0x80
	// Bit TIM13LPEN.
	RCC_APB1LPENR_TIM13LPEN = 0x80
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM13LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM13LPEN_EnabledInSleep = 0x1
	// Position of TIM12LPEN field.
	RCC_APB1LPENR_TIM12LPEN_Pos = 0x6
	// Bit mask of TIM12LPEN field.
	RCC_APB1LPENR_TIM12LPEN_Msk = 0x40
	// Bit TIM12LPEN.
	RCC_APB1LPENR_TIM12LPEN = 0x40
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM12LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM12LPEN_EnabledInSleep = 0x1
	// Position of TIM7LPEN field.
	RCC_APB1LPENR_TIM7LPEN_Pos = 0x5
	// Bit mask of TIM7LPEN field.
	RCC_APB1LPENR_TIM7LPEN_Msk = 0x20
	// Bit TIM7LPEN.
	RCC_APB1LPENR_TIM7LPEN = 0x20
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM7LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM7LPEN_EnabledInSleep = 0x1
	// Position of TIM6LPEN field.
	RCC_APB1LPENR_TIM6LPEN_Pos = 0x4
	// Bit mask of TIM6LPEN field.
	RCC_APB1LPENR_TIM6LPEN_Msk = 0x10
	// Bit TIM6LPEN.
	RCC_APB1LPENR_TIM6LPEN = 0x10
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM6LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM6LPEN_EnabledInSleep = 0x1
	// Position of TIM5LPEN field.
	RCC_APB1LPENR_TIM5LPEN_Pos = 0x3
	// Bit mask of TIM5LPEN field.
	RCC_APB1LPENR_TIM5LPEN_Msk = 0x8
	// Bit TIM5LPEN.
	RCC_APB1LPENR_TIM5LPEN = 0x8
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM5LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM5LPEN_EnabledInSleep = 0x1
	// Position of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN_Pos = 0x2
	// Bit mask of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN_Msk = 0x4
	// Bit TIM4LPEN.
	RCC_APB1LPENR_TIM4LPEN = 0x4
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM4LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM4LPEN_EnabledInSleep = 0x1
	// Position of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN_Pos = 0x1
	// Bit mask of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN_Msk = 0x2
	// Bit TIM3LPEN.
	RCC_APB1LPENR_TIM3LPEN = 0x2
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM3LPEN_EnabledInSleep = 0x1
	// Position of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN_Pos = 0x0
	// Bit mask of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN_Msk = 0x1
	// Bit TIM2LPEN.
	RCC_APB1LPENR_TIM2LPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM2LPEN_EnabledInSleep = 0x1

	// APB2LPENR: APB2 peripheral clock enabled in low power mode register
	// Position of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN_Pos = 0x12
	// Bit mask of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN_Msk = 0x40000
	// Bit TIM11LPEN.
	RCC_APB2LPENR_TIM11LPEN = 0x40000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM11LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM11LPEN_EnabledInSleep = 0x1
	// Position of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN_Pos = 0x11
	// Bit mask of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN_Msk = 0x20000
	// Bit TIM10LPEN.
	RCC_APB2LPENR_TIM10LPEN = 0x20000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM10LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM10LPEN_EnabledInSleep = 0x1
	// Position of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN_Pos = 0x10
	// Bit mask of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN_Msk = 0x10000
	// Bit TIM9LPEN.
	RCC_APB2LPENR_TIM9LPEN = 0x10000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM9LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM9LPEN_EnabledInSleep = 0x1
	// Position of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN_Pos = 0xe
	// Bit mask of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN_Msk = 0x4000
	// Bit SYSCFGLPEN.
	RCC_APB2LPENR_SYSCFGLPEN = 0x4000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SYSCFGLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SYSCFGLPEN_EnabledInSleep = 0x1
	// Position of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN_Pos = 0xc
	// Bit mask of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN_Msk = 0x1000
	// Bit SPI1LPEN.
	RCC_APB2LPENR_SPI1LPEN = 0x1000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SPI1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SPI1LPEN_EnabledInSleep = 0x1
	// Position of SDIOLPEN field.
	RCC_APB2LPENR_SDIOLPEN_Pos = 0xb
	// Bit mask of SDIOLPEN field.
	RCC_APB2LPENR_SDIOLPEN_Msk = 0x800
	// Bit SDIOLPEN.
	RCC_APB2LPENR_SDIOLPEN = 0x800
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SDIOLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SDIOLPEN_EnabledInSleep = 0x1
	// Position of ADC3LPEN field.
	RCC_APB2LPENR_ADC3LPEN_Pos = 0xa
	// Bit mask of ADC3LPEN field.
	RCC_APB2LPENR_ADC3LPEN_Msk = 0x400
	// Bit ADC3LPEN.
	RCC_APB2LPENR_ADC3LPEN = 0x400
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_ADC3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_ADC3LPEN_EnabledInSleep = 0x1
	// Position of ADC2LPEN field.
	RCC_APB2LPENR_ADC2LPEN_Pos = 0x9
	// Bit mask of ADC2LPEN field.
	RCC_APB2LPENR_ADC2LPEN_Msk = 0x200
	// Bit ADC2LPEN.
	RCC_APB2LPENR_ADC2LPEN = 0x200
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_ADC2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_ADC2LPEN_EnabledInSleep = 0x1
	// Position of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN_Pos = 0x8
	// Bit mask of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN_Msk = 0x100
	// Bit ADC1LPEN.
	RCC_APB2LPENR_ADC1LPEN = 0x100
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_ADC1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_ADC1LPEN_EnabledInSleep = 0x1
	// Position of USART6LPEN field.
	RCC_APB2LPENR_USART6LPEN_Pos = 0x5
	// Bit mask of USART6LPEN field.
	RCC_APB2LPENR_USART6LPEN_Msk = 0x20
	// Bit USART6LPEN.
	RCC_APB2LPENR_USART6LPEN = 0x20
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_USART6LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_USART6LPEN_EnabledInSleep = 0x1
	// Position of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN_Pos = 0x4
	// Bit mask of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN_Msk = 0x10
	// Bit USART1LPEN.
	RCC_APB2LPENR_USART1LPEN = 0x10
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_USART1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_USART1LPEN_EnabledInSleep = 0x1
	// Position of TIM8LPEN field.
	RCC_APB2LPENR_TIM8LPEN_Pos = 0x1
	// Bit mask of TIM8LPEN field.
	RCC_APB2LPENR_TIM8LPEN_Msk = 0x2
	// Bit TIM8LPEN.
	RCC_APB2LPENR_TIM8LPEN = 0x2
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM8LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM8LPEN_EnabledInSleep = 0x1
	// Position of TIM1LPEN field.
	RCC_APB2LPENR_TIM1LPEN_Pos = 0x0
	// Bit mask of TIM1LPEN field.
	RCC_APB2LPENR_TIM1LPEN_Msk = 0x1
	// Bit TIM1LPEN.
	RCC_APB2LPENR_TIM1LPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM1LPEN_EnabledInSleep = 0x1

	// BDCR: Backup domain control register
	// Position of BDRST field.
	RCC_BDCR_BDRST_Pos = 0x10
	// Bit mask of BDRST field.
	RCC_BDCR_BDRST_Msk = 0x10000
	// Bit BDRST.
	RCC_BDCR_BDRST = 0x10000
	// Reset not activated
	RCC_BDCR_BDRST_Disabled = 0x0
	// Reset the entire RTC domain
	RCC_BDCR_BDRST_Enabled = 0x1
	// Position of RTCEN field.
	RCC_BDCR_RTCEN_Pos = 0xf
	// Bit mask of RTCEN field.
	RCC_BDCR_RTCEN_Msk = 0x8000
	// Bit RTCEN.
	RCC_BDCR_RTCEN = 0x8000
	// RTC clock disabled
	RCC_BDCR_RTCEN_Disabled = 0x0
	// RTC clock enabled
	RCC_BDCR_RTCEN_Enabled = 0x1
	// Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Pos = 0x2
	// Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk = 0x4
	// Bit LSEBYP.
	RCC_BDCR_LSEBYP = 0x4
	// LSE crystal oscillator not bypassed
	RCC_BDCR_LSEBYP_NotBypassed = 0x0
	// LSE crystal oscillator bypassed with external clock
	RCC_BDCR_LSEBYP_Bypassed = 0x1
	// Position of LSERDY field.
	RCC_BDCR_LSERDY_Pos = 0x1
	// Bit mask of LSERDY field.
	RCC_BDCR_LSERDY_Msk = 0x2
	// Bit LSERDY.
	RCC_BDCR_LSERDY = 0x2
	// LSE oscillator not ready
	RCC_BDCR_LSERDY_NotReady = 0x0
	// LSE oscillator ready
	RCC_BDCR_LSERDY_Ready = 0x1
	// Position of LSEON field.
	RCC_BDCR_LSEON_Pos = 0x0
	// Bit mask of LSEON field.
	RCC_BDCR_LSEON_Msk = 0x1
	// Bit LSEON.
	RCC_BDCR_LSEON = 0x1
	// LSE oscillator Off
	RCC_BDCR_LSEON_Off = 0x0
	// LSE oscillator On
	RCC_BDCR_LSEON_On = 0x1
	// Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Pos = 0x8
	// Bit mask of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk = 0x300
	// No clock
	RCC_BDCR_RTCSEL_NoClock = 0x0
	// LSE oscillator clock used as RTC clock
	RCC_BDCR_RTCSEL_LSE = 0x1
	// LSI oscillator clock used as RTC clock
	RCC_BDCR_RTCSEL_LSI = 0x2
	// HSE oscillator clock divided by a prescaler used as RTC clock
	RCC_BDCR_RTCSEL_HSE = 0x3

	// CSR: clock control & status register
	// Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Pos = 0x1f
	// Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000
	// Bit LPWRRSTF.
	RCC_CSR_LPWRRSTF = 0x80000000
	// No reset has occured
	RCC_CSR_LPWRRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_LPWRRSTF_Reset = 0x1
	// Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Pos = 0x1e
	// Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000
	// Bit WWDGRSTF.
	RCC_CSR_WWDGRSTF = 0x40000000
	// No reset has occured
	RCC_CSR_WWDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_WWDGRSTF_Reset = 0x1
	// Position of WDGRSTF field.
	RCC_CSR_WDGRSTF_Pos = 0x1d
	// Bit mask of WDGRSTF field.
	RCC_CSR_WDGRSTF_Msk = 0x20000000
	// Bit WDGRSTF.
	RCC_CSR_WDGRSTF = 0x20000000
	// No reset has occured
	RCC_CSR_WDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_WDGRSTF_Reset = 0x1
	// Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Pos = 0x1c
	// Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk = 0x10000000
	// Bit SFTRSTF.
	RCC_CSR_SFTRSTF = 0x10000000
	// No reset has occured
	RCC_CSR_SFTRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_SFTRSTF_Reset = 0x1
	// Position of PORRSTF field.
	RCC_CSR_PORRSTF_Pos = 0x1b
	// Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF_Msk = 0x8000000
	// Bit PORRSTF.
	RCC_CSR_PORRSTF = 0x8000000
	// No reset has occured
	RCC_CSR_PORRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PORRSTF_Reset = 0x1
	// Position of PADRSTF field.
	RCC_CSR_PADRSTF_Pos = 0x1a
	// Bit mask of PADRSTF field.
	RCC_CSR_PADRSTF_Msk = 0x4000000
	// Bit PADRSTF.
	RCC_CSR_PADRSTF = 0x4000000
	// No reset has occured
	RCC_CSR_PADRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PADRSTF_Reset = 0x1
	// Position of BORRSTF field.
	RCC_CSR_BORRSTF_Pos = 0x19
	// Bit mask of BORRSTF field.
	RCC_CSR_BORRSTF_Msk = 0x2000000
	// Bit BORRSTF.
	RCC_CSR_BORRSTF = 0x2000000
	// No reset has occured
	RCC_CSR_BORRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_BORRSTF_Reset = 0x1
	// Position of RMVF field.
	RCC_CSR_RMVF_Pos = 0x18
	// Bit mask of RMVF field.
	RCC_CSR_RMVF_Msk = 0x1000000
	// Bit RMVF.
	RCC_CSR_RMVF = 0x1000000
	// Clears the reset flag
	RCC_CSR_RMVF_Clear = 0x1
	// Position of LSIRDY field.
	RCC_CSR_LSIRDY_Pos = 0x1
	// Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY_Msk = 0x2
	// Bit LSIRDY.
	RCC_CSR_LSIRDY = 0x2
	// LSI oscillator not ready
	RCC_CSR_LSIRDY_NotReady = 0x0
	// LSI oscillator ready
	RCC_CSR_LSIRDY_Ready = 0x1
	// Position of LSION field.
	RCC_CSR_LSION_Pos = 0x0
	// Bit mask of LSION field.
	RCC_CSR_LSION_Msk = 0x1
	// Bit LSION.
	RCC_CSR_LSION = 0x1
	// LSI oscillator Off
	RCC_CSR_LSION_Off = 0x0
	// LSI oscillator On
	RCC_CSR_LSION_On = 0x1

	// SSCGR: spread spectrum clock generation register
	// Position of SSCGEN field.
	RCC_SSCGR_SSCGEN_Pos = 0x1f
	// Bit mask of SSCGEN field.
	RCC_SSCGR_SSCGEN_Msk = 0x80000000
	// Bit SSCGEN.
	RCC_SSCGR_SSCGEN = 0x80000000
	// Spread spectrum modulation disabled
	RCC_SSCGR_SSCGEN_Disabled = 0x0
	// Spread spectrum modulation enabled
	RCC_SSCGR_SSCGEN_Enabled = 0x1
	// Position of SPREADSEL field.
	RCC_SSCGR_SPREADSEL_Pos = 0x1e
	// Bit mask of SPREADSEL field.
	RCC_SSCGR_SPREADSEL_Msk = 0x40000000
	// Bit SPREADSEL.
	RCC_SSCGR_SPREADSEL = 0x40000000
	// Center spread
	RCC_SSCGR_SPREADSEL_Center = 0x0
	// Down spread
	RCC_SSCGR_SPREADSEL_Down = 0x1
	// Position of INCSTEP field.
	RCC_SSCGR_INCSTEP_Pos = 0xd
	// Bit mask of INCSTEP field.
	RCC_SSCGR_INCSTEP_Msk = 0xfffe000
	// Position of MODPER field.
	RCC_SSCGR_MODPER_Pos = 0x0
	// Bit mask of MODPER field.
	RCC_SSCGR_MODPER_Msk = 0x1fff

	// PLLI2SCFGR: PLLI2S configuration register
	// Position of PLLI2SR field.
	RCC_PLLI2SCFGR_PLLI2SR_Pos = 0x1c
	// Bit mask of PLLI2SR field.
	RCC_PLLI2SCFGR_PLLI2SR_Msk = 0x70000000
	// Position of PLLI2SN field.
	RCC_PLLI2SCFGR_PLLI2SN_Pos = 0x6
	// Bit mask of PLLI2SN field.
	RCC_PLLI2SCFGR_PLLI2SN_Msk = 0x7fc0
)

// Constants for GPIOI: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	// Position of MODER15 field.
	GPIO_MODER_MODER15_Pos = 0x1e
	// Bit mask of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000
	// Input mode (reset state)
	GPIO_MODER_MODER15_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER15_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER15_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER15_Analog = 0x3
	// Position of MODER14 field.
	GPIO_MODER_MODER14_Pos = 0x1c
	// Bit mask of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000
	// Input mode (reset state)
	GPIO_MODER_MODER14_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER14_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER14_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER14_Analog = 0x3
	// Position of MODER13 field.
	GPIO_MODER_MODER13_Pos = 0x1a
	// Bit mask of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000
	// Input mode (reset state)
	GPIO_MODER_MODER13_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER13_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER13_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER13_Analog = 0x3
	// Position of MODER12 field.
	GPIO_MODER_MODER12_Pos = 0x18
	// Bit mask of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000
	// Input mode (reset state)
	GPIO_MODER_MODER12_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER12_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER12_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER12_Analog = 0x3
	// Position of MODER11 field.
	GPIO_MODER_MODER11_Pos = 0x16
	// Bit mask of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000
	// Input mode (reset state)
	GPIO_MODER_MODER11_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER11_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER11_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER11_Analog = 0x3
	// Position of MODER10 field.
	GPIO_MODER_MODER10_Pos = 0x14
	// Bit mask of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000
	// Input mode (reset state)
	GPIO_MODER_MODER10_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER10_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER10_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER10_Analog = 0x3
	// Position of MODER9 field.
	GPIO_MODER_MODER9_Pos = 0x12
	// Bit mask of MODER9 field.
	GPIO_MODER_MODER9_Msk = 0xc0000
	// Input mode (reset state)
	GPIO_MODER_MODER9_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER9_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER9_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER9_Analog = 0x3
	// Position of MODER8 field.
	GPIO_MODER_MODER8_Pos = 0x10
	// Bit mask of MODER8 field.
	GPIO_MODER_MODER8_Msk = 0x30000
	// Input mode (reset state)
	GPIO_MODER_MODER8_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER8_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER8_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER8_Analog = 0x3
	// Position of MODER7 field.
	GPIO_MODER_MODER7_Pos = 0xe
	// Bit mask of MODER7 field.
	GPIO_MODER_MODER7_Msk = 0xc000
	// Input mode (reset state)
	GPIO_MODER_MODER7_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER7_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER7_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER7_Analog = 0x3
	// Position of MODER6 field.
	GPIO_MODER_MODER6_Pos = 0xc
	// Bit mask of MODER6 field.
	GPIO_MODER_MODER6_Msk = 0x3000
	// Input mode (reset state)
	GPIO_MODER_MODER6_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER6_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER6_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER6_Analog = 0x3
	// Position of MODER5 field.
	GPIO_MODER_MODER5_Pos = 0xa
	// Bit mask of MODER5 field.
	GPIO_MODER_MODER5_Msk = 0xc00
	// Input mode (reset state)
	GPIO_MODER_MODER5_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER5_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER5_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER5_Analog = 0x3
	// Position of MODER4 field.
	GPIO_MODER_MODER4_Pos = 0x8
	// Bit mask of MODER4 field.
	GPIO_MODER_MODER4_Msk = 0x300
	// Input mode (reset state)
	GPIO_MODER_MODER4_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER4_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER4_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER4_Analog = 0x3
	// Position of MODER3 field.
	GPIO_MODER_MODER3_Pos = 0x6
	// Bit mask of MODER3 field.
	GPIO_MODER_MODER3_Msk = 0xc0
	// Input mode (reset state)
	GPIO_MODER_MODER3_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER3_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER3_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER3_Analog = 0x3
	// Position of MODER2 field.
	GPIO_MODER_MODER2_Pos = 0x4
	// Bit mask of MODER2 field.
	GPIO_MODER_MODER2_Msk = 0x30
	// Input mode (reset state)
	GPIO_MODER_MODER2_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER2_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER2_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER2_Analog = 0x3
	// Position of MODER1 field.
	GPIO_MODER_MODER1_Pos = 0x2
	// Bit mask of MODER1 field.
	GPIO_MODER_MODER1_Msk = 0xc
	// Input mode (reset state)
	GPIO_MODER_MODER1_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER1_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER1_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER1_Analog = 0x3
	// Position of MODER0 field.
	GPIO_MODER_MODER0_Pos = 0x0
	// Bit mask of MODER0 field.
	GPIO_MODER_MODER0_Msk = 0x3
	// Input mode (reset state)
	GPIO_MODER_MODER0_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER0_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER0_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER0_Analog = 0x3

	// OTYPER: GPIO port output type register
	// Position of OT15 field.
	GPIO_OTYPER_OT15_Pos = 0xf
	// Bit mask of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000
	// Bit OT15.
	GPIO_OTYPER_OT15 = 0x8000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT15_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT15_OpenDrain = 0x1
	// Position of OT14 field.
	GPIO_OTYPER_OT14_Pos = 0xe
	// Bit mask of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000
	// Bit OT14.
	GPIO_OTYPER_OT14 = 0x4000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT14_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT14_OpenDrain = 0x1
	// Position of OT13 field.
	GPIO_OTYPER_OT13_Pos = 0xd
	// Bit mask of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000
	// Bit OT13.
	GPIO_OTYPER_OT13 = 0x2000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT13_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT13_OpenDrain = 0x1
	// Position of OT12 field.
	GPIO_OTYPER_OT12_Pos = 0xc
	// Bit mask of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000
	// Bit OT12.
	GPIO_OTYPER_OT12 = 0x1000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT12_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT12_OpenDrain = 0x1
	// Position of OT11 field.
	GPIO_OTYPER_OT11_Pos = 0xb
	// Bit mask of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800
	// Bit OT11.
	GPIO_OTYPER_OT11 = 0x800
	// Output push-pull (reset state)
	GPIO_OTYPER_OT11_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT11_OpenDrain = 0x1
	// Position of OT10 field.
	GPIO_OTYPER_OT10_Pos = 0xa
	// Bit mask of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400
	// Bit OT10.
	GPIO_OTYPER_OT10 = 0x400
	// Output push-pull (reset state)
	GPIO_OTYPER_OT10_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT10_OpenDrain = 0x1
	// Position of OT9 field.
	GPIO_OTYPER_OT9_Pos = 0x9
	// Bit mask of OT9 field.
	GPIO_OTYPER_OT9_Msk = 0x200
	// Bit OT9.
	GPIO_OTYPER_OT9 = 0x200
	// Output push-pull (reset state)
	GPIO_OTYPER_OT9_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT9_OpenDrain = 0x1
	// Position of OT8 field.
	GPIO_OTYPER_OT8_Pos = 0x8
	// Bit mask of OT8 field.
	GPIO_OTYPER_OT8_Msk = 0x100
	// Bit OT8.
	GPIO_OTYPER_OT8 = 0x100
	// Output push-pull (reset state)
	GPIO_OTYPER_OT8_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT8_OpenDrain = 0x1
	// Position of OT7 field.
	GPIO_OTYPER_OT7_Pos = 0x7
	// Bit mask of OT7 field.
	GPIO_OTYPER_OT7_Msk = 0x80
	// Bit OT7.
	GPIO_OTYPER_OT7 = 0x80
	// Output push-pull (reset state)
	GPIO_OTYPER_OT7_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT7_OpenDrain = 0x1
	// Position of OT6 field.
	GPIO_OTYPER_OT6_Pos = 0x6
	// Bit mask of OT6 field.
	GPIO_OTYPER_OT6_Msk = 0x40
	// Bit OT6.
	GPIO_OTYPER_OT6 = 0x40
	// Output push-pull (reset state)
	GPIO_OTYPER_OT6_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT6_OpenDrain = 0x1
	// Position of OT5 field.
	GPIO_OTYPER_OT5_Pos = 0x5
	// Bit mask of OT5 field.
	GPIO_OTYPER_OT5_Msk = 0x20
	// Bit OT5.
	GPIO_OTYPER_OT5 = 0x20
	// Output push-pull (reset state)
	GPIO_OTYPER_OT5_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT5_OpenDrain = 0x1
	// Position of OT4 field.
	GPIO_OTYPER_OT4_Pos = 0x4
	// Bit mask of OT4 field.
	GPIO_OTYPER_OT4_Msk = 0x10
	// Bit OT4.
	GPIO_OTYPER_OT4 = 0x10
	// Output push-pull (reset state)
	GPIO_OTYPER_OT4_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT4_OpenDrain = 0x1
	// Position of OT3 field.
	GPIO_OTYPER_OT3_Pos = 0x3
	// Bit mask of OT3 field.
	GPIO_OTYPER_OT3_Msk = 0x8
	// Bit OT3.
	GPIO_OTYPER_OT3 = 0x8
	// Output push-pull (reset state)
	GPIO_OTYPER_OT3_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT3_OpenDrain = 0x1
	// Position of OT2 field.
	GPIO_OTYPER_OT2_Pos = 0x2
	// Bit mask of OT2 field.
	GPIO_OTYPER_OT2_Msk = 0x4
	// Bit OT2.
	GPIO_OTYPER_OT2 = 0x4
	// Output push-pull (reset state)
	GPIO_OTYPER_OT2_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT2_OpenDrain = 0x1
	// Position of OT1 field.
	GPIO_OTYPER_OT1_Pos = 0x1
	// Bit mask of OT1 field.
	GPIO_OTYPER_OT1_Msk = 0x2
	// Bit OT1.
	GPIO_OTYPER_OT1 = 0x2
	// Output push-pull (reset state)
	GPIO_OTYPER_OT1_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT1_OpenDrain = 0x1
	// Position of OT0 field.
	GPIO_OTYPER_OT0_Pos = 0x0
	// Bit mask of OT0 field.
	GPIO_OTYPER_OT0_Msk = 0x1
	// Bit OT0.
	GPIO_OTYPER_OT0 = 0x1
	// Output push-pull (reset state)
	GPIO_OTYPER_OT0_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT0_OpenDrain = 0x1

	// OSPEEDR: GPIO port output speed register
	// Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e
	// Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR15_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR15_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR15_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR15_VeryHighSpeed = 0x3
	// Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c
	// Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR14_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR14_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR14_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR14_VeryHighSpeed = 0x3
	// Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a
	// Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR13_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR13_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR13_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR13_VeryHighSpeed = 0x3
	// Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18
	// Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR12_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR12_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR12_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR12_VeryHighSpeed = 0x3
	// Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16
	// Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR11_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR11_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR11_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR11_VeryHighSpeed = 0x3
	// Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14
	// Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR10_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR10_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR10_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR10_VeryHighSpeed = 0x3
	// Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos = 0x12
	// Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk = 0xc0000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR9_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR9_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR9_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR9_VeryHighSpeed = 0x3
	// Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos = 0x10
	// Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk = 0x30000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR8_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR8_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR8_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR8_VeryHighSpeed = 0x3
	// Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos = 0xe
	// Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk = 0xc000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR7_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR7_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR7_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR7_VeryHighSpeed = 0x3
	// Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos = 0xc
	// Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk = 0x3000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR6_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR6_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR6_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR6_VeryHighSpeed = 0x3
	// Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos = 0xa
	// Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk = 0xc00
	// Low speed
	GPIO_OSPEEDR_OSPEEDR5_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR5_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR5_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR5_VeryHighSpeed = 0x3
	// Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos = 0x8
	// Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk = 0x300
	// Low speed
	GPIO_OSPEEDR_OSPEEDR4_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR4_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR4_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR4_VeryHighSpeed = 0x3
	// Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos = 0x6
	// Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk = 0xc0
	// Low speed
	GPIO_OSPEEDR_OSPEEDR3_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR3_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR3_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR3_VeryHighSpeed = 0x3
	// Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos = 0x4
	// Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk = 0x30
	// Low speed
	GPIO_OSPEEDR_OSPEEDR2_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR2_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR2_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR2_VeryHighSpeed = 0x3
	// Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos = 0x2
	// Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk = 0xc
	// Low speed
	GPIO_OSPEEDR_OSPEEDR1_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR1_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR1_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR1_VeryHighSpeed = 0x3
	// Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos = 0x0
	// Bit mask of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk = 0x3
	// Low speed
	GPIO_OSPEEDR_OSPEEDR0_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR0_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR0_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR0_VeryHighSpeed = 0x3

	// PUPDR: GPIO port pull-up/pull-down register
	// Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Pos = 0x1e
	// Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR15_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR15_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR15_PullDown = 0x2
	// Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c
	// Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR14_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR14_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR14_PullDown = 0x2
	// Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a
	// Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR13_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR13_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR13_PullDown = 0x2
	// Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18
	// Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR12_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR12_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR12_PullDown = 0x2
	// Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16
	// Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR11_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR11_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR11_PullDown = 0x2
	// Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14
	// Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR10_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR10_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR10_PullDown = 0x2
	// Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Pos = 0x12
	// Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk = 0xc0000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR9_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR9_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR9_PullDown = 0x2
	// Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Pos = 0x10
	// Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk = 0x30000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR8_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR8_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR8_PullDown = 0x2
	// Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Pos = 0xe
	// Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk = 0xc000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR7_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR7_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR7_PullDown = 0x2
	// Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Pos = 0xc
	// Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk = 0x3000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR6_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR6_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR6_PullDown = 0x2
	// Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Pos = 0xa
	// Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk = 0xc00
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR5_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR5_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR5_PullDown = 0x2
	// Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Pos = 0x8
	// Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk = 0x300
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR4_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR4_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR4_PullDown = 0x2
	// Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Pos = 0x6
	// Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk = 0xc0
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR3_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR3_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR3_PullDown = 0x2
	// Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Pos = 0x4
	// Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk = 0x30
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR2_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR2_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR2_PullDown = 0x2
	// Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Pos = 0x2
	// Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk = 0xc
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR1_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR1_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR1_PullDown = 0x2
	// Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Pos = 0x0
	// Bit mask of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk = 0x3
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR0_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR0_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR0_PullDown = 0x2

	// IDR: GPIO port input data register
	// Position of IDR15 field.
	GPIO_IDR_IDR15_Pos = 0xf
	// Bit mask of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000
	// Bit IDR15.
	GPIO_IDR_IDR15 = 0x8000
	// Input is logic high
	GPIO_IDR_IDR15_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR15_Low = 0x0
	// Position of IDR14 field.
	GPIO_IDR_IDR14_Pos = 0xe
	// Bit mask of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000
	// Bit IDR14.
	GPIO_IDR_IDR14 = 0x4000
	// Input is logic high
	GPIO_IDR_IDR14_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR14_Low = 0x0
	// Position of IDR13 field.
	GPIO_IDR_IDR13_Pos = 0xd
	// Bit mask of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000
	// Bit IDR13.
	GPIO_IDR_IDR13 = 0x2000
	// Input is logic high
	GPIO_IDR_IDR13_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR13_Low = 0x0
	// Position of IDR12 field.
	GPIO_IDR_IDR12_Pos = 0xc
	// Bit mask of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000
	// Bit IDR12.
	GPIO_IDR_IDR12 = 0x1000
	// Input is logic high
	GPIO_IDR_IDR12_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR12_Low = 0x0
	// Position of IDR11 field.
	GPIO_IDR_IDR11_Pos = 0xb
	// Bit mask of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800
	// Bit IDR11.
	GPIO_IDR_IDR11 = 0x800
	// Input is logic high
	GPIO_IDR_IDR11_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR11_Low = 0x0
	// Position of IDR10 field.
	GPIO_IDR_IDR10_Pos = 0xa
	// Bit mask of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400
	// Bit IDR10.
	GPIO_IDR_IDR10 = 0x400
	// Input is logic high
	GPIO_IDR_IDR10_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR10_Low = 0x0
	// Position of IDR9 field.
	GPIO_IDR_IDR9_Pos = 0x9
	// Bit mask of IDR9 field.
	GPIO_IDR_IDR9_Msk = 0x200
	// Bit IDR9.
	GPIO_IDR_IDR9 = 0x200
	// Input is logic high
	GPIO_IDR_IDR9_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR9_Low = 0x0
	// Position of IDR8 field.
	GPIO_IDR_IDR8_Pos = 0x8
	// Bit mask of IDR8 field.
	GPIO_IDR_IDR8_Msk = 0x100
	// Bit IDR8.
	GPIO_IDR_IDR8 = 0x100
	// Input is logic high
	GPIO_IDR_IDR8_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR8_Low = 0x0
	// Position of IDR7 field.
	GPIO_IDR_IDR7_Pos = 0x7
	// Bit mask of IDR7 field.
	GPIO_IDR_IDR7_Msk = 0x80
	// Bit IDR7.
	GPIO_IDR_IDR7 = 0x80
	// Input is logic high
	GPIO_IDR_IDR7_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR7_Low = 0x0
	// Position of IDR6 field.
	GPIO_IDR_IDR6_Pos = 0x6
	// Bit mask of IDR6 field.
	GPIO_IDR_IDR6_Msk = 0x40
	// Bit IDR6.
	GPIO_IDR_IDR6 = 0x40
	// Input is logic high
	GPIO_IDR_IDR6_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR6_Low = 0x0
	// Position of IDR5 field.
	GPIO_IDR_IDR5_Pos = 0x5
	// Bit mask of IDR5 field.
	GPIO_IDR_IDR5_Msk = 0x20
	// Bit IDR5.
	GPIO_IDR_IDR5 = 0x20
	// Input is logic high
	GPIO_IDR_IDR5_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR5_Low = 0x0
	// Position of IDR4 field.
	GPIO_IDR_IDR4_Pos = 0x4
	// Bit mask of IDR4 field.
	GPIO_IDR_IDR4_Msk = 0x10
	// Bit IDR4.
	GPIO_IDR_IDR4 = 0x10
	// Input is logic high
	GPIO_IDR_IDR4_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR4_Low = 0x0
	// Position of IDR3 field.
	GPIO_IDR_IDR3_Pos = 0x3
	// Bit mask of IDR3 field.
	GPIO_IDR_IDR3_Msk = 0x8
	// Bit IDR3.
	GPIO_IDR_IDR3 = 0x8
	// Input is logic high
	GPIO_IDR_IDR3_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR3_Low = 0x0
	// Position of IDR2 field.
	GPIO_IDR_IDR2_Pos = 0x2
	// Bit mask of IDR2 field.
	GPIO_IDR_IDR2_Msk = 0x4
	// Bit IDR2.
	GPIO_IDR_IDR2 = 0x4
	// Input is logic high
	GPIO_IDR_IDR2_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR2_Low = 0x0
	// Position of IDR1 field.
	GPIO_IDR_IDR1_Pos = 0x1
	// Bit mask of IDR1 field.
	GPIO_IDR_IDR1_Msk = 0x2
	// Bit IDR1.
	GPIO_IDR_IDR1 = 0x2
	// Input is logic high
	GPIO_IDR_IDR1_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR1_Low = 0x0
	// Position of IDR0 field.
	GPIO_IDR_IDR0_Pos = 0x0
	// Bit mask of IDR0 field.
	GPIO_IDR_IDR0_Msk = 0x1
	// Bit IDR0.
	GPIO_IDR_IDR0 = 0x1
	// Input is logic high
	GPIO_IDR_IDR0_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR0_Low = 0x0

	// ODR: GPIO port output data register
	// Position of ODR15 field.
	GPIO_ODR_ODR15_Pos = 0xf
	// Bit mask of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000
	// Bit ODR15.
	GPIO_ODR_ODR15 = 0x8000
	// Set output to logic high
	GPIO_ODR_ODR15_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR15_Low = 0x0
	// Position of ODR14 field.
	GPIO_ODR_ODR14_Pos = 0xe
	// Bit mask of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000
	// Bit ODR14.
	GPIO_ODR_ODR14 = 0x4000
	// Set output to logic high
	GPIO_ODR_ODR14_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR14_Low = 0x0
	// Position of ODR13 field.
	GPIO_ODR_ODR13_Pos = 0xd
	// Bit mask of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000
	// Bit ODR13.
	GPIO_ODR_ODR13 = 0x2000
	// Set output to logic high
	GPIO_ODR_ODR13_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR13_Low = 0x0
	// Position of ODR12 field.
	GPIO_ODR_ODR12_Pos = 0xc
	// Bit mask of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000
	// Bit ODR12.
	GPIO_ODR_ODR12 = 0x1000
	// Set output to logic high
	GPIO_ODR_ODR12_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR12_Low = 0x0
	// Position of ODR11 field.
	GPIO_ODR_ODR11_Pos = 0xb
	// Bit mask of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800
	// Bit ODR11.
	GPIO_ODR_ODR11 = 0x800
	// Set output to logic high
	GPIO_ODR_ODR11_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR11_Low = 0x0
	// Position of ODR10 field.
	GPIO_ODR_ODR10_Pos = 0xa
	// Bit mask of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400
	// Bit ODR10.
	GPIO_ODR_ODR10 = 0x400
	// Set output to logic high
	GPIO_ODR_ODR10_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR10_Low = 0x0
	// Position of ODR9 field.
	GPIO_ODR_ODR9_Pos = 0x9
	// Bit mask of ODR9 field.
	GPIO_ODR_ODR9_Msk = 0x200
	// Bit ODR9.
	GPIO_ODR_ODR9 = 0x200
	// Set output to logic high
	GPIO_ODR_ODR9_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR9_Low = 0x0
	// Position of ODR8 field.
	GPIO_ODR_ODR8_Pos = 0x8
	// Bit mask of ODR8 field.
	GPIO_ODR_ODR8_Msk = 0x100
	// Bit ODR8.
	GPIO_ODR_ODR8 = 0x100
	// Set output to logic high
	GPIO_ODR_ODR8_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR8_Low = 0x0
	// Position of ODR7 field.
	GPIO_ODR_ODR7_Pos = 0x7
	// Bit mask of ODR7 field.
	GPIO_ODR_ODR7_Msk = 0x80
	// Bit ODR7.
	GPIO_ODR_ODR7 = 0x80
	// Set output to logic high
	GPIO_ODR_ODR7_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR7_Low = 0x0
	// Position of ODR6 field.
	GPIO_ODR_ODR6_Pos = 0x6
	// Bit mask of ODR6 field.
	GPIO_ODR_ODR6_Msk = 0x40
	// Bit ODR6.
	GPIO_ODR_ODR6 = 0x40
	// Set output to logic high
	GPIO_ODR_ODR6_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR6_Low = 0x0
	// Position of ODR5 field.
	GPIO_ODR_ODR5_Pos = 0x5
	// Bit mask of ODR5 field.
	GPIO_ODR_ODR5_Msk = 0x20
	// Bit ODR5.
	GPIO_ODR_ODR5 = 0x20
	// Set output to logic high
	GPIO_ODR_ODR5_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR5_Low = 0x0
	// Position of ODR4 field.
	GPIO_ODR_ODR4_Pos = 0x4
	// Bit mask of ODR4 field.
	GPIO_ODR_ODR4_Msk = 0x10
	// Bit ODR4.
	GPIO_ODR_ODR4 = 0x10
	// Set output to logic high
	GPIO_ODR_ODR4_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR4_Low = 0x0
	// Position of ODR3 field.
	GPIO_ODR_ODR3_Pos = 0x3
	// Bit mask of ODR3 field.
	GPIO_ODR_ODR3_Msk = 0x8
	// Bit ODR3.
	GPIO_ODR_ODR3 = 0x8
	// Set output to logic high
	GPIO_ODR_ODR3_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR3_Low = 0x0
	// Position of ODR2 field.
	GPIO_ODR_ODR2_Pos = 0x2
	// Bit mask of ODR2 field.
	GPIO_ODR_ODR2_Msk = 0x4
	// Bit ODR2.
	GPIO_ODR_ODR2 = 0x4
	// Set output to logic high
	GPIO_ODR_ODR2_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR2_Low = 0x0
	// Position of ODR1 field.
	GPIO_ODR_ODR1_Pos = 0x1
	// Bit mask of ODR1 field.
	GPIO_ODR_ODR1_Msk = 0x2
	// Bit ODR1.
	GPIO_ODR_ODR1 = 0x2
	// Set output to logic high
	GPIO_ODR_ODR1_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR1_Low = 0x0
	// Position of ODR0 field.
	GPIO_ODR_ODR0_Pos = 0x0
	// Bit mask of ODR0 field.
	GPIO_ODR_ODR0_Msk = 0x1
	// Bit ODR0.
	GPIO_ODR_ODR0 = 0x1
	// Set output to logic high
	GPIO_ODR_ODR0_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR0_Low = 0x0

	// BSRR: GPIO port bit set/reset register
	// Position of BR15 field.
	GPIO_BSRR_BR15_Pos = 0x1f
	// Bit mask of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000
	// Bit BR15.
	GPIO_BSRR_BR15 = 0x80000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR15_Reset = 0x1
	// Position of BR14 field.
	GPIO_BSRR_BR14_Pos = 0x1e
	// Bit mask of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000
	// Bit BR14.
	GPIO_BSRR_BR14 = 0x40000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR14_Reset = 0x1
	// Position of BR13 field.
	GPIO_BSRR_BR13_Pos = 0x1d
	// Bit mask of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000
	// Bit BR13.
	GPIO_BSRR_BR13 = 0x20000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR13_Reset = 0x1
	// Position of BR12 field.
	GPIO_BSRR_BR12_Pos = 0x1c
	// Bit mask of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000
	// Bit BR12.
	GPIO_BSRR_BR12 = 0x10000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR12_Reset = 0x1
	// Position of BR11 field.
	GPIO_BSRR_BR11_Pos = 0x1b
	// Bit mask of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000
	// Bit BR11.
	GPIO_BSRR_BR11 = 0x8000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR11_Reset = 0x1
	// Position of BR10 field.
	GPIO_BSRR_BR10_Pos = 0x1a
	// Bit mask of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000
	// Bit BR10.
	GPIO_BSRR_BR10 = 0x4000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR10_Reset = 0x1
	// Position of BR9 field.
	GPIO_BSRR_BR9_Pos = 0x19
	// Bit mask of BR9 field.
	GPIO_BSRR_BR9_Msk = 0x2000000
	// Bit BR9.
	GPIO_BSRR_BR9 = 0x2000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR9_Reset = 0x1
	// Position of BR8 field.
	GPIO_BSRR_BR8_Pos = 0x18
	// Bit mask of BR8 field.
	GPIO_BSRR_BR8_Msk = 0x1000000
	// Bit BR8.
	GPIO_BSRR_BR8 = 0x1000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR8_Reset = 0x1
	// Position of BR7 field.
	GPIO_BSRR_BR7_Pos = 0x17
	// Bit mask of BR7 field.
	GPIO_BSRR_BR7_Msk = 0x800000
	// Bit BR7.
	GPIO_BSRR_BR7 = 0x800000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR7_Reset = 0x1
	// Position of BR6 field.
	GPIO_BSRR_BR6_Pos = 0x16
	// Bit mask of BR6 field.
	GPIO_BSRR_BR6_Msk = 0x400000
	// Bit BR6.
	GPIO_BSRR_BR6 = 0x400000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR6_Reset = 0x1
	// Position of BR5 field.
	GPIO_BSRR_BR5_Pos = 0x15
	// Bit mask of BR5 field.
	GPIO_BSRR_BR5_Msk = 0x200000
	// Bit BR5.
	GPIO_BSRR_BR5 = 0x200000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR5_Reset = 0x1
	// Position of BR4 field.
	GPIO_BSRR_BR4_Pos = 0x14
	// Bit mask of BR4 field.
	GPIO_BSRR_BR4_Msk = 0x100000
	// Bit BR4.
	GPIO_BSRR_BR4 = 0x100000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR4_Reset = 0x1
	// Position of BR3 field.
	GPIO_BSRR_BR3_Pos = 0x13
	// Bit mask of BR3 field.
	GPIO_BSRR_BR3_Msk = 0x80000
	// Bit BR3.
	GPIO_BSRR_BR3 = 0x80000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR3_Reset = 0x1
	// Position of BR2 field.
	GPIO_BSRR_BR2_Pos = 0x12
	// Bit mask of BR2 field.
	GPIO_BSRR_BR2_Msk = 0x40000
	// Bit BR2.
	GPIO_BSRR_BR2 = 0x40000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR2_Reset = 0x1
	// Position of BR1 field.
	GPIO_BSRR_BR1_Pos = 0x11
	// Bit mask of BR1 field.
	GPIO_BSRR_BR1_Msk = 0x20000
	// Bit BR1.
	GPIO_BSRR_BR1 = 0x20000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR1_Reset = 0x1
	// Position of BR0 field.
	GPIO_BSRR_BR0_Pos = 0x10
	// Bit mask of BR0 field.
	GPIO_BSRR_BR0_Msk = 0x10000
	// Bit BR0.
	GPIO_BSRR_BR0 = 0x10000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR0_Reset = 0x1
	// Position of BS15 field.
	GPIO_BSRR_BS15_Pos = 0xf
	// Bit mask of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000
	// Bit BS15.
	GPIO_BSRR_BS15 = 0x8000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS15_Set = 0x1
	// Position of BS14 field.
	GPIO_BSRR_BS14_Pos = 0xe
	// Bit mask of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000
	// Bit BS14.
	GPIO_BSRR_BS14 = 0x4000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS14_Set = 0x1
	// Position of BS13 field.
	GPIO_BSRR_BS13_Pos = 0xd
	// Bit mask of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000
	// Bit BS13.
	GPIO_BSRR_BS13 = 0x2000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS13_Set = 0x1
	// Position of BS12 field.
	GPIO_BSRR_BS12_Pos = 0xc
	// Bit mask of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000
	// Bit BS12.
	GPIO_BSRR_BS12 = 0x1000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS12_Set = 0x1
	// Position of BS11 field.
	GPIO_BSRR_BS11_Pos = 0xb
	// Bit mask of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800
	// Bit BS11.
	GPIO_BSRR_BS11 = 0x800
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS11_Set = 0x1
	// Position of BS10 field.
	GPIO_BSRR_BS10_Pos = 0xa
	// Bit mask of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400
	// Bit BS10.
	GPIO_BSRR_BS10 = 0x400
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS10_Set = 0x1
	// Position of BS9 field.
	GPIO_BSRR_BS9_Pos = 0x9
	// Bit mask of BS9 field.
	GPIO_BSRR_BS9_Msk = 0x200
	// Bit BS9.
	GPIO_BSRR_BS9 = 0x200
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS9_Set = 0x1
	// Position of BS8 field.
	GPIO_BSRR_BS8_Pos = 0x8
	// Bit mask of BS8 field.
	GPIO_BSRR_BS8_Msk = 0x100
	// Bit BS8.
	GPIO_BSRR_BS8 = 0x100
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS8_Set = 0x1
	// Position of BS7 field.
	GPIO_BSRR_BS7_Pos = 0x7
	// Bit mask of BS7 field.
	GPIO_BSRR_BS7_Msk = 0x80
	// Bit BS7.
	GPIO_BSRR_BS7 = 0x80
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS7_Set = 0x1
	// Position of BS6 field.
	GPIO_BSRR_BS6_Pos = 0x6
	// Bit mask of BS6 field.
	GPIO_BSRR_BS6_Msk = 0x40
	// Bit BS6.
	GPIO_BSRR_BS6 = 0x40
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS6_Set = 0x1
	// Position of BS5 field.
	GPIO_BSRR_BS5_Pos = 0x5
	// Bit mask of BS5 field.
	GPIO_BSRR_BS5_Msk = 0x20
	// Bit BS5.
	GPIO_BSRR_BS5 = 0x20
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS5_Set = 0x1
	// Position of BS4 field.
	GPIO_BSRR_BS4_Pos = 0x4
	// Bit mask of BS4 field.
	GPIO_BSRR_BS4_Msk = 0x10
	// Bit BS4.
	GPIO_BSRR_BS4 = 0x10
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS4_Set = 0x1
	// Position of BS3 field.
	GPIO_BSRR_BS3_Pos = 0x3
	// Bit mask of BS3 field.
	GPIO_BSRR_BS3_Msk = 0x8
	// Bit BS3.
	GPIO_BSRR_BS3 = 0x8
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS3_Set = 0x1
	// Position of BS2 field.
	GPIO_BSRR_BS2_Pos = 0x2
	// Bit mask of BS2 field.
	GPIO_BSRR_BS2_Msk = 0x4
	// Bit BS2.
	GPIO_BSRR_BS2 = 0x4
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS2_Set = 0x1
	// Position of BS1 field.
	GPIO_BSRR_BS1_Pos = 0x1
	// Bit mask of BS1 field.
	GPIO_BSRR_BS1_Msk = 0x2
	// Bit BS1.
	GPIO_BSRR_BS1 = 0x2
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS1_Set = 0x1
	// Position of BS0 field.
	GPIO_BSRR_BS0_Pos = 0x0
	// Bit mask of BS0 field.
	GPIO_BSRR_BS0_Msk = 0x1
	// Bit BS0.
	GPIO_BSRR_BS0 = 0x1
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS0_Set = 0x1

	// LCKR: GPIO port configuration lock register
	// Position of LCKK field.
	GPIO_LCKR_LCKK_Pos = 0x10
	// Bit mask of LCKK field.
	GPIO_LCKR_LCKK_Msk = 0x10000
	// Bit LCKK.
	GPIO_LCKR_LCKK = 0x10000
	// Port configuration lock key not active
	GPIO_LCKR_LCKK_NotActive = 0x0
	// Port configuration lock key active
	GPIO_LCKR_LCKK_Active = 0x1
	// Position of LCK15 field.
	GPIO_LCKR_LCK15_Pos = 0xf
	// Bit mask of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000
	// Bit LCK15.
	GPIO_LCKR_LCK15 = 0x8000
	// Port configuration not locked
	GPIO_LCKR_LCK15_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK15_Locked = 0x1
	// Position of LCK14 field.
	GPIO_LCKR_LCK14_Pos = 0xe
	// Bit mask of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000
	// Bit LCK14.
	GPIO_LCKR_LCK14 = 0x4000
	// Port configuration not locked
	GPIO_LCKR_LCK14_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK14_Locked = 0x1
	// Position of LCK13 field.
	GPIO_LCKR_LCK13_Pos = 0xd
	// Bit mask of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000
	// Bit LCK13.
	GPIO_LCKR_LCK13 = 0x2000
	// Port configuration not locked
	GPIO_LCKR_LCK13_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK13_Locked = 0x1
	// Position of LCK12 field.
	GPIO_LCKR_LCK12_Pos = 0xc
	// Bit mask of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000
	// Bit LCK12.
	GPIO_LCKR_LCK12 = 0x1000
	// Port configuration not locked
	GPIO_LCKR_LCK12_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK12_Locked = 0x1
	// Position of LCK11 field.
	GPIO_LCKR_LCK11_Pos = 0xb
	// Bit mask of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800
	// Bit LCK11.
	GPIO_LCKR_LCK11 = 0x800
	// Port configuration not locked
	GPIO_LCKR_LCK11_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK11_Locked = 0x1
	// Position of LCK10 field.
	GPIO_LCKR_LCK10_Pos = 0xa
	// Bit mask of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400
	// Bit LCK10.
	GPIO_LCKR_LCK10 = 0x400
	// Port configuration not locked
	GPIO_LCKR_LCK10_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK10_Locked = 0x1
	// Position of LCK9 field.
	GPIO_LCKR_LCK9_Pos = 0x9
	// Bit mask of LCK9 field.
	GPIO_LCKR_LCK9_Msk = 0x200
	// Bit LCK9.
	GPIO_LCKR_LCK9 = 0x200
	// Port configuration not locked
	GPIO_LCKR_LCK9_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK9_Locked = 0x1
	// Position of LCK8 field.
	GPIO_LCKR_LCK8_Pos = 0x8
	// Bit mask of LCK8 field.
	GPIO_LCKR_LCK8_Msk = 0x100
	// Bit LCK8.
	GPIO_LCKR_LCK8 = 0x100
	// Port configuration not locked
	GPIO_LCKR_LCK8_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK8_Locked = 0x1
	// Position of LCK7 field.
	GPIO_LCKR_LCK7_Pos = 0x7
	// Bit mask of LCK7 field.
	GPIO_LCKR_LCK7_Msk = 0x80
	// Bit LCK7.
	GPIO_LCKR_LCK7 = 0x80
	// Port configuration not locked
	GPIO_LCKR_LCK7_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK7_Locked = 0x1
	// Position of LCK6 field.
	GPIO_LCKR_LCK6_Pos = 0x6
	// Bit mask of LCK6 field.
	GPIO_LCKR_LCK6_Msk = 0x40
	// Bit LCK6.
	GPIO_LCKR_LCK6 = 0x40
	// Port configuration not locked
	GPIO_LCKR_LCK6_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK6_Locked = 0x1
	// Position of LCK5 field.
	GPIO_LCKR_LCK5_Pos = 0x5
	// Bit mask of LCK5 field.
	GPIO_LCKR_LCK5_Msk = 0x20
	// Bit LCK5.
	GPIO_LCKR_LCK5 = 0x20
	// Port configuration not locked
	GPIO_LCKR_LCK5_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK5_Locked = 0x1
	// Position of LCK4 field.
	GPIO_LCKR_LCK4_Pos = 0x4
	// Bit mask of LCK4 field.
	GPIO_LCKR_LCK4_Msk = 0x10
	// Bit LCK4.
	GPIO_LCKR_LCK4 = 0x10
	// Port configuration not locked
	GPIO_LCKR_LCK4_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK4_Locked = 0x1
	// Position of LCK3 field.
	GPIO_LCKR_LCK3_Pos = 0x3
	// Bit mask of LCK3 field.
	GPIO_LCKR_LCK3_Msk = 0x8
	// Bit LCK3.
	GPIO_LCKR_LCK3 = 0x8
	// Port configuration not locked
	GPIO_LCKR_LCK3_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK3_Locked = 0x1
	// Position of LCK2 field.
	GPIO_LCKR_LCK2_Pos = 0x2
	// Bit mask of LCK2 field.
	GPIO_LCKR_LCK2_Msk = 0x4
	// Bit LCK2.
	GPIO_LCKR_LCK2 = 0x4
	// Port configuration not locked
	GPIO_LCKR_LCK2_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK2_Locked = 0x1
	// Position of LCK1 field.
	GPIO_LCKR_LCK1_Pos = 0x1
	// Bit mask of LCK1 field.
	GPIO_LCKR_LCK1_Msk = 0x2
	// Bit LCK1.
	GPIO_LCKR_LCK1 = 0x2
	// Port configuration not locked
	GPIO_LCKR_LCK1_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK1_Locked = 0x1
	// Position of LCK0 field.
	GPIO_LCKR_LCK0_Pos = 0x0
	// Bit mask of LCK0 field.
	GPIO_LCKR_LCK0_Msk = 0x1
	// Bit LCK0.
	GPIO_LCKR_LCK0 = 0x1
	// Port configuration not locked
	GPIO_LCKR_LCK0_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK0_Locked = 0x1

	// AFRL: GPIO alternate function low register
	// Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Pos = 0x1c
	// Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000
	// AF0
	GPIO_AFRL_AFRL7_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL7_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL7_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL7_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL7_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL7_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL7_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL7_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL7_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL7_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL7_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL7_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL7_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL7_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL7_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL7_AF15 = 0xf
	// Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Pos = 0x18
	// Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000
	// AF0
	GPIO_AFRL_AFRL6_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL6_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL6_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL6_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL6_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL6_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL6_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL6_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL6_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL6_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL6_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL6_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL6_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL6_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL6_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL6_AF15 = 0xf
	// Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Pos = 0x14
	// Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000
	// AF0
	GPIO_AFRL_AFRL5_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL5_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL5_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL5_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL5_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL5_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL5_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL5_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL5_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL5_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL5_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL5_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL5_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL5_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL5_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL5_AF15 = 0xf
	// Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Pos = 0x10
	// Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000
	// AF0
	GPIO_AFRL_AFRL4_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL4_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL4_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL4_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL4_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL4_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL4_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL4_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL4_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL4_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL4_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL4_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL4_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL4_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL4_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL4_AF15 = 0xf
	// Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Pos = 0xc
	// Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000
	// AF0
	GPIO_AFRL_AFRL3_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL3_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL3_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL3_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL3_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL3_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL3_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL3_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL3_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL3_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL3_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL3_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL3_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL3_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL3_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL3_AF15 = 0xf
	// Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Pos = 0x8
	// Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00
	// AF0
	GPIO_AFRL_AFRL2_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL2_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL2_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL2_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL2_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL2_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL2_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL2_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL2_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL2_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL2_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL2_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL2_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL2_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL2_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL2_AF15 = 0xf
	// Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Pos = 0x4
	// Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0
	// AF0
	GPIO_AFRL_AFRL1_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL1_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL1_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL1_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL1_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL1_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL1_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL1_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL1_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL1_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL1_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL1_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL1_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL1_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL1_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL1_AF15 = 0xf
	// Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Pos = 0x0
	// Bit mask of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf
	// AF0
	GPIO_AFRL_AFRL0_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL0_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL0_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL0_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL0_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL0_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL0_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL0_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL0_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL0_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL0_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL0_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL0_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL0_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL0_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL0_AF15 = 0xf

	// AFRH: GPIO alternate function high register
	// Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Pos = 0x1c
	// Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000
	// AF0
	GPIO_AFRH_AFRH15_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH15_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH15_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH15_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH15_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH15_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH15_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH15_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH15_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH15_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH15_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH15_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH15_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH15_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH15_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH15_AF15 = 0xf
	// Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Pos = 0x18
	// Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000
	// AF0
	GPIO_AFRH_AFRH14_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH14_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH14_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH14_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH14_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH14_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH14_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH14_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH14_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH14_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH14_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH14_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH14_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH14_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH14_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH14_AF15 = 0xf
	// Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Pos = 0x14
	// Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000
	// AF0
	GPIO_AFRH_AFRH13_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH13_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH13_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH13_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH13_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH13_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH13_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH13_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH13_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH13_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH13_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH13_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH13_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH13_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH13_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH13_AF15 = 0xf
	// Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Pos = 0x10
	// Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000
	// AF0
	GPIO_AFRH_AFRH12_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH12_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH12_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH12_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH12_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH12_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH12_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH12_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH12_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH12_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH12_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH12_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH12_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH12_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH12_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH12_AF15 = 0xf
	// Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Pos = 0xc
	// Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000
	// AF0
	GPIO_AFRH_AFRH11_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH11_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH11_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH11_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH11_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH11_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH11_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH11_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH11_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH11_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH11_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH11_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH11_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH11_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH11_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH11_AF15 = 0xf
	// Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Pos = 0x8
	// Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00
	// AF0
	GPIO_AFRH_AFRH10_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH10_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH10_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH10_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH10_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH10_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH10_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH10_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH10_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH10_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH10_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH10_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH10_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH10_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH10_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH10_AF15 = 0xf
	// Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Pos = 0x4
	// Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk = 0xf0
	// AF0
	GPIO_AFRH_AFRH9_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH9_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH9_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH9_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH9_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH9_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH9_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH9_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH9_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH9_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH9_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH9_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH9_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH9_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH9_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH9_AF15 = 0xf
	// Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Pos = 0x0
	// Bit mask of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk = 0xf
	// AF0
	GPIO_AFRH_AFRH8_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH8_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH8_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH8_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH8_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH8_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH8_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH8_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH8_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH8_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH8_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH8_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH8_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH8_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH8_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH8_AF15 = 0xf
)

// Constants for SYSCFG: System configuration controller
const (
	// MEMRM: memory remap register
	// Position of MEM_MODE field.
	SYSCFG_MEMRM_MEM_MODE_Pos = 0x0
	// Bit mask of MEM_MODE field.
	SYSCFG_MEMRM_MEM_MODE_Msk = 0x3

	// PMC: peripheral mode configuration register
	// Position of MII_RMII_SEL field.
	SYSCFG_PMC_MII_RMII_SEL_Pos = 0x17
	// Bit mask of MII_RMII_SEL field.
	SYSCFG_PMC_MII_RMII_SEL_Msk = 0x800000
	// Bit MII_RMII_SEL.
	SYSCFG_PMC_MII_RMII_SEL = 0x800000

	// EXTICR1: external interrupt configuration register 1
	// Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc
	// Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0xf000
	// Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8
	// Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0xf00
	// Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4
	// Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0xf0
	// Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0
	// Bit mask of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0xf

	// EXTICR2: external interrupt configuration register 2
	// Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc
	// Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0xf000
	// Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8
	// Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0xf00
	// Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4
	// Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0xf0
	// Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0
	// Bit mask of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0xf

	// EXTICR3: external interrupt configuration register 3
	// Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc
	// Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0xf000
	// Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8
	// Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0xf00
	// Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Pos = 0x4
	// Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk = 0xf0
	// Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Pos = 0x0
	// Bit mask of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk = 0xf

	// EXTICR4: external interrupt configuration register 4
	// Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc
	// Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0xf000
	// Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8
	// Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0xf00
	// Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4
	// Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0xf0
	// Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0
	// Bit mask of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0xf

	// CMPCR: Compensation cell control register
	// Position of READY field.
	SYSCFG_CMPCR_READY_Pos = 0x7
	// Bit mask of READY field.
	SYSCFG_CMPCR_READY_Msk = 0x80
	// Bit READY.
	SYSCFG_CMPCR_READY = 0x80
	// Position of CMP_PD field.
	SYSCFG_CMPCR_CMP_PD_Pos = 0x0
	// Bit mask of CMP_PD field.
	SYSCFG_CMPCR_CMP_PD_Msk = 0x1
	// Bit CMP_PD.
	SYSCFG_CMPCR_CMP_PD = 0x1
)

// Constants for SPI1: Serial peripheral interface
const (
	// CR1: control register 1
	// Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Pos = 0xf
	// Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000
	// Bit BIDIMODE.
	SPI_CR1_BIDIMODE = 0x8000
	// 2-line unidirectional data mode selected
	SPI_CR1_BIDIMODE_Unidirectional = 0x0
	// 1-line bidirectional data mode selected
	SPI_CR1_BIDIMODE_Bidirectional = 0x1
	// Position of BIDIOE field.
	SPI_CR1_BIDIOE_Pos = 0xe
	// Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE_Msk = 0x4000
	// Bit BIDIOE.
	SPI_CR1_BIDIOE = 0x4000
	// Output disabled (receive-only mode)
	SPI_CR1_BIDIOE_OutputDisabled = 0x0
	// Output enabled (transmit-only mode)
	SPI_CR1_BIDIOE_OutputEnabled = 0x1
	// Position of CRCEN field.
	SPI_CR1_CRCEN_Pos = 0xd
	// Bit mask of CRCEN field.
	SPI_CR1_CRCEN_Msk = 0x2000
	// Bit CRCEN.
	SPI_CR1_CRCEN = 0x2000
	// CRC calculation disabled
	SPI_CR1_CRCEN_Disabled = 0x0
	// CRC calculation enabled
	SPI_CR1_CRCEN_Enabled = 0x1
	// Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Pos = 0xc
	// Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk = 0x1000
	// Bit CRCNEXT.
	SPI_CR1_CRCNEXT = 0x1000
	// Next transmit value is from Tx buffer
	SPI_CR1_CRCNEXT_TxBuffer = 0x0
	// Next transmit value is from Tx CRC register
	SPI_CR1_CRCNEXT_CRC = 0x1
	// Position of DFF field.
	SPI_CR1_DFF_Pos = 0xb
	// Bit mask of DFF field.
	SPI_CR1_DFF_Msk = 0x800
	// Bit DFF.
	SPI_CR1_DFF = 0x800
	// 8-bit data frame format is selected for transmission/reception
	SPI_CR1_DFF_EightBit = 0x0
	// 16-bit data frame format is selected for transmission/reception
	SPI_CR1_DFF_SixteenBit = 0x1
	// Position of RXONLY field.
	SPI_CR1_RXONLY_Pos = 0xa
	// Bit mask of RXONLY field.
	SPI_CR1_RXONLY_Msk = 0x400
	// Bit RXONLY.
	SPI_CR1_RXONLY = 0x400
	// Full duplex (Transmit and receive)
	SPI_CR1_RXONLY_FullDuplex = 0x0
	// Output disabled (Receive-only mode)
	SPI_CR1_RXONLY_OutputDisabled = 0x1
	// Position of SSM field.
	SPI_CR1_SSM_Pos = 0x9
	// Bit mask of SSM field.
	SPI_CR1_SSM_Msk = 0x200
	// Bit SSM.
	SPI_CR1_SSM = 0x200
	// Software slave management disabled
	SPI_CR1_SSM_Disabled = 0x0
	// Software slave management enabled
	SPI_CR1_SSM_Enabled = 0x1
	// Position of SSI field.
	SPI_CR1_SSI_Pos = 0x8
	// Bit mask of SSI field.
	SPI_CR1_SSI_Msk = 0x100
	// Bit SSI.
	SPI_CR1_SSI = 0x100
	// 0 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveSelected = 0x0
	// 1 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveNotSelected = 0x1
	// Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Pos = 0x7
	// Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80
	// Bit LSBFIRST.
	SPI_CR1_LSBFIRST = 0x80
	// Data is transmitted/received with the MSB first
	SPI_CR1_LSBFIRST_MSBFirst = 0x0
	// Data is transmitted/received with the LSB first
	SPI_CR1_LSBFIRST_LSBFirst = 0x1
	// Position of SPE field.
	SPI_CR1_SPE_Pos = 0x6
	// Bit mask of SPE field.
	SPI_CR1_SPE_Msk = 0x40
	// Bit SPE.
	SPI_CR1_SPE = 0x40
	// Peripheral disabled
	SPI_CR1_SPE_Disabled = 0x0
	// Peripheral enabled
	SPI_CR1_SPE_Enabled = 0x1
	// Position of BR field.
	SPI_CR1_BR_Pos = 0x3
	// Bit mask of BR field.
	SPI_CR1_BR_Msk = 0x38
	// f_PCLK / 2
	SPI_CR1_BR_Div2 = 0x0
	// f_PCLK / 4
	SPI_CR1_BR_Div4 = 0x1
	// f_PCLK / 8
	SPI_CR1_BR_Div8 = 0x2
	// f_PCLK / 16
	SPI_CR1_BR_Div16 = 0x3
	// f_PCLK / 32
	SPI_CR1_BR_Div32 = 0x4
	// f_PCLK / 64
	SPI_CR1_BR_Div64 = 0x5
	// f_PCLK / 128
	SPI_CR1_BR_Div128 = 0x6
	// f_PCLK / 256
	SPI_CR1_BR_Div256 = 0x7
	// Position of MSTR field.
	SPI_CR1_MSTR_Pos = 0x2
	// Bit mask of MSTR field.
	SPI_CR1_MSTR_Msk = 0x4
	// Bit MSTR.
	SPI_CR1_MSTR = 0x4
	// Slave configuration
	SPI_CR1_MSTR_Slave = 0x0
	// Master configuration
	SPI_CR1_MSTR_Master = 0x1
	// Position of CPOL field.
	SPI_CR1_CPOL_Pos = 0x1
	// Bit mask of CPOL field.
	SPI_CR1_CPOL_Msk = 0x2
	// Bit CPOL.
	SPI_CR1_CPOL = 0x2
	// CK to 0 when idle
	SPI_CR1_CPOL_IdleLow = 0x0
	// CK to 1 when idle
	SPI_CR1_CPOL_IdleHigh = 0x1
	// Position of CPHA field.
	SPI_CR1_CPHA_Pos = 0x0
	// Bit mask of CPHA field.
	SPI_CR1_CPHA_Msk = 0x1
	// Bit CPHA.
	SPI_CR1_CPHA = 0x1
	// The first clock transition is the first data capture edge
	SPI_CR1_CPHA_FirstEdge = 0x0
	// The second clock transition is the first data capture edge
	SPI_CR1_CPHA_SecondEdge = 0x1

	// CR2: control register 2
	// Position of TXEIE field.
	SPI_CR2_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	SPI_CR2_TXEIE_Msk = 0x80
	// Bit TXEIE.
	SPI_CR2_TXEIE = 0x80
	// TXE interrupt masked
	SPI_CR2_TXEIE_Masked = 0x0
	// TXE interrupt not masked
	SPI_CR2_TXEIE_NotMasked = 0x1
	// Position of RXNEIE field.
	SPI_CR2_RXNEIE_Pos = 0x6
	// Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE_Msk = 0x40
	// Bit RXNEIE.
	SPI_CR2_RXNEIE = 0x40
	// RXE interrupt masked
	SPI_CR2_RXNEIE_Masked = 0x0
	// RXE interrupt not masked
	SPI_CR2_RXNEIE_NotMasked = 0x1
	// Position of ERRIE field.
	SPI_CR2_ERRIE_Pos = 0x5
	// Bit mask of ERRIE field.
	SPI_CR2_ERRIE_Msk = 0x20
	// Bit ERRIE.
	SPI_CR2_ERRIE = 0x20
	// Error interrupt masked
	SPI_CR2_ERRIE_Masked = 0x0
	// Error interrupt not masked
	SPI_CR2_ERRIE_NotMasked = 0x1
	// Position of FRF field.
	SPI_CR2_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SPI_CR2_FRF_Msk = 0x10
	// Bit FRF.
	SPI_CR2_FRF = 0x10
	// SPI Motorola mode
	SPI_CR2_FRF_Motorola = 0x0
	// SPI TI mode
	SPI_CR2_FRF_TI = 0x1
	// Position of SSOE field.
	SPI_CR2_SSOE_Pos = 0x2
	// Bit mask of SSOE field.
	SPI_CR2_SSOE_Msk = 0x4
	// Bit SSOE.
	SPI_CR2_SSOE = 0x4
	// SS output is disabled in master mode
	SPI_CR2_SSOE_Disabled = 0x0
	// SS output is enabled in master mode
	SPI_CR2_SSOE_Enabled = 0x1
	// Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Pos = 0x1
	// Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2
	// Bit TXDMAEN.
	SPI_CR2_TXDMAEN = 0x2
	// Tx buffer DMA disabled
	SPI_CR2_TXDMAEN_Disabled = 0x0
	// Tx buffer DMA enabled
	SPI_CR2_TXDMAEN_Enabled = 0x1
	// Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Pos = 0x0
	// Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1
	// Bit RXDMAEN.
	SPI_CR2_RXDMAEN = 0x1
	// Rx buffer DMA disabled
	SPI_CR2_RXDMAEN_Disabled = 0x0
	// Rx buffer DMA enabled
	SPI_CR2_RXDMAEN_Enabled = 0x1

	// SR: status register
	// Position of TIFRFE field.
	SPI_SR_TIFRFE_Pos = 0x8
	// Bit mask of TIFRFE field.
	SPI_SR_TIFRFE_Msk = 0x100
	// Bit TIFRFE.
	SPI_SR_TIFRFE = 0x100
	// No frame format error
	SPI_SR_TIFRFE_NoError = 0x0
	// A frame format error occurred
	SPI_SR_TIFRFE_Error = 0x1
	// Position of BSY field.
	SPI_SR_BSY_Pos = 0x7
	// Bit mask of BSY field.
	SPI_SR_BSY_Msk = 0x80
	// Bit BSY.
	SPI_SR_BSY = 0x80
	// SPI not busy
	SPI_SR_BSY_NotBusy = 0x0
	// SPI busy
	SPI_SR_BSY_Busy = 0x1
	// Position of OVR field.
	SPI_SR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	SPI_SR_OVR_Msk = 0x40
	// Bit OVR.
	SPI_SR_OVR = 0x40
	// No overrun occurred
	SPI_SR_OVR_NoOverrun = 0x0
	// Overrun occurred
	SPI_SR_OVR_Overrun = 0x1
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x5
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x20
	// Bit MODF.
	SPI_SR_MODF = 0x20
	// No mode fault occurred
	SPI_SR_MODF_NoFault = 0x0
	// Mode fault occurred
	SPI_SR_MODF_Fault = 0x1
	// Position of CRCERR field.
	SPI_SR_CRCERR_Pos = 0x4
	// Bit mask of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10
	// Bit CRCERR.
	SPI_SR_CRCERR = 0x10
	// CRC value received matches the SPIx_RXCRCR value
	SPI_SR_CRCERR_Match = 0x0
	// CRC value received does not match the SPIx_RXCRCR value
	SPI_SR_CRCERR_NoMatch = 0x1
	// Position of UDR field.
	SPI_SR_UDR_Pos = 0x3
	// Bit mask of UDR field.
	SPI_SR_UDR_Msk = 0x8
	// Bit UDR.
	SPI_SR_UDR = 0x8
	// No underrun occurred
	SPI_SR_UDR_NoUnderrun = 0x0
	// Underrun occurred
	SPI_SR_UDR_Underrun = 0x1
	// Position of CHSIDE field.
	SPI_SR_CHSIDE_Pos = 0x2
	// Bit mask of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4
	// Bit CHSIDE.
	SPI_SR_CHSIDE = 0x4
	// Channel left has to be transmitted or has been received
	SPI_SR_CHSIDE_Left = 0x0
	// Channel right has to be transmitted or has been received
	SPI_SR_CHSIDE_Right = 0x1
	// Position of TXE field.
	SPI_SR_TXE_Pos = 0x1
	// Bit mask of TXE field.
	SPI_SR_TXE_Msk = 0x2
	// Bit TXE.
	SPI_SR_TXE = 0x2
	// Tx buffer not empty
	SPI_SR_TXE_NotEmpty = 0x0
	// Tx buffer empty
	SPI_SR_TXE_Empty = 0x1
	// Position of RXNE field.
	SPI_SR_RXNE_Pos = 0x0
	// Bit mask of RXNE field.
	SPI_SR_RXNE_Msk = 0x1
	// Bit RXNE.
	SPI_SR_RXNE = 0x1
	// Rx buffer empty
	SPI_SR_RXNE_Empty = 0x0
	// Rx buffer not empty
	SPI_SR_RXNE_NotEmpty = 0x1

	// DR: data register
	// Position of DR field.
	SPI_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	SPI_DR_DR_Msk = 0xffff

	// CRCPR: CRC polynomial register
	// Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff

	// RXCRCR: RX CRC register
	// Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Pos = 0x0
	// Bit mask of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff

	// TXCRCR: TX CRC register
	// Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Pos = 0x0
	// Bit mask of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff

	// I2SCFGR: I2S configuration register
	// Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Pos = 0xb
	// Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk = 0x800
	// Bit I2SMOD.
	SPI_I2SCFGR_I2SMOD = 0x800
	// SPI mode is selected
	SPI_I2SCFGR_I2SMOD_SPIMode = 0x0
	// I2S mode is selected
	SPI_I2SCFGR_I2SMOD_I2SMode = 0x1
	// Position of I2SE field.
	SPI_I2SCFGR_I2SE_Pos = 0xa
	// Bit mask of I2SE field.
	SPI_I2SCFGR_I2SE_Msk = 0x400
	// Bit I2SE.
	SPI_I2SCFGR_I2SE = 0x400
	// I2S peripheral is disabled
	SPI_I2SCFGR_I2SE_Disabled = 0x0
	// I2S peripheral is enabled
	SPI_I2SCFGR_I2SE_Enabled = 0x1
	// Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Pos = 0x8
	// Bit mask of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk = 0x300
	// Slave - transmit
	SPI_I2SCFGR_I2SCFG_SlaveTx = 0x0
	// Slave - receive
	SPI_I2SCFGR_I2SCFG_SlaveRx = 0x1
	// Master - transmit
	SPI_I2SCFGR_I2SCFG_MasterTx = 0x2
	// Master - receive
	SPI_I2SCFGR_I2SCFG_MasterRx = 0x3
	// Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7
	// Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80
	// Bit PCMSYNC.
	SPI_I2SCFGR_PCMSYNC = 0x80
	// Short frame synchronisation
	SPI_I2SCFGR_PCMSYNC_Short = 0x0
	// Long frame synchronisation
	SPI_I2SCFGR_PCMSYNC_Long = 0x1
	// Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Pos = 0x4
	// Bit mask of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk = 0x30
	// I2S Philips standard
	SPI_I2SCFGR_I2SSTD_Philips = 0x0
	// MSB justified standard
	SPI_I2SCFGR_I2SSTD_MSB = 0x1
	// LSB justified standard
	SPI_I2SCFGR_I2SSTD_LSB = 0x2
	// PCM standard
	SPI_I2SCFGR_I2SSTD_PCM = 0x3
	// Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Pos = 0x3
	// Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk = 0x8
	// Bit CKPOL.
	SPI_I2SCFGR_CKPOL = 0x8
	// I2S clock inactive state is low level
	SPI_I2SCFGR_CKPOL_IdleLow = 0x0
	// I2S clock inactive state is high level
	SPI_I2SCFGR_CKPOL_IdleHigh = 0x1
	// Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Pos = 0x1
	// Bit mask of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk = 0x6
	// 16-bit data length
	SPI_I2SCFGR_DATLEN_SixteenBit = 0x0
	// 24-bit data length
	SPI_I2SCFGR_DATLEN_TwentyFourBit = 0x1
	// 32-bit data length
	SPI_I2SCFGR_DATLEN_ThirtyTwoBit = 0x2
	// Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Pos = 0x0
	// Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk = 0x1
	// Bit CHLEN.
	SPI_I2SCFGR_CHLEN = 0x1
	// 16-bit wide
	SPI_I2SCFGR_CHLEN_SixteenBit = 0x0
	// 32-bit wide
	SPI_I2SCFGR_CHLEN_ThirtyTwoBit = 0x1

	// I2SPR: I2S prescaler register
	// Position of MCKOE field.
	SPI_I2SPR_MCKOE_Pos = 0x9
	// Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE_Msk = 0x200
	// Bit MCKOE.
	SPI_I2SPR_MCKOE = 0x200
	// Master clock output is disabled
	SPI_I2SPR_MCKOE_Disabled = 0x0
	// Master clock output is enabled
	SPI_I2SPR_MCKOE_Enabled = 0x1
	// Position of ODD field.
	SPI_I2SPR_ODD_Pos = 0x8
	// Bit mask of ODD field.
	SPI_I2SPR_ODD_Msk = 0x100
	// Bit ODD.
	SPI_I2SPR_ODD = 0x100
	// Real divider value is I2SDIV * 2
	SPI_I2SPR_ODD_Even = 0x0
	// Real divider value is (I2SDIV * 2) + 1
	SPI_I2SPR_ODD_Odd = 0x1
	// Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Pos = 0x0
	// Bit mask of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff
)

// Constants for SDIO: Secure digital input/output interface
const (
	// POWER: power control register
	// Position of PWRCTRL field.
	SDIO_POWER_PWRCTRL_Pos = 0x0
	// Bit mask of PWRCTRL field.
	SDIO_POWER_PWRCTRL_Msk = 0x3

	// CLKCR: SDI clock control register
	// Position of HWFC_EN field.
	SDIO_CLKCR_HWFC_EN_Pos = 0xe
	// Bit mask of HWFC_EN field.
	SDIO_CLKCR_HWFC_EN_Msk = 0x4000
	// Bit HWFC_EN.
	SDIO_CLKCR_HWFC_EN = 0x4000
	// Position of NEGEDGE field.
	SDIO_CLKCR_NEGEDGE_Pos = 0xd
	// Bit mask of NEGEDGE field.
	SDIO_CLKCR_NEGEDGE_Msk = 0x2000
	// Bit NEGEDGE.
	SDIO_CLKCR_NEGEDGE = 0x2000
	// Position of WIDBUS field.
	SDIO_CLKCR_WIDBUS_Pos = 0xb
	// Bit mask of WIDBUS field.
	SDIO_CLKCR_WIDBUS_Msk = 0x1800
	// Position of BYPASS field.
	SDIO_CLKCR_BYPASS_Pos = 0xa
	// Bit mask of BYPASS field.
	SDIO_CLKCR_BYPASS_Msk = 0x400
	// Bit BYPASS.
	SDIO_CLKCR_BYPASS = 0x400
	// Position of PWRSAV field.
	SDIO_CLKCR_PWRSAV_Pos = 0x9
	// Bit mask of PWRSAV field.
	SDIO_CLKCR_PWRSAV_Msk = 0x200
	// Bit PWRSAV.
	SDIO_CLKCR_PWRSAV = 0x200
	// Position of CLKEN field.
	SDIO_CLKCR_CLKEN_Pos = 0x8
	// Bit mask of CLKEN field.
	SDIO_CLKCR_CLKEN_Msk = 0x100
	// Bit CLKEN.
	SDIO_CLKCR_CLKEN = 0x100
	// Position of CLKDIV field.
	SDIO_CLKCR_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	SDIO_CLKCR_CLKDIV_Msk = 0xff

	// ARG: argument register
	// Position of CMDARG field.
	SDIO_ARG_CMDARG_Pos = 0x0
	// Bit mask of CMDARG field.
	SDIO_ARG_CMDARG_Msk = 0xffffffff

	// CMD: command register
	// Position of CE_ATACMD field.
	SDIO_CMD_CE_ATACMD_Pos = 0xe
	// Bit mask of CE_ATACMD field.
	SDIO_CMD_CE_ATACMD_Msk = 0x4000
	// Bit CE_ATACMD.
	SDIO_CMD_CE_ATACMD = 0x4000
	// Position of NIEN field.
	SDIO_CMD_NIEN_Pos = 0xd
	// Bit mask of NIEN field.
	SDIO_CMD_NIEN_Msk = 0x2000
	// Bit NIEN.
	SDIO_CMD_NIEN = 0x2000
	// Position of ENCMDcompl field.
	SDIO_CMD_ENCMDcompl_Pos = 0xc
	// Bit mask of ENCMDcompl field.
	SDIO_CMD_ENCMDcompl_Msk = 0x1000
	// Bit ENCMDcompl.
	SDIO_CMD_ENCMDcompl = 0x1000
	// Position of SDIOSuspend field.
	SDIO_CMD_SDIOSuspend_Pos = 0xb
	// Bit mask of SDIOSuspend field.
	SDIO_CMD_SDIOSuspend_Msk = 0x800
	// Bit SDIOSuspend.
	SDIO_CMD_SDIOSuspend = 0x800
	// Position of CPSMEN field.
	SDIO_CMD_CPSMEN_Pos = 0xa
	// Bit mask of CPSMEN field.
	SDIO_CMD_CPSMEN_Msk = 0x400
	// Bit CPSMEN.
	SDIO_CMD_CPSMEN = 0x400
	// Position of WAITPEND field.
	SDIO_CMD_WAITPEND_Pos = 0x9
	// Bit mask of WAITPEND field.
	SDIO_CMD_WAITPEND_Msk = 0x200
	// Bit WAITPEND.
	SDIO_CMD_WAITPEND = 0x200
	// Position of WAITINT field.
	SDIO_CMD_WAITINT_Pos = 0x8
	// Bit mask of WAITINT field.
	SDIO_CMD_WAITINT_Msk = 0x100
	// Bit WAITINT.
	SDIO_CMD_WAITINT = 0x100
	// Position of WAITRESP field.
	SDIO_CMD_WAITRESP_Pos = 0x6
	// Bit mask of WAITRESP field.
	SDIO_CMD_WAITRESP_Msk = 0xc0
	// Position of CMDINDEX field.
	SDIO_CMD_CMDINDEX_Pos = 0x0
	// Bit mask of CMDINDEX field.
	SDIO_CMD_CMDINDEX_Msk = 0x3f

	// RESPCMD: command response register
	// Position of RESPCMD field.
	SDIO_RESPCMD_RESPCMD_Pos = 0x0
	// Bit mask of RESPCMD field.
	SDIO_RESPCMD_RESPCMD_Msk = 0x3f

	// RESP1: response 1..4 register
	// Position of CARDSTATUS1 field.
	SDIO_RESP1_CARDSTATUS1_Pos = 0x0
	// Bit mask of CARDSTATUS1 field.
	SDIO_RESP1_CARDSTATUS1_Msk = 0xffffffff

	// RESP2: response 1..4 register
	// Position of CARDSTATUS2 field.
	SDIO_RESP2_CARDSTATUS2_Pos = 0x0
	// Bit mask of CARDSTATUS2 field.
	SDIO_RESP2_CARDSTATUS2_Msk = 0xffffffff

	// RESP3: response 1..4 register
	// Position of CARDSTATUS3 field.
	SDIO_RESP3_CARDSTATUS3_Pos = 0x0
	// Bit mask of CARDSTATUS3 field.
	SDIO_RESP3_CARDSTATUS3_Msk = 0xffffffff

	// RESP4: response 1..4 register
	// Position of CARDSTATUS4 field.
	SDIO_RESP4_CARDSTATUS4_Pos = 0x0
	// Bit mask of CARDSTATUS4 field.
	SDIO_RESP4_CARDSTATUS4_Msk = 0xffffffff

	// DTIMER: data timer register
	// Position of DATATIME field.
	SDIO_DTIMER_DATATIME_Pos = 0x0
	// Bit mask of DATATIME field.
	SDIO_DTIMER_DATATIME_Msk = 0xffffffff

	// DLEN: data length register
	// Position of DATALENGTH field.
	SDIO_DLEN_DATALENGTH_Pos = 0x0
	// Bit mask of DATALENGTH field.
	SDIO_DLEN_DATALENGTH_Msk = 0x1ffffff

	// DCTRL: data control register
	// Position of SDIOEN field.
	SDIO_DCTRL_SDIOEN_Pos = 0xb
	// Bit mask of SDIOEN field.
	SDIO_DCTRL_SDIOEN_Msk = 0x800
	// Bit SDIOEN.
	SDIO_DCTRL_SDIOEN = 0x800
	// Position of RWMOD field.
	SDIO_DCTRL_RWMOD_Pos = 0xa
	// Bit mask of RWMOD field.
	SDIO_DCTRL_RWMOD_Msk = 0x400
	// Bit RWMOD.
	SDIO_DCTRL_RWMOD = 0x400
	// Position of RWSTOP field.
	SDIO_DCTRL_RWSTOP_Pos = 0x9
	// Bit mask of RWSTOP field.
	SDIO_DCTRL_RWSTOP_Msk = 0x200
	// Bit RWSTOP.
	SDIO_DCTRL_RWSTOP = 0x200
	// Position of RWSTART field.
	SDIO_DCTRL_RWSTART_Pos = 0x8
	// Bit mask of RWSTART field.
	SDIO_DCTRL_RWSTART_Msk = 0x100
	// Bit RWSTART.
	SDIO_DCTRL_RWSTART = 0x100
	// Position of DBLOCKSIZE field.
	SDIO_DCTRL_DBLOCKSIZE_Pos = 0x4
	// Bit mask of DBLOCKSIZE field.
	SDIO_DCTRL_DBLOCKSIZE_Msk = 0xf0
	// Position of DMAEN field.
	SDIO_DCTRL_DMAEN_Pos = 0x3
	// Bit mask of DMAEN field.
	SDIO_DCTRL_DMAEN_Msk = 0x8
	// Bit DMAEN.
	SDIO_DCTRL_DMAEN = 0x8
	// Position of DTMODE field.
	SDIO_DCTRL_DTMODE_Pos = 0x2
	// Bit mask of DTMODE field.
	SDIO_DCTRL_DTMODE_Msk = 0x4
	// Bit DTMODE.
	SDIO_DCTRL_DTMODE = 0x4
	// Position of DTDIR field.
	SDIO_DCTRL_DTDIR_Pos = 0x1
	// Bit mask of DTDIR field.
	SDIO_DCTRL_DTDIR_Msk = 0x2
	// Bit DTDIR.
	SDIO_DCTRL_DTDIR = 0x2
	// Position of DTEN field.
	SDIO_DCTRL_DTEN_Pos = 0x0
	// Bit mask of DTEN field.
	SDIO_DCTRL_DTEN_Msk = 0x1
	// Bit DTEN.
	SDIO_DCTRL_DTEN = 0x1

	// DCOUNT: data counter register
	// Position of DATACOUNT field.
	SDIO_DCOUNT_DATACOUNT_Pos = 0x0
	// Bit mask of DATACOUNT field.
	SDIO_DCOUNT_DATACOUNT_Msk = 0x1ffffff

	// STA: status register
	// Position of CEATAEND field.
	SDIO_STA_CEATAEND_Pos = 0x17
	// Bit mask of CEATAEND field.
	SDIO_STA_CEATAEND_Msk = 0x800000
	// Bit CEATAEND.
	SDIO_STA_CEATAEND = 0x800000
	// Position of SDIOIT field.
	SDIO_STA_SDIOIT_Pos = 0x16
	// Bit mask of SDIOIT field.
	SDIO_STA_SDIOIT_Msk = 0x400000
	// Bit SDIOIT.
	SDIO_STA_SDIOIT = 0x400000
	// Position of RXDAVL field.
	SDIO_STA_RXDAVL_Pos = 0x15
	// Bit mask of RXDAVL field.
	SDIO_STA_RXDAVL_Msk = 0x200000
	// Bit RXDAVL.
	SDIO_STA_RXDAVL = 0x200000
	// Position of TXDAVL field.
	SDIO_STA_TXDAVL_Pos = 0x14
	// Bit mask of TXDAVL field.
	SDIO_STA_TXDAVL_Msk = 0x100000
	// Bit TXDAVL.
	SDIO_STA_TXDAVL = 0x100000
	// Position of RXFIFOE field.
	SDIO_STA_RXFIFOE_Pos = 0x13
	// Bit mask of RXFIFOE field.
	SDIO_STA_RXFIFOE_Msk = 0x80000
	// Bit RXFIFOE.
	SDIO_STA_RXFIFOE = 0x80000
	// Position of TXFIFOE field.
	SDIO_STA_TXFIFOE_Pos = 0x12
	// Bit mask of TXFIFOE field.
	SDIO_STA_TXFIFOE_Msk = 0x40000
	// Bit TXFIFOE.
	SDIO_STA_TXFIFOE = 0x40000
	// Position of RXFIFOF field.
	SDIO_STA_RXFIFOF_Pos = 0x11
	// Bit mask of RXFIFOF field.
	SDIO_STA_RXFIFOF_Msk = 0x20000
	// Bit RXFIFOF.
	SDIO_STA_RXFIFOF = 0x20000
	// Position of TXFIFOF field.
	SDIO_STA_TXFIFOF_Pos = 0x10
	// Bit mask of TXFIFOF field.
	SDIO_STA_TXFIFOF_Msk = 0x10000
	// Bit TXFIFOF.
	SDIO_STA_TXFIFOF = 0x10000
	// Position of RXFIFOHF field.
	SDIO_STA_RXFIFOHF_Pos = 0xf
	// Bit mask of RXFIFOHF field.
	SDIO_STA_RXFIFOHF_Msk = 0x8000
	// Bit RXFIFOHF.
	SDIO_STA_RXFIFOHF = 0x8000
	// Position of TXFIFOHE field.
	SDIO_STA_TXFIFOHE_Pos = 0xe
	// Bit mask of TXFIFOHE field.
	SDIO_STA_TXFIFOHE_Msk = 0x4000
	// Bit TXFIFOHE.
	SDIO_STA_TXFIFOHE = 0x4000
	// Position of RXACT field.
	SDIO_STA_RXACT_Pos = 0xd
	// Bit mask of RXACT field.
	SDIO_STA_RXACT_Msk = 0x2000
	// Bit RXACT.
	SDIO_STA_RXACT = 0x2000
	// Position of TXACT field.
	SDIO_STA_TXACT_Pos = 0xc
	// Bit mask of TXACT field.
	SDIO_STA_TXACT_Msk = 0x1000
	// Bit TXACT.
	SDIO_STA_TXACT = 0x1000
	// Position of CMDACT field.
	SDIO_STA_CMDACT_Pos = 0xb
	// Bit mask of CMDACT field.
	SDIO_STA_CMDACT_Msk = 0x800
	// Bit CMDACT.
	SDIO_STA_CMDACT = 0x800
	// Position of DBCKEND field.
	SDIO_STA_DBCKEND_Pos = 0xa
	// Bit mask of DBCKEND field.
	SDIO_STA_DBCKEND_Msk = 0x400
	// Bit DBCKEND.
	SDIO_STA_DBCKEND = 0x400
	// Position of STBITERR field.
	SDIO_STA_STBITERR_Pos = 0x9
	// Bit mask of STBITERR field.
	SDIO_STA_STBITERR_Msk = 0x200
	// Bit STBITERR.
	SDIO_STA_STBITERR = 0x200
	// Position of DATAEND field.
	SDIO_STA_DATAEND_Pos = 0x8
	// Bit mask of DATAEND field.
	SDIO_STA_DATAEND_Msk = 0x100
	// Bit DATAEND.
	SDIO_STA_DATAEND = 0x100
	// Position of CMDSENT field.
	SDIO_STA_CMDSENT_Pos = 0x7
	// Bit mask of CMDSENT field.
	SDIO_STA_CMDSENT_Msk = 0x80
	// Bit CMDSENT.
	SDIO_STA_CMDSENT = 0x80
	// Position of CMDREND field.
	SDIO_STA_CMDREND_Pos = 0x6
	// Bit mask of CMDREND field.
	SDIO_STA_CMDREND_Msk = 0x40
	// Bit CMDREND.
	SDIO_STA_CMDREND = 0x40
	// Position of RXOVERR field.
	SDIO_STA_RXOVERR_Pos = 0x5
	// Bit mask of RXOVERR field.
	SDIO_STA_RXOVERR_Msk = 0x20
	// Bit RXOVERR.
	SDIO_STA_RXOVERR = 0x20
	// Position of TXUNDERR field.
	SDIO_STA_TXUNDERR_Pos = 0x4
	// Bit mask of TXUNDERR field.
	SDIO_STA_TXUNDERR_Msk = 0x10
	// Bit TXUNDERR.
	SDIO_STA_TXUNDERR = 0x10
	// Position of DTIMEOUT field.
	SDIO_STA_DTIMEOUT_Pos = 0x3
	// Bit mask of DTIMEOUT field.
	SDIO_STA_DTIMEOUT_Msk = 0x8
	// Bit DTIMEOUT.
	SDIO_STA_DTIMEOUT = 0x8
	// Position of CTIMEOUT field.
	SDIO_STA_CTIMEOUT_Pos = 0x2
	// Bit mask of CTIMEOUT field.
	SDIO_STA_CTIMEOUT_Msk = 0x4
	// Bit CTIMEOUT.
	SDIO_STA_CTIMEOUT = 0x4
	// Position of DCRCFAIL field.
	SDIO_STA_DCRCFAIL_Pos = 0x1
	// Bit mask of DCRCFAIL field.
	SDIO_STA_DCRCFAIL_Msk = 0x2
	// Bit DCRCFAIL.
	SDIO_STA_DCRCFAIL = 0x2
	// Position of CCRCFAIL field.
	SDIO_STA_CCRCFAIL_Pos = 0x0
	// Bit mask of CCRCFAIL field.
	SDIO_STA_CCRCFAIL_Msk = 0x1
	// Bit CCRCFAIL.
	SDIO_STA_CCRCFAIL = 0x1

	// ICR: interrupt clear register
	// Position of CEATAENDC field.
	SDIO_ICR_CEATAENDC_Pos = 0x17
	// Bit mask of CEATAENDC field.
	SDIO_ICR_CEATAENDC_Msk = 0x800000
	// Bit CEATAENDC.
	SDIO_ICR_CEATAENDC = 0x800000
	// Position of SDIOITC field.
	SDIO_ICR_SDIOITC_Pos = 0x16
	// Bit mask of SDIOITC field.
	SDIO_ICR_SDIOITC_Msk = 0x400000
	// Bit SDIOITC.
	SDIO_ICR_SDIOITC = 0x400000
	// Position of DBCKENDC field.
	SDIO_ICR_DBCKENDC_Pos = 0xa
	// Bit mask of DBCKENDC field.
	SDIO_ICR_DBCKENDC_Msk = 0x400
	// Bit DBCKENDC.
	SDIO_ICR_DBCKENDC = 0x400
	// Position of STBITERRC field.
	SDIO_ICR_STBITERRC_Pos = 0x9
	// Bit mask of STBITERRC field.
	SDIO_ICR_STBITERRC_Msk = 0x200
	// Bit STBITERRC.
	SDIO_ICR_STBITERRC = 0x200
	// Position of DATAENDC field.
	SDIO_ICR_DATAENDC_Pos = 0x8
	// Bit mask of DATAENDC field.
	SDIO_ICR_DATAENDC_Msk = 0x100
	// Bit DATAENDC.
	SDIO_ICR_DATAENDC = 0x100
	// Position of CMDSENTC field.
	SDIO_ICR_CMDSENTC_Pos = 0x7
	// Bit mask of CMDSENTC field.
	SDIO_ICR_CMDSENTC_Msk = 0x80
	// Bit CMDSENTC.
	SDIO_ICR_CMDSENTC = 0x80
	// Position of CMDRENDC field.
	SDIO_ICR_CMDRENDC_Pos = 0x6
	// Bit mask of CMDRENDC field.
	SDIO_ICR_CMDRENDC_Msk = 0x40
	// Bit CMDRENDC.
	SDIO_ICR_CMDRENDC = 0x40
	// Position of RXOVERRC field.
	SDIO_ICR_RXOVERRC_Pos = 0x5
	// Bit mask of RXOVERRC field.
	SDIO_ICR_RXOVERRC_Msk = 0x20
	// Bit RXOVERRC.
	SDIO_ICR_RXOVERRC = 0x20
	// Position of TXUNDERRC field.
	SDIO_ICR_TXUNDERRC_Pos = 0x4
	// Bit mask of TXUNDERRC field.
	SDIO_ICR_TXUNDERRC_Msk = 0x10
	// Bit TXUNDERRC.
	SDIO_ICR_TXUNDERRC = 0x10
	// Position of DTIMEOUTC field.
	SDIO_ICR_DTIMEOUTC_Pos = 0x3
	// Bit mask of DTIMEOUTC field.
	SDIO_ICR_DTIMEOUTC_Msk = 0x8
	// Bit DTIMEOUTC.
	SDIO_ICR_DTIMEOUTC = 0x8
	// Position of CTIMEOUTC field.
	SDIO_ICR_CTIMEOUTC_Pos = 0x2
	// Bit mask of CTIMEOUTC field.
	SDIO_ICR_CTIMEOUTC_Msk = 0x4
	// Bit CTIMEOUTC.
	SDIO_ICR_CTIMEOUTC = 0x4
	// Position of DCRCFAILC field.
	SDIO_ICR_DCRCFAILC_Pos = 0x1
	// Bit mask of DCRCFAILC field.
	SDIO_ICR_DCRCFAILC_Msk = 0x2
	// Bit DCRCFAILC.
	SDIO_ICR_DCRCFAILC = 0x2
	// Position of CCRCFAILC field.
	SDIO_ICR_CCRCFAILC_Pos = 0x0
	// Bit mask of CCRCFAILC field.
	SDIO_ICR_CCRCFAILC_Msk = 0x1
	// Bit CCRCFAILC.
	SDIO_ICR_CCRCFAILC = 0x1

	// MASK: mask register
	// Position of CEATAENDIE field.
	SDIO_MASK_CEATAENDIE_Pos = 0x17
	// Bit mask of CEATAENDIE field.
	SDIO_MASK_CEATAENDIE_Msk = 0x800000
	// Bit CEATAENDIE.
	SDIO_MASK_CEATAENDIE = 0x800000
	// Position of SDIOITIE field.
	SDIO_MASK_SDIOITIE_Pos = 0x16
	// Bit mask of SDIOITIE field.
	SDIO_MASK_SDIOITIE_Msk = 0x400000
	// Bit SDIOITIE.
	SDIO_MASK_SDIOITIE = 0x400000
	// Position of RXDAVLIE field.
	SDIO_MASK_RXDAVLIE_Pos = 0x15
	// Bit mask of RXDAVLIE field.
	SDIO_MASK_RXDAVLIE_Msk = 0x200000
	// Bit RXDAVLIE.
	SDIO_MASK_RXDAVLIE = 0x200000
	// Position of TXDAVLIE field.
	SDIO_MASK_TXDAVLIE_Pos = 0x14
	// Bit mask of TXDAVLIE field.
	SDIO_MASK_TXDAVLIE_Msk = 0x100000
	// Bit TXDAVLIE.
	SDIO_MASK_TXDAVLIE = 0x100000
	// Position of RXFIFOEIE field.
	SDIO_MASK_RXFIFOEIE_Pos = 0x13
	// Bit mask of RXFIFOEIE field.
	SDIO_MASK_RXFIFOEIE_Msk = 0x80000
	// Bit RXFIFOEIE.
	SDIO_MASK_RXFIFOEIE = 0x80000
	// Position of TXFIFOEIE field.
	SDIO_MASK_TXFIFOEIE_Pos = 0x12
	// Bit mask of TXFIFOEIE field.
	SDIO_MASK_TXFIFOEIE_Msk = 0x40000
	// Bit TXFIFOEIE.
	SDIO_MASK_TXFIFOEIE = 0x40000
	// Position of RXFIFOFIE field.
	SDIO_MASK_RXFIFOFIE_Pos = 0x11
	// Bit mask of RXFIFOFIE field.
	SDIO_MASK_RXFIFOFIE_Msk = 0x20000
	// Bit RXFIFOFIE.
	SDIO_MASK_RXFIFOFIE = 0x20000
	// Position of TXFIFOFIE field.
	SDIO_MASK_TXFIFOFIE_Pos = 0x10
	// Bit mask of TXFIFOFIE field.
	SDIO_MASK_TXFIFOFIE_Msk = 0x10000
	// Bit TXFIFOFIE.
	SDIO_MASK_TXFIFOFIE = 0x10000
	// Position of RXFIFOHFIE field.
	SDIO_MASK_RXFIFOHFIE_Pos = 0xf
	// Bit mask of RXFIFOHFIE field.
	SDIO_MASK_RXFIFOHFIE_Msk = 0x8000
	// Bit RXFIFOHFIE.
	SDIO_MASK_RXFIFOHFIE = 0x8000
	// Position of TXFIFOHEIE field.
	SDIO_MASK_TXFIFOHEIE_Pos = 0xe
	// Bit mask of TXFIFOHEIE field.
	SDIO_MASK_TXFIFOHEIE_Msk = 0x4000
	// Bit TXFIFOHEIE.
	SDIO_MASK_TXFIFOHEIE = 0x4000
	// Position of RXACTIE field.
	SDIO_MASK_RXACTIE_Pos = 0xd
	// Bit mask of RXACTIE field.
	SDIO_MASK_RXACTIE_Msk = 0x2000
	// Bit RXACTIE.
	SDIO_MASK_RXACTIE = 0x2000
	// Position of TXACTIE field.
	SDIO_MASK_TXACTIE_Pos = 0xc
	// Bit mask of TXACTIE field.
	SDIO_MASK_TXACTIE_Msk = 0x1000
	// Bit TXACTIE.
	SDIO_MASK_TXACTIE = 0x1000
	// Position of CMDACTIE field.
	SDIO_MASK_CMDACTIE_Pos = 0xb
	// Bit mask of CMDACTIE field.
	SDIO_MASK_CMDACTIE_Msk = 0x800
	// Bit CMDACTIE.
	SDIO_MASK_CMDACTIE = 0x800
	// Position of DBCKENDIE field.
	SDIO_MASK_DBCKENDIE_Pos = 0xa
	// Bit mask of DBCKENDIE field.
	SDIO_MASK_DBCKENDIE_Msk = 0x400
	// Bit DBCKENDIE.
	SDIO_MASK_DBCKENDIE = 0x400
	// Position of STBITERRIE field.
	SDIO_MASK_STBITERRIE_Pos = 0x9
	// Bit mask of STBITERRIE field.
	SDIO_MASK_STBITERRIE_Msk = 0x200
	// Bit STBITERRIE.
	SDIO_MASK_STBITERRIE = 0x200
	// Position of DATAENDIE field.
	SDIO_MASK_DATAENDIE_Pos = 0x8
	// Bit mask of DATAENDIE field.
	SDIO_MASK_DATAENDIE_Msk = 0x100
	// Bit DATAENDIE.
	SDIO_MASK_DATAENDIE = 0x100
	// Position of CMDSENTIE field.
	SDIO_MASK_CMDSENTIE_Pos = 0x7
	// Bit mask of CMDSENTIE field.
	SDIO_MASK_CMDSENTIE_Msk = 0x80
	// Bit CMDSENTIE.
	SDIO_MASK_CMDSENTIE = 0x80
	// Position of CMDRENDIE field.
	SDIO_MASK_CMDRENDIE_Pos = 0x6
	// Bit mask of CMDRENDIE field.
	SDIO_MASK_CMDRENDIE_Msk = 0x40
	// Bit CMDRENDIE.
	SDIO_MASK_CMDRENDIE = 0x40
	// Position of RXOVERRIE field.
	SDIO_MASK_RXOVERRIE_Pos = 0x5
	// Bit mask of RXOVERRIE field.
	SDIO_MASK_RXOVERRIE_Msk = 0x20
	// Bit RXOVERRIE.
	SDIO_MASK_RXOVERRIE = 0x20
	// Position of TXUNDERRIE field.
	SDIO_MASK_TXUNDERRIE_Pos = 0x4
	// Bit mask of TXUNDERRIE field.
	SDIO_MASK_TXUNDERRIE_Msk = 0x10
	// Bit TXUNDERRIE.
	SDIO_MASK_TXUNDERRIE = 0x10
	// Position of DTIMEOUTIE field.
	SDIO_MASK_DTIMEOUTIE_Pos = 0x3
	// Bit mask of DTIMEOUTIE field.
	SDIO_MASK_DTIMEOUTIE_Msk = 0x8
	// Bit DTIMEOUTIE.
	SDIO_MASK_DTIMEOUTIE = 0x8
	// Position of CTIMEOUTIE field.
	SDIO_MASK_CTIMEOUTIE_Pos = 0x2
	// Bit mask of CTIMEOUTIE field.
	SDIO_MASK_CTIMEOUTIE_Msk = 0x4
	// Bit CTIMEOUTIE.
	SDIO_MASK_CTIMEOUTIE = 0x4
	// Position of DCRCFAILIE field.
	SDIO_MASK_DCRCFAILIE_Pos = 0x1
	// Bit mask of DCRCFAILIE field.
	SDIO_MASK_DCRCFAILIE_Msk = 0x2
	// Bit DCRCFAILIE.
	SDIO_MASK_DCRCFAILIE = 0x2
	// Position of CCRCFAILIE field.
	SDIO_MASK_CCRCFAILIE_Pos = 0x0
	// Bit mask of CCRCFAILIE field.
	SDIO_MASK_CCRCFAILIE_Msk = 0x1
	// Bit CCRCFAILIE.
	SDIO_MASK_CCRCFAILIE = 0x1

	// FIFOCNT: FIFO counter register
	// Position of FIFOCOUNT field.
	SDIO_FIFOCNT_FIFOCOUNT_Pos = 0x0
	// Bit mask of FIFOCOUNT field.
	SDIO_FIFOCNT_FIFOCOUNT_Msk = 0xffffff

	// FIFO: data FIFO register
	// Position of FIFOData field.
	SDIO_FIFO_FIFOData_Pos = 0x0
	// Bit mask of FIFOData field.
	SDIO_FIFO_FIFOData_Msk = 0xffffffff
)

// Constants for ADC1: Analog-to-digital converter
const (
	// SR: status register
	// Position of OVR field.
	ADC_SR_OVR_Pos = 0x5
	// Bit mask of OVR field.
	ADC_SR_OVR_Msk = 0x20
	// Bit OVR.
	ADC_SR_OVR = 0x20
	// No overrun occurred
	ADC_SR_OVR_NoOverrun = 0x0
	// Overrun occurred
	ADC_SR_OVR_Overrun = 0x1
	// Position of STRT field.
	ADC_SR_STRT_Pos = 0x4
	// Bit mask of STRT field.
	ADC_SR_STRT_Msk = 0x10
	// Bit STRT.
	ADC_SR_STRT = 0x10
	// No regular channel conversion started
	ADC_SR_STRT_NotStarted = 0x0
	// Regular channel conversion has started
	ADC_SR_STRT_Started = 0x1
	// Position of JSTRT field.
	ADC_SR_JSTRT_Pos = 0x3
	// Bit mask of JSTRT field.
	ADC_SR_JSTRT_Msk = 0x8
	// Bit JSTRT.
	ADC_SR_JSTRT = 0x8
	// No injected channel conversion started
	ADC_SR_JSTRT_NotStarted = 0x0
	// Injected channel conversion has started
	ADC_SR_JSTRT_Started = 0x1
	// Position of JEOC field.
	ADC_SR_JEOC_Pos = 0x2
	// Bit mask of JEOC field.
	ADC_SR_JEOC_Msk = 0x4
	// Bit JEOC.
	ADC_SR_JEOC = 0x4
	// Conversion is not complete
	ADC_SR_JEOC_NotComplete = 0x0
	// Conversion complete
	ADC_SR_JEOC_Complete = 0x1
	// Position of EOC field.
	ADC_SR_EOC_Pos = 0x1
	// Bit mask of EOC field.
	ADC_SR_EOC_Msk = 0x2
	// Bit EOC.
	ADC_SR_EOC = 0x2
	// Conversion is not complete
	ADC_SR_EOC_NotComplete = 0x0
	// Conversion complete
	ADC_SR_EOC_Complete = 0x1
	// Position of AWD field.
	ADC_SR_AWD_Pos = 0x0
	// Bit mask of AWD field.
	ADC_SR_AWD_Msk = 0x1
	// Bit AWD.
	ADC_SR_AWD = 0x1
	// No analog watchdog event occurred
	ADC_SR_AWD_NoEvent = 0x0
	// Analog watchdog event occurred
	ADC_SR_AWD_Event = 0x1

	// CR1: control register 1
	// Position of OVRIE field.
	ADC_CR1_OVRIE_Pos = 0x1a
	// Bit mask of OVRIE field.
	ADC_CR1_OVRIE_Msk = 0x4000000
	// Bit OVRIE.
	ADC_CR1_OVRIE = 0x4000000
	// Overrun interrupt disabled
	ADC_CR1_OVRIE_Disabled = 0x0
	// Overrun interrupt enabled
	ADC_CR1_OVRIE_Enabled = 0x1
	// Position of RES field.
	ADC_CR1_RES_Pos = 0x18
	// Bit mask of RES field.
	ADC_CR1_RES_Msk = 0x3000000
	// 12-bit (15 ADCCLK cycles)
	ADC_CR1_RES_TwelveBit = 0x0
	// 10-bit (13 ADCCLK cycles)
	ADC_CR1_RES_TenBit = 0x1
	// 8-bit (11 ADCCLK cycles)
	ADC_CR1_RES_EightBit = 0x2
	// 6-bit (9 ADCCLK cycles)
	ADC_CR1_RES_SixBit = 0x3
	// Position of AWDEN field.
	ADC_CR1_AWDEN_Pos = 0x17
	// Bit mask of AWDEN field.
	ADC_CR1_AWDEN_Msk = 0x800000
	// Bit AWDEN.
	ADC_CR1_AWDEN = 0x800000
	// Analog watchdog disabled on regular channels
	ADC_CR1_AWDEN_Disabled = 0x0
	// Analog watchdog enabled on regular channels
	ADC_CR1_AWDEN_Enabled = 0x1
	// Position of JAWDEN field.
	ADC_CR1_JAWDEN_Pos = 0x16
	// Bit mask of JAWDEN field.
	ADC_CR1_JAWDEN_Msk = 0x400000
	// Bit JAWDEN.
	ADC_CR1_JAWDEN = 0x400000
	// Analog watchdog disabled on injected channels
	ADC_CR1_JAWDEN_Disabled = 0x0
	// Analog watchdog enabled on injected channels
	ADC_CR1_JAWDEN_Enabled = 0x1
	// Position of DISCNUM field.
	ADC_CR1_DISCNUM_Pos = 0xd
	// Bit mask of DISCNUM field.
	ADC_CR1_DISCNUM_Msk = 0xe000
	// Position of JDISCEN field.
	ADC_CR1_JDISCEN_Pos = 0xc
	// Bit mask of JDISCEN field.
	ADC_CR1_JDISCEN_Msk = 0x1000
	// Bit JDISCEN.
	ADC_CR1_JDISCEN = 0x1000
	// Discontinuous mode on injected channels disabled
	ADC_CR1_JDISCEN_Disabled = 0x0
	// Discontinuous mode on injected channels enabled
	ADC_CR1_JDISCEN_Enabled = 0x1
	// Position of DISCEN field.
	ADC_CR1_DISCEN_Pos = 0xb
	// Bit mask of DISCEN field.
	ADC_CR1_DISCEN_Msk = 0x800
	// Bit DISCEN.
	ADC_CR1_DISCEN = 0x800
	// Discontinuous mode on regular channels disabled
	ADC_CR1_DISCEN_Disabled = 0x0
	// Discontinuous mode on regular channels enabled
	ADC_CR1_DISCEN_Enabled = 0x1
	// Position of JAUTO field.
	ADC_CR1_JAUTO_Pos = 0xa
	// Bit mask of JAUTO field.
	ADC_CR1_JAUTO_Msk = 0x400
	// Bit JAUTO.
	ADC_CR1_JAUTO = 0x400
	// Automatic injected group conversion disabled
	ADC_CR1_JAUTO_Disabled = 0x0
	// Automatic injected group conversion enabled
	ADC_CR1_JAUTO_Enabled = 0x1
	// Position of AWDSGL field.
	ADC_CR1_AWDSGL_Pos = 0x9
	// Bit mask of AWDSGL field.
	ADC_CR1_AWDSGL_Msk = 0x200
	// Bit AWDSGL.
	ADC_CR1_AWDSGL = 0x200
	// Analog watchdog enabled on all channels
	ADC_CR1_AWDSGL_AllChannels = 0x0
	// Analog watchdog enabled on a single channel
	ADC_CR1_AWDSGL_SingleChannel = 0x1
	// Position of SCAN field.
	ADC_CR1_SCAN_Pos = 0x8
	// Bit mask of SCAN field.
	ADC_CR1_SCAN_Msk = 0x100
	// Bit SCAN.
	ADC_CR1_SCAN = 0x100
	// Scan mode disabled
	ADC_CR1_SCAN_Disabled = 0x0
	// Scan mode enabled
	ADC_CR1_SCAN_Enabled = 0x1
	// Position of JEOCIE field.
	ADC_CR1_JEOCIE_Pos = 0x7
	// Bit mask of JEOCIE field.
	ADC_CR1_JEOCIE_Msk = 0x80
	// Bit JEOCIE.
	ADC_CR1_JEOCIE = 0x80
	// JEOC interrupt disabled
	ADC_CR1_JEOCIE_Disabled = 0x0
	// JEOC interrupt enabled
	ADC_CR1_JEOCIE_Enabled = 0x1
	// Position of AWDIE field.
	ADC_CR1_AWDIE_Pos = 0x6
	// Bit mask of AWDIE field.
	ADC_CR1_AWDIE_Msk = 0x40
	// Bit AWDIE.
	ADC_CR1_AWDIE = 0x40
	// Analogue watchdog interrupt disabled
	ADC_CR1_AWDIE_Disabled = 0x0
	// Analogue watchdog interrupt enabled
	ADC_CR1_AWDIE_Enabled = 0x1
	// Position of EOCIE field.
	ADC_CR1_EOCIE_Pos = 0x5
	// Bit mask of EOCIE field.
	ADC_CR1_EOCIE_Msk = 0x20
	// Bit EOCIE.
	ADC_CR1_EOCIE = 0x20
	// EOC interrupt disabled
	ADC_CR1_EOCIE_Disabled = 0x0
	// EOC interrupt enabled
	ADC_CR1_EOCIE_Enabled = 0x1
	// Position of AWDCH field.
	ADC_CR1_AWDCH_Pos = 0x0
	// Bit mask of AWDCH field.
	ADC_CR1_AWDCH_Msk = 0x1f

	// CR2: control register 2
	// Position of SWSTART field.
	ADC_CR2_SWSTART_Pos = 0x1e
	// Bit mask of SWSTART field.
	ADC_CR2_SWSTART_Msk = 0x40000000
	// Bit SWSTART.
	ADC_CR2_SWSTART = 0x40000000
	// Starts conversion of regular channels
	ADC_CR2_SWSTART_Start = 0x1
	// Position of EXTEN field.
	ADC_CR2_EXTEN_Pos = 0x1c
	// Bit mask of EXTEN field.
	ADC_CR2_EXTEN_Msk = 0x30000000
	// Trigger detection disabled
	ADC_CR2_EXTEN_Disabled = 0x0
	// Trigger detection on the rising edge
	ADC_CR2_EXTEN_RisingEdge = 0x1
	// Trigger detection on the falling edge
	ADC_CR2_EXTEN_FallingEdge = 0x2
	// Trigger detection on both the rising and falling edges
	ADC_CR2_EXTEN_BothEdges = 0x3
	// Position of EXTSEL field.
	ADC_CR2_EXTSEL_Pos = 0x18
	// Bit mask of EXTSEL field.
	ADC_CR2_EXTSEL_Msk = 0xf000000
	// Timer 1 CC1 event
	ADC_CR2_EXTSEL_TIM1CC1 = 0x0
	// Timer 1 CC2 event
	ADC_CR2_EXTSEL_TIM1CC2 = 0x1
	// Timer 1 CC3 event
	ADC_CR2_EXTSEL_TIM1CC3 = 0x2
	// Timer 2 CC2 event
	ADC_CR2_EXTSEL_TIM2CC2 = 0x3
	// Timer 2 CC3 event
	ADC_CR2_EXTSEL_TIM2CC3 = 0x4
	// Timer 2 CC4 event
	ADC_CR2_EXTSEL_TIM2CC4 = 0x5
	// Timer 2 TRGO event
	ADC_CR2_EXTSEL_TIM2TRGO = 0x6
	// Position of JSWSTART field.
	ADC_CR2_JSWSTART_Pos = 0x16
	// Bit mask of JSWSTART field.
	ADC_CR2_JSWSTART_Msk = 0x400000
	// Bit JSWSTART.
	ADC_CR2_JSWSTART = 0x400000
	// Starts conversion of injected channels
	ADC_CR2_JSWSTART_Start = 0x1
	// Position of JEXTEN field.
	ADC_CR2_JEXTEN_Pos = 0x14
	// Bit mask of JEXTEN field.
	ADC_CR2_JEXTEN_Msk = 0x300000
	// Trigger detection disabled
	ADC_CR2_JEXTEN_Disabled = 0x0
	// Trigger detection on the rising edge
	ADC_CR2_JEXTEN_RisingEdge = 0x1
	// Trigger detection on the falling edge
	ADC_CR2_JEXTEN_FallingEdge = 0x2
	// Trigger detection on both the rising and falling edges
	ADC_CR2_JEXTEN_BothEdges = 0x3
	// Position of JEXTSEL field.
	ADC_CR2_JEXTSEL_Pos = 0x10
	// Bit mask of JEXTSEL field.
	ADC_CR2_JEXTSEL_Msk = 0xf0000
	// Timer 1 TRGO event
	ADC_CR2_JEXTSEL_TIM1TRGO = 0x0
	// Timer 1 CC4 event
	ADC_CR2_JEXTSEL_TIM1CC4 = 0x1
	// Timer 2 TRGO event
	ADC_CR2_JEXTSEL_TIM2TRGO = 0x2
	// Timer 2 CC1 event
	ADC_CR2_JEXTSEL_TIM2CC1 = 0x3
	// Timer 3 CC4 event
	ADC_CR2_JEXTSEL_TIM3CC4 = 0x4
	// Timer 4 TRGO event
	ADC_CR2_JEXTSEL_TIM4TRGO = 0x5
	// Timer 8 CC4 event
	ADC_CR2_JEXTSEL_TIM8CC4 = 0x7
	// Timer 1 TRGO(2) event
	ADC_CR2_JEXTSEL_TIM1TRGO2 = 0x8
	// Timer 8 TRGO event
	ADC_CR2_JEXTSEL_TIM8TRGO = 0x9
	// Timer 8 TRGO(2) event
	ADC_CR2_JEXTSEL_TIM8TRGO2 = 0xa
	// Timer 3 CC3 event
	ADC_CR2_JEXTSEL_TIM3CC3 = 0xb
	// Timer 5 TRGO event
	ADC_CR2_JEXTSEL_TIM5TRGO = 0xc
	// Timer 3 CC1 event
	ADC_CR2_JEXTSEL_TIM3CC1 = 0xd
	// Timer 6 TRGO event
	ADC_CR2_JEXTSEL_TIM6TRGO = 0xe
	// Position of ALIGN field.
	ADC_CR2_ALIGN_Pos = 0xb
	// Bit mask of ALIGN field.
	ADC_CR2_ALIGN_Msk = 0x800
	// Bit ALIGN.
	ADC_CR2_ALIGN = 0x800
	// Right alignment
	ADC_CR2_ALIGN_Right = 0x0
	// Left alignment
	ADC_CR2_ALIGN_Left = 0x1
	// Position of EOCS field.
	ADC_CR2_EOCS_Pos = 0xa
	// Bit mask of EOCS field.
	ADC_CR2_EOCS_Msk = 0x400
	// Bit EOCS.
	ADC_CR2_EOCS = 0x400
	// The EOC bit is set at the end of each sequence of regular conversions
	ADC_CR2_EOCS_EachSequence = 0x0
	// The EOC bit is set at the end of each regular conversion
	ADC_CR2_EOCS_EachConversion = 0x1
	// Position of DDS field.
	ADC_CR2_DDS_Pos = 0x9
	// Bit mask of DDS field.
	ADC_CR2_DDS_Msk = 0x200
	// Bit DDS.
	ADC_CR2_DDS = 0x200
	// No new DMA request is issued after the last transfer
	ADC_CR2_DDS_Single = 0x0
	// DMA requests are issued as long as data are converted and DMA=1
	ADC_CR2_DDS_Continuous = 0x1
	// Position of DMA field.
	ADC_CR2_DMA_Pos = 0x8
	// Bit mask of DMA field.
	ADC_CR2_DMA_Msk = 0x100
	// Bit DMA.
	ADC_CR2_DMA = 0x100
	// DMA mode disabled
	ADC_CR2_DMA_Disabled = 0x0
	// DMA mode enabled
	ADC_CR2_DMA_Enabled = 0x1
	// Position of CONT field.
	ADC_CR2_CONT_Pos = 0x1
	// Bit mask of CONT field.
	ADC_CR2_CONT_Msk = 0x2
	// Bit CONT.
	ADC_CR2_CONT = 0x2
	// Single conversion mode
	ADC_CR2_CONT_Single = 0x0
	// Continuous conversion mode
	ADC_CR2_CONT_Continuous = 0x1
	// Position of ADON field.
	ADC_CR2_ADON_Pos = 0x0
	// Bit mask of ADON field.
	ADC_CR2_ADON_Msk = 0x1
	// Bit ADON.
	ADC_CR2_ADON = 0x1
	// Disable ADC conversion and go to power down mode
	ADC_CR2_ADON_Disabled = 0x0
	// Enable ADC
	ADC_CR2_ADON_Enabled = 0x1

	// SMPR1: sample time register 1
	// Position of SMP10 field.
	ADC_SMPR1_SMP10_Pos = 0x0
	// Bit mask of SMP10 field.
	ADC_SMPR1_SMP10_Msk = 0x7
	// 3 cycles
	ADC_SMPR1_SMP10_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP10_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP10_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP10_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP10_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP10_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP10_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP10_Cycles480 = 0x7
	// Position of SMP11 field.
	ADC_SMPR1_SMP11_Pos = 0x3
	// Bit mask of SMP11 field.
	ADC_SMPR1_SMP11_Msk = 0x38
	// 3 cycles
	ADC_SMPR1_SMP11_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP11_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP11_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP11_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP11_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP11_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP11_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP11_Cycles480 = 0x7
	// Position of SMP12 field.
	ADC_SMPR1_SMP12_Pos = 0x6
	// Bit mask of SMP12 field.
	ADC_SMPR1_SMP12_Msk = 0x1c0
	// 3 cycles
	ADC_SMPR1_SMP12_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP12_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP12_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP12_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP12_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP12_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP12_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP12_Cycles480 = 0x7
	// Position of SMP13 field.
	ADC_SMPR1_SMP13_Pos = 0x9
	// Bit mask of SMP13 field.
	ADC_SMPR1_SMP13_Msk = 0xe00
	// 3 cycles
	ADC_SMPR1_SMP13_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP13_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP13_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP13_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP13_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP13_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP13_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP13_Cycles480 = 0x7
	// Position of SMP14 field.
	ADC_SMPR1_SMP14_Pos = 0xc
	// Bit mask of SMP14 field.
	ADC_SMPR1_SMP14_Msk = 0x7000
	// 3 cycles
	ADC_SMPR1_SMP14_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP14_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP14_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP14_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP14_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP14_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP14_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP14_Cycles480 = 0x7
	// Position of SMP15 field.
	ADC_SMPR1_SMP15_Pos = 0xf
	// Bit mask of SMP15 field.
	ADC_SMPR1_SMP15_Msk = 0x38000
	// 3 cycles
	ADC_SMPR1_SMP15_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP15_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP15_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP15_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP15_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP15_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP15_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP15_Cycles480 = 0x7
	// Position of SMP16 field.
	ADC_SMPR1_SMP16_Pos = 0x12
	// Bit mask of SMP16 field.
	ADC_SMPR1_SMP16_Msk = 0x1c0000
	// 3 cycles
	ADC_SMPR1_SMP16_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP16_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP16_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP16_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP16_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP16_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP16_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP16_Cycles480 = 0x7
	// Position of SMP17 field.
	ADC_SMPR1_SMP17_Pos = 0x15
	// Bit mask of SMP17 field.
	ADC_SMPR1_SMP17_Msk = 0xe00000
	// 3 cycles
	ADC_SMPR1_SMP17_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP17_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP17_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP17_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP17_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP17_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP17_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP17_Cycles480 = 0x7
	// Position of SMP18 field.
	ADC_SMPR1_SMP18_Pos = 0x18
	// Bit mask of SMP18 field.
	ADC_SMPR1_SMP18_Msk = 0x7000000
	// 3 cycles
	ADC_SMPR1_SMP18_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP18_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP18_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP18_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP18_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP18_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP18_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP18_Cycles480 = 0x7

	// SMPR2: sample time register 2
	// Position of SMP0 field.
	ADC_SMPR2_SMP0_Pos = 0x0
	// Bit mask of SMP0 field.
	ADC_SMPR2_SMP0_Msk = 0x7
	// 3 cycles
	ADC_SMPR2_SMP0_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP0_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP0_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP0_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP0_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP0_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP0_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP0_Cycles480 = 0x7
	// Position of SMP1 field.
	ADC_SMPR2_SMP1_Pos = 0x3
	// Bit mask of SMP1 field.
	ADC_SMPR2_SMP1_Msk = 0x38
	// 3 cycles
	ADC_SMPR2_SMP1_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP1_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP1_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP1_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP1_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP1_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP1_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP1_Cycles480 = 0x7
	// Position of SMP2 field.
	ADC_SMPR2_SMP2_Pos = 0x6
	// Bit mask of SMP2 field.
	ADC_SMPR2_SMP2_Msk = 0x1c0
	// 3 cycles
	ADC_SMPR2_SMP2_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP2_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP2_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP2_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP2_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP2_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP2_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP2_Cycles480 = 0x7
	// Position of SMP3 field.
	ADC_SMPR2_SMP3_Pos = 0x9
	// Bit mask of SMP3 field.
	ADC_SMPR2_SMP3_Msk = 0xe00
	// 3 cycles
	ADC_SMPR2_SMP3_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP3_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP3_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP3_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP3_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP3_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP3_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP3_Cycles480 = 0x7
	// Position of SMP4 field.
	ADC_SMPR2_SMP4_Pos = 0xc
	// Bit mask of SMP4 field.
	ADC_SMPR2_SMP4_Msk = 0x7000
	// 3 cycles
	ADC_SMPR2_SMP4_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP4_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP4_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP4_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP4_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP4_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP4_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP4_Cycles480 = 0x7
	// Position of SMP5 field.
	ADC_SMPR2_SMP5_Pos = 0xf
	// Bit mask of SMP5 field.
	ADC_SMPR2_SMP5_Msk = 0x38000
	// 3 cycles
	ADC_SMPR2_SMP5_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP5_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP5_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP5_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP5_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP5_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP5_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP5_Cycles480 = 0x7
	// Position of SMP6 field.
	ADC_SMPR2_SMP6_Pos = 0x12
	// Bit mask of SMP6 field.
	ADC_SMPR2_SMP6_Msk = 0x1c0000
	// 3 cycles
	ADC_SMPR2_SMP6_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP6_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP6_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP6_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP6_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP6_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP6_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP6_Cycles480 = 0x7
	// Position of SMP7 field.
	ADC_SMPR2_SMP7_Pos = 0x15
	// Bit mask of SMP7 field.
	ADC_SMPR2_SMP7_Msk = 0xe00000
	// 3 cycles
	ADC_SMPR2_SMP7_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP7_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP7_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP7_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP7_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP7_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP7_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP7_Cycles480 = 0x7
	// Position of SMP8 field.
	ADC_SMPR2_SMP8_Pos = 0x18
	// Bit mask of SMP8 field.
	ADC_SMPR2_SMP8_Msk = 0x7000000
	// 3 cycles
	ADC_SMPR2_SMP8_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP8_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP8_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP8_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP8_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP8_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP8_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP8_Cycles480 = 0x7
	// Position of SMP9 field.
	ADC_SMPR2_SMP9_Pos = 0x1b
	// Bit mask of SMP9 field.
	ADC_SMPR2_SMP9_Msk = 0x38000000
	// 3 cycles
	ADC_SMPR2_SMP9_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP9_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP9_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP9_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP9_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP9_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP9_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP9_Cycles480 = 0x7

	// JOFR1: injected channel data offset register x
	// Position of JOFFSET field.
	ADC_JOFR_JOFFSET_Pos = 0x0
	// Bit mask of JOFFSET field.
	ADC_JOFR_JOFFSET_Msk = 0xfff

	// HTR: watchdog higher threshold register
	// Position of HT field.
	ADC_HTR_HT_Pos = 0x0
	// Bit mask of HT field.
	ADC_HTR_HT_Msk = 0xfff

	// LTR: watchdog lower threshold register
	// Position of LT field.
	ADC_LTR_LT_Pos = 0x0
	// Bit mask of LT field.
	ADC_LTR_LT_Msk = 0xfff

	// SQR1: regular sequence register 1
	// Position of L field.
	ADC_SQR1_L_Pos = 0x14
	// Bit mask of L field.
	ADC_SQR1_L_Msk = 0xf00000
	// Position of SQ16 field.
	ADC_SQR1_SQ16_Pos = 0xf
	// Bit mask of SQ16 field.
	ADC_SQR1_SQ16_Msk = 0xf8000
	// Position of SQ15 field.
	ADC_SQR1_SQ15_Pos = 0xa
	// Bit mask of SQ15 field.
	ADC_SQR1_SQ15_Msk = 0x7c00
	// Position of SQ14 field.
	ADC_SQR1_SQ14_Pos = 0x5
	// Bit mask of SQ14 field.
	ADC_SQR1_SQ14_Msk = 0x3e0
	// Position of SQ13 field.
	ADC_SQR1_SQ13_Pos = 0x0
	// Bit mask of SQ13 field.
	ADC_SQR1_SQ13_Msk = 0x1f

	// SQR2: regular sequence register 2
	// Position of SQ12 field.
	ADC_SQR2_SQ12_Pos = 0x19
	// Bit mask of SQ12 field.
	ADC_SQR2_SQ12_Msk = 0x3e000000
	// Position of SQ11 field.
	ADC_SQR2_SQ11_Pos = 0x14
	// Bit mask of SQ11 field.
	ADC_SQR2_SQ11_Msk = 0x1f00000
	// Position of SQ10 field.
	ADC_SQR2_SQ10_Pos = 0xf
	// Bit mask of SQ10 field.
	ADC_SQR2_SQ10_Msk = 0xf8000
	// Position of SQ9 field.
	ADC_SQR2_SQ9_Pos = 0xa
	// Bit mask of SQ9 field.
	ADC_SQR2_SQ9_Msk = 0x7c00
	// Position of SQ8 field.
	ADC_SQR2_SQ8_Pos = 0x5
	// Bit mask of SQ8 field.
	ADC_SQR2_SQ8_Msk = 0x3e0
	// Position of SQ7 field.
	ADC_SQR2_SQ7_Pos = 0x0
	// Bit mask of SQ7 field.
	ADC_SQR2_SQ7_Msk = 0x1f

	// SQR3: regular sequence register 3
	// Position of SQ6 field.
	ADC_SQR3_SQ6_Pos = 0x19
	// Bit mask of SQ6 field.
	ADC_SQR3_SQ6_Msk = 0x3e000000
	// Position of SQ5 field.
	ADC_SQR3_SQ5_Pos = 0x14
	// Bit mask of SQ5 field.
	ADC_SQR3_SQ5_Msk = 0x1f00000
	// Position of SQ4 field.
	ADC_SQR3_SQ4_Pos = 0xf
	// Bit mask of SQ4 field.
	ADC_SQR3_SQ4_Msk = 0xf8000
	// Position of SQ3 field.
	ADC_SQR3_SQ3_Pos = 0xa
	// Bit mask of SQ3 field.
	ADC_SQR3_SQ3_Msk = 0x7c00
	// Position of SQ2 field.
	ADC_SQR3_SQ2_Pos = 0x5
	// Bit mask of SQ2 field.
	ADC_SQR3_SQ2_Msk = 0x3e0
	// Position of SQ1 field.
	ADC_SQR3_SQ1_Pos = 0x0
	// Bit mask of SQ1 field.
	ADC_SQR3_SQ1_Msk = 0x1f

	// JSQR: injected sequence register
	// Position of JL field.
	ADC_JSQR_JL_Pos = 0x14
	// Bit mask of JL field.
	ADC_JSQR_JL_Msk = 0x300000
	// Position of JSQ4 field.
	ADC_JSQR_JSQ4_Pos = 0xf
	// Bit mask of JSQ4 field.
	ADC_JSQR_JSQ4_Msk = 0xf8000
	// Position of JSQ3 field.
	ADC_JSQR_JSQ3_Pos = 0xa
	// Bit mask of JSQ3 field.
	ADC_JSQR_JSQ3_Msk = 0x7c00
	// Position of JSQ2 field.
	ADC_JSQR_JSQ2_Pos = 0x5
	// Bit mask of JSQ2 field.
	ADC_JSQR_JSQ2_Msk = 0x3e0
	// Position of JSQ1 field.
	ADC_JSQR_JSQ1_Pos = 0x0
	// Bit mask of JSQ1 field.
	ADC_JSQR_JSQ1_Msk = 0x1f

	// JDR1: injected data register x
	// Position of JDATA field.
	ADC_JDR_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR_JDATA_Msk = 0xffff

	// DR: regular data register
	// Position of DATA field.
	ADC_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_DR_DATA_Msk = 0xffff
)

// Constants for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// SR: Status register
	// Position of CTS field.
	USART_SR_CTS_Pos = 0x9
	// Bit mask of CTS field.
	USART_SR_CTS_Msk = 0x200
	// Bit CTS.
	USART_SR_CTS = 0x200
	// Position of LBD field.
	USART_SR_LBD_Pos = 0x8
	// Bit mask of LBD field.
	USART_SR_LBD_Msk = 0x100
	// Bit LBD.
	USART_SR_LBD = 0x100
	// Position of TXE field.
	USART_SR_TXE_Pos = 0x7
	// Bit mask of TXE field.
	USART_SR_TXE_Msk = 0x80
	// Bit TXE.
	USART_SR_TXE = 0x80
	// Position of TC field.
	USART_SR_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_SR_TC_Msk = 0x40
	// Bit TC.
	USART_SR_TC = 0x40
	// Position of RXNE field.
	USART_SR_RXNE_Pos = 0x5
	// Bit mask of RXNE field.
	USART_SR_RXNE_Msk = 0x20
	// Bit RXNE.
	USART_SR_RXNE = 0x20
	// Position of IDLE field.
	USART_SR_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_SR_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_SR_IDLE = 0x10
	// Position of ORE field.
	USART_SR_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_SR_ORE_Msk = 0x8
	// Bit ORE.
	USART_SR_ORE = 0x8
	// Position of NF field.
	USART_SR_NF_Pos = 0x2
	// Bit mask of NF field.
	USART_SR_NF_Msk = 0x4
	// Bit NF.
	USART_SR_NF = 0x4
	// Position of FE field.
	USART_SR_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_SR_FE_Msk = 0x2
	// Bit FE.
	USART_SR_FE = 0x2
	// Position of PE field.
	USART_SR_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_SR_PE_Msk = 0x1
	// Bit PE.
	USART_SR_PE = 0x1

	// DR: Data register
	// Position of DR field.
	USART_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	USART_DR_DR_Msk = 0x1ff

	// BRR: Baud rate register
	// Position of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Pos = 0x4
	// Bit mask of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Msk = 0xfff0
	// Position of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Pos = 0x0
	// Bit mask of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Msk = 0xf

	// CR1: Control register 1
	// Position of OVER8 field.
	USART_CR1_OVER8_Pos = 0xf
	// Bit mask of OVER8 field.
	USART_CR1_OVER8_Msk = 0x8000
	// Bit OVER8.
	USART_CR1_OVER8 = 0x8000
	// Oversampling by 16
	USART_CR1_OVER8_Oversample16 = 0x0
	// Oversampling by 8
	USART_CR1_OVER8_Oversample8 = 0x1
	// Position of UE field.
	USART_CR1_UE_Pos = 0xd
	// Bit mask of UE field.
	USART_CR1_UE_Msk = 0x2000
	// Bit UE.
	USART_CR1_UE = 0x2000
	// USART prescaler and outputs disabled
	USART_CR1_UE_Disabled = 0x0
	// USART enabled
	USART_CR1_UE_Enabled = 0x1
	// Position of M field.
	USART_CR1_M_Pos = 0xc
	// Bit mask of M field.
	USART_CR1_M_Msk = 0x1000
	// Bit M.
	USART_CR1_M = 0x1000
	// 8 data bits
	USART_CR1_M_M8 = 0x0
	// 9 data bits
	USART_CR1_M_M9 = 0x1
	// Position of WAKE field.
	USART_CR1_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_WAKE = 0x800
	// USART wakeup on idle line
	USART_CR1_WAKE_IdleLine = 0x0
	// USART wakeup on address mark
	USART_CR1_WAKE_AddressMark = 0x1
	// Position of PCE field.
	USART_CR1_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_PCE = 0x400
	// Parity control disabled
	USART_CR1_PCE_Disabled = 0x0
	// Parity control enabled
	USART_CR1_PCE_Enabled = 0x1
	// Position of PS field.
	USART_CR1_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_PS = 0x200
	// Even parity
	USART_CR1_PS_Even = 0x0
	// Odd parity
	USART_CR1_PS_Odd = 0x1
	// Position of PEIE field.
	USART_CR1_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_PEIE = 0x100
	// PE interrupt disabled
	USART_CR1_PEIE_Disabled = 0x0
	// PE interrupt enabled
	USART_CR1_PEIE_Enabled = 0x1
	// Position of TXEIE field.
	USART_CR1_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	USART_CR1_TXEIE_Msk = 0x80
	// Bit TXEIE.
	USART_CR1_TXEIE = 0x80
	// TXE interrupt disabled
	USART_CR1_TXEIE_Disabled = 0x0
	// TXE interrupt enabled
	USART_CR1_TXEIE_Enabled = 0x1
	// Position of TCIE field.
	USART_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_TCIE = 0x40
	// TC interrupt disabled
	USART_CR1_TCIE_Disabled = 0x0
	// TC interrupt enabled
	USART_CR1_TCIE_Enabled = 0x1
	// Position of RXNEIE field.
	USART_CR1_RXNEIE_Pos = 0x5
	// Bit mask of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20
	// Bit RXNEIE.
	USART_CR1_RXNEIE = 0x20
	// RXNE interrupt disabled
	USART_CR1_RXNEIE_Disabled = 0x0
	// RXNE interrupt enabled
	USART_CR1_RXNEIE_Enabled = 0x1
	// Position of IDLEIE field.
	USART_CR1_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_IDLEIE = 0x10
	// IDLE interrupt disabled
	USART_CR1_IDLEIE_Disabled = 0x0
	// IDLE interrupt enabled
	USART_CR1_IDLEIE_Enabled = 0x1
	// Position of TE field.
	USART_CR1_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_TE = 0x8
	// Transmitter disabled
	USART_CR1_TE_Disabled = 0x0
	// Transmitter enabled
	USART_CR1_TE_Enabled = 0x1
	// Position of RE field.
	USART_CR1_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_RE = 0x4
	// Receiver disabled
	USART_CR1_RE_Disabled = 0x0
	// Receiver enabled
	USART_CR1_RE_Enabled = 0x1
	// Position of RWU field.
	USART_CR1_RWU_Pos = 0x1
	// Bit mask of RWU field.
	USART_CR1_RWU_Msk = 0x2
	// Bit RWU.
	USART_CR1_RWU = 0x2
	// Receiver in active mode
	USART_CR1_RWU_Active = 0x0
	// Receiver in mute mode
	USART_CR1_RWU_Mute = 0x1
	// Position of SBK field.
	USART_CR1_SBK_Pos = 0x0
	// Bit mask of SBK field.
	USART_CR1_SBK_Msk = 0x1
	// Bit SBK.
	USART_CR1_SBK = 0x1
	// No break character is transmitted
	USART_CR1_SBK_NoBreak = 0x0
	// Break character transmitted
	USART_CR1_SBK_Break = 0x1

	// CR2: Control register 2
	// Position of LINEN field.
	USART_CR2_LINEN_Pos = 0xe
	// Bit mask of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000
	// Bit LINEN.
	USART_CR2_LINEN = 0x4000
	// LIN mode disabled
	USART_CR2_LINEN_Disabled = 0x0
	// LIN mode enabled
	USART_CR2_LINEN_Enabled = 0x1
	// Position of STOP field.
	USART_CR2_STOP_Pos = 0xc
	// Bit mask of STOP field.
	USART_CR2_STOP_Msk = 0x3000
	// 1 stop bit
	USART_CR2_STOP_Stop1 = 0x0
	// 0.5 stop bits
	USART_CR2_STOP_Stop0p5 = 0x1
	// 2 stop bits
	USART_CR2_STOP_Stop2 = 0x2
	// 1.5 stop bits
	USART_CR2_STOP_Stop1p5 = 0x3
	// Position of CLKEN field.
	USART_CR2_CLKEN_Pos = 0xb
	// Bit mask of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800
	// Bit CLKEN.
	USART_CR2_CLKEN = 0x800
	// CK pin disabled
	USART_CR2_CLKEN_Disabled = 0x0
	// CK pin enabled
	USART_CR2_CLKEN_Enabled = 0x1
	// Position of CPOL field.
	USART_CR2_CPOL_Pos = 0xa
	// Bit mask of CPOL field.
	USART_CR2_CPOL_Msk = 0x400
	// Bit CPOL.
	USART_CR2_CPOL = 0x400
	// Steady low value on CK pin outside transmission window
	USART_CR2_CPOL_Low = 0x0
	// Steady high value on CK pin outside transmission window
	USART_CR2_CPOL_High = 0x1
	// Position of CPHA field.
	USART_CR2_CPHA_Pos = 0x9
	// Bit mask of CPHA field.
	USART_CR2_CPHA_Msk = 0x200
	// Bit CPHA.
	USART_CR2_CPHA = 0x200
	// The first clock transition is the first data capture edge
	USART_CR2_CPHA_First = 0x0
	// The second clock transition is the first data capture edge
	USART_CR2_CPHA_Second = 0x1
	// Position of LBCL field.
	USART_CR2_LBCL_Pos = 0x8
	// Bit mask of LBCL field.
	USART_CR2_LBCL_Msk = 0x100
	// Bit LBCL.
	USART_CR2_LBCL = 0x100
	// Position of LBDIE field.
	USART_CR2_LBDIE_Pos = 0x6
	// Bit mask of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40
	// Bit LBDIE.
	USART_CR2_LBDIE = 0x40
	// LIN break detection interrupt disabled
	USART_CR2_LBDIE_Disabled = 0x0
	// LIN break detection interrupt enabled
	USART_CR2_LBDIE_Enabled = 0x1
	// Position of LBDL field.
	USART_CR2_LBDL_Pos = 0x5
	// Bit mask of LBDL field.
	USART_CR2_LBDL_Msk = 0x20
	// Bit LBDL.
	USART_CR2_LBDL = 0x20
	// 10-bit break detection
	USART_CR2_LBDL_LBDL10 = 0x0
	// 11-bit break detection
	USART_CR2_LBDL_LBDL11 = 0x1
	// Position of ADD field.
	USART_CR2_ADD_Pos = 0x0
	// Bit mask of ADD field.
	USART_CR2_ADD_Msk = 0xf

	// CR3: Control register 3
	// Position of ONEBIT field.
	USART_CR3_ONEBIT_Pos = 0xb
	// Bit mask of ONEBIT field.
	USART_CR3_ONEBIT_Msk = 0x800
	// Bit ONEBIT.
	USART_CR3_ONEBIT = 0x800
	// Three sample bit method
	USART_CR3_ONEBIT_Sample3 = 0x0
	// One sample bit method
	USART_CR3_ONEBIT_Sample1 = 0x1
	// Position of CTSIE field.
	USART_CR3_CTSIE_Pos = 0xa
	// Bit mask of CTSIE field.
	USART_CR3_CTSIE_Msk = 0x400
	// Bit CTSIE.
	USART_CR3_CTSIE = 0x400
	// CTS interrupt disabled
	USART_CR3_CTSIE_Disabled = 0x0
	// CTS interrupt enabled
	USART_CR3_CTSIE_Enabled = 0x1
	// Position of CTSE field.
	USART_CR3_CTSE_Pos = 0x9
	// Bit mask of CTSE field.
	USART_CR3_CTSE_Msk = 0x200
	// Bit CTSE.
	USART_CR3_CTSE = 0x200
	// CTS hardware flow control disabled
	USART_CR3_CTSE_Disabled = 0x0
	// CTS hardware flow control enabled
	USART_CR3_CTSE_Enabled = 0x1
	// Position of RTSE field.
	USART_CR3_RTSE_Pos = 0x8
	// Bit mask of RTSE field.
	USART_CR3_RTSE_Msk = 0x100
	// Bit RTSE.
	USART_CR3_RTSE = 0x100
	// RTS hardware flow control disabled
	USART_CR3_RTSE_Disabled = 0x0
	// RTS hardware flow control enabled
	USART_CR3_RTSE_Enabled = 0x1
	// Position of DMAT field.
	USART_CR3_DMAT_Pos = 0x7
	// Bit mask of DMAT field.
	USART_CR3_DMAT_Msk = 0x80
	// Bit DMAT.
	USART_CR3_DMAT = 0x80
	// DMA mode is disabled for transmission
	USART_CR3_DMAT_Disabled = 0x0
	// DMA mode is enabled for transmission
	USART_CR3_DMAT_Enabled = 0x1
	// Position of DMAR field.
	USART_CR3_DMAR_Pos = 0x6
	// Bit mask of DMAR field.
	USART_CR3_DMAR_Msk = 0x40
	// Bit DMAR.
	USART_CR3_DMAR = 0x40
	// DMA mode is disabled for reception
	USART_CR3_DMAR_Disabled = 0x0
	// DMA mode is enabled for reception
	USART_CR3_DMAR_Enabled = 0x1
	// Position of SCEN field.
	USART_CR3_SCEN_Pos = 0x5
	// Bit mask of SCEN field.
	USART_CR3_SCEN_Msk = 0x20
	// Bit SCEN.
	USART_CR3_SCEN = 0x20
	// Smartcard mode disabled
	USART_CR3_SCEN_Disabled = 0x0
	// Smartcard mode enabled
	USART_CR3_SCEN_Enabled = 0x1
	// Position of NACK field.
	USART_CR3_NACK_Pos = 0x4
	// Bit mask of NACK field.
	USART_CR3_NACK_Msk = 0x10
	// Bit NACK.
	USART_CR3_NACK = 0x10
	// NACK transmission in case of parity error is disabled
	USART_CR3_NACK_Disabled = 0x0
	// NACK transmission during parity error is enabled
	USART_CR3_NACK_Enabled = 0x1
	// Position of HDSEL field.
	USART_CR3_HDSEL_Pos = 0x3
	// Bit mask of HDSEL field.
	USART_CR3_HDSEL_Msk = 0x8
	// Bit HDSEL.
	USART_CR3_HDSEL = 0x8
	// Half duplex mode is not selected
	USART_CR3_HDSEL_FullDuplex = 0x0
	// Half duplex mode is selected
	USART_CR3_HDSEL_HalfDuplex = 0x1
	// Position of IRLP field.
	USART_CR3_IRLP_Pos = 0x2
	// Bit mask of IRLP field.
	USART_CR3_IRLP_Msk = 0x4
	// Bit IRLP.
	USART_CR3_IRLP = 0x4
	// Normal mode
	USART_CR3_IRLP_Normal = 0x0
	// Low-power mode
	USART_CR3_IRLP_LowPower = 0x1
	// Position of IREN field.
	USART_CR3_IREN_Pos = 0x1
	// Bit mask of IREN field.
	USART_CR3_IREN_Msk = 0x2
	// Bit IREN.
	USART_CR3_IREN = 0x2
	// IrDA disabled
	USART_CR3_IREN_Disabled = 0x0
	// IrDA enabled
	USART_CR3_IREN_Enabled = 0x1
	// Position of EIE field.
	USART_CR3_EIE_Pos = 0x0
	// Bit mask of EIE field.
	USART_CR3_EIE_Msk = 0x1
	// Bit EIE.
	USART_CR3_EIE = 0x1
	// Error interrupt disabled
	USART_CR3_EIE_Disabled = 0x0
	// Error interrupt enabled
	USART_CR3_EIE_Enabled = 0x1

	// GTPR: Guard time and prescaler register
	// Position of GT field.
	USART_GTPR_GT_Pos = 0x8
	// Bit mask of GT field.
	USART_GTPR_GT_Msk = 0xff00
	// Position of PSC field.
	USART_GTPR_PSC_Pos = 0x0
	// Bit mask of PSC field.
	USART_GTPR_PSC_Msk = 0xff
)

// Constants for DAC: Digital-to-analog converter
const (
	// CR: control register
	// Position of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Pos = 0x1d
	// Bit mask of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Msk = 0x20000000
	// Bit DMAUDRIE2.
	DAC_CR_DMAUDRIE2 = 0x20000000
	// DAC channel X DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE2_Disabled = 0x0
	// DAC channel X DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE2_Enabled = 0x1
	// Position of DMAEN2 field.
	DAC_CR_DMAEN2_Pos = 0x1c
	// Bit mask of DMAEN2 field.
	DAC_CR_DMAEN2_Msk = 0x10000000
	// Bit DMAEN2.
	DAC_CR_DMAEN2 = 0x10000000
	// DAC channel X DMA mode disabled
	DAC_CR_DMAEN2_Disabled = 0x0
	// DAC channel X DMA mode enabled
	DAC_CR_DMAEN2_Enabled = 0x1
	// Position of MAMP2 field.
	DAC_CR_MAMP2_Pos = 0x18
	// Bit mask of MAMP2 field.
	DAC_CR_MAMP2_Msk = 0xf000000
	// Position of WAVE2 field.
	DAC_CR_WAVE2_Pos = 0x16
	// Bit mask of WAVE2 field.
	DAC_CR_WAVE2_Msk = 0xc00000
	// Wave generation disabled
	DAC_CR_WAVE2_Disabled = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE2_Noise = 0x1
	// Triangle wave generation enabled
	DAC_CR_WAVE2_Triangle = 0x2
	// Position of TSEL2 field.
	DAC_CR_TSEL2_Pos = 0x13
	// Bit mask of TSEL2 field.
	DAC_CR_TSEL2_Msk = 0x380000
	// Timer 6 TRGO event
	DAC_CR_TSEL2_TIM6_TRGO = 0x0
	// Timer 8 TRGO event
	DAC_CR_TSEL2_TIM8_TRGO = 0x1
	// Timer 7 TRGO event
	DAC_CR_TSEL2_TIM7_TRGO = 0x2
	// Timer 5 TRGO event
	DAC_CR_TSEL2_TIM5_TRGO = 0x3
	// Timer 2 TRGO event
	DAC_CR_TSEL2_TIM2_TRGO = 0x4
	// Timer 4 TRGO event
	DAC_CR_TSEL2_TIM4_TRGO = 0x5
	// EXTI line9
	DAC_CR_TSEL2_EXTI9 = 0x6
	// Software trigger
	DAC_CR_TSEL2_SOFTWARE = 0x7
	// Position of TEN2 field.
	DAC_CR_TEN2_Pos = 0x12
	// Bit mask of TEN2 field.
	DAC_CR_TEN2_Msk = 0x40000
	// Bit TEN2.
	DAC_CR_TEN2 = 0x40000
	// DAC channel X trigger disabled
	DAC_CR_TEN2_Disabled = 0x0
	// DAC channel X trigger enabled
	DAC_CR_TEN2_Enabled = 0x1
	// Position of BOFF2 field.
	DAC_CR_BOFF2_Pos = 0x11
	// Bit mask of BOFF2 field.
	DAC_CR_BOFF2_Msk = 0x20000
	// Bit BOFF2.
	DAC_CR_BOFF2 = 0x20000
	// DAC channel X output buffer enabled
	DAC_CR_BOFF2_Enabled = 0x0
	// DAC channel X output buffer disabled
	DAC_CR_BOFF2_Disabled = 0x1
	// Position of EN2 field.
	DAC_CR_EN2_Pos = 0x10
	// Bit mask of EN2 field.
	DAC_CR_EN2_Msk = 0x10000
	// Bit EN2.
	DAC_CR_EN2 = 0x10000
	// DAC channel X disabled
	DAC_CR_EN2_Disabled = 0x0
	// DAC channel X enabled
	DAC_CR_EN2_Enabled = 0x1
	// Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Pos = 0xd
	// Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000
	// Bit DMAUDRIE1.
	DAC_CR_DMAUDRIE1 = 0x2000
	// DAC channel X DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE1_Disabled = 0x0
	// DAC channel X DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE1_Enabled = 0x1
	// Position of DMAEN1 field.
	DAC_CR_DMAEN1_Pos = 0xc
	// Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1_Msk = 0x1000
	// Bit DMAEN1.
	DAC_CR_DMAEN1 = 0x1000
	// DAC channel X DMA mode disabled
	DAC_CR_DMAEN1_Disabled = 0x0
	// DAC channel X DMA mode enabled
	DAC_CR_DMAEN1_Enabled = 0x1
	// Position of MAMP1 field.
	DAC_CR_MAMP1_Pos = 0x8
	// Bit mask of MAMP1 field.
	DAC_CR_MAMP1_Msk = 0xf00
	// Position of WAVE1 field.
	DAC_CR_WAVE1_Pos = 0x6
	// Bit mask of WAVE1 field.
	DAC_CR_WAVE1_Msk = 0xc0
	// Wave generation disabled
	DAC_CR_WAVE1_Disabled = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE1_Noise = 0x1
	// Triangle wave generation enabled
	DAC_CR_WAVE1_Triangle = 0x2
	// Position of TSEL1 field.
	DAC_CR_TSEL1_Pos = 0x3
	// Bit mask of TSEL1 field.
	DAC_CR_TSEL1_Msk = 0x38
	// Timer 6 TRGO event
	DAC_CR_TSEL1_TIM6_TRGO = 0x0
	// Timer 3 TRGO event
	DAC_CR_TSEL1_TIM3_TRGO = 0x1
	// Timer 7 TRGO event
	DAC_CR_TSEL1_TIM7_TRGO = 0x2
	// Timer 15 TRGO event
	DAC_CR_TSEL1_TIM15_TRGO = 0x3
	// Timer 2 TRGO event
	DAC_CR_TSEL1_TIM2_TRGO = 0x4
	// EXTI line9
	DAC_CR_TSEL1_EXTI9 = 0x6
	// Software trigger
	DAC_CR_TSEL1_SOFTWARE = 0x7
	// Position of TEN1 field.
	DAC_CR_TEN1_Pos = 0x2
	// Bit mask of TEN1 field.
	DAC_CR_TEN1_Msk = 0x4
	// Bit TEN1.
	DAC_CR_TEN1 = 0x4
	// DAC channel X trigger disabled
	DAC_CR_TEN1_Disabled = 0x0
	// DAC channel X trigger enabled
	DAC_CR_TEN1_Enabled = 0x1
	// Position of BOFF1 field.
	DAC_CR_BOFF1_Pos = 0x1
	// Bit mask of BOFF1 field.
	DAC_CR_BOFF1_Msk = 0x2
	// Bit BOFF1.
	DAC_CR_BOFF1 = 0x2
	// DAC channel X output buffer enabled
	DAC_CR_BOFF1_Enabled = 0x0
	// DAC channel X output buffer disabled
	DAC_CR_BOFF1_Disabled = 0x1
	// Position of EN1 field.
	DAC_CR_EN1_Pos = 0x0
	// Bit mask of EN1 field.
	DAC_CR_EN1_Msk = 0x1
	// Bit EN1.
	DAC_CR_EN1 = 0x1
	// DAC channel X disabled
	DAC_CR_EN1_Disabled = 0x0
	// DAC channel X enabled
	DAC_CR_EN1_Enabled = 0x1

	// SWTRIGR: software trigger register
	// Position of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Pos = 0x1
	// Bit mask of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Msk = 0x2
	// Bit SWTRIG2.
	DAC_SWTRIGR_SWTRIG2 = 0x2
	// DAC channel X software trigger disabled
	DAC_SWTRIGR_SWTRIG2_Disabled = 0x0
	// DAC channel X software trigger enabled
	DAC_SWTRIGR_SWTRIG2_Enabled = 0x1
	// Position of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Pos = 0x0
	// Bit mask of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Msk = 0x1
	// Bit SWTRIG1.
	DAC_SWTRIGR_SWTRIG1 = 0x1
	// DAC channel X software trigger disabled
	DAC_SWTRIGR_SWTRIG1_Disabled = 0x0
	// DAC channel X software trigger enabled
	DAC_SWTRIGR_SWTRIG1_Enabled = 0x1

	// DHR12R1: channel1 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff

	// DHR12L1: channel1 12-bit left aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0

	// DHR8R1: channel1 8-bit right aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff

	// DHR12R2: channel2 12-bit right aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Msk = 0xfff

	// DHR12L2: channel2 12-bit left aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Pos = 0x4
	// Bit mask of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Msk = 0xfff0

	// DHR8R2: channel2 8-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Msk = 0xff

	// DHR12RD: Dual DAC 12-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Pos = 0x10
	// Bit mask of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000
	// Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff

	// DHR12LD: DUAL DAC 12-bit left aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Pos = 0x14
	// Bit mask of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000
	// Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0

	// DHR8RD: DUAL DAC 8-bit right aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Pos = 0x8
	// Bit mask of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Msk = 0xff00
	// Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff

	// DOR1: channel1 data output register
	// Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Pos = 0x0
	// Bit mask of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff

	// DOR2: channel2 data output register
	// Position of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Pos = 0x0
	// Bit mask of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Msk = 0xfff

	// SR: status register
	// Position of DMAUDR2 field.
	DAC_SR_DMAUDR2_Pos = 0x1d
	// Bit mask of DMAUDR2 field.
	DAC_SR_DMAUDR2_Msk = 0x20000000
	// Bit DMAUDR2.
	DAC_SR_DMAUDR2 = 0x20000000
	// No DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR2_NoUnderrun = 0x0
	// DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR2_Underrun = 0x1
	// Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Pos = 0xd
	// Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000
	// Bit DMAUDR1.
	DAC_SR_DMAUDR1 = 0x2000
	// No DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR1_NoUnderrun = 0x0
	// DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR1_Underrun = 0x1
)

// Constants for PWR: Power control
const (
	// CR: power control register
	// Position of FPDS field.
	PWR_CR_FPDS_Pos = 0x9
	// Bit mask of FPDS field.
	PWR_CR_FPDS_Msk = 0x200
	// Bit FPDS.
	PWR_CR_FPDS = 0x200
	// Position of DBP field.
	PWR_CR_DBP_Pos = 0x8
	// Bit mask of DBP field.
	PWR_CR_DBP_Msk = 0x100
	// Bit DBP.
	PWR_CR_DBP = 0x100
	// Position of PLS field.
	PWR_CR_PLS_Pos = 0x5
	// Bit mask of PLS field.
	PWR_CR_PLS_Msk = 0xe0
	// Position of PVDE field.
	PWR_CR_PVDE_Pos = 0x4
	// Bit mask of PVDE field.
	PWR_CR_PVDE_Msk = 0x10
	// Bit PVDE.
	PWR_CR_PVDE = 0x10
	// Position of CSBF field.
	PWR_CR_CSBF_Pos = 0x3
	// Bit mask of CSBF field.
	PWR_CR_CSBF_Msk = 0x8
	// Bit CSBF.
	PWR_CR_CSBF = 0x8
	// Position of CWUF field.
	PWR_CR_CWUF_Pos = 0x2
	// Bit mask of CWUF field.
	PWR_CR_CWUF_Msk = 0x4
	// Bit CWUF.
	PWR_CR_CWUF = 0x4
	// Position of PDDS field.
	PWR_CR_PDDS_Pos = 0x1
	// Bit mask of PDDS field.
	PWR_CR_PDDS_Msk = 0x2
	// Bit PDDS.
	PWR_CR_PDDS = 0x2
	// Enter Stop mode when the CPU enters deepsleep
	PWR_CR_PDDS_STOP_MODE = 0x0
	// Enter Standby mode when the CPU enters deepsleep
	PWR_CR_PDDS_STANDBY_MODE = 0x1
	// Position of LPDS field.
	PWR_CR_LPDS_Pos = 0x0
	// Bit mask of LPDS field.
	PWR_CR_LPDS_Msk = 0x1
	// Bit LPDS.
	PWR_CR_LPDS = 0x1

	// CSR: power control/status register
	// Position of BRE field.
	PWR_CSR_BRE_Pos = 0x9
	// Bit mask of BRE field.
	PWR_CSR_BRE_Msk = 0x200
	// Bit BRE.
	PWR_CSR_BRE = 0x200
	// Position of EWUP field.
	PWR_CSR_EWUP_Pos = 0x8
	// Bit mask of EWUP field.
	PWR_CSR_EWUP_Msk = 0x100
	// Bit EWUP.
	PWR_CSR_EWUP = 0x100
	// Position of BRR field.
	PWR_CSR_BRR_Pos = 0x3
	// Bit mask of BRR field.
	PWR_CSR_BRR_Msk = 0x8
	// Bit BRR.
	PWR_CSR_BRR = 0x8
	// Position of PVDO field.
	PWR_CSR_PVDO_Pos = 0x2
	// Bit mask of PVDO field.
	PWR_CSR_PVDO_Msk = 0x4
	// Bit PVDO.
	PWR_CSR_PVDO = 0x4
	// Position of SBF field.
	PWR_CSR_SBF_Pos = 0x1
	// Bit mask of SBF field.
	PWR_CSR_SBF_Msk = 0x2
	// Bit SBF.
	PWR_CSR_SBF = 0x2
	// Position of WUF field.
	PWR_CSR_WUF_Pos = 0x0
	// Bit mask of WUF field.
	PWR_CSR_WUF_Msk = 0x1
	// Bit WUF.
	PWR_CSR_WUF = 0x1
)

// Constants for CAN2: Controller area network
const (
	// MCR: master control register
	// Position of DBF field.
	CAN_MCR_DBF_Pos = 0x10
	// Bit mask of DBF field.
	CAN_MCR_DBF_Msk = 0x10000
	// Bit DBF.
	CAN_MCR_DBF = 0x10000
	// Position of RESET field.
	CAN_MCR_RESET_Pos = 0xf
	// Bit mask of RESET field.
	CAN_MCR_RESET_Msk = 0x8000
	// Bit RESET.
	CAN_MCR_RESET = 0x8000
	// Position of TTCM field.
	CAN_MCR_TTCM_Pos = 0x7
	// Bit mask of TTCM field.
	CAN_MCR_TTCM_Msk = 0x80
	// Bit TTCM.
	CAN_MCR_TTCM = 0x80
	// Position of ABOM field.
	CAN_MCR_ABOM_Pos = 0x6
	// Bit mask of ABOM field.
	CAN_MCR_ABOM_Msk = 0x40
	// Bit ABOM.
	CAN_MCR_ABOM = 0x40
	// Position of AWUM field.
	CAN_MCR_AWUM_Pos = 0x5
	// Bit mask of AWUM field.
	CAN_MCR_AWUM_Msk = 0x20
	// Bit AWUM.
	CAN_MCR_AWUM = 0x20
	// Position of NART field.
	CAN_MCR_NART_Pos = 0x4
	// Bit mask of NART field.
	CAN_MCR_NART_Msk = 0x10
	// Bit NART.
	CAN_MCR_NART = 0x10
	// Position of RFLM field.
	CAN_MCR_RFLM_Pos = 0x3
	// Bit mask of RFLM field.
	CAN_MCR_RFLM_Msk = 0x8
	// Bit RFLM.
	CAN_MCR_RFLM = 0x8
	// Position of TXFP field.
	CAN_MCR_TXFP_Pos = 0x2
	// Bit mask of TXFP field.
	CAN_MCR_TXFP_Msk = 0x4
	// Bit TXFP.
	CAN_MCR_TXFP = 0x4
	// Position of SLEEP field.
	CAN_MCR_SLEEP_Pos = 0x1
	// Bit mask of SLEEP field.
	CAN_MCR_SLEEP_Msk = 0x2
	// Bit SLEEP.
	CAN_MCR_SLEEP = 0x2
	// Position of INRQ field.
	CAN_MCR_INRQ_Pos = 0x0
	// Bit mask of INRQ field.
	CAN_MCR_INRQ_Msk = 0x1
	// Bit INRQ.
	CAN_MCR_INRQ = 0x1

	// MSR: master status register
	// Position of RX field.
	CAN_MSR_RX_Pos = 0xb
	// Bit mask of RX field.
	CAN_MSR_RX_Msk = 0x800
	// Bit RX.
	CAN_MSR_RX = 0x800
	// Position of SAMP field.
	CAN_MSR_SAMP_Pos = 0xa
	// Bit mask of SAMP field.
	CAN_MSR_SAMP_Msk = 0x400
	// Bit SAMP.
	CAN_MSR_SAMP = 0x400
	// Position of RXM field.
	CAN_MSR_RXM_Pos = 0x9
	// Bit mask of RXM field.
	CAN_MSR_RXM_Msk = 0x200
	// Bit RXM.
	CAN_MSR_RXM = 0x200
	// Position of TXM field.
	CAN_MSR_TXM_Pos = 0x8
	// Bit mask of TXM field.
	CAN_MSR_TXM_Msk = 0x100
	// Bit TXM.
	CAN_MSR_TXM = 0x100
	// Position of SLAKI field.
	CAN_MSR_SLAKI_Pos = 0x4
	// Bit mask of SLAKI field.
	CAN_MSR_SLAKI_Msk = 0x10
	// Bit SLAKI.
	CAN_MSR_SLAKI = 0x10
	// Position of WKUI field.
	CAN_MSR_WKUI_Pos = 0x3
	// Bit mask of WKUI field.
	CAN_MSR_WKUI_Msk = 0x8
	// Bit WKUI.
	CAN_MSR_WKUI = 0x8
	// Position of ERRI field.
	CAN_MSR_ERRI_Pos = 0x2
	// Bit mask of ERRI field.
	CAN_MSR_ERRI_Msk = 0x4
	// Bit ERRI.
	CAN_MSR_ERRI = 0x4
	// Position of SLAK field.
	CAN_MSR_SLAK_Pos = 0x1
	// Bit mask of SLAK field.
	CAN_MSR_SLAK_Msk = 0x2
	// Bit SLAK.
	CAN_MSR_SLAK = 0x2
	// Position of INAK field.
	CAN_MSR_INAK_Pos = 0x0
	// Bit mask of INAK field.
	CAN_MSR_INAK_Msk = 0x1
	// Bit INAK.
	CAN_MSR_INAK = 0x1

	// TSR: transmit status register
	// Position of LOW2 field.
	CAN_TSR_LOW2_Pos = 0x1f
	// Bit mask of LOW2 field.
	CAN_TSR_LOW2_Msk = 0x80000000
	// Bit LOW2.
	CAN_TSR_LOW2 = 0x80000000
	// Position of LOW1 field.
	CAN_TSR_LOW1_Pos = 0x1e
	// Bit mask of LOW1 field.
	CAN_TSR_LOW1_Msk = 0x40000000
	// Bit LOW1.
	CAN_TSR_LOW1 = 0x40000000
	// Position of LOW0 field.
	CAN_TSR_LOW0_Pos = 0x1d
	// Bit mask of LOW0 field.
	CAN_TSR_LOW0_Msk = 0x20000000
	// Bit LOW0.
	CAN_TSR_LOW0 = 0x20000000
	// Position of TME2 field.
	CAN_TSR_TME2_Pos = 0x1c
	// Bit mask of TME2 field.
	CAN_TSR_TME2_Msk = 0x10000000
	// Bit TME2.
	CAN_TSR_TME2 = 0x10000000
	// Position of TME1 field.
	CAN_TSR_TME1_Pos = 0x1b
	// Bit mask of TME1 field.
	CAN_TSR_TME1_Msk = 0x8000000
	// Bit TME1.
	CAN_TSR_TME1 = 0x8000000
	// Position of TME0 field.
	CAN_TSR_TME0_Pos = 0x1a
	// Bit mask of TME0 field.
	CAN_TSR_TME0_Msk = 0x4000000
	// Bit TME0.
	CAN_TSR_TME0 = 0x4000000
	// Position of CODE field.
	CAN_TSR_CODE_Pos = 0x18
	// Bit mask of CODE field.
	CAN_TSR_CODE_Msk = 0x3000000
	// Position of ABRQ2 field.
	CAN_TSR_ABRQ2_Pos = 0x17
	// Bit mask of ABRQ2 field.
	CAN_TSR_ABRQ2_Msk = 0x800000
	// Bit ABRQ2.
	CAN_TSR_ABRQ2 = 0x800000
	// Position of TERR2 field.
	CAN_TSR_TERR2_Pos = 0x13
	// Bit mask of TERR2 field.
	CAN_TSR_TERR2_Msk = 0x80000
	// Bit TERR2.
	CAN_TSR_TERR2 = 0x80000
	// Position of ALST2 field.
	CAN_TSR_ALST2_Pos = 0x12
	// Bit mask of ALST2 field.
	CAN_TSR_ALST2_Msk = 0x40000
	// Bit ALST2.
	CAN_TSR_ALST2 = 0x40000
	// Position of TXOK2 field.
	CAN_TSR_TXOK2_Pos = 0x11
	// Bit mask of TXOK2 field.
	CAN_TSR_TXOK2_Msk = 0x20000
	// Bit TXOK2.
	CAN_TSR_TXOK2 = 0x20000
	// Position of RQCP2 field.
	CAN_TSR_RQCP2_Pos = 0x10
	// Bit mask of RQCP2 field.
	CAN_TSR_RQCP2_Msk = 0x10000
	// Bit RQCP2.
	CAN_TSR_RQCP2 = 0x10000
	// Position of ABRQ1 field.
	CAN_TSR_ABRQ1_Pos = 0xf
	// Bit mask of ABRQ1 field.
	CAN_TSR_ABRQ1_Msk = 0x8000
	// Bit ABRQ1.
	CAN_TSR_ABRQ1 = 0x8000
	// Position of TERR1 field.
	CAN_TSR_TERR1_Pos = 0xb
	// Bit mask of TERR1 field.
	CAN_TSR_TERR1_Msk = 0x800
	// Bit TERR1.
	CAN_TSR_TERR1 = 0x800
	// Position of ALST1 field.
	CAN_TSR_ALST1_Pos = 0xa
	// Bit mask of ALST1 field.
	CAN_TSR_ALST1_Msk = 0x400
	// Bit ALST1.
	CAN_TSR_ALST1 = 0x400
	// Position of TXOK1 field.
	CAN_TSR_TXOK1_Pos = 0x9
	// Bit mask of TXOK1 field.
	CAN_TSR_TXOK1_Msk = 0x200
	// Bit TXOK1.
	CAN_TSR_TXOK1 = 0x200
	// Position of RQCP1 field.
	CAN_TSR_RQCP1_Pos = 0x8
	// Bit mask of RQCP1 field.
	CAN_TSR_RQCP1_Msk = 0x100
	// Bit RQCP1.
	CAN_TSR_RQCP1 = 0x100
	// Position of ABRQ0 field.
	CAN_TSR_ABRQ0_Pos = 0x7
	// Bit mask of ABRQ0 field.
	CAN_TSR_ABRQ0_Msk = 0x80
	// Bit ABRQ0.
	CAN_TSR_ABRQ0 = 0x80
	// Position of TERR0 field.
	CAN_TSR_TERR0_Pos = 0x3
	// Bit mask of TERR0 field.
	CAN_TSR_TERR0_Msk = 0x8
	// Bit TERR0.
	CAN_TSR_TERR0 = 0x8
	// Position of ALST0 field.
	CAN_TSR_ALST0_Pos = 0x2
	// Bit mask of ALST0 field.
	CAN_TSR_ALST0_Msk = 0x4
	// Bit ALST0.
	CAN_TSR_ALST0 = 0x4
	// Position of TXOK0 field.
	CAN_TSR_TXOK0_Pos = 0x1
	// Bit mask of TXOK0 field.
	CAN_TSR_TXOK0_Msk = 0x2
	// Bit TXOK0.
	CAN_TSR_TXOK0 = 0x2
	// Position of RQCP0 field.
	CAN_TSR_RQCP0_Pos = 0x0
	// Bit mask of RQCP0 field.
	CAN_TSR_RQCP0_Msk = 0x1
	// Bit RQCP0.
	CAN_TSR_RQCP0 = 0x1

	// RF0R: receive FIFO %s register
	// Position of RFOM field.
	CAN_RFR_RFOM_Pos = 0x5
	// Bit mask of RFOM field.
	CAN_RFR_RFOM_Msk = 0x20
	// Bit RFOM.
	CAN_RFR_RFOM = 0x20
	// Set by software to release the output mailbox of the FIFO
	CAN_RFR_RFOM_Release = 0x1
	// Position of FOVR field.
	CAN_RFR_FOVR_Pos = 0x4
	// Bit mask of FOVR field.
	CAN_RFR_FOVR_Msk = 0x10
	// Bit FOVR.
	CAN_RFR_FOVR = 0x10
	// No FIFO x overrun
	CAN_RFR_FOVR_NoOverrun = 0x0
	// FIFO x overrun
	CAN_RFR_FOVR_Overrun = 0x1
	// Clear flag
	CAN_RFR_FOVR_Clear = 0x1
	// Position of FULL field.
	CAN_RFR_FULL_Pos = 0x3
	// Bit mask of FULL field.
	CAN_RFR_FULL_Msk = 0x8
	// Bit FULL.
	CAN_RFR_FULL = 0x8
	// FIFO x is not full
	CAN_RFR_FULL_NotFull = 0x0
	// FIFO x is full
	CAN_RFR_FULL_Full = 0x1
	// Clear flag
	CAN_RFR_FULL_Clear = 0x1
	// Position of FMP field.
	CAN_RFR_FMP_Pos = 0x0
	// Bit mask of FMP field.
	CAN_RFR_FMP_Msk = 0x3

	// IER: interrupt enable register
	// Position of SLKIE field.
	CAN_IER_SLKIE_Pos = 0x11
	// Bit mask of SLKIE field.
	CAN_IER_SLKIE_Msk = 0x20000
	// Bit SLKIE.
	CAN_IER_SLKIE = 0x20000
	// No interrupt when SLAKI bit is set
	CAN_IER_SLKIE_Disabled = 0x0
	// Interrupt generated when SLAKI bit is set
	CAN_IER_SLKIE_Enabled = 0x1
	// Position of WKUIE field.
	CAN_IER_WKUIE_Pos = 0x10
	// Bit mask of WKUIE field.
	CAN_IER_WKUIE_Msk = 0x10000
	// Bit WKUIE.
	CAN_IER_WKUIE = 0x10000
	// No interrupt when WKUI is set
	CAN_IER_WKUIE_Disabled = 0x0
	// Interrupt generated when WKUI bit is set
	CAN_IER_WKUIE_Enabled = 0x1
	// Position of ERRIE field.
	CAN_IER_ERRIE_Pos = 0xf
	// Bit mask of ERRIE field.
	CAN_IER_ERRIE_Msk = 0x8000
	// Bit ERRIE.
	CAN_IER_ERRIE = 0x8000
	// No interrupt will be generated when an error condition is pending in the CAN_ESR
	CAN_IER_ERRIE_Disabled = 0x0
	// An interrupt will be generation when an error condition is pending in the CAN_ESR
	CAN_IER_ERRIE_Enabled = 0x1
	// Position of LECIE field.
	CAN_IER_LECIE_Pos = 0xb
	// Bit mask of LECIE field.
	CAN_IER_LECIE_Msk = 0x800
	// Bit LECIE.
	CAN_IER_LECIE = 0x800
	// ERRI bit will not be set when the error code in LEC[2:0] is set by hardware on error detection
	CAN_IER_LECIE_Disabled = 0x0
	// ERRI bit will be set when the error code in LEC[2:0] is set by hardware on error detection
	CAN_IER_LECIE_Enabled = 0x1
	// Position of BOFIE field.
	CAN_IER_BOFIE_Pos = 0xa
	// Bit mask of BOFIE field.
	CAN_IER_BOFIE_Msk = 0x400
	// Bit BOFIE.
	CAN_IER_BOFIE = 0x400
	// ERRI bit will not be set when BOFF is set
	CAN_IER_BOFIE_Disabled = 0x0
	// ERRI bit will be set when BOFF is set
	CAN_IER_BOFIE_Enabled = 0x1
	// Position of EPVIE field.
	CAN_IER_EPVIE_Pos = 0x9
	// Bit mask of EPVIE field.
	CAN_IER_EPVIE_Msk = 0x200
	// Bit EPVIE.
	CAN_IER_EPVIE = 0x200
	// ERRI bit will not be set when EPVF is set
	CAN_IER_EPVIE_Disabled = 0x0
	// ERRI bit will be set when EPVF is set
	CAN_IER_EPVIE_Enabled = 0x1
	// Position of EWGIE field.
	CAN_IER_EWGIE_Pos = 0x8
	// Bit mask of EWGIE field.
	CAN_IER_EWGIE_Msk = 0x100
	// Bit EWGIE.
	CAN_IER_EWGIE = 0x100
	// ERRI bit will not be set when EWGF is set
	CAN_IER_EWGIE_Disabled = 0x0
	// ERRI bit will be set when EWGF is set
	CAN_IER_EWGIE_Enabled = 0x1
	// Position of FOVIE1 field.
	CAN_IER_FOVIE1_Pos = 0x6
	// Bit mask of FOVIE1 field.
	CAN_IER_FOVIE1_Msk = 0x40
	// Bit FOVIE1.
	CAN_IER_FOVIE1 = 0x40
	// No interrupt when FOVR is set
	CAN_IER_FOVIE1_Disabled = 0x0
	// Interrupt generation when FOVR is set
	CAN_IER_FOVIE1_Enabled = 0x1
	// Position of FFIE1 field.
	CAN_IER_FFIE1_Pos = 0x5
	// Bit mask of FFIE1 field.
	CAN_IER_FFIE1_Msk = 0x20
	// Bit FFIE1.
	CAN_IER_FFIE1 = 0x20
	// No interrupt when FULL bit is set
	CAN_IER_FFIE1_Disabled = 0x0
	// Interrupt generated when FULL bit is set
	CAN_IER_FFIE1_Enabled = 0x1
	// Position of FMPIE1 field.
	CAN_IER_FMPIE1_Pos = 0x4
	// Bit mask of FMPIE1 field.
	CAN_IER_FMPIE1_Msk = 0x10
	// Bit FMPIE1.
	CAN_IER_FMPIE1 = 0x10
	// No interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE1_Disabled = 0x0
	// Interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE1_Enabled = 0x1
	// Position of FOVIE0 field.
	CAN_IER_FOVIE0_Pos = 0x3
	// Bit mask of FOVIE0 field.
	CAN_IER_FOVIE0_Msk = 0x8
	// Bit FOVIE0.
	CAN_IER_FOVIE0 = 0x8
	// No interrupt when FOVR bit is set
	CAN_IER_FOVIE0_Disabled = 0x0
	// Interrupt generated when FOVR bit is set
	CAN_IER_FOVIE0_Enabled = 0x1
	// Position of FFIE0 field.
	CAN_IER_FFIE0_Pos = 0x2
	// Bit mask of FFIE0 field.
	CAN_IER_FFIE0_Msk = 0x4
	// Bit FFIE0.
	CAN_IER_FFIE0 = 0x4
	// No interrupt when FULL bit is set
	CAN_IER_FFIE0_Disabled = 0x0
	// Interrupt generated when FULL bit is set
	CAN_IER_FFIE0_Enabled = 0x1
	// Position of FMPIE0 field.
	CAN_IER_FMPIE0_Pos = 0x1
	// Bit mask of FMPIE0 field.
	CAN_IER_FMPIE0_Msk = 0x2
	// Bit FMPIE0.
	CAN_IER_FMPIE0 = 0x2
	// No interrupt generated when state of FMP[1:0] bits are not 00
	CAN_IER_FMPIE0_Disabled = 0x0
	// Interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE0_Enabled = 0x1
	// Position of TMEIE field.
	CAN_IER_TMEIE_Pos = 0x0
	// Bit mask of TMEIE field.
	CAN_IER_TMEIE_Msk = 0x1
	// Bit TMEIE.
	CAN_IER_TMEIE = 0x1
	// No interrupt when RQCPx bit is set
	CAN_IER_TMEIE_Disabled = 0x0
	// Interrupt generated when RQCPx bit is set
	CAN_IER_TMEIE_Enabled = 0x1

	// ESR: interrupt enable register
	// Position of REC field.
	CAN_ESR_REC_Pos = 0x18
	// Bit mask of REC field.
	CAN_ESR_REC_Msk = 0xff000000
	// Position of TEC field.
	CAN_ESR_TEC_Pos = 0x10
	// Bit mask of TEC field.
	CAN_ESR_TEC_Msk = 0xff0000
	// Position of LEC field.
	CAN_ESR_LEC_Pos = 0x4
	// Bit mask of LEC field.
	CAN_ESR_LEC_Msk = 0x70
	// No Error
	CAN_ESR_LEC_NoError = 0x0
	// Stuff Error
	CAN_ESR_LEC_Stuff = 0x1
	// Form Error
	CAN_ESR_LEC_Form = 0x2
	// Acknowledgment Error
	CAN_ESR_LEC_Ack = 0x3
	// Bit recessive Error
	CAN_ESR_LEC_BitRecessive = 0x4
	// Bit dominant Error
	CAN_ESR_LEC_BitDominant = 0x5
	// CRC Error
	CAN_ESR_LEC_Crc = 0x6
	// Set by software
	CAN_ESR_LEC_Custom = 0x7
	// Position of BOFF field.
	CAN_ESR_BOFF_Pos = 0x2
	// Bit mask of BOFF field.
	CAN_ESR_BOFF_Msk = 0x4
	// Bit BOFF.
	CAN_ESR_BOFF = 0x4
	// Position of EPVF field.
	CAN_ESR_EPVF_Pos = 0x1
	// Bit mask of EPVF field.
	CAN_ESR_EPVF_Msk = 0x2
	// Bit EPVF.
	CAN_ESR_EPVF = 0x2
	// Position of EWGF field.
	CAN_ESR_EWGF_Pos = 0x0
	// Bit mask of EWGF field.
	CAN_ESR_EWGF_Msk = 0x1
	// Bit EWGF.
	CAN_ESR_EWGF = 0x1

	// BTR: bit timing register
	// Position of SILM field.
	CAN_BTR_SILM_Pos = 0x1f
	// Bit mask of SILM field.
	CAN_BTR_SILM_Msk = 0x80000000
	// Bit SILM.
	CAN_BTR_SILM = 0x80000000
	// Normal operation
	CAN_BTR_SILM_Normal = 0x0
	// Silent Mode
	CAN_BTR_SILM_Silent = 0x1
	// Position of LBKM field.
	CAN_BTR_LBKM_Pos = 0x1e
	// Bit mask of LBKM field.
	CAN_BTR_LBKM_Msk = 0x40000000
	// Bit LBKM.
	CAN_BTR_LBKM = 0x40000000
	// Loop Back Mode disabled
	CAN_BTR_LBKM_Disabled = 0x0
	// Loop Back Mode enabled
	CAN_BTR_LBKM_Enabled = 0x1
	// Position of SJW field.
	CAN_BTR_SJW_Pos = 0x18
	// Bit mask of SJW field.
	CAN_BTR_SJW_Msk = 0x3000000
	// Position of TS2 field.
	CAN_BTR_TS2_Pos = 0x14
	// Bit mask of TS2 field.
	CAN_BTR_TS2_Msk = 0x700000
	// Position of TS1 field.
	CAN_BTR_TS1_Pos = 0x10
	// Bit mask of TS1 field.
	CAN_BTR_TS1_Msk = 0xf0000
	// Position of BRP field.
	CAN_BTR_BRP_Pos = 0x0
	// Bit mask of BRP field.
	CAN_BTR_BRP_Msk = 0x3ff

	// TX.TIR: TX mailbox identifier register
	// Position of STID field.
	CAN_TX_TIR_STID_Pos = 0x15
	// Bit mask of STID field.
	CAN_TX_TIR_STID_Msk = 0xffe00000
	// Position of EXID field.
	CAN_TX_TIR_EXID_Pos = 0x3
	// Bit mask of EXID field.
	CAN_TX_TIR_EXID_Msk = 0x1ffff8
	// Position of IDE field.
	CAN_TX_TIR_IDE_Pos = 0x2
	// Bit mask of IDE field.
	CAN_TX_TIR_IDE_Msk = 0x4
	// Bit IDE.
	CAN_TX_TIR_IDE = 0x4
	// Standard identifier
	CAN_TX_TIR_IDE_Standard = 0x0
	// Extended identifier
	CAN_TX_TIR_IDE_Extended = 0x1
	// Position of RTR field.
	CAN_TX_TIR_RTR_Pos = 0x1
	// Bit mask of RTR field.
	CAN_TX_TIR_RTR_Msk = 0x2
	// Bit RTR.
	CAN_TX_TIR_RTR = 0x2
	// Data frame
	CAN_TX_TIR_RTR_Data = 0x0
	// Remote frame
	CAN_TX_TIR_RTR_Remote = 0x1
	// Position of TXRQ field.
	CAN_TX_TIR_TXRQ_Pos = 0x0
	// Bit mask of TXRQ field.
	CAN_TX_TIR_TXRQ_Msk = 0x1
	// Bit TXRQ.
	CAN_TX_TIR_TXRQ = 0x1

	// TX.TDTR: mailbox data length control and time stamp register
	// Position of TIME field.
	CAN_TX_TDTR_TIME_Pos = 0x10
	// Bit mask of TIME field.
	CAN_TX_TDTR_TIME_Msk = 0xffff0000
	// Position of TGT field.
	CAN_TX_TDTR_TGT_Pos = 0x8
	// Bit mask of TGT field.
	CAN_TX_TDTR_TGT_Msk = 0x100
	// Bit TGT.
	CAN_TX_TDTR_TGT = 0x100
	// Position of DLC field.
	CAN_TX_TDTR_DLC_Pos = 0x0
	// Bit mask of DLC field.
	CAN_TX_TDTR_DLC_Msk = 0xf

	// TX.TDLR: mailbox data low register
	// Position of DATA3 field.
	CAN_TX_TDLR_DATA3_Pos = 0x18
	// Bit mask of DATA3 field.
	CAN_TX_TDLR_DATA3_Msk = 0xff000000
	// Position of DATA2 field.
	CAN_TX_TDLR_DATA2_Pos = 0x10
	// Bit mask of DATA2 field.
	CAN_TX_TDLR_DATA2_Msk = 0xff0000
	// Position of DATA1 field.
	CAN_TX_TDLR_DATA1_Pos = 0x8
	// Bit mask of DATA1 field.
	CAN_TX_TDLR_DATA1_Msk = 0xff00
	// Position of DATA0 field.
	CAN_TX_TDLR_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	CAN_TX_TDLR_DATA0_Msk = 0xff

	// TX.TDHR: mailbox data high register
	// Position of DATA7 field.
	CAN_TX_TDHR_DATA7_Pos = 0x18
	// Bit mask of DATA7 field.
	CAN_TX_TDHR_DATA7_Msk = 0xff000000
	// Position of DATA6 field.
	CAN_TX_TDHR_DATA6_Pos = 0x10
	// Bit mask of DATA6 field.
	CAN_TX_TDHR_DATA6_Msk = 0xff0000
	// Position of DATA5 field.
	CAN_TX_TDHR_DATA5_Pos = 0x8
	// Bit mask of DATA5 field.
	CAN_TX_TDHR_DATA5_Msk = 0xff00
	// Position of DATA4 field.
	CAN_TX_TDHR_DATA4_Pos = 0x0
	// Bit mask of DATA4 field.
	CAN_TX_TDHR_DATA4_Msk = 0xff

	// RX.RIR: receive FIFO mailbox identifier register
	// Position of STID field.
	CAN_RX_RIR_STID_Pos = 0x15
	// Bit mask of STID field.
	CAN_RX_RIR_STID_Msk = 0xffe00000
	// Position of EXID field.
	CAN_RX_RIR_EXID_Pos = 0x3
	// Bit mask of EXID field.
	CAN_RX_RIR_EXID_Msk = 0x1ffff8
	// Position of IDE field.
	CAN_RX_RIR_IDE_Pos = 0x2
	// Bit mask of IDE field.
	CAN_RX_RIR_IDE_Msk = 0x4
	// Bit IDE.
	CAN_RX_RIR_IDE = 0x4
	// Standard identifier
	CAN_RX_RIR_IDE_Standard = 0x0
	// Extended identifier
	CAN_RX_RIR_IDE_Extended = 0x1
	// Position of RTR field.
	CAN_RX_RIR_RTR_Pos = 0x1
	// Bit mask of RTR field.
	CAN_RX_RIR_RTR_Msk = 0x2
	// Bit RTR.
	CAN_RX_RIR_RTR = 0x2
	// Data frame
	CAN_RX_RIR_RTR_Data = 0x0
	// Remote frame
	CAN_RX_RIR_RTR_Remote = 0x1

	// RX.RDTR: mailbox data high register
	// Position of TIME field.
	CAN_RX_RDTR_TIME_Pos = 0x10
	// Bit mask of TIME field.
	CAN_RX_RDTR_TIME_Msk = 0xffff0000
	// Position of FMI field.
	CAN_RX_RDTR_FMI_Pos = 0x8
	// Bit mask of FMI field.
	CAN_RX_RDTR_FMI_Msk = 0xff00
	// Position of DLC field.
	CAN_RX_RDTR_DLC_Pos = 0x0
	// Bit mask of DLC field.
	CAN_RX_RDTR_DLC_Msk = 0xf

	// RX.RDLR: mailbox data high register
	// Position of DATA3 field.
	CAN_RX_RDLR_DATA3_Pos = 0x18
	// Bit mask of DATA3 field.
	CAN_RX_RDLR_DATA3_Msk = 0xff000000
	// Position of DATA2 field.
	CAN_RX_RDLR_DATA2_Pos = 0x10
	// Bit mask of DATA2 field.
	CAN_RX_RDLR_DATA2_Msk = 0xff0000
	// Position of DATA1 field.
	CAN_RX_RDLR_DATA1_Pos = 0x8
	// Bit mask of DATA1 field.
	CAN_RX_RDLR_DATA1_Msk = 0xff00
	// Position of DATA0 field.
	CAN_RX_RDLR_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	CAN_RX_RDLR_DATA0_Msk = 0xff

	// RX.RDHR: receive FIFO mailbox data high register
	// Position of DATA7 field.
	CAN_RX_RDHR_DATA7_Pos = 0x18
	// Bit mask of DATA7 field.
	CAN_RX_RDHR_DATA7_Msk = 0xff000000
	// Position of DATA6 field.
	CAN_RX_RDHR_DATA6_Pos = 0x10
	// Bit mask of DATA6 field.
	CAN_RX_RDHR_DATA6_Msk = 0xff0000
	// Position of DATA5 field.
	CAN_RX_RDHR_DATA5_Pos = 0x8
	// Bit mask of DATA5 field.
	CAN_RX_RDHR_DATA5_Msk = 0xff00
	// Position of DATA4 field.
	CAN_RX_RDHR_DATA4_Pos = 0x0
	// Bit mask of DATA4 field.
	CAN_RX_RDHR_DATA4_Msk = 0xff

	// FMR: filter master register
	// Position of CAN2SB field.
	CAN_FMR_CAN2SB_Pos = 0x8
	// Bit mask of CAN2SB field.
	CAN_FMR_CAN2SB_Msk = 0x3f00
	// Position of FINIT field.
	CAN_FMR_FINIT_Pos = 0x0
	// Bit mask of FINIT field.
	CAN_FMR_FINIT_Msk = 0x1
	// Bit FINIT.
	CAN_FMR_FINIT = 0x1

	// FM1R: filter mode register
	// Position of FBM0 field.
	CAN_FM1R_FBM0_Pos = 0x0
	// Bit mask of FBM0 field.
	CAN_FM1R_FBM0_Msk = 0x1
	// Bit FBM0.
	CAN_FM1R_FBM0 = 0x1
	// Position of FBM1 field.
	CAN_FM1R_FBM1_Pos = 0x1
	// Bit mask of FBM1 field.
	CAN_FM1R_FBM1_Msk = 0x2
	// Bit FBM1.
	CAN_FM1R_FBM1 = 0x2
	// Position of FBM2 field.
	CAN_FM1R_FBM2_Pos = 0x2
	// Bit mask of FBM2 field.
	CAN_FM1R_FBM2_Msk = 0x4
	// Bit FBM2.
	CAN_FM1R_FBM2 = 0x4
	// Position of FBM3 field.
	CAN_FM1R_FBM3_Pos = 0x3
	// Bit mask of FBM3 field.
	CAN_FM1R_FBM3_Msk = 0x8
	// Bit FBM3.
	CAN_FM1R_FBM3 = 0x8
	// Position of FBM4 field.
	CAN_FM1R_FBM4_Pos = 0x4
	// Bit mask of FBM4 field.
	CAN_FM1R_FBM4_Msk = 0x10
	// Bit FBM4.
	CAN_FM1R_FBM4 = 0x10
	// Position of FBM5 field.
	CAN_FM1R_FBM5_Pos = 0x5
	// Bit mask of FBM5 field.
	CAN_FM1R_FBM5_Msk = 0x20
	// Bit FBM5.
	CAN_FM1R_FBM5 = 0x20
	// Position of FBM6 field.
	CAN_FM1R_FBM6_Pos = 0x6
	// Bit mask of FBM6 field.
	CAN_FM1R_FBM6_Msk = 0x40
	// Bit FBM6.
	CAN_FM1R_FBM6 = 0x40
	// Position of FBM7 field.
	CAN_FM1R_FBM7_Pos = 0x7
	// Bit mask of FBM7 field.
	CAN_FM1R_FBM7_Msk = 0x80
	// Bit FBM7.
	CAN_FM1R_FBM7 = 0x80
	// Position of FBM8 field.
	CAN_FM1R_FBM8_Pos = 0x8
	// Bit mask of FBM8 field.
	CAN_FM1R_FBM8_Msk = 0x100
	// Bit FBM8.
	CAN_FM1R_FBM8 = 0x100
	// Position of FBM9 field.
	CAN_FM1R_FBM9_Pos = 0x9
	// Bit mask of FBM9 field.
	CAN_FM1R_FBM9_Msk = 0x200
	// Bit FBM9.
	CAN_FM1R_FBM9 = 0x200
	// Position of FBM10 field.
	CAN_FM1R_FBM10_Pos = 0xa
	// Bit mask of FBM10 field.
	CAN_FM1R_FBM10_Msk = 0x400
	// Bit FBM10.
	CAN_FM1R_FBM10 = 0x400
	// Position of FBM11 field.
	CAN_FM1R_FBM11_Pos = 0xb
	// Bit mask of FBM11 field.
	CAN_FM1R_FBM11_Msk = 0x800
	// Bit FBM11.
	CAN_FM1R_FBM11 = 0x800
	// Position of FBM12 field.
	CAN_FM1R_FBM12_Pos = 0xc
	// Bit mask of FBM12 field.
	CAN_FM1R_FBM12_Msk = 0x1000
	// Bit FBM12.
	CAN_FM1R_FBM12 = 0x1000
	// Position of FBM13 field.
	CAN_FM1R_FBM13_Pos = 0xd
	// Bit mask of FBM13 field.
	CAN_FM1R_FBM13_Msk = 0x2000
	// Bit FBM13.
	CAN_FM1R_FBM13 = 0x2000
	// Position of FBM14 field.
	CAN_FM1R_FBM14_Pos = 0xe
	// Bit mask of FBM14 field.
	CAN_FM1R_FBM14_Msk = 0x4000
	// Bit FBM14.
	CAN_FM1R_FBM14 = 0x4000
	// Position of FBM15 field.
	CAN_FM1R_FBM15_Pos = 0xf
	// Bit mask of FBM15 field.
	CAN_FM1R_FBM15_Msk = 0x8000
	// Bit FBM15.
	CAN_FM1R_FBM15 = 0x8000
	// Position of FBM16 field.
	CAN_FM1R_FBM16_Pos = 0x10
	// Bit mask of FBM16 field.
	CAN_FM1R_FBM16_Msk = 0x10000
	// Bit FBM16.
	CAN_FM1R_FBM16 = 0x10000
	// Position of FBM17 field.
	CAN_FM1R_FBM17_Pos = 0x11
	// Bit mask of FBM17 field.
	CAN_FM1R_FBM17_Msk = 0x20000
	// Bit FBM17.
	CAN_FM1R_FBM17 = 0x20000
	// Position of FBM18 field.
	CAN_FM1R_FBM18_Pos = 0x12
	// Bit mask of FBM18 field.
	CAN_FM1R_FBM18_Msk = 0x40000
	// Bit FBM18.
	CAN_FM1R_FBM18 = 0x40000
	// Position of FBM19 field.
	CAN_FM1R_FBM19_Pos = 0x13
	// Bit mask of FBM19 field.
	CAN_FM1R_FBM19_Msk = 0x80000
	// Bit FBM19.
	CAN_FM1R_FBM19 = 0x80000
	// Position of FBM20 field.
	CAN_FM1R_FBM20_Pos = 0x14
	// Bit mask of FBM20 field.
	CAN_FM1R_FBM20_Msk = 0x100000
	// Bit FBM20.
	CAN_FM1R_FBM20 = 0x100000
	// Position of FBM21 field.
	CAN_FM1R_FBM21_Pos = 0x15
	// Bit mask of FBM21 field.
	CAN_FM1R_FBM21_Msk = 0x200000
	// Bit FBM21.
	CAN_FM1R_FBM21 = 0x200000
	// Position of FBM22 field.
	CAN_FM1R_FBM22_Pos = 0x16
	// Bit mask of FBM22 field.
	CAN_FM1R_FBM22_Msk = 0x400000
	// Bit FBM22.
	CAN_FM1R_FBM22 = 0x400000
	// Position of FBM23 field.
	CAN_FM1R_FBM23_Pos = 0x17
	// Bit mask of FBM23 field.
	CAN_FM1R_FBM23_Msk = 0x800000
	// Bit FBM23.
	CAN_FM1R_FBM23 = 0x800000
	// Position of FBM24 field.
	CAN_FM1R_FBM24_Pos = 0x18
	// Bit mask of FBM24 field.
	CAN_FM1R_FBM24_Msk = 0x1000000
	// Bit FBM24.
	CAN_FM1R_FBM24 = 0x1000000
	// Position of FBM25 field.
	CAN_FM1R_FBM25_Pos = 0x19
	// Bit mask of FBM25 field.
	CAN_FM1R_FBM25_Msk = 0x2000000
	// Bit FBM25.
	CAN_FM1R_FBM25 = 0x2000000
	// Position of FBM26 field.
	CAN_FM1R_FBM26_Pos = 0x1a
	// Bit mask of FBM26 field.
	CAN_FM1R_FBM26_Msk = 0x4000000
	// Bit FBM26.
	CAN_FM1R_FBM26 = 0x4000000
	// Position of FBM27 field.
	CAN_FM1R_FBM27_Pos = 0x1b
	// Bit mask of FBM27 field.
	CAN_FM1R_FBM27_Msk = 0x8000000
	// Bit FBM27.
	CAN_FM1R_FBM27 = 0x8000000

	// FS1R: filter scale register
	// Position of FSC0 field.
	CAN_FS1R_FSC0_Pos = 0x0
	// Bit mask of FSC0 field.
	CAN_FS1R_FSC0_Msk = 0x1
	// Bit FSC0.
	CAN_FS1R_FSC0 = 0x1
	// Position of FSC1 field.
	CAN_FS1R_FSC1_Pos = 0x1
	// Bit mask of FSC1 field.
	CAN_FS1R_FSC1_Msk = 0x2
	// Bit FSC1.
	CAN_FS1R_FSC1 = 0x2
	// Position of FSC2 field.
	CAN_FS1R_FSC2_Pos = 0x2
	// Bit mask of FSC2 field.
	CAN_FS1R_FSC2_Msk = 0x4
	// Bit FSC2.
	CAN_FS1R_FSC2 = 0x4
	// Position of FSC3 field.
	CAN_FS1R_FSC3_Pos = 0x3
	// Bit mask of FSC3 field.
	CAN_FS1R_FSC3_Msk = 0x8
	// Bit FSC3.
	CAN_FS1R_FSC3 = 0x8
	// Position of FSC4 field.
	CAN_FS1R_FSC4_Pos = 0x4
	// Bit mask of FSC4 field.
	CAN_FS1R_FSC4_Msk = 0x10
	// Bit FSC4.
	CAN_FS1R_FSC4 = 0x10
	// Position of FSC5 field.
	CAN_FS1R_FSC5_Pos = 0x5
	// Bit mask of FSC5 field.
	CAN_FS1R_FSC5_Msk = 0x20
	// Bit FSC5.
	CAN_FS1R_FSC5 = 0x20
	// Position of FSC6 field.
	CAN_FS1R_FSC6_Pos = 0x6
	// Bit mask of FSC6 field.
	CAN_FS1R_FSC6_Msk = 0x40
	// Bit FSC6.
	CAN_FS1R_FSC6 = 0x40
	// Position of FSC7 field.
	CAN_FS1R_FSC7_Pos = 0x7
	// Bit mask of FSC7 field.
	CAN_FS1R_FSC7_Msk = 0x80
	// Bit FSC7.
	CAN_FS1R_FSC7 = 0x80
	// Position of FSC8 field.
	CAN_FS1R_FSC8_Pos = 0x8
	// Bit mask of FSC8 field.
	CAN_FS1R_FSC8_Msk = 0x100
	// Bit FSC8.
	CAN_FS1R_FSC8 = 0x100
	// Position of FSC9 field.
	CAN_FS1R_FSC9_Pos = 0x9
	// Bit mask of FSC9 field.
	CAN_FS1R_FSC9_Msk = 0x200
	// Bit FSC9.
	CAN_FS1R_FSC9 = 0x200
	// Position of FSC10 field.
	CAN_FS1R_FSC10_Pos = 0xa
	// Bit mask of FSC10 field.
	CAN_FS1R_FSC10_Msk = 0x400
	// Bit FSC10.
	CAN_FS1R_FSC10 = 0x400
	// Position of FSC11 field.
	CAN_FS1R_FSC11_Pos = 0xb
	// Bit mask of FSC11 field.
	CAN_FS1R_FSC11_Msk = 0x800
	// Bit FSC11.
	CAN_FS1R_FSC11 = 0x800
	// Position of FSC12 field.
	CAN_FS1R_FSC12_Pos = 0xc
	// Bit mask of FSC12 field.
	CAN_FS1R_FSC12_Msk = 0x1000
	// Bit FSC12.
	CAN_FS1R_FSC12 = 0x1000
	// Position of FSC13 field.
	CAN_FS1R_FSC13_Pos = 0xd
	// Bit mask of FSC13 field.
	CAN_FS1R_FSC13_Msk = 0x2000
	// Bit FSC13.
	CAN_FS1R_FSC13 = 0x2000
	// Position of FSC14 field.
	CAN_FS1R_FSC14_Pos = 0xe
	// Bit mask of FSC14 field.
	CAN_FS1R_FSC14_Msk = 0x4000
	// Bit FSC14.
	CAN_FS1R_FSC14 = 0x4000
	// Position of FSC15 field.
	CAN_FS1R_FSC15_Pos = 0xf
	// Bit mask of FSC15 field.
	CAN_FS1R_FSC15_Msk = 0x8000
	// Bit FSC15.
	CAN_FS1R_FSC15 = 0x8000
	// Position of FSC16 field.
	CAN_FS1R_FSC16_Pos = 0x10
	// Bit mask of FSC16 field.
	CAN_FS1R_FSC16_Msk = 0x10000
	// Bit FSC16.
	CAN_FS1R_FSC16 = 0x10000
	// Position of FSC17 field.
	CAN_FS1R_FSC17_Pos = 0x11
	// Bit mask of FSC17 field.
	CAN_FS1R_FSC17_Msk = 0x20000
	// Bit FSC17.
	CAN_FS1R_FSC17 = 0x20000
	// Position of FSC18 field.
	CAN_FS1R_FSC18_Pos = 0x12
	// Bit mask of FSC18 field.
	CAN_FS1R_FSC18_Msk = 0x40000
	// Bit FSC18.
	CAN_FS1R_FSC18 = 0x40000
	// Position of FSC19 field.
	CAN_FS1R_FSC19_Pos = 0x13
	// Bit mask of FSC19 field.
	CAN_FS1R_FSC19_Msk = 0x80000
	// Bit FSC19.
	CAN_FS1R_FSC19 = 0x80000
	// Position of FSC20 field.
	CAN_FS1R_FSC20_Pos = 0x14
	// Bit mask of FSC20 field.
	CAN_FS1R_FSC20_Msk = 0x100000
	// Bit FSC20.
	CAN_FS1R_FSC20 = 0x100000
	// Position of FSC21 field.
	CAN_FS1R_FSC21_Pos = 0x15
	// Bit mask of FSC21 field.
	CAN_FS1R_FSC21_Msk = 0x200000
	// Bit FSC21.
	CAN_FS1R_FSC21 = 0x200000
	// Position of FSC22 field.
	CAN_FS1R_FSC22_Pos = 0x16
	// Bit mask of FSC22 field.
	CAN_FS1R_FSC22_Msk = 0x400000
	// Bit FSC22.
	CAN_FS1R_FSC22 = 0x400000
	// Position of FSC23 field.
	CAN_FS1R_FSC23_Pos = 0x17
	// Bit mask of FSC23 field.
	CAN_FS1R_FSC23_Msk = 0x800000
	// Bit FSC23.
	CAN_FS1R_FSC23 = 0x800000
	// Position of FSC24 field.
	CAN_FS1R_FSC24_Pos = 0x18
	// Bit mask of FSC24 field.
	CAN_FS1R_FSC24_Msk = 0x1000000
	// Bit FSC24.
	CAN_FS1R_FSC24 = 0x1000000
	// Position of FSC25 field.
	CAN_FS1R_FSC25_Pos = 0x19
	// Bit mask of FSC25 field.
	CAN_FS1R_FSC25_Msk = 0x2000000
	// Bit FSC25.
	CAN_FS1R_FSC25 = 0x2000000
	// Position of FSC26 field.
	CAN_FS1R_FSC26_Pos = 0x1a
	// Bit mask of FSC26 field.
	CAN_FS1R_FSC26_Msk = 0x4000000
	// Bit FSC26.
	CAN_FS1R_FSC26 = 0x4000000
	// Position of FSC27 field.
	CAN_FS1R_FSC27_Pos = 0x1b
	// Bit mask of FSC27 field.
	CAN_FS1R_FSC27_Msk = 0x8000000
	// Bit FSC27.
	CAN_FS1R_FSC27 = 0x8000000

	// FFA1R: filter FIFO assignment register
	// Position of FFA0 field.
	CAN_FFA1R_FFA0_Pos = 0x0
	// Bit mask of FFA0 field.
	CAN_FFA1R_FFA0_Msk = 0x1
	// Bit FFA0.
	CAN_FFA1R_FFA0 = 0x1
	// Position of FFA1 field.
	CAN_FFA1R_FFA1_Pos = 0x1
	// Bit mask of FFA1 field.
	CAN_FFA1R_FFA1_Msk = 0x2
	// Bit FFA1.
	CAN_FFA1R_FFA1 = 0x2
	// Position of FFA2 field.
	CAN_FFA1R_FFA2_Pos = 0x2
	// Bit mask of FFA2 field.
	CAN_FFA1R_FFA2_Msk = 0x4
	// Bit FFA2.
	CAN_FFA1R_FFA2 = 0x4
	// Position of FFA3 field.
	CAN_FFA1R_FFA3_Pos = 0x3
	// Bit mask of FFA3 field.
	CAN_FFA1R_FFA3_Msk = 0x8
	// Bit FFA3.
	CAN_FFA1R_FFA3 = 0x8
	// Position of FFA4 field.
	CAN_FFA1R_FFA4_Pos = 0x4
	// Bit mask of FFA4 field.
	CAN_FFA1R_FFA4_Msk = 0x10
	// Bit FFA4.
	CAN_FFA1R_FFA4 = 0x10
	// Position of FFA5 field.
	CAN_FFA1R_FFA5_Pos = 0x5
	// Bit mask of FFA5 field.
	CAN_FFA1R_FFA5_Msk = 0x20
	// Bit FFA5.
	CAN_FFA1R_FFA5 = 0x20
	// Position of FFA6 field.
	CAN_FFA1R_FFA6_Pos = 0x6
	// Bit mask of FFA6 field.
	CAN_FFA1R_FFA6_Msk = 0x40
	// Bit FFA6.
	CAN_FFA1R_FFA6 = 0x40
	// Position of FFA7 field.
	CAN_FFA1R_FFA7_Pos = 0x7
	// Bit mask of FFA7 field.
	CAN_FFA1R_FFA7_Msk = 0x80
	// Bit FFA7.
	CAN_FFA1R_FFA7 = 0x80
	// Position of FFA8 field.
	CAN_FFA1R_FFA8_Pos = 0x8
	// Bit mask of FFA8 field.
	CAN_FFA1R_FFA8_Msk = 0x100
	// Bit FFA8.
	CAN_FFA1R_FFA8 = 0x100
	// Position of FFA9 field.
	CAN_FFA1R_FFA9_Pos = 0x9
	// Bit mask of FFA9 field.
	CAN_FFA1R_FFA9_Msk = 0x200
	// Bit FFA9.
	CAN_FFA1R_FFA9 = 0x200
	// Position of FFA10 field.
	CAN_FFA1R_FFA10_Pos = 0xa
	// Bit mask of FFA10 field.
	CAN_FFA1R_FFA10_Msk = 0x400
	// Bit FFA10.
	CAN_FFA1R_FFA10 = 0x400
	// Position of FFA11 field.
	CAN_FFA1R_FFA11_Pos = 0xb
	// Bit mask of FFA11 field.
	CAN_FFA1R_FFA11_Msk = 0x800
	// Bit FFA11.
	CAN_FFA1R_FFA11 = 0x800
	// Position of FFA12 field.
	CAN_FFA1R_FFA12_Pos = 0xc
	// Bit mask of FFA12 field.
	CAN_FFA1R_FFA12_Msk = 0x1000
	// Bit FFA12.
	CAN_FFA1R_FFA12 = 0x1000
	// Position of FFA13 field.
	CAN_FFA1R_FFA13_Pos = 0xd
	// Bit mask of FFA13 field.
	CAN_FFA1R_FFA13_Msk = 0x2000
	// Bit FFA13.
	CAN_FFA1R_FFA13 = 0x2000
	// Position of FFA14 field.
	CAN_FFA1R_FFA14_Pos = 0xe
	// Bit mask of FFA14 field.
	CAN_FFA1R_FFA14_Msk = 0x4000
	// Bit FFA14.
	CAN_FFA1R_FFA14 = 0x4000
	// Position of FFA15 field.
	CAN_FFA1R_FFA15_Pos = 0xf
	// Bit mask of FFA15 field.
	CAN_FFA1R_FFA15_Msk = 0x8000
	// Bit FFA15.
	CAN_FFA1R_FFA15 = 0x8000
	// Position of FFA16 field.
	CAN_FFA1R_FFA16_Pos = 0x10
	// Bit mask of FFA16 field.
	CAN_FFA1R_FFA16_Msk = 0x10000
	// Bit FFA16.
	CAN_FFA1R_FFA16 = 0x10000
	// Position of FFA17 field.
	CAN_FFA1R_FFA17_Pos = 0x11
	// Bit mask of FFA17 field.
	CAN_FFA1R_FFA17_Msk = 0x20000
	// Bit FFA17.
	CAN_FFA1R_FFA17 = 0x20000
	// Position of FFA18 field.
	CAN_FFA1R_FFA18_Pos = 0x12
	// Bit mask of FFA18 field.
	CAN_FFA1R_FFA18_Msk = 0x40000
	// Bit FFA18.
	CAN_FFA1R_FFA18 = 0x40000
	// Position of FFA19 field.
	CAN_FFA1R_FFA19_Pos = 0x13
	// Bit mask of FFA19 field.
	CAN_FFA1R_FFA19_Msk = 0x80000
	// Bit FFA19.
	CAN_FFA1R_FFA19 = 0x80000
	// Position of FFA20 field.
	CAN_FFA1R_FFA20_Pos = 0x14
	// Bit mask of FFA20 field.
	CAN_FFA1R_FFA20_Msk = 0x100000
	// Bit FFA20.
	CAN_FFA1R_FFA20 = 0x100000
	// Position of FFA21 field.
	CAN_FFA1R_FFA21_Pos = 0x15
	// Bit mask of FFA21 field.
	CAN_FFA1R_FFA21_Msk = 0x200000
	// Bit FFA21.
	CAN_FFA1R_FFA21 = 0x200000
	// Position of FFA22 field.
	CAN_FFA1R_FFA22_Pos = 0x16
	// Bit mask of FFA22 field.
	CAN_FFA1R_FFA22_Msk = 0x400000
	// Bit FFA22.
	CAN_FFA1R_FFA22 = 0x400000
	// Position of FFA23 field.
	CAN_FFA1R_FFA23_Pos = 0x17
	// Bit mask of FFA23 field.
	CAN_FFA1R_FFA23_Msk = 0x800000
	// Bit FFA23.
	CAN_FFA1R_FFA23 = 0x800000
	// Position of FFA24 field.
	CAN_FFA1R_FFA24_Pos = 0x18
	// Bit mask of FFA24 field.
	CAN_FFA1R_FFA24_Msk = 0x1000000
	// Bit FFA24.
	CAN_FFA1R_FFA24 = 0x1000000
	// Position of FFA25 field.
	CAN_FFA1R_FFA25_Pos = 0x19
	// Bit mask of FFA25 field.
	CAN_FFA1R_FFA25_Msk = 0x2000000
	// Bit FFA25.
	CAN_FFA1R_FFA25 = 0x2000000
	// Position of FFA26 field.
	CAN_FFA1R_FFA26_Pos = 0x1a
	// Bit mask of FFA26 field.
	CAN_FFA1R_FFA26_Msk = 0x4000000
	// Bit FFA26.
	CAN_FFA1R_FFA26 = 0x4000000
	// Position of FFA27 field.
	CAN_FFA1R_FFA27_Pos = 0x1b
	// Bit mask of FFA27 field.
	CAN_FFA1R_FFA27_Msk = 0x8000000
	// Bit FFA27.
	CAN_FFA1R_FFA27 = 0x8000000

	// FA1R: filter activation register
	// Position of FACT0 field.
	CAN_FA1R_FACT0_Pos = 0x0
	// Bit mask of FACT0 field.
	CAN_FA1R_FACT0_Msk = 0x1
	// Bit FACT0.
	CAN_FA1R_FACT0 = 0x1
	// Position of FACT1 field.
	CAN_FA1R_FACT1_Pos = 0x1
	// Bit mask of FACT1 field.
	CAN_FA1R_FACT1_Msk = 0x2
	// Bit FACT1.
	CAN_FA1R_FACT1 = 0x2
	// Position of FACT2 field.
	CAN_FA1R_FACT2_Pos = 0x2
	// Bit mask of FACT2 field.
	CAN_FA1R_FACT2_Msk = 0x4
	// Bit FACT2.
	CAN_FA1R_FACT2 = 0x4
	// Position of FACT3 field.
	CAN_FA1R_FACT3_Pos = 0x3
	// Bit mask of FACT3 field.
	CAN_FA1R_FACT3_Msk = 0x8
	// Bit FACT3.
	CAN_FA1R_FACT3 = 0x8
	// Position of FACT4 field.
	CAN_FA1R_FACT4_Pos = 0x4
	// Bit mask of FACT4 field.
	CAN_FA1R_FACT4_Msk = 0x10
	// Bit FACT4.
	CAN_FA1R_FACT4 = 0x10
	// Position of FACT5 field.
	CAN_FA1R_FACT5_Pos = 0x5
	// Bit mask of FACT5 field.
	CAN_FA1R_FACT5_Msk = 0x20
	// Bit FACT5.
	CAN_FA1R_FACT5 = 0x20
	// Position of FACT6 field.
	CAN_FA1R_FACT6_Pos = 0x6
	// Bit mask of FACT6 field.
	CAN_FA1R_FACT6_Msk = 0x40
	// Bit FACT6.
	CAN_FA1R_FACT6 = 0x40
	// Position of FACT7 field.
	CAN_FA1R_FACT7_Pos = 0x7
	// Bit mask of FACT7 field.
	CAN_FA1R_FACT7_Msk = 0x80
	// Bit FACT7.
	CAN_FA1R_FACT7 = 0x80
	// Position of FACT8 field.
	CAN_FA1R_FACT8_Pos = 0x8
	// Bit mask of FACT8 field.
	CAN_FA1R_FACT8_Msk = 0x100
	// Bit FACT8.
	CAN_FA1R_FACT8 = 0x100
	// Position of FACT9 field.
	CAN_FA1R_FACT9_Pos = 0x9
	// Bit mask of FACT9 field.
	CAN_FA1R_FACT9_Msk = 0x200
	// Bit FACT9.
	CAN_FA1R_FACT9 = 0x200
	// Position of FACT10 field.
	CAN_FA1R_FACT10_Pos = 0xa
	// Bit mask of FACT10 field.
	CAN_FA1R_FACT10_Msk = 0x400
	// Bit FACT10.
	CAN_FA1R_FACT10 = 0x400
	// Position of FACT11 field.
	CAN_FA1R_FACT11_Pos = 0xb
	// Bit mask of FACT11 field.
	CAN_FA1R_FACT11_Msk = 0x800
	// Bit FACT11.
	CAN_FA1R_FACT11 = 0x800
	// Position of FACT12 field.
	CAN_FA1R_FACT12_Pos = 0xc
	// Bit mask of FACT12 field.
	CAN_FA1R_FACT12_Msk = 0x1000
	// Bit FACT12.
	CAN_FA1R_FACT12 = 0x1000
	// Position of FACT13 field.
	CAN_FA1R_FACT13_Pos = 0xd
	// Bit mask of FACT13 field.
	CAN_FA1R_FACT13_Msk = 0x2000
	// Bit FACT13.
	CAN_FA1R_FACT13 = 0x2000
	// Position of FACT14 field.
	CAN_FA1R_FACT14_Pos = 0xe
	// Bit mask of FACT14 field.
	CAN_FA1R_FACT14_Msk = 0x4000
	// Bit FACT14.
	CAN_FA1R_FACT14 = 0x4000
	// Position of FACT15 field.
	CAN_FA1R_FACT15_Pos = 0xf
	// Bit mask of FACT15 field.
	CAN_FA1R_FACT15_Msk = 0x8000
	// Bit FACT15.
	CAN_FA1R_FACT15 = 0x8000
	// Position of FACT16 field.
	CAN_FA1R_FACT16_Pos = 0x10
	// Bit mask of FACT16 field.
	CAN_FA1R_FACT16_Msk = 0x10000
	// Bit FACT16.
	CAN_FA1R_FACT16 = 0x10000
	// Position of FACT17 field.
	CAN_FA1R_FACT17_Pos = 0x11
	// Bit mask of FACT17 field.
	CAN_FA1R_FACT17_Msk = 0x20000
	// Bit FACT17.
	CAN_FA1R_FACT17 = 0x20000
	// Position of FACT18 field.
	CAN_FA1R_FACT18_Pos = 0x12
	// Bit mask of FACT18 field.
	CAN_FA1R_FACT18_Msk = 0x40000
	// Bit FACT18.
	CAN_FA1R_FACT18 = 0x40000
	// Position of FACT19 field.
	CAN_FA1R_FACT19_Pos = 0x13
	// Bit mask of FACT19 field.
	CAN_FA1R_FACT19_Msk = 0x80000
	// Bit FACT19.
	CAN_FA1R_FACT19 = 0x80000
	// Position of FACT20 field.
	CAN_FA1R_FACT20_Pos = 0x14
	// Bit mask of FACT20 field.
	CAN_FA1R_FACT20_Msk = 0x100000
	// Bit FACT20.
	CAN_FA1R_FACT20 = 0x100000
	// Position of FACT21 field.
	CAN_FA1R_FACT21_Pos = 0x15
	// Bit mask of FACT21 field.
	CAN_FA1R_FACT21_Msk = 0x200000
	// Bit FACT21.
	CAN_FA1R_FACT21 = 0x200000
	// Position of FACT22 field.
	CAN_FA1R_FACT22_Pos = 0x16
	// Bit mask of FACT22 field.
	CAN_FA1R_FACT22_Msk = 0x400000
	// Bit FACT22.
	CAN_FA1R_FACT22 = 0x400000
	// Position of FACT23 field.
	CAN_FA1R_FACT23_Pos = 0x17
	// Bit mask of FACT23 field.
	CAN_FA1R_FACT23_Msk = 0x800000
	// Bit FACT23.
	CAN_FA1R_FACT23 = 0x800000
	// Position of FACT24 field.
	CAN_FA1R_FACT24_Pos = 0x18
	// Bit mask of FACT24 field.
	CAN_FA1R_FACT24_Msk = 0x1000000
	// Bit FACT24.
	CAN_FA1R_FACT24 = 0x1000000
	// Position of FACT25 field.
	CAN_FA1R_FACT25_Pos = 0x19
	// Bit mask of FACT25 field.
	CAN_FA1R_FACT25_Msk = 0x2000000
	// Bit FACT25.
	CAN_FA1R_FACT25 = 0x2000000
	// Position of FACT26 field.
	CAN_FA1R_FACT26_Pos = 0x1a
	// Bit mask of FACT26 field.
	CAN_FA1R_FACT26_Msk = 0x4000000
	// Bit FACT26.
	CAN_FA1R_FACT26 = 0x4000000
	// Position of FACT27 field.
	CAN_FA1R_FACT27_Pos = 0x1b
	// Bit mask of FACT27 field.
	CAN_FA1R_FACT27_Msk = 0x8000000
	// Bit FACT27.
	CAN_FA1R_FACT27 = 0x8000000

	// FB.FR1: Filter bank 0 register 1
	// Position of FB field.
	CAN_FB_FR1_FB_Pos = 0x0
	// Bit mask of FB field.
	CAN_FB_FR1_FB_Msk = 0xffffffff

	// FB.FR2: Filter bank 0 register 2
	// Position of FB field.
	CAN_FB_FR2_FB_Pos = 0x0
	// Bit mask of FB field.
	CAN_FB_FR2_FB_Msk = 0xffffffff
)

// Constants for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	// Position of SWRST field.
	I2C_CR1_SWRST_Pos = 0xf
	// Bit mask of SWRST field.
	I2C_CR1_SWRST_Msk = 0x8000
	// Bit SWRST.
	I2C_CR1_SWRST = 0x8000
	// I2C peripheral not under reset
	I2C_CR1_SWRST_NotReset = 0x0
	// I2C peripheral under reset
	I2C_CR1_SWRST_Reset = 0x1
	// Position of ALERT field.
	I2C_CR1_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_CR1_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_CR1_ALERT = 0x2000
	// SMBA pin released high
	I2C_CR1_ALERT_Release = 0x0
	// SMBA pin driven low
	I2C_CR1_ALERT_Drive = 0x1
	// Position of PEC field.
	I2C_CR1_PEC_Pos = 0xc
	// Bit mask of PEC field.
	I2C_CR1_PEC_Msk = 0x1000
	// Bit PEC.
	I2C_CR1_PEC = 0x1000
	// No PEC transfer
	I2C_CR1_PEC_Disabled = 0x0
	// PEC transfer
	I2C_CR1_PEC_Enabled = 0x1
	// Position of POS field.
	I2C_CR1_POS_Pos = 0xb
	// Bit mask of POS field.
	I2C_CR1_POS_Msk = 0x800
	// Bit POS.
	I2C_CR1_POS = 0x800
	// ACK bit controls the (N)ACK of the current byte being received
	I2C_CR1_POS_Current = 0x0
	// ACK bit controls the (N)ACK of the next byte to be received
	I2C_CR1_POS_Next = 0x1
	// Position of ACK field.
	I2C_CR1_ACK_Pos = 0xa
	// Bit mask of ACK field.
	I2C_CR1_ACK_Msk = 0x400
	// Bit ACK.
	I2C_CR1_ACK = 0x400
	// No acknowledge returned
	I2C_CR1_ACK_NAK = 0x0
	// Acknowledge returned after a byte is received
	I2C_CR1_ACK_ACK = 0x1
	// Position of STOP field.
	I2C_CR1_STOP_Pos = 0x9
	// Bit mask of STOP field.
	I2C_CR1_STOP_Msk = 0x200
	// Bit STOP.
	I2C_CR1_STOP = 0x200
	// No Stop generation
	I2C_CR1_STOP_NoStop = 0x0
	// In master mode: stop generation after current byte/start, in slave mode: release SCL and SDA after current byte
	I2C_CR1_STOP_Stop = 0x1
	// Position of START field.
	I2C_CR1_START_Pos = 0x8
	// Bit mask of START field.
	I2C_CR1_START_Msk = 0x100
	// Bit START.
	I2C_CR1_START = 0x100
	// No Start generation
	I2C_CR1_START_NoStart = 0x0
	// In master mode: repeated start generation, in slave mode: start generation when bus is free
	I2C_CR1_START_Start = 0x1
	// Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Pos = 0x7
	// Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x80
	// Bit NOSTRETCH.
	I2C_CR1_NOSTRETCH = 0x80
	// Clock stretching enabled
	I2C_CR1_NOSTRETCH_Enabled = 0x0
	// Clock stretching disabled
	I2C_CR1_NOSTRETCH_Disabled = 0x1
	// Position of ENGC field.
	I2C_CR1_ENGC_Pos = 0x6
	// Bit mask of ENGC field.
	I2C_CR1_ENGC_Msk = 0x40
	// Bit ENGC.
	I2C_CR1_ENGC = 0x40
	// General call disabled
	I2C_CR1_ENGC_Disabled = 0x0
	// General call enabled
	I2C_CR1_ENGC_Enabled = 0x1
	// Position of ENPEC field.
	I2C_CR1_ENPEC_Pos = 0x5
	// Bit mask of ENPEC field.
	I2C_CR1_ENPEC_Msk = 0x20
	// Bit ENPEC.
	I2C_CR1_ENPEC = 0x20
	// PEC calculation disabled
	I2C_CR1_ENPEC_Disabled = 0x0
	// PEC calculation enabled
	I2C_CR1_ENPEC_Enabled = 0x1
	// Position of ENARP field.
	I2C_CR1_ENARP_Pos = 0x4
	// Bit mask of ENARP field.
	I2C_CR1_ENARP_Msk = 0x10
	// Bit ENARP.
	I2C_CR1_ENARP = 0x10
	// ARP disabled
	I2C_CR1_ENARP_Disabled = 0x0
	// ARP enabled
	I2C_CR1_ENARP_Enabled = 0x1
	// Position of SMBTYPE field.
	I2C_CR1_SMBTYPE_Pos = 0x3
	// Bit mask of SMBTYPE field.
	I2C_CR1_SMBTYPE_Msk = 0x8
	// Bit SMBTYPE.
	I2C_CR1_SMBTYPE = 0x8
	// SMBus Device
	I2C_CR1_SMBTYPE_Device = 0x0
	// SMBus Host
	I2C_CR1_SMBTYPE_Host = 0x1
	// Position of SMBUS field.
	I2C_CR1_SMBUS_Pos = 0x1
	// Bit mask of SMBUS field.
	I2C_CR1_SMBUS_Msk = 0x2
	// Bit SMBUS.
	I2C_CR1_SMBUS = 0x2
	// I2C Mode
	I2C_CR1_SMBUS_I2C = 0x0
	// SMBus
	I2C_CR1_SMBUS_SMBus = 0x1
	// Position of PE field.
	I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_CR1_PE = 0x1
	// Peripheral disabled
	I2C_CR1_PE_Disabled = 0x0
	// Peripheral enabled
	I2C_CR1_PE_Enabled = 0x1

	// CR2: Control register 2
	// Position of LAST field.
	I2C_CR2_LAST_Pos = 0xc
	// Bit mask of LAST field.
	I2C_CR2_LAST_Msk = 0x1000
	// Bit LAST.
	I2C_CR2_LAST = 0x1000
	// Next DMA EOT is not the last transfer
	I2C_CR2_LAST_NotLast = 0x0
	// Next DMA EOT is the last transfer
	I2C_CR2_LAST_Last = 0x1
	// Position of DMAEN field.
	I2C_CR2_DMAEN_Pos = 0xb
	// Bit mask of DMAEN field.
	I2C_CR2_DMAEN_Msk = 0x800
	// Bit DMAEN.
	I2C_CR2_DMAEN = 0x800
	// DMA requests disabled
	I2C_CR2_DMAEN_Disabled = 0x0
	// DMA request enabled when TxE=1 or RxNE=1
	I2C_CR2_DMAEN_Enabled = 0x1
	// Position of ITBUFEN field.
	I2C_CR2_ITBUFEN_Pos = 0xa
	// Bit mask of ITBUFEN field.
	I2C_CR2_ITBUFEN_Msk = 0x400
	// Bit ITBUFEN.
	I2C_CR2_ITBUFEN = 0x400
	// TxE=1 or RxNE=1 does not generate any interrupt
	I2C_CR2_ITBUFEN_Disabled = 0x0
	// TxE=1 or RxNE=1 generates Event interrupt
	I2C_CR2_ITBUFEN_Enabled = 0x1
	// Position of ITEVTEN field.
	I2C_CR2_ITEVTEN_Pos = 0x9
	// Bit mask of ITEVTEN field.
	I2C_CR2_ITEVTEN_Msk = 0x200
	// Bit ITEVTEN.
	I2C_CR2_ITEVTEN = 0x200
	// Event interrupt disabled
	I2C_CR2_ITEVTEN_Disabled = 0x0
	// Event interrupt enabled
	I2C_CR2_ITEVTEN_Enabled = 0x1
	// Position of ITERREN field.
	I2C_CR2_ITERREN_Pos = 0x8
	// Bit mask of ITERREN field.
	I2C_CR2_ITERREN_Msk = 0x100
	// Bit ITERREN.
	I2C_CR2_ITERREN = 0x100
	// Error interrupt disabled
	I2C_CR2_ITERREN_Disabled = 0x0
	// Error interrupt enabled
	I2C_CR2_ITERREN_Enabled = 0x1
	// Position of FREQ field.
	I2C_CR2_FREQ_Pos = 0x0
	// Bit mask of FREQ field.
	I2C_CR2_FREQ_Msk = 0x3f

	// OAR1: Own address register 1
	// Position of ADDMODE field.
	I2C_OAR1_ADDMODE_Pos = 0xf
	// Bit mask of ADDMODE field.
	I2C_OAR1_ADDMODE_Msk = 0x8000
	// Bit ADDMODE.
	I2C_OAR1_ADDMODE = 0x8000
	// 7-bit slave address
	I2C_OAR1_ADDMODE_ADD7 = 0x0
	// 10-bit slave address
	I2C_OAR1_ADDMODE_ADD10 = 0x1
	// Position of ADD field.
	I2C_OAR1_ADD_Pos = 0x0
	// Bit mask of ADD field.
	I2C_OAR1_ADD_Msk = 0x3ff

	// OAR2: Own address register 2
	// Position of ADD2 field.
	I2C_OAR2_ADD2_Pos = 0x1
	// Bit mask of ADD2 field.
	I2C_OAR2_ADD2_Msk = 0xfe
	// Position of ENDUAL field.
	I2C_OAR2_ENDUAL_Pos = 0x0
	// Bit mask of ENDUAL field.
	I2C_OAR2_ENDUAL_Msk = 0x1
	// Bit ENDUAL.
	I2C_OAR2_ENDUAL = 0x1
	// Single addressing mode
	I2C_OAR2_ENDUAL_Single = 0x0
	// Dual addressing mode
	I2C_OAR2_ENDUAL_Dual = 0x1

	// DR: Data register
	// Position of DR field.
	I2C_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	I2C_DR_DR_Msk = 0xff

	// SR1: Status register 1
	// Position of SMBALERT field.
	I2C_SR1_SMBALERT_Pos = 0xf
	// Bit mask of SMBALERT field.
	I2C_SR1_SMBALERT_Msk = 0x8000
	// Bit SMBALERT.
	I2C_SR1_SMBALERT = 0x8000
	// No SMBALERT occured
	I2C_SR1_SMBALERT_NoAlert = 0x0
	// SMBALERT occurred
	I2C_SR1_SMBALERT_Alert = 0x1
	// Position of TIMEOUT field.
	I2C_SR1_TIMEOUT_Pos = 0xe
	// Bit mask of TIMEOUT field.
	I2C_SR1_TIMEOUT_Msk = 0x4000
	// Bit TIMEOUT.
	I2C_SR1_TIMEOUT = 0x4000
	// No Timeout error
	I2C_SR1_TIMEOUT_NoTimeout = 0x0
	// SCL remained LOW for 25 ms
	I2C_SR1_TIMEOUT_Timeout = 0x1
	// Position of PECERR field.
	I2C_SR1_PECERR_Pos = 0xc
	// Bit mask of PECERR field.
	I2C_SR1_PECERR_Msk = 0x1000
	// Bit PECERR.
	I2C_SR1_PECERR = 0x1000
	// no PEC error: receiver returns ACK after PEC reception (if ACK=1)
	I2C_SR1_PECERR_NoError = 0x0
	// PEC error: receiver returns NACK after PEC reception (whatever ACK)
	I2C_SR1_PECERR_Error = 0x1
	// Position of OVR field.
	I2C_SR1_OVR_Pos = 0xb
	// Bit mask of OVR field.
	I2C_SR1_OVR_Msk = 0x800
	// Bit OVR.
	I2C_SR1_OVR = 0x800
	// No overrun/underrun occured
	I2C_SR1_OVR_NoOverrun = 0x0
	// Overrun/underrun occured
	I2C_SR1_OVR_Overrun = 0x1
	// Position of AF field.
	I2C_SR1_AF_Pos = 0xa
	// Bit mask of AF field.
	I2C_SR1_AF_Msk = 0x400
	// Bit AF.
	I2C_SR1_AF = 0x400
	// No acknowledge failure
	I2C_SR1_AF_NoFailure = 0x0
	// Acknowledge failure
	I2C_SR1_AF_Failure = 0x1
	// Position of ARLO field.
	I2C_SR1_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_SR1_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_SR1_ARLO = 0x200
	// No Arbitration Lost detected
	I2C_SR1_ARLO_NoLost = 0x0
	// Arbitration Lost detected
	I2C_SR1_ARLO_Lost = 0x1
	// Position of BERR field.
	I2C_SR1_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_SR1_BERR_Msk = 0x100
	// Bit BERR.
	I2C_SR1_BERR = 0x100
	// No misplaced Start or Stop condition
	I2C_SR1_BERR_NoError = 0x0
	// Misplaced Start or Stop condition
	I2C_SR1_BERR_Error = 0x1
	// Position of TxE field.
	I2C_SR1_TxE_Pos = 0x7
	// Bit mask of TxE field.
	I2C_SR1_TxE_Msk = 0x80
	// Bit TxE.
	I2C_SR1_TxE = 0x80
	// Data register not empty
	I2C_SR1_TxE_NotEmpty = 0x0
	// Data register empty
	I2C_SR1_TxE_Empty = 0x1
	// Position of RxNE field.
	I2C_SR1_RxNE_Pos = 0x6
	// Bit mask of RxNE field.
	I2C_SR1_RxNE_Msk = 0x40
	// Bit RxNE.
	I2C_SR1_RxNE = 0x40
	// Data register empty
	I2C_SR1_RxNE_Empty = 0x0
	// Data register not empty
	I2C_SR1_RxNE_NotEmpty = 0x1
	// Position of STOPF field.
	I2C_SR1_STOPF_Pos = 0x4
	// Bit mask of STOPF field.
	I2C_SR1_STOPF_Msk = 0x10
	// Bit STOPF.
	I2C_SR1_STOPF = 0x10
	// No Stop condition detected
	I2C_SR1_STOPF_NoStop = 0x0
	// Stop condition detected
	I2C_SR1_STOPF_Stop = 0x1
	// Position of ADD10 field.
	I2C_SR1_ADD10_Pos = 0x3
	// Bit mask of ADD10 field.
	I2C_SR1_ADD10_Msk = 0x8
	// Bit ADD10.
	I2C_SR1_ADD10 = 0x8
	// Position of BTF field.
	I2C_SR1_BTF_Pos = 0x2
	// Bit mask of BTF field.
	I2C_SR1_BTF_Msk = 0x4
	// Bit BTF.
	I2C_SR1_BTF = 0x4
	// Data byte transfer not done
	I2C_SR1_BTF_NotFinished = 0x0
	// Data byte transfer successful
	I2C_SR1_BTF_Finished = 0x1
	// Position of ADDR field.
	I2C_SR1_ADDR_Pos = 0x1
	// Bit mask of ADDR field.
	I2C_SR1_ADDR_Msk = 0x2
	// Bit ADDR.
	I2C_SR1_ADDR = 0x2
	// Adress mismatched or not received
	I2C_SR1_ADDR_NotMatch = 0x0
	// Received slave address matched with one of the enabled slave addresses
	I2C_SR1_ADDR_Match = 0x1
	// Position of SB field.
	I2C_SR1_SB_Pos = 0x0
	// Bit mask of SB field.
	I2C_SR1_SB_Msk = 0x1
	// Bit SB.
	I2C_SR1_SB = 0x1
	// No Start condition
	I2C_SR1_SB_NoStart = 0x0
	// Start condition generated
	I2C_SR1_SB_Start = 0x1

	// SR2: Status register 2
	// Position of PEC field.
	I2C_SR2_PEC_Pos = 0x8
	// Bit mask of PEC field.
	I2C_SR2_PEC_Msk = 0xff00
	// Position of DUALF field.
	I2C_SR2_DUALF_Pos = 0x7
	// Bit mask of DUALF field.
	I2C_SR2_DUALF_Msk = 0x80
	// Bit DUALF.
	I2C_SR2_DUALF = 0x80
	// Position of SMBHOST field.
	I2C_SR2_SMBHOST_Pos = 0x6
	// Bit mask of SMBHOST field.
	I2C_SR2_SMBHOST_Msk = 0x40
	// Bit SMBHOST.
	I2C_SR2_SMBHOST = 0x40
	// Position of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT_Pos = 0x5
	// Bit mask of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT_Msk = 0x20
	// Bit SMBDEFAULT.
	I2C_SR2_SMBDEFAULT = 0x20
	// Position of GENCALL field.
	I2C_SR2_GENCALL_Pos = 0x4
	// Bit mask of GENCALL field.
	I2C_SR2_GENCALL_Msk = 0x10
	// Bit GENCALL.
	I2C_SR2_GENCALL = 0x10
	// Position of TRA field.
	I2C_SR2_TRA_Pos = 0x2
	// Bit mask of TRA field.
	I2C_SR2_TRA_Msk = 0x4
	// Bit TRA.
	I2C_SR2_TRA = 0x4
	// Position of BUSY field.
	I2C_SR2_BUSY_Pos = 0x1
	// Bit mask of BUSY field.
	I2C_SR2_BUSY_Msk = 0x2
	// Bit BUSY.
	I2C_SR2_BUSY = 0x2
	// Position of MSL field.
	I2C_SR2_MSL_Pos = 0x0
	// Bit mask of MSL field.
	I2C_SR2_MSL_Msk = 0x1
	// Bit MSL.
	I2C_SR2_MSL = 0x1

	// CCR: Clock control register
	// Position of F_S field.
	I2C_CCR_F_S_Pos = 0xf
	// Bit mask of F_S field.
	I2C_CCR_F_S_Msk = 0x8000
	// Bit F_S.
	I2C_CCR_F_S = 0x8000
	// Standard mode I2C
	I2C_CCR_F_S_Standard = 0x0
	// Fast mode I2C
	I2C_CCR_F_S_Fast = 0x1
	// Position of DUTY field.
	I2C_CCR_DUTY_Pos = 0xe
	// Bit mask of DUTY field.
	I2C_CCR_DUTY_Msk = 0x4000
	// Bit DUTY.
	I2C_CCR_DUTY = 0x4000
	// Duty cycle t_low/t_high = 2/1
	I2C_CCR_DUTY_Duty2_1 = 0x0
	// Duty cycle t_low/t_high = 16/9
	I2C_CCR_DUTY_Duty16_9 = 0x1
	// Position of CCR field.
	I2C_CCR_CCR_Pos = 0x0
	// Bit mask of CCR field.
	I2C_CCR_CCR_Msk = 0xfff

	// TRISE: TRISE register
	// Position of TRISE field.
	I2C_TRISE_TRISE_Pos = 0x0
	// Bit mask of TRISE field.
	I2C_TRISE_TRISE_Msk = 0x3f
)

// Constants for IWDG: Independent watchdog
const (
	// KR: Key register
	// Position of KEY field.
	IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_KR_KEY_Msk = 0xffff
	// Enable access to PR, RLR and WINR registers (0x5555)
	IWDG_KR_KEY_Enable = 0x5555
	// Reset the watchdog value (0xAAAA)
	IWDG_KR_KEY_Reset = 0xaaaa
	// Start the watchdog (0xCCCC)
	IWDG_KR_KEY_Start = 0xcccc

	// PR: Prescaler register
	// Position of PR field.
	IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_PR_PR_Msk = 0x7
	// Divider /4
	IWDG_PR_PR_DivideBy4 = 0x0
	// Divider /8
	IWDG_PR_PR_DivideBy8 = 0x1
	// Divider /16
	IWDG_PR_PR_DivideBy16 = 0x2
	// Divider /32
	IWDG_PR_PR_DivideBy32 = 0x3
	// Divider /64
	IWDG_PR_PR_DivideBy64 = 0x4
	// Divider /128
	IWDG_PR_PR_DivideBy128 = 0x5
	// Divider /256
	IWDG_PR_PR_DivideBy256 = 0x6
	// Divider /256
	IWDG_PR_PR_DivideBy256bis = 0x7

	// RLR: Reload register
	// Position of RL field.
	IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_RLR_RL_Msk = 0xfff

	// SR: Status register
	// Position of RVU field.
	IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_SR_RVU = 0x2
	// Position of PVU field.
	IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_SR_PVU = 0x1
)

// Constants for WWDG: Window watchdog
const (
	// CR: Control register
	// Position of WDGA field.
	WWDG_CR_WDGA_Pos = 0x7
	// Bit mask of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80
	// Bit WDGA.
	WWDG_CR_WDGA = 0x80
	// Watchdog disabled
	WWDG_CR_WDGA_Disabled = 0x0
	// Watchdog enabled
	WWDG_CR_WDGA_Enabled = 0x1
	// Position of T field.
	WWDG_CR_T_Pos = 0x0
	// Bit mask of T field.
	WWDG_CR_T_Msk = 0x7f

	// CFR: Configuration register
	// Position of EWI field.
	WWDG_CFR_EWI_Pos = 0x9
	// Bit mask of EWI field.
	WWDG_CFR_EWI_Msk = 0x200
	// Bit EWI.
	WWDG_CFR_EWI = 0x200
	// interrupt occurs whenever the counter reaches the value 0x40
	WWDG_CFR_EWI_Enable = 0x1
	// Position of W field.
	WWDG_CFR_W_Pos = 0x0
	// Bit mask of W field.
	WWDG_CFR_W_Msk = 0x7f
	// Position of WDGTB field.
	WWDG_CFR_WDGTB_Pos = 0x7
	// Bit mask of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x180
	// Counter clock (PCLK1 div 4096) div 1
	WWDG_CFR_WDGTB_Div1 = 0x0
	// Counter clock (PCLK1 div 4096) div 2
	WWDG_CFR_WDGTB_Div2 = 0x1
	// Counter clock (PCLK1 div 4096) div 4
	WWDG_CFR_WDGTB_Div4 = 0x2
	// Counter clock (PCLK1 div 4096) div 8
	WWDG_CFR_WDGTB_Div8 = 0x3

	// SR: Status register
	// Position of EWIF field.
	WWDG_SR_EWIF_Pos = 0x0
	// Bit mask of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1
	// Bit EWIF.
	WWDG_SR_EWIF = 0x1
	// The EWI Interrupt Service Routine has been triggered
	WWDG_SR_EWIF_Pending = 0x1
	// The EWI Interrupt Service Routine has been serviced
	WWDG_SR_EWIF_Finished = 0x0
)

// Constants for RTC: Real-time clock
const (
	// TR: time register
	// Position of PM field.
	RTC_TR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TR_PM = 0x400000
	// Position of HT field.
	RTC_TR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TR_SU_Msk = 0xf

	// DR: date register
	// Position of YT field.
	RTC_DR_YT_Pos = 0x14
	// Bit mask of YT field.
	RTC_DR_YT_Msk = 0xf00000
	// Position of YU field.
	RTC_DR_YU_Pos = 0x10
	// Bit mask of YU field.
	RTC_DR_YU_Msk = 0xf0000
	// Position of WDU field.
	RTC_DR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_DR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_DR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_DR_MT_Msk = 0x1000
	// Bit MT.
	RTC_DR_MT = 0x1000
	// Position of MU field.
	RTC_DR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_DR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_DR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_DR_DT_Msk = 0x30
	// Position of DU field.
	RTC_DR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_DR_DU_Msk = 0xf

	// CR: control register
	// Position of COE field.
	RTC_CR_COE_Pos = 0x17
	// Bit mask of COE field.
	RTC_CR_COE_Msk = 0x800000
	// Bit COE.
	RTC_CR_COE = 0x800000
	// Position of OSEL field.
	RTC_CR_OSEL_Pos = 0x15
	// Bit mask of OSEL field.
	RTC_CR_OSEL_Msk = 0x600000
	// Position of POL field.
	RTC_CR_POL_Pos = 0x14
	// Bit mask of POL field.
	RTC_CR_POL_Msk = 0x100000
	// Bit POL.
	RTC_CR_POL = 0x100000
	// Position of BKP field.
	RTC_CR_BKP_Pos = 0x12
	// Bit mask of BKP field.
	RTC_CR_BKP_Msk = 0x40000
	// Bit BKP.
	RTC_CR_BKP = 0x40000
	// Position of SUB1H field.
	RTC_CR_SUB1H_Pos = 0x11
	// Bit mask of SUB1H field.
	RTC_CR_SUB1H_Msk = 0x20000
	// Bit SUB1H.
	RTC_CR_SUB1H = 0x20000
	// Position of ADD1H field.
	RTC_CR_ADD1H_Pos = 0x10
	// Bit mask of ADD1H field.
	RTC_CR_ADD1H_Msk = 0x10000
	// Bit ADD1H.
	RTC_CR_ADD1H = 0x10000
	// Position of TSIE field.
	RTC_CR_TSIE_Pos = 0xf
	// Bit mask of TSIE field.
	RTC_CR_TSIE_Msk = 0x8000
	// Bit TSIE.
	RTC_CR_TSIE = 0x8000
	// Position of WUTIE field.
	RTC_CR_WUTIE_Pos = 0xe
	// Bit mask of WUTIE field.
	RTC_CR_WUTIE_Msk = 0x4000
	// Bit WUTIE.
	RTC_CR_WUTIE = 0x4000
	// Position of ALRBIE field.
	RTC_CR_ALRBIE_Pos = 0xd
	// Bit mask of ALRBIE field.
	RTC_CR_ALRBIE_Msk = 0x2000
	// Bit ALRBIE.
	RTC_CR_ALRBIE = 0x2000
	// Position of ALRAIE field.
	RTC_CR_ALRAIE_Pos = 0xc
	// Bit mask of ALRAIE field.
	RTC_CR_ALRAIE_Msk = 0x1000
	// Bit ALRAIE.
	RTC_CR_ALRAIE = 0x1000
	// Position of TSE field.
	RTC_CR_TSE_Pos = 0xb
	// Bit mask of TSE field.
	RTC_CR_TSE_Msk = 0x800
	// Bit TSE.
	RTC_CR_TSE = 0x800
	// Position of WUTE field.
	RTC_CR_WUTE_Pos = 0xa
	// Bit mask of WUTE field.
	RTC_CR_WUTE_Msk = 0x400
	// Bit WUTE.
	RTC_CR_WUTE = 0x400
	// Position of ALRBE field.
	RTC_CR_ALRBE_Pos = 0x9
	// Bit mask of ALRBE field.
	RTC_CR_ALRBE_Msk = 0x200
	// Bit ALRBE.
	RTC_CR_ALRBE = 0x200
	// Position of ALRAE field.
	RTC_CR_ALRAE_Pos = 0x8
	// Bit mask of ALRAE field.
	RTC_CR_ALRAE_Msk = 0x100
	// Bit ALRAE.
	RTC_CR_ALRAE = 0x100
	// Position of DCE field.
	RTC_CR_DCE_Pos = 0x7
	// Bit mask of DCE field.
	RTC_CR_DCE_Msk = 0x80
	// Bit DCE.
	RTC_CR_DCE = 0x80
	// Position of FMT field.
	RTC_CR_FMT_Pos = 0x6
	// Bit mask of FMT field.
	RTC_CR_FMT_Msk = 0x40
	// Bit FMT.
	RTC_CR_FMT = 0x40
	// Position of REFCKON field.
	RTC_CR_REFCKON_Pos = 0x4
	// Bit mask of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10
	// Bit REFCKON.
	RTC_CR_REFCKON = 0x10
	// Position of TSEDGE field.
	RTC_CR_TSEDGE_Pos = 0x3
	// Bit mask of TSEDGE field.
	RTC_CR_TSEDGE_Msk = 0x8
	// Bit TSEDGE.
	RTC_CR_TSEDGE = 0x8
	// Position of WUCKSEL field.
	RTC_CR_WUCKSEL_Pos = 0x0
	// Bit mask of WUCKSEL field.
	RTC_CR_WUCKSEL_Msk = 0x7

	// ISR: initialization and status register
	// Position of TAMP1F field.
	RTC_ISR_TAMP1F_Pos = 0xd
	// Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F_Msk = 0x2000
	// Bit TAMP1F.
	RTC_ISR_TAMP1F = 0x2000
	// Position of TSOVF field.
	RTC_ISR_TSOVF_Pos = 0xc
	// Bit mask of TSOVF field.
	RTC_ISR_TSOVF_Msk = 0x1000
	// Bit TSOVF.
	RTC_ISR_TSOVF = 0x1000
	// Position of TSF field.
	RTC_ISR_TSF_Pos = 0xb
	// Bit mask of TSF field.
	RTC_ISR_TSF_Msk = 0x800
	// Bit TSF.
	RTC_ISR_TSF = 0x800
	// Position of WUTF field.
	RTC_ISR_WUTF_Pos = 0xa
	// Bit mask of WUTF field.
	RTC_ISR_WUTF_Msk = 0x400
	// Bit WUTF.
	RTC_ISR_WUTF = 0x400
	// Position of ALRBF field.
	RTC_ISR_ALRBF_Pos = 0x9
	// Bit mask of ALRBF field.
	RTC_ISR_ALRBF_Msk = 0x200
	// Bit ALRBF.
	RTC_ISR_ALRBF = 0x200
	// Position of ALRAF field.
	RTC_ISR_ALRAF_Pos = 0x8
	// Bit mask of ALRAF field.
	RTC_ISR_ALRAF_Msk = 0x100
	// Bit ALRAF.
	RTC_ISR_ALRAF = 0x100
	// Position of INIT field.
	RTC_ISR_INIT_Pos = 0x7
	// Bit mask of INIT field.
	RTC_ISR_INIT_Msk = 0x80
	// Bit INIT.
	RTC_ISR_INIT = 0x80
	// Position of INITF field.
	RTC_ISR_INITF_Pos = 0x6
	// Bit mask of INITF field.
	RTC_ISR_INITF_Msk = 0x40
	// Bit INITF.
	RTC_ISR_INITF = 0x40
	// Position of RSF field.
	RTC_ISR_RSF_Pos = 0x5
	// Bit mask of RSF field.
	RTC_ISR_RSF_Msk = 0x20
	// Bit RSF.
	RTC_ISR_RSF = 0x20
	// Position of INITS field.
	RTC_ISR_INITS_Pos = 0x4
	// Bit mask of INITS field.
	RTC_ISR_INITS_Msk = 0x10
	// Bit INITS.
	RTC_ISR_INITS = 0x10
	// Position of WUTWF field.
	RTC_ISR_WUTWF_Pos = 0x2
	// Bit mask of WUTWF field.
	RTC_ISR_WUTWF_Msk = 0x4
	// Bit WUTWF.
	RTC_ISR_WUTWF = 0x4
	// Position of ALRBWF field.
	RTC_ISR_ALRBWF_Pos = 0x1
	// Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF_Msk = 0x2
	// Bit ALRBWF.
	RTC_ISR_ALRBWF = 0x2
	// Position of ALRAWF field.
	RTC_ISR_ALRAWF_Pos = 0x0
	// Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF_Msk = 0x1
	// Bit ALRAWF.
	RTC_ISR_ALRAWF = 0x1

	// PRER: prescaler register
	// Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Pos = 0x10
	// Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000
	// Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Pos = 0x0
	// Bit mask of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x1fff

	// WUTR: wakeup timer register
	// Position of WUT field.
	RTC_WUTR_WUT_Pos = 0x0
	// Bit mask of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff

	// CALIBR: calibration register
	// Position of DCS field.
	RTC_CALIBR_DCS_Pos = 0x7
	// Bit mask of DCS field.
	RTC_CALIBR_DCS_Msk = 0x80
	// Bit DCS.
	RTC_CALIBR_DCS = 0x80
	// Position of DC field.
	RTC_CALIBR_DC_Pos = 0x0
	// Bit mask of DC field.
	RTC_CALIBR_DC_Msk = 0x1f

	// ALRMAR: alarm A register
	// Position of MSK4 field.
	RTC_ALRMAR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMAR_MSK4 = 0x80000000
	// Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMAR_WDSEL = 0x40000000
	// Position of DT field.
	RTC_ALRMAR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMAR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMAR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMAR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMAR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMAR_MSK3 = 0x800000
	// Position of PM field.
	RTC_ALRMAR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMAR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMAR_PM = 0x400000
	// Position of HT field.
	RTC_ALRMAR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMAR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMAR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMAR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMAR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMAR_MSK2 = 0x8000
	// Position of MNT field.
	RTC_ALRMAR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMAR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMAR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMAR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMAR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMAR_MSK1 = 0x80
	// Position of ST field.
	RTC_ALRMAR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMAR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMAR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMAR_SU_Msk = 0xf

	// ALRMBR: alarm B register
	// Position of MSK4 field.
	RTC_ALRMBR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMBR_MSK4 = 0x80000000
	// Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMBR_WDSEL = 0x40000000
	// Position of DT field.
	RTC_ALRMBR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMBR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMBR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMBR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMBR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMBR_MSK3 = 0x800000
	// Position of PM field.
	RTC_ALRMBR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMBR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMBR_PM = 0x400000
	// Position of HT field.
	RTC_ALRMBR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMBR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMBR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMBR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMBR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMBR_MSK2 = 0x8000
	// Position of MNT field.
	RTC_ALRMBR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMBR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMBR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMBR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMBR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMBR_MSK1 = 0x80
	// Position of ST field.
	RTC_ALRMBR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMBR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMBR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMBR_SU_Msk = 0xf

	// WPR: write protection register
	// Position of KEY field.
	RTC_WPR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	RTC_WPR_KEY_Msk = 0xff

	// TSTR: time stamp time register
	// Position of SU field.
	RTC_TSTR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TSTR_SU_Msk = 0xf
	// Position of ST field.
	RTC_TSTR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TSTR_ST_Msk = 0x70
	// Position of MNU field.
	RTC_TSTR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00
	// Position of MNT field.
	RTC_TSTR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000
	// Position of HU field.
	RTC_TSTR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TSTR_HU_Msk = 0xf0000
	// Position of HT field.
	RTC_TSTR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TSTR_HT_Msk = 0x300000
	// Position of PM field.
	RTC_TSTR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TSTR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TSTR_PM = 0x400000

	// TSDR: time stamp date register
	// Position of WDU field.
	RTC_TSDR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_TSDR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_TSDR_MT_Msk = 0x1000
	// Bit MT.
	RTC_TSDR_MT = 0x1000
	// Position of MU field.
	RTC_TSDR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_TSDR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_TSDR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_TSDR_DT_Msk = 0x30
	// Position of DU field.
	RTC_TSDR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_TSDR_DU_Msk = 0xf

	// TAFCR: tamper and alternate function configuration register
	// Position of ALARMOUTTYPE field.
	RTC_TAFCR_ALARMOUTTYPE_Pos = 0x12
	// Bit mask of ALARMOUTTYPE field.
	RTC_TAFCR_ALARMOUTTYPE_Msk = 0x40000
	// Bit ALARMOUTTYPE.
	RTC_TAFCR_ALARMOUTTYPE = 0x40000
	// Position of TSINSEL field.
	RTC_TAFCR_TSINSEL_Pos = 0x11
	// Bit mask of TSINSEL field.
	RTC_TAFCR_TSINSEL_Msk = 0x20000
	// Bit TSINSEL.
	RTC_TAFCR_TSINSEL = 0x20000
	// Position of TAMP1INSEL field.
	RTC_TAFCR_TAMP1INSEL_Pos = 0x10
	// Bit mask of TAMP1INSEL field.
	RTC_TAFCR_TAMP1INSEL_Msk = 0x10000
	// Bit TAMP1INSEL.
	RTC_TAFCR_TAMP1INSEL = 0x10000
	// Position of TAMPIE field.
	RTC_TAFCR_TAMPIE_Pos = 0x2
	// Bit mask of TAMPIE field.
	RTC_TAFCR_TAMPIE_Msk = 0x4
	// Bit TAMPIE.
	RTC_TAFCR_TAMPIE = 0x4
	// Position of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG_Pos = 0x1
	// Bit mask of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG_Msk = 0x2
	// Bit TAMP1TRG.
	RTC_TAFCR_TAMP1TRG = 0x2
	// Position of TAMP1E field.
	RTC_TAFCR_TAMP1E_Pos = 0x0
	// Bit mask of TAMP1E field.
	RTC_TAFCR_TAMP1E_Msk = 0x1
	// Bit TAMP1E.
	RTC_TAFCR_TAMP1E = 0x1

	// BKP0R: backup register
	// Position of BKP field.
	RTC_BKPR_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKPR_BKP_Msk = 0xffffffff
)

// Constants for TIM1: Advanced-timers
const (
	// CR1: control register 1
	// Position of CKD field.
	TIM_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	TIM_CR1_CKD_Msk = 0x300
	// t_DTS = t_CK_INT
	TIM_CR1_CKD_Div1 = 0x0
	// t_DTS = 2 × t_CK_INT
	TIM_CR1_CKD_Div2 = 0x1
	// t_DTS = 4 × t_CK_INT
	TIM_CR1_CKD_Div4 = 0x2
	// Position of ARPE field.
	TIM_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	TIM_CR1_ARPE = 0x80
	// TIMx_APRR register is not buffered
	TIM_CR1_ARPE_Disabled = 0x0
	// TIMx_APRR register is buffered
	TIM_CR1_ARPE_Enabled = 0x1
	// Position of CMS field.
	TIM_CR1_CMS_Pos = 0x5
	// Bit mask of CMS field.
	TIM_CR1_CMS_Msk = 0x60
	// The counter counts up or down depending on the direction bit
	TIM_CR1_CMS_EdgeAligned = 0x0
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting down.
	TIM_CR1_CMS_CenterAligned1 = 0x1
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting up.
	TIM_CR1_CMS_CenterAligned2 = 0x2
	// The counter counts up and down alternatively. Output compare interrupt flags are set both when the counter is counting up or down.
	TIM_CR1_CMS_CenterAligned3 = 0x3
	// Position of DIR field.
	TIM_CR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	TIM_CR1_DIR_Msk = 0x10
	// Bit DIR.
	TIM_CR1_DIR = 0x10
	// Counter used as upcounter
	TIM_CR1_DIR_Up = 0x0
	// Counter used as downcounter
	TIM_CR1_DIR_Down = 0x1
	// Position of OPM field.
	TIM_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	TIM_CR1_OPM_Msk = 0x8
	// Bit OPM.
	TIM_CR1_OPM = 0x8
	// Counter is not stopped at update event
	TIM_CR1_OPM_Disabled = 0x0
	// Counter stops counting at the next update event (clearing the CEN bit)
	TIM_CR1_OPM_Enabled = 0x1
	// Position of URS field.
	TIM_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	TIM_CR1_URS_Msk = 0x4
	// Bit URS.
	TIM_CR1_URS = 0x4
	// Any of counter overflow/underflow, setting UG, or update through slave mode, generates an update interrupt or DMA request
	TIM_CR1_URS_AnyEvent = 0x0
	// Only counter overflow/underflow generates an update interrupt or DMA request
	TIM_CR1_URS_CounterOnly = 0x1
	// Position of UDIS field.
	TIM_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	TIM_CR1_UDIS = 0x2
	// Update event enabled
	TIM_CR1_UDIS_Enabled = 0x0
	// Update event disabled
	TIM_CR1_UDIS_Disabled = 0x1
	// Position of CEN field.
	TIM_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIM_CR1_CEN_Msk = 0x1
	// Bit CEN.
	TIM_CR1_CEN = 0x1
	// Counter disabled
	TIM_CR1_CEN_Disabled = 0x0
	// Counter enabled
	TIM_CR1_CEN_Enabled = 0x1

	// CR2: control register 2
	// Position of OIS4 field.
	TIM_CR2_OIS4_Pos = 0xe
	// Bit mask of OIS4 field.
	TIM_CR2_OIS4_Msk = 0x4000
	// Bit OIS4.
	TIM_CR2_OIS4 = 0x4000
	// Position of OIS3N field.
	TIM_CR2_OIS3N_Pos = 0xd
	// Bit mask of OIS3N field.
	TIM_CR2_OIS3N_Msk = 0x2000
	// Bit OIS3N.
	TIM_CR2_OIS3N = 0x2000
	// Position of OIS3 field.
	TIM_CR2_OIS3_Pos = 0xc
	// Bit mask of OIS3 field.
	TIM_CR2_OIS3_Msk = 0x1000
	// Bit OIS3.
	TIM_CR2_OIS3 = 0x1000
	// Position of OIS2N field.
	TIM_CR2_OIS2N_Pos = 0xb
	// Bit mask of OIS2N field.
	TIM_CR2_OIS2N_Msk = 0x800
	// Bit OIS2N.
	TIM_CR2_OIS2N = 0x800
	// Position of OIS2 field.
	TIM_CR2_OIS2_Pos = 0xa
	// Bit mask of OIS2 field.
	TIM_CR2_OIS2_Msk = 0x400
	// Bit OIS2.
	TIM_CR2_OIS2 = 0x400
	// Position of OIS1N field.
	TIM_CR2_OIS1N_Pos = 0x9
	// Bit mask of OIS1N field.
	TIM_CR2_OIS1N_Msk = 0x200
	// Bit OIS1N.
	TIM_CR2_OIS1N = 0x200
	// Position of OIS1 field.
	TIM_CR2_OIS1_Pos = 0x8
	// Bit mask of OIS1 field.
	TIM_CR2_OIS1_Msk = 0x100
	// Bit OIS1.
	TIM_CR2_OIS1 = 0x100
	// Position of TI1S field.
	TIM_CR2_TI1S_Pos = 0x7
	// Bit mask of TI1S field.
	TIM_CR2_TI1S_Msk = 0x80
	// Bit TI1S.
	TIM_CR2_TI1S = 0x80
	// The TIMx_CH1 pin is connected to TI1 input
	TIM_CR2_TI1S_Normal = 0x0
	// The TIMx_CH1, CH2, CH3 pins are connected to TI1 input
	TIM_CR2_TI1S_XOR = 0x1
	// Position of MMS field.
	TIM_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	TIM_CR2_MMS_Msk = 0x70
	// The UG bit from the TIMx_EGR register is used as trigger output
	TIM_CR2_MMS_Reset = 0x0
	// The counter enable signal, CNT_EN, is used as trigger output
	TIM_CR2_MMS_Enable = 0x1
	// The update event is selected as trigger output
	TIM_CR2_MMS_Update = 0x2
	// The trigger output send a positive pulse when the CC1IF flag it to be set, as soon as a capture or a compare match occurred
	TIM_CR2_MMS_ComparePulse = 0x3
	// OC1REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC1 = 0x4
	// OC2REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC2 = 0x5
	// OC3REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC3 = 0x6
	// OC4REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC4 = 0x7
	// Position of CCDS field.
	TIM_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	TIM_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	TIM_CR2_CCDS = 0x8
	// CCx DMA request sent when CCx event occurs
	TIM_CR2_CCDS_OnCompare = 0x0
	// CCx DMA request sent when update event occurs
	TIM_CR2_CCDS_OnUpdate = 0x1
	// Position of CCUS field.
	TIM_CR2_CCUS_Pos = 0x2
	// Bit mask of CCUS field.
	TIM_CR2_CCUS_Msk = 0x4
	// Bit CCUS.
	TIM_CR2_CCUS = 0x4
	// Position of CCPC field.
	TIM_CR2_CCPC_Pos = 0x0
	// Bit mask of CCPC field.
	TIM_CR2_CCPC_Msk = 0x1
	// Bit CCPC.
	TIM_CR2_CCPC = 0x1

	// SMCR: slave mode control register
	// Position of ETP field.
	TIM_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	TIM_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	TIM_SMCR_ETP = 0x8000
	// ETR is noninverted, active at high level or rising edge
	TIM_SMCR_ETP_NotInverted = 0x0
	// ETR is inverted, active at low level or falling edge
	TIM_SMCR_ETP_Inverted = 0x1
	// Position of ECE field.
	TIM_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	TIM_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	TIM_SMCR_ECE = 0x4000
	// External clock mode 2 disabled
	TIM_SMCR_ECE_Disabled = 0x0
	// External clock mode 2 enabled. The counter is clocked by any active edge on the ETRF signal.
	TIM_SMCR_ECE_Enabled = 0x1
	// Position of ETPS field.
	TIM_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000
	// Prescaler OFF
	TIM_SMCR_ETPS_Div1 = 0x0
	// ETRP frequency divided by 2
	TIM_SMCR_ETPS_Div2 = 0x1
	// ETRP frequency divided by 4
	TIM_SMCR_ETPS_Div4 = 0x2
	// ETRP frequency divided by 8
	TIM_SMCR_ETPS_Div8 = 0x3
	// Position of ETF field.
	TIM_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	TIM_SMCR_ETF_Msk = 0xf00
	// No filter, sampling is done at fDTS
	TIM_SMCR_ETF_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_SMCR_ETF_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_SMCR_ETF_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_SMCR_ETF_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_SMCR_ETF_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_SMCR_ETF_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_SMCR_ETF_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_SMCR_ETF_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_SMCR_ETF_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_SMCR_ETF_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_SMCR_ETF_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_SMCR_ETF_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_SMCR_ETF_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_SMCR_ETF_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_SMCR_ETF_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_SMCR_ETF_FDTS_Div32_N8 = 0xf
	// Position of MSM field.
	TIM_SMCR_MSM_Pos = 0x7
	// Bit mask of MSM field.
	TIM_SMCR_MSM_Msk = 0x80
	// Bit MSM.
	TIM_SMCR_MSM = 0x80
	// No action
	TIM_SMCR_MSM_NoSync = 0x0
	// The effect of an event on the trigger input (TRGI) is delayed to allow a perfect synchronization between the current timer and its slaves (through TRGO). It is useful if we want to synchronize several timers on a single external event.
	TIM_SMCR_MSM_Sync = 0x1
	// Position of TS field.
	TIM_SMCR_TS_Pos = 0x4
	// Bit mask of TS field.
	TIM_SMCR_TS_Msk = 0x70
	// Internal Trigger 0 (ITR0)
	TIM_SMCR_TS_ITR0 = 0x0
	// Internal Trigger 1 (ITR1)
	TIM_SMCR_TS_ITR1 = 0x1
	// Internal Trigger 2 (ITR2)
	TIM_SMCR_TS_ITR2 = 0x2
	// TI1 Edge Detector (TI1F_ED)
	TIM_SMCR_TS_TI1F_ED = 0x4
	// Filtered Timer Input 1 (TI1FP1)
	TIM_SMCR_TS_TI1FP1 = 0x5
	// Filtered Timer Input 2 (TI2FP2)
	TIM_SMCR_TS_TI2FP2 = 0x6
	// External Trigger input (ETRF)
	TIM_SMCR_TS_ETRF = 0x7
	// Position of SMS field.
	TIM_SMCR_SMS_Pos = 0x0
	// Bit mask of SMS field.
	TIM_SMCR_SMS_Msk = 0x7
	// Slave mode disabled - if CEN = ‘1 then the prescaler is clocked directly by the internal clock.
	TIM_SMCR_SMS_Disabled = 0x0
	// Encoder mode 1 - Counter counts up/down on TI2FP1 edge depending on TI1FP2 level.
	TIM_SMCR_SMS_Encoder_Mode_1 = 0x1
	// Encoder mode 2 - Counter counts up/down on TI1FP2 edge depending on TI2FP1 level.
	TIM_SMCR_SMS_Encoder_Mode_2 = 0x2
	// Encoder mode 3 - Counter counts up/down on both TI1FP1 and TI2FP2 edges depending on the level of the other input.
	TIM_SMCR_SMS_Encoder_Mode_3 = 0x3
	// Reset Mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter and generates an update of the registers.
	TIM_SMCR_SMS_Reset_Mode = 0x4
	// Gated Mode - The counter clock is enabled when the trigger input (TRGI) is high. The counter stops (but is not reset) as soon as the trigger becomes low. Both start and stop of the counter are controlled.
	TIM_SMCR_SMS_Gated_Mode = 0x5
	// Trigger Mode - The counter starts at a rising edge of the trigger TRGI (but it is not reset). Only the start of the counter is controlled.
	TIM_SMCR_SMS_Trigger_Mode = 0x6
	// External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.
	TIM_SMCR_SMS_Ext_Clock_Mode = 0x7

	// DIER: DMA/Interrupt enable register
	// Position of TDE field.
	TIM_DIER_TDE_Pos = 0xe
	// Bit mask of TDE field.
	TIM_DIER_TDE_Msk = 0x4000
	// Bit TDE.
	TIM_DIER_TDE = 0x4000
	// Trigger DMA request disabled
	TIM_DIER_TDE_Disabled = 0x0
	// Trigger DMA request enabled
	TIM_DIER_TDE_Enabled = 0x1
	// Position of COMDE field.
	TIM_DIER_COMDE_Pos = 0xd
	// Bit mask of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000
	// Bit COMDE.
	TIM_DIER_COMDE = 0x2000
	// Position of CC4DE field.
	TIM_DIER_CC4DE_Pos = 0xc
	// Bit mask of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000
	// Bit CC4DE.
	TIM_DIER_CC4DE = 0x1000
	// CCx DMA request disabled
	TIM_DIER_CC4DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC4DE_Enabled = 0x1
	// Position of CC3DE field.
	TIM_DIER_CC3DE_Pos = 0xb
	// Bit mask of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800
	// Bit CC3DE.
	TIM_DIER_CC3DE = 0x800
	// CCx DMA request disabled
	TIM_DIER_CC3DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC3DE_Enabled = 0x1
	// Position of CC2DE field.
	TIM_DIER_CC2DE_Pos = 0xa
	// Bit mask of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400
	// Bit CC2DE.
	TIM_DIER_CC2DE = 0x400
	// CCx DMA request disabled
	TIM_DIER_CC2DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC2DE_Enabled = 0x1
	// Position of CC1DE field.
	TIM_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	TIM_DIER_CC1DE = 0x200
	// CCx DMA request disabled
	TIM_DIER_CC1DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC1DE_Enabled = 0x1
	// Position of UDE field.
	TIM_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	TIM_DIER_UDE_Msk = 0x100
	// Bit UDE.
	TIM_DIER_UDE = 0x100
	// Update DMA request disabled
	TIM_DIER_UDE_Disabled = 0x0
	// Update DMA request enabled
	TIM_DIER_UDE_Enabled = 0x1
	// Position of BIE field.
	TIM_DIER_BIE_Pos = 0x7
	// Bit mask of BIE field.
	TIM_DIER_BIE_Msk = 0x80
	// Bit BIE.
	TIM_DIER_BIE = 0x80
	// Position of TIE field.
	TIM_DIER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	TIM_DIER_TIE_Msk = 0x40
	// Bit TIE.
	TIM_DIER_TIE = 0x40
	// Trigger interrupt disabled
	TIM_DIER_TIE_Disabled = 0x0
	// Trigger interrupt enabled
	TIM_DIER_TIE_Enabled = 0x1
	// Position of COMIE field.
	TIM_DIER_COMIE_Pos = 0x5
	// Bit mask of COMIE field.
	TIM_DIER_COMIE_Msk = 0x20
	// Bit COMIE.
	TIM_DIER_COMIE = 0x20
	// Position of CC4IE field.
	TIM_DIER_CC4IE_Pos = 0x4
	// Bit mask of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10
	// Bit CC4IE.
	TIM_DIER_CC4IE = 0x10
	// CCx interrupt disabled
	TIM_DIER_CC4IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC4IE_Enabled = 0x1
	// Position of CC3IE field.
	TIM_DIER_CC3IE_Pos = 0x3
	// Bit mask of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8
	// Bit CC3IE.
	TIM_DIER_CC3IE = 0x8
	// CCx interrupt disabled
	TIM_DIER_CC3IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC3IE_Enabled = 0x1
	// Position of CC2IE field.
	TIM_DIER_CC2IE_Pos = 0x2
	// Bit mask of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4
	// Bit CC2IE.
	TIM_DIER_CC2IE = 0x4
	// CCx interrupt disabled
	TIM_DIER_CC2IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC2IE_Enabled = 0x1
	// Position of CC1IE field.
	TIM_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	TIM_DIER_CC1IE = 0x2
	// CCx interrupt disabled
	TIM_DIER_CC1IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC1IE_Enabled = 0x1
	// Position of UIE field.
	TIM_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	TIM_DIER_UIE_Msk = 0x1
	// Bit UIE.
	TIM_DIER_UIE = 0x1
	// Update interrupt disabled
	TIM_DIER_UIE_Disabled = 0x0
	// Update interrupt enabled
	TIM_DIER_UIE_Enabled = 0x1

	// SR: status register
	// Position of CC4OF field.
	TIM_SR_CC4OF_Pos = 0xc
	// Bit mask of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000
	// Bit CC4OF.
	TIM_SR_CC4OF = 0x1000
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC4OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC4OF_Clear = 0x0
	// Position of CC3OF field.
	TIM_SR_CC3OF_Pos = 0xb
	// Bit mask of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800
	// Bit CC3OF.
	TIM_SR_CC3OF = 0x800
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC3OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC3OF_Clear = 0x0
	// Position of CC2OF field.
	TIM_SR_CC2OF_Pos = 0xa
	// Bit mask of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400
	// Bit CC2OF.
	TIM_SR_CC2OF = 0x400
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC2OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC2OF_Clear = 0x0
	// Position of CC1OF field.
	TIM_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	TIM_SR_CC1OF = 0x200
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC1OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC1OF_Clear = 0x0
	// Position of BIF field.
	TIM_SR_BIF_Pos = 0x7
	// Bit mask of BIF field.
	TIM_SR_BIF_Msk = 0x80
	// Bit BIF.
	TIM_SR_BIF = 0x80
	// Position of TIF field.
	TIM_SR_TIF_Pos = 0x6
	// Bit mask of TIF field.
	TIM_SR_TIF_Msk = 0x40
	// Bit TIF.
	TIM_SR_TIF = 0x40
	// No trigger event occurred
	TIM_SR_TIF_NoTrigger = 0x0
	// Trigger interrupt pending
	TIM_SR_TIF_Trigger = 0x1
	// Clear flag
	TIM_SR_TIF_Clear = 0x0
	// Position of COMIF field.
	TIM_SR_COMIF_Pos = 0x5
	// Bit mask of COMIF field.
	TIM_SR_COMIF_Msk = 0x20
	// Bit COMIF.
	TIM_SR_COMIF = 0x20
	// Position of CC4IF field.
	TIM_SR_CC4IF_Pos = 0x4
	// Bit mask of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10
	// Bit CC4IF.
	TIM_SR_CC4IF = 0x10
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC4IF_Match = 0x1
	// Clear flag
	TIM_SR_CC4IF_Clear = 0x0
	// Position of CC3IF field.
	TIM_SR_CC3IF_Pos = 0x3
	// Bit mask of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8
	// Bit CC3IF.
	TIM_SR_CC3IF = 0x8
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC3IF_Match = 0x1
	// Clear flag
	TIM_SR_CC3IF_Clear = 0x0
	// Position of CC2IF field.
	TIM_SR_CC2IF_Pos = 0x2
	// Bit mask of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4
	// Bit CC2IF.
	TIM_SR_CC2IF = 0x4
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC2IF_Match = 0x1
	// Clear flag
	TIM_SR_CC2IF_Clear = 0x0
	// Position of CC1IF field.
	TIM_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	TIM_SR_CC1IF = 0x2
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC1IF_Match = 0x1
	// Clear flag
	TIM_SR_CC1IF_Clear = 0x0
	// Position of UIF field.
	TIM_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	TIM_SR_UIF_Msk = 0x1
	// Bit UIF.
	TIM_SR_UIF = 0x1
	// No update occurred
	TIM_SR_UIF_Clear = 0x0
	// Update interrupt pending.
	TIM_SR_UIF_UpdatePending = 0x1

	// EGR: event generation register
	// Position of BG field.
	TIM_EGR_BG_Pos = 0x7
	// Bit mask of BG field.
	TIM_EGR_BG_Msk = 0x80
	// Bit BG.
	TIM_EGR_BG = 0x80
	// Position of TG field.
	TIM_EGR_TG_Pos = 0x6
	// Bit mask of TG field.
	TIM_EGR_TG_Msk = 0x40
	// Bit TG.
	TIM_EGR_TG = 0x40
	// The TIF flag is set in TIMx_SR register. Related interrupt or DMA transfer can occur if enabled.
	TIM_EGR_TG_Trigger = 0x1
	// Position of COMG field.
	TIM_EGR_COMG_Pos = 0x5
	// Bit mask of COMG field.
	TIM_EGR_COMG_Msk = 0x20
	// Bit COMG.
	TIM_EGR_COMG = 0x20
	// Position of CC4G field.
	TIM_EGR_CC4G_Pos = 0x4
	// Bit mask of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10
	// Bit CC4G.
	TIM_EGR_CC4G = 0x10
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC4G_Trigger = 0x1
	// Position of CC3G field.
	TIM_EGR_CC3G_Pos = 0x3
	// Bit mask of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8
	// Bit CC3G.
	TIM_EGR_CC3G = 0x8
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC3G_Trigger = 0x1
	// Position of CC2G field.
	TIM_EGR_CC2G_Pos = 0x2
	// Bit mask of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4
	// Bit CC2G.
	TIM_EGR_CC2G = 0x4
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC2G_Trigger = 0x1
	// Position of CC1G field.
	TIM_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	TIM_EGR_CC1G = 0x2
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC1G_Trigger = 0x1
	// Position of UG field.
	TIM_EGR_UG