import Tracer from './tracer.js';
export interface OngoingRequestCanceller {
    readonly cancellationPipeName: string | undefined;
    tryCancelOngoingRequest(seq: number): boolean;
}
export interface OngoingRequestCancellerFactory {
    create(serverId: string, tracer: Tracer): OngoingRequestCanceller;
}
export declare const noopRequestCancellerFactory: {
    create(_serverId: string, _tracer: Tracer): OngoingRequestCanceller;
};
export declare class NodeRequestCanceller implements OngoingRequestCanceller {
    private readonly _serverId;
    private readonly _tracer;
    readonly cancellationPipeName: string;
    constructor(_serverId: string, _tracer: Tracer);
    tryCancelOngoingRequest(seq: number): boolean;
}
export declare const nodeRequestCancellerFactory: {
    create(serverId: string, tracer: Tracer): OngoingRequestCanceller;
};
//# sourceMappingURL=cancellation.d.ts.map