/// <reference types="node" resolution-mode="require"/>
import { CancellationToken } from 'vscode-jsonrpc';
import { ServerResponse, ServerType, TypeScriptRequestTypes } from './requests.js';
import type { tsp } from '../ts-protocol.js';
import type { TspClientOptions } from '../tsp-client.js';
import { OngoingRequestCanceller } from './cancellation.js';
import type Tracer from './tracer.js';
import type { TypeScriptVersion } from './versionProvider.js';
export declare enum ExecutionTarget {
    Semantic = 0,
    Syntax = 1
}
export interface TypeScriptServerExitEvent {
    readonly code: number | null;
    readonly signal: NodeJS.Signals | null;
}
type OnEventHandler = (e: tsp.Event) => any;
type OnExitHandler = (e: TypeScriptServerExitEvent) => any;
type OnErrorHandler = (e: any) => any;
type OnStdErrHandler = (e: string) => any;
export interface ITypeScriptServer {
    onEvent(handler: OnEventHandler): void;
    onExit(handler: OnExitHandler): void;
    onError(handler: OnErrorHandler): void;
    onStdErr(handler: OnStdErrHandler): void;
    readonly tsServerLogFile: string | undefined;
    kill(): void;
    /**
     * @return A list of all execute requests. If there are multiple entries, the first item is the primary
     * request while the rest are secondary ones.
     */
    executeImpl(command: keyof TypeScriptRequestTypes, args: any, executeInfo: {
        isAsync: boolean;
        token?: CancellationToken;
        expectsResult: boolean;
        lowPriority?: boolean;
        executionTarget?: ExecutionTarget;
    }): Array<Promise<ServerResponse.Response<tsp.Response>> | undefined>;
    dispose(): void;
}
export declare const enum TsServerProcessKind {
    Main = "main",
    Syntax = "syntax",
    Semantic = "semantic",
    Diagnostics = "diagnostics"
}
export interface TsServerProcessFactory {
    fork(version: TypeScriptVersion, args: readonly string[], kind: TsServerProcessKind, configuration: TspClientOptions): TsServerProcess;
}
export interface TsServerProcess {
    write(serverRequest: tsp.Request): void;
    onData(handler: (data: tsp.Response) => void): void;
    onExit(handler: (code: number | null, signal: NodeJS.Signals | null) => void): void;
    onError(handler: (error: Error) => void): void;
    onStdErr(handler: (code: string) => void): void;
    kill(): void;
}
export declare class ProcessBasedTsServer implements ITypeScriptServer {
    private readonly _serverId;
    private readonly _serverSource;
    private readonly _process;
    private readonly _tsServerLogFile;
    private readonly _requestCanceller;
    private readonly _version;
    private readonly _tracer;
    private readonly _requestQueue;
    private readonly _callbacks;
    private readonly _pendingResponses;
    private readonly _eventHandlers;
    private readonly _exitHandlers;
    private readonly _errorHandlers;
    private readonly _stdErrHandlers;
    constructor(_serverId: string, _serverSource: ServerType, _process: TsServerProcess, _tsServerLogFile: string | undefined, _requestCanceller: OngoingRequestCanceller, _version: TypeScriptVersion, _tracer: Tracer);
    onEvent(handler: OnEventHandler): void;
    onExit(handler: OnExitHandler): void;
    onStdErr(handler: OnStdErrHandler): void;
    onError(handler: OnErrorHandler): void;
    get tsServerLogFile(): string | undefined;
    private write;
    dispose(): void;
    kill(): void;
    private dispatchMessage;
    private tryCancelRequest;
    private dispatchResponse;
    executeImpl(command: keyof TypeScriptRequestTypes, args: any, executeInfo: {
        isAsync: boolean;
        token?: CancellationToken;
        expectsResult: boolean;
        lowPriority?: boolean;
        executionTarget?: ExecutionTarget;
    }): Array<Promise<ServerResponse.Response<tsp.Response>> | undefined>;
    private sendNextRequests;
    private sendRequest;
    private fetchCallback;
    private logTrace;
    private static readonly fenceCommands;
    private static getQueueingType;
}
export {};
//# sourceMappingURL=server.d.ts.map