/* HotCorner.c generated by valac 0.56.3, the Vala compiler
 * generated from HotCorner.vala, do not modify */

/*
 * Copyright 2021 elementary, Inc (https://elementary.io)
 *           2021 José Expósito <jose.exposito89@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <meta/barrier.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <meta/display.h>
#include <stdlib.h>
#include <string.h>
#include <meta/boxes.h>
#include <clutter/clutter.h>

#define GALA_HOT_CORNER_POSITION_TOP_LEFT "hotcorner-topleft"
#define GALA_HOT_CORNER_POSITION_TOP_RIGHT "hotcorner-topright"
#define GALA_HOT_CORNER_POSITION_BOTTOM_LEFT "hotcorner-bottomleft"
#define GALA_HOT_CORNER_POSITION_BOTTOM_RIGHT "hotcorner-bottomright"
#define GALA_HOT_CORNER_BARRIER_SIZE 30
#define GALA_HOT_CORNER_TRIGGER_PRESSURE_THRESHOLD 50
#define GALA_HOT_CORNER_RELEASE_PRESSURE_THRESHOLD 100
#define GALA_HOT_CORNER_RETRIGGER_PRESSURE_THRESHOLD 500
#define GALA_HOT_CORNER_RETRIGGER_DELAY 600
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_BARRIER (gala_barrier_get_type ())
#define GALA_BARRIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BARRIER, GalaBarrier))
#define GALA_BARRIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BARRIER, GalaBarrierClass))
#define GALA_IS_BARRIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BARRIER))
#define GALA_IS_BARRIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BARRIER))
#define GALA_BARRIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BARRIER, GalaBarrierClass))

typedef struct _GalaBarrier GalaBarrier;
typedef struct _GalaBarrierClass GalaBarrierClass;
typedef struct _GalaBarrierPrivate GalaBarrierPrivate;
enum  {
	GALA_BARRIER_0_PROPERTY,
	GALA_BARRIER_IS_HIT_PROPERTY,
	GALA_BARRIER_PRESSURE_X_PROPERTY,
	GALA_BARRIER_PRESSURE_Y_PROPERTY,
	GALA_BARRIER_NUM_PROPERTIES
};
static GParamSpec* gala_barrier_properties[GALA_BARRIER_NUM_PROPERTIES];

#define GALA_TYPE_HOT_CORNER (gala_hot_corner_get_type ())
#define GALA_HOT_CORNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_HOT_CORNER, GalaHotCorner))
#define GALA_HOT_CORNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_HOT_CORNER, GalaHotCornerClass))
#define GALA_IS_HOT_CORNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_HOT_CORNER))
#define GALA_IS_HOT_CORNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_HOT_CORNER))
#define GALA_HOT_CORNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_HOT_CORNER, GalaHotCornerClass))

typedef struct _GalaHotCorner GalaHotCorner;
typedef struct _GalaHotCornerClass GalaHotCornerClass;
typedef struct _GalaHotCornerPrivate GalaHotCornerPrivate;
enum  {
	GALA_HOT_CORNER_0_PROPERTY,
	GALA_HOT_CORNER_NUM_PROPERTIES
};
static GParamSpec* gala_hot_corner_properties[GALA_HOT_CORNER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GALA_HOT_CORNER_TRIGGER_SIGNAL,
	GALA_HOT_CORNER_NUM_SIGNALS
};
static guint gala_hot_corner_signals[GALA_HOT_CORNER_NUM_SIGNALS] = {0};

struct _GalaBarrier {
	MetaBarrier parent_instance;
	GalaBarrierPrivate * priv;
};

struct _GalaBarrierClass {
	MetaBarrierClass parent_class;
};

struct _GalaBarrierPrivate {
	gboolean _is_hit;
	gdouble _pressure_x;
	gdouble _pressure_y;
};

struct _GalaHotCorner {
	GObject parent_instance;
	GalaHotCornerPrivate * priv;
};

struct _GalaHotCornerClass {
	GObjectClass parent_class;
};

struct _GalaHotCornerPrivate {
	GalaBarrier* vertical_barrier;
	GalaBarrier* horizontal_barrier;
	gboolean triggered;
	guint32 triggered_time;
};

static gint GalaBarrier_private_offset;
static gpointer gala_barrier_parent_class = NULL;
static gint GalaHotCorner_private_offset;
static gpointer gala_hot_corner_parent_class = NULL;

 G_GNUC_INTERNAL GType gala_barrier_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBarrier, g_object_unref)
 G_GNUC_INTERNAL GalaBarrier* gala_barrier_new (MetaDisplay* display,
                               gint x1,
                               gint y1,
                               gint x2,
                               gint y2,
                               MetaBarrierDirection directions);
 G_GNUC_INTERNAL GalaBarrier* gala_barrier_construct (GType object_type,
                                     MetaDisplay* display,
                                     gint x1,
                                     gint y1,
                                     gint x2,
                                     gint y2,
                                     MetaBarrierDirection directions);
 G_GNUC_INTERNAL gboolean gala_barrier_get_is_hit (GalaBarrier* self);
 G_GNUC_INTERNAL void gala_barrier_set_is_hit (GalaBarrier* self,
                              gboolean value);
 G_GNUC_INTERNAL gdouble gala_barrier_get_pressure_x (GalaBarrier* self);
 G_GNUC_INTERNAL void gala_barrier_set_pressure_x (GalaBarrier* self,
                                  gdouble value);
 G_GNUC_INTERNAL gdouble gala_barrier_get_pressure_y (GalaBarrier* self);
 G_GNUC_INTERNAL void gala_barrier_set_pressure_y (GalaBarrier* self,
                                  gdouble value);
static void gala_barrier_finalize (GObject * obj);
static GType gala_barrier_get_type_once (void);
static void _vala_gala_barrier_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_gala_barrier_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
VALA_EXTERN GType gala_hot_corner_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaHotCorner, g_object_unref)
VALA_EXTERN GalaHotCorner* gala_hot_corner_new (MetaDisplay* display,
                                    gfloat x,
                                    gfloat y,
                                    const gchar* hot_corner_position);
VALA_EXTERN GalaHotCorner* gala_hot_corner_construct (GType object_type,
                                          MetaDisplay* display,
                                          gfloat x,
                                          gfloat y,
                                          const gchar* hot_corner_position);
static void gala_hot_corner_add_barriers (GalaHotCorner* self,
                                   MetaDisplay* display,
                                   gfloat x,
                                   gfloat y,
                                   const gchar* hot_corner_position);
VALA_EXTERN void gala_hot_corner_destroy_barriers (GalaHotCorner* self);
static void gala_hot_corner_get_barrier_rect (gfloat x,
                                       gfloat y,
                                       const gchar* hot_corner_position,
                                       ClutterOrientation orientation,
                                       MetaRectangle* result);
static MetaBarrierDirection gala_hot_corner_get_barrier_direction (const gchar* hot_corner_position,
                                                            ClutterOrientation orientation);
static void __lambda24_ (GalaHotCorner* self,
                  MetaBarrierEvent* event);
static void gala_hot_corner_on_barrier_hit (GalaHotCorner* self,
                                     GalaBarrier* barrier,
                                     MetaBarrierEvent* event);
static void ___lambda24__meta_barrier_hit (MetaBarrier* _sender,
                                    MetaBarrierEvent* event,
                                    gpointer self);
static void __lambda25_ (GalaHotCorner* self,
                  MetaBarrierEvent* event);
static void ___lambda25__meta_barrier_hit (MetaBarrier* _sender,
                                    MetaBarrierEvent* event,
                                    gpointer self);
static void __lambda26_ (GalaHotCorner* self,
                  MetaBarrierEvent* event);
static void gala_hot_corner_on_barrier_left (GalaHotCorner* self,
                                      GalaBarrier* barrier,
                                      MetaBarrierEvent* event);
static void ___lambda26__meta_barrier_left (MetaBarrier* _sender,
                                     MetaBarrierEvent* event,
                                     gpointer self);
static void __lambda27_ (GalaHotCorner* self,
                  MetaBarrierEvent* event);
static void ___lambda27__meta_barrier_left (MetaBarrier* _sender,
                                     MetaBarrierEvent* event,
                                     gpointer self);
VALA_EXTERN gint gala_internal_utils_get_ui_scaling_factor (void);
static void gala_hot_corner_trigger_hot_corner (GalaHotCorner* self);
static void gala_hot_corner_finalize (GObject * obj);
static GType gala_hot_corner_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_barrier_get_instance_private (GalaBarrier* self)
{
	return G_STRUCT_MEMBER_P (self, GalaBarrier_private_offset);
}

 G_GNUC_INTERNAL GalaBarrier*
gala_barrier_construct (GType object_type,
                        MetaDisplay* display,
                        gint x1,
                        gint y1,
                        gint x2,
                        gint y2,
                        MetaBarrierDirection directions)
{
	GalaBarrier * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GalaBarrier*) g_object_new (object_type, "display", display, "x1", x1, "y1", y1, "x2", x2, "y2", y2, "directions", directions, NULL);
	return self;
}

 G_GNUC_INTERNAL GalaBarrier*
gala_barrier_new (MetaDisplay* display,
                  gint x1,
                  gint y1,
                  gint x2,
                  gint y2,
                  MetaBarrierDirection directions)
{
	return gala_barrier_construct (GALA_TYPE_BARRIER, display, x1, y1, x2, y2, directions);
}

 G_GNUC_INTERNAL gboolean
gala_barrier_get_is_hit (GalaBarrier* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_hit;
	return result;
}

 G_GNUC_INTERNAL void
gala_barrier_set_is_hit (GalaBarrier* self,
                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_barrier_get_is_hit (self);
	if (old_value != value) {
		self->priv->_is_hit = value;
		g_object_notify_by_pspec ((GObject *) self, gala_barrier_properties[GALA_BARRIER_IS_HIT_PROPERTY]);
	}
}

 G_GNUC_INTERNAL gdouble
gala_barrier_get_pressure_x (GalaBarrier* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_pressure_x;
	return result;
}

 G_GNUC_INTERNAL void
gala_barrier_set_pressure_x (GalaBarrier* self,
                             gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_barrier_get_pressure_x (self);
	if (old_value != value) {
		self->priv->_pressure_x = value;
		g_object_notify_by_pspec ((GObject *) self, gala_barrier_properties[GALA_BARRIER_PRESSURE_X_PROPERTY]);
	}
}

 G_GNUC_INTERNAL gdouble
gala_barrier_get_pressure_y (GalaBarrier* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_pressure_y;
	return result;
}

 G_GNUC_INTERNAL void
gala_barrier_set_pressure_y (GalaBarrier* self,
                             gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_barrier_get_pressure_y (self);
	if (old_value != value) {
		self->priv->_pressure_y = value;
		g_object_notify_by_pspec ((GObject *) self, gala_barrier_properties[GALA_BARRIER_PRESSURE_Y_PROPERTY]);
	}
}

static void
gala_barrier_class_init (GalaBarrierClass * klass,
                         gpointer klass_data)
{
	gala_barrier_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaBarrier_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_barrier_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_barrier_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_barrier_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BARRIER_IS_HIT_PROPERTY, gala_barrier_properties[GALA_BARRIER_IS_HIT_PROPERTY] = g_param_spec_boolean ("is-hit", "is-hit", "is-hit", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BARRIER_PRESSURE_X_PROPERTY, gala_barrier_properties[GALA_BARRIER_PRESSURE_X_PROPERTY] = g_param_spec_double ("pressure-x", "pressure-x", "pressure-x", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BARRIER_PRESSURE_Y_PROPERTY, gala_barrier_properties[GALA_BARRIER_PRESSURE_Y_PROPERTY] = g_param_spec_double ("pressure-y", "pressure-y", "pressure-y", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gala_barrier_instance_init (GalaBarrier * self,
                            gpointer klass)
{
	self->priv = gala_barrier_get_instance_private (self);
	self->priv->_is_hit = FALSE;
	self->priv->_pressure_x = (gdouble) 0;
	self->priv->_pressure_y = (gdouble) 0;
}

static void
gala_barrier_finalize (GObject * obj)
{
	GalaBarrier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BARRIER, GalaBarrier);
	G_OBJECT_CLASS (gala_barrier_parent_class)->finalize (obj);
}

static GType
gala_barrier_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaBarrierClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_barrier_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaBarrier), 0, (GInstanceInitFunc) gala_barrier_instance_init, NULL };
	GType gala_barrier_type_id;
	gala_barrier_type_id = g_type_register_static (meta_barrier_get_type (), "GalaBarrier", &g_define_type_info, 0);
	GalaBarrier_private_offset = g_type_add_instance_private (gala_barrier_type_id, sizeof (GalaBarrierPrivate));
	return gala_barrier_type_id;
}

 G_GNUC_INTERNAL GType
gala_barrier_get_type (void)
{
	static volatile gsize gala_barrier_type_id__once = 0;
	if (g_once_init_enter (&gala_barrier_type_id__once)) {
		GType gala_barrier_type_id;
		gala_barrier_type_id = gala_barrier_get_type_once ();
		g_once_init_leave (&gala_barrier_type_id__once, gala_barrier_type_id);
	}
	return gala_barrier_type_id__once;
}

static void
_vala_gala_barrier_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	GalaBarrier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_BARRIER, GalaBarrier);
	switch (property_id) {
		case GALA_BARRIER_IS_HIT_PROPERTY:
		g_value_set_boolean (value, gala_barrier_get_is_hit (self));
		break;
		case GALA_BARRIER_PRESSURE_X_PROPERTY:
		g_value_set_double (value, gala_barrier_get_pressure_x (self));
		break;
		case GALA_BARRIER_PRESSURE_Y_PROPERTY:
		g_value_set_double (value, gala_barrier_get_pressure_y (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_barrier_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	GalaBarrier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_BARRIER, GalaBarrier);
	switch (property_id) {
		case GALA_BARRIER_IS_HIT_PROPERTY:
		gala_barrier_set_is_hit (self, g_value_get_boolean (value));
		break;
		case GALA_BARRIER_PRESSURE_X_PROPERTY:
		gala_barrier_set_pressure_x (self, g_value_get_double (value));
		break;
		case GALA_BARRIER_PRESSURE_Y_PROPERTY:
		gala_barrier_set_pressure_y (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
gala_hot_corner_get_instance_private (GalaHotCorner* self)
{
	return G_STRUCT_MEMBER_P (self, GalaHotCorner_private_offset);
}

GalaHotCorner*
gala_hot_corner_construct (GType object_type,
                           MetaDisplay* display,
                           gfloat x,
                           gfloat y,
                           const gchar* hot_corner_position)
{
	GalaHotCorner * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	g_return_val_if_fail (hot_corner_position != NULL, NULL);
	self = (GalaHotCorner*) g_object_new (object_type, NULL);
	gala_hot_corner_add_barriers (self, display, x, y, hot_corner_position);
	return self;
}

GalaHotCorner*
gala_hot_corner_new (MetaDisplay* display,
                     gfloat x,
                     gfloat y,
                     const gchar* hot_corner_position)
{
	return gala_hot_corner_construct (GALA_TYPE_HOT_CORNER, display, x, y, hot_corner_position);
}

void
gala_hot_corner_destroy_barriers (GalaHotCorner* self)
{
	GalaBarrier* _tmp0_;
	GalaBarrier* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->vertical_barrier;
	if (_tmp0_ != NULL) {
		GalaBarrier* _tmp1_;
		_tmp1_ = self->priv->vertical_barrier;
		meta_barrier_destroy ((MetaBarrier*) _tmp1_);
	}
	_tmp2_ = self->priv->horizontal_barrier;
	if (_tmp2_ != NULL) {
		GalaBarrier* _tmp3_;
		_tmp3_ = self->priv->horizontal_barrier;
		meta_barrier_destroy ((MetaBarrier*) _tmp3_);
	}
}

static void
__lambda24_ (GalaHotCorner* self,
             MetaBarrierEvent* event)
{
	GalaBarrier* _tmp0_;
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->vertical_barrier;
	gala_hot_corner_on_barrier_hit (self, _tmp0_, event);
}

static void
___lambda24__meta_barrier_hit (MetaBarrier* _sender,
                               MetaBarrierEvent* event,
                               gpointer self)
{
	__lambda24_ ((GalaHotCorner*) self, event);
}

static void
__lambda25_ (GalaHotCorner* self,
             MetaBarrierEvent* event)
{
	GalaBarrier* _tmp0_;
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->horizontal_barrier;
	gala_hot_corner_on_barrier_hit (self, _tmp0_, event);
}

static void
___lambda25__meta_barrier_hit (MetaBarrier* _sender,
                               MetaBarrierEvent* event,
                               gpointer self)
{
	__lambda25_ ((GalaHotCorner*) self, event);
}

static void
__lambda26_ (GalaHotCorner* self,
             MetaBarrierEvent* event)
{
	GalaBarrier* _tmp0_;
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->vertical_barrier;
	gala_hot_corner_on_barrier_left (self, _tmp0_, event);
}

static void
___lambda26__meta_barrier_left (MetaBarrier* _sender,
                                MetaBarrierEvent* event,
                                gpointer self)
{
	__lambda26_ ((GalaHotCorner*) self, event);
}

static void
__lambda27_ (GalaHotCorner* self,
             MetaBarrierEvent* event)
{
	GalaBarrier* _tmp0_;
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->horizontal_barrier;
	gala_hot_corner_on_barrier_left (self, _tmp0_, event);
}

static void
___lambda27__meta_barrier_left (MetaBarrier* _sender,
                                MetaBarrierEvent* event,
                                gpointer self)
{
	__lambda27_ ((GalaHotCorner*) self, event);
}

static void
gala_hot_corner_add_barriers (GalaHotCorner* self,
                              MetaDisplay* display,
                              gfloat x,
                              gfloat y,
                              const gchar* hot_corner_position)
{
	MetaRectangle vrect = {0};
	MetaRectangle _tmp0_ = {0};
	MetaRectangle hrect = {0};
	MetaRectangle _tmp1_ = {0};
	MetaBarrierDirection vdir = 0U;
	MetaBarrierDirection hdir = 0U;
	MetaRectangle _tmp2_;
	MetaRectangle _tmp3_;
	MetaRectangle _tmp4_;
	MetaRectangle _tmp5_;
	MetaRectangle _tmp6_;
	MetaRectangle _tmp7_;
	GalaBarrier* _tmp8_;
	MetaRectangle _tmp9_;
	MetaRectangle _tmp10_;
	MetaRectangle _tmp11_;
	MetaRectangle _tmp12_;
	MetaRectangle _tmp13_;
	MetaRectangle _tmp14_;
	GalaBarrier* _tmp15_;
	GalaBarrier* _tmp16_;
	GalaBarrier* _tmp17_;
	GalaBarrier* _tmp18_;
	GalaBarrier* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (hot_corner_position != NULL);
	gala_hot_corner_get_barrier_rect (x, y, hot_corner_position, CLUTTER_ORIENTATION_VERTICAL, &_tmp0_);
	vrect = _tmp0_;
	gala_hot_corner_get_barrier_rect (x, y, hot_corner_position, CLUTTER_ORIENTATION_HORIZONTAL, &_tmp1_);
	hrect = _tmp1_;
	vdir = gala_hot_corner_get_barrier_direction (hot_corner_position, CLUTTER_ORIENTATION_VERTICAL);
	hdir = gala_hot_corner_get_barrier_direction (hot_corner_position, CLUTTER_ORIENTATION_HORIZONTAL);
	_tmp2_ = vrect;
	_tmp3_ = vrect;
	_tmp4_ = vrect;
	_tmp5_ = vrect;
	_tmp6_ = vrect;
	_tmp7_ = vrect;
	_tmp8_ = gala_barrier_new (display, _tmp2_.x, _tmp3_.y, _tmp4_.x + _tmp5_.width, _tmp6_.y + _tmp7_.height, vdir);
	_g_object_unref0 (self->priv->vertical_barrier);
	self->priv->vertical_barrier = _tmp8_;
	_tmp9_ = hrect;
	_tmp10_ = hrect;
	_tmp11_ = hrect;
	_tmp12_ = hrect;
	_tmp13_ = hrect;
	_tmp14_ = hrect;
	_tmp15_ = gala_barrier_new (display, _tmp9_.x, _tmp10_.y, _tmp11_.x + _tmp12_.width, _tmp13_.y + _tmp14_.height, hdir);
	_g_object_unref0 (self->priv->horizontal_barrier);
	self->priv->horizontal_barrier = _tmp15_;
	_tmp16_ = self->priv->vertical_barrier;
	g_signal_connect_object ((MetaBarrier*) _tmp16_, "hit", (GCallback) ___lambda24__meta_barrier_hit, self, 0);
	_tmp17_ = self->priv->horizontal_barrier;
	g_signal_connect_object ((MetaBarrier*) _tmp17_, "hit", (GCallback) ___lambda25__meta_barrier_hit, self, 0);
	_tmp18_ = self->priv->vertical_barrier;
	g_signal_connect_object ((MetaBarrier*) _tmp18_, "left", (GCallback) ___lambda26__meta_barrier_left, self, 0);
	_tmp19_ = self->priv->horizontal_barrier;
	g_signal_connect_object ((MetaBarrier*) _tmp19_, "left", (GCallback) ___lambda27__meta_barrier_left, self, 0);
}

static MetaBarrierDirection
gala_hot_corner_get_barrier_direction (const gchar* hot_corner_position,
                                       ClutterOrientation orientation)
{
	gboolean vert = FALSE;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	MetaBarrierDirection result;
	g_return_val_if_fail (hot_corner_position != NULL, 0U);
	vert = orientation == CLUTTER_ORIENTATION_VERTICAL;
	_tmp0_ = hot_corner_position;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (GALA_HOT_CORNER_POSITION_TOP_LEFT)))) {
		switch (0) {
			default:
			{
				MetaBarrierDirection _tmp3_ = 0U;
				if (vert) {
					_tmp3_ = META_BARRIER_DIRECTION_POSITIVE_X;
				} else {
					_tmp3_ = META_BARRIER_DIRECTION_POSITIVE_Y;
				}
				result = _tmp3_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (GALA_HOT_CORNER_POSITION_TOP_RIGHT)))) {
		switch (0) {
			default:
			{
				MetaBarrierDirection _tmp4_ = 0U;
				if (vert) {
					_tmp4_ = META_BARRIER_DIRECTION_NEGATIVE_X;
				} else {
					_tmp4_ = META_BARRIER_DIRECTION_POSITIVE_Y;
				}
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (GALA_HOT_CORNER_POSITION_BOTTOM_LEFT)))) {
		switch (0) {
			default:
			{
				MetaBarrierDirection _tmp5_ = 0U;
				if (vert) {
					_tmp5_ = META_BARRIER_DIRECTION_POSITIVE_X;
				} else {
					_tmp5_ = META_BARRIER_DIRECTION_NEGATIVE_Y;
				}
				result = _tmp5_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				MetaBarrierDirection _tmp6_ = 0U;
				if (vert) {
					_tmp6_ = META_BARRIER_DIRECTION_NEGATIVE_X;
				} else {
					_tmp6_ = META_BARRIER_DIRECTION_NEGATIVE_Y;
				}
				result = _tmp6_;
				return result;
			}
		}
	}
}

static void
gala_hot_corner_get_barrier_rect (gfloat x,
                                  gfloat y,
                                  const gchar* hot_corner_position,
                                  ClutterOrientation orientation,
                                  MetaRectangle* result)
{
	gint scale = 0;
	gint barrier_size = 0;
	gint x1 = 0;
	gint y1 = 0;
	gint x2 = 0;
	gint y2 = 0;
	gboolean vert = FALSE;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	MetaRectangle _tmp11_ = {0};
	g_return_if_fail (hot_corner_position != NULL);
	scale = gala_internal_utils_get_ui_scaling_factor ();
	barrier_size = GALA_HOT_CORNER_BARRIER_SIZE * scale;
	x1 = (gint) x;
	y1 = (gint) y;
	vert = orientation == CLUTTER_ORIENTATION_VERTICAL;
	_tmp0_ = hot_corner_position;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (GALA_HOT_CORNER_POSITION_TOP_LEFT)))) {
		switch (0) {
			default:
			{
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				if (vert) {
					_tmp3_ = x1;
				} else {
					_tmp3_ = x1 + barrier_size;
				}
				x2 = _tmp3_;
				if (vert) {
					_tmp4_ = y1 + barrier_size;
				} else {
					_tmp4_ = y1;
				}
				y2 = _tmp4_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (GALA_HOT_CORNER_POSITION_TOP_RIGHT)))) {
		switch (0) {
			default:
			{
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				if (vert) {
					_tmp5_ = x1;
				} else {
					_tmp5_ = x1 - barrier_size;
				}
				x2 = _tmp5_;
				if (vert) {
					_tmp6_ = y1 + barrier_size;
				} else {
					_tmp6_ = y1;
				}
				y2 = _tmp6_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (GALA_HOT_CORNER_POSITION_BOTTOM_LEFT)))) {
		switch (0) {
			default:
			{
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				if (vert) {
					_tmp7_ = x1;
				} else {
					_tmp7_ = x1 + barrier_size;
				}
				x2 = _tmp7_;
				if (vert) {
					_tmp8_ = y1 - barrier_size;
				} else {
					_tmp8_ = y1;
				}
				y2 = _tmp8_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				if (vert) {
					_tmp9_ = x1;
				} else {
					_tmp9_ = x1 - barrier_size;
				}
				x2 = _tmp9_;
				if (vert) {
					_tmp10_ = y1 - barrier_size;
				} else {
					_tmp10_ = y1;
				}
				y2 = _tmp10_;
				break;
			}
		}
	}
	_tmp11_.x = x1;
	_tmp11_.y = y1;
	_tmp11_.width = x2 - x1;
	_tmp11_.height = y2 - y1;
	*result = _tmp11_;
	return;
}

static void
gala_hot_corner_on_barrier_hit (GalaHotCorner* self,
                                GalaBarrier* barrier,
                                MetaBarrierEvent* event)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_ = 0.0;
	GalaBarrier* _tmp5_;
	gdouble pressure = 0.0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (barrier != NULL);
	g_return_if_fail (event != NULL);
	gala_barrier_set_is_hit (barrier, TRUE);
	_tmp0_ = gala_barrier_get_pressure_x (barrier);
	_tmp1_ = _tmp0_;
	gala_barrier_set_pressure_x (barrier, _tmp1_ + event->dx);
	_tmp2_ = gala_barrier_get_pressure_y (barrier);
	_tmp3_ = _tmp2_;
	gala_barrier_set_pressure_y (barrier, _tmp3_ + event->dy);
	_tmp5_ = self->priv->vertical_barrier;
	if (barrier == _tmp5_) {
		gdouble _tmp6_;
		gdouble _tmp7_;
		_tmp6_ = gala_barrier_get_pressure_x (barrier);
		_tmp7_ = _tmp6_;
		_tmp4_ = fabs (_tmp7_);
	} else {
		gdouble _tmp8_;
		gdouble _tmp9_;
		_tmp8_ = gala_barrier_get_pressure_y (barrier);
		_tmp9_ = _tmp8_;
		_tmp4_ = fabs (_tmp9_);
	}
	pressure = _tmp4_;
	if (!self->priv->triggered) {
		GalaBarrier* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp12_ = self->priv->vertical_barrier;
		_tmp13_ = gala_barrier_get_is_hit (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp11_ = _tmp14_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GalaBarrier* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp15_ = self->priv->horizontal_barrier;
		_tmp16_ = gala_barrier_get_is_hit (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp10_ = _tmp17_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		if (fabs (pressure) > ((gdouble) GALA_HOT_CORNER_TRIGGER_PRESSURE_THRESHOLD)) {
			gala_hot_corner_trigger_hot_corner (self);
			pressure = (gdouble) 0;
			self->priv->triggered_time = event->time;
		}
	}
	if (!self->priv->triggered) {
		_tmp18_ = fabs (pressure) > ((gdouble) GALA_HOT_CORNER_RELEASE_PRESSURE_THRESHOLD);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		meta_barrier_release ((MetaBarrier*) barrier, event);
	}
	if (self->priv->triggered) {
		_tmp20_ = fabs (pressure) > ((gdouble) GALA_HOT_CORNER_RETRIGGER_PRESSURE_THRESHOLD);
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		_tmp19_ = event->time > (GALA_HOT_CORNER_RETRIGGER_DELAY + self->priv->triggered_time);
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gala_hot_corner_trigger_hot_corner (self);
	}
}

static void
gala_hot_corner_on_barrier_left (GalaHotCorner* self,
                                 GalaBarrier* barrier,
                                 MetaBarrierEvent* event)
{
	gboolean _tmp0_ = FALSE;
	GalaBarrier* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (barrier != NULL);
	g_return_if_fail (event != NULL);
	gala_barrier_set_is_hit (barrier, FALSE);
	gala_barrier_set_pressure_x (barrier, (gdouble) 0);
	gala_barrier_set_pressure_y (barrier, (gdouble) 0);
	_tmp1_ = self->priv->vertical_barrier;
	_tmp2_ = gala_barrier_get_is_hit (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		GalaBarrier* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->horizontal_barrier;
		_tmp5_ = gala_barrier_get_is_hit (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = !_tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->triggered = FALSE;
	}
}

static void
gala_hot_corner_trigger_hot_corner (GalaHotCorner* self)
{
	GalaBarrier* _tmp0_;
	GalaBarrier* _tmp1_;
	GalaBarrier* _tmp2_;
	GalaBarrier* _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->triggered = TRUE;
	_tmp0_ = self->priv->vertical_barrier;
	gala_barrier_set_pressure_x (_tmp0_, (gdouble) 0);
	_tmp1_ = self->priv->vertical_barrier;
	gala_barrier_set_pressure_y (_tmp1_, (gdouble) 0);
	_tmp2_ = self->priv->horizontal_barrier;
	gala_barrier_set_pressure_x (_tmp2_, (gdouble) 0);
	_tmp3_ = self->priv->horizontal_barrier;
	gala_barrier_set_pressure_y (_tmp3_, (gdouble) 0);
	g_signal_emit (self, gala_hot_corner_signals[GALA_HOT_CORNER_TRIGGER_SIGNAL], 0);
}

static void
gala_hot_corner_class_init (GalaHotCornerClass * klass,
                            gpointer klass_data)
{
	gala_hot_corner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaHotCorner_private_offset);
	G_OBJECT_CLASS (klass)->finalize = gala_hot_corner_finalize;
	gala_hot_corner_signals[GALA_HOT_CORNER_TRIGGER_SIGNAL] = g_signal_new ("trigger", GALA_TYPE_HOT_CORNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_hot_corner_instance_init (GalaHotCorner * self,
                               gpointer klass)
{
	self->priv = gala_hot_corner_get_instance_private (self);
	self->priv->vertical_barrier = NULL;
	self->priv->horizontal_barrier = NULL;
	self->priv->triggered = FALSE;
}

static void
gala_hot_corner_finalize (GObject * obj)
{
	GalaHotCorner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_HOT_CORNER, GalaHotCorner);
	_g_object_unref0 (self->priv->vertical_barrier);
	_g_object_unref0 (self->priv->horizontal_barrier);
	G_OBJECT_CLASS (gala_hot_corner_parent_class)->finalize (obj);
}

static GType
gala_hot_corner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaHotCornerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_hot_corner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaHotCorner), 0, (GInstanceInitFunc) gala_hot_corner_instance_init, NULL };
	GType gala_hot_corner_type_id;
	gala_hot_corner_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaHotCorner", &g_define_type_info, 0);
	GalaHotCorner_private_offset = g_type_add_instance_private (gala_hot_corner_type_id, sizeof (GalaHotCornerPrivate));
	return gala_hot_corner_type_id;
}

GType
gala_hot_corner_get_type (void)
{
	static volatile gsize gala_hot_corner_type_id__once = 0;
	if (g_once_init_enter (&gala_hot_corner_type_id__once)) {
		GType gala_hot_corner_type_id;
		gala_hot_corner_type_id = gala_hot_corner_get_type_once ();
		g_once_init_leave (&gala_hot_corner_type_id__once, gala_hot_corner_type_id);
	}
	return gala_hot_corner_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

