/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.api.BytePoster;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.tree.TreeNode;
import jspecview.api.ExportInterface;
import jspecview.api.JSVFileHelper;
import jspecview.api.JSVMainPanel;
import jspecview.api.JSVPanel;
import jspecview.api.JSVPrintDialog;
import jspecview.api.JSVTree;
import jspecview.api.JSVTreeNode;
import jspecview.api.ScriptInterface;
import jspecview.api.VisibleInterface;
import jspecview.api.js.JSVAppletObject;
import jspecview.api.js.JSVToJSmolInterface;
import jspecview.common.Annotation;
import jspecview.common.ColorParameters;
import jspecview.common.Coordinate;
import jspecview.common.ExportType;
import jspecview.common.JSVFileManager;
import jspecview.common.PanelData;
import jspecview.common.PanelNode;
import jspecview.common.Parameters;
import jspecview.common.PeakInfo;
import jspecview.common.PeakPickEvent;
import jspecview.common.PrintLayout;
import jspecview.common.RepaintManager;
import jspecview.common.ScaleData;
import jspecview.common.ScriptToken;
import jspecview.common.ScriptTokenizer;
import jspecview.common.Spectrum;
import jspecview.dialog.DialogManager;
import jspecview.dialog.JSVDialog;
import jspecview.exception.JSVException;
import jspecview.popup.JSVGenericPopup;
import jspecview.source.JDXReader;
import jspecview.source.JDXSource;
import jspecview.tree.SimpleTree;
import org.jmol.api.GenericFileInterface;
import org.jmol.api.GenericGraphics;
import org.jmol.api.GenericPlatform;
import org.jmol.api.PlatformViewer;
import org.jmol.util.Logger;

public class JSViewer
implements PlatformViewer,
BytePoster {
    public static final String sourceLabel = "Original...";
    public static final int FILE_OPEN_OK = 0;
    public static final int FILE_OPEN_ALREADY = -1;
    public static final int FILE_OPEN_ERROR = -3;
    public static final int FILE_OPEN_NO_DATA = -4;
    public static final int OVERLAY_DIALOG = -1;
    public static final int OVERLAY_OFFSET = 99;
    public static final int PORTRAIT = 1;
    public static final int PAGE_EXISTS = 0;
    public static final int NO_SUCH_PAGE = 1;
    private static String testScript = "<PeakData  index=\"1\" title=\"\" model=\"~1.1\" type=\"1HNMR\" xMin=\"3.2915\" xMax=\"3.2965\" atoms=\"15,16,17,18,19,20\" multiplicity=\"\" integral=\"1\"> src=\"JPECVIEW\" file=\"http://SIMULATION/$caffeine\"";
    private static final int NLEVEL_MAX = 100;
    public ScriptInterface si;
    public GenericGraphics g2d;
    public JSVTree spectraTree;
    public JDXSource currentSource;
    public Lst<PanelNode> panelNodes;
    public ColorParameters parameters;
    public RepaintManager repaintManager;
    public JSVPanel selectedPanel;
    public JSVMainPanel mainPanel;
    public Properties properties;
    public Lst<String> scriptQueue;
    public JSVFileHelper fileHelper;
    public JSVGenericPopup jsvpPopupMenu;
    private DialogManager dialogManager;
    private JSVDialog viewDialog;
    private JSVDialog overlayLegendDialog;
    private Spectrum.IRMode irMode = Spectrum.IRMode.NO_CONVERT;
    public boolean loadImaginary;
    public boolean interfaceOverlaid;
    public boolean autoIntegrate;
    public boolean autoShowLegend;
    public Boolean obscureTitleFromUser;
    public boolean allowMenu = true;
    public int initialStartIndex = -1;
    public int initialEndIndex = -1;
    public boolean isSingleThreaded;
    public boolean isApplet;
    public static boolean isJS;
    public static boolean isSwingJS;
    public boolean isSigned;
    private String recentScript = "";
    public String appletName;
    public String fullName;
    public String syncID;
    public JSVAppletObject html5Applet;
    public Object display;
    private int maximumSize = Integer.MAX_VALUE;
    private int screenHeight;
    private int screenWidth;
    private int fileCount;
    private int nViews;
    private int scriptLevelCount;
    private String returnFromJmolModel;
    private String integrationRatios;
    public GenericPlatform apiPlatform;
    public static JSVToJSmolInterface jmolObject;
    private boolean popupAllowMenu = true;
    private boolean popupZoomEnabled = true;
    private String defaultLoadScript;
    public float nmrMaxY = Float.NaN;
    private boolean overlayLegendVisible;
    private int recentStackPercent = 5;
    private PrintLayout lastPrintLayout;
    private Object offWindowFrame;
    private String recentOpenURL = "http://";
    private String recentURL;
    private String recentSimulation = "tylenol";

    static {
        isSwingJS = false;
    }

    public void setProperty(String string, String string2) {
        if (this.properties != null) {
            this.properties.setProperty(string, string2);
        }
    }

    public void setNode(PanelNode panelNode) {
        if (panelNode.jsvp != this.selectedPanel) {
            this.si.siSetSelectedPanel(panelNode.jsvp);
        }
        this.si.siSendPanelChange();
        this.si.siNodeSet(panelNode);
    }

    public JSViewer(ScriptInterface scriptInterface, boolean bl, boolean bl2) {
        this.si = scriptInterface;
        this.isApplet = bl;
        isJS = bl && bl2;
        Object var4_4 = null;
        jmolObject = var4_4;
        this.isSigned = scriptInterface.isSigned();
        this.apiPlatform = (GenericPlatform)this.getPlatformInterface("Platform");
        this.apiPlatform.setViewer(this, this.display);
        this.g2d = (GenericGraphics)this.getPlatformInterface("G2D");
        this.spectraTree = new SimpleTree(this);
        this.parameters = (ColorParameters)this.getPlatformInterface("Parameters");
        this.parameters.setName("applet");
        this.fileHelper = ((JSVFileHelper)this.getPlatformInterface("FileHelper")).set(this);
        this.isSingleThreaded = this.apiPlatform.isSingleThreaded();
        this.panelNodes = new Lst();
        this.repaintManager = new RepaintManager(this);
        if (!bl) {
            this.setPopupMenu(true, true);
        }
    }

    public void setPopupMenu(boolean bl, boolean bl2) {
        this.popupAllowMenu = bl;
        this.popupZoomEnabled = bl2;
    }

    public void showMenu(int n, int n2) {
        if (!this.popupAllowMenu) {
            return;
        }
        if (this.jsvpPopupMenu == null) {
            try {
                this.jsvpPopupMenu = (JSVGenericPopup)this.getPlatformInterface("Popup");
                this.jsvpPopupMenu.jpiInitialize(this, this.isApplet ? "appletMenu" : "appMenu");
                this.jsvpPopupMenu.setEnabled(this.popupAllowMenu, this.popupZoomEnabled);
            }
            catch (Exception exception) {
                Logger.error(exception + " initializing popup menu");
                return;
            }
        }
        this.jsvpPopupMenu.jpiShow(n, n2);
    }

    public boolean runScriptNow(String string) {
        System.out.println(this.checkScript(string));
        ++this.scriptLevelCount;
        if (string == null) {
            string = "";
        }
        if ((string = string.trim()).startsWith("!")) {
            string = string.substring(1).trim();
        } else if (string.startsWith(">")) {
            Logger.error(string);
            return true;
        }
        if (string.indexOf("<PeakData") >= 0) {
            this.syncScript(string);
            return true;
        }
        Logger.info("RUNSCRIPT " + string);
        boolean bl = true;
        int n = 10;
        ScriptTokenizer scriptTokenizer = new ScriptTokenizer(string, true);
        String string2 = null;
        block56: while (scriptTokenizer != null && scriptTokenizer.hasMoreTokens() && n > 0 && bl) {
            String string3 = scriptTokenizer.nextToken();
            ScriptTokenizer scriptTokenizer2 = new ScriptTokenizer(string3, false);
            String string4 = ScriptToken.getKey(scriptTokenizer2);
            if (string4 == null) continue;
            ScriptToken scriptToken = ScriptToken.getScriptToken(string4);
            String string5 = ScriptToken.getValue(scriptToken, scriptTokenizer2, string3);
            try {
                block1 : switch (scriptToken) {
                    case UNKNOWN: {
                        Logger.info("Unrecognized parameter: " + string4);
                        --n;
                        break;
                    }
                    default: {
                        if (this.selectedPanel == null) continue block56;
                        this.parameters.set(this.pd(), scriptToken, string5);
                        this.si.siUpdateBoolean(scriptToken, Parameters.isTrue(string5));
                        break;
                    }
                    case COORDCALLBACKFUNCTIONNAME: 
                    case LOADFILECALLBACKFUNCTIONNAME: 
                    case PEAKCALLBACKFUNCTIONNAME: 
                    case SYNCCALLBACKFUNCTIONNAME: {
                        this.si.siExecSetCallback(scriptToken, string5);
                        break;
                    }
                    case DEFAULTLOADSCRIPT: {
                        string5 = PT.rep(string5, "''", "\"");
                        this.defaultLoadScript = string5.length() > 0 ? string5 : null;
                        break;
                    }
                    case DEFAULTNMRNORMALIZATION: {
                        this.nmrMaxY = PT.parseFloat(string5);
                        break;
                    }
                    case AUTOINTEGRATE: {
                        this.autoIntegrate = Parameters.isTrue(string5);
                        break;
                    }
                    case CLOSE: {
                        this.execClose(string5);
                        break;
                    }
                    case DEBUG: {
                        Logger.setLogLevel(string5.toLowerCase().equals("high") ? 6 : (Parameters.isTrue(string5) ? 5 : 4));
                        break;
                    }
                    case GETPROPERTY: {
                        Map<String, Object> map;
                        Map<String, Object> map2 = map = this.selectedPanel == null ? null : this.getPropertyAsJavaObject(string5);
                        if (map == null) continue block56;
                        this.selectedPanel.showMessage(PT.toJSON(null, map), string5);
                        break;
                    }
                    case HELP: {
                        this.execHelp(string5);
                        break;
                    }
                    case HIDDEN: {
                        this.si.siExecHidden(Parameters.isTrue(string5));
                        break;
                    }
                    case INTEGRATIONRATIOS: {
                        this.integrationRatios = string5;
                        this.execIntegrate(null);
                        break;
                    }
                    case INTERFACE: {
                        this.interfaceOverlaid = this.checkOvelayInterface(string5);
                        break;
                    }
                    case INTEGRALOFFSET: 
                    case INTEGRALRANGE: {
                        this.execSetIntegralParameter(scriptToken, Double.parseDouble(string5));
                        break;
                    }
                    case INVERTY: {
                        this.execZoom("invertY");
                        break;
                    }
                    case JMOL: {
                        this.si.syncToJmol(string5);
                        break;
                    }
                    case JSV: {
                        this.syncScript(PT.trimQuotes(string5));
                        break;
                    }
                    case LOAD: {
                        if (string5.length() == 0) {
                            if (this.defaultLoadScript == null) continue block56;
                            this.runScriptNow(this.defaultLoadScript);
                            break;
                        }
                        this.execLoad(string5, String.valueOf(this.defaultLoadScript == null ? "" : String.valueOf(this.defaultLoadScript) + ";") + scriptTokenizer.getRemainingScript());
                        string2 = this.selectedPanel == null ? null : this.si.siLoaded(string5);
                        scriptTokenizer = null;
                        break;
                    }
                    case LOADIMAGINARY: {
                        this.loadImaginary = Parameters.isTrue(string5);
                        break;
                    }
                    case PEAK: {
                        this.execPeak(string5);
                        break;
                    }
                    case PEAKLIST: {
                        this.execPeakList(string5);
                        break;
                    }
                    case SCALEBY: {
                        this.scaleSelectedBy(this.panelNodes, string5);
                        break;
                    }
                    case SCRIPT: {
                        if (string5.equals("") || string5.toLowerCase().startsWith("inline")) {
                            this.execScriptInline(string5);
                            break;
                        }
                        String string6 = JSVFileManager.getFileAsString(string5);
                        if (string6 == null || this.scriptLevelCount >= 100) continue block56;
                        this.runScriptNow(string6);
                        break;
                    }
                    case SELECT: {
                        this.execSelect(string5);
                        break;
                    }
                    case SPECTRUM: 
                    case SPECTRUMNUMBER: {
                        if (this.setSpectrum(string5)) continue block56;
                        bl = false;
                        break;
                    }
                    case STACKOFFSETY: {
                        this.execOverlayOffsetY(PT.parseInt("" + PT.parseFloat(string5)));
                        break;
                    }
                    case TEST: {
                        this.si.siExecTest(string5);
                        break;
                    }
                    case OVERLAY: 
                    case VIEW: {
                        this.execView(string5, true);
                        break;
                    }
                    case HIGHLIGHT: {
                        bl = this.highlight(string3);
                        break;
                    }
                    case FINDX: 
                    case GETSOLUTIONCOLOR: 
                    case INTEGRATE: 
                    case INTEGRATION: 
                    case IRMODE: 
                    case LABEL: 
                    case LINK: 
                    case OVERLAYSTACKED: 
                    case PRINT: 
                    case SETPEAK: 
                    case SETX: 
                    case SHIFTX: 
                    case SHOWERRORS: 
                    case SHOWINTEGRATION: 
                    case SHOWKEY: 
                    case SHOWMEASUREMENTS: 
                    case SHOWMENU: 
                    case SHOWPEAKLIST: 
                    case SHOWPROPERTIES: 
                    case SHOWSOURCE: 
                    case YSCALE: 
                    case WRITE: 
                    case ZOOM: {
                        if (this.isClosed()) {
                            bl = false;
                            break;
                        }
                        switch (scriptToken) {
                            default: {
                                break block1;
                            }
                            case FINDX: {
                                this.pd().findX(null, Double.parseDouble(string5));
                                break block1;
                            }
                            case GETSOLUTIONCOLOR: {
                                this.show("solutioncolor" + string5.toLowerCase());
                                break block1;
                            }
                            case INTEGRATE: 
                            case INTEGRATION: {
                                this.execIntegrate(string5);
                                break block1;
                            }
                            case IRMODE: {
                                this.execIRMode(string5);
                                break block1;
                            }
                            case LABEL: {
                                this.pd().addAnnotation(ScriptToken.getTokens(string5));
                                break block1;
                            }
                            case LINK: {
                                this.pd().linkSpectra(PanelData.LinkMode.getMode(string5));
                                break block1;
                            }
                            case OVERLAYSTACKED: {
                                this.pd().splitStack(!Parameters.isTrue(string5));
                                break block1;
                            }
                            case PRINT: {
                                string2 = this.execWrite(null);
                                break block1;
                            }
                            case SETPEAK: 
                            case SETX: 
                            case SHIFTX: {
                                this.execShiftSpectrum(scriptToken, string3);
                                break block1;
                            }
                            case SHOWERRORS: {
                                this.show("errors");
                                break block1;
                            }
                            case SHOWINTEGRATION: {
                                this.pd().showAnnotation(Annotation.AType.Integration, Parameters.getTFToggle(string5));
                                break block1;
                            }
                            case SHOWKEY: {
                                this.setOverlayLegendVisibility(Parameters.getTFToggle(string5), true);
                                break block1;
                            }
                            case SHOWMEASUREMENTS: {
                                this.pd().showAnnotation(Annotation.AType.Measurements, Parameters.getTFToggle(string5));
                                break block1;
                            }
                            case SHOWMENU: {
                                this.showMenu(Integer.MIN_VALUE, 0);
                                break block1;
                            }
                            case SHOWPEAKLIST: {
                                this.pd().showAnnotation(Annotation.AType.PeakList, Parameters.getTFToggle(string5));
                                break block1;
                            }
                            case SHOWPROPERTIES: {
                                this.show("properties");
                                break block1;
                            }
                            case SHOWSOURCE: {
                                this.show("source");
                                break block1;
                            }
                            case YSCALE: {
                                this.setYScale(string5);
                                break block1;
                            }
                            case WINDOW: {
                                this.si.siNewWindow(Parameters.isTrue(string5), false);
                                break block1;
                            }
                            case WRITE: {
                                string2 = this.execWrite(string5);
                                break block1;
                            }
                            case ZOOM: 
                        }
                        bl = this.execZoom(string5);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                string2 = exception.toString();
                Logger.error(exception.toString());
                bl = false;
                --n;
            }
        }
        --this.scriptLevelCount;
        this.si.siExecScriptComplete(string2, true);
        return bl;
    }

    private void execShiftSpectrum(ScriptToken scriptToken, String string) {
        Lst<String> lst = ScriptToken.getTokens(string);
        double d = Double.NaN;
        double d2 = Double.NaN;
        switch (lst.size()) {
            case 2: {
                String string2 = (String)lst.get(1);
                if (string2.equals("")) {
                    string2 = "?";
                }
                d2 = string2.equalsIgnoreCase("NONE") ? Double.MAX_VALUE : (string2.equalsIgnoreCase("?") ? Double.NaN : Double.parseDouble(string2));
                break;
            }
            case 3: {
                d = Double.parseDouble((String)lst.get(1));
                d2 = Double.parseDouble((String)lst.get(2));
                break;
            }
            default: {
                Double.parseDouble("");
            }
        }
        int n = 0;
        switch (scriptToken) {
            case SETPEAK: {
                n = 1;
                break;
            }
            case SETX: {
                n = 2;
                break;
            }
            case SHIFTX: {
                n = 3;
                if (!Double.isNaN(d2)) break;
                Double.parseDouble("");
                break;
            }
            default: {
                return;
            }
        }
        this.pd().shiftSpectrum(n, d, d2);
    }

    private void execClose(String string) {
        boolean bl;
        boolean bl2 = bl = !string.startsWith("!");
        if (!bl) {
            string = string.substring(1);
        }
        this.close(PT.trimQuotes(string));
        if (!bl || this.panelNodes.size() == 0) {
            this.si.siValidateAndRepaint(true);
        }
    }

    public boolean checkOvelayInterface(String string) {
        return string.equalsIgnoreCase("single") || string.equalsIgnoreCase("overlay");
    }

    private void execPeak(String string) {
        try {
            Lst<String> lst = ScriptToken.getTokens(PT.rep(string, "#", "INDEX="));
            string = " type=\"" + ((String)lst.get(0)).toUpperCase() + "\" _match=\"" + PT.trimQuotes(((String)lst.get(1)).toUpperCase()) + "\"";
            if (lst.size() > 2 && ((String)lst.get(2)).equalsIgnoreCase("all")) {
                string = String.valueOf(string) + " title=\"ALL\"";
            }
            this.processPeakPickEvent(new PeakInfo(string), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void execPeakList(String string) {
        ColorParameters colorParameters = this.parameters;
        Boolean bl = Parameters.getTFToggle(string);
        if (string.indexOf("=") < 0) {
            if (!this.isClosed()) {
                this.pd().getPeakListing(null, bl);
            }
        } else {
            Lst<String> lst = ScriptToken.getTokens(string);
            double d = colorParameters.peakListThreshold;
            String string2 = colorParameters.peakListInterpolation;
            try {
                int n = lst.size();
                while (--n >= 0) {
                    String string3 = (String)lst.get(n);
                    int n2 = string3.indexOf("=");
                    if (n2 <= 0) continue;
                    String string4 = string3.substring(0, n2);
                    string = string3.substring(n2 + 1);
                    if (string4.startsWith("thr")) {
                        d = Double.valueOf(string);
                        continue;
                    }
                    if (!string4.startsWith("int")) continue;
                    String string5 = string2 = string.equalsIgnoreCase("none") ? "NONE" : "parabolic";
                }
                colorParameters.peakListThreshold = d;
                colorParameters.peakListInterpolation = string2;
                if (!this.isClosed()) {
                    this.pd().getPeakListing(colorParameters, Boolean.TRUE);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean highlight(String string) {
        Lst<String> lst = ScriptToken.getTokens(string);
        int n = lst.size();
        switch (n) {
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: 
            case 4: {
                if (((String)lst.get(n - 1)).equalsIgnoreCase("OFF")) break;
            }
            default: {
                return false;
            }
        }
        if (!this.isClosed()) {
            float f = PT.parseFloat(n > 1 ? (String)lst.get(1) : "");
            float f2 = PT.parseFloat(n > 2 ? (String)lst.get(2) : "");
            int n2 = this.getRGB(n > 3 ? (String)lst.get(3) : "100");
            int n3 = this.getRGB(n > 4 ? (String)lst.get(4) : "100");
            int n4 = this.getRGB(n > 5 ? (String)lst.get(5) : "100");
            int n5 = this.getRGB(n > 6 ? (String)lst.get(6) : "100");
            if (Float.isNaN(f) || Float.isNaN(f2)) {
                this.pd().removeAllHighlights();
            } else {
                this.pd().removeHighlight(f, f2);
                if (n5 < 0) {
                    n5 = 150;
                }
                if (n2 >= 0 && n3 >= 0 && n4 >= 0) {
                    this.pd().addHighlight(null, f, f2, null, n2, n3, n4, n5);
                }
            }
            this.repaint(true);
        }
        return true;
    }

    private int getRGB(String string) {
        float f = PT.parseFloat(string);
        return (int)(Float.isNaN(f) ? -1.0f : (f > 1.0f ? f : f * 255.0f));
    }

    private boolean execZoom(String string) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        string = PT.rep(string, " - ", " ").replace(',', ' ');
        Lst<String> lst = ScriptToken.getTokens(string);
        switch (lst.size()) {
            default: {
                return false;
            }
            case 0: {
                ScaleData scaleData = this.pd().getCurrentGraphSet().getCurrentView();
                string = String.valueOf((float)Math.round(scaleData.minXOnScale * 100.0) / 100.0f) + "," + (float)Math.round(scaleData.maxXOnScale * 100.0) / 100.0f;
                string = this.selectedPanel.getInput("Enter zoom range x1 x2", "Zoom", string);
                return string == null || this.execZoom(string);
            }
            case 1: {
                string = (String)lst.get(0);
                if (string.equalsIgnoreCase("next")) {
                    this.pd().nextView();
                } else if (string.toLowerCase().startsWith("prev")) {
                    this.pd().previousView();
                } else if (string.equalsIgnoreCase("out")) {
                    this.pd().resetView();
                } else if (string.equalsIgnoreCase("clear")) {
                    this.pd().clearAllView();
                } else if (string.equalsIgnoreCase("invertY")) {
                    this.pd().getCurrentGraphSet().invertYAxis();
                }
                return true;
            }
            case 2: {
                d = Double.parseDouble((String)lst.get(0));
                d2 = Double.parseDouble((String)lst.get(1));
                break;
            }
            case 3: {
                String string2 = (String)lst.get(0);
                if (string2.equalsIgnoreCase("X")) {
                    d = Double.parseDouble((String)lst.get(1));
                    d2 = Double.parseDouble((String)lst.get(2));
                    break;
                }
                if (!string2.equalsIgnoreCase("Y")) break;
                d3 = Double.parseDouble((String)lst.get(1));
                d4 = Double.parseDouble((String)lst.get(2));
                break;
            }
            case 4: {
                d = Double.parseDouble((String)lst.get(0));
                d3 = Double.parseDouble((String)lst.get(1));
                d2 = Double.parseDouble((String)lst.get(2));
                d4 = Double.parseDouble((String)lst.get(3));
            }
        }
        this.pd().setZoom(d, d3, d2, d4);
        return true;
    }

    private void scaleSelectedBy(Lst<PanelNode> lst, String string) {
        try {
            double d = Double.parseDouble(string);
            int n = lst.size();
            while (--n >= 0) {
                ((PanelNode)lst.get(n)).pd().scaleSelectedBy(d);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PanelData pd() {
        return this.selectedPanel == null ? null : this.selectedPanel.getPanelData();
    }

    private boolean isClosed() {
        return this.pd() == null;
    }

    private void execSelect(String string) {
        if (string.startsWith("ID ")) {
            if (!this.isClosed()) {
                try {
                    this.pd().selectSpectrum(null, "ID", PT.trimQuotes(string.substring(3)), true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        Lst<PanelNode> lst = this.panelNodes;
        int n = lst.size();
        while (--n >= 0) {
            ((PanelNode)lst.get(n)).pd().selectFromEntireSet(Integer.MIN_VALUE);
        }
        Lst<Spectrum> lst2 = new Lst<Spectrum>();
        this.fillSpecList(string, lst2, false);
    }

    public void execView(String string, boolean bl) {
        if (string.equals("")) {
            this.checkOverlay();
            return;
        }
        Lst<Spectrum> lst = new Lst<Spectrum>();
        String string2 = this.fillSpecList(string, lst, true);
        if (lst.size() > 0) {
            this.si.siOpenDataOrFile(null, string2, lst, string2, -1, -1, false, null, null);
        }
        if (!bl) {
            this.si.siValidateAndRepaint(false);
        }
    }

    private void execIRMode(String string) {
        Spectrum.IRMode iRMode = Spectrum.IRMode.getMode(string);
        String string2 = this.pd().getSpectrum().dataType;
        int n = this.panelNodes.size();
        while (--n >= 0) {
            ((PanelNode)this.panelNodes.get(n)).pd().setIRMode(iRMode, string2);
        }
        this.setIRmode(string);
    }

    private void execIntegrate(String string) {
        if (this.isClosed()) {
            return;
        }
        this.pd().checkIntegral(this.parameters, string);
        if (this.integrationRatios != null) {
            this.pd().setIntegrationRatios(this.integrationRatios);
        }
        this.integrationRatios = null;
        this.repaint(true);
    }

    private void repaint(boolean bl) {
        this.selectedPanel.doRepaint(bl);
    }

    private void execSetIntegralParameter(ScriptToken scriptToken, double d) {
        ColorParameters colorParameters = this.parameters;
        switch (scriptToken) {
            case INTEGRALRANGE: {
                colorParameters.integralRange = d;
                break;
            }
            case INTEGRALOFFSET: {
                colorParameters.integralOffset = d;
            }
        }
        if (!this.isClosed()) {
            this.pd().checkIntegral(this.parameters, "update");
        }
    }

    private void setYScale(String string) {
        Lst<String> lst = ScriptToken.getTokens(string);
        int n = 0;
        boolean bl = false;
        if (lst.size() > 1 && ((String)lst.get(0)).equalsIgnoreCase("ALL")) {
            bl = true;
        }
        int n2 = ++n;
        double d = Double.parseDouble((String)lst.get(n2));
        double d2 = Double.parseDouble((String)lst.get(++n));
        if (bl) {
            Spectrum spectrum = this.pd().getSpectrum();
            int n3 = this.panelNodes.size();
            while (--n3 >= 0) {
                PanelNode panelNode = (PanelNode)this.panelNodes.get(n3);
                if (panelNode.source != this.currentSource || !Spectrum.areXScalesCompatible(spectrum, panelNode.getSpectrum(), false, false)) continue;
                panelNode.pd().setZoom(0.0, d, 0.0, d2);
            }
        } else {
            this.pd().setZoom(0.0, d, 0.0, d2);
        }
    }

    private void setOverlayLegendVisibility(Boolean bl, boolean bl2) {
        if (bl2) {
            this.overlayLegendVisible = bl == null ? !this.overlayLegendVisible : bl == Boolean.TRUE;
        }
        PanelNode panelNode = PanelNode.findNode(this.selectedPanel, this.panelNodes);
        int n = this.panelNodes.size();
        while (--n >= 0) {
            this.showOverlayLegend((PanelNode)this.panelNodes.get(n), this.panelNodes.get(n) == panelNode && this.overlayLegendVisible);
        }
    }

    private void showOverlayLegend(PanelNode panelNode, boolean bl) {
        JSVDialog jSVDialog = panelNode.legend;
        if (jSVDialog == null && bl) {
            jSVDialog = panelNode.setLegend(panelNode.pd().getNumberOfSpectraInCurrentSet() > 1 && panelNode.pd().getNumberOfGraphSets() == 1 ? this.getDialog(Annotation.AType.OverlayLegend, null) : null);
        }
        if (jSVDialog != null) {
            jSVDialog.setVisible(bl);
        }
    }

    public void syncScript(String string) {
        String string2;
        String string3;
        Object object;
        String string4;
        String string5;
        String string6;
        String string7;
        if (string.equals("TEST")) {
            string = testScript;
        }
        Logger.info("JSViewer.syncScript Jmol>JSV " + string);
        if (string.indexOf("<PeakData") < 0) {
            if (string.startsWith("JSVSTR:")) {
                this.si.syncToJmol(string);
                return;
            }
            this.runScriptNow(string);
            if (string.indexOf("#SYNC_PEAKS") >= 0) {
                this.syncPeaksAfterSyncScript();
            }
            return;
        }
        Logger.info(">>toJSV>> " + string);
        String string8 = PT.getQuotedAttribute(string, "sourceID");
        if (string8 == null) {
            string7 = PT.getQuotedAttribute(string, "file");
            string6 = PT.getQuotedAttribute(string, "index");
            if (string7 == null || string6 == null) {
                return;
            }
            string7 = PT.rep(string7, "#molfile", "");
            string5 = PT.getQuotedAttribute(string, "model");
            string4 = PT.getQuotedAttribute(string, "src");
            Object object2 = object = string4 != null && string4.startsWith("Jmol") ? null : this.returnFromJmolModel;
            if (string5 != null && object != null && !string5.equals(object)) {
                Logger.info("JSV ignoring model " + string5 + "; should be " + (String)object);
                return;
            }
            this.returnFromJmolModel = null;
            if (this.panelNodes.size() == 0 || !this.checkFileAlreadyLoaded(string7)) {
                Logger.info("file " + string7 + " not found -- JSViewer closing all and reopening");
                this.si.siSyncLoad(string7);
            }
            string3 = PT.getQuotedAttribute(string, "type");
            string2 = null;
        } else {
            string7 = null;
            string6 = string5 = string8;
            string2 = "," + PT.getQuotedAttribute(string, "atom") + ",";
            string3 = "ID";
            string4 = string8;
        }
        object = this.selectPanelByPeak(string7, string6, string2);
        PanelData panelData = this.pd();
        panelData.selectSpectrum(string7, string3, string5, true);
        this.si.siSendPanelChange();
        panelData.addPeakHighlight((PeakInfo)object);
        this.repaint(true);
        if (string4 == null || object != null && ((PeakInfo)object).getAtoms() != null) {
            this.si.syncToJmol(this.jmolSelect((PeakInfo)object));
        }
    }

    private void syncPeaksAfterSyncScript() {
        JDXSource jDXSource = this.currentSource;
        if (jDXSource == null) {
            return;
        }
        try {
            String string = "file=" + PT.esc(jDXSource.getFilePath());
            Lst<PeakInfo> lst = ((Spectrum)jDXSource.getSpectra().get(0)).getPeakList();
            SB sB = new SB();
            sB.append("[");
            int n = lst.size();
            int n2 = 0;
            while (n2 < n) {
                String string2 = ((PeakInfo)lst.get(n2)).toString();
                string2 = String.valueOf(string2) + " " + string;
                sB.append(PT.esc(string2));
                if (n2 > 0) {
                    sB.append(",");
                }
                ++n2;
            }
            sB.append("]");
            this.si.syncToJmol("Peaks: " + sB);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean checkFileAlreadyLoaded(String string) {
        if (this.isClosed()) {
            return false;
        }
        if (this.pd().hasFileLoaded(string)) {
            return true;
        }
        int n = this.panelNodes.size();
        while (--n >= 0) {
            if (!((PanelNode)this.panelNodes.get(n)).pd().hasFileLoaded(string)) continue;
            this.si.siSetSelectedPanel(((PanelNode)this.panelNodes.get((int)n)).jsvp);
            return true;
        }
        return false;
    }

    private PeakInfo selectPanelByPeak(String string, String string2, String string3) {
        if (this.panelNodes == null) {
            return null;
        }
        PeakInfo peakInfo = null;
        int n = this.panelNodes.size();
        while (--n >= 0) {
            ((PanelNode)this.panelNodes.get(n)).pd().addPeakHighlight(null);
        }
        peakInfo = this.pd().selectPeakByFileIndex(string, string2, string3);
        if (peakInfo != null) {
            this.setNode(PanelNode.findNode(this.selectedPanel, this.panelNodes));
        } else {
            n = this.panelNodes.size();
            while (--n >= 0) {
                PanelNode panelNode = (PanelNode)this.panelNodes.get(n);
                peakInfo = panelNode.pd().selectPeakByFileIndex(string, string2, string3);
                if (peakInfo == null) continue;
                this.setNode(panelNode);
                break;
            }
        }
        return peakInfo;
    }

    public void processPeakPickEvent(Object object, boolean bl) {
        PeakInfo peakInfo;
        if (object instanceof PeakInfo) {
            peakInfo = (PeakInfo)object;
            PeakInfo peakInfo2 = this.pd().findMatchingPeakInfo(peakInfo);
            if (peakInfo2 == null) {
                if (!"ALL".equals(peakInfo.getTitle())) {
                    return;
                }
                PanelNode panelNode = null;
                int n = 0;
                while (n < this.panelNodes.size()) {
                    peakInfo2 = ((PanelNode)this.panelNodes.get(n)).pd().findMatchingPeakInfo(peakInfo);
                    if (peakInfo2 != null) {
                        panelNode = (PanelNode)this.panelNodes.get(n);
                        break;
                    }
                    ++n;
                }
                if (panelNode == null) {
                    return;
                }
                this.setNode(panelNode);
            }
            peakInfo = peakInfo2;
        } else {
            PeakPickEvent peakPickEvent = (PeakPickEvent)object;
            this.si.siSetSelectedPanel((JSVPanel)peakPickEvent.getSource());
            peakInfo = peakPickEvent.getPeakInfo();
        }
        this.pd().addPeakHighlight(peakInfo);
        this.syncToJmol(peakInfo);
        if (peakInfo.isClearAll()) {
            this.repaint(false);
        } else {
            this.pd().selectSpectrum(peakInfo.getFilePath(), peakInfo.getType(), peakInfo.getModel(), true);
        }
        this.si.siCheckCallbacks(peakInfo.getTitle());
    }

    void newStructToJmol(String string) {
        Logger.info("sending new structure to Jmol:\n" + string);
        this.si.syncToJmol("struct:" + string);
    }

    private void syncToJmol(PeakInfo peakInfo) {
        this.repaint(true);
        this.returnFromJmolModel = peakInfo.getModel();
        this.si.syncToJmol(this.jmolSelect(peakInfo));
    }

    public void sendPanelChange() {
        PanelData panelData = this.pd();
        Spectrum spectrum = panelData.getSpectrum();
        PeakInfo peakInfo = spectrum.getSelectedPeak();
        if (peakInfo == null) {
            peakInfo = spectrum.getModelPeakInfoForAutoSelectOnLoad();
        }
        if (peakInfo == null) {
            peakInfo = spectrum.getBasePeakInfo();
        }
        panelData.addPeakHighlight(peakInfo);
        Logger.info(Thread.currentThread() + "JSViewer sendFrameChange " + this.selectedPanel);
        this.syncToJmol(peakInfo);
    }

    private String jmolSelect(PeakInfo peakInfo) {
        String string = "IR".equals(peakInfo.getType()) || "RAMAN".equals(peakInfo.getType()) ? "vibration ON; selectionHalos OFF;" : "vibration OFF; selectionhalos " + (peakInfo.getAtoms() == null ? "OFF" : "ON");
        return "Select: " + peakInfo + " script=\"" + string + " \" sourceID=\"" + this.pd().getSpectrum().sourceID + "\"";
    }

    public Map<String, Object> getPropertyAsJavaObject(String string) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if ("SOURCEID".equalsIgnoreCase(string)) {
            hashtable.put(string, this.pd() == null ? "" : this.pd().getSpectrum().sourceID);
            return hashtable;
        }
        if (string != null && string.startsWith("DATA_")) {
            hashtable.put(string, JSVFileManager.cacheGet(string.substring(5)));
            return hashtable;
        }
        boolean bl = false;
        if (string != null && string.toUpperCase().startsWith("ALL ") || "all".equalsIgnoreCase(string)) {
            string = string.substring(3).trim();
            bl = true;
        }
        if ("".equals(string)) {
            string = null;
        }
        if ("NAMES".equalsIgnoreCase(string) || "KEYS".equalsIgnoreCase(string)) {
            string = "";
        }
        Map<String, Object> map = this.pd().getInfo(true, string);
        if (!bl && map != null) {
            return map;
        }
        if (map != null) {
            hashtable.put("current", map);
        }
        Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
        int n = 0;
        while (n < this.panelNodes.size()) {
            JSVPanel jSVPanel = ((PanelNode)this.panelNodes.get((int)n)).jsvp;
            if (jSVPanel != null) {
                lst.addLast(((PanelNode)this.panelNodes.get(n)).getInfo(string));
            }
            ++n;
        }
        hashtable.put("items", lst);
        return hashtable;
    }

    public String getCoordinate() {
        Coordinate coordinate;
        if (!this.isClosed() && (coordinate = this.pd().getClickedCoordinate()) != null) {
            return String.valueOf(coordinate.getXVal()) + " " + coordinate.getYVal();
        }
        return "";
    }

    private String fillSpecList(String string, Lst<Spectrum> lst, boolean bl) {
        PanelNode panelNode;
        Lst<String> lst2;
        int n;
        SB sB;
        Object object;
        String string2 = "1.";
        Lst<String> lst3 = null;
        boolean bl2 = string.equalsIgnoreCase("NONE");
        if (bl2 || string.equalsIgnoreCase("all")) {
            string = "*";
        }
        if (string.indexOf("*") < 0) {
            object = string.split(" ");
            sB = new SB();
            n = 0;
            while (n < ((String[])object).length) {
                int n2 = object[n].indexOf(46);
                if (n2 != ((String)object[n]).lastIndexOf(46)) {
                    object[n] = String.valueOf(((String)object[n]).substring(0, n2 + 1)) + ((String)object[n]).substring(n2 + 1).replace('.', '_');
                }
                sB.append((String)object[n]).append(" ");
                ++n;
            }
            string = sB.toString().trim();
        }
        if (string.equals("*")) {
            lst2 = ScriptToken.getTokens(PanelNode.getSpectrumListAsString(this.panelNodes));
        } else if (string.startsWith("\"") || string.startsWith("'")) {
            lst2 = ScriptToken.getTokens(string);
        } else {
            string = PT.rep(string, "_", " _ ");
            string = PT.rep(string, "-", " - ");
            lst2 = ScriptToken.getTokens(string);
            lst3 = ScriptToken.getTokens(PanelNode.getSpectrumListAsString(this.panelNodes));
            if (lst3.size() == 0) {
                return null;
            }
        }
        object = this.isClosed() ? string2 : PanelNode.findNode((JSVPanel)this.selectedPanel, this.panelNodes).id;
        object = ((String)object).substring(0, ((String)object).indexOf(".") + 1);
        sB = new SB();
        n = lst2.size();
        String string3 = null;
        int n3 = 0;
        while (n3 < n) {
            String string4 = (String)lst2.get(n3);
            double d = Double.NaN;
            int n4 = -1;
            if (n3 + 1 < n && ((String)lst2.get(n3 + 1)).equals("*")) {
                d = Double.parseDouble((String)lst2.get(n3 += 2));
            } else if (n3 + 1 < n && ((String)lst2.get(n3 + 1)).equals("_")) {
                n4 = Integer.parseInt((String)lst2.get(n3 += 2));
            }
            if (string4.equals("-")) {
                if (string3 == null) {
                    string3 = (String)lst3.get(0);
                }
                String string5 = string4 = n3 + 1 == n ? (String)lst3.get(lst3.size() - 1) : (String)lst2.get(++n3);
                if (!string4.contains(".")) {
                    string4 = String.valueOf(object) + string4;
                }
                int n5 = 0;
                while (n5 < lst3.size() && !((String)lst3.get(n5)).equals(string3)) {
                    ++n5;
                }
                ++n5;
                while (n5 < lst3.size() && !string3.equals(string4)) {
                    string3 = (String)lst3.get(n5++);
                    PanelNode panelNode2 = PanelNode.findNodeById(string3, this.panelNodes);
                    lst.addLast(panelNode2.pd().getSpectrumAt(0));
                    sB.append(",").append(string3);
                }
            } else {
                if (string4.startsWith("'") && string4.endsWith("'")) {
                    string4 = "\"" + PT.trim(string4, "'") + "\"";
                }
                if (string4.startsWith("\"")) {
                    string4 = PT.trim(string4, "\"");
                    int n6 = this.panelNodes.size();
                    int n7 = 0;
                    while (n7 < n6) {
                        PanelNode panelNode3 = (PanelNode)this.panelNodes.get(n7);
                        if (panelNode3.fileName != null && panelNode3.fileName.startsWith(string4) || panelNode3.frameTitle != null && panelNode3.frameTitle.startsWith(string4)) {
                            this.addSpecToList(panelNode3.pd(), d, -1, lst, bl);
                            sB.append(",").append(panelNode3.id);
                        }
                        ++n7;
                    }
                } else {
                    PanelNode panelNode4;
                    if (!string4.contains(".")) {
                        string4 = String.valueOf(object) + string4;
                    }
                    if ((panelNode4 = PanelNode.findNodeById(string4, this.panelNodes)) != null) {
                        string3 = string4;
                        this.addSpecToList(panelNode4.pd(), d, n4, lst, bl);
                        sB.append(",").append(string4);
                        if (n4 > 0) {
                            sB.append(".").appendI(n4);
                        }
                    }
                }
            }
            ++n3;
        }
        if (bl && lst.size() > 0 && (panelNode = PanelNode.findNodeById(sB.substring(1), this.panelNodes)) != null) {
            this.setNode(panelNode);
            lst.clear();
        }
        return bl2 ? "NONE" : (sB.length() > 0 ? sB.toString().substring(1) : null);
    }

    private void addSpecToList(PanelData panelData, double d, int n, Lst<Spectrum> lst, boolean bl) {
        if (bl) {
            Spectrum spectrum = panelData.getSpectrumAt(0);
            spectrum.setUserYFactor(Double.isNaN(d) ? 1.0 : d);
            panelData.addToList(n - 1, lst);
        } else {
            panelData.selectFromEntireSet(n - 1);
        }
    }

    public int getSolutionColor(boolean bl) {
        Spectrum spectrum = this.pd().getSpectrum();
        VisibleInterface visibleInterface = spectrum.canShowSolutionColor() ? (VisibleInterface)JSViewer.getInterface("jspecview.common.Visible") : null;
        return visibleInterface == null ? -1 : visibleInterface.getColour(spectrum, bl);
    }

    public int openDataOrFile(Object object, String string, Lst<Spectrum> lst, String string2, int n, int n2, boolean bl, String string3) {
        boolean bl2;
        if ("NONE".equals(string)) {
            this.close("View*");
            return 0;
        }
        this.si.writeStatus("");
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl3 = false;
        if (string2 == null || string2.startsWith("cache://")) {
            // empty if block
        }
        GenericFileInterface genericFileInterface = null;
        if (object != null) {
            try {
                string6 = string;
                string5 = string4 = JSVFileManager.getFullPathName(string);
            }
            catch (JSVException jSVException) {}
        } else if (lst != null) {
            bl3 = true;
            string6 = string4 = "View" + ++this.nViews;
            string5 = string4;
        } else if (string2 != null) {
            try {
                genericFileInterface = this.apiPlatform.newFile(string2);
                URL uRL = new URL(JSVFileManager.appletDocumentBase, string2, null);
                this.recentURL = string4 = uRL.toString();
                string6 = JSVFileManager.getTagName(string4);
            }
            catch (MalformedURLException malformedURLException) {
                string6 = genericFileInterface.getName();
                string5 = string4 = genericFileInterface.getFullPath();
                this.recentURL = null;
            }
        }
        int n3 = -1;
        n3 = PanelNode.isOpen(this.panelNodes, string4);
        if (n3 >= 0 || (n3 = PanelNode.isOpen(this.panelNodes, string2)) >= 0) {
            if (bl3) {
                --this.nViews;
                this.setNode((PanelNode)this.panelNodes.get(n3));
            } else {
                this.si.writeStatus(String.valueOf(string4) + " is already open");
            }
            return -1;
        }
        if (!bl && !bl3) {
            this.close("all");
        }
        this.si.setCursor(3);
        try {
            this.si.siSetCurrentSource(bl3 ? JDXSource.createView(lst) : JDXReader.createJDXSource(genericFileInterface, object, string4, this.obscureTitleFromUser == Boolean.TRUE, this.loadImaginary, n, n2, this.nmrMaxY));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.error(exception.toString());
            if (Logger.debugging) {
                exception.printStackTrace();
            }
            this.si.writeStatus(exception.getMessage());
            this.si.setCursor(0);
            if (this.isApplet) {
                this.selectedPanel.showMessage(exception.toString(), "Error Opening File");
            }
            return -3;
        }
        this.si.setCursor(0);
        System.gc();
        if (string5 == null) {
            string5 = this.currentSource.getFilePath();
            if (string5 != null) {
                string6 = string5.substring(string5.lastIndexOf("/") + 1);
            }
        } else {
            this.currentSource.setFilePath(string5);
        }
        if (string3 == null && !bl3) {
            string3 = string5;
        }
        if (string3 != null) {
            this.currentSource.setID(string3);
        }
        this.si.siSetLoaded(string6, string5);
        Spectrum spectrum = this.currentSource.getJDXSpectrum(0);
        if (spectrum == null) {
            return -4;
        }
        lst = this.currentSource.getSpectra();
        Spectrum.process(lst, this.irMode);
        boolean bl4 = this.interfaceOverlaid || spectrum.isAutoOverlayFromJmolClick();
        boolean bl5 = bl2 = bl3 || bl4 && this.currentSource.isCompoundSource;
        if (bl2) {
            this.combineSpectra(bl3 ? string2 : null);
        } else {
            this.splitSpectra();
        }
        this.pd().setTaintedAll();
        if (!bl3) {
            this.si.siUpdateRecentMenus(string4);
        }
        return 0;
    }

    public void close(String string) {
        JDXSource jDXSource;
        int n;
        boolean bl;
        int n2;
        int n3 = 0;
        int n4 = n2 = string == null ? -2 : string.indexOf(">");
        if (n2 > 0) {
            n3 = PT.parseInt(string.substring(n2 + 1).trim());
            string = string.substring(0, n2).trim();
        }
        if ("*".equals(string)) {
            string = "all";
        }
        boolean bl2 = bl = string == "all";
        if (string == null || n3 == 0 && string.equalsIgnoreCase("all")) {
            this.closeSource(null);
            return;
        }
        boolean bl3 = string.equalsIgnoreCase("views");
        Lst<JDXSource> lst = new Lst<JDXSource>();
        string = string.replace('\\', '/');
        int n5 = this.panelNodes.size();
        int n6 = n5 - n3;
        if (string.endsWith("*")) {
            string = string.substring(0, string.length() - 1);
            int n7 = n5;
            while (--n7 >= 0) {
                if (!((PanelNode)this.panelNodes.get((int)n7)).fileName.startsWith(string)) continue;
                lst.addLast(((PanelNode)this.panelNodes.get((int)n7)).source);
            }
        } else if (string.equalsIgnoreCase("selected")) {
            JDXSource jDXSource2 = null;
            n = n5;
            while (--n >= 0) {
                jDXSource = ((PanelNode)this.panelNodes.get((int)n)).source;
                if (((PanelNode)this.panelNodes.get((int)n)).isSelected && (jDXSource2 == null || jDXSource2 != jDXSource)) {
                    lst.addLast(jDXSource);
                }
                jDXSource2 = jDXSource;
            }
        } else if (bl || bl3 || string.equalsIgnoreCase("simulations")) {
            int n8 = 0;
            n = n5;
            while (--n >= 0 && n8 < n6) {
                if (!bl && !(bl3 ? ((PanelNode)this.panelNodes.get((int)n)).isView : ((PanelNode)this.panelNodes.get((int)n)).isSimulation)) continue;
                lst.addLast(((PanelNode)this.panelNodes.get((int)n)).source);
                ++n8;
            }
        } else {
            JDXSource jDXSource3 = jDXSource = string.length() == 0 ? this.currentSource : PanelNode.findSourceByNameOrId(string, this.panelNodes);
            if (jDXSource != null) {
                lst.addLast(jDXSource);
            }
        }
        int n9 = lst.size();
        while (--n9 >= 0) {
            this.closeSource((JDXSource)lst.get(n9));
        }
        if (this.selectedPanel == null && this.panelNodes.size() > 0) {
            this.si.siSetSelectedPanel(PanelNode.getLastFileFirstNode(this.panelNodes));
        }
    }

    public void execLoad(String string, String string2) {
        boolean bl;
        JSVAppletObject jSVAppletObject = this.html5Applet;
        boolean bl2 = false;
        if (bl2) {
            jSVAppletObject._search(string);
            return;
        }
        Lst<String> lst = ScriptToken.getTokens(string);
        String string3 = (String)lst.get(0);
        String string4 = null;
        int n = 0;
        if (string3.equalsIgnoreCase("ID")) {
            string4 = PT.trimQuotes((String)lst.get(1));
            string3 = (String)lst.get(2);
            n = 2;
        }
        boolean bl3 = string3.equalsIgnoreCase("APPEND");
        boolean bl4 = string3.equalsIgnoreCase("CHECK");
        if (bl3 || bl4) {
            ++n;
        }
        if (n > 0) {
            string3 = (String)lst.get(n);
        }
        if (string2 == null) {
            string2 = this.defaultLoadScript;
        }
        if (string3.equals("?")) {
            this.openFileFromDialog(bl3, false, null, string2);
            return;
        }
        if (string3.equals("http://?")) {
            this.openFileFromDialog(bl3, true, null, null);
            return;
        }
        if (string3.equals("$?") || string3.equals("$H1?")) {
            this.openFileFromDialog(bl3, true, "H1", null);
            return;
        }
        if (string3.equals("$C13?")) {
            this.openFileFromDialog(bl3, true, "C13", null);
            return;
        }
        boolean bl5 = string3.equalsIgnoreCase("MOL") || string3.equalsIgnoreCase("H1");
        boolean bl6 = string3.equalsIgnoreCase("C13");
        if (bl5 || bl6) {
            string3 = "http://SIMULATION/" + (bl5 ? "H1/" : "C13/") + "MOL=" + PT.trimQuotes((String)lst.get(++n));
        }
        if (!bl4 && !bl3) {
            if (string3.equals("\"\"") && this.currentSource != null) {
                string3 = this.currentSource.getFilePath();
            }
            this.close("all");
        }
        if (bl = (string3 = PT.trimQuotes(string3)).startsWith("$")) {
            if (!string3.startsWith("$H1") && !string3.startsWith("$C13")) {
                string3 = "$H1/" + string3.substring(1);
            }
            string3 = "http://SIMULATION/" + string3.substring(1);
        }
        int n2 = n + 1 < lst.size() ? Integer.valueOf((String)lst.get(++n)) : -1;
        int n3 = n + 1 < lst.size() ? Integer.valueOf((String)lst.get(++n)) : n2;
        this.si.siOpenDataOrFile(null, null, null, string3, n2, n3, bl3, string2, string4);
        if (bl) {
            this.close("views");
            this.execView("*", true);
        }
    }

    public void combineSpectra(String string) {
        JDXSource jDXSource = this.currentSource;
        Lst<Spectrum> lst = jDXSource.getSpectra();
        boolean bl = false;
        int n = lst.size();
        while (--n >= 0) {
            if (!((Spectrum)lst.get((int)n)).isSimulation) continue;
            bl = true;
            break;
        }
        JSVPanel jSVPanel = this.si.siGetNewJSVPanel2(lst);
        jSVPanel.setTitle(jDXSource.getTitle());
        if (jSVPanel.getTitle().equals("")) {
            jSVPanel.getPanelData().setViewTitle(jDXSource.getFilePath());
            jSVPanel.setTitle(string);
        }
        this.si.siSetPropertiesFromPreferences(jSVPanel, true);
        ++this.fileCount;
        (new JSVPanel[1])[0] = jSVPanel;
        this.spectraTree.createTree((int)(this.fileCount + 1), (JDXSource)jDXSource, (JSVPanel[])new JSVPanel[1]).getPanelNode().isView = true;
        PanelNode panelNode = PanelNode.findNode(this.selectedPanel, this.panelNodes);
        panelNode.setFrameTitle(string);
        panelNode.isView = true;
        if (this.autoShowLegend && this.pd().getNumberOfGraphSets() == 1) {
            panelNode.setLegend(this.getDialog(Annotation.AType.OverlayLegend, null));
        }
        this.si.siSetMenuEnables(panelNode, false);
        if (bl) {
            this.pd().splitStack(true);
        }
    }

    public void closeSource(JDXSource jDXSource) {
        JSVTreeNode jSVTreeNode = this.spectraTree.getRootNode();
        String string = jDXSource == null ? null : jDXSource.getFilePath();
        Lst<JSVTreeNode> lst = new Lst<JSVTreeNode>();
        Enumeration<TreeNode> enumeration = jSVTreeNode.children();
        while (enumeration.hasMoreElements()) {
            JSVTreeNode jSVTreeNode2 = (JSVTreeNode)((Object)enumeration.nextElement());
            if (string != null && !jSVTreeNode2.getPanelNode().source.matchesFilePath(string)) continue;
            Logger.info("Closing " + jSVTreeNode2.getPanelNode().source.getFilePath());
            Enumeration<TreeNode> enumeration2 = jSVTreeNode2.children();
            while (enumeration2.hasMoreElements()) {
                JSVTreeNode jSVTreeNode3 = (JSVTreeNode)((Object)enumeration2.nextElement());
                lst.addLast(jSVTreeNode3);
                this.panelNodes.removeObj(jSVTreeNode3.getPanelNode());
            }
            lst.addLast(jSVTreeNode2);
            if (string != null) break;
        }
        this.spectraTree.deleteNodes(lst);
        if (jDXSource == null) {
            if (this.currentSource != null) {
                this.currentSource.dispose();
            }
            this.currentSource = null;
            if (this.selectedPanel != null) {
                this.selectedPanel.dispose();
            }
        }
        if (this.currentSource == jDXSource) {
            this.si.siSetSelectedPanel(null);
            this.si.siSetCurrentSource(null);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.panelNodes.size()) {
            float f = PT.parseFloat(((PanelNode)this.panelNodes.get((int)n2)).id);
            if (f >= (float)(n + 1)) {
                n = (int)Math.floor(f);
            }
            ++n2;
        }
        this.fileCount = n;
        System.gc();
        if (Logger.debugging) {
            Logger.checkMemory();
        }
        this.si.siSourceClosed(jDXSource);
    }

    public void setFrameAndTreeNode(int n) {
        if (this.panelNodes == null || n < 0 || n >= this.panelNodes.size()) {
            return;
        }
        this.setNode((PanelNode)this.panelNodes.get(n));
    }

    public PanelNode selectFrameNode(JSVPanel jSVPanel) {
        PanelNode panelNode = PanelNode.findNode(jSVPanel, this.panelNodes);
        if (panelNode == null) {
            return null;
        }
        this.spectraTree.setPath(this.spectraTree.newTreePath(panelNode.treeNode.getPath()));
        this.setOverlayLegendVisibility(null, false);
        return panelNode;
    }

    private boolean setSpectrum(String string) {
        if (string.indexOf(46) >= 0) {
            PanelNode panelNode = PanelNode.findNodeById(string, this.panelNodes);
            if (panelNode == null) {
                return false;
            }
            this.setNode(panelNode);
        } else {
            int n = PT.parseInt(string);
            if (n <= 0) {
                this.checkOverlay();
                return false;
            }
            this.setFrameAndTreeNode(n - 1);
        }
        return true;
    }

    public void splitSpectra() {
        JDXSource jDXSource = this.currentSource;
        Lst<Spectrum> lst = jDXSource.getSpectra();
        JSVPanel[] jSVPanelArray = new JSVPanel[lst.size()];
        JSVPanel jSVPanel = null;
        int n = 0;
        while (n < lst.size()) {
            Spectrum spectrum = (Spectrum)lst.get(n);
            jSVPanel = this.si.siGetNewJSVPanel(spectrum);
            this.si.siSetPropertiesFromPreferences(jSVPanel, true);
            jSVPanelArray[n] = jSVPanel;
            ++n;
        }
        this.spectraTree.createTree(++this.fileCount, jDXSource, jSVPanelArray);
        this.si.siGetNewJSVPanel(null);
        PanelNode panelNode = PanelNode.findNode(this.selectedPanel, this.panelNodes);
        this.si.siSetMenuEnables(panelNode, true);
    }

    public void selectedTreeNode(JSVTreeNode jSVTreeNode) {
        if (jSVTreeNode == null) {
            return;
        }
        if (jSVTreeNode.isLeaf()) {
            this.setNode(jSVTreeNode.getPanelNode());
        } else {
            System.out.println("not a leaf");
        }
        this.si.siSetCurrentSource(jSVTreeNode.getPanelNode().source);
    }

    public void dispose() {
        this.fileHelper = null;
        if (this.viewDialog != null) {
            this.viewDialog.dispose();
        }
        this.viewDialog = null;
        if (this.overlayLegendDialog != null) {
            this.overlayLegendDialog.dispose();
        }
        this.overlayLegendDialog = null;
        if (this.jsvpPopupMenu != null) {
            this.jsvpPopupMenu.jpiDispose();
            this.jsvpPopupMenu = null;
        }
        if (this.panelNodes != null) {
            int n = this.panelNodes.size();
            while (--n >= 0) {
                ((PanelNode)this.panelNodes.get(n)).dispose();
                this.panelNodes.removeItemAt(n);
            }
        }
    }

    public void runScript(String string) {
        if (this.scriptQueue == null) {
            this.si.siProcessCommand(string);
        } else {
            this.scriptQueue.addLast(string);
        }
    }

    public void requestRepaint() {
        if (this.selectedPanel != null) {
            this.repaintManager.refresh();
        }
    }

    public void repaintDone() {
        this.repaintManager.repaintDone();
    }

    public void checkOverlay() {
        if (this.mainPanel != null) {
            this.markSelectedPanels(this.panelNodes, this.mainPanel.getCurrentPanelIndex());
        }
        this.viewDialog = this.getDialog(Annotation.AType.Views, null);
    }

    private void markSelectedPanels(Lst<PanelNode> lst, int n) {
        int n2 = lst.size();
        while (--n2 >= 0) {
            boolean bl = ((PanelNode)lst.get((int)n2)).isSelected = n == n2;
        }
    }

    private void execOverlayOffsetY(int n) {
        if (n == Integer.MIN_VALUE) {
            if (this.selectedPanel == null) {
                return;
            }
            String string = this.selectedPanel.getInput("Enter a vertical offset in percent for stacked plots", "Overlay", "" + this.recentStackPercent);
            float f = PT.parseFloat(string);
            if (Float.isNaN(f)) {
                return;
            }
            n = (int)f;
        }
        this.recentStackPercent = n;
        this.parameters.viewOffset = n;
        if (this.isClosed()) {
            this.pd().setYStackOffsetPercent(n);
        }
    }

    private void execScriptInline(String string) {
        if (string.length() > 0) {
            string = string.substring(6).trim();
        }
        if (string.length() == 0) {
            string = this.selectedPanel.getInput("Enter a JSpecView script", "Script", this.recentScript);
        }
        if (string == null) {
            return;
        }
        this.recentScript = string;
        this.runScriptNow(string);
    }

    public void setDisplay(Object object) {
        this.display = object;
        this.apiPlatform.setViewer(this, this.display);
        int[] nArray = new int[2];
        this.apiPlatform.getFullScreenDimensions(object, nArray);
        this.setScreenDimension(nArray[0], nArray[1]);
    }

    public void setScreenDimension(int n, int n2) {
        n2 = Math.min(n2, this.maximumSize);
        if (this.screenWidth == (n = Math.min(n, this.maximumSize)) && this.screenHeight == n2) {
            return;
        }
        this.resizeImage(n, n2);
    }

    void resizeImage(int n, int n2) {
        if (n > 0) {
            this.screenWidth = n;
            this.screenHeight = n2;
        } else {
            n = this.screenWidth == 0 ? (this.screenWidth = 500) : this.screenWidth;
            n2 = this.screenHeight == 0 ? (this.screenHeight = 500) : this.screenHeight;
        }
        this.g2d.setWindowParameters(n, n2);
    }

    public void updateJS() {
        if (this.selectedPanel != null) {
            this.selectedPanel.paintComponent(this.apiPlatform.getGraphics(null));
        }
    }

    public boolean processMouseEvent(int n, int n2, int n3, int n4, long l) {
        return this.selectedPanel != null && this.selectedPanel.processMouseEvent(n, n2, n3, n4, l);
    }

    public void processTwoPointGesture(float[][][] fArray) {
        if (!this.isClosed()) {
            this.selectedPanel.processTwoPointGesture(fArray);
        }
    }

    public JSVAppletObject getApplet() {
        return this.html5Applet;
    }

    public void openFileAsyncSpecial(String string, int n) {
        String string2;
        String string3 = string2 = this.currentSource == null ? "NO" : this.getDialogManager().getDialogInput(this, "Do you want to append this file? (Answer NO to replace.)", "Drag/Drop Action", 3, null, null, "YES");
        if (string2 == null) {
            return;
        }
        String string4 = string2.toLowerCase().startsWith("y") ? "append" : "";
        String string5 = string4 == "" ? "" : "; view *";
        this.runScript("load " + string4 + " \"" + string + "\"" + string5);
    }

    public int getHeight() {
        return this.screenHeight;
    }

    public int getWidth() {
        return this.screenWidth;
    }

    public Object getPlatformInterface(String string) {
        return JSViewer.getInterface("jspecview." + (isJS ? "js2d.Js" : "java.Awt") + string);
    }

    public DialogManager getDialogManager() {
        if (this.dialogManager != null) {
            return this.dialogManager;
        }
        this.dialogManager = (DialogManager)this.getPlatformInterface("DialogManager");
        return this.dialogManager.set(this);
    }

    public JSVDialog getDialog(Annotation.AType aType, Spectrum spectrum) {
        String string = "jspecview.dialog.";
        switch (aType) {
            case Integration: {
                return ((JSVDialog)JSViewer.getInterface(String.valueOf(string) + "IntegrationDialog")).setParams("Integration for " + spectrum, this, spectrum);
            }
            case Measurements: {
                return ((JSVDialog)JSViewer.getInterface(String.valueOf(string) + "MeasurementsDialog")).setParams("Measurements for " + spectrum, this, spectrum);
            }
            case PeakList: {
                return ((JSVDialog)JSViewer.getInterface(String.valueOf(string) + "PeakListDialog")).setParams("Peak List for " + spectrum, this, spectrum);
            }
            case OverlayLegend: {
                this.overlayLegendDialog = ((JSVDialog)JSViewer.getInterface(String.valueOf(string) + "OverlayLegendDialog")).setParams(this.pd().getViewTitle(), this, null);
                return this.overlayLegendDialog;
            }
            case Views: {
                this.viewDialog = ((JSVDialog)JSViewer.getInterface(String.valueOf(string) + "ViewsDialog")).setParams("View/Combine/Close Spectra", this, null);
                return this.viewDialog;
            }
        }
        return null;
    }

    private void show(String string) {
        this.getDialogManager();
        if (string.equals("properties")) {
            this.dialogManager.showProperties(null, this.pd().getSpectrum());
        } else if (string.equals("errors")) {
            this.dialogManager.showSourceErrors(null, this.currentSource);
        } else if (string.equals("source")) {
            if (this.currentSource == null) {
                if (this.panelNodes.size() > 0) {
                    this.dialogManager.showMessageDialog(null, "Please Select a Spectrum", "Select Spectrum", 0);
                }
                return;
            }
            this.dialogManager.showSource(this, this.pd().getSpectrum());
        } else if (string.startsWith("solutioncolorfill")) {
            if (string.indexOf("all") >= 0) {
                int n = this.panelNodes.size();
                while (--n >= 0) {
                    ((PanelNode)this.panelNodes.get(n)).pd().setSolutionColor(string);
                }
            } else {
                this.pd().setSolutionColor(string);
            }
        } else if (string.startsWith("solutioncolor")) {
            String string2 = this.getSolutionColorStr(string.indexOf("false") < 0);
            string2 = "background-color:rgb(" + string2 + ")'><br />Predicted Solution Colour- RGB(" + string2 + ")<br /><br />";
            if (isJS) {
                this.dialogManager.showMessage(this, "<div style='width:100%;height:100%;" + string2 + "</div>", "Predicted Colour");
            } else {
                this.selectedPanel.showMessage("<html><body style='" + string2 + "</body></html>", "Predicted Colour");
            }
        }
    }

    public PrintLayout getDialogPrint(boolean bl) {
        if (!isJS) {
            try {
                PrintLayout printLayout = ((JSVPrintDialog)this.getPlatformInterface("PrintDialog")).set(this.offWindowFrame, this.lastPrintLayout, bl).getPrintLayout();
                if (printLayout != null) {
                    this.lastPrintLayout = printLayout;
                }
                return printLayout;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PrintLayout(this.pd());
    }

    public void setIRmode(String string) {
        this.irMode = string.equals("AtoT") ? Spectrum.IRMode.TO_TRANS : (string.equals("TtoA") ? Spectrum.IRMode.TO_ABS : Spectrum.IRMode.getMode(string));
    }

    public int getOptionFromDialog(String[] stringArray, String string, String string2) {
        return this.getDialogManager().getOptionFromDialog(null, stringArray, this.selectedPanel, string, string2);
    }

    public String print(String string) {
        return this.execWrite("PDF \"" + string + "\"");
    }

    private String execWrite(String string) {
        if (isJS && string == null) {
            string = "PDF";
        }
        String string2 = ((ExportInterface)JSViewer.getInterface("jspecview.export.Exporter")).write(this, string == null ? null : ScriptToken.getTokens(string), false);
        this.si.writeStatus(string2);
        return string2;
    }

    public String export(String string, int n) {
        if (string == null) {
            string = "XY";
        }
        PanelData panelData = this.pd();
        int n2 = panelData.getNumberOfSpectraInCurrentSet();
        if (n < -1 || n >= n2) {
            return "Maximum spectrum index (0-based) is " + (n2 - 1) + ".";
        }
        Spectrum spectrum = n < 0 ? panelData.getSpectrum() : panelData.getSpectrumAt(n);
        try {
            return ((ExportInterface)JSViewer.getInterface("jspecview.export.Exporter")).exportTheSpectrum(this, ExportType.getType(string), null, spectrum, 0, spectrum.getXYCoords().length - 1, null, string.equalsIgnoreCase("PDF"));
        }
        catch (Exception exception) {
            Logger.error(exception.toString());
            return null;
        }
    }

    @Override
    public String postByteArray(String string, byte[] byArray) {
        return JSVFileManager.postByteArray(string, byArray);
    }

    public OC getOutputChannel(String string, boolean bl) throws Exception {
        FileOutputStream fileOutputStream = null;
        fileOutputStream = string == null || string.equals(";base64,") ? null : new FileOutputStream(string);
        return new OC().setParams(this, string, !bl, fileOutputStream);
    }

    public static Object getInterface(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz == null ? null : clazz.newInstance();
        }
        catch (Exception exception) {
            Logger.error("Interface.java Error creating instance for " + string + ": \n" + exception);
            return null;
        }
    }

    public void showMessage(String string) {
        if (this.selectedPanel != null && string != null) {
            this.selectedPanel.showMessage(string, null);
        }
    }

    public void openFileFromDialog(boolean bl, boolean bl2, String string, String string2) {
        String string3 = null;
        if (string != null) {
            string3 = this.fileHelper.getUrlFromDialog("Enter the name or identifier of a compound", this.recentSimulation);
            if (string3 == null) {
                return;
            }
            this.recentSimulation = string3;
            string3 = "$" + string + "/" + string3;
        } else if (bl2) {
            string3 = this.fileHelper.getUrlFromDialog("Enter the URL of a JCAMP-DX File", this.recentURL == null ? this.recentOpenURL : this.recentURL);
            if (string3 == null) {
                return;
            }
            this.recentOpenURL = string3;
        } else {
            Object[] objectArray = new Object[]{bl, string2};
            GenericFileInterface genericFileInterface = this.fileHelper.showFileOpenDialog(this.mainPanel, objectArray);
            if (genericFileInterface != null) {
                string3 = genericFileInterface.getFullPath();
            }
        }
        if (string3 != null) {
            this.runScriptNow("load " + (bl ? "APPEND " : "") + "\"" + string3 + "\"" + (string2 == null ? "" : ";" + string2));
        }
    }

    public void openFile(String string, boolean bl) {
        JDXSource jDXSource;
        if (bl && this.panelNodes != null && (jDXSource = PanelNode.findSourceByNameOrId(new File(string).getAbsolutePath(), this.panelNodes)) != null) {
            this.closeSource(jDXSource);
        }
        this.si.siOpenDataOrFile(null, null, null, string, -1, -1, true, this.defaultLoadScript, null);
    }

    public int selectPanel(JSVPanel jSVPanel, Lst<PanelNode> lst) {
        int n = -1;
        if (lst != null) {
            int n2 = lst.size();
            while (--n2 >= 0) {
                JSVPanel jSVPanel2 = ((PanelNode)lst.get((int)n2)).jsvp;
                if (jSVPanel2 == jSVPanel) {
                    n = n2;
                    continue;
                }
                jSVPanel2.setEnabled(false);
                jSVPanel2.setFocusable(false);
                jSVPanel2.getPanelData().closeAllDialogsExcept(Annotation.AType.NONE);
            }
            this.markSelectedPanels(lst, n);
        }
        return n;
    }

    public void checkAutoIntegrate() {
        if (this.autoIntegrate) {
            this.pd().integrateAll(this.parameters);
        }
    }

    public void parseInitScript(String string) {
        if (string == null) {
            string = "";
        }
        ScriptTokenizer scriptTokenizer = new ScriptTokenizer(string, true);
        if (Logger.debugging) {
            Logger.info("Running in DEBUG mode");
        }
        block16: while (scriptTokenizer.hasMoreTokens()) {
            String string2 = scriptTokenizer.nextToken();
            ScriptTokenizer scriptTokenizer2 = new ScriptTokenizer(string2, false);
            String string3 = scriptTokenizer2.nextToken();
            if (string3.equalsIgnoreCase("SET")) {
                string3 = scriptTokenizer2.nextToken();
            }
            string3 = string3.toUpperCase();
            ScriptToken scriptToken = ScriptToken.getScriptToken(string3);
            String string4 = ScriptToken.getValue(scriptToken, scriptTokenizer2, string2);
            Logger.info("KEY-> " + string3 + " VALUE-> " + string4 + " : " + (Object)((Object)scriptToken));
            try {
                switch (scriptToken) {
                    default: {
                        this.parameters.set(null, scriptToken, string4);
                        break;
                    }
                    case UNKNOWN: {
                        break;
                    }
                    case APPLETID: {
                        this.appletName = string4;
                        this.fullName = String.valueOf(this.appletName) + "__" + this.appletName + "__";
                        Object var8_8 = null;
                        this.html5Applet = var8_8;
                        break;
                    }
                    case AUTOINTEGRATE: {
                        this.autoIntegrate = Parameters.isTrue(string4);
                        break;
                    }
                    case COMPOUNDMENUON: {
                        break;
                    }
                    case APPLETREADYCALLBACKFUNCTIONNAME: 
                    case COORDCALLBACKFUNCTIONNAME: 
                    case LOADFILECALLBACKFUNCTIONNAME: 
                    case PEAKCALLBACKFUNCTIONNAME: 
                    case SYNCCALLBACKFUNCTIONNAME: {
                        this.si.siExecSetCallback(scriptToken, string4);
                        break;
                    }
                    case ENDINDEX: {
                        this.initialEndIndex = Integer.parseInt(string4);
                        break;
                    }
                    case INTERFACE: {
                        this.checkOvelayInterface(string4);
                        break;
                    }
                    case IRMODE: {
                        this.setIRmode(string4);
                        break;
                    }
                    case MENUON: {
                        this.allowMenu = Boolean.parseBoolean(string4);
                        break;
                    }
                    case OBSCURE: {
                        if (this.obscureTitleFromUser != null) continue block16;
                        this.obscureTitleFromUser = Boolean.valueOf(string4);
                        break;
                    }
                    case STARTINDEX: {
                        this.initialStartIndex = Integer.parseInt(string4);
                        break;
                    }
                    case SYNCID: {
                        this.syncID = string4;
                        this.fullName = String.valueOf(this.appletName) + "__" + this.syncID + "__";
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getSolutionColorStr(boolean bl) {
        P3 p3 = CU.colorPtFromInt(this.getSolutionColor(bl), null);
        return String.valueOf((int)p3.x) + "," + (int)p3.y + "," + (int)p3.z;
    }

    public String checkCommandLineForTip(char c, String string, boolean bl) {
        String string2;
        boolean bl2;
        boolean bl3 = bl2 = c == '\u0001';
        if (!bl2 && c != '\u0000') {
            if (c != '\t' && (c == '\n' || c < ' ' || c > '~')) {
                return null;
            }
            string = String.valueOf(string) + (Character.isISOControl(c) ? "" : "" + c);
        }
        if (string.indexOf(";") >= 0) {
            string = string.substring(string.lastIndexOf(";") + 1);
        }
        String string3 = null;
        while (string.startsWith(" ")) {
            string = string.substring(1);
        }
        if (string.length() == 0 && !bl2) {
            string2 = "";
        } else {
            Lst<String> lst = ScriptToken.getTokens(string);
            if (lst.size() == 0 && !bl2) {
                return "";
            }
            boolean bl4 = string.endsWith(" ") || lst.size() > 1 && bl;
            Lst<ScriptToken> lst2 = ScriptToken.getScriptTokenList(lst.size() == 0 ? null : (String)lst.get(0), bl4);
            switch (lst2.size()) {
                case 0: {
                    string2 = "?";
                    break;
                }
                case 1: {
                    ScriptToken scriptToken = (ScriptToken)((Object)lst2.get(0));
                    string2 = scriptToken.getTip();
                    try {
                        string2 = string2.indexOf("TRUE") >= 0 ? " (" + this.parameters.getBoolean(scriptToken) + ")" : (scriptToken.name().indexOf("COLOR") >= 0 ? " (" + CU.toRGBHexString(this.parameters.getElementColor(scriptToken)) + ")" : "");
                    }
                    catch (Exception exception) {
                        return null;
                    }
                    if (c == '\t' || bl4 || !bl) {
                        string2 = String.valueOf(scriptToken.name()) + " " + scriptToken.getTip() + string2 + " " + scriptToken.getDescription();
                        if (c != '\t') break;
                        string3 = String.valueOf(scriptToken.name()) + " ";
                        break;
                    }
                    string2 = String.valueOf(scriptToken.name()) + " " + string2;
                    break;
                }
                default: {
                    string2 = ScriptToken.getNameList(lst2);
                }
            }
        }
        if (bl) {
            this.si.writeStatus(string2);
        } else {
            string3 = string2;
        }
        return string3;
    }

    public String checkScript(String string) {
        return this.checkCommandLineForTip('\u0000', string, false);
    }

    private void execHelp(String string) {
        String string2 = this.checkCommandLineForTip('\u0001', string, false);
        if (string2.indexOf(" ") < 0 && string2.indexOf(",") > 0) {
            Object[] objectArray = PT.split(string2, ",");
            Arrays.sort(objectArray);
            string2 = "";
            int n = 0;
            while (n < objectArray.length) {
                ScriptToken scriptToken = ScriptToken.getScriptToken((String)objectArray[n]);
                string2 = String.valueOf(string2) + (String)objectArray[n] + " " + scriptToken.getTip() + "\n  " + scriptToken.getDescription() + "\n\n";
                ++n;
            }
            this.getDialogManager().showMessage(null, string2, "HELP " + string);
        } else {
            this.selectedPanel.showMessage(string2, "Help " + string);
        }
        System.out.println(string2);
    }
}

