/*
 * Decompiled with CFR 0.152.
 */
package jspecview.dialog;

import java.util.Enumeration;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.tree.TreeNode;
import jspecview.api.JSVTreeNode;
import jspecview.common.Annotation;
import jspecview.common.PanelNode;
import jspecview.dialog.JSVDialog;

public class ViewsDialog
extends JSVDialog {
    private Lst<JSVTreeNode> treeNodes;
    private Lst<Object> checkBoxes;
    private Object closeSelectedButton;
    private Object combineSelectedButton;
    private Object viewSelectedButton;
    private static int[] posXY = new int[]{Integer.MIN_VALUE, 0};
    private boolean checking = false;

    public ViewsDialog() {
        this.type = Annotation.AType.Views;
    }

    @Override
    public int[] getPosXY() {
        return posXY;
    }

    @Override
    protected void addUniqueControls() {
        this.checkBoxes = new Lst();
        this.treeNodes = new Lst();
        this.dialog.addButton("btnSelectAll", "Select All");
        this.dialog.addButton("btnSelectNone", "Select None");
        this.txt2 = this.dialog.addTextField("txtOffset", "Offset", "" + this.vwr.parameters.viewOffset, "%", null, true);
        this.viewSelectedButton = this.dialog.addButton("btnViewSelected", "View Selected");
        this.combineSelectedButton = this.dialog.addButton("btnCombineSelected", "Combine Selected");
        this.closeSelectedButton = this.dialog.addButton("btnCloseSelected", "Close Selected");
        this.dialog.addButton("btnDone", "Done");
        this.dialog.setPreferredSize(800, 350);
        this.txt1 = this.dialog.addCheckBox(null, null, 0, false);
        this.addCheckBoxes(this.vwr.spectraTree.getRootNode(), 0, true);
        this.addCheckBoxes(this.vwr.spectraTree.getRootNode(), 0, false);
    }

    private void addCheckBoxes(JSVTreeNode rootNode, int level, boolean isViews) {
        Enumeration<TreeNode> enume = rootNode.children();
        while (enume.hasMoreElements()) {
            JSVTreeNode treeNode = (JSVTreeNode)((Object)enume.nextElement());
            PanelNode node = treeNode.getPanelNode();
            if (node.isView != isViews) continue;
            String title = node.toString();
            if (title.indexOf("\n") >= 0) {
                title = title.substring(0, title.indexOf(10));
            }
            String name = "chkBox" + this.treeNodes.size();
            Object cb = this.dialog.addCheckBox(name, title, level, node.isSelected);
            treeNode.setIndex(this.treeNodes.size());
            this.treeNodes.addLast(treeNode);
            this.checkBoxes.addLast(cb);
            this.addCheckBoxes(treeNode, level + 1, isViews);
        }
    }

    @Override
    public void checkEnables() {
        int n = 0;
        for (int i = 0; i < this.checkBoxes.size(); ++i) {
            if (!this.dialog.isSelected(this.checkBoxes.get(i)) || ((JSVTreeNode)this.treeNodes.get((int)i)).getPanelNode().jsvp == null) continue;
            ++n;
        }
        System.out.println("viewsdialog n=" + n);
        this.dialog.setEnabled(this.closeSelectedButton, n > 0);
        this.dialog.setEnabled(this.combineSelectedButton, n > 1);
        this.dialog.setEnabled(this.viewSelectedButton, n == 1);
    }

    protected void check(String name) {
        int i = PT.parseInt(name.substring(name.indexOf("_") + 1));
        JSVTreeNode node = (JSVTreeNode)this.treeNodes.get(i);
        Object cb = this.checkBoxes.get(i);
        boolean isSelected = this.dialog.isSelected(cb);
        if (node.getPanelNode().jsvp == null) {
            if (!this.checking && isSelected && this.dialog.getText(cb).startsWith("Overlay")) {
                this.checking = true;
                this.selectAll(false);
                this.dialog.setSelected(cb, true);
                node.getPanelNode().isSelected = true;
                this.checking = false;
            }
            Enumeration<TreeNode> enume = node.children();
            while (enume.hasMoreElements()) {
                JSVTreeNode treeNode = (JSVTreeNode)((Object)enume.nextElement());
                this.dialog.setSelected(this.checkBoxes.get(treeNode.getIndex()), isSelected);
                treeNode.getPanelNode().isSelected = isSelected;
                node.getPanelNode().isSelected = isSelected;
            }
        } else {
            node.getPanelNode().isSelected = isSelected;
        }
        if (isSelected) {
            i = this.treeNodes.size();
            while (--i >= 0) {
                if (((JSVTreeNode)this.treeNodes.get((int)i)).getPanelNode().isView == node.getPanelNode().isView) continue;
                this.dialog.setSelected(this.checkBoxes.get(((JSVTreeNode)this.treeNodes.get(i)).getIndex()), false);
                ((JSVTreeNode)this.treeNodes.get((int)i)).getPanelNode().isSelected = false;
            }
        }
        this.checkEnables();
    }

    protected void selectAll(boolean mode) {
        int i = this.checkBoxes.size();
        while (--i >= 0) {
            this.dialog.setSelected(this.checkBoxes.get(i), mode);
            ((JSVTreeNode)this.treeNodes.get((int)i)).getPanelNode().isSelected = mode;
        }
        this.checkEnables();
    }

    protected void combineSelected() {
    }

    protected void viewSelected() {
        SB sb = new SB();
        PanelNode thisNode = null;
        int n = 0;
        for (int i = 0; i < this.checkBoxes.size(); ++i) {
            Object cb = this.checkBoxes.get(i);
            PanelNode node = ((JSVTreeNode)this.treeNodes.get(i)).getPanelNode();
            if (!this.dialog.isSelected(cb) || node.jsvp == null) continue;
            if (node.isView) {
                thisNode = node;
                n = 2;
                break;
            }
            ++n;
            String label = this.dialog.getText(cb);
            sb.append(" ").append(label.substring(0, label.indexOf(":")));
        }
        String script = null;
        if (n > 1) {
            this.eventApply();
            script = "STACKOFFSETY " + this.vwr.parameters.viewOffset;
        }
        if (thisNode == null) {
            this.vwr.execView(sb.toString().trim(), false);
            this.layoutDialog();
        } else {
            this.vwr.setNode(thisNode);
        }
        if (script != null) {
            this.vwr.runScript(script);
        }
    }

    protected void closeSelected() {
        this.vwr.runScript("close !selected");
        this.layoutDialog();
    }

    @Override
    public boolean callback(String id, String msg) {
        if (id.equals("btnSelectAll")) {
            this.selectAll(true);
        } else if (id.equals("btnSelectNone")) {
            this.selectAll(false);
        } else if (id.equals("btnViewSelected")) {
            this.viewSelected();
        } else if (id.equals("btnCombineSelected")) {
            this.viewSelected();
        } else if (id.equals("btnCloseSelected")) {
            this.closeSelected();
        } else if (id.equals("btnDone")) {
            this.viewSelected();
            this.dispose();
            this.done();
        } else if (id.equals("txtOffset")) {
            this.eventApply();
            this.viewSelected();
        } else if (id.startsWith("chk")) {
            this.checkEnables();
        } else {
            return this.callbackAD(id, msg);
        }
        return true;
    }

    @Override
    public void applyFromFields() {
        this.apply(new Object[]{this.dialog.getText(this.txt2)});
    }
}

