/*
 * Decompiled with CFR 0.152.
 */
package naga;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import naga.ChannelResponder;
import naga.NIOService;
import naga.NIOSocket;
import naga.PacketReader;
import naga.PacketWriter;
import naga.SocketObserver;
import naga.SocketReader;
import naga.SocketWriter;
import naga.packetreader.RawPacketReader;

class SocketChannelResponder
extends ChannelResponder
implements NIOSocket {
    private int m_maxQueueSize = -1;
    private long m_timeOpened = -1L;
    private final AtomicLong m_bytesInQueue;
    private ConcurrentLinkedQueue<Object> m_packetQueue;
    private PacketReader m_packetReader = RawPacketReader.INSTANCE;
    private volatile SocketObserver m_socketObserver = null;
    private final SocketReader m_socketReader;
    private final SocketWriter m_socketWriter;

    public SocketChannelResponder(NIOService nIOService, SocketChannel socketChannel, InetSocketAddress inetSocketAddress) {
        super(nIOService, socketChannel, inetSocketAddress);
        this.m_bytesInQueue = new AtomicLong(0L);
        this.m_packetQueue = new ConcurrentLinkedQueue();
        this.m_socketReader = new SocketReader(nIOService);
        this.m_socketWriter = new SocketWriter();
    }

    @Override
    void keyInitialized() {
        if (!this.isConnected()) {
            this.addInterest(8);
        }
    }

    @Override
    public void closeAfterWrite() {
        this.queue(new Runnable(){

            @Override
            public void run() {
                SocketChannelResponder.this.m_packetQueue.clear();
                SocketChannelResponder.this.close(null);
            }
        });
    }

    @Override
    public void queue(Runnable runnable) {
        this.m_packetQueue.offer(runnable);
        this.getNIOService().queue(new AddInterestEvent(4));
    }

    @Override
    public boolean write(byte[] byArray, Object object) {
        Object[] objectArray;
        long l = this.m_bytesInQueue.addAndGet(byArray.length);
        if (this.m_maxQueueSize > 0 && l > (long)this.m_maxQueueSize) {
            this.m_bytesInQueue.addAndGet(-byArray.length);
            return false;
        }
        if (object == null) {
            objectArray = byArray;
        } else {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = byArray;
            objectArray = objectArray2;
            objectArray2[1] = object;
        }
        this.m_packetQueue.offer(objectArray);
        this.getNIOService().queue(new AddInterestEvent(4));
        return true;
    }

    @Override
    public boolean write(byte[] byArray) {
        return this.write(byArray, null);
    }

    public boolean isConnected() {
        return this.getChannel().isConnected();
    }

    private void notifyPacketReceived(byte[] byArray) {
        try {
            if (this.m_socketObserver != null) {
                this.m_socketObserver.packetReceived(this, byArray);
            }
        }
        catch (Exception exception) {
            this.getNIOService().notifyException(exception);
        }
    }

    private void notifyPacketSent(Object object) {
        try {
            if (this.m_socketObserver != null) {
                this.m_socketObserver.packetSent(this, object);
            }
        }
        catch (Exception exception) {
            this.getNIOService().notifyException(exception);
        }
    }

    @Override
    public void socketReadyForRead() {
        if (!this.isOpen()) {
            return;
        }
        try {
            if (!this.isConnected()) {
                throw new IOException("Channel not connected.");
            }
            while (this.m_socketReader.read(this.getChannel()) > 0) {
                byte[] byArray;
                ByteBuffer byteBuffer = this.m_socketReader.getBuffer();
                while (byteBuffer.remaining() > 0 && (byArray = this.m_packetReader.nextPacket(byteBuffer)) != null) {
                    if (byArray == PacketReader.SKIP_PACKET) continue;
                    this.notifyPacketReceived(byArray);
                }
                this.m_socketReader.compact();
            }
        }
        catch (Exception exception) {
            this.close(exception);
        }
    }

    private void fillCurrentOutgoingBuffer() throws IOException {
        if (this.m_socketWriter.isEmpty()) {
            byte[] byArray;
            Object object = this.m_packetQueue.poll();
            while (object != null && object instanceof Runnable) {
                ((Runnable)object).run();
                object = this.m_packetQueue.poll();
            }
            if (object == null) {
                return;
            }
            Object object2 = null;
            if (object instanceof byte[]) {
                byArray = (byte[])object;
            } else {
                byArray = (byte[])((Object[])object)[0];
                object2 = ((Object[])object)[1];
            }
            this.m_socketWriter.setPacket(byArray, object2);
            this.m_bytesInQueue.addAndGet(-byArray.length);
        }
    }

    @Override
    public void socketReadyForWrite() {
        try {
            this.deleteInterest(4);
            if (!this.isOpen()) {
                return;
            }
            this.fillCurrentOutgoingBuffer();
            if (this.m_socketWriter.isEmpty()) {
                return;
            }
            while (!this.m_socketWriter.isEmpty()) {
                boolean bl = this.m_socketWriter.write(this.getChannel());
                if (!bl) {
                    this.addInterest(4);
                    return;
                }
                if (!this.m_socketWriter.isEmpty()) continue;
                this.notifyPacketSent(this.m_socketWriter.getTag());
                this.fillCurrentOutgoingBuffer();
            }
        }
        catch (Exception exception) {
            this.close(exception);
        }
    }

    @Override
    public void socketReadyForConnect() {
        try {
            if (!this.isOpen()) {
                return;
            }
            if (this.getChannel().finishConnect()) {
                this.deleteInterest(8);
                this.m_timeOpened = System.currentTimeMillis();
                this.notifyObserverOfConnect();
            }
        }
        catch (Exception exception) {
            this.close(exception);
        }
    }

    public void notifyWasCancelled() {
        this.close();
    }

    public Socket getSocket() {
        return this.getChannel().socket();
    }

    @Override
    public long getBytesRead() {
        return this.m_socketReader.getBytesRead();
    }

    @Override
    public long getBytesWritten() {
        return this.m_socketWriter.getBytesWritten();
    }

    @Override
    public long getTimeOpen() {
        return this.m_timeOpened > 0L ? System.currentTimeMillis() - this.m_timeOpened : -1L;
    }

    @Override
    public long getWriteQueueSize() {
        return this.m_bytesInQueue.get();
    }

    @Override
    public String toString() {
        try {
            return this.getSocket().toString();
        }
        catch (Exception exception) {
            return "Closed NIO Socket";
        }
    }

    @Override
    public int getMaxQueueSize() {
        return this.m_maxQueueSize;
    }

    @Override
    public void setMaxQueueSize(int n) {
        this.m_maxQueueSize = n;
    }

    @Override
    public void listen(SocketObserver socketObserver) {
        this.markObserverSet();
        this.getNIOService().queue(new BeginListenEvent(this, socketObserver == null ? SocketObserver.NULL : socketObserver));
    }

    private void notifyObserverOfConnect() {
        try {
            if (this.m_socketObserver != null) {
                this.m_socketObserver.connectionOpened(this);
            }
        }
        catch (Exception exception) {
            this.getNIOService().notifyException(exception);
        }
    }

    private void notifyObserverOfDisconnect(Exception exception) {
        try {
            if (this.m_socketObserver != null) {
                this.m_socketObserver.connectionBroken(this, exception);
            }
        }
        catch (Exception exception2) {
            this.getNIOService().notifyException(exception2);
        }
    }

    @Override
    public void setPacketReader(PacketReader packetReader) {
        this.m_packetReader = packetReader;
    }

    @Override
    public void setPacketWriter(final PacketWriter packetWriter) {
        if (packetWriter == null) {
            throw new NullPointerException();
        }
        this.queue(new Runnable(){

            @Override
            public void run() {
                SocketChannelResponder.this.m_socketWriter.setPacketWriter(packetWriter);
            }
        });
    }

    @Override
    public SocketChannel getChannel() {
        return (SocketChannel)super.getChannel();
    }

    @Override
    protected void shutdown(Exception exception) {
        this.m_timeOpened = -1L;
        this.m_packetQueue.clear();
        this.m_bytesInQueue.set(0L);
        this.notifyObserverOfDisconnect(exception);
    }

    @Override
    public Socket socket() {
        return this.getChannel().socket();
    }

    private class BeginListenEvent
    implements Runnable {
        private final SocketObserver m_newObserver;
        private final SocketChannelResponder m_responder;

        private BeginListenEvent(SocketChannelResponder socketChannelResponder2, SocketObserver socketObserver) {
            this.m_responder = socketChannelResponder2;
            this.m_newObserver = socketObserver;
        }

        @Override
        public void run() {
            this.m_responder.m_socketObserver = this.m_newObserver;
            if (this.m_responder.isConnected()) {
                this.m_responder.notifyObserverOfConnect();
            }
            if (!this.m_responder.isOpen()) {
                this.m_responder.notifyObserverOfDisconnect(null);
            }
            this.m_responder.addInterest(1);
        }

        public String toString() {
            return "BeginListen[" + this.m_newObserver + "]";
        }
    }

    private class AddInterestEvent
    implements Runnable {
        private final int m_interest;

        private AddInterestEvent(int n) {
            this.m_interest = n;
        }

        @Override
        public void run() {
            SocketChannelResponder.this.addInterest(this.m_interest);
        }
    }
}

