"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.composeAggregations = void 0;

var _explorer = require("../../../common/constants/explorer");

var _utils = require("../../../common/utils");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const composeAggregations = (aggConfig, staleStats) => {
  var _staleStats$partition, _staleStats$all_num, _staleStats$delim, _staleStats$dedup_spl;

  return {
    aggregations: aggConfig.series.map(metric => ({
      function_alias: metric[_explorer.CUSTOM_LABEL],
      function: {
        name: metric.aggregation,
        value_expression: metric.name,
        percentile_agg_function: ''
      }
    })),
    groupby: {
      group_fields: [...(aggConfig.dimensions || []), ...(aggConfig.breakdowns || [])].map(dimension => ({
        name: `\`${(0, _utils.removeBacktick)(dimension.name)}\``
      })),
      ...(aggConfig.span && JSON.stringify(aggConfig === null || aggConfig === void 0 ? void 0 : aggConfig.span) !== '{}' && {
        span: composeSpan(aggConfig.span)
      })
    },
    partitions: (_staleStats$partition = staleStats === null || staleStats === void 0 ? void 0 : staleStats.partitions) !== null && _staleStats$partition !== void 0 ? _staleStats$partition : {},
    all_num: (_staleStats$all_num = staleStats === null || staleStats === void 0 ? void 0 : staleStats.all_num) !== null && _staleStats$all_num !== void 0 ? _staleStats$all_num : {},
    delim: (_staleStats$delim = staleStats === null || staleStats === void 0 ? void 0 : staleStats.delim) !== null && _staleStats$delim !== void 0 ? _staleStats$delim : {},
    dedup_split_value: (_staleStats$dedup_spl = staleStats === null || staleStats === void 0 ? void 0 : staleStats.dedup_split_value) !== null && _staleStats$dedup_spl !== void 0 ? _staleStats$dedup_spl : {}
  };
};

exports.composeAggregations = composeAggregations;

const composeSpan = spanConfig => {
  var _spanConfig$CUSTOM_LA, _spanConfig$time_fiel, _spanConfig$time_fiel2, _spanConfig$time_fiel3, _spanConfig$time_fiel4, _spanConfig$unit$0$va, _spanConfig$unit$, _spanConfig$interval;

  return {
    [_explorer.CUSTOM_LABEL]: (_spanConfig$CUSTOM_LA = spanConfig[_explorer.CUSTOM_LABEL]) !== null && _spanConfig$CUSTOM_LA !== void 0 ? _spanConfig$CUSTOM_LA : '',
    span_expression: {
      type: (_spanConfig$time_fiel = (_spanConfig$time_fiel2 = spanConfig.time_field[0]) === null || _spanConfig$time_fiel2 === void 0 ? void 0 : _spanConfig$time_fiel2.type) !== null && _spanConfig$time_fiel !== void 0 ? _spanConfig$time_fiel : 'timestamp',
      field: (_spanConfig$time_fiel3 = (_spanConfig$time_fiel4 = spanConfig.time_field[0]) === null || _spanConfig$time_fiel4 === void 0 ? void 0 : _spanConfig$time_fiel4.name) !== null && _spanConfig$time_fiel3 !== void 0 ? _spanConfig$time_fiel3 : 'timestamp',
      time_unit: (_spanConfig$unit$0$va = (_spanConfig$unit$ = spanConfig.unit[0]) === null || _spanConfig$unit$ === void 0 ? void 0 : _spanConfig$unit$.value) !== null && _spanConfig$unit$0$va !== void 0 ? _spanConfig$unit$0$va : 'd',
      literal_value: (_spanConfig$interval = spanConfig.interval) !== null && _spanConfig$interval !== void 0 ? _spanConfig$interval : 1
    }
  };
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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