/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.datetime;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprDatetimeValue;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.datetime.CalendarLookup;
import org.opensearch.sql.expression.datetime.DateTimeFormatterUtil;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.DefaultFunctionResolver;
import org.opensearch.sql.expression.function.FunctionDSL;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.utils.DateTimeFormatters;
import org.opensearch.sql.utils.DateTimeUtils;

public final class DateTimeFunction {
    private static final Long DAYS_0000_TO_1970 = 719528L;
    private static final Double MYSQL_MAX_TIMESTAMP = 3.25367712E10;

    public static void register(BuiltinFunctionRepository repository) {
        repository.register(DateTimeFunction.adddate());
        repository.register(DateTimeFunction.convert_tz());
        repository.register(DateTimeFunction.curtime());
        repository.register(DateTimeFunction.curdate());
        repository.register(DateTimeFunction.current_date());
        repository.register(DateTimeFunction.current_time());
        repository.register(DateTimeFunction.current_timestamp());
        repository.register(DateTimeFunction.date());
        repository.register(DateTimeFunction.datetime());
        repository.register(DateTimeFunction.date_add());
        repository.register(DateTimeFunction.date_sub());
        repository.register(DateTimeFunction.day());
        repository.register(DateTimeFunction.dayName());
        repository.register(DateTimeFunction.dayOfMonth());
        repository.register(DateTimeFunction.dayOfWeek());
        repository.register(DateTimeFunction.dayOfYear());
        repository.register(DateTimeFunction.from_days());
        repository.register(DateTimeFunction.from_unixtime());
        repository.register(DateTimeFunction.hour());
        repository.register(DateTimeFunction.localtime());
        repository.register(DateTimeFunction.localtimestamp());
        repository.register(DateTimeFunction.makedate());
        repository.register(DateTimeFunction.maketime());
        repository.register(DateTimeFunction.microsecond());
        repository.register(DateTimeFunction.minute());
        repository.register(DateTimeFunction.month());
        repository.register(DateTimeFunction.monthName());
        repository.register(DateTimeFunction.now());
        repository.register(DateTimeFunction.period_add());
        repository.register(DateTimeFunction.period_diff());
        repository.register(DateTimeFunction.quarter());
        repository.register(DateTimeFunction.second());
        repository.register(DateTimeFunction.subdate());
        repository.register(DateTimeFunction.sysdate());
        repository.register(DateTimeFunction.time());
        repository.register(DateTimeFunction.time_to_sec());
        repository.register(DateTimeFunction.timestamp());
        repository.register(DateTimeFunction.date_format());
        repository.register(DateTimeFunction.to_days());
        repository.register(DateTimeFunction.unix_timestamp());
        repository.register(DateTimeFunction.week());
        repository.register(DateTimeFunction.year());
    }

    private static DefaultFunctionResolver add_date(FunctionName functionName) {
        return FunctionDSL.define(functionName, FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprAddDateInterval), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.INTERVAL), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprAddDateInterval), ExprCoreType.DATETIME, ExprCoreType.DATE, ExprCoreType.INTERVAL), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprAddDateInterval), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.INTERVAL), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprAddDateInterval), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.INTERVAL), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprAddDateDays), ExprCoreType.DATE, ExprCoreType.DATE, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprAddDateDays), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprAddDateDays), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprAddDateDays), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.LONG));
    }

    private static DefaultFunctionResolver adddate() {
        return DateTimeFunction.add_date(BuiltinFunctionName.ADDDATE.getName());
    }

    private static DefaultFunctionResolver convert_tz() {
        return FunctionDSL.define(BuiltinFunctionName.CONVERT_TZ.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprConvertTZ), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprConvertTZ), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver curdate(FunctionName functionName) {
        return FunctionDSL.define(functionName, FunctionDSL.impl(() -> new ExprDateValue(DateTimeFunction.formatNow(null).toLocalDate()), ExprCoreType.DATE));
    }

    private static DefaultFunctionResolver curdate() {
        return DateTimeFunction.curdate(BuiltinFunctionName.CURDATE.getName());
    }

    private static DefaultFunctionResolver curtime(FunctionName functionName) {
        return FunctionDSL.define(functionName, FunctionDSL.impl(() -> new ExprTimeValue(DateTimeFunction.formatNow(null).toLocalTime()), ExprCoreType.TIME));
    }

    private static DefaultFunctionResolver curtime() {
        return DateTimeFunction.curtime(BuiltinFunctionName.CURTIME.getName());
    }

    private static DefaultFunctionResolver current_date() {
        return DateTimeFunction.curdate(BuiltinFunctionName.CURRENT_DATE.getName());
    }

    private static DefaultFunctionResolver current_time() {
        return DateTimeFunction.curtime(BuiltinFunctionName.CURRENT_TIME.getName());
    }

    private static DefaultFunctionResolver current_timestamp() {
        return DateTimeFunction.now(BuiltinFunctionName.CURRENT_TIMESTAMP.getName());
    }

    private static DefaultFunctionResolver date() {
        return FunctionDSL.define(BuiltinFunctionName.DATE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDate), ExprCoreType.DATE, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDate), ExprCoreType.DATE, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDate), ExprCoreType.DATE, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDate), ExprCoreType.DATE, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver datetime() {
        return FunctionDSL.define(BuiltinFunctionName.DATETIME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDateTime), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDateTimeNoTimezone), ExprCoreType.DATETIME, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver date_add() {
        return DateTimeFunction.add_date(BuiltinFunctionName.DATE_ADD.getName());
    }

    private static DefaultFunctionResolver sub_date(FunctionName functionName) {
        return FunctionDSL.define(functionName, FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSubDateInterval), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.INTERVAL), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSubDateInterval), ExprCoreType.DATETIME, ExprCoreType.DATE, ExprCoreType.INTERVAL), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSubDateInterval), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.INTERVAL), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSubDateInterval), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.INTERVAL), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSubDateDays), ExprCoreType.DATE, ExprCoreType.DATE, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSubDateDays), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSubDateDays), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSubDateDays), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.LONG));
    }

    private static DefaultFunctionResolver date_sub() {
        return DateTimeFunction.sub_date(BuiltinFunctionName.DATE_SUB.getName());
    }

    private static DefaultFunctionResolver day() {
        return FunctionDSL.define(BuiltinFunctionName.DAY.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver dayName() {
        return FunctionDSL.define(BuiltinFunctionName.DAYNAME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayName), ExprCoreType.STRING, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayName), ExprCoreType.STRING, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayName), ExprCoreType.STRING, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayName), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver dayOfMonth() {
        return FunctionDSL.define(BuiltinFunctionName.DAYOFMONTH.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver dayOfWeek() {
        return FunctionDSL.define(BuiltinFunctionName.DAYOFWEEK.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfWeek), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfWeek), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfWeek), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfWeek), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver dayOfYear() {
        return FunctionDSL.define(BuiltinFunctionName.DAYOFYEAR.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfYear), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfYear), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfYear), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfYear), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver from_days() {
        return FunctionDSL.define(BuiltinFunctionName.FROM_DAYS.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprFromDays), ExprCoreType.DATE, ExprCoreType.LONG));
    }

    private static DefaultFunctionResolver from_unixtime() {
        return FunctionDSL.define(BuiltinFunctionName.FROM_UNIXTIME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprFromUnixTime), ExprCoreType.DATETIME, ExprCoreType.DOUBLE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprFromUnixTimeFormat), ExprCoreType.STRING, ExprCoreType.DOUBLE, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver hour() {
        return FunctionDSL.define(BuiltinFunctionName.HOUR.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprHour), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprHour), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprHour), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprHour), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver localtime() {
        return DateTimeFunction.now(BuiltinFunctionName.LOCALTIME.getName());
    }

    private static DefaultFunctionResolver localtimestamp() {
        return DateTimeFunction.now(BuiltinFunctionName.LOCALTIMESTAMP.getName());
    }

    private static DefaultFunctionResolver now(FunctionName functionName) {
        return FunctionDSL.define(functionName, FunctionDSL.impl(() -> new ExprDatetimeValue(DateTimeFunction.formatNow(null)), ExprCoreType.DATETIME));
    }

    private static DefaultFunctionResolver now() {
        return DateTimeFunction.now(BuiltinFunctionName.NOW.getName());
    }

    private static DefaultFunctionResolver makedate() {
        return FunctionDSL.define(BuiltinFunctionName.MAKEDATE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMakeDate), ExprCoreType.DATE, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver maketime() {
        return FunctionDSL.define(BuiltinFunctionName.MAKETIME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMakeTime), ExprCoreType.TIME, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver microsecond() {
        return FunctionDSL.define(BuiltinFunctionName.MICROSECOND.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMicrosecond), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMicrosecond), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMicrosecond), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMicrosecond), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver minute() {
        return FunctionDSL.define(BuiltinFunctionName.MINUTE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinute), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinute), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinute), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinute), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver month() {
        return FunctionDSL.define(BuiltinFunctionName.MONTH.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonth), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonth), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonth), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonth), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver monthName() {
        return FunctionDSL.define(BuiltinFunctionName.MONTHNAME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonthName), ExprCoreType.STRING, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonthName), ExprCoreType.STRING, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonthName), ExprCoreType.STRING, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonthName), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver period_add() {
        return FunctionDSL.define(BuiltinFunctionName.PERIOD_ADD.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprPeriodAdd), ExprCoreType.INTEGER, ExprCoreType.INTEGER, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver period_diff() {
        return FunctionDSL.define(BuiltinFunctionName.PERIOD_DIFF.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprPeriodDiff), ExprCoreType.INTEGER, ExprCoreType.INTEGER, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver quarter() {
        return FunctionDSL.define(BuiltinFunctionName.QUARTER.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprQuarter), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprQuarter), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprQuarter), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprQuarter), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver second() {
        return FunctionDSL.define(BuiltinFunctionName.SECOND.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecond), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecond), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecond), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecond), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver subdate() {
        return DateTimeFunction.sub_date(BuiltinFunctionName.SUBDATE.getName());
    }

    private static DefaultFunctionResolver time() {
        return FunctionDSL.define(BuiltinFunctionName.TIME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTime), ExprCoreType.TIME, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTime), ExprCoreType.TIME, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTime), ExprCoreType.TIME, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTime), ExprCoreType.TIME, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTime), ExprCoreType.TIME, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver time_to_sec() {
        return FunctionDSL.define(BuiltinFunctionName.TIME_TO_SEC.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimeToSec), ExprCoreType.LONG, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimeToSec), ExprCoreType.LONG, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimeToSec), ExprCoreType.LONG, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimeToSec), ExprCoreType.LONG, ExprCoreType.DATETIME));
    }

    private static DefaultFunctionResolver timestamp() {
        return FunctionDSL.define(BuiltinFunctionName.TIMESTAMP.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimestamp), ExprCoreType.TIMESTAMP, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimestamp), ExprCoreType.TIMESTAMP, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimestamp), ExprCoreType.TIMESTAMP, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimestamp), ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver to_days() {
        return FunctionDSL.define(BuiltinFunctionName.TO_DAYS.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprToDays), ExprCoreType.LONG, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprToDays), ExprCoreType.LONG, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprToDays), ExprCoreType.LONG, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprToDays), ExprCoreType.LONG, ExprCoreType.DATETIME));
    }

    private static DefaultFunctionResolver unix_timestamp() {
        return FunctionDSL.define(BuiltinFunctionName.UNIX_TIMESTAMP.getName(), FunctionDSL.impl(DateTimeFunction::unixTimeStamp, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::unixTimeStampOf), ExprCoreType.DOUBLE, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::unixTimeStampOf), ExprCoreType.DOUBLE, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::unixTimeStampOf), ExprCoreType.DOUBLE, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::unixTimeStampOf), ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver week() {
        return FunctionDSL.define(BuiltinFunctionName.WEEK.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeek), ExprCoreType.INTEGER, ExprCoreType.DATE, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeek), ExprCoreType.INTEGER, ExprCoreType.DATETIME, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeek), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeek), ExprCoreType.INTEGER, ExprCoreType.STRING, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver year() {
        return FunctionDSL.define(BuiltinFunctionName.YEAR.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYear), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYear), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYear), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYear), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver date_format() {
        return FunctionDSL.define(BuiltinFunctionName.DATE_FORMAT.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedDate), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedDate), ExprCoreType.STRING, ExprCoreType.DATE, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedDate), ExprCoreType.STRING, ExprCoreType.DATETIME, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedDate), ExprCoreType.STRING, ExprCoreType.TIMESTAMP, ExprCoreType.STRING));
    }

    private static ExprValue exprAddDateInterval(ExprValue date, ExprValue expr) {
        ExprDatetimeValue exprValue = new ExprDatetimeValue(date.datetimeValue().plus(expr.intervalValue()));
        return exprValue.timeValue().toSecondOfDay() == 0 ? new ExprDateValue(exprValue.dateValue()) : exprValue;
    }

    private static ExprValue exprAddDateDays(ExprValue date, ExprValue days) {
        ExprDatetimeValue exprValue = new ExprDatetimeValue(date.datetimeValue().plusDays(days.longValue()));
        return exprValue.timeValue().toSecondOfDay() == 0 ? new ExprDateValue(exprValue.dateValue()) : exprValue;
    }

    private static ExprValue exprConvertTZ(ExprValue startingDateTime, ExprValue fromTz, ExprValue toTz) {
        if (startingDateTime.type() == ExprCoreType.STRING) {
            startingDateTime = DateTimeFunction.exprDateTimeNoTimezone(startingDateTime);
        }
        try {
            ZoneId convertedFromTz = ZoneId.of(fromTz.stringValue());
            ZoneId convertedToTz = ZoneId.of(toTz.stringValue());
            if (!DateTimeUtils.isValidMySqlTimeZoneId(convertedFromTz).booleanValue() || !DateTimeUtils.isValidMySqlTimeZoneId(convertedToTz).booleanValue()) {
                return ExprNullValue.of();
            }
            ZonedDateTime zonedDateTime = startingDateTime.datetimeValue().atZone(convertedFromTz);
            return new ExprDatetimeValue(zonedDateTime.withZoneSameInstant(convertedToTz).toLocalDateTime());
        }
        catch (DateTimeException | ExpressionEvaluationException e) {
            return ExprNullValue.of();
        }
    }

    private static ExprValue exprDate(ExprValue exprValue) {
        if (exprValue instanceof ExprStringValue) {
            return new ExprDateValue(exprValue.stringValue());
        }
        return new ExprDateValue(exprValue.dateValue());
    }

    private static ExprValue exprDateTime(ExprValue dateTime, ExprValue timeZone) {
        String toTz;
        ExprDatetimeValue ldt;
        String defaultTimeZone = TimeZone.getDefault().getID();
        try {
            LocalDateTime ldtFormatted = LocalDateTime.parse(dateTime.stringValue(), DateTimeFormatters.DATE_TIME_FORMATTER_STRICT_WITH_TZ);
            if (timeZone.isNull()) {
                return new ExprDatetimeValue(ldtFormatted);
            }
        }
        catch (DateTimeParseException e) {
            return ExprNullValue.of();
        }
        try {
            ZonedDateTime zdtWithZoneOffset = ZonedDateTime.parse(dateTime.stringValue(), DateTimeFormatters.DATE_TIME_FORMATTER_STRICT_WITH_TZ);
            ZoneId fromTZ = zdtWithZoneOffset.getZone();
            ldt = new ExprDatetimeValue(zdtWithZoneOffset.toLocalDateTime());
            toTz = String.valueOf(fromTZ);
        }
        catch (DateTimeParseException e) {
            ldt = new ExprDatetimeValue(dateTime.stringValue());
            toTz = defaultTimeZone;
        }
        ExprValue convertTZResult = DateTimeFunction.exprConvertTZ(ldt, new ExprStringValue(toTz), timeZone);
        return convertTZResult;
    }

    private static ExprValue exprDateTimeNoTimezone(ExprValue dateTime) {
        return DateTimeFunction.exprDateTime(dateTime, ExprNullValue.of());
    }

    private static ExprValue exprDayName(ExprValue date) {
        return new ExprStringValue(date.dateValue().getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.getDefault()));
    }

    private static ExprValue exprDayOfMonth(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getDayOfMonth());
    }

    private static ExprValue exprDayOfWeek(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getDayOfWeek().getValue() % 7 + 1);
    }

    private static ExprValue exprDayOfYear(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getDayOfYear());
    }

    private static ExprValue exprFromDays(ExprValue exprValue) {
        return new ExprDateValue(LocalDate.ofEpochDay(exprValue.longValue() - DAYS_0000_TO_1970));
    }

    private static ExprValue exprFromUnixTime(ExprValue time) {
        if (0.0 > time.doubleValue()) {
            return ExprNullValue.of();
        }
        if (MYSQL_MAX_TIMESTAMP <= time.doubleValue()) {
            return ExprNullValue.of();
        }
        return new ExprDatetimeValue(DateTimeFunction.exprFromUnixTimeImpl(time));
    }

    private static LocalDateTime exprFromUnixTimeImpl(ExprValue time) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond((long)Math.floor(time.doubleValue())), ZoneId.of("UTC")).withNano((int)(time.doubleValue() % 1.0 * 1.0E9));
    }

    private static ExprValue exprFromUnixTimeFormat(ExprValue time, ExprValue format) {
        ExprValue value = DateTimeFunction.exprFromUnixTime(time);
        if (value.equals(ExprNullValue.of())) {
            return ExprNullValue.of();
        }
        return DateTimeFormatterUtil.getFormattedDate(value, format);
    }

    private static ExprValue exprHour(ExprValue time) {
        return new ExprIntegerValue(time.timeValue().getHour());
    }

    private static ExprValue exprMakeDate(ExprValue yearExpr, ExprValue dayOfYearExp) {
        long year = Math.round(yearExpr.doubleValue());
        long dayOfYear = Math.round(dayOfYearExp.doubleValue());
        if (0L >= dayOfYear || 0L > year) {
            return ExprNullValue.of();
        }
        if (0L == year) {
            year = 2000L;
        }
        return new ExprDateValue(LocalDate.ofYearDay((int)year, 1).plusDays(dayOfYear - 1L));
    }

    private static ExprValue exprMakeTime(ExprValue hourExpr, ExprValue minuteExpr, ExprValue secondExpr) {
        long hour = Math.round(hourExpr.doubleValue());
        long minute = Math.round(minuteExpr.doubleValue());
        Double second = secondExpr.doubleValue();
        if (0L > hour || 0L > minute || 0.0 > second) {
            return ExprNullValue.of();
        }
        return new ExprTimeValue(LocalTime.parse(String.format("%02d:%02d:%012.9f", hour, minute, second), DateTimeFormatter.ISO_TIME));
    }

    private static ExprValue exprMicrosecond(ExprValue time) {
        return new ExprIntegerValue(TimeUnit.MICROSECONDS.convert(time.timeValue().getNano(), TimeUnit.NANOSECONDS));
    }

    private static ExprValue exprMinute(ExprValue time) {
        return new ExprIntegerValue(time.timeValue().getMinute());
    }

    private static ExprValue exprMonth(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getMonthValue());
    }

    private static ExprValue exprMonthName(ExprValue date) {
        return new ExprStringValue(date.dateValue().getMonth().getDisplayName(TextStyle.FULL, Locale.getDefault()));
    }

    private static LocalDate parseDatePeriod(Integer period) {
        String input = period.toString();
        if (input.length() <= 5) {
            input = String.format("200%05d", period);
        }
        try {
            return LocalDate.parse(input, DateTimeFormatters.DATE_FORMATTER_SHORT_YEAR);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return LocalDate.parse(input, DateTimeFormatters.DATE_FORMATTER_LONG_YEAR);
            }
            catch (DateTimeParseException ignored) {
                return null;
            }
        }
    }

    private static ExprValue exprPeriodAdd(ExprValue period, ExprValue months) {
        int input = period.integerValue() * 100 + 1;
        LocalDate parsedDate = DateTimeFunction.parseDatePeriod(input);
        if (parsedDate == null) {
            return ExprNullValue.of();
        }
        String res = DateTimeFormatters.DATE_FORMATTER_LONG_YEAR.format(parsedDate.plusMonths(months.integerValue().intValue()));
        return new ExprIntegerValue(Integer.parseInt(res.substring(0, res.length() - 2)));
    }

    private static ExprValue exprPeriodDiff(ExprValue period1, ExprValue period2) {
        LocalDate parsedDate1 = DateTimeFunction.parseDatePeriod(period1.integerValue() * 100 + 1);
        LocalDate parsedDate2 = DateTimeFunction.parseDatePeriod(period2.integerValue() * 100 + 1);
        if (parsedDate1 == null || parsedDate2 == null) {
            return ExprNullValue.of();
        }
        return new ExprIntegerValue(ChronoUnit.MONTHS.between(parsedDate2, parsedDate1));
    }

    private static ExprValue exprQuarter(ExprValue date) {
        int month = date.dateValue().getMonthValue();
        return new ExprIntegerValue(month / 3 + (month % 3 == 0 ? 0 : 1));
    }

    private static ExprValue exprSecond(ExprValue time) {
        return new ExprIntegerValue(time.timeValue().getSecond());
    }

    private static ExprValue exprSubDateDays(ExprValue date, ExprValue days) {
        ExprDatetimeValue exprValue = new ExprDatetimeValue(date.datetimeValue().minusDays(days.longValue()));
        return exprValue.timeValue().toSecondOfDay() == 0 ? new ExprDateValue(exprValue.dateValue()) : exprValue;
    }

    private static ExprValue exprSubDateInterval(ExprValue date, ExprValue expr) {
        ExprDatetimeValue exprValue = new ExprDatetimeValue(date.datetimeValue().minus(expr.intervalValue()));
        return exprValue.timeValue().toSecondOfDay() == 0 ? new ExprDateValue(exprValue.dateValue()) : exprValue;
    }

    private static DefaultFunctionResolver sysdate() {
        return FunctionDSL.define(BuiltinFunctionName.SYSDATE.getName(), FunctionDSL.impl(() -> new ExprDatetimeValue(DateTimeFunction.formatNow(null)), ExprCoreType.DATETIME), FunctionDSL.impl(v -> new ExprDatetimeValue(DateTimeFunction.formatNow(v.integerValue())), ExprCoreType.DATETIME, ExprCoreType.INTEGER));
    }

    private static ExprValue exprTime(ExprValue exprValue) {
        if (exprValue instanceof ExprStringValue) {
            return new ExprTimeValue(exprValue.stringValue());
        }
        return new ExprTimeValue(exprValue.timeValue());
    }

    private static ExprValue exprTimestamp(ExprValue exprValue) {
        if (exprValue instanceof ExprStringValue) {
            return new ExprTimestampValue(exprValue.stringValue());
        }
        return new ExprTimestampValue(exprValue.timestampValue());
    }

    private static ExprValue exprTimeToSec(ExprValue time) {
        return new ExprLongValue(time.timeValue().toSecondOfDay());
    }

    private static ExprValue exprToDays(ExprValue date) {
        return new ExprLongValue(date.dateValue().toEpochDay() + DAYS_0000_TO_1970);
    }

    private static ExprValue exprWeek(ExprValue date, ExprValue mode) {
        return new ExprIntegerValue(CalendarLookup.getWeekNumber(mode.integerValue(), date.dateValue()));
    }

    private static ExprValue unixTimeStamp() {
        return new ExprLongValue(Instant.now().getEpochSecond());
    }

    private static ExprValue unixTimeStampOf(ExprValue value) {
        Double res = DateTimeFunction.unixTimeStampOfImpl(value);
        if (res == null) {
            return ExprNullValue.of();
        }
        if (res < 0.0) {
            return new ExprDoubleValue(0);
        }
        if (res >= MYSQL_MAX_TIMESTAMP) {
            return new ExprDoubleValue(0);
        }
        return new ExprDoubleValue(res);
    }

    private static Double unixTimeStampOfImpl(ExprValue value) {
        switch ((ExprCoreType)value.type()) {
            case DATE: {
                return (double)value.dateValue().toEpochSecond(LocalTime.MIN, ZoneOffset.UTC) + 0.0;
            }
            case DATETIME: {
                return (double)value.datetimeValue().toEpochSecond(ZoneOffset.UTC) + (double)value.datetimeValue().getNano() / 1.0E9;
            }
            case TIMESTAMP: {
                return (double)value.timestampValue().getEpochSecond() + (double)value.timestampValue().getNano() / 1.0E9;
            }
        }
        DecimalFormat format = new DecimalFormat("0.#");
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(6);
        String input = format.format(value.doubleValue());
        double fraction = 0.0;
        if (input.contains(".")) {
            fraction = value.doubleValue() - (double)Math.round(Math.ceil(value.doubleValue()));
            input = input.substring(0, input.indexOf(46));
        }
        try {
            LocalDateTime res = LocalDateTime.parse(input, DateTimeFormatters.DATE_TIME_FORMATTER_SHORT_YEAR);
            return (double)res.toEpochSecond(ZoneOffset.UTC) + fraction;
        }
        catch (DateTimeParseException res) {
            try {
                LocalDateTime res2 = LocalDateTime.parse(input, DateTimeFormatters.DATE_TIME_FORMATTER_LONG_YEAR);
                return (double)res2.toEpochSecond(ZoneOffset.UTC) + fraction;
            }
            catch (DateTimeParseException res2) {
                try {
                    LocalDate res3 = LocalDate.parse(input, DateTimeFormatters.DATE_FORMATTER_SHORT_YEAR);
                    return (double)res3.toEpochSecond(LocalTime.MIN, ZoneOffset.UTC) + 0.0;
                }
                catch (DateTimeParseException res3) {
                    try {
                        LocalDate res4 = LocalDate.parse(input, DateTimeFormatters.DATE_FORMATTER_LONG_YEAR);
                        return (double)res4.toEpochSecond(LocalTime.MIN, ZoneOffset.UTC) + 0.0;
                    }
                    catch (DateTimeParseException ignored) {
                        return null;
                    }
                }
            }
        }
    }

    private static ExprValue exprWeekWithoutMode(ExprValue date) {
        return DateTimeFunction.exprWeek(date, new ExprIntegerValue(0));
    }

    private static ExprValue exprYear(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getYear());
    }

    private static LocalDateTime formatNow(@Nullable Integer fsp) {
        LocalDateTime res = LocalDateTime.now();
        if (fsp == null) {
            fsp = 0;
        }
        int defaultPrecision = 9;
        if (fsp < 0 || fsp > 6) {
            throw new IllegalArgumentException(String.format("Invalid `fsp` value: %d, allowed 0 to 6", fsp));
        }
        int nano = new BigDecimal(res.getNano()).setScale(fsp - defaultPrecision, RoundingMode.DOWN).intValue();
        return res.withNano(nano);
    }

    @Generated
    private DateTimeFunction() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

