/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.optimizer;

import com.facebook.presto.matching.DefaultMatcher;
import com.facebook.presto.matching.Match;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.sql.expression.DSL;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.optimizer.Rule;
import org.opensearch.sql.planner.optimizer.rule.MergeFilterAndFilter;
import org.opensearch.sql.planner.optimizer.rule.PushFilterUnderSort;

public class LogicalPlanOptimizer {
    private final List<Rule<?>> rules;

    public LogicalPlanOptimizer(List<Rule<?>> rules) {
        this.rules = rules;
    }

    public static LogicalPlanOptimizer create(DSL dsl) {
        return new LogicalPlanOptimizer(Arrays.asList(new MergeFilterAndFilter(dsl), new PushFilterUnderSort()));
    }

    public LogicalPlan optimize(LogicalPlan plan) {
        LogicalPlan optimized = this.internalOptimize(plan);
        optimized.replaceChildPlans(optimized.getChild().stream().map(this::optimize).collect(Collectors.toList()));
        return this.internalOptimize(optimized);
    }

    private LogicalPlan internalOptimize(LogicalPlan plan) {
        LogicalPlan node = plan;
        boolean done = false;
        while (!done) {
            done = true;
            for (Rule<?> rule : this.rules) {
                Match match = DefaultMatcher.DEFAULT_MATCHER.match(rule.pattern(), (Object)node);
                if (!match.isPresent()) continue;
                node = rule.apply(match.value(), match.captures());
                done = false;
            }
        }
        return node;
    }
}

