/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.executor;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.executor.Explain;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.executor.protector.ExecutionProtector;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.storage.TableScanOperator;

public class OpenSearchExecutionEngine
implements ExecutionEngine {
    private final OpenSearchClient client;
    private final ExecutionProtector executionProtector;

    public void execute(PhysicalPlan physicalPlan, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        PhysicalPlan plan = this.executionProtector.protect(physicalPlan);
        this.client.schedule(() -> {
            try {
                ArrayList<ExprValue> result = new ArrayList<ExprValue>();
                plan.open();
                while (plan.hasNext()) {
                    result.add((ExprValue)plan.next());
                }
                ExecutionEngine.QueryResponse response = new ExecutionEngine.QueryResponse(physicalPlan.schema(), result);
                listener.onResponse((Object)response);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
            finally {
                plan.close();
            }
        });
    }

    public void explain(PhysicalPlan plan, ResponseListener<ExecutionEngine.ExplainResponse> listener) {
        this.client.schedule(() -> {
            try {
                Explain openSearchExplain = new Explain(){

                    public ExecutionEngine.ExplainResponseNode visitTableScan(TableScanOperator node, Object context) {
                        return this.explain((PhysicalPlan)node, context, explainNode -> explainNode.setDescription((Map)ImmutableMap.of((Object)"request", (Object)node.explain())));
                    }
                };
                listener.onResponse((Object)openSearchExplain.apply(plan));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        });
    }

    @Generated
    public OpenSearchExecutionEngine(OpenSearchClient client, ExecutionProtector executionProtector) {
        this.client = client;
        this.executionProtector = executionProtector;
    }
}

