/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.executor;

import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.ThreadContext;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.threadpool.ThreadPool;

public final class Scheduler {
    public static final String SQL_WORKER_THREAD_POOL_NAME = "sql-worker";

    public static void schedule(NodeClient client, Runnable task) {
        ThreadPool threadPool = client.threadPool();
        threadPool.schedule(Scheduler.withCurrentContext(task), new TimeValue(0L), SQL_WORKER_THREAD_POOL_NAME);
    }

    private static Runnable withCurrentContext(Runnable task) {
        Map currentContext = ThreadContext.getImmutableContext();
        return () -> {
            ThreadContext.putAll((Map)currentContext);
            task.run();
        };
    }

    @Generated
    private Scheduler() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

